/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.basedata.FADepreciationPolicyFactory;
import com.kingdee.eas.fi.fa.basedata.FADepreciationPolicyInfo;
import com.kingdee.eas.fi.fa.basedata.FaCatInfo;
import com.kingdee.eas.fi.fa.def.FaDefPropertyValueInfo;
import com.kingdee.eas.fi.fa.manage.FaBakCardFactory;
import com.kingdee.eas.fi.fa.manage.FaBakCardInfo;
import com.kingdee.eas.fi.fa.manage.FaBillOriginEnum;
import com.kingdee.eas.fi.fa.manage.FaBillTypeEnum;
import com.kingdee.eas.fi.fa.manage.FaBizCardFactory;
import com.kingdee.eas.fi.fa.manage.FaBizCardInfo;
import com.kingdee.eas.fi.fa.manage.FaBizStatusEnum;
import com.kingdee.eas.fi.fa.manage.FaCardException;
import com.kingdee.eas.fi.fa.manage.FaChangeBillCollection;
import com.kingdee.eas.fi.fa.manage.FaChangeBillEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaChangeBillFactory;
import com.kingdee.eas.fi.fa.manage.FaChangeBillInfo;
import com.kingdee.eas.fi.fa.manage.FaChangeStatusEnmu;
import com.kingdee.eas.fi.fa.manage.FaCurCardCollection;
import com.kingdee.eas.fi.fa.manage.FaCurCardFactory;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.fi.fa.manage.FaDecValueEntryCollection;
import com.kingdee.eas.fi.fa.manage.FaDecValueEntryFactory;
import com.kingdee.eas.fi.fa.manage.FaDecValueEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaDecValueFactory;
import com.kingdee.eas.fi.fa.manage.FaDecValueInfo;
import com.kingdee.eas.fi.fa.manage.FaManageUtils;
import com.kingdee.eas.fi.fa.manage.IFaBakCard;
import com.kingdee.eas.fi.fa.manage.IFaChangeBill;
import com.kingdee.eas.fi.fa.manage.IFaCurCard;
import com.kingdee.eas.fi.fa.manage.IFaDecValueEntry;
import com.kingdee.eas.fi.fa.manage.app.AbstractPrcFaManageStrategy;
import com.kingdee.eas.fi.fa.manage.app.FaCardDefPropertyPersist;
import com.kingdee.eas.fi.fa.manage.app.FaDepLocalUtils;
import com.kingdee.eas.fi.fa.manage.app.FaLocalUtils;
import com.kingdee.eas.fi.fa.manage.app.PrcFaChangeStrategy;
import com.kingdee.eas.fi.fa.manage.app.PrcFaCoreManager;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.BlockedStatusEnum;
import com.kingdee.eas.framework.CheckedStatusEnum;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.framework.EffectedStatusEnum;
import com.kingdee.eas.framework.bireport.bimanager.ws.engine.util.UUIDUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;

public class PrcDecValueStrategy
extends AbstractPrcFaManageStrategy {
    private static String RES_PATH = "com.kingdee.eas.fi.fa.manage.FaDecValueResource";
    private static int BATCH_SIZE = 100;

    @Override
    protected IObjectPK saveBill(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        return this.innerSaveBill(ctx, (FaDecValueInfo)model);
    }

    @Override
    protected IObjectPK submitBill(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        return this.innerSaveBill(ctx, (FaDecValueInfo)model);
    }

    private IObjectPK innerSaveBill(Context ctx, FaDecValueInfo info) throws BOSException, EASBizException {
        FaDecValueInfo decValueInfo;
        int size = info.getEntry().size();
        for (int i = 0; i < size; ++i) {
            FaDecValueEntryCollection entryColl = info.getEntry();
            String cardId = entryColl.get(i).getCurcard().getId().toString();
            BigDecimal decvalue = entryColl.get(i).getDecValue();
            FaCurCardInfo cardInfo = FaCurCardFactory.getLocalInstance(ctx).getFaCurCardInfo("select id, number, assetCat.*,assetValue, accuDepr, neatRemValue, decValue, initEvalValue, isEvaledBefore, assetName, bizStatus, leaseStatus where id = '" + cardId + "'");
            this.checkFaCurCardDec(ctx, cardInfo, decvalue);
            if (FaBizStatusEnum.DECVALUEDEALING == cardInfo.getBizStatus()) continue;
            this.checkFaCurCardValid(ctx, cardInfo);
        }
        FaDecValueInfo oldValueInfo = null;
        ObjectUuidPK pk = null;
        if (info.getId() != null) {
            pk = new ObjectUuidPK(info.getId());
            oldValueInfo = FaDecValueFactory.getLocalInstance(ctx).getFaDecValueInfo((IObjectPK)pk, this.getFaDecValueSelector());
        }
        if (info != null && info.getId() != null) {
            boolean flag = false;
            CoreBaseCollection addNewEntryCol = new CoreBaseCollection();
            StringBuffer addNewCurCards = new StringBuffer();
            CoreBaseCollection updateEntryCol = new CoreBaseCollection();
            StringBuffer updateCurCards = new StringBuffer();
            FaDecValueInfo updateEntryInfo = new FaDecValueInfo();
            FaDecValueInfo deleteDecValueInfo = new FaDecValueInfo();
            IFaDecValueEntry ifaDecValueEntry = FaDecValueEntryFactory.getLocalInstance(ctx);
            int size2 = info.getEntry().size();
            for (int i = 0; i < size2; ++i) {
                FaDecValueEntryCollection entryColl = info.getEntry();
                FaDecValueEntryInfo newEntry = entryColl.get(i);
                String cardId = newEntry.getCurcard().getId().toString();
                newEntry.setHead(info);
                flag = false;
                int s = oldValueInfo.getEntry().size();
                for (int j = 0; j < s; ++j) {
                    FaDecValueEntryCollection idlEntryColl = oldValueInfo.getEntry();
                    FaDecValueEntryInfo oldEntry = idlEntryColl.get(j);
                    if (!cardId.equals(oldEntry.getCurcard().getId().toString())) continue;
                    if (newEntry.getDecValue().doubleValue() == 0.0) {
                        deleteDecValueInfo.getEntry().add(oldEntry);
                    } else if (newEntry.getDecValue().compareTo(oldEntry.getDecValue()) != 0) {
                        oldEntry.setDecValue(newEntry.getDecValue());
                        updateEntryCol.add((CoreBaseInfo)oldEntry);
                        updateCurCards.append(",'").append(cardId).append("'");
                        updateEntryInfo.getEntry().add(oldEntry);
                    }
                    flag = true;
                    break;
                }
                if (flag) continue;
                addNewEntryCol.add((CoreBaseInfo)newEntry);
                addNewCurCards.append(",'").append(cardId).append("'");
            }
            Map<String, Boolean> tempTableNames = new HashMap();
            if (addNewEntryCol.size() > 0 || updateEntryCol.size() > 0) {
                tempTableNames = PrcDecValueStrategy.createBizBakTempTable(ctx);
            }
            if (addNewEntryCol.size() > 0 && updateEntryCol.size() > 0) {
                tempTableNames.put("isNeededDropTable", false);
                ifaDecValueEntry.addnewBatchData(addNewEntryCol);
                this.saveBizBakCard(ctx, new String[]{addNewCurCards.substring(1), "t_fa_fadecvalueentry", pk.toString(), "fheadid"}, FaBillTypeEnum.DECVALUE, FaBizStatusEnum.DECVALUEDEALING, tempTableNames);
                tempTableNames.put("isNeededDropTable", true);
                this.rollBackCurcardAndDeleteBizBakCard(ctx, updateEntryInfo);
                ifaDecValueEntry.updateBatchData(updateEntryCol);
                this.saveBizBakCard(ctx, new String[]{updateCurCards.substring(1), "t_fa_fadecvalueentry", pk.toString(), "fheadid"}, FaBillTypeEnum.DECVALUE, FaBizStatusEnum.DECVALUEDEALING, tempTableNames);
            } else if (addNewEntryCol.size() > 0) {
                ifaDecValueEntry.addnewBatchData(addNewEntryCol);
                this.saveBizBakCard(ctx, new String[]{addNewCurCards.substring(1), "t_fa_fadecvalueentry", pk.toString(), "fheadid"}, FaBillTypeEnum.DECVALUE, FaBizStatusEnum.DECVALUEDEALING, tempTableNames);
            } else if (updateEntryCol.size() > 0) {
                this.rollBackCurcardAndDeleteBizBakCard(ctx, updateEntryInfo);
                ifaDecValueEntry.updateBatchData(updateEntryCol);
                this.saveBizBakCard(ctx, new String[]{updateCurCards.substring(1), "t_fa_fadecvalueentry", pk.toString(), "fheadid"}, FaBillTypeEnum.DECVALUE, FaBizStatusEnum.DECVALUEDEALING, tempTableNames);
            }
            if (deleteDecValueInfo.getEntry().size() > 0) {
                this.rollBackCurcardAndDeleteBizBakCard(ctx, deleteDecValueInfo);
                IObjectPK[] deleteEntryID = new IObjectPK[deleteDecValueInfo.getEntry().size()];
                int size3 = deleteDecValueInfo.getEntry().size();
                for (int i = 0; i < size3; ++i) {
                    deleteEntryID[i] = new ObjectUuidPK(deleteDecValueInfo.getEntry().get(i).getId());
                }
                ifaDecValueEntry.deleteBatchData(deleteEntryID);
            }
            if (oldValueInfo.getAlterMode() != null && oldValueInfo.getAlterMode().getId() != null && info.getAlterMode() != null && info.getAlterMode().getId() != null && !oldValueInfo.getAlterMode().getId().equals((Object)info.getAlterMode().getId())) {
                String sql = "update t_fa_fadecvalue set faltermodeid = ? where fid = ? ";
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{info.getAlterMode().getId().toString(), info.getId().toString()});
            }
        } else {
            info.setPeriod(this.getCurrentPeriod(ctx, info));
            info.setBizDate(DateTimeUtils.truncateDate((Date)new Date()));
            info.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
            info.setFiVouchered(false);
            info.setHasEffected(true);
            CompanyOrgUnitInfo object = (CompanyOrgUnitInfo)ctx.get((Object)OrgType.Company);
            Object number = object.get("number");
            if (info.getId() == null) {
                info.setNumber(number.toString() + "-JZ-" + UUIDUtil.UUID());
            }
            if (info.getEntry().size() > 0) {
                Map tempTableNames = PrcDecValueStrategy.createBizBakTempTable(ctx);
                pk = FaDecValueFactory.getLocalInstance(ctx).submitSelf(info);
                String selectCardId = "select fcurcardid from t_fa_faDecValueentry entry where fheadid = '" + pk.toString() + "'";
                this.saveBizBakCard(ctx, new String[]{selectCardId, "t_fa_fadecvalueentry", pk.toString(), "fheadid"}, FaBillTypeEnum.DECVALUE, FaBizStatusEnum.DECVALUEDEALING, tempTableNames);
            }
        }
        if (pk != null && (decValueInfo = FaDecValueFactory.getLocalInstance(ctx).getFaDecValueInfo((IObjectPK)pk)).getEntry().size() == 0) {
            this.deleteBill(ctx, (IObjectPK)new ObjectUuidPK(info.getId()));
        }
        return pk;
    }

    protected void checkFaCurCardDec(Context ctx, FaCurCardInfo curCard, BigDecimal decValue) throws EASBizException, BOSException {
        if (curCard != null) {
            BigDecimal assetValue = curCard.getAssetValue() == null ? ZERO : curCard.getAssetValue();
            BigDecimal accuDepr = curCard.getAccuDepr() == null ? ZERO : curCard.getAccuDepr();
            BigDecimal neatRemValue = curCard.getNeatRemValue() == null ? ZERO : curCard.getNeatRemValue();
            BigDecimal decValueEd = curCard.getDecValue() == null ? ZERO : curCard.getDecValue();
            decValue = decValue == null ? ZERO.add(decValueEd) : decValue.add(decValueEd);
            FaCatInfo aFaCatInfo = curCard.getAssetCat();
            if (aFaCatInfo != null && aFaCatInfo.get("calcuByEvaluate") == null) {
                throw new IllegalArgumentException(EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"108_FaCardValidatorImpl"));
            }
            boolean isUseEvaValue = aFaCatInfo != null && aFaCatInfo.isCalcuByEvaluate() && curCard.getInitEvalValue() != null && curCard.isIsEvaledBefore();
            BigDecimal originalAmount = isUseEvaValue ? curCard.getInitEvalValue() : assetValue;
            BigDecimal temp = (originalAmount = originalAmount == null ? ZERO : originalAmount).subtract(neatRemValue).subtract(accuDepr);
            if (decValue.compareTo(temp) > 0) {
                throw new FaCardException(isUseEvaValue ? FaCardException.CARD_DEP_DEC_EVAL : FaCardException.CARD_DEP_DEC);
            }
        }
    }

    @Override
    protected void auditBill(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        IFaDecValueEntry iDecValueEntry = FaDecValueEntryFactory.getLocalInstance(ctx);
        IFaCurCard iCurCard = FaCurCardFactory.getLocalInstance(ctx);
        IFaBakCard iBakCard = FaBakCardFactory.getLocalInstance(ctx);
        IFaChangeBill iChangeBill = FaChangeBillFactory.getLocalInstance(ctx);
        String updateCardSql = "update t_fa_facurcard set fbizstatus = ? , flastbillid = ? where fid in (" + this.getEntryCol("entry.fcurcardid") + ")";
        DbUtil.execute((Context)ctx, (String)updateCardSql, (Object[])new Object[]{"0999", model.get("id").toString(), model.get("id").toString()});
        FaDecValueInfo decValueInfo = (FaDecValueInfo)model;
        FaDecValueEntryCollection entries = decValueInfo.getEntry();
        PrcFaChangeStrategy changeStrategy = new PrcFaChangeStrategy();
        SelectorItemCollection updateCardSic = this.getUpdateStatusSelector();
        SelectorItemCollection decEntrySic = this.getUpdateDecEntrySelector();
        SelectorItemCollection fullCurCardSic = this.getFullCurCardSelector();
        FaChangeBillInfo templateChangeInfo = this.getChangeBillInfoTemplate(ctx, decValueInfo);
        fullCurCardSic.add(new SelectorItemInfo("assetCat.calcuByDecValue"));
        PeriodInfo currPeriod = this.getCurrentPeriod(ctx, decValueInfo);
        String strYear = ResourceBase.getString((String)RES_PATH, (String)"periodYear", (Locale)ctx.getOriginLocale());
        String strNumber = ResourceBase.getString((String)RES_PATH, (String)"periodNumber", (Locale)ctx.getOriginLocale());
        String strDecValue = ResourceBase.getString((String)RES_PATH, (String)"strDecValue", (Locale)ctx.getOriginLocale());
        String strPick = ResourceBase.getString((String)RES_PATH, (String)"pick", (Locale)ctx.getOriginLocale());
        String switchBack = ResourceBase.getString((String)RES_PATH, (String)"switchBack", (Locale)ctx.getOriginLocale());
        HashMap<BOSUuid, FaDecValueEntryInfo> entryMap = new HashMap<BOSUuid, FaDecValueEntryInfo>();
        HashSet<String> curcardIdSet = new HashSet<String>();
        int batchSize = BATCH_SIZE;
        if (entries != null && entries.size() > 0) {
            for (int i = 0; i < entries.size(); ++i) {
                if (entries.get(i) == null) continue;
                entryMap.put(entries.get(i).getCurcard().getId(), entries.get(i));
                curcardIdSet.add(entries.get(i).getCurcard().getId().toString());
                if ((i + 1) % batchSize != 0) continue;
                this.batchDealEntryData(ctx, iCurCard, entryMap, curcardIdSet, fullCurCardSic, templateChangeInfo, currPeriod, strYear, strNumber, strDecValue, strPick, switchBack, iBakCard, iChangeBill, changeStrategy, decEntrySic, updateCardSic, iDecValueEntry);
                entryMap.clear();
                curcardIdSet.clear();
            }
            if (entryMap.size() > 0 && curcardIdSet.size() > 0) {
                this.batchDealEntryData(ctx, iCurCard, entryMap, curcardIdSet, fullCurCardSic, templateChangeInfo, currPeriod, strYear, strNumber, strDecValue, strPick, switchBack, iBakCard, iChangeBill, changeStrategy, decEntrySic, updateCardSic, iDecValueEntry);
            }
        }
    }

    private void batchDealEntryData(Context ctx, IFaCurCard iCurCard, HashMap entryMap, HashSet curcardIdSet, SelectorItemCollection fullCurCardSic, FaChangeBillInfo templateChangeInfo, PeriodInfo currPeriod, String strYear, String strNumber, String strDecValue, String strPick, String switchBack, IFaBakCard iBakCard, IFaChangeBill iChangeBill, PrcFaChangeStrategy changeStrategy, SelectorItemCollection decEntrySic, SelectorItemCollection updateCardSic, IFaDecValueEntry iDecValueEntry) throws BOSException, EASBizException {
        FaCurCardInfo curCardInfo;
        CoreBaseCollection bakCardCol = new CoreBaseCollection();
        CoreBaseCollection coreChangeBillCol = new CoreBaseCollection();
        FaChangeBillCollection changeBillCol = new FaChangeBillCollection();
        FaCurCardCollection curCardCollection = new FaCurCardCollection();
        EntityViewInfo v = new EntityViewInfo();
        v.setSelector(fullCurCardSic);
        FilterInfo f = new FilterInfo();
        v.setFilter(f);
        f.getFilterItems().add(new FilterItemInfo("id", (Object)curcardIdSet, CompareType.INCLUDE));
        FaCurCardCollection cards = iCurCard.getFaCurCardCollection(v);
        Iterator iterator = cards.iterator();
        while (iterator.hasNext()) {
            curCardInfo = (FaCurCardInfo)iterator.next();
            FaDecValueEntryInfo entry = (FaDecValueEntryInfo)entryMap.get(curCardInfo.getId());
            FaCurCardInfo bakCardInfo = (FaCurCardInfo)curCardInfo.clone();
            FaChangeBillInfo changeInfo = (FaChangeBillInfo)templateChangeInfo.clone();
            String description = currPeriod.getPeriodYear() + strYear + currPeriod.getPeriodNumber() + strNumber + strDecValue;
            description = entry.getDecValue().doubleValue() > 0.0 ? description + strPick : description + switchBack;
            changeInfo.setDescription(description.toString());
            FaBakCardInfo bakCard = FaManageUtils.CurCard2BakCard(bakCardInfo);
            bakCard.setFaCurCard(curCardInfo);
            bakCard.setBillType(FaBillTypeEnum.CHANGE);
            bakCard.setId(BOSUuid.create((BOSObjectType)bakCard.getBOSType()));
            bakCardCol.add((CoreBaseInfo)bakCard);
            curCardInfo.setDecValue(curCardInfo.getDecValue().add(entry.getDecValue()));
            curCardInfo.setNeatAmt(curCardInfo.getNeatValue().subtract(curCardInfo.getDecValue()));
            FADepreciationPolicyInfo faDepreciationPolicyInfo = FADepreciationPolicyFactory.getLocalInstance((Context)ctx).getFADepreciationPolicyInfo((IObjectPK)new ObjectUuidPK(curCardInfo.getAssetCat().getDepreciationPolicy().getId().toString()));
            boolean isDevalueChange = faDepreciationPolicyInfo.isDevalueChange();
            FaChangeStatusEnmu haseChange = isDevalueChange ? FaChangeStatusEnmu.HasChanged_ReDepr_DepAllChange : FaChangeStatusEnmu.HasChanged_NoDepr_DepChange;
            curCardInfo.setHasChanged(haseChange);
            FaBizCardInfo bizCard = FaManageUtils.CurCard2BizCard(curCardInfo);
            bizCard.setBillType(FaBillTypeEnum.CHANGE);
            bizCard.setFaBakCard(bakCard);
            FaChangeBillEntryInfo changeEntryInfo = changeInfo.getChangeBillEntry().get(0);
            BOSUuid uuid = BOSUuid.create((BOSObjectType)changeInfo.getBOSType());
            changeInfo.setId(uuid);
            changeEntryInfo.setBizCard(bizCard);
            changeEntryInfo.setCurCard(curCardInfo);
            changeEntryInfo.setOriginChg(ZERO);
            changeEntryInfo.setAccuDeprChg(ZERO);
            changeEntryInfo.setDecValueChg(entry.getDecValue());
            coreChangeBillCol.add((CoreBaseInfo)changeInfo);
            changeBillCol.add(changeInfo);
            entry.setChangeBill(changeInfo);
            iDecValueEntry.updatePartial((CoreBaseInfo)entry, decEntrySic);
            curCardInfo.setLastBillID(entry.getHead().getId().toString());
            curCardInfo.setBizStatus(FaBizStatusEnum.HAVE_DECVALUEDEALED);
            curCardCollection.add(curCardInfo);
        }
        iBakCard.submitBatchData(bakCardCol);
        PrcDecValueStrategy.getChangeBillColNumbers(ctx, changeBillCol);
        iChangeBill.submitBatchData(coreChangeBillCol);
        changeStrategy.auditBill(ctx, changeBillCol);
        iterator = curCardCollection.iterator();
        while (iterator.hasNext()) {
            curCardInfo = (FaCurCardInfo)iterator.next();
            iCurCard.updatePartial((CoreBaseInfo)curCardInfo, updateCardSic);
        }
    }

    @Override
    protected void unAuditBill(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        FaDecValueInfo decValueinfo = (FaDecValueInfo)model;
        IFaCurCard iCurCard = FaCurCardFactory.getLocalInstance(ctx);
        IFaBakCard iBakCard = FaBakCardFactory.getLocalInstance(ctx);
        IFaDecValueEntry iDecValueEntry = FaDecValueEntryFactory.getLocalInstance(ctx);
        IFaChangeBill iChangeBill = FaChangeBillFactory.getLocalInstance(ctx);
        PrcFaChangeStrategy changeStrategy = new PrcFaChangeStrategy();
        SelectorItemCollection updateCardSic = this.getUpdateStatusSelector();
        SelectorItemCollection updateDecEntrySic = this.getUpdateDecEntrySelector();
        SelectorItemCollection changeBillSic = this.getChangeBillSelector();
        FaDecValueEntryCollection entries = decValueinfo.getEntry();
        int size = entries.size();
        for (int i = 0; i < size; ++i) {
            BOSUuid curPropertyValueId;
            FaCurCardInfo curCardInfo;
            FaDecValueEntryInfo entry = entries.get(i);
            BOSUuid cardId = entry.getCurcard().getId();
            if (entry.getChangeBill() != null && entry.getChangeBill().getId() != null) {
                BOSUuid changeBillId = entry.getChangeBill().getId();
                entry.setChangeBill(null);
                iDecValueEntry.updatePartial((CoreBaseInfo)entry, updateDecEntrySic);
                CoreBaseInfo changeBillInfo = iChangeBill.getValue((IObjectPK)new ObjectUuidPK(changeBillId), changeBillSic);
                changeStrategy.unAuditBill(ctx, (IObjectValue)changeBillInfo);
                changeStrategy.deleteBill(ctx, (IObjectPK)new ObjectUuidPK(changeBillId));
            }
            if ((curCardInfo = entry.getCurcard()) == null) continue;
            curCardInfo = FaCurCardFactory.getLocalInstance(ctx).getFaCurCardInfo((IObjectPK)new ObjectUuidPK(cardId));
            FaBizCardInfo bizcard = entry.getBizcard();
            if (bizcard == null) continue;
            SelectorItemCollection sicOfBakCard = PrcFaCoreManager.getBakCardSelectors();
            sicOfBakCard.add(new SelectorItemInfo("company.baseCurrency.*"));
            sicOfBakCard.add(new SelectorItemInfo("assetCat.DepreciationPolicy.*"));
            sicOfBakCard.add(new SelectorItemInfo("deprMethod.*"));
            sicOfBakCard.add(new SelectorItemInfo("assetCat.*"));
            sicOfBakCard.add(new SelectorItemInfo("useStatus.isDepreciation"));
            sicOfBakCard.add(new SelectorItemInfo("useStatus.id"));
            sicOfBakCard.add(new SelectorItemInfo("faCurCard.deprTTerm"));
            sicOfBakCard.add(new SelectorItemInfo("faCurCard.evalDeprTTerm"));
            sicOfBakCard.add(new SelectorItemInfo("faBakCostCenter.*"));
            sicOfBakCard.add(new SelectorItemInfo("faBakCostCenter.faBakAsstActComposit.*"));
            bizcard = FaBizCardFactory.getLocalInstance(ctx).getFaBizCardInfo((IObjectPK)new ObjectUuidPK(bizcard.getId()), sicOfBakCard);
            FaCurCardInfo curCardInfoNew = FaManageUtils.BizCard2CurCard(bizcard);
            BOSUuid bOSUuid = curPropertyValueId = curCardInfo.getPropertyValue() == null ? null : curCardInfo.getPropertyValue().getId();
            if (bizcard.getPropertyValue() != null) {
                FaDefPropertyValueInfo p = FaCardDefPropertyPersist.copy(curPropertyValueId, bizcard.getPropertyValue().getId(), ctx);
                curCardInfo.setPropertyValue(p);
            } else {
                FaCardDefPropertyPersist.deleteById(curPropertyValueId, ctx);
            }
            curCardInfo.setNeatAmt(curCardInfo.getNeatValue().subtract(curCardInfo.getDecValue()));
            curCardInfo.setBizStatus(FaBizStatusEnum.DECVALUEDEALING);
            curCardInfo.setId(cardId);
            iCurCard.updatePartial((CoreBaseInfo)curCardInfo, updateCardSic);
        }
        FaDecValueFactory.getLocalInstance(ctx).unpassAuditSelf((IObjectPK)new ObjectUuidPK(decValueinfo.getId()), decValueinfo);
    }

    @Override
    protected void checkForEdit(Context ctx, IObjectValue val) throws EASBizException, BOSException {
        ObjectUuidPK pk;
        ObjectUuidPK objectUuidPK = pk = val.get("id") == null ? null : new ObjectUuidPK(val.get("id").toString());
        if (pk == null || pk.toString().length() == 0) {
            return;
        }
        BillBaseInfo billInfo = this.perpareBillInfo(ctx, (IObjectPK)pk);
        StringBuffer sbMsg = new StringBuffer("");
        if (billInfo.get("checkedStatus").equals(new Integer(2))) {
            sbMsg.append(" ");
            sbMsg.append(this.getCheckedStatus(billInfo, ctx));
        }
        if (billInfo.getBoolean("fiVouchered")) {
            sbMsg.append(" ");
            sbMsg.append(this.getIsVouchered(billInfo, ctx));
        }
        if (sbMsg.toString().length() > 0) {
            StringBuffer sbAll = new StringBuffer(ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource", (String)"THISBILL", (Locale)ctx.getOriginLocale()));
            sbAll.append(sbMsg);
            sbAll.append("\n");
            throw new FaCardException(FaCardException.CANNOT_BE_EDITED, new String[]{sbAll.toString()});
        }
        FaLocalUtils.verifyForLastestPeriod(ctx, val, 7);
    }

    @Override
    protected void generateVourcher(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
    }

    @Override
    protected void deleteBill(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        FaDecValueFactory.getLocalInstance(ctx).delete(pk);
    }

    @Override
    protected void checkForAudit(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        if (pk == null || pk.toString().length() == 0) {
            return;
        }
        BillBaseInfo billInfo = this.perpareBillInfo(ctx, pk);
        StringBuffer sbMsg = new StringBuffer("");
        if (billInfo.get("checkedStatus").equals(new Integer(2))) {
            sbMsg.append(" ");
            sbMsg.append(this.getCheckedStatus(billInfo, ctx));
        }
        if (billInfo.getBoolean("fiVouchered")) {
            sbMsg.append(" ");
            sbMsg.append(this.getIsVouchered(billInfo, ctx));
        }
        if (sbMsg.toString().length() > 0) {
            StringBuffer sbAll = new StringBuffer(ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource", (String)"THISBILL", (Locale)ctx.getOriginLocale()));
            sbAll.append(sbMsg);
            sbAll.append("\n");
            throw new FaCardException(FaCardException.CANNOT_BE_AUDITED, new String[]{sbAll.toString()});
        }
        FaLocalUtils.verifyForLastestPeriod(ctx, (IObjectValue)billInfo, 4);
    }

    @Override
    protected void checkForUnAudit(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        StringBuffer info = new StringBuffer();
        FaDecValueInfo decValueInfo = FaDecValueFactory.getLocalInstance(ctx).getFaDecValueInfo("select * where id ='" + pk.toString() + "'");
        if (decValueInfo.get("checkedStatus").equals(new Integer(1))) {
            info.append(" ");
            info.append(this.getCheckedStatus(decValueInfo, ctx));
        }
        if (decValueInfo.getBoolean("fiVouchered")) {
            info.append(" ");
            info.append(this.getIsVouchered(decValueInfo, ctx));
        }
        if (info.toString().length() > 0) {
            StringBuffer sbAll = new StringBuffer(ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource", (String)"THISBILL", (Locale)ctx.getOriginLocale()));
            sbAll.append(info);
            sbAll.append("\n");
            throw new FaCardException(FaCardException.CANNOT_BE_UNAUDITED, new String[]{"", sbAll.toString()});
        }
        info = new StringBuffer();
        if (decValueInfo.isFiVouchered()) {
            info.append(ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource", (String)"Has_GenVoucher", (Locale)ctx.getOriginLocale()));
        }
        if (info.length() > 0) {
            throw new FaCardException(FaCardException.CANT_UNDO, new String[]{info.toString()});
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select curcard.fnumber as assetNumber,curcard.fassetname as assetName, curcard.flastbillid as lastbillid");
        sql.append(" from t_fa_fadecvalue decv");
        sql.append(" inner join t_fa_fadecvalueentry entry on entry.fheadid = decv.fid");
        sql.append(" inner join t_fa_fachangebill changebill on entry.fchangebillid = changebill.fid");
        sql.append(" inner join t_fa_fachangebillentry b on b.fchangebillid = changebill.fid");
        sql.append(" inner join t_fa_facurcard curcard on b.fcurcardid = curcard.fid");
        sql.append(" where curcard.flastbillid != decv.fid");
        sql.append(" and decv.fid = '").append(pk.toString()).append("'");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        info = new StringBuffer();
        try {
            while (rowSet.next()) {
                String billName = rowSet.getString("assetNumber") + "(" + rowSet.getString("assetName") + ")";
                String bizName = FaLocalUtils.getEntityAlias(ctx, BOSUuid.getBOSObjectType((String)rowSet.getString("lastbillid"), (boolean)false));
                info.append(",").append(new FaCardException(FaCardException.HASOTHEROPRATION, new String[]{billName, bizName}).getMessage());
            }
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        if (info.length() > 0) {
            throw new FaCardException(FaCardException.CANT_UNDO, new String[]{info.substring(1)});
        }
        StringBuffer sqlStr = new StringBuffer();
        sqlStr.append("select curcard.fnumber as assetNumber,curcard.fassetname as assetName, curcard.flastbillid as lastbillid ");
        sqlStr.append(" from t_fa_fadecvalue decv");
        sqlStr.append(" inner join t_fa_fadecvalueentry entry on entry.fheadid = decv.fid");
        sqlStr.append(" inner join t_fa_fadepreciationentry deprentry on deprentry.ffacurcardid = entry.fcurcardid");
        sqlStr.append(" inner join t_fa_fadepreciation depr on depr.fid = deprentry.flnkfadepreentry");
        sqlStr.append(" inner join t_fa_facurcard curcard on curcard.fid = entry.fcurcardid");
        sqlStr.append(" inner join t_bd_period pd1 on pd1.fid = decv.fperiodid");
        sqlStr.append(" inner join t_bd_period pd2 on pd2.fid = depr.fperiod");
        sqlStr.append(" where depr.ffivouchered = 1");
        sqlStr.append(" and pd2.fnumber > pd1.fnumber");
        sqlStr.append(" and decv.fid = '").append(pk.toString()).append("'");
        IRowSet rowSetS = DbUtil.executeQuery((Context)ctx, (String)sqlStr.toString());
        info = new StringBuffer();
        try {
            while (rowSetS.next()) {
                String billName = rowSetS.getString("assetNumber") + "(" + rowSetS.getString("assetName") + ")";
                info.append(",").append(new FaCardException(FaCardException.HASVOUCHERFROMDEPRLATER, new String[]{billName}).getMessage());
            }
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        if (info.length() > 0) {
            throw new FaCardException(FaCardException.CANT_UNDO, new String[]{info.substring(1)});
        }
        FaLocalUtils.verifyForLastestPeriod(ctx, (IObjectValue)decValueInfo, 5);
    }

    private FaChangeBillInfo getChangeBillInfoTemplate(Context ctx, FaDecValueInfo decValueInfo) throws EASBizException, BOSException {
        Date today = DateTimeUtils.truncateDate((Date)new Date());
        PeriodInfo periodInfo = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(decValueInfo.getPeriod().getId()));
        FaChangeBillInfo changeInfo = new FaChangeBillInfo();
        changeInfo.setEffectedStatus(EffectedStatusEnum.EFFECTED);
        changeInfo.setDeletedStatus(DeletedStatusEnum.NORMAL);
        changeInfo.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
        changeInfo.setBlockedStatus(BlockedStatusEnum.UNBLOCKED);
        changeInfo.setFiVouchered(false);
        if (today.after(periodInfo.getEndDate())) {
            changeInfo.setChangeDate(periodInfo.getEndDate());
        } else if (today.before(periodInfo.getBeginDate())) {
            changeInfo.setChangeDate(periodInfo.getBeginDate());
        } else {
            changeInfo.setChangeDate(today);
        }
        changeInfo.setPeriod(periodInfo);
        changeInfo.setBillType(FaBillOriginEnum.FROM_DECVALUE);
        changeInfo.setCompany(decValueInfo.getCompany());
        changeInfo.setBizDate(today);
        changeInfo.setHasEffected(true);
        changeInfo.setSourceBillId(decValueInfo.getId().toString());
        changeInfo.setHandler(ContextUtil.getCurrentUserInfo((Context)ctx));
        changeInfo.setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
        changeInfo.setLastUpdateTime(null);
        changeInfo.setChangeMode(decValueInfo.getAlterMode());
        FaChangeBillEntryInfo changeEntryInfo = new FaChangeBillEntryInfo();
        changeInfo.getChangeBillEntry().add(changeEntryInfo);
        changeEntryInfo.setChangeBill(changeInfo);
        return changeInfo;
    }

    private String getEntryCol(String columnName) {
        return "select " + columnName + " from t_fa_fadecvalue bill inner join t_fa_fadecvalueentry entry on bill.fid = entry.fheadid where bill.fid = ?";
    }

    private SelectorItemCollection getFullCurCardSelector() {
        SelectorItemCollection sic = PrcFaCoreManager.getCurCardSelectors();
        sic.add(new SelectorItemInfo("currency.precision"));
        return sic;
    }

    private SelectorItemCollection getUpdateStatusSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("decValue"));
        sic.add(new SelectorItemInfo("neatAmt"));
        sic.add(new SelectorItemInfo("lastBillID"));
        sic.add(new SelectorItemInfo("bizStatus"));
        sic.add(new SelectorItemInfo("propertyValue"));
        sic.add(new SelectorItemInfo("hasChanged"));
        return sic;
    }

    private SelectorItemCollection getUpdateDecEntrySelector() {
        SelectorItemCollection decEntrySic = new SelectorItemCollection();
        decEntrySic.add(new SelectorItemInfo("changeBill"));
        return decEntrySic;
    }

    private SelectorItemCollection getChangeBillSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("changeBillEntry.*"));
        sic.add(new SelectorItemInfo("changeBillEntry.curCard.*"));
        sic.add(new SelectorItemInfo("changeBillEntry.bizCard.faBakCard.id"));
        return sic;
    }

    private SelectorItemCollection getFaDecValueSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("alterMode.id"));
        sic.add(new SelectorItemInfo("alterMode.name"));
        sic.add(new SelectorItemInfo("alterMode.number"));
        sic.add(new SelectorItemInfo("entry.decValue"));
        sic.add(new SelectorItemInfo("entry.curcard.id"));
        sic.add(new SelectorItemInfo("entry.bizcard.id"));
        sic.add(new SelectorItemInfo("entry.bizcard.faBakCard.id"));
        sic.add(new SelectorItemInfo("entry.head.id"));
        return sic;
    }

    @Override
    protected String getCurCardFieldName() {
        return "curcard";
    }

    @Override
    protected String getBizCardFieldName() {
        return "bizcard";
    }

    private void rollBackCurcardAndDeleteBizBakCard(Context ctx, FaDecValueInfo info) throws EASBizException, BOSException {
        CompanyOrgUnitInfo companyInfo = info.getCompany() != null ? info.getCompany() : ContextUtil.getCurrentFIUnit((Context)ctx);
        PeriodInfo curPeriodInfo = info.getPeriod() != null ? info.getPeriod() : FaDepLocalUtils.getCurrentPeriod(ctx);
        ArrayList<String> list = new ArrayList<String>();
        int size = info.getEntry().size();
        IObjectPK[] bizCardIds = new IObjectPK[size];
        IObjectPK[] bakCardIds = new IObjectPK[size];
        Iterator it = info.getEntry().iterator();
        int i = 0;
        while (it.hasNext()) {
            FaDecValueEntryInfo entry = (FaDecValueEntryInfo)it.next();
            list.add(entry.getCurcard().getId().toString());
            bizCardIds[i] = new ObjectUuidPK(entry.getBizcard().getId().toString());
            bakCardIds[i] = new ObjectUuidPK(entry.getBizcard().getFaBakCard().getId().toString());
        }
        PreparedStatement stmt = null;
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            StringBuffer curCardIdArray = new StringBuffer();
            for (int j = 0; j < list.size(); ++j) {
                if (list.get(j) == null) continue;
                curCardIdArray.append("'" + list.get(j) + "',");
            }
            if (curCardIdArray.length() > 0) {
                String updateSql = this.updateCurCard(curCardIdArray);
                stmt = conn.prepareStatement(updateSql.toString());
                stmt.setString(1, companyInfo.getId().toString());
                stmt.setString(2, curPeriodInfo.getId().toString());
                stmt.executeUpdate();
            }
            this.deleteBizBakCard(ctx, bizCardIds, bakCardIds, true);
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
    }

    private String updateCurCard(StringBuffer idArray) {
        StringBuffer updateCurCardSql = new StringBuffer();
        updateCurCardSql.append("update t_fa_facurcard set (fbizstatus, flastbillid, flastupdatetime) = ").append("(select bak.fbizstatus, bak.flastbillid, bak.flastupdatetime ").append(" from t_fa_fadecvalueentry entry ").append(" inner join t_fa_fadecvalue dec on dec.fid = entry.fheadid ").append(" inner join t_fa_fabizcard biz on biz.fid = entry.fbizcardid ").append(" inner join t_fa_fabakcard bak on bak.fid = biz.ffabakcardid ").append(" where dec.fcompanyid = ? and dec.fperiodid = ? ").append(" and entry.fcurcardid = t_fa_facurcard.fid) ").append(" where t_fa_facurcard.fid in (").append(idArray.substring(0, idArray.length() - 1)).append(")");
        return updateCurCardSql.toString();
    }

    public static void getChangeBillColNumbers(Context ctx, FaChangeBillCollection changeBillCol) throws EASBizException, BOSException {
        String strCompanyID = changeBillCol.get(0).getCompany() != null && changeBillCol.get(0).getCompany().getId() != null ? changeBillCol.get(0).getCompany().getId().toString() : ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        FaChangeBillInfo changeBillInfo = changeBillCol.get(0);
        changeBillInfo.setCU(ContextUtil.getCurrentFIUnit((Context)ctx).getCU());
        StringBuffer changeBillNumbers = new StringBuffer();
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        String[] batchNumbers = iCodingRuleManager.getBatchNumber((IObjectValue)changeBillInfo, strCompanyID, changeBillCol.size());
        HashSet<String> numberSet = new HashSet<String>();
        while (true) {
            changeBillNumbers = new StringBuffer();
            for (int i = 0; i < batchNumbers.length; ++i) {
                numberSet.add(batchNumbers[i]);
                changeBillNumbers.append(",'").append(batchNumbers[i]).append("'");
            }
            String existNumberCountSQl = "select fnumber from t_fa_fachangebill where fcompanyid=? and fnumber in(" + changeBillNumbers.substring(1) + ") ";
            IRowSet result = DbUtil.executeQuery((Context)ctx, (String)existNumberCountSQl, (Object[])new Object[]{strCompanyID});
            try {
                while (result != null && result.next()) {
                    numberSet.remove(result.getString("fnumber"));
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            if (numberSet.size() >= changeBillCol.size()) break;
            batchNumbers = iCodingRuleManager.getBatchNumber((IObjectValue)changeBillInfo, strCompanyID, changeBillCol.size() - numberSet.size());
        }
        for (int i = 0; i < changeBillCol.size(); ++i) {
            String[] changeBillInfoNumber = numberSet.toArray(new String[0]);
            changeBillCol.get(i).setNumber(changeBillInfoNumber[i]);
            changeBillCol.get(i).setCU(ContextUtil.getCurrentFIUnit((Context)ctx).getCU());
        }
    }
}

