/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.dap.DAPVoucherTypeEnum;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.master.account.common.AccountConstant;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.adv.chain.app.BusinessChainExecutingHelper;
import com.kingdee.eas.dynbusiness.app.processor.ApplicationContext;
import com.kingdee.eas.fi.fa.basedata.FADepreciationPolicyInfo;
import com.kingdee.eas.fi.fa.basedata.FaCatFactory;
import com.kingdee.eas.fi.fa.basedata.FaCatInfo;
import com.kingdee.eas.fi.fa.basedata.FaDepreciationModeFactory;
import com.kingdee.eas.fi.fa.basedata.FaDepreciationModeInfo;
import com.kingdee.eas.fi.fa.basedata.IFaCat;
import com.kingdee.eas.fi.fa.basedata.IFaDepreciationMode;
import com.kingdee.eas.fi.fa.facade.app.AbstractFaDAPTransStrategy;
import com.kingdee.eas.fi.fa.facade.app.FaDAPCardStrategy;
import com.kingdee.eas.fi.fa.facade.app.FaDAPFacade;
import com.kingdee.eas.fi.fa.manage.FaBakCardCollection;
import com.kingdee.eas.fi.fa.manage.FaBakCardFactory;
import com.kingdee.eas.fi.fa.manage.FaBakCardInfo;
import com.kingdee.eas.fi.fa.manage.FaBillTypeEnum;
import com.kingdee.eas.fi.fa.manage.FaBizCardCollection;
import com.kingdee.eas.fi.fa.manage.FaBizCardFactory;
import com.kingdee.eas.fi.fa.manage.FaBizCardInfo;
import com.kingdee.eas.fi.fa.manage.FaBizStatusEnum;
import com.kingdee.eas.fi.fa.manage.FaCardException;
import com.kingdee.eas.fi.fa.manage.FaCardOriginEnum;
import com.kingdee.eas.fi.fa.manage.FaCurCardCollection;
import com.kingdee.eas.fi.fa.manage.FaCurCardFactory;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.fi.fa.manage.FaDepCalFacadeFactory;
import com.kingdee.eas.fi.fa.manage.FaDepCalcForCoalFacadeFactory;
import com.kingdee.eas.fi.fa.manage.FaLeaseBillEntryFactory;
import com.kingdee.eas.fi.fa.manage.FaLeaseBillInfo;
import com.kingdee.eas.fi.fa.manage.FaManageUtils;
import com.kingdee.eas.fi.fa.manage.FaMortagBillEntryFactory;
import com.kingdee.eas.fi.fa.manage.FaMortagBillInfo;
import com.kingdee.eas.fi.fa.manage.FaUserDefineSortEntryFactory;
import com.kingdee.eas.fi.fa.manage.FaWorkLoadCollection;
import com.kingdee.eas.fi.fa.manage.FaWorkLoadFactory;
import com.kingdee.eas.fi.fa.manage.FaWorkLoadInfo;
import com.kingdee.eas.fi.fa.manage.IFaCurCard;
import com.kingdee.eas.fi.fa.manage.IFaDepCalFacade;
import com.kingdee.eas.fi.fa.manage.IFaDepCalcForCoalFacade;
import com.kingdee.eas.fi.fa.manage.IFaWorkLoad;
import com.kingdee.eas.fi.fa.manage.app.AbstractPrcFaManageStrategy;
import com.kingdee.eas.fi.fa.manage.app.FaBalanceAddUpdStrategy;
import com.kingdee.eas.fi.fa.manage.app.FaBalanceFacade;
import com.kingdee.eas.fi.fa.manage.app.FaCardDefPropertyPersist;
import com.kingdee.eas.fi.fa.manage.app.FaDepCalExecutor;
import com.kingdee.eas.fi.fa.manage.app.FaDepLocalUtils;
import com.kingdee.eas.fi.fa.manage.app.FaDepORMapping;
import com.kingdee.eas.fi.fa.manage.app.FaLocalUtils;
import com.kingdee.eas.fi.fa.manage.app.PrcFaCoreManager;
import com.kingdee.eas.fi.fa.manage.app.processor.FaCurCardBusinessProcessorBuilder;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.BlockedStatusEnum;
import com.kingdee.eas.framework.CheckedStatusEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.framework.EffectedStatusEnum;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class PrcFaAddStrategy
extends AbstractPrcFaManageStrategy {
    public static final String IS_FROM_PRCFAADDSTRATEGY = "isFromPrcFaAddStrategy";

    @Override
    protected IObjectPK saveBill(Context ctx, IObjectValue bill) throws EASBizException, BOSException {
        if (bill == null) {
            throw new IllegalArgumentException();
        }
        FaCurCardInfo curCard = (FaCurCardInfo)bill;
        curCard.setEffectedStatus(EffectedStatusEnum.TEMPSTORE);
        curCard.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
        curCard.setDeletedStatus(DeletedStatusEnum.NORMAL);
        curCard.setBlockedStatus(BlockedStatusEnum.UNBLOCKED);
        curCard.setBizStatus(FaBizStatusEnum.ADDING);
        curCard.setFiVouchered(false);
        if (curCard.getUseTermCount() != null && curCard.getDeprTermCount() != null) {
            curCard.setIsOveraged(curCard.getUseTermCount().doubleValue() <= curCard.getDeprTermCount().doubleValue());
        }
        return FaCurCardFactory.getLocalInstance(ctx).saveSelf((CoreBaseInfo)curCard);
    }

    @Override
    protected IObjectPK submitBill(Context ctx, IObjectValue bill) throws EASBizException, BOSException {
        if (bill == null) {
            throw new IllegalArgumentException();
        }
        FaCurCardInfo curCard = (FaCurCardInfo)bill;
        curCard.setEffectedStatus(EffectedStatusEnum.EFFECTED);
        curCard.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
        curCard.setDeletedStatus(DeletedStatusEnum.NORMAL);
        curCard.setBlockedStatus(BlockedStatusEnum.UNBLOCKED);
        curCard.setBizStatus(FaBizStatusEnum.ADDING);
        curCard.setOriginDif(curCard.getAssetValue());
        curCard.setOriginAccuDif(curCard.getAssetValue());
        curCard.setAccuDeprChg(curCard.getAccuDepr());
        curCard.setAccuDeprAccuChg(curCard.getAccuDepr());
        curCard.setAccuDeprChgTYear(curCard.getAccuDeprTYear());
        curCard.setAccuDeprAccuChgTYear(curCard.getAccuDeprTYear());
        curCard.setDecValueChg(curCard.getDecValue());
        curCard.setDecValueAccuChg(curCard.getDecValue());
        curCard.setFiVouchered(false);
        curCard.setIsOveraged(curCard.getUseTermCount().doubleValue() <= curCard.getDeprTermCount().doubleValue());
        return FaCurCardFactory.getLocalInstance(ctx).submitSelf((CoreBaseInfo)curCard);
    }

    @Override
    protected void auditBill(Context ctx, IObjectValue bill) throws EASBizException, BOSException {
        if (bill == null) {
            throw new IllegalArgumentException();
        }
        FaCurCardInfo curCard = (FaCurCardInfo)bill;
        curCard.setEffectedStatus(EffectedStatusEnum.EFFECTED);
        curCard.setCheckedStatus(CheckedStatusEnum.AUDITED);
        curCard.setDeletedStatus(DeletedStatusEnum.NORMAL);
        curCard.setBlockedStatus(BlockedStatusEnum.UNBLOCKED);
        curCard.setBizStatus(FaBizStatusEnum.HAVE_ADDED);
        curCard.setHasNew(true);
        curCard.setFiVouchered(false);
        PeriodInfo period = this.getCurrentPeriod(ctx, curCard);
        if (curCard.getFiAccountDate() == null) {
            Date now = DateTimeUtils.truncateDate((Date)new Date());
            if (now.before(period.getBeginDate())) {
                now = period.getBeginDate();
            }
            if (now.after(period.getEndDate())) {
                now = period.getEndDate();
            }
            if (now.before(curCard.getAccountDate())) {
                now = curCard.getAccountDate();
            }
            curCard.setFiAccountDate(now);
        } else {
            HashMap hmParam = FaManageUtils.getFAParameter(curCard.getCompany().getId(), ctx);
            String addNextCard = (String)hmParam.get("FA_100");
            if ((addNextCard == null || "false".equals(addNextCard)) && (curCard.getFiAccountDate().before(period.getBeginDate()) || curCard.getFiAccountDate().after(period.getEndDate()))) {
                throw new FaCardException(FaCardException.ACCOUNT_DATE_NOT_IN_PERIOD);
            }
        }
        boolean isAfterPeriodCard = FaManageUtils.getFaParamValue(ctx, "FA_100", curCard.getCompany().getId().toString());
        if (isAfterPeriodCard) {
            boolean isAllowPassPeriod;
            boolean isLatestPeriod = FaLocalUtils.isCurrentPeriodLatest(ctx, curCard.getCompany().getId().toString());
            if (isLatestPeriod && FaManageUtils.comparePeriods(curCard.getPeriod(), period) == 1) {
                curCard.setLatestPeriodAddFuture(true);
            }
            if (isAllowPassPeriod = FaManageUtils.getFaParamValue(ctx, "FA_022", curCard.getCompany().getId().toString())) {
                PeriodInfo fiAccountPeriod = PeriodUtils.getPeriodInfo((Context)ctx, (Date)curCard.getFiAccountDate(), (CompanyOrgUnitInfo)curCard.getCompany());
                curCard.setPeriod(fiAccountPeriod);
            }
        }
        if (curCard.getSourceBillId() != null) {
            ApplicationContext applicationContext = new ApplicationContext();
            applicationContext.putData("sourceBillId", (Object)curCard.getSourceBillId());
            applicationContext.putData("sourceEntryID", (Object)curCard.getSourceBillId());
            applicationContext.putData("changeQty", (Object)curCard.getAssetAmt());
            BusinessChainExecutingHelper.batchExecute((Context)ctx, null, (BOSObjectType)BOSObjectType.create((String)"42AC39EC"), (Object[])new Object[]{curCard.getId().toString()}, (BatchActionEnum)BatchActionEnum.AUDIT, FaCurCardBusinessProcessorBuilder.class, (ApplicationContext)applicationContext);
        }
        if (curCard.getOriginFlag().getValue() != 0) {
            curCard.setIsNeedReDepr(false);
            if (FaDepLocalUtils.ifAlreadyCal(ctx, curCard.getPeriod(), curCard.getCompany().getId().toString()) && curCard.getAssetCat() != null && curCard.getAssetCat().getId() != null) {
                IFaCat iFaCat = FaCatFactory.getLocalInstance((Context)ctx);
                ObjectUuidPK faCatpk = new ObjectUuidPK(curCard.getAssetCat().getId());
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("*"));
                sic.add(new SelectorItemInfo("DepreciationPolicy.*"));
                FaCatInfo aFaCatInfo = iFaCat.getFaCatInfo((IObjectPK)faCatpk, sic);
                FADepreciationPolicyInfo aFADepreciationPolicyInfo = aFaCatInfo.getDepreciationPolicy();
                curCard.setAssetCat(aFaCatInfo);
                if (curCard.getOriginFlag().getValue() == 2 || curCard.getOriginFlag().getValue() == 3) {
                    IFaDepreciationMode ifaMode = FaDepreciationModeFactory.getLocalInstance((Context)ctx);
                    if (curCard.getDeprMethod() != null) {
                        FaDepreciationModeInfo faModeInfo = ifaMode.getFaDepreciationModeInfo((IObjectPK)new ObjectUuidPK(curCard.getDeprMethod().getId()));
                        curCard.setDeprMethod(faModeInfo);
                    }
                    if (curCard.getEvalDeprMode() != null) {
                        FaDepreciationModeInfo faEvalModeInfo = ifaMode.getFaDepreciationModeInfo((IObjectPK)new ObjectUuidPK(curCard.getEvalDeprMode().getId()));
                        curCard.setEvalDeprMode(faEvalModeInfo);
                    }
                }
                if (aFADepreciationPolicyInfo != null && aFADepreciationPolicyInfo.getStartDeprTime().getValue() == 0) {
                    FaCurCardCollection cards = new FaCurCardCollection();
                    cards.add(curCard);
                    if (FaDepCalFacadeFactory.getLocalInstance(ctx).isNeedDep(cards)) {
                        String newGovermentAccountingSystem;
                        curCard.setIsNeedReDepr(true);
                        Map paramMap = FaDepLocalUtils.getParamNewGovermentAccSystem(ctx);
                        String string = newGovermentAccountingSystem = paramMap.get(AccountConstant.GovermentAccountingSystem) != null ? (String)paramMap.get(AccountConstant.GovermentAccountingSystem) : "false";
                        if ("true".equalsIgnoreCase(newGovermentAccountingSystem) && curCard.getAssetCat().isNotCalDep()) {
                            curCard.setIsNeedReDepr(false);
                        }
                    }
                }
            }
        }
        IFaCurCard iFaCurCard = FaCurCardFactory.getLocalInstance(ctx);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("effectedStatus"));
        selector.add(new SelectorItemInfo("checkedStatus"));
        selector.add(new SelectorItemInfo("deletedStatus"));
        selector.add(new SelectorItemInfo("blockedStatus"));
        selector.add(new SelectorItemInfo("bizStatus"));
        selector.add(new SelectorItemInfo("hasNew"));
        selector.add(new SelectorItemInfo("fiVouchered"));
        selector.add(new SelectorItemInfo("isNeedReDepr"));
        selector.add(new SelectorItemInfo("fiAccountDate"));
        selector.add(new SelectorItemInfo("period"));
        selector.add(new SelectorItemInfo("latestPeriodAddFuture"));
        iFaCurCard.updatePartial((CoreBaseInfo)curCard, selector);
        FaBakCardInfo faBakCard = PrcFaCoreManager.CurCard2BakCard(curCard);
        faBakCard.setFaCurCard(curCard);
        if (!isAfterPeriodCard) {
            faBakCard.setPeriod(period);
        }
        faBakCard.setBillType(FaBillTypeEnum.ADDNEW);
        faBakCard.setPropertyValue(FaCardDefPropertyPersist.copy(curCard.getPropertyValue() == null ? null : curCard.getPropertyValue().getId(), ctx));
        IObjectPK bakCardPK = FaBakCardFactory.getLocalInstance(ctx).submit((CoreBaseInfo)faBakCard);
        faBakCard.setId(BOSUuid.read((String)bakCardPK.toString()));
        FaBizCardInfo faBizCard = PrcFaCoreManager.CurCard2BizCard(curCard);
        faBizCard.setFaBakCard(faBakCard);
        faBizCard.setBillType(FaBillTypeEnum.ADDNEW);
        faBizCard.setPropertyValue(FaCardDefPropertyPersist.copy(curCard.getPropertyValue() == null ? null : curCard.getPropertyValue().getId(), ctx));
        IObjectPK bizCardPK = FaBizCardFactory.getLocalInstance(ctx).submit((CoreBaseInfo)faBizCard);
        FaBalanceFacade faBalanceFacade = new FaBalanceFacade();
        faBalanceFacade.setFaBalanceUpdStrategy(new FaBalanceAddUpdStrategy());
        PeriodInfo balancePeriod = this.getCurrentPeriod(ctx, curCard);
        if (isAfterPeriodCard) {
            balancePeriod = curCard.getPeriod();
        }
        faBalanceFacade.updateFaAccountBalance(ctx, curCard, balancePeriod);
        iFaCurCard.passAuditSelf((IObjectPK)new ObjectUuidPK(curCard.getId()), curCard);
        if (!isAfterPeriodCard) {
            DbUtil.execute((Context)ctx, (String)"update t_fa_facurcard set fperiodid=? where fid=?", (Object[])new Object[]{period.getId().toString(), curCard.getId().toString()});
        } else {
            boolean isLatestPeriod = FaLocalUtils.isCurrentPeriodLatest(ctx, curCard.getCompany().getId().toString());
            if (isLatestPeriod && FaManageUtils.comparePeriods(curCard.getPeriod(), period) == 1) {
                DbUtil.execute((Context)ctx, (String)"update T_FA_FaCurCard set fLatestPeriodAddFuture = 1 where fid = ?", (Object[])new Object[]{curCard.getId().toString()});
                DbUtil.execute((Context)ctx, (String)"update T_FA_FABAKCARD set fLatestPeriodAddFuture = 1 where fid = ?", (Object[])new Object[]{faBakCard.getId().toString()});
                DbUtil.execute((Context)ctx, (String)"update T_FA_FaBizCard set fLatestPeriodAddFuture = 1 where fid = ?", (Object[])new Object[]{faBizCard.getId().toString()});
            }
        }
    }

    protected void auditBill(Context ctx, IObjectPK pk, IObjectValue bill) throws EASBizException, BOSException {
        this.auditBill(ctx, bill);
    }

    @Override
    protected void unAuditBill(Context ctx, IObjectValue bill) throws EASBizException, BOSException {
        if (bill == null) {
            throw new IllegalArgumentException();
        }
        FaCurCardInfo curCard = (FaCurCardInfo)bill;
        PeriodInfo aCurrentPeriodInfo = this.getCurrentPeriod(ctx, curCard);
        IFaCurCard iCurCard = FaCurCardFactory.getLocalInstance(ctx);
        FaCurCardCollection coll = new FaCurCardCollection();
        coll.add(curCard);
        FaBizCardCollection bakCardCol = FaBizCardFactory.getLocalInstance(ctx).getFaBizCardCollection("select id,period.id,faBakCard.deprTTerm,faBakCard.evalDeprTTerm,faBakCard.faCurCard.deprTTerm,faBakCard.faCurCard.evalDeprTTerm,faBakCard.assetCat.id,faBakCard.assetCat.DepreciationPolicy.DeprRule,faBakCard.useStatus where faBakCard.faCurCard.id='" + curCard.getId().toString() + "' and billType=" + 1);
        if (curCard.getDeprMethod() == null || !FaLocalUtils.isWellOnlyMethod((FaDepreciationModeInfo)curCard.getDeprMethod())) {
            if (FaLocalUtils.isWorkLoadMethod((FaDepreciationModeInfo)curCard.getDeprMethod())) {
                IFaWorkLoad iWorkLoad = FaWorkLoadFactory.getLocalInstance(ctx);
                EntityViewInfo view = new EntityViewInfo();
                StringBuffer sql = new StringBuffer();
                view.getSelector().add(new SelectorItemInfo("id"));
                view.getSelector().add(new SelectorItemInfo("currentWorkLoad"));
                view.getSelector().add(new SelectorItemInfo("curCard"));
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("period", (Object)aCurrentPeriodInfo.getId(), CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("company", (Object)curCard.getCompany().getId().toString(), CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("curCard", (Object)curCard.getId().toString(), CompareType.EQUALS));
                view.setFilter(filter);
                FaWorkLoadCollection workLoadCollection = iWorkLoad.getFaWorkLoadCollection(view);
                String strWorkLoadId = FaLocalUtils.getWorkloadMethodID(ctx);
                if (strWorkLoadId != null && strWorkLoadId.length() != 0) {
                    for (int i = 0; i < workLoadCollection.size(); ++i) {
                        FaWorkLoadInfo workLoad = workLoadCollection.get(i);
                        BigDecimal currentWorkLoad = workLoad.getCurrentWorkLoad();
                        if (currentWorkLoad == null || currentWorkLoad.compareTo(new BigDecimal("0")) <= 0) continue;
                        sql = new StringBuffer();
                        sql.append("update T_FA_FaCurCard set fdeprtermcount = fdeprtermcount - " + currentWorkLoad + " where fid ='" + curCard.getId().toString() + "' AND FDeprMethodID in (" + strWorkLoadId + ")");
                        DbUtil.execute((Context)ctx, (String)sql.toString());
                        sql = new StringBuffer();
                        sql.append("update T_FA_FaCurCard set fTempdeprtermcount = fTempdeprtermcount - " + currentWorkLoad + " where fid ='" + curCard.getId().toString() + "' AND FTempDeprMethod in (" + strWorkLoadId + ")");
                        DbUtil.execute((Context)ctx, (String)sql.toString());
                        sql = null;
                    }
                }
                iWorkLoad.delete(filter);
            }
            if (FaDepLocalUtils.ifAlreadyCal(ctx, aCurrentPeriodInfo, curCard.getCompany().getId().toString()) && bakCardCol != null && bakCardCol.size() > 0) {
                FaBakCardCollection bakCardCollection = new FaBakCardCollection();
                bakCardCollection.add(bakCardCol.get(0).getFaBakCard());
                IFaDepCalFacade iFaDepCalFacade = FaDepCalFacadeFactory.getLocalInstance(ctx);
                aCurrentPeriodInfo.put(IS_FROM_PRCFAADDSTRATEGY, (Object)"true");
                iFaDepCalFacade.calDepForUnAudit((IObjectValue)aCurrentPeriodInfo, (IObjectCollection)bakCardCollection);
                aCurrentPeriodInfo.remove(IS_FROM_PRCFAADDSTRATEGY);
            }
        } else {
            IFaDepCalcForCoalFacade depForCoal = FaDepCalcForCoalFacadeFactory.getLocalInstance(ctx);
            if (depForCoal.isAlreadyDep(curCard.getCompany().getId().toString(), aCurrentPeriodInfo)) {
                FaDepORMapping.partUndoDepForBalance(ctx, (IObjectValue)aCurrentPeriodInfo, (IObjectCollection)coll);
                FaDepORMapping.partUndoDepForCoalCard((IObjectValue)aCurrentPeriodInfo, (IObjectCollection)coll, curCard.getCompany().getId().toString(), true, ctx);
                FaDepCalExecutor executor = new FaDepCalExecutor();
                executor._deleteDepEntry(ctx, (IObjectValue)aCurrentPeriodInfo, (IObjectCollection)coll);
                FaDepORMapping.undoDeprCountForCoalCard((IObjectValue)aCurrentPeriodInfo, (IObjectCollection)coll, curCard.getCompany().getId().toString(), ctx);
            }
        }
        PeriodInfo lastPeriodInfo = null;
        if (bakCardCol != null && bakCardCol.size() > 0) {
            IObjectPK[] arrayBizCardPK = new IObjectPK[]{new ObjectUuidPK(bakCardCol.get(0).getId())};
            IObjectPK[] arrayBakCardPK = new IObjectPK[]{new ObjectUuidPK(bakCardCol.get(0).getFaBakCard().getId())};
            this.deleteBizBakCard(ctx, arrayBizCardPK, arrayBakCardPK, true);
            lastPeriodInfo = bakCardCol.get(0).getPeriod();
        }
        FaBalanceFacade faBalanceFacade = new FaBalanceFacade();
        faBalanceFacade.setFaBalanceUpdStrategy(new FaBalanceAddUpdStrategy());
        faBalanceFacade.rollbackFaAccountBalance(ctx, curCard, aCurrentPeriodInfo);
        iCurCard.unpassAuditSelf((IObjectPK)new ObjectUuidPK(curCard.getId()), curCard);
        if (lastPeriodInfo != null) {
            DbUtil.execute((Context)ctx, (String)"update t_fa_facurcard set fperiodid=? where fid=?", (Object[])new Object[]{lastPeriodInfo.getId().toString(), curCard.getId().toString()});
        }
        if (curCard.getSourceBillId() != null) {
            ApplicationContext applicationContext = new ApplicationContext();
            applicationContext.putData("sourceBillId", (Object)curCard.getSourceBillId());
            applicationContext.putData("sourceEntryID", (Object)curCard.getSourceBillId());
            applicationContext.putData("changeQty", (Object)curCard.getAssetAmt());
            BusinessChainExecutingHelper.batchExecute((Context)ctx, null, (BOSObjectType)BOSObjectType.create((String)"42AC39EC"), (Object[])new Object[]{curCard.getId().toString()}, (BatchActionEnum)BatchActionEnum.UNAUDIT, FaCurCardBusinessProcessorBuilder.class, (ApplicationContext)applicationContext);
        }
    }

    protected void unAuditBill(Context ctx, IObjectPK pk, IObjectValue bill) throws EASBizException, BOSException {
        this.unAuditBill(ctx, bill);
    }

    @Override
    protected void generateVourcher(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("originMethod.*"));
        IFaCurCard iFaCurCard = FaCurCardFactory.getLocalInstance(ctx);
        FaCurCardInfo curCard = iFaCurCard.getFaCurCardInfo(pk, sic);
        FaDAPFacade faDAPFacade = new FaDAPFacade();
        faDAPFacade.setFaBillDAPTransStrategy((AbstractFaDAPTransStrategy)new FaDAPCardStrategy());
        faDAPFacade.setBill((BillBaseInfo)curCard);
        faDAPFacade.generateVourcherViaDAP(ctx, DAPVoucherTypeEnum.FIVoucher);
    }

    @Override
    protected void deleteBill(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        if (pk == null) {
            throw new IllegalArgumentException();
        }
        DbUtil.execute((Context)ctx, (String)"delete from t_fa_faaccountbalance where ffacurcardid = ? ", (Object[])new Object[]{pk.toString()});
        FaCardDefPropertyPersist.deleteByCurCardPK(ctx, pk.toString());
        FaCurCardFactory.getLocalInstance(ctx).deleteSelf(pk);
    }

    @Override
    protected void checkForUnAudit(Context ctx, BillBaseInfo billInfo, boolean isFromSource) throws EASBizException, BOSException {
        StringBuffer sbHasGenVoucher = new StringBuffer(ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource", (String)"Has_GenVoucher", (Locale)ctx.getOriginLocale()));
        FaCurCardInfo curCard = (FaCurCardInfo)billInfo;
        String bookInfo = this.checkUnauditForBook(ctx, curCard);
        if (bookInfo == null) {
            bookInfo = "";
        }
        if (!(curCard.getOriginFlag() != FaCardOriginEnum.SPLIT && curCard.getOriginFlag() != FaCardOriginEnum.COMBIN || isFromSource)) {
            throw new FaCardException(FaCardException.BILL_CANNOT_OPERATE, new String[]{curCard.getNumber() + "(" + curCard.getAssetName() + ")", curCard.getOriginFlag().getAlias()});
        }
        if (curCard.getLastBillID() != null && curCard.getLastBillID().length() > 0) {
            throw new FaCardException(FaCardException.CURCARD_HASOTHEROPRATION, new String[]{curCard.getNumber() + "(" + curCard.getAssetName() + ")", bookInfo, FaLocalUtils.getEntityAlias(ctx, BOSUuid.getBOSObjectType((String)curCard.getLastBillID(), (boolean)false))});
        }
        if (FaLeaseBillEntryFactory.getLocalInstance(ctx).exists("where facurcard.id = '" + curCard.getId() + "'")) {
            throw new FaCardException(FaCardException.CURCARD_HASOTHEROPRATION, new String[]{curCard.getNumber() + "(" + curCard.getAssetName() + ")", bookInfo, FaLocalUtils.getEntityAlias(ctx, new FaLeaseBillInfo().getBOSType())});
        }
        if (FaMortagBillEntryFactory.getLocalInstance(ctx).exists("where facurcard.id = '" + curCard.getId() + "'")) {
            throw new FaCardException(FaCardException.CURCARD_HASOTHEROPRATION, new String[]{curCard.getNumber() + "(" + curCard.getAssetName() + ")", bookInfo, FaLocalUtils.getEntityAlias(ctx, new FaMortagBillInfo().getBOSType())});
        }
        if (curCard.isFiVouchered()) {
            throw new FaCardException(FaCardException.CANNOT_BE_UNAUDITED, new String[]{sbHasGenVoucher.toString(), bookInfo});
        }
        if (FaUserDefineSortEntryFactory.getLocalInstance(ctx).exists("where assetCard.id = '" + curCard.getId() + "'")) {
            StringBuffer faUserDefinedSort = new StringBuffer();
            faUserDefinedSort.append(" select sort.fname_").append(ctx.getLocale().toString()).append(" name, sort.fnumber number from T_Fa_UserDefinedSort sort ");
            faUserDefinedSort.append(" inner join T_FA_UserDefineEntry entry on entry.FUserDefineSortID = sort.FID ");
            faUserDefinedSort.append(" where entry.FAssetCardID = ? ");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)faUserDefinedSort.toString(), (Object[])new Object[]{curCard.getId().toString()});
            try {
                if (rs.next()) {
                    String faUserDefinedSortName = rs.getString("name");
                    String faUserDefinedSortNumber = rs.getString("number");
                    String faUserDefinedSortError = FaLocalUtils.getResource(ctx, "com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", "116_PrcFaAddStrategy");
                    throw new EASBizException(new NumericExceptionSubItem("1", faUserDefinedSortError), (Object[])new String[]{curCard.getNumber() + "(" + curCard.getAssetName() + ")", faUserDefinedSortNumber + "(" + faUserDefinedSortName + ")"});
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    protected String checkUnauditForBook(Context ctx, FaCurCardInfo curCard) throws EASBizException, BOSException {
        if (curCard.getCompany() == null) {
            return null;
        }
        String companyid = curCard.getCompany().getId().toString();
        String currCompanyID = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        if (currCompanyID == null) {
            return null;
        }
        if (companyid.equals(currCompanyID)) {
            return null;
        }
        CompanyOrgUnitInfo info = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyid));
        String msg = ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.TransCardResource", (String)"BOOK_HAS_BIZ", (Locale)ctx.getOriginLocale());
        msg = msg + info.getName();
        return msg;
    }
}

