/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.basedata.FaUseStatusFactory;
import com.kingdee.eas.fi.fa.basedata.FaUseStatusInfo;
import com.kingdee.eas.fi.fa.def.FaDefPropertyValueInfo;
import com.kingdee.eas.fi.fa.manage.AbstractFaCardException;
import com.kingdee.eas.fi.fa.manage.FaBakCardInfo;
import com.kingdee.eas.fi.fa.manage.FaBillOriginEnum;
import com.kingdee.eas.fi.fa.manage.FaBizCardFactory;
import com.kingdee.eas.fi.fa.manage.FaBizCardInfo;
import com.kingdee.eas.fi.fa.manage.FaBizStatusEnum;
import com.kingdee.eas.fi.fa.manage.FaCardException;
import com.kingdee.eas.fi.fa.manage.FaCardOriginEnum;
import com.kingdee.eas.fi.fa.manage.FaClearBillEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaClearBillFactory;
import com.kingdee.eas.fi.fa.manage.FaClearBillInfo;
import com.kingdee.eas.fi.fa.manage.FaClearStatusEnum;
import com.kingdee.eas.fi.fa.manage.FaCombinBillEntryCollection;
import com.kingdee.eas.fi.fa.manage.FaCombinBillEntryFactory;
import com.kingdee.eas.fi.fa.manage.FaCombinBillEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaCombinBillFactory;
import com.kingdee.eas.fi.fa.manage.FaCombinBillInfo;
import com.kingdee.eas.fi.fa.manage.FaCurCardFactory;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.fi.fa.manage.FaManageUtils;
import com.kingdee.eas.fi.fa.manage.FaMonCardFactory;
import com.kingdee.eas.fi.fa.manage.FaMonCardInfo;
import com.kingdee.eas.fi.fa.manage.IFaCombinBill;
import com.kingdee.eas.fi.fa.manage.app.AbstractPrcFaManageStrategy;
import com.kingdee.eas.fi.fa.manage.app.FaCardDefPropertyPersist;
import com.kingdee.eas.fi.fa.manage.app.FaLastPeriodChangeUtils;
import com.kingdee.eas.fi.fa.manage.app.FaLocalUtils;
import com.kingdee.eas.fi.fa.manage.app.FaStocktakingReportBillControllerBean;
import com.kingdee.eas.fi.fa.manage.app.PrcFaAddStrategy;
import com.kingdee.eas.fi.fa.manage.app.PrcFaClearStrategy;
import com.kingdee.eas.fi.fa.manage.app.PrcFaCoreManager;
import com.kingdee.eas.framework.BlockedStatusEnum;
import com.kingdee.eas.framework.CheckedStatusEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.framework.EffectedStatusEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;

public class PrcFaCombinStrategy
extends AbstractPrcFaManageStrategy {
    private static String className = "com.kingdee.eas.fi.fa.manage.FaCardResource";

    @Override
    protected IObjectPK saveBill(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        FaCombinBillInfo billInfo = this.getCombinBillInfo(ctx, model, EffectedStatusEnum.TEMPSTORE);
        billInfo.setEffectedStatus(EffectedStatusEnum.TEMPSTORE);
        IFaCombinBill combinFactory = FaCombinBillFactory.getLocalInstance(ctx);
        IObjectPK pk = combinFactory.saveSelf(billInfo);
        String updateEvaledSql = "update t_fa_fabizcard set fisevaledbefore = 1 where fid in (select bill.FFaBizCardID from t_fa_facombinbill bill inner join t_fa_facombinbillentry entry on bill.fid = entry.FFaCombinBill inner join t_fa_facurcard card on entry.fcurcardid = card.fid where bill.fid = ? and card.fisevaledbefore = 1)";
        DbUtil.execute((Context)ctx, (String)updateEvaledSql, (Object[])new Object[]{pk.toString()});
        FaCombinBillEntryCollection entryColl = billInfo.getFaCombinBillEntry();
        int size = entryColl.size();
        for (int i = 0; i < size; ++i) {
            FaCurCardInfo card = entryColl.get(i).getFaCurCard();
            if (card == null || card.getId() == null) continue;
            this.updateCurCardBySQL(ctx, FaBizStatusEnum.COMBINING.getValue(), pk.toString(), card.getId().toString());
        }
        return pk;
    }

    @Override
    protected IObjectPK submitBill(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        FaCombinBillInfo billInfo = this.getCombinBillInfo(ctx, model, EffectedStatusEnum.EFFECTED);
        FaCardDefPropertyPersist.checkRequired(ctx, (IObjectValue)billInfo.getFaBizCard());
        billInfo.setEffectedStatus(EffectedStatusEnum.EFFECTED);
        IFaCombinBill combinFactory = FaCombinBillFactory.getLocalInstance(ctx);
        IObjectPK pk = combinFactory.submitSelf(billInfo);
        String updateEvaledSql = "update t_fa_fabizcard set fisevaledbefore = 1 where fid in (select bill.FFaBizCardID from t_fa_facombinbill bill inner join t_fa_facombinbillentry entry on bill.fid = entry.FFaCombinBill inner join t_fa_facurcard card on entry.fcurcardid = card.fid where bill.fid = ? and card.fisevaledbefore = 1)";
        DbUtil.execute((Context)ctx, (String)updateEvaledSql, (Object[])new Object[]{pk.toString()});
        FaCombinBillEntryCollection entryColl = billInfo.getFaCombinBillEntry();
        int size = entryColl.size();
        for (int i = 0; i < size; ++i) {
            FaCurCardInfo card = entryColl.get(i).getFaCurCard();
            if (card == null || card.getId() == null) continue;
            this.updateCurCardBySQL(ctx, FaBizStatusEnum.COMBINING.getValue(), pk.toString(), card.getId().toString());
        }
        return pk;
    }

    private FaCombinBillInfo getCombinBillInfo(Context ctx, IObjectValue model, EffectedStatusEnum status) throws EASBizException, BOSException {
        FaCurCardInfo curCard;
        int i;
        FaCombinBillInfo billInfo = (FaCombinBillInfo)model;
        if (billInfo == null) {
            throw new IllegalArgumentException();
        }
        HashMap faParameter = FaManageUtils.getFAParameter(billInfo.getCompany().getId(), ctx);
        boolean isAutoCode = faParameter.get("FA_001") != null ? "true".equalsIgnoreCase(faParameter.get("FA_001").toString()) : true;
        boolean isUseInitCardRule = faParameter.get("FA_055") != null ? "true".equalsIgnoreCase(faParameter.get("FA_055").toString()) : true;
        boolean isUseGroupCode = faParameter.get("FA_030") != null ? "true".equalsIgnoreCase(faParameter.get("FA_030").toString()) : false;
        boolean isAutoGroupCode = faParameter.get("FA_189") != null ? "true".equalsIgnoreCase(faParameter.get("FA_189").toString()) : true;
        boolean isUseBarCode = faParameter.get("FA_043") != null ? "true".equalsIgnoreCase(faParameter.get("FA_043").toString()) : false;
        boolean isAutoBarCode = faParameter.get("FA_101") != null ? "true".equalsIgnoreCase(faParameter.get("FA_101").toString()) : true;
        FaCombinBillEntryCollection entryCollection = billInfo.getFaCombinBillEntry();
        if (billInfo.getId() != null) {
            FaBizCardInfo bizCardInfo;
            ArrayList<ObjectUuidPK> listBakCardPK = new ArrayList<ObjectUuidPK>();
            ArrayList<ObjectUuidPK> listBizCardPK = new ArrayList<ObjectUuidPK>();
            ArrayList<ObjectUuidPK> listCombinEntryPK = new ArrayList<ObjectUuidPK>();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("faCurCard.id"));
            sic.add(new SelectorItemInfo("faBizCard.id"));
            sic.add(new SelectorItemInfo("faBizCard.faBakCard.id"));
            sic.add(new SelectorItemInfo("faBizCard.faBakCard.bizStatus"));
            sic.add(new SelectorItemInfo("faBizCard.faBakCard.lastBillID"));
            sic.add(new SelectorItemInfo("faBizCard.faBakCard.faCurCard.id"));
            sic.add(new SelectorItemInfo("faCombinBillEntry.id"));
            sic.add(new SelectorItemInfo("faCombinBillEntry.faCurCard.id"));
            sic.add(new SelectorItemInfo("faCombinBillEntry.faBizCard.id"));
            sic.add(new SelectorItemInfo("faCombinBillEntry.faBizCard.faBakCard.id"));
            sic.add(new SelectorItemInfo("faCombinBillEntry.faBizCard.faBakCard.faCurCard.id"));
            sic.add(new SelectorItemInfo("faCombinBillEntry.faBizCard.faBakCard.bizStatus"));
            sic.add(new SelectorItemInfo("faCombinBillEntry.faBizCard.faBakCard.lastBillID"));
            sic.add(new SelectorItemInfo("faCombinBillEntry.faBizCard.faBakCard.lastPeriodChange"));
            sic.add(new SelectorItemInfo("faBizCard.assetValue"));
            sic.add(new SelectorItemInfo("faBizCard.number"));
            sic.add(new SelectorItemInfo("faBizCard.company.id"));
            sic.add(new SelectorItemInfo("faBizCard.effectedStatus"));
            sic.add(new SelectorItemInfo("faBizCard.assetCat.*"));
            sic.add(new SelectorItemInfo("faBizCard.measureUnit.*"));
            sic.add(new SelectorItemInfo("company.id"));
            sic.add(new SelectorItemInfo("*"));
            FaCombinBillInfo savedBillInfo = FaCombinBillFactory.getLocalInstance(ctx).getFaCombinBillInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)billInfo.getId().toString())), sic);
            FaCombinBillEntryCollection collectionSaved = savedBillInfo.getFaCombinBillEntry();
            boolean delFlag = true;
            int isize = collectionSaved.size();
            for (int i2 = 0; i2 < isize; ++i2) {
                delFlag = true;
                FaCombinBillEntryInfo entryInfoSaved = collectionSaved.get(i2);
                int jsize = entryCollection.size();
                for (int j = 0; j < jsize; ++j) {
                    FaCombinBillEntryInfo combinEntryInfo = entryCollection.get(j);
                    if (combinEntryInfo.getFaBizCard().getId() == null || !entryInfoSaved.getFaBizCard().getId().toString().equals(combinEntryInfo.getFaBizCard().getId().toString())) continue;
                    delFlag = false;
                }
                if (!delFlag || (bizCardInfo = entryInfoSaved.getFaBizCard()) == null) continue;
                FaBakCardInfo bakCardInfo = bizCardInfo.getFaBakCard();
                if (bakCardInfo != null && bakCardInfo.getId() != null) {
                    listBakCardPK.add(new ObjectUuidPK(bakCardInfo.getId()));
                }
                listBizCardPK.add(new ObjectUuidPK(bizCardInfo.getId()));
                listCombinEntryPK.add(new ObjectUuidPK(entryInfoSaved.getId()));
                FaLastPeriodChangeUtils.updateCurCardBySQL(ctx, bizCardInfo.getFaBakCard().getBizStatus().getValue(), bizCardInfo.getFaBakCard().getLastBillID(), entryInfoSaved.getFaCurCard().getId().toString(), bizCardInfo.getFaBakCard().isLastPeriodChange());
            }
            if (savedBillInfo.getFaBizCard().getId() != null && savedBillInfo.getFaBizCard() != null) {
                FaBizCardInfo oldBizCardInfo = savedBillInfo.getFaBizCard();
                bizCardInfo = billInfo.getFaBizCard();
                if (bizCardInfo.getId() != null && isAutoCode && oldBizCardInfo.getNumber() != null && !oldBizCardInfo.getNumber().equals(bizCardInfo.getNumber())) {
                    FaMonCardInfo oldMonCardInfo = PrcFaCoreManager.CurCard2MonCard(PrcFaCoreManager.BizCard2CurCard(oldBizCardInfo));
                    if (isUseInitCardRule) {
                        this.recycleNumber(ctx, oldMonCardInfo, "effectedStatus", "");
                    } else {
                        this.recycleNumber(ctx, PrcFaCoreManager.BizCard2CurCard(oldBizCardInfo), "effectedStatus", "");
                    }
                }
            }
            IObjectPK[] arrayCombinEntryPK = new IObjectPK[listCombinEntryPK.size()];
            System.arraycopy(listCombinEntryPK.toArray(), 0, arrayCombinEntryPK, 0, listCombinEntryPK.size());
            IObjectPK[] arrayBakCardPK = new IObjectPK[listBakCardPK.size()];
            System.arraycopy(listBakCardPK.toArray(), 0, arrayBakCardPK, 0, listBakCardPK.size());
            IObjectPK[] arrayBizCardPK = new IObjectPK[listBizCardPK.size()];
            System.arraycopy(listBizCardPK.toArray(), 0, arrayBizCardPK, 0, listBizCardPK.size());
            if (arrayCombinEntryPK.length > 0) {
                FaCombinBillEntryFactory.getLocalInstance(ctx).delete(arrayCombinEntryPK);
            }
            this.deleteBizBakCard(ctx, arrayBizCardPK, arrayBakCardPK, true);
        }
        HashMap<String, FaCurCardInfo> result = new HashMap<String, FaCurCardInfo>();
        FaCurCardInfo cardInfo = null;
        int size = entryCollection.size();
        for (i = 0; i < size; ++i) {
            if (entryCollection.get(i).getFaBizCard().getId() != null && entryCollection.get(i).getFaCurCard().getId().toString().equals(entryCollection.get(i).getFaBizCard().getFaBakCard().getFaCurCard().getId().toString())) continue;
            cardInfo = entryCollection.get(i).getFaCurCard();
            result.put(cardInfo.getId().toString(), cardInfo);
        }
        this.checkFaCurCardValid(ctx, result);
        size = entryCollection.size();
        for (i = 0; i < size; ++i) {
            curCard = entryCollection.get(i).getFaCurCard();
            if (entryCollection.get(i).getFaBizCard().getId() != null && entryCollection.get(i).getFaCurCard().getId().toString().equals(entryCollection.get(i).getFaBizCard().getFaBakCard().getFaCurCard().getId().toString())) continue;
            String bakCardId = this.saveBakCard(ctx, curCard.getId().toString(), 8);
            String bizCardId = this.saveBizCard(ctx, curCard.getId().toString(), bakCardId, 8);
            FaDefPropertyValueInfo curpv = curCard.getPropertyValue();
            if (curpv != null && curpv.getId() != null) {
                FaDefPropertyValueInfo bizpv = FaCardDefPropertyPersist.copy(curpv.getId(), ctx);
                FaCardDefPropertyPersist.updateBizCardPropertyId(ctx, bizCardId, bizpv.getId().toString());
                FaDefPropertyValueInfo bakpv = FaCardDefPropertyPersist.copy(curpv.getId(), ctx);
                FaCardDefPropertyPersist.updateBakCardPropertyId(ctx, bakCardId, bakpv.getId().toString());
            }
            FaBizCardInfo bizBeforeCombin = new FaBizCardInfo();
            bizBeforeCombin.setId(BOSUuid.read((String)bizCardId));
            entryCollection.get(i).setFaBizCard(bizBeforeCombin);
        }
        FaBizCardInfo objCard = billInfo.getFaBizCard();
        if (objCard != null) {
            curCard = PrcFaCoreManager.BizCard2CurCard(objCard);
            curCard.setBizDate(DateTimeUtils.truncateDate((Date)this.getCurrentPeriod(ctx, curCard).getEndDate()));
            FaMonCardInfo mondCard = null;
            if (isUseInitCardRule) {
                mondCard = PrcFaCoreManager.CurCard2MonCard(curCard);
            }
            if (objCard.getId() == null) {
                if (isAutoCode) {
                    if (isUseInitCardRule) {
                        FaLocalUtils.setNewCardNumber(ctx, mondCard);
                        curCard.setNumber(mondCard.getNumber());
                    } else {
                        FaLocalUtils.setNewCardNumber(ctx, curCard);
                    }
                }
                if (isUseGroupCode && isAutoGroupCode) {
                    FaLocalUtils.setNewGroupNumber(ctx, curCard);
                }
                if (isUseBarCode && isAutoBarCode) {
                    FaLocalUtils.setNewBarCode(ctx, curCard);
                }
            }
            curCard.put("ID_KEY", billInfo.getId());
            if (objCard.getNumber() != null && !"".equals(objCard.getNumber())) {
                if (isUseInitCardRule) {
                    FaMonCardFactory.getLocalInstance(ctx).checkNumberDup(null, (CoreBillBaseInfo)mondCard);
                } else {
                    FaCurCardFactory.getLocalInstance(ctx).checkNumberDup(null, (CoreBillBaseInfo)curCard);
                }
            }
            objCard.setNumber(curCard.getNumber());
            objCard.setGroupNumber(curCard.getGroupNumber());
            objCard.setBarCode(curCard.getBarCode());
            objCard.setIsEvaledBefore(false);
            FaCardDefPropertyPersist.save(objCard, ctx);
            FaBizCardFactory.getLocalInstance(ctx).submit((CoreBaseInfo)objCard);
        }
        billInfo.setCombinDate(DateTimeUtils.truncateDate((Date)billInfo.getCombinDate()));
        billInfo.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
        billInfo.setFiVouchered(false);
        billInfo.setPeriod(this.getCurrentPeriod(ctx, billInfo));
        billInfo.setBizDate(DateTimeUtils.truncateDate((Date)this.getCurrentPeriod(ctx, billInfo).getEndDate()));
        if (billInfo.getId() == null) {
            PrcFaCombinStrategy.setBillInfoNumber(ctx, billInfo, FaCombinBillFactory.getLocalInstance(ctx));
        }
        return billInfo;
    }

    @Override
    protected void auditBill(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        StringBuffer sql;
        FaCurCardInfo curCardInfoNew;
        FaCombinBillEntryInfo combinBillEntry;
        FaCombinBillInfo billInfo = (FaCombinBillInfo)model;
        if (billInfo == null) {
            throw new IllegalArgumentException();
        }
        FaCombinBillEntryCollection collection = billInfo.getFaCombinBillEntry();
        if (collection == null) {
            return;
        }
        FaClearBillInfo clearBill = new FaClearBillInfo();
        clearBill.setId(billInfo.getId());
        clearBill.setCompany(billInfo.getCompany());
        clearBill.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
        clearBill.setDeletedStatus(DeletedStatusEnum.NORMAL);
        clearBill.setBlockedStatus(BlockedStatusEnum.UNBLOCKED);
        clearBill.setBillType(FaBillOriginEnum.FROM_COMBIN);
        clearBill.setSourceBillId(billInfo.getId().toString());
        clearBill.setPeriod(this.getCurrentPeriod(ctx, billInfo));
        BigDecimal sumCardDeprTTerm = new BigDecimal(0);
        for (int i = 0; i < collection.size(); ++i) {
            combinBillEntry = collection.get(i);
            FaBizCardInfo bizCard = combinBillEntry.getFaBizCard();
            FaCurCardInfo curCard = combinBillEntry.getFaCurCard();
            if (bizCard == null) continue;
            sumCardDeprTTerm = sumCardDeprTTerm.add(curCard.getDeprTTerm());
            FaClearBillEntryInfo clearEntryInfo = new FaClearBillEntryInfo();
            clearEntryInfo.setClrQty(curCard.getAssetAmt());
            BigDecimal accuDepr = curCard.getAccuDepr();
            if (this.getDeprtime(ctx, curCard.getId().toString()) == 0) {
                accuDepr = accuDepr.subtract(curCard.getDeprTTerm());
            }
            clearEntryInfo.setClrAddupDep(curCard.getAccuDepr() == null ? ZERO : accuDepr);
            clearEntryInfo.setClrEvalValue(curCard.getInitEvalValue() == null ? ZERO : curCard.getInitEvalValue());
            clearEntryInfo.setClrDecPrep(curCard.getDecValue() == null ? ZERO : curCard.getDecValue());
            clearEntryInfo.setClrOriginal(curCard.getAssetValue() == null ? ZERO : curCard.getAssetValue());
            clearEntryInfo.setBizCard(bizCard);
            clearEntryInfo.setCurCard(curCard);
            clearBill.getClearBillEntry().add(clearEntryInfo);
        }
        clearBill.setClearMode(billInfo.getClearMode());
        clearBill.setClearDate(billInfo.getCombinDate());
        String description = ResourceBase.getString((String)className, (String)"FaCombinBillEditUI_Description2", (Locale)ctx.getOriginLocale());
        clearBill.setDescription(description);
        clearBill.setHandler(billInfo.getHandler());
        clearBill.setAuditor(billInfo.getAuditor());
        clearBill.setBizDate(DateTimeUtils.truncateDate((Date)this.getCurrentPeriod(ctx, clearBill).getEndDate()));
        PrcFaCombinStrategy.setBillInfoNumber(ctx, clearBill, FaClearBillFactory.getLocalInstance(ctx));
        PrcFaCoreManager prcFaClearManager = new PrcFaCoreManager(new PrcFaClearStrategy());
        clearBill.put(FaStocktakingReportBillControllerBean.IS_FROM_STOCK_TAKING_REPORT_BILL, "true");
        prcFaClearManager.getFaManageStrategy().auditBill(ctx, (IObjectValue)clearBill);
        clearBill.setId(null);
        FaClearBillFactory.getLocalInstance(ctx).submitNoWorkFlow((IObjectValue)clearBill);
        billInfo.setFaClearBill(clearBill);
        for (int i = 0; i < collection.size(); ++i) {
            combinBillEntry = collection.get(i);
            curCardInfoNew = combinBillEntry.getFaCurCard();
            curCardInfoNew.setId(combinBillEntry.getFaCurCard().getId());
            curCardInfoNew.setBizStatus(FaBizStatusEnum.HAVE_COMBINED);
            curCardInfoNew.setHasCleared(FaClearStatusEnum.HasAllCleared);
            curCardInfoNew.setLastBillID(billInfo.getId().toString());
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("bizStatus"));
            selector.add(new SelectorItemInfo("deleteStatus"));
            selector.add(new SelectorItemInfo("hasCleared"));
            selector.add(new SelectorItemInfo("lastBillID"));
            FaCurCardFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)curCardInfoNew, selector);
            FaBizCardInfo tmpBizCard = combinBillEntry.getFaBizCard();
            if (this.getDeprtime(ctx, curCardInfoNew.getId().toString()) != 0) continue;
            BigDecimal tempDeprTTerm = curCardInfoNew.getDeprTTerm();
            sql = new StringBuffer();
            sql.append("update T_FA_FaBizCard  set FAccuDepr=" + tmpBizCard.getAccuDepr().subtract(tempDeprTTerm) + ",FAccuDeprTYear=" + tmpBizCard.getAccuDeprTYear().subtract(tempDeprTTerm) + " where fid='" + tmpBizCard.getId().toString() + "'");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        PrcFaCoreManager prcFaCoreManager = new PrcFaCoreManager(new PrcFaAddStrategy());
        FaBizCardInfo bizCardInfo = billInfo.getFaBizCard();
        bizCardInfo = FaBizCardFactory.getLocalInstance(ctx).getFaBizCardInfo((IObjectPK)new ObjectUuidPK(bizCardInfo.getId().toString()), PrcFaCoreManager.getBizCardSelectors());
        curCardInfoNew = PrcFaCoreManager.BizCard2CurCard(bizCardInfo);
        if (bizCardInfo.getPropertyValue() != null) {
            FaDefPropertyValueInfo pv = FaCardDefPropertyPersist.copy(bizCardInfo.getPropertyValue().getId(), ctx);
            curCardInfoNew.setPropertyValue(pv);
        }
        if (curCardInfoNew.getUseStatus() != null) {
            FaUseStatusInfo useStatusInfo = FaUseStatusFactory.getLocalInstance((Context)ctx).getFaUseStatusInfo((IObjectPK)new ObjectUuidPK(curCardInfoNew.getUseStatus().getId()));
            curCardInfoNew.setUseStatus(useStatusInfo);
        }
        if (FaLocalUtils.existCardNumber(ctx, (IObjectValue)curCardInfoNew)) {
            throw new AbstractFaCardException(AbstractFaCardException.DUPLICATECARDNUMBER);
        }
        curCardInfoNew.setOriginFlag(FaCardOriginEnum.COMBIN);
        curCardInfoNew.setSourceBillId(billInfo.getId().toString());
        curCardInfoNew.setVoucher(null);
        curCardInfoNew.setVoucherNumber(null);
        curCardInfoNew.setVoucherAbstract(null);
        prcFaCoreManager.getFaManageStrategy().submitBill(ctx, (IObjectValue)curCardInfoNew);
        if (this.getDeprtime(ctx, curCardInfoNew.getId().toString()) == 0) {
            BigDecimal deprValue = curCardInfoNew.getAccuDepr().subtract(sumCardDeprTTerm);
            BigDecimal DeprTermCount = curCardInfoNew.getDeprTermCount().subtract(new BigDecimal("1"));
            DeprTermCount = deprValue.compareTo(ZERO) <= 0 ? ZERO : (DeprTermCount.compareTo(ZERO) < 0 ? ZERO : DeprTermCount);
            BigDecimal deprYearValue = curCardInfoNew.getAccuDeprTYear().subtract(sumCardDeprTTerm);
            curCardInfoNew.setAccuDepr(deprValue);
            curCardInfoNew.setAccuDeprTYear(deprYearValue);
            BigDecimal exRate = curCardInfoNew.getExRate();
            BigDecimal neatDeprValue = deprValue.multiply(exRate);
            int scale = curCardInfoNew.getAssetValue().scale();
            BigDecimal FNeatValue = curCardInfoNew.getAssetValue().subtract(this.formatBigDecmal(neatDeprValue, scale));
            BigDecimal FNeatAmt = curCardInfoNew.getAssetValue().subtract(neatDeprValue).subtract(curCardInfoNew.getDecValue());
            BigDecimal FAccuDeprAll = deprValue;
            sql = new StringBuffer();
            sql.append("update T_FA_FaCurCard  set FDeprTermCount=" + DeprTermCount + ",FAccuDepr=" + deprValue + ",FAccuDeprTYear=" + deprYearValue + ",FAccuDeprChg=" + deprValue + ",FAccuDeprAccuChg=" + deprValue + ",FAccuDeprChgTyear=" + deprYearValue + ",FAccuDeprAccuChgTyear=" + deprYearValue + ",FNeatValue=" + FNeatValue + ",FNeatAmt=" + FNeatAmt + ",FAccuDeprAll=" + FAccuDeprAll + " where fid='" + curCardInfoNew.getId().toString() + "'");
            DbUtil.execute((Context)ctx, (String)sql.toString());
            sql = new StringBuffer();
            sql.append("update T_FA_FaBizCard  set FDeprTermCount=" + DeprTermCount + ",FAccuDepr=" + deprValue + ",FAccuDeprTYear=" + deprYearValue + ",FAccuDeprChg=" + deprValue + ",FAccuDeprAccuChg=" + deprValue + ",FAccuDeprChgTyear=" + deprYearValue + ",FAccuDeprAccuChgTyear=" + deprYearValue + ",FAccuDeprAll=" + FAccuDeprAll + " where fid='" + bizCardInfo.getId().toString() + "'");
            DbUtil.execute((Context)ctx, (String)sql.toString());
            sql = new StringBuffer();
            sql.append("update T_FA_FABAKCARD  set FDeprTermCount=" + DeprTermCount + ",FAccuDepr=" + deprValue + ",FAccuDeprTYear=" + deprYearValue + ",FAccuDeprChg=" + deprValue + ",FAccuDeprAccuChg=" + deprValue + ",FAccuDeprChgTyear=" + deprYearValue + ",FAccuDeprAccuChgTyear=" + deprYearValue + ",FNeatValue=" + FNeatValue + ",FNeatAmt=" + FNeatAmt + ",FAccuDeprAll=" + FAccuDeprAll + " where ffacurcardid='" + curCardInfoNew.getId().toString() + "'");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        prcFaCoreManager.getFaManageStrategy().auditBill(ctx, (IObjectValue)curCardInfoNew);
        billInfo.setFaCurCard(curCardInfoNew);
        billInfo.setCheckedStatus(CheckedStatusEnum.AUDITED);
        billInfo.setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
        billInfo.setAuditTime(new Date());
        IFaCombinBill icombin = FaCombinBillFactory.getLocalInstance(ctx);
        icombin.update((IObjectPK)new ObjectUuidPK(billInfo.getId()), (CoreBaseInfo)billInfo);
        icombin.passAuditSelf((IObjectPK)new ObjectUuidPK(billInfo.getId()), billInfo);
    }

    private int getDeprtime(Context ctx, String curCardId) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT fstartdeprtime FROM t_fa_facurcard e INNER JOIN t_fa_cat g ON g.fid = e.fassetcatid INNER JOIN t_fa_depreciationpolicy h ");
        sql.append(" ON g.fdepreciationpolicyid = h.fid where e.fid = '" + curCardId + "'");
        IRowSet result = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        int deprtime = 0;
        try {
            while (result.next()) {
                deprtime = result.getInt("fstartdeprtime");
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return deprtime;
    }

    @Override
    protected void unAuditBill(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        FaBizCardInfo bizCard;
        FaCombinBillInfo billInfo = (FaCombinBillInfo)model;
        if (billInfo == null) {
            throw new IllegalArgumentException();
        }
        FaCombinBillEntryCollection collection = billInfo.getFaCombinBillEntry();
        if (collection == null) {
            return;
        }
        StringBuffer sbHasGenVoucher = new StringBuffer(ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource", (String)"Has_GenVoucher", (Locale)ctx.getOriginLocale()));
        FaClearBillInfo clearBill = FaClearBillFactory.getLocalInstance(ctx).getFaClearBillInfo((IObjectPK)new ObjectUuidPK(billInfo.getFaClearBill().getId()), new SelectorItemCollection());
        if (billInfo.getFaClearBill().isFiVouchered()) {
            throw new FaCardException(FaCardException.CANNOT_BE_UNAUDITED, new String[]{"", sbHasGenVoucher.toString()});
        }
        FaCurCardInfo objCurCardInfo = billInfo.getFaCurCard();
        int deprtime = 0;
        deprtime = this.getDeprtime(ctx, objCurCardInfo.getId().toString());
        billInfo.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
        billInfo.setAuditor(null);
        billInfo.setAuditTime(null);
        billInfo.setFaClearBill(null);
        billInfo.setFaCurCard(null);
        FaCombinBillFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(billInfo.getId()), (CoreBaseInfo)billInfo);
        PrcFaCoreManager prcFaCoreManager = new PrcFaCoreManager(new PrcFaAddStrategy());
        HashMap faParameter = FaManageUtils.getFAParameter(billInfo.getCompany().getId(), ctx);
        boolean isAutoCode = faParameter.get("FA_001") != null ? "true".equalsIgnoreCase(faParameter.get("FA_001").toString()) : true;
        boolean isUseInitCardRule = faParameter.get("FA_055") != null ? "true".equalsIgnoreCase(faParameter.get("FA_055").toString()) : true;
        prcFaCoreManager.getFaManageStrategy().getTempParam().put("FROM_SOURCE", Boolean.TRUE);
        prcFaCoreManager.getFaManageStrategy().checkForUnAudit(ctx, (IObjectPK)new ObjectUuidPK(objCurCardInfo.getId()));
        prcFaCoreManager.getFaManageStrategy().unAuditBill(ctx, (IObjectValue)objCurCardInfo);
        prcFaCoreManager.getFaManageStrategy().deleteBill(ctx, (IObjectPK)new ObjectUuidPK(objCurCardInfo.getId()));
        if (isAutoCode) {
            if (isUseInitCardRule) {
                this.setNumber(ctx, PrcFaCoreManager.CurCard2MonCard(objCurCardInfo), "effectedStatus", "");
            } else {
                this.setNumber(ctx, objCurCardInfo, "effectedStatus", "");
            }
        }
        PrcFaCoreManager prcFaClearManager = new PrcFaCoreManager(new PrcFaClearStrategy());
        prcFaClearManager.getFaManageStrategy().getTempParam().put("FROM_SOURCE", Boolean.TRUE);
        prcFaClearManager.getFaManageStrategy().checkForUnAudit(ctx, (IObjectPK)new ObjectUuidPK(clearBill.getId()));
        prcFaClearManager.getFaManageStrategy().unAuditBill(ctx, (IObjectValue)clearBill);
        this.recycleNumber(ctx, clearBill);
        FaClearBillFactory.getLocalInstance(ctx).deleteSelf((IObjectPK)new ObjectUuidPK(clearBill.getId()));
        BigDecimal sumDeprTTerm = new BigDecimal(0);
        StringBuffer sql = new StringBuffer();
        for (int i = 0; i < collection.size(); ++i) {
            FaCombinBillEntryInfo combinBillEntry = collection.get(i);
            bizCard = combinBillEntry.getFaBizCard();
            FaCurCardInfo curCardInfoNew = FaCurCardFactory.getLocalInstance(ctx).getFaCurCardInfo((IObjectPK)new ObjectUuidPK(combinBillEntry.getFaCurCard().getId().toString()));
            curCardInfoNew.setId(combinBillEntry.getFaCurCard().getId());
            if (this.getDeprtime(ctx, curCardInfoNew.getId().toString()) == 0) {
                BigDecimal deprTTerm = curCardInfoNew.getDeprTTerm();
                sumDeprTTerm = sumDeprTTerm.add(deprTTerm);
                BigDecimal deprValue = bizCard.getAccuDepr().add(deprTTerm);
                BigDecimal deprYearValue = bizCard.getAccuDeprTYear().add(deprTTerm);
                sql.append("update T_FA_FaBizCard  set FAccuDepr=" + deprValue + ",FAccuDeprTYear=" + deprYearValue + ",FAccuDeprChg=" + deprValue + ",FAccuDeprAccuChg=" + deprValue + ",FAccuDeprChgTyear=" + deprYearValue + ",FAccuDeprAccuChgTyear=" + deprYearValue + " where fid='" + bizCard.getId().toString() + "'");
                DbUtil.execute((Context)ctx, (String)sql.toString());
            }
            curCardInfoNew.setBizStatus(FaBizStatusEnum.COMBINING);
            curCardInfoNew.setLastBillID(billInfo.getId().toString());
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("bizStatus"));
            selector.add(new SelectorItemInfo("deleteStatus"));
            selector.add(new SelectorItemInfo("hasCleared"));
            selector.add(new SelectorItemInfo("lastBillID"));
            FaCurCardFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)curCardInfoNew, selector);
        }
        if (deprtime == 0) {
            bizCard = billInfo.getFaBizCard();
            sql = new StringBuffer();
            BigDecimal FAccuDeprAll = bizCard.getAccuDepr().add(sumDeprTTerm);
            BigDecimal DeprTermCount = bizCard.getDeprTermCount().add(new BigDecimal("1"));
            sql.append("update T_FA_FaBizCard  set FDeprTermCount=" + DeprTermCount + ",FAccuDepr=" + bizCard.getAccuDepr().add(sumDeprTTerm) + ",FAccuDeprTYear=" + bizCard.getAccuDeprTYear().add(sumDeprTTerm) + ",FAccuDeprAll=" + FAccuDeprAll + " where fid='" + bizCard.getId().toString() + "'");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        FaCombinBillFactory.getLocalInstance(ctx).unpassAuditSelf((IObjectPK)new ObjectUuidPK(billInfo.getId()), billInfo);
    }

    @Override
    protected void generateVourcher(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
    }

    @Override
    protected void deleteBill(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        if (pk == null) {
            return;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("faCombinBillEntry.id"));
        sic.add(new SelectorItemInfo("faCombinBillEntry.faCurCard.id"));
        sic.add(new SelectorItemInfo("faCombinBillEntry.faBizCard.faBakCard.id"));
        sic.add(new SelectorItemInfo("faCombinBillEntry.faBizCard.faBakCard.bizStatus"));
        sic.add(new SelectorItemInfo("faCombinBillEntry.faBizCard.faBakCard.lastBillID"));
        sic.add(new SelectorItemInfo("faCombinBillEntry.faBizCard.faBakCard.lastPeriodChange"));
        sic.add(new SelectorItemInfo("faCombinBillEntry.faBizCard.id"));
        sic.add(new SelectorItemInfo("faBizCard.faBakCard.id"));
        sic.add(new SelectorItemInfo("faBizCard.faBakCard.bizStatus"));
        sic.add(new SelectorItemInfo("faBizCard.faBakCard.lastBillID"));
        sic.add(new SelectorItemInfo("faBizCard.id"));
        sic.add(new SelectorItemInfo("faBizCard.assetValue"));
        sic.add(new SelectorItemInfo("faBizCard.assetCat.numberRule"));
        sic.add(new SelectorItemInfo("faBizCard.company.id"));
        sic.add(new SelectorItemInfo("faBizCard.number"));
        sic.add(new SelectorItemInfo("faBizCard.effectedStatus"));
        sic.add(new SelectorItemInfo("faCurCard.id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("company.id"));
        FaCombinBillInfo billInfo = FaCombinBillFactory.getLocalInstance(ctx).getFaCombinBillInfo(pk, sic);
        HashMap faParameter = FaManageUtils.getFAParameter(billInfo.getCompany().getId(), ctx);
        boolean isAutoCode = faParameter.get("FA_001") != null ? "true".equalsIgnoreCase(faParameter.get("FA_001").toString()) : true;
        boolean isUseInitCardRule = faParameter.get("FA_055") != null ? "true".equalsIgnoreCase(faParameter.get("FA_055").toString()) : true;
        boolean useGroupNumber = faParameter.get("FA_030") != null ? "true".equalsIgnoreCase(faParameter.get("FA_030").toString()) : true;
        boolean autoGroupNumber = faParameter.get("FA_189") != null ? "true".equalsIgnoreCase(faParameter.get("FA_189").toString()) : true;
        FaCombinBillEntryCollection collection = billInfo.getFaCombinBillEntry();
        IObjectPK[] arrayBakCardPK = new IObjectPK[collection.size()];
        IObjectPK[] arrayBizCardPK = new IObjectPK[collection.size() + 1];
        FaBizCardInfo bizCardInfo = billInfo.getFaBizCard();
        if (bizCardInfo.getId() != null) {
            bizCardInfo = FaBizCardFactory.getLocalInstance(ctx).getFaBizCardInfo((IObjectPK)new ObjectUuidPK(billInfo.getFaBizCard().getId()));
        }
        if (billInfo.getFaBizCard() != null) {
            arrayBizCardPK[0] = new ObjectUuidPK(billInfo.getFaBizCard().getId());
        }
        if (isAutoCode && billInfo.getFaBizCard().getAssetValue() != null && billInfo.getFaBizCard().getAssetValue().compareTo(new BigDecimal("0.0")) >= 0) {
            if (isUseInitCardRule) {
                this.recycleNumber(ctx, PrcFaCoreManager.CurCard2MonCard(PrcFaCoreManager.BizCard2CurCard(billInfo.getFaBizCard())), "effectedStatus", "");
            } else {
                this.recycleNumber(ctx, PrcFaCoreManager.BizCard2CurCard(billInfo.getFaBizCard()), "effectedStatus", "");
            }
        }
        if (useGroupNumber && autoGroupNumber) {
            this.recycleGroupNumber(ctx, PrcFaCoreManager.BizCard2CurCard(bizCardInfo), "groupNumberStatus", "");
        }
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            FaCombinBillEntryInfo combinBillEntry = collection.get(i);
            arrayBizCardPK[i + 1] = new ObjectUuidPK(combinBillEntry.getFaBizCard().getId());
            FaBakCardInfo bakCardInfo = combinBillEntry.getFaBizCard().getFaBakCard();
            if (bakCardInfo == null) continue;
            arrayBakCardPK[i] = new ObjectUuidPK(bakCardInfo.getId());
            FaLastPeriodChangeUtils.updateCurCardBySQL(ctx, combinBillEntry.getFaBizCard().getFaBakCard().getBizStatus().getValue(), combinBillEntry.getFaBizCard().getFaBakCard().getLastBillID(), combinBillEntry.getFaCurCard().getId().toString(), combinBillEntry.getFaBizCard().getFaBakCard().isLastPeriodChange());
        }
        this.recycleNumber(ctx, billInfo);
        FaCombinBillFactory.getLocalInstance(ctx).deleteSelf(pk);
        this.deleteBizBakCard(ctx, arrayBizCardPK, arrayBakCardPK, true);
    }

    private BigDecimal formatBigDecmal(BigDecimal data, int scale) {
        if (data == null || data.compareTo(ZERO) == 0) {
            data = ZERO;
        }
        return data.setScale(scale, 4);
    }
}

