/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.def.FaDefPropertyValueInfo;
import com.kingdee.eas.fi.fa.manage.DateUnitEnum;
import com.kingdee.eas.fi.fa.manage.FALeaseContractCollection;
import com.kingdee.eas.fi.fa.manage.FALeaseContractFactory;
import com.kingdee.eas.fi.fa.manage.FALeaseContractInfo;
import com.kingdee.eas.fi.fa.manage.FaBakCardFactory;
import com.kingdee.eas.fi.fa.manage.FaBakCardInfo;
import com.kingdee.eas.fi.fa.manage.FaBillBaseEntityInfo;
import com.kingdee.eas.fi.fa.manage.FaBillOriginEnum;
import com.kingdee.eas.fi.fa.manage.FaBillTypeEnum;
import com.kingdee.eas.fi.fa.manage.FaBizCardInfo;
import com.kingdee.eas.fi.fa.manage.FaBizStatusEnum;
import com.kingdee.eas.fi.fa.manage.FaCardException;
import com.kingdee.eas.fi.fa.manage.FaChangeBillEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaChangeBillFactory;
import com.kingdee.eas.fi.fa.manage.FaChangeBillInfo;
import com.kingdee.eas.fi.fa.manage.FaClearBillEntryCollection;
import com.kingdee.eas.fi.fa.manage.FaClearBillEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaClearBillException;
import com.kingdee.eas.fi.fa.manage.FaClearBillFactory;
import com.kingdee.eas.fi.fa.manage.FaClearBillInfo;
import com.kingdee.eas.fi.fa.manage.FaCurCardFactory;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.fi.fa.manage.FaLeaseBalanceBillFactory;
import com.kingdee.eas.fi.fa.manage.FaLeaseBalanceOutEntryCollection;
import com.kingdee.eas.fi.fa.manage.FaLeaseBalanceOutEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaLeaseBillEntryCollection;
import com.kingdee.eas.fi.fa.manage.FaLeaseBillEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaLeaseBillFactory;
import com.kingdee.eas.fi.fa.manage.FaLeaseBillInfo;
import com.kingdee.eas.fi.fa.manage.FaLeaseException;
import com.kingdee.eas.fi.fa.manage.FaLeaseStatusEnum;
import com.kingdee.eas.fi.fa.manage.IFALeaseContract;
import com.kingdee.eas.fi.fa.manage.IFaChangeBill;
import com.kingdee.eas.fi.fa.manage.IFaLeaseBill;
import com.kingdee.eas.fi.fa.manage.LeaseBizStatusEnum;
import com.kingdee.eas.fi.fa.manage.app.AbstractPrcFaManageStrategy;
import com.kingdee.eas.fi.fa.manage.app.FaCardDefPropertyPersist;
import com.kingdee.eas.fi.fa.manage.app.FaLastPeriodChangeUtils;
import com.kingdee.eas.fi.fa.manage.app.FaLocalUtils;
import com.kingdee.eas.fi.fa.manage.app.PrcFaChangeStrategy;
import com.kingdee.eas.fi.fa.manage.app.PrcFaClearStrategy;
import com.kingdee.eas.fi.fa.manage.app.PrcFaCoreManager;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.BlockedStatusEnum;
import com.kingdee.eas.framework.CheckedStatusEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.framework.EffectedStatusEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class PrcFaLeasStrategy
extends AbstractPrcFaManageStrategy {
    private static final String RES_PATH = "com.kingdee.eas.fi.fa.manage.FaLeaseResource";
    private static final String WORK_NUMBER = "001";
    private static final String FINANCING_NUMBER = "002";

    @Override
    protected void deleteBill(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        if (pk == null) {
            return;
        }
        IFaLeaseBill iFaLeaseBill = FaLeaseBillFactory.getLocalInstance(ctx);
        FaLeaseBillInfo billInfo = iFaLeaseBill.getFaLeaseBillInfo("select id,number,company where id ='" + pk + "'");
        if (billInfo == null) {
            return;
        }
        FaLastPeriodChangeUtils.restoreBakAndCleanUp(ctx, (CoreBaseInfo)billInfo, new String[]{"fbizstatus", "flastbillid"}, null);
        this.recycleNumber(ctx, billInfo);
        iFaLeaseBill.deleteSelf(pk);
    }

    @Override
    protected IObjectPK saveBill(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        return this.innerSaveBill(ctx, (FaLeaseBillInfo)model, false);
    }

    @Override
    protected IObjectPK submitBill(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        return this.innerSaveBill(ctx, (FaLeaseBillInfo)model, true);
    }

    @Override
    protected void auditBill(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        FaLeaseBillInfo leaseInfo = (FaLeaseBillInfo)model;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("faLeaseType.number"));
        sic.add(new SelectorItemInfo("faLeaseBillEntry.*"));
        leaseInfo = FaLeaseBillFactory.getLocalInstance(ctx).getFaLeaseBillInfo((IObjectPK)new ObjectUuidPK(leaseInfo.getId()), sic);
        if (!LeaseBizStatusEnum.RELETING.equals((Object)leaseInfo.getBizStatus())) {
            int leaseStatus = 0;
            if (WORK_NUMBER.equals(leaseInfo.getFaLeaseType().getNumber())) {
                leaseStatus = 1;
            } else if (FINANCING_NUMBER.equals(leaseInfo.getFaLeaseType().getNumber())) {
                leaseStatus = 2;
            }
            this.updateCurCardStatus(ctx, leaseInfo.getId(), "1199", 0);
            FaLeaseBillEntryCollection coll = leaseInfo.getFaLeaseBillEntry();
            IFaChangeBill iFaChangeBill = FaChangeBillFactory.getLocalInstance(ctx);
            for (int i = 0; i < coll.size(); ++i) {
                FaLeaseBillEntryInfo entryInfo = coll.get(i);
                FaChangeBillInfo billInfo = this.createChangeBillInfo(ctx, leaseInfo, entryInfo, false);
                IObjectPK pk = iFaChangeBill.save((CoreBaseInfo)billInfo);
                this.updateEntryChangeBillID(ctx, entryInfo.getId(), pk);
            }
            this.updateCurCardStatus(ctx, leaseInfo.getId(), "1199", leaseStatus);
        }
        if (!LeaseBizStatusEnum.RELETING.equals((Object)leaseInfo.getBizStatus())) {
            this.updateLeaseBillStatus(ctx, leaseInfo.getId(), 2);
        }
        FaLeaseBillFactory.getLocalInstance(ctx).passAuditSelf((IObjectPK)new ObjectUuidPK(leaseInfo.getId()), leaseInfo);
    }

    protected void getBack(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        FaLeaseBillInfo leaseInfo = FaLeaseBillFactory.getLocalInstance(ctx).getFaLeaseBillInfo((IObjectPK)new ObjectUuidPK(billID));
        this.checkAtTermStatus(ctx, leaseInfo, false);
        this.updateCurCardStatus(ctx, leaseInfo.getId(), 0);
        FaLeaseBillEntryCollection coll = leaseInfo.getFaLeaseBillEntry();
        IFaChangeBill iFaChangeBill = FaChangeBillFactory.getLocalInstance(ctx);
        for (int i = 0; i < coll.size(); ++i) {
            FaLeaseBillEntryInfo entryInfo = coll.get(i);
            FaChangeBillInfo billInfo = this.createChangeBillInfo(ctx, leaseInfo, entryInfo, true);
            IObjectPK pk = iFaChangeBill.save((CoreBaseInfo)billInfo);
            this.updateEntryReturnChangeBillID(ctx, entryInfo.getId(), pk);
        }
        this.updateLeaseBillStatus(ctx, billID, 5);
    }

    protected void sale(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("leaseType.number"));
        selector.add(new SelectorItemInfo("faLeaseBillEntry.faCurCard.id"));
        selector.add(new SelectorItemInfo("faLeaseBillEntry.faCurCard.assetAmt"));
        selector.add(new SelectorItemInfo("faLeaseBillEntry.faCurCard.assetValue"));
        selector.add(new SelectorItemInfo("faLeaseBillEntry.faCurCard.accuDepr"));
        selector.add(new SelectorItemInfo("faLeaseBillEntry.faCurCard.decValue"));
        selector.add(new SelectorItemInfo("faLeaseBillEntry.faCurCard.lastUpdateTime"));
        FaLeaseBillInfo billInfo = FaLeaseBillFactory.getLocalInstance(ctx).getFaLeaseBillInfo((IObjectPK)new ObjectUuidPK(billID), selector);
        this.checkAtTermStatus(ctx, billInfo, true);
        this.updateCurCardStatus(ctx, billInfo.getId(), 0);
        if (WORK_NUMBER.equals(billInfo.getFaLeaseType().getNumber())) {
            throw new FaLeaseException(FaLeaseException.WORKLEASEINCANTBUY);
        }
        FaClearBillInfo clearBillInfo = this.createClearBillInfo(ctx, billInfo);
        IObjectPK pk = FaClearBillFactory.getLocalInstance(ctx).save((CoreBaseInfo)clearBillInfo);
        this.setClearBillID(ctx, billID, pk);
        this.updateLeaseBillStatus(ctx, billID, 5);
    }

    protected BillBaseInfo relet(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        IFaLeaseBill iLeaseBill = FaLeaseBillFactory.getLocalInstance(ctx);
        FaLeaseBillInfo billInfo = iLeaseBill.getFaLeaseBillInfo((IObjectPK)new ObjectUuidPK(billID));
        this.checkAtTermStatus(ctx, billInfo, true);
        this.updateLeaseBillStatus(ctx, billID, 5);
        IFALeaseContract iFALeaseContract = FALeaseContractFactory.getLocalInstance(ctx);
        FALeaseContractCollection leaseContCollection = iFALeaseContract.getFALeaseContractCollection("select * where number ='" + billInfo.getBargainNum() + "' and company.id = '" + billInfo.getCompany().getId().toString() + "'");
        if (leaseContCollection == null || leaseContCollection.size() == 0) {
            FaLeaseBillInfo leaseBillInfo = this.getReletLeaseBillInfo(ctx, billInfo);
            leaseBillInfo.setSourceBillId(billID.toString());
            iLeaseBill.save((CoreBaseInfo)leaseBillInfo);
            return leaseBillInfo;
        }
        FALeaseContractInfo reletLeaseContInfo = this.getReletContractInfo(ctx, leaseContCollection.get(0));
        reletLeaseContInfo.setSourceBillId(billID.toString());
        iFALeaseContract.save((CoreBaseInfo)reletLeaseContInfo);
        return reletLeaseContInfo;
    }

    private FaLeaseBillInfo getReletLeaseBillInfo(Context ctx, FaLeaseBillInfo leaseBillinfo) {
        FaLeaseBillInfo reletLeaseBillInfo = (FaLeaseBillInfo)leaseBillinfo.clone();
        reletLeaseBillInfo.setId(null);
        reletLeaseBillInfo.setNumber(null);
        reletLeaseBillInfo.setBargainNum(null);
        reletLeaseBillInfo.setFiVouchered(false);
        reletLeaseBillInfo.setVoucher(null);
        reletLeaseBillInfo.setEffectedStatus(EffectedStatusEnum.TEMPSTORE);
        reletLeaseBillInfo.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
        reletLeaseBillInfo.setBizStatus(LeaseBizStatusEnum.RELETING);
        reletLeaseBillInfo.setCreateTime(new Timestamp(new Date().getTime()));
        reletLeaseBillInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
        Date today = DateTimeUtils.truncateDate((Date)new Date());
        reletLeaseBillInfo.setBeginDate(today);
        reletLeaseBillInfo.setMeasureUnit(DateUnitEnum.YEAR);
        BigDecimal leaseTime = new BigDecimal("1.0");
        reletLeaseBillInfo.setBargainTime(leaseTime);
        Date endDate = DateTimeUtils.addYear((Date)today, (int)leaseTime.intValue());
        reletLeaseBillInfo.setEndDate(endDate);
        reletLeaseBillInfo.setDeliverDate(today);
        reletLeaseBillInfo.setSignatureDate(today);
        reletLeaseBillInfo.setAuditor(null);
        reletLeaseBillInfo.setClearBill(null);
        reletLeaseBillInfo.setLastUpdateTime(null);
        reletLeaseBillInfo.setLastUpdateUser(null);
        reletLeaseBillInfo.setBillType(FaBillOriginEnum.FROM_LEASEOUT_RELET);
        FaLeaseBillEntryCollection leaseBillColl = reletLeaseBillInfo.getFaLeaseBillEntry();
        for (int i = 0; i < leaseBillColl.size(); ++i) {
            FaLeaseBillEntryInfo aFaLeaseBillEntryInfo = leaseBillColl.get(i);
            aFaLeaseBillEntryInfo.setId(null);
        }
        FaLeaseBalanceOutEntryCollection balanceBillColl = reletLeaseBillInfo.getBalanceEntry();
        for (int i = 0; i < balanceBillColl.size(); ++i) {
            FaLeaseBalanceOutEntryInfo aFaLeaseBalanceOutEntryInfo = balanceBillColl.get(i);
            aFaLeaseBalanceOutEntryInfo.setId(null);
            aFaLeaseBalanceOutEntryInfo.setBillID(null);
            aFaLeaseBalanceOutEntryInfo.setBillNumber(null);
        }
        return reletLeaseBillInfo;
    }

    private FALeaseContractInfo getReletContractInfo(Context ctx, FALeaseContractInfo leaseContInfo) {
        FALeaseContractInfo reletLeaseContInfo = (FALeaseContractInfo)leaseContInfo.clone();
        reletLeaseContInfo.setId(null);
        reletLeaseContInfo.setNumber(null);
        reletLeaseContInfo.setEffectedStatus(EffectedStatusEnum.TEMPSTORE);
        reletLeaseContInfo.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
        reletLeaseContInfo.setCreateTime(new Timestamp(new Date().getTime()));
        reletLeaseContInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
        Date today = DateTimeUtils.truncateDate((Date)new Date());
        reletLeaseContInfo.setEffectiveDate(today);
        reletLeaseContInfo.setSignDateA(today);
        reletLeaseContInfo.setSignDateB(today);
        reletLeaseContInfo.setSignDateC(today);
        reletLeaseContInfo.setLastUpdateTime(null);
        reletLeaseContInfo.setLastUpdateUser(null);
        return reletLeaseContInfo;
    }

    protected void unAction(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("faLeaseBillEntry.id"));
        selector.add(new SelectorItemInfo("faLeaseType.number"));
        FaLeaseBillInfo billInfo = FaLeaseBillFactory.getLocalInstance(ctx).getFaLeaseBillInfo((IObjectPK)new ObjectUuidPK(billID), selector);
        if (LeaseBizStatusEnum.CLOSED.equals((Object)billInfo.getBizStatus())) {
            if (billInfo.getClearBill() != null) {
                this.unSale(ctx, billInfo);
            } else {
                StringBuffer sql = new StringBuffer();
                sql.append(" select fid,fnumber,FCheckedStatus,1 as billType from T_FA_FALeaseContract where FSourceBillID = '").append(billID.toString()).append("'");
                sql.append(" union all ");
                sql.append(" select fid,fnumber,FCheckedStatus,2 as billType from T_FA_FALeaseBill where FSourceBillID = '").append(billID.toString()).append("'");
                IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                try {
                    if (iRowSet.next()) {
                        String id = iRowSet.getString("fid");
                        String number = iRowSet.getString("fnumber");
                        int checkedStatus = iRowSet.getInt("FCheckedStatus");
                        int billType = iRowSet.getInt("billType");
                        if (2 == checkedStatus) {
                            throw new FaLeaseException(billType == 1 ? FaLeaseException.RELETOCONTBILLAUDITED : FaLeaseException.RELETOLEASEBILLAUDITED, new String[]{number});
                        }
                        FaLocalUtils.abortWfProcessByObjId(ctx, id);
                        if (billType == 1) {
                            FALeaseContractFactory.getLocalInstance(ctx).deleteSelf((IObjectPK)new ObjectUuidPK(id));
                        }
                        this.deleteBill(ctx, (IObjectPK)new ObjectUuidPK(id));
                    }
                    this.unGetBack(ctx, billInfo);
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
            }
        } else {
            throw new FaLeaseException(FaLeaseException.CANTUNACTION);
        }
        if (FaBillOriginEnum.FROM_LEASEOUT_RELET.equals((Object)billInfo.getBillType()) && DateTimeUtils.truncateDate((Date)new Date()).before(billInfo.getEndDate())) {
            this.updateLeaseBillStatus(ctx, billID, 4);
        } else {
            this.updateLeaseBillStatus(ctx, billID, 2);
        }
    }

    private void unSale(Context ctx, FaLeaseBillInfo billInfo) throws EASBizException, BOSException {
        SelectorItemCollection src = new SelectorItemCollection();
        src.add(new SelectorItemInfo("id"));
        src.add(new SelectorItemInfo("clearBill.id"));
        src.add(new SelectorItemInfo("clearBill.number"));
        src.add(new SelectorItemInfo("clearBill.checkedStatus"));
        ObjectUuidPK objectUuidPK = new ObjectUuidPK(billInfo.getId());
        FaLeaseBillInfo leaseBilInfo = FaLeaseBillFactory.getLocalInstance(ctx).getFaLeaseBillInfo((IObjectPK)objectUuidPK, src);
        StringBuffer clearBillNumber = new StringBuffer();
        if (CheckedStatusEnum.AUDITED.equals((Object)leaseBilInfo.getClearBill().getCheckedStatus())) {
            clearBillNumber.append(",").append(leaseBilInfo.getClearBill().getNumber());
        }
        if (clearBillNumber.length() > 0) {
            throw new FaLeaseException(FaLeaseException.UNSALECLBILLAUDITED, new String[]{clearBillNumber.substring(1)});
        }
        PrcFaCoreManager prcFaCoreManager = new PrcFaCoreManager(new PrcFaClearStrategy());
        FaLocalUtils.abortWfProcessByObjId(ctx, leaseBilInfo.getClearBill().getId().toString());
        prcFaCoreManager.getFaManageStrategy().deleteBill(ctx, (IObjectPK)new ObjectUuidPK(leaseBilInfo.getClearBill().getId()));
        this.clearLeaseEntryClearBillId(ctx, billInfo.getId());
    }

    private void unGetBack(Context ctx, FaLeaseBillInfo billInfo) throws FaClearBillException, EASBizException, BOSException {
        SelectorItemCollection src = new SelectorItemCollection();
        src.add(new SelectorItemInfo("faLeaseBillEntry.returnChangeBill.number"));
        src.add(new SelectorItemInfo("faLeaseBillEntry.returnChangeBill.checkedStatus"));
        ObjectUuidPK objectUuidPK = new ObjectUuidPK(billInfo.getId());
        FaLeaseBillInfo leaseBilInfo = FaLeaseBillFactory.getLocalInstance(ctx).getFaLeaseBillInfo((IObjectPK)objectUuidPK, src);
        StringBuffer changeBillNumber = new StringBuffer();
        for (int i = 0; i < leaseBilInfo.getFaLeaseBillEntry().size(); ++i) {
            FaChangeBillInfo changeBillInfo = leaseBilInfo.getFaLeaseBillEntry().get(i).getReturnChangeBill();
            if (!CheckedStatusEnum.AUDITED.equals((Object)changeBillInfo.getCheckedStatus())) continue;
            changeBillNumber.append(",").append(changeBillInfo.getNumber());
        }
        if (changeBillNumber.length() > 0) {
            throw new FaLeaseException(FaLeaseException.CANTUNGETBACK, new String[]{changeBillNumber.substring(1)});
        }
        PrcFaCoreManager prcFaCoreManager = new PrcFaCoreManager(new PrcFaChangeStrategy());
        for (int i = 0; i < leaseBilInfo.getFaLeaseBillEntry().size(); ++i) {
            FaChangeBillInfo changeBillInfo = leaseBilInfo.getFaLeaseBillEntry().get(i).getReturnChangeBill();
            FaLocalUtils.abortWfProcessByObjId(ctx, changeBillInfo.getId().toString());
            prcFaCoreManager.getFaManageStrategy().deleteBill(ctx, (IObjectPK)new ObjectUuidPK(changeBillInfo.getId()));
        }
        this.clearLeaseEntryReturnChangeBillId(ctx, billInfo.getId());
        int leaseStatus = 0;
        if (WORK_NUMBER.equals(billInfo.getFaLeaseType().getNumber())) {
            leaseStatus = 1;
        } else if (FINANCING_NUMBER.equals(billInfo.getFaLeaseType().getNumber())) {
            leaseStatus = 2;
        }
        this.updateCurCardStatus(ctx, billInfo.getId(), leaseStatus);
    }

    private void updateCurCardStatus(Context ctx, BOSUuid id, String bizStatus, int leaseStatus) throws BOSException {
        String updateCardSql = "update t_fa_facurcard set fbizstatus = ? , fleasestatus = ?  where fid in (" + this.getEntryCol("entry.fcurcardid") + ")";
        DbUtil.execute((Context)ctx, (String)updateCardSql, (Object[])new Object[]{bizStatus, new Integer(leaseStatus), id.toString()});
    }

    private String getEntryCol(String columnName) {
        return "select " + columnName + " from t_fa_faleasebill bill inner join t_fa_faleasebillentry entry on bill.fid = entry.FFaLeaseBillID where bill.fid = ?";
    }

    private FaClearBillInfo createClearBillInfo(Context ctx, FaLeaseBillInfo billInfo) {
        FaClearBillInfo clearBillInfo = new FaClearBillInfo();
        clearBillInfo.setBillType(FaBillOriginEnum.FROM_LEASEOUT_SALE);
        clearBillInfo.setSourceBillId(billInfo.getId().toString());
        clearBillInfo.setCompany(billInfo.getCompany());
        clearBillInfo.setCU(billInfo.getCU());
        clearBillInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
        clearBillInfo.setHandler(ContextUtil.getCurrentUserInfo((Context)ctx));
        clearBillInfo.setCreateTime(new Timestamp(new Date().getTime()));
        clearBillInfo.setClearDate(DateTimeUtils.truncateDate((Date)new Date()));
        clearBillInfo.setDeletedStatus(DeletedStatusEnum.NORMAL);
        clearBillInfo.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
        clearBillInfo.setBlockedStatus(BlockedStatusEnum.UNBLOCKED);
        String desc = ResourceBase.getString((String)RES_PATH, (String)"faLeaseBill", (Locale)ctx.getOriginLocale()) + billInfo.getNumber() + ResourceBase.getString((String)RES_PATH, (String)"saleClearBill", (Locale)ctx.getOriginLocale());
        clearBillInfo.setDescription(desc);
        FaClearBillEntryCollection entryColl = clearBillInfo.getClearBillEntry();
        FaLeaseBillEntryCollection coll = billInfo.getFaLeaseBillEntry();
        for (int i = 0; i < coll.size(); ++i) {
            FaCurCardInfo curCardIno = coll.get(i).getFaCurCard();
            FaClearBillEntryInfo entryInfo = new FaClearBillEntryInfo();
            entryInfo.put("faCurCard", curCardIno.getId().toString());
            entryInfo.put("cardUpdateTime", curCardIno.getLastUpdateTime());
            entryInfo.setCurCard(curCardIno);
            entryInfo.setClrQty(curCardIno.getAssetAmt());
            entryInfo.setClrOriginal(curCardIno.getAssetValue());
            entryInfo.setClrAddupDep(curCardIno.getAccuDepr());
            entryInfo.setClrDecPrep(curCardIno.getDecValue());
            entryColl.add(entryInfo);
        }
        return clearBillInfo;
    }

    private FaChangeBillInfo createChangeBillInfo(Context ctx, FaLeaseBillInfo leaseInfo, FaLeaseBillEntryInfo entryInfo, boolean isReturn) throws EASBizException, BOSException {
        BOSUuid curCardID = entryInfo.getFaCurCard().getId();
        SelectorItemCollection sic = PrcFaCoreManager.getCurCardSelectors();
        sic.add(new SelectorItemInfo("currency.*"));
        FaCurCardInfo curCard = FaCurCardFactory.getLocalInstance(ctx).getFaCurCardInfo((IObjectPK)new ObjectUuidPK(curCardID), sic);
        this.checkFaCurCardValid(ctx, curCard);
        FaChangeBillInfo changeBillInfo = new FaChangeBillInfo();
        changeBillInfo.setBillType(isReturn ? FaBillOriginEnum.FROM_LEASEOUT_GETBACK : FaBillOriginEnum.FROM_LEASEOUT);
        changeBillInfo.setSourceBillId(leaseInfo.getId().toString());
        changeBillInfo.setCompany(curCard.getCompany());
        changeBillInfo.setCU(curCard.getCU());
        changeBillInfo.setChangeDate(DateTimeUtils.truncateDate((Date)new Date()));
        changeBillInfo.setDeletedStatus(DeletedStatusEnum.NORMAL);
        changeBillInfo.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
        changeBillInfo.setBlockedStatus(BlockedStatusEnum.UNBLOCKED);
        changeBillInfo.setFiVouchered(false);
        changeBillInfo.setHandler(ContextUtil.getCurrentUserInfo((Context)ctx));
        changeBillInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
        String desc = ResourceBase.getString((String)RES_PATH, (String)"faLeaseBill", (Locale)ctx.getOriginLocale()) + leaseInfo.getNumber();
        desc = desc + (isReturn ? ResourceBase.getString((String)RES_PATH, (String)"returnChangeBill", (Locale)ctx.getOriginLocale()) : ResourceBase.getString((String)RES_PATH, (String)"newChangeBill", (Locale)ctx.getOriginLocale()));
        changeBillInfo.setDescription(desc);
        HashMap hmParam = FaLocalUtils.getFAParameter(changeBillInfo.getCompany().getId(), ctx);
        boolean useCardChangeMode = hmParam.get("FA_026") == null ? false : Boolean.valueOf(hmParam.get("FA_026").toString());
        changeBillInfo.setChangeMode(useCardChangeMode ? curCard.getOriginMethod() : null);
        FaBakCardInfo bakCard = PrcFaCoreManager.CurCard2BakCard(curCard);
        bakCard.setFaCurCard(curCard);
        bakCard.setBillType(FaBillTypeEnum.CHANGE);
        if (curCard.getPropertyValue() != null) {
            FaDefPropertyValueInfo bakPV = FaCardDefPropertyPersist.copy(curCard.getPropertyValue().getId(), ctx);
            bakCard.setPropertyValue(bakPV);
        } else {
            bakCard.setPropertyValue(null);
        }
        FaBizCardInfo bizCard = PrcFaCoreManager.CurCard2BizCard(curCard);
        bizCard.setFaBakCard(bakCard);
        bizCard.setBillType(FaBillTypeEnum.CHANGE);
        if (curCard.getPropertyValue() != null) {
            FaDefPropertyValueInfo bizPV = FaCardDefPropertyPersist.copy(curCard.getPropertyValue().getId(), ctx);
            bizCard.setPropertyValue(bizPV);
        } else {
            bizCard.setPropertyValue(null);
        }
        if (isReturn) {
            bizCard.setLeaseStatus(FaLeaseStatusEnum.NO_LEASE);
        } else if (WORK_NUMBER.equals(leaseInfo.getFaLeaseType().getNumber())) {
            bizCard.setLeaseStatus(FaLeaseStatusEnum.WORKING_LEASE_OUT);
        } else if (FINANCING_NUMBER.equals(leaseInfo.getFaLeaseType().getNumber())) {
            bizCard.setLeaseStatus(FaLeaseStatusEnum.FINANCE_LEASE_OUT);
        } else {
            bizCard.setLeaseStatus(FaLeaseStatusEnum.NO_LEASE);
        }
        bakCard.setId((BOSUuid)FaBakCardFactory.getLocalInstance(ctx).submit((CoreBaseInfo)bakCard).getKeyValue("id"));
        FaChangeBillEntryInfo cgBillentryInfo = new FaChangeBillEntryInfo();
        cgBillentryInfo.setBizCard(bizCard);
        cgBillentryInfo.setCurCard(curCard);
        cgBillentryInfo.setOriginChg(ZERO);
        cgBillentryInfo.setAccuDeprChg(ZERO);
        cgBillentryInfo.setDecValueChg(ZERO);
        changeBillInfo.getChangeBillEntry().add(cgBillentryInfo);
        this.setChangeBillNewNumber(ctx, changeBillInfo, 100);
        return changeBillInfo;
    }

    protected void setChangeBillNewNumber(Context ctx, FaChangeBillInfo billInfo, int deepNo) throws EASBizException, BOSException {
        if (deepNo == 0) {
            throw new CodingRuleException(CodingRuleException.ERROR_REFERENCE_INVALID);
        }
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitInfo aCompanyOrgUnitInfo = billInfo.getCompany();
        if (aCompanyOrgUnitInfo == null) {
            aCompanyOrgUnitInfo = ContextUtil.getCurrentFIUnit((Context)ctx);
        }
        String strCompanyId = aCompanyOrgUnitInfo.getId().toString();
        String number = iCodingRuleManager.getNumber((IObjectValue)billInfo, strCompanyId);
        billInfo.setNumber(number);
        if (this.existChangeBillNumber(ctx, (IObjectValue)billInfo)) {
            this.setChangeBillNewNumber(ctx, billInfo, deepNo - 1);
        }
    }

    protected boolean existChangeBillNumber(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        FaChangeBillInfo billInfo = (FaChangeBillInfo)model;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FID FROM T_FA_FACHANGEBILL WHERE FNUMBER = '");
        sql.append(billInfo.getNumber()).append("'");
        sql.append(" AND FCOMPANYID = '").append(billInfo.getCompany().getId().toString()).append("'");
        if (billInfo.getId() != null) {
            sql.append(" AND FID != '").append(billInfo.getId().toString()).append("'");
        }
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            return rowSet.next();
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected void checkForUnAudit(Context ctx, BillBaseInfo billInfo, boolean isFromSource) throws EASBizException, BOSException {
        String msg;
        FaLeaseBillInfo leaseBillInfo = (FaLeaseBillInfo)billInfo;
        if (leaseBillInfo.isFiVouchered()) {
            StringBuffer sbHasGenVoucher = new StringBuffer(ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource", (String)"Has_GenVoucher", (Locale)ctx.getOriginLocale()));
            throw new FaCardException(FaCardException.CANNOT_BE_UNAUDITED, new String[]{"", sbHasGenVoucher.toString()});
        }
        if (LeaseBizStatusEnum.CLOSED.equals((Object)leaseBillInfo.getBizStatus())) {
            throw new FaLeaseException(FaLeaseException.HASCLOSED);
        }
        if (!LeaseBizStatusEnum.RELETING.equals((Object)leaseBillInfo.getBizStatus()) && (msg = this.getAuditedChangeBills(ctx, billInfo.getId())) != null) {
            throw new FaLeaseException(FaLeaseException.UNAUDITCGBILLAUDITED, new String[]{msg});
        }
        msg = this.getGatheringBills(ctx, billInfo.getId());
        if (msg != null) {
            throw new FaLeaseException(FaLeaseException.PRODUCEGATHERINGBILL, new String[]{msg});
        }
    }

    private void verifyBargainNum(Context ctx, IObjectValue model) throws BOSException, FaLeaseException {
        IRowSet iRowSet;
        StringBuffer sql;
        FaLeaseBillInfo billInfo = (FaLeaseBillInfo)model;
        String bargainNum = billInfo.getBargainNum();
        if (bargainNum == null || bargainNum.trim().length() == 0) {
            return;
        }
        if (!FaBillOriginEnum.FROM_LEASECONTRACT.equals((Object)billInfo.getBillType())) {
            sql = new StringBuffer();
            sql.append(" select fnumber from t_fa_faleasecontract where fnumber = '").append(bargainNum).append("'");
            sql.append(" and fcompanyid = '").append(billInfo.getCompany().getId().toString()).append("'");
            iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            try {
                if (iRowSet.next()) {
                    throw new FaLeaseException(FaLeaseException.BARGINNUMHASUSED, new String[]{bargainNum});
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        sql = new StringBuffer();
        sql.append(" select fnumber from t_fa_faleasebill where fBargainNum = '").append(bargainNum).append("'");
        sql.append(" and fcompanyid = '").append(billInfo.getCompany().getId().toString()).append("'");
        if (billInfo.getId() != null) {
            sql.append(" and fid != '").append(billInfo.getId().toString()).append("'");
        }
        iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (iRowSet.next()) {
                String number = iRowSet.getString("fnumber");
                throw new FaLeaseException(FaLeaseException.BARGINNUMHASUSED2, new String[]{number, bargainNum});
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        sql = new StringBuffer();
        sql.append(" select fnumber from t_fa_faleaseinbill where fBargainNum = '").append(bargainNum).append("'");
        sql.append(" and fcompanyid = '").append(billInfo.getCompany().getId().toString()).append("'");
        iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (iRowSet.next()) {
                String number = iRowSet.getString("fnumber");
                throw new FaLeaseException(FaLeaseException.BARGINNUMHASUSED1, new String[]{number, bargainNum});
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private String getAuditedChangeBills(Context ctx, BOSUuid id) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select cg.fnumber as FNumber from t_fa_faleasebill b ");
        sql.append(" inner join t_fa_faleasebillentry e on b.fid = e.ffaLeaseBillID");
        sql.append(" inner join t_fa_fachangebill cg on cg.fid = e.fchangebillid");
        sql.append(" where cg.fcheckedstatus = ").append(2);
        sql.append(" and b.fid = '").append(id).append("'");
        IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        StringBuffer msg = new StringBuffer();
        try {
            while (iRowSet.next()) {
                msg.append("\u3001");
                msg.append(iRowSet.getString("FNumber"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return msg.length() == 0 ? null : msg.substring(1);
    }

    private String getGatheringBills(Context ctx, BOSUuid id) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select e.fnumber as FNumber,e.FIsPayment as isPayment from t_Fa_Faleasebalancebill b ");
        sql.append(" inner join T_FA_FaLeaseBalanceEntry e on b.fid = e.fbillid");
        sql.append(" where b.FleaseOutBillID = '").append(id).append("'");
        IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        StringBuffer msg = new StringBuffer();
        StringBuffer gatherMsg = new StringBuffer();
        StringBuffer paymentMsg = new StringBuffer();
        String gatheringBill = ResourceBase.getString((String)RES_PATH, (String)"gatheringBill", (Locale)ctx.getOriginLocale());
        String paymentBill = ResourceBase.getString((String)RES_PATH, (String)"paymentBill", (Locale)ctx.getOriginLocale());
        try {
            while (iRowSet.next()) {
                if (iRowSet.getBoolean("isPayment")) {
                    paymentMsg.append("\u3001");
                    paymentMsg.append(iRowSet.getString("FNumber"));
                    continue;
                }
                gatherMsg.append("\u3001");
                gatherMsg.append(iRowSet.getString("FNumber"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (gatherMsg.length() > 0) {
            msg.append(gatheringBill).append(gatherMsg.substring(1));
        }
        if (paymentMsg.length() > 0) {
            if (gatherMsg.length() > 0) {
                msg.append("\uff0c");
            }
            msg.append(paymentBill).append(paymentMsg.substring(1));
        }
        return msg.length() == 0 ? null : msg.toString();
    }

    private void updateEntryChangeBillID(Context ctx, BOSUuid entryID, IObjectPK changeBillPK) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("update t_fa_faleasebillentry set fchangebillid = '").append(changeBillPK).append("'");
        sql.append(" where fid = '").append(entryID).append("'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private void updateEntryReturnChangeBillID(Context ctx, BOSUuid entryID, IObjectPK changeBillPK) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("update t_fa_faleasebillentry set freturnchangebillid = '").append(changeBillPK).append("'");
        sql.append(" where fid = '").append(entryID).append("'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private void updateLeaseBillStatus(Context ctx, BOSUuid id, int bizStatus) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("update t_fa_faleasebill set fbizStatus = ").append(bizStatus);
        sql.append(" where fid = '").append(id).append("'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    @Override
    protected void unAuditBill(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        FaLeaseBillInfo leaseInfo = (FaLeaseBillInfo)model;
        if (!LeaseBizStatusEnum.RELETING.equals((Object)leaseInfo.getBizStatus())) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("faLeaseBillEntry.*"));
            leaseInfo = FaLeaseBillFactory.getLocalInstance(ctx).getFaLeaseBillInfo((IObjectPK)new ObjectUuidPK(leaseInfo.getId()), sic);
            FaLeaseBillEntryCollection coll = leaseInfo.getFaLeaseBillEntry();
            PrcFaCoreManager prcFaCoreManager = new PrcFaCoreManager(new PrcFaChangeStrategy());
            for (int i = 0; i < coll.size(); ++i) {
                BOSUuid changeBillID = coll.get(i).getChangeBill().getId();
                FaLocalUtils.abortWfProcessByObjId(ctx, changeBillID.toString());
                prcFaCoreManager.getFaManageStrategy().deleteBill(ctx, (IObjectPK)new ObjectUuidPK(changeBillID));
            }
            this.updateCurCardStatus(ctx, leaseInfo.getId(), "1101", 0);
            this.clearLeaseEntryChangeBillId(ctx, leaseInfo.getId());
            this.updateLeaseBillStatus(ctx, leaseInfo.getId(), 1);
        }
        FaLeaseBillFactory.getLocalInstance(ctx).unpassAuditSelf((IObjectPK)new ObjectUuidPK(leaseInfo.getId()), leaseInfo);
    }

    @Override
    protected void generateVourcher(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
    }

    private IObjectPK innerSaveBill(Context ctx, FaLeaseBillInfo info, boolean isSubmit) throws BOSException, EASBizException {
        this.verifyBargainNum(ctx, (IObjectValue)info);
        PeriodInfo periodInfo = this.getCurrentPeriod(ctx, info);
        info.setDeliverDate(DateTimeUtils.truncateDate((Date)info.getDeliverDate()));
        info.setSignatureDate(DateTimeUtils.truncateDate((Date)info.getSignatureDate()));
        info.setBeginDate(DateTimeUtils.truncateDate((Date)info.getBeginDate()));
        info.setEndDate(DateTimeUtils.truncateDate((Date)info.getEndDate()));
        info.setPeriod(periodInfo);
        info.setBizDate(DateTimeUtils.truncateDate((Date)new Date()));
        info.setDeletedStatus(DeletedStatusEnum.NORMAL);
        info.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
        info.setBlockedStatus(BlockedStatusEnum.UNBLOCKED);
        info.setFiVouchered(false);
        info.setHasEffected(true);
        info.setEffectedStatus(isSubmit ? EffectedStatusEnum.EFFECTED : EffectedStatusEnum.TEMPSTORE);
        info.setBizDate(DateTimeUtils.truncateDate((Date)this.getCurrentPeriod(ctx, info).getEndDate()));
        IFaLeaseBill iLease = FaLeaseBillFactory.getLocalInstance(ctx);
        PrcFaLeasStrategy.setBillInfoNumber(ctx, info, iLease);
        if (info.getId() == null && LeaseBizStatusEnum.RELETING != info.getBizStatus()) {
            this.checkFaCurCardValid(ctx, this.getCardColFromEntry((IObjectCollection)info.getFaLeaseBillEntry()));
        }
        FaLastPeriodChangeUtils.restoreBakAndCleanUp(ctx, (CoreBaseInfo)info, new String[]{"fbizstatus", "flastbillid"}, null);
        Map tempTableNames = PrcFaLeasStrategy.createBizBakTempTable(ctx);
        IObjectPK billId = isSubmit ? iLease.submitSelf(info) : iLease.saveSelf(info);
        String selectCardId = "select fcurcardid from t_fa_faleasebillentry entry where ffaleasebillid = '" + billId + "'";
        this.saveBizBakCard(ctx, new String[]{selectCardId, "t_fa_faleasebillentry", billId.toString(), "FFaleaseBillID"}, FaBillTypeEnum.LEASEOUT, FaBizStatusEnum.LEASING, tempTableNames);
        return billId;
    }

    @Override
    protected Map getCardColFromEntry(IObjectCollection entryCol) {
        HashMap<String, FaCurCardInfo> result = new HashMap<String, FaCurCardInfo>();
        FaCurCardInfo cardInfo = null;
        int size = entryCol.size();
        for (int i = 0; i < size; ++i) {
            if (entryCol.getObject(i) == null || entryCol.getObject(i).get("faCurCard") == null) continue;
            cardInfo = ((FaBillBaseEntityInfo)entryCol.getObject(i)).getFaCurCard();
            result.put(cardInfo.getId().toString(), cardInfo);
        }
        return result;
    }

    private void checkAtTermStatus(Context ctx, FaLeaseBillInfo billInfo, boolean chekckAtTerm) throws BOSException, EASBizException {
        FaLocalUtils.checkPeriodConsistent(ctx, billInfo.getCompany(), billInfo.getPeriod(), false);
        if (CheckedStatusEnum.UNAUDITED.equals((Object)billInfo.getCheckedStatus())) {
            throw new FaLeaseException(FaLeaseException.UNAUDITLEASEINBILL);
        }
        if (LeaseBizStatusEnum.CLOSED.equals((Object)billInfo.getBizStatus())) {
            throw new FaLeaseException(FaLeaseException.LEASEINBILLHASCLOSE);
        }
        if (chekckAtTerm) {
            Date endDate = billInfo.getEndDate();
            Date curDate = new Date(System.currentTimeMillis());
            if ((curDate = this.formateDate(curDate)).before(endDate) || curDate.equals(endDate)) {
                throw new FaLeaseException(FaLeaseException.LEASEBILLNOTATTERM);
            }
        }
        FaLeaseBalanceBillFactory.getLocalInstance(ctx).checkUnAuditPayment((IObjectPK)new ObjectUuidPK(billInfo.getId()));
    }

    private Date formateDate(Date date) {
        date = date == null ? new Date() : date;
        Date newDate = date;
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String strDate = format.format(date);
        try {
            newDate = format.parse(strDate);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return newDate;
    }

    private void updateCurCardStatus(Context ctx, BOSUuid id, int leaseStatus) throws BOSException {
        String updateCardSql = "update t_fa_facurcard set fleasestatus = ?  where fid in (" + this.getEntryCol("entry.fcurcardid") + ")";
        DbUtil.execute((Context)ctx, (String)updateCardSql, (Object[])new Object[]{new Integer(leaseStatus), id.toString()});
    }

    private void clearLeaseEntryChangeBillId(Context ctx, BOSUuid leaseBillID) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("update t_fa_faleasebillentry set fchangebillid = null where ffaleasebillid = '").append(leaseBillID).append("'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private void clearLeaseEntryReturnChangeBillId(Context ctx, BOSUuid leaseBillID) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("update t_fa_faleasebillentry set freturnchangebillid = null where ffaleasebillid = '").append(leaseBillID).append("'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private void setClearBillID(Context ctx, BOSUuid billID, IObjectPK clearBillPK) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("update t_fa_faleasebill set fclearbillid = '").append(clearBillPK).append("'");
        sql.append(" where fid = '").append(billID).append("'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private void clearLeaseEntryClearBillId(Context ctx, BOSUuid leaseBillID) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("update t_fa_faleasebill set fclearbillid = null where fid = '").append(leaseBillID).append("'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }
}

