/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.BarCodeStatusEnum;
import com.kingdee.eas.fi.fa.manage.DateUnitEnum;
import com.kingdee.eas.fi.fa.manage.FALeaseContractCollection;
import com.kingdee.eas.fi.fa.manage.FALeaseContractFactory;
import com.kingdee.eas.fi.fa.manage.FALeaseContractInfo;
import com.kingdee.eas.fi.fa.manage.FaBakCardFactory;
import com.kingdee.eas.fi.fa.manage.FaBakCardInfo;
import com.kingdee.eas.fi.fa.manage.FaBillOriginEnum;
import com.kingdee.eas.fi.fa.manage.FaBillTypeEnum;
import com.kingdee.eas.fi.fa.manage.FaBizCardInfo;
import com.kingdee.eas.fi.fa.manage.FaCardException;
import com.kingdee.eas.fi.fa.manage.FaCardOriginEnum;
import com.kingdee.eas.fi.fa.manage.FaChangeBillEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaChangeBillFactory;
import com.kingdee.eas.fi.fa.manage.FaChangeBillInfo;
import com.kingdee.eas.fi.fa.manage.FaClearBillEntryCollection;
import com.kingdee.eas.fi.fa.manage.FaClearBillEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaClearBillException;
import com.kingdee.eas.fi.fa.manage.FaClearBillFactory;
import com.kingdee.eas.fi.fa.manage.FaClearBillInfo;
import com.kingdee.eas.fi.fa.manage.FaCurCardFactory;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.fi.fa.manage.FaFromUnitCatEnum;
import com.kingdee.eas.fi.fa.manage.FaLeaseBalanceBillFactory;
import com.kingdee.eas.fi.fa.manage.FaLeaseBalanceInEntryCollection;
import com.kingdee.eas.fi.fa.manage.FaLeaseBalanceInEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaLeaseException;
import com.kingdee.eas.fi.fa.manage.FaLeaseInBillEntryCollection;
import com.kingdee.eas.fi.fa.manage.FaLeaseInBillEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaLeaseInBillFactory;
import com.kingdee.eas.fi.fa.manage.FaLeaseInBillInfo;
import com.kingdee.eas.fi.fa.manage.FaLeaseStatusEnum;
import com.kingdee.eas.fi.fa.manage.GroupNumberStatusEnum;
import com.kingdee.eas.fi.fa.manage.IFALeaseContract;
import com.kingdee.eas.fi.fa.manage.IFaCurCard;
import com.kingdee.eas.fi.fa.manage.IFaLeaseInBill;
import com.kingdee.eas.fi.fa.manage.LeaseBizStatusEnum;
import com.kingdee.eas.fi.fa.manage.app.AbstractPrcFaManageStrategy;
import com.kingdee.eas.fi.fa.manage.app.FaLocalUtils;
import com.kingdee.eas.fi.fa.manage.app.PrcFaAddStrategy;
import com.kingdee.eas.fi.fa.manage.app.PrcFaChangeStrategy;
import com.kingdee.eas.fi.fa.manage.app.PrcFaClearStrategy;
import com.kingdee.eas.fi.fa.manage.app.PrcFaCoreManager;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.BlockedStatusEnum;
import com.kingdee.eas.framework.CheckedStatusEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.framework.EffectedStatusEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class PrcFaLeaseInStrategy
extends AbstractPrcFaManageStrategy {
    private static final String RES_PATH = "com.kingdee.eas.fi.fa.manage.FaLeaseResource";
    private static final BigDecimal ONE = new BigDecimal("1");
    private static final String FINANCING_NUMBER = "002";

    @Override
    protected void deleteBill(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        IFaLeaseInBill iFaLeaseIn = FaLeaseInBillFactory.getLocalInstance(ctx);
        FaLeaseInBillInfo billInfo = iFaLeaseIn.getFaLeaseInBillInfo("select id,number,company where id ='" + pk + "'");
        this.recycleNumber(ctx, billInfo);
        iFaLeaseIn.deleteSelf(pk);
    }

    @Override
    protected IObjectPK saveBill(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        return this.innerSaveBill(ctx, (FaLeaseInBillInfo)model, false);
    }

    @Override
    protected IObjectPK submitBill(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        return this.innerSaveBill(ctx, (FaLeaseInBillInfo)model, true);
    }

    @Override
    protected void auditBill(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        FaLeaseInBillInfo leaseInInfo = (FaLeaseInBillInfo)model;
        if (leaseInInfo.getLeaseType().getNumber().equals(FINANCING_NUMBER) && !LeaseBizStatusEnum.RELETING.equals((Object)leaseInInfo.getBizStatus())) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("company.baseCurrency.id"));
            sic.add(new SelectorItemInfo("entry.*"));
            leaseInInfo = FaLeaseInBillFactory.getLocalInstance(ctx).getFaLeaseInBillInfo((IObjectPK)new ObjectUuidPK(leaseInInfo.getId()), sic);
            FaLeaseInBillEntryCollection coll = leaseInInfo.getEntry();
            IFaCurCard iFaCurCard = FaCurCardFactory.getLocalInstance(ctx);
            for (int i = 0; i < coll.size(); ++i) {
                FaLeaseInBillEntryInfo entryInfo = coll.get(i);
                FaCurCardInfo newCard = this.createCurCardInfo(ctx, leaseInInfo, entryInfo);
                IObjectPK pk = iFaCurCard.save((CoreBaseInfo)newCard);
                this.updateEntryCardID(ctx, entryInfo.getId(), pk);
            }
        }
        if (!LeaseBizStatusEnum.RELETING.equals((Object)leaseInInfo.getBizStatus())) {
            this.updateLeaseInBillStatus(ctx, leaseInInfo.getId(), 2);
        }
        FaLeaseInBillFactory.getLocalInstance(ctx).passAuditSelf((IObjectPK)new ObjectUuidPK(leaseInInfo.getId()), leaseInInfo);
    }

    @Override
    protected void unAuditBill(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        FaLeaseInBillInfo leaseInInfo = (FaLeaseInBillInfo)model;
        if (leaseInInfo.getLeaseType().getNumber().equals(FINANCING_NUMBER) && !LeaseBizStatusEnum.RELETING.equals((Object)leaseInInfo.getBizStatus())) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("entry.*"));
            leaseInInfo = FaLeaseInBillFactory.getLocalInstance(ctx).getFaLeaseInBillInfo((IObjectPK)new ObjectUuidPK(leaseInInfo.getId()), sic);
            FaLeaseInBillEntryCollection coll = leaseInInfo.getEntry();
            PrcFaCoreManager prcFaCoreManager = new PrcFaCoreManager(new PrcFaAddStrategy());
            for (int i = 0; i < coll.size(); ++i) {
                FaCurCardInfo card = coll.get(i).getFaCurCard();
                if (card == null) continue;
                FaLocalUtils.abortWfProcessByObjId(ctx, card.getId().toString());
                prcFaCoreManager.getFaManageStrategy().deleteBill(ctx, (IObjectPK)new ObjectUuidPK(card.getId()));
            }
            this.clearLeaseInEntryCardId(ctx, leaseInInfo.getId());
        }
        if (!LeaseBizStatusEnum.RELETING.equals((Object)leaseInInfo.getBizStatus())) {
            this.updateLeaseInBillStatus(ctx, leaseInInfo.getId(), 1);
        }
        FaLeaseInBillFactory.getLocalInstance(ctx).unpassAuditSelf((IObjectPK)new ObjectUuidPK(leaseInInfo.getId()), leaseInInfo);
    }

    @Override
    protected void checkForUnAudit(Context ctx, BillBaseInfo billInfo, boolean isFromSource) throws EASBizException, BOSException {
        String msg;
        FaLeaseInBillInfo leaseInBillInfo = (FaLeaseInBillInfo)billInfo;
        if (leaseInBillInfo.isFiVouchered()) {
            StringBuffer sbHasGenVoucher = new StringBuffer(ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource", (String)"Has_GenVoucher", (Locale)ctx.getOriginLocale()));
            throw new FaCardException(FaCardException.CANNOT_BE_UNAUDITED, new String[]{"", sbHasGenVoucher.toString()});
        }
        if (LeaseBizStatusEnum.CLOSED.equals((Object)leaseInBillInfo.getBizStatus())) {
            throw new FaLeaseException(FaLeaseException.HASCLOSED);
        }
        if (leaseInBillInfo.getLeaseType().getNumber().equals(FINANCING_NUMBER) && !LeaseBizStatusEnum.RELETING.equals((Object)leaseInBillInfo.getBizStatus()) && (msg = this.getAuditedCard(ctx, billInfo.getId())) != null) {
            throw new FaLeaseException(FaLeaseException.UNAUDITCARDAUDITED, new String[]{msg});
        }
        msg = this.getPaymentBills(ctx, billInfo.getId());
        if (msg != null) {
            throw new FaLeaseException(FaLeaseException.PRODUCEGATHERINGBILL, new String[]{msg});
        }
    }

    protected void giveBack(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("leaseType.number"));
        selector.add(new SelectorItemInfo("entry.faCurCard.id"));
        selector.add(new SelectorItemInfo("entry.faCurCard.number"));
        selector.add(new SelectorItemInfo("entry.faCurCard.assetValue"));
        selector.add(new SelectorItemInfo("entry.faCurCard.accuDepr"));
        selector.add(new SelectorItemInfo("entry.faCurCard.decValue"));
        selector.add(new SelectorItemInfo("entry.faCurCard.assetName"));
        selector.add(new SelectorItemInfo("entry.faCurCard.assetAmt"));
        selector.add(new SelectorItemInfo("entry.faCurCard.checkedStatus"));
        selector.add(new SelectorItemInfo("entry.faCurCard.lastUpdateTime"));
        FaLeaseInBillInfo billInfo = FaLeaseInBillFactory.getLocalInstance(ctx).getFaLeaseInBillInfo((IObjectPK)new ObjectUuidPK(billID), selector);
        this.checkAtTermStatus(ctx, billInfo, false);
        if (FINANCING_NUMBER.equals(billInfo.getLeaseType().getNumber())) {
            FaLeaseInBillEntryCollection coll = billInfo.getEntry();
            StringBuffer cardInfo = new StringBuffer();
            for (int i = 0; i < coll.size(); ++i) {
                FaCurCardInfo card = coll.get(i).getFaCurCard();
                if (!CheckedStatusEnum.UNAUDITED.equals((Object)card.getCheckedStatus())) continue;
                cardInfo.append("\u3001").append(card.getNumber()).append("(").append(card.getAssetName()).append(")");
            }
            if (cardInfo.length() > 0) {
                throw new FaLeaseException(FaLeaseException.CARDNOTAUDITED, new String[]{cardInfo.substring(1)});
            }
            FaClearBillInfo clearBillInfo = this.createClearBillInfo(ctx, billInfo);
            IObjectPK pk = FaClearBillFactory.getLocalInstance(ctx).save((CoreBaseInfo)clearBillInfo);
            this.setClearBillID(ctx, billID, pk);
        }
        this.updateLeaseInBillStatus(ctx, billID, 5);
    }

    protected void buy(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("leaseType.number"));
        selector.add(new SelectorItemInfo("entry.faCurCard.id"));
        selector.add(new SelectorItemInfo("entry.faCurCard.number"));
        selector.add(new SelectorItemInfo("entry.faCurCard.assetName"));
        selector.add(new SelectorItemInfo("entry.faCurCard.checkedStatus"));
        FaLeaseInBillInfo billInfo = FaLeaseInBillFactory.getLocalInstance(ctx).getFaLeaseInBillInfo((IObjectPK)new ObjectUuidPK(billID), selector);
        this.checkAtTermStatus(ctx, billInfo, false);
        this.updateCurCardStatus(ctx, billInfo.getId(), 0);
        if (FINANCING_NUMBER.equals(billInfo.getLeaseType().getNumber())) {
            int i;
            FaLeaseInBillEntryCollection coll = billInfo.getEntry();
            StringBuffer cardInfo = new StringBuffer();
            for (i = 0; i < coll.size(); ++i) {
                FaCurCardInfo card = coll.get(i).getFaCurCard();
                if (!CheckedStatusEnum.UNAUDITED.equals((Object)card.getCheckedStatus())) continue;
                cardInfo.append("\u3001").append(card.getNumber()).append("(").append(card.getAssetName()).append(")");
            }
            if (cardInfo.length() > 0) {
                throw new FaLeaseException(FaLeaseException.CARDNOTAUDITED, new String[]{cardInfo.substring(1)});
            }
            for (i = 0; i < coll.size(); ++i) {
                FaChangeBillInfo changeBillInfo = this.createChangeBillInfo(ctx, billInfo, coll.get(i));
                IObjectPK pk = FaChangeBillFactory.getLocalInstance(ctx).save((CoreBaseInfo)changeBillInfo);
                this.setChangeBillID(ctx, coll.get(i).getId(), pk);
            }
        } else {
            throw new FaLeaseException(FaLeaseException.WORKLEASEINCANTBUY);
        }
        this.updateLeaseInBillStatus(ctx, billID, 5);
    }

    private FaCurCardInfo createCurCardInfo(Context ctx, FaLeaseInBillInfo billInfo, FaLeaseInBillEntryInfo entryInfo) throws EASBizException, BOSException {
        FaCurCardInfo newCard = new FaCurCardInfo();
        if (entryInfo.getCardNumber() != null && entryInfo.getCardNumber().trim().length() > 0) {
            newCard.setNumber(entryInfo.getCardNumber());
        }
        newCard.setEffectedStatus(EffectedStatusEnum.TEMPSTORE);
        newCard.setGroupNumberStatus(GroupNumberStatusEnum.EFFECTED);
        newCard.setBarCodeStatus(BarCodeStatusEnum.EFFECTED);
        newCard.setCompany(billInfo.getCompany());
        newCard.setAssetName(entryInfo.getCardName());
        newCard.setAssetAmt(entryInfo.getQuantity());
        newCard.setSpecs(entryInfo.getSpecs() == null ? "" : entryInfo.getSpecs());
        newCard.setMeasureUnit(entryInfo.getMeasureUnit());
        newCard.setAssetCat(entryInfo.getAssetCat());
        newCard.setAccountDate(billInfo.getDeliverDate());
        newCard.setCurrency(billInfo.getCompany().getBaseCurrency());
        String remark = MessageFormat.format(ResourceBase.getString((String)RES_PATH, (String)"leaseDetails", (Locale)ctx.getOriginLocale()), billInfo.getLeasor(), billInfo.getDeliverDate(), billInfo.getBargainTime().setScale(0), billInfo.getMeasureUnit().getAlias(), billInfo.getBargainNum());
        newCard.setRemark(remark);
        newCard.setExRate(ONE);
        newCard.setAddonFare(entryInfo.getInitAmt());
        BigDecimal unAssuredAmt = entryInfo.getUnAssuredAmt() == null ? ZERO : entryInfo.getUnAssuredAmt();
        newCard.setOriginAmt(entryInfo.getHireLocalAmt().add(unAssuredAmt));
        newCard.setAssetValue(entryInfo.getHireLocalAmt().add(unAssuredAmt).add(entryInfo.getInitAmt()));
        newCard.setDeliverDate(billInfo.getDeliverDate());
        newCard.setStartUseDate(billInfo.getBeginDate());
        newCard.setUseTermCount(entryInfo.getDeprLife());
        newCard.setOriginFlag(FaCardOriginEnum.LEASEIN);
        newCard.setOriginType(FaFromUnitCatEnum.NULL);
        newCard.setSourceBillId(billInfo.getId().toString());
        newCard.setLeaseStatus(FaLeaseStatusEnum.FINANCE_LEASE_IN);
        newCard.setBizDate(DateTimeUtils.truncateDate((Date)this.getCurrentPeriod(ctx, newCard).getEndDate()));
        newCard.setAccuDepr(ZERO);
        newCard.setDecValue(ZERO);
        newCard.setNeatValue(newCard.getAssetValue().subtract(newCard.getAccuDepr()));
        newCard.setNeatAmt(newCard.getNeatValue().subtract(newCard.getDecValue()));
        int periodNumbers = this.getPeriodNumOfYear(ctx, this.getCurrentPeriod(ctx, billInfo));
        if (newCard.getUseTermCount() != null) {
            newCard.setUseYears(newCard.getUseTermCount().divide(new BigDecimal(periodNumbers), 1, 4));
        }
        return newCard;
    }

    private int getPeriodNumOfYear(Context ctx, PeriodInfo period) throws BOSException {
        int periodYear = period.getPeriodYear();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodYear", (Object)new Integer(periodYear), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)period.getPeriodType().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isAdjustPeriod", (Object)"0", CompareType.EQUALS));
        filter.setMaskString("#0 and #1 and #2");
        evi.setFilter(filter);
        PeriodCollection periodc = null;
        periodc = PeriodFactory.getLocalInstance((Context)ctx).getPeriodCollection(evi);
        if (periodc == null) {
            return 12;
        }
        int periodCount = periodc.size();
        return periodCount;
    }

    private FaClearBillInfo createClearBillInfo(Context ctx, FaLeaseInBillInfo billInfo) {
        FaClearBillInfo clearBillInfo = new FaClearBillInfo();
        clearBillInfo.setBillType(FaBillOriginEnum.FROM_LEASEIN_RETURN);
        clearBillInfo.setSourceBillId(billInfo.getId().toString());
        clearBillInfo.setCompany(billInfo.getCompany());
        clearBillInfo.setCU(billInfo.getCU());
        clearBillInfo.setCreateTime(new Timestamp(new Date().getTime()));
        clearBillInfo.setClearDate(DateTimeUtils.truncateDate((Date)new Date()));
        clearBillInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
        clearBillInfo.setHandler(ContextUtil.getCurrentUserInfo((Context)ctx));
        clearBillInfo.setDeletedStatus(DeletedStatusEnum.NORMAL);
        clearBillInfo.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
        clearBillInfo.setBlockedStatus(BlockedStatusEnum.UNBLOCKED);
        clearBillInfo.setFiVouchered(false);
        String desc = ResourceBase.getString((String)RES_PATH, (String)"faLeaseInBill", (Locale)ctx.getOriginLocale()) + billInfo.getNumber() + ResourceBase.getString((String)RES_PATH, (String)"returnClearBill", (Locale)ctx.getOriginLocale());
        clearBillInfo.setDescription(desc);
        FaLeaseInBillEntryCollection coll = billInfo.getEntry();
        FaClearBillEntryCollection entryColl = clearBillInfo.getClearBillEntry();
        for (int i = 0; i < coll.size(); ++i) {
            FaCurCardInfo curCardIno = coll.get(i).getFaCurCard();
            FaClearBillEntryInfo entryInfo = new FaClearBillEntryInfo();
            entryInfo.put("faCurCard", curCardIno.getId().toString());
            entryInfo.put("cardUpdateTime", curCardIno.getLastUpdateTime());
            entryInfo.setClrQty(curCardIno.getAssetAmt());
            entryInfo.setClrOriginal(curCardIno.getAssetValue());
            entryInfo.setClrAddupDep(curCardIno.getAccuDepr());
            entryInfo.setClrDecPrep(curCardIno.getDecValue());
            entryColl.add(entryInfo);
        }
        return clearBillInfo;
    }

    private FaLeaseInBillInfo getReletLeaseInBillInfo(Context ctx, FaLeaseInBillInfo leaseInBillinfo) {
        FaLeaseInBillInfo reletLeaseInBillInfo = (FaLeaseInBillInfo)leaseInBillinfo.clone();
        reletLeaseInBillInfo.setId(null);
        reletLeaseInBillInfo.setNumber(null);
        reletLeaseInBillInfo.setBargainNum(null);
        reletLeaseInBillInfo.setFiVouchered(false);
        reletLeaseInBillInfo.setVoucher(null);
        reletLeaseInBillInfo.setEffectedStatus(EffectedStatusEnum.TEMPSTORE);
        reletLeaseInBillInfo.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
        reletLeaseInBillInfo.setBizStatus(LeaseBizStatusEnum.RELETING);
        reletLeaseInBillInfo.setCreateTime(new Timestamp(new Date().getTime()));
        reletLeaseInBillInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
        Date today = DateTimeUtils.truncateDate((Date)new Date());
        reletLeaseInBillInfo.setBeginDate(today);
        reletLeaseInBillInfo.setMeasureUnit(DateUnitEnum.YEAR);
        BigDecimal leaseTime = new BigDecimal("1.0");
        reletLeaseInBillInfo.setBargainTime(leaseTime);
        Date endDate = DateTimeUtils.addYear((Date)today, (int)leaseTime.intValue());
        reletLeaseInBillInfo.setEndDate(endDate);
        reletLeaseInBillInfo.setDeliverDate(today);
        reletLeaseInBillInfo.setSignatureDate(today);
        reletLeaseInBillInfo.setAuditor(null);
        reletLeaseInBillInfo.setClearBill(null);
        reletLeaseInBillInfo.setLastUpdateTime(null);
        reletLeaseInBillInfo.setLastUpdateUser(null);
        reletLeaseInBillInfo.setBillType(FaBillOriginEnum.FROM_LEASEIN_RELET);
        FaLeaseInBillEntryCollection leaseInBillColl = reletLeaseInBillInfo.getEntry();
        for (int i = 0; i < leaseInBillColl.size(); ++i) {
            FaLeaseInBillEntryInfo aFaLeaseInBillEntryInfo = leaseInBillColl.get(i);
            aFaLeaseInBillEntryInfo.setId(null);
        }
        FaLeaseBalanceInEntryCollection balanceBillColl = reletLeaseInBillInfo.getBalanceEntry();
        for (int i = 0; i < balanceBillColl.size(); ++i) {
            FaLeaseBalanceInEntryInfo aFaLeaseBalanceInEntryInfo = balanceBillColl.get(i);
            aFaLeaseBalanceInEntryInfo.setId(null);
            aFaLeaseBalanceInEntryInfo.setBillID(null);
            aFaLeaseBalanceInEntryInfo.setBillNumber(null);
        }
        return reletLeaseInBillInfo;
    }

    private FaChangeBillInfo createChangeBillInfo(Context ctx, FaLeaseInBillInfo leaseInfo, FaLeaseInBillEntryInfo entryInfo) throws EASBizException, BOSException {
        BOSUuid curCardID = entryInfo.getFaCurCard().getId();
        SelectorItemCollection sic = PrcFaCoreManager.getCurCardSelectors();
        sic.add(new SelectorItemInfo("currency.*"));
        FaCurCardInfo curCard = FaCurCardFactory.getLocalInstance(ctx).getFaCurCardInfo((IObjectPK)new ObjectUuidPK(curCardID), sic);
        FaChangeBillInfo changeBillInfo = new FaChangeBillInfo();
        changeBillInfo.setBillType(FaBillOriginEnum.FROM_LEASEIN_BUY);
        changeBillInfo.setSourceBillId(leaseInfo.getId().toString());
        changeBillInfo.setCompany(leaseInfo.getCompany());
        changeBillInfo.setCU(leaseInfo.getCU());
        changeBillInfo.setDeletedStatus(DeletedStatusEnum.NORMAL);
        changeBillInfo.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
        changeBillInfo.setBlockedStatus(BlockedStatusEnum.UNBLOCKED);
        changeBillInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
        changeBillInfo.setHandler(ContextUtil.getCurrentUserInfo((Context)ctx));
        changeBillInfo.setFiVouchered(false);
        String desc = ResourceBase.getString((String)RES_PATH, (String)"faLeaseInBill", (Locale)ctx.getOriginLocale()) + leaseInfo.getNumber() + ResourceBase.getString((String)RES_PATH, (String)"buyChangeBill", (Locale)ctx.getOriginLocale());
        changeBillInfo.setDescription(desc);
        FaBakCardInfo bakCard = PrcFaCoreManager.CurCard2BakCard(curCard);
        bakCard.setFaCurCard(curCard);
        bakCard.setBillType(FaBillTypeEnum.CHANGE);
        FaChangeBillEntryInfo changebillEntryInfo = new FaChangeBillEntryInfo();
        FaBizCardInfo bizCard = PrcFaCoreManager.CurCard2BizCard(curCard);
        bizCard.setFaBakCard(bakCard);
        bizCard.setBillType(FaBillTypeEnum.CHANGE);
        bakCard.setId((BOSUuid)FaBakCardFactory.getLocalInstance(ctx).submit((CoreBaseInfo)bakCard).getKeyValue("id"));
        changebillEntryInfo.setBizCard(bizCard);
        changebillEntryInfo.setCurCard(curCard);
        changebillEntryInfo.setOriginChg(ZERO);
        changebillEntryInfo.setAccuDeprChg(ZERO);
        changebillEntryInfo.setDecValueChg(ZERO);
        changeBillInfo.getChangeBillEntry().add(changebillEntryInfo);
        this.setChangeBillNewNumber(ctx, changeBillInfo, 100);
        return changeBillInfo;
    }

    protected void setChangeBillNewNumber(Context ctx, FaChangeBillInfo billInfo, int deepNo) throws EASBizException, BOSException {
        if (deepNo == 0) {
            throw new CodingRuleException(CodingRuleException.ERROR_REFERENCE_INVALID);
        }
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitInfo aCompanyOrgUnitInfo = billInfo.getCompany();
        if (aCompanyOrgUnitInfo == null) {
            aCompanyOrgUnitInfo = ContextUtil.getCurrentFIUnit((Context)ctx);
        }
        String strCompanyId = aCompanyOrgUnitInfo.getId().toString();
        String number = iCodingRuleManager.getNumber((IObjectValue)billInfo, strCompanyId);
        billInfo.setNumber(number);
        if (this.existChangeBillNumber(ctx, (IObjectValue)billInfo)) {
            this.setChangeBillNewNumber(ctx, billInfo, deepNo - 1);
        }
    }

    protected boolean existChangeBillNumber(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        FaChangeBillInfo billInfo = (FaChangeBillInfo)model;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FID FROM T_FA_FACHANGEBILL WHERE FNUMBER = '");
        sql.append(billInfo.getNumber()).append("'");
        sql.append(" AND FCOMPANYID = '").append(billInfo.getCompany().getId().toString()).append("'");
        if (billInfo.getId() != null) {
            sql.append(" AND FID != '").append(billInfo.getId().toString()).append("'");
        }
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            return rowSet.next();
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected BillBaseInfo relet(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        IFaLeaseInBill iLeaseInBill = FaLeaseInBillFactory.getLocalInstance(ctx);
        FaLeaseInBillInfo billInfo = iLeaseInBill.getFaLeaseInBillInfo((IObjectPK)new ObjectUuidPK(billID));
        this.checkAtTermStatus(ctx, billInfo, true);
        this.updateLeaseInBillStatus(ctx, billID, 5);
        IFALeaseContract iFALeaseContract = FALeaseContractFactory.getLocalInstance(ctx);
        FALeaseContractCollection leaseContCollection = iFALeaseContract.getFALeaseContractCollection("select * where number ='" + billInfo.getBargainNum() + "' and company.id = '" + billInfo.getCompany().getId().toString() + "'");
        if (leaseContCollection == null || leaseContCollection.size() == 0) {
            FaLeaseInBillInfo leaseInBillInfo = this.getReletLeaseInBillInfo(ctx, billInfo);
            leaseInBillInfo.setSourceBillId(billID.toString());
            iLeaseInBill.save((CoreBaseInfo)leaseInBillInfo);
            return leaseInBillInfo;
        }
        FALeaseContractInfo reletLeaseContInfo = this.getReletContractInfo(ctx, leaseContCollection.get(0));
        reletLeaseContInfo.setSourceBillId(billID.toString());
        iFALeaseContract.save((CoreBaseInfo)reletLeaseContInfo);
        return reletLeaseContInfo;
    }

    private FALeaseContractInfo getReletContractInfo(Context ctx, FALeaseContractInfo leaseContInfo) {
        FALeaseContractInfo reletLeaseContInfo = (FALeaseContractInfo)leaseContInfo.clone();
        reletLeaseContInfo.setId(null);
        reletLeaseContInfo.setNumber(null);
        reletLeaseContInfo.setEffectedStatus(EffectedStatusEnum.TEMPSTORE);
        reletLeaseContInfo.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
        reletLeaseContInfo.setCreateTime(new Timestamp(new Date().getTime()));
        reletLeaseContInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
        Date today = DateTimeUtils.truncateDate((Date)new Date());
        reletLeaseContInfo.setEffectiveDate(today);
        reletLeaseContInfo.setSignDateA(today);
        reletLeaseContInfo.setSignDateB(today);
        reletLeaseContInfo.setSignDateC(today);
        reletLeaseContInfo.setLastUpdateTime(null);
        reletLeaseContInfo.setLastUpdateUser(null);
        return reletLeaseContInfo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void unAction(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("leaseType.number"));
        FaLeaseInBillInfo billInfo = FaLeaseInBillFactory.getLocalInstance(ctx).getFaLeaseInBillInfo((IObjectPK)new ObjectUuidPK(billID), selector);
        if (!LeaseBizStatusEnum.CLOSED.equals((Object)billInfo.getBizStatus())) throw new FaLeaseException(FaLeaseException.CANTUNACTION);
        StringBuffer sql = new StringBuffer();
        sql.append(" select fid,fnumber,FCheckedStatus,1 as billType from T_FA_FALeaseContract where FSourceBillID = '").append(billID.toString()).append("'");
        sql.append(" union all ");
        sql.append(" select fid,fnumber,FCheckedStatus,2 as billType from T_FA_FALeaseInBill where FSourceBillID = '").append(billID.toString()).append("'");
        IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (iRowSet.next()) {
                String id = iRowSet.getString("fid");
                String number = iRowSet.getString("fnumber");
                int checkedStatus = iRowSet.getInt("FCheckedStatus");
                int billType = iRowSet.getInt("billType");
                if (2 == checkedStatus) {
                    throw new FaLeaseException(billType == 1 ? FaLeaseException.RELETOCONTBILLAUDITED : FaLeaseException.RELETILEASEBILLAUDITED, new String[]{number});
                }
                FaLocalUtils.abortWfProcessByObjId(ctx, id);
                if (billType == 1) {
                    FALeaseContractFactory.getLocalInstance(ctx).deleteSelf((IObjectPK)new ObjectUuidPK(id));
                } else {
                    this.deleteBill(ctx, (IObjectPK)new ObjectUuidPK(id));
                }
            } else if (FINANCING_NUMBER.equals(billInfo.getLeaseType().getNumber())) {
                if (billInfo.getClearBill() == null) {
                    this.unBuy(ctx, billInfo);
                } else {
                    this.unGiveBack(ctx, billInfo);
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (FaBillOriginEnum.FROM_LEASEOUT_RELET.equals((Object)billInfo.getBillType()) && DateTimeUtils.truncateDate((Date)new Date()).before(billInfo.getEndDate())) {
            this.updateLeaseInBillStatus(ctx, billID, 4);
            return;
        } else {
            this.updateLeaseInBillStatus(ctx, billID, 2);
        }
    }

    @Override
    protected void generateVourcher(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
    }

    @Override
    protected SelectorItemCollection getStatusSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("leaseType.number"));
        return sic;
    }

    private void unGiveBack(Context ctx, FaLeaseInBillInfo billInfo) throws FaClearBillException, EASBizException, BOSException {
        SelectorItemCollection src = new SelectorItemCollection();
        src.add(new SelectorItemInfo("id"));
        src.add(new SelectorItemInfo("number"));
        src.add(new SelectorItemInfo("checkedStatus"));
        ObjectUuidPK objectUuidPK = new ObjectUuidPK(billInfo.getClearBill().getId());
        FaClearBillInfo clearBilInfo = FaClearBillFactory.getLocalInstance(ctx).getFaClearBillInfo((IObjectPK)objectUuidPK, src);
        if (CheckedStatusEnum.AUDITED.equals((Object)clearBilInfo.getCheckedStatus())) {
            throw new FaLeaseException(FaLeaseException.CANTUNGIVEBACK, new String[]{clearBilInfo.getNumber()});
        }
        PrcFaCoreManager prcFaCoreManager = new PrcFaCoreManager(new PrcFaClearStrategy());
        FaLocalUtils.abortWfProcessByObjId(ctx, billInfo.getClearBill().getId().toString());
        prcFaCoreManager.getFaManageStrategy().deleteBill(ctx, (IObjectPK)new ObjectUuidPK(billInfo.getClearBill().getId()));
        this.clearLeaseInEntryClearBillId(ctx, billInfo.getId());
    }

    private void unBuy(Context ctx, FaLeaseInBillInfo billInfo) throws EASBizException, BOSException {
        SelectorItemCollection src = new SelectorItemCollection();
        src.add(new SelectorItemInfo("id"));
        src.add(new SelectorItemInfo("entry.changeBill.id"));
        src.add(new SelectorItemInfo("entry.changeBill.number"));
        src.add(new SelectorItemInfo("entry.changeBill.checkedStatus"));
        ObjectUuidPK objectUuidPK = new ObjectUuidPK(billInfo.getId());
        FaLeaseInBillInfo leaseBilInfo = FaLeaseInBillFactory.getLocalInstance(ctx).getFaLeaseInBillInfo((IObjectPK)objectUuidPK, src);
        this.updateCurCardStatus(ctx, billInfo.getId(), 3);
        StringBuffer changeBillNumber = new StringBuffer();
        FaLeaseInBillEntryCollection entryColl = leaseBilInfo.getEntry();
        for (int i = 0; i < entryColl.size(); ++i) {
            FaChangeBillInfo changeBillInfo = entryColl.get(i).getChangeBill();
            if (!CheckedStatusEnum.AUDITED.equals((Object)changeBillInfo.getCheckedStatus())) continue;
            changeBillNumber.append(",").append(changeBillInfo.getNumber());
        }
        if (changeBillNumber.length() > 0) {
            throw new FaLeaseException(FaLeaseException.CANTUNBUY, new String[]{changeBillNumber.substring(1)});
        }
        PrcFaCoreManager prcFaCoreManager = new PrcFaCoreManager(new PrcFaChangeStrategy());
        for (int i = 0; i < entryColl.size(); ++i) {
            BOSUuid changeBillID = entryColl.get(i).getChangeBill().getId();
            FaLocalUtils.abortWfProcessByObjId(ctx, changeBillID.toString());
            prcFaCoreManager.getFaManageStrategy().deleteBill(ctx, (IObjectPK)new ObjectUuidPK(changeBillID));
        }
        this.clearLeaseInEntryChangeBillId(ctx, billInfo.getId());
    }

    private void updateCurCardStatus(Context ctx, BOSUuid id, int leaseStatus) throws BOSException {
        String updateCardSql = "update t_fa_facurcard set fleasestatus = ?  where fid in (" + this.getEntryCol("entry.fcurcardid") + ")";
        DbUtil.execute((Context)ctx, (String)updateCardSql, (Object[])new Object[]{new Integer(leaseStatus), id.toString()});
    }

    private String getEntryCol(String columnName) {
        return "select " + columnName + " from t_fa_faleaseinbill bill inner join t_fa_faleaseinbillentry entry on bill.fid = entry.fheadid where bill.fid = ?";
    }

    private void checkAtTermStatus(Context ctx, FaLeaseInBillInfo billInfo, boolean chekckAtTerm) throws BOSException, EASBizException {
        FaLocalUtils.checkPeriodConsistent(ctx, billInfo.getCompany(), billInfo.getPeriod(), false);
        if (CheckedStatusEnum.UNAUDITED.equals((Object)billInfo.getCheckedStatus())) {
            throw new FaLeaseException(FaLeaseException.UNAUDITLEASEINBILL);
        }
        if (LeaseBizStatusEnum.CLOSED.equals((Object)billInfo.getBizStatus())) {
            throw new FaLeaseException(FaLeaseException.LEASEINBILLHASCLOSE);
        }
        if (chekckAtTerm) {
            Date endDate = billInfo.getEndDate();
            Date curDate = new Date(System.currentTimeMillis());
            if ((curDate = this.formateDate(curDate)).before(endDate) || curDate.equals(endDate)) {
                throw new FaLeaseException(FaLeaseException.LEASEBILLNOTATTERM);
            }
        }
        FaLeaseBalanceBillFactory.getLocalInstance(ctx).checkUnAuditPayment((IObjectPK)new ObjectUuidPK(billInfo.getId()));
    }

    private Date formateDate(Date date) {
        date = date == null ? new Date() : date;
        Date newDate = date;
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String strDate = format.format(date);
        try {
            newDate = format.parse(strDate);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return newDate;
    }

    private void verifyBargainNum(Context ctx, IObjectValue model) throws BOSException, FaLeaseException {
        IRowSet iRowSet;
        StringBuffer sql;
        FaLeaseInBillInfo billInfo = (FaLeaseInBillInfo)model;
        String bargainNum = billInfo.getBargainNum();
        if (bargainNum == null || bargainNum.trim().length() == 0) {
            return;
        }
        if (!FaBillOriginEnum.FROM_LEASECONTRACT.equals((Object)billInfo.getBillType())) {
            sql = new StringBuffer();
            sql.append(" select fnumber from t_fa_faleasecontract where fnumber = '").append(bargainNum).append("'");
            sql.append(" and fcompanyid = '").append(billInfo.getCompany().getId().toString()).append("'");
            iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            try {
                if (iRowSet.next()) {
                    throw new FaLeaseException(FaLeaseException.BARGINNUMHASUSED, new String[]{bargainNum});
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        sql = new StringBuffer();
        sql.append(" select fnumber from t_fa_faleasebill where fBargainNum = '").append(bargainNum).append("'");
        sql.append(" and fcompanyid = '").append(billInfo.getCompany().getId().toString()).append("'");
        iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (iRowSet.next()) {
                String number = iRowSet.getString("fnumber");
                throw new FaLeaseException(FaLeaseException.BARGINNUMHASUSED2, new String[]{number, bargainNum});
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        sql = new StringBuffer();
        sql.append(" select fnumber from t_fa_faleaseinbill where fBargainNum = '").append(bargainNum).append("'");
        sql.append(" and fcompanyid = '").append(billInfo.getCompany().getId().toString()).append("'");
        if (billInfo.getId() != null) {
            sql.append(" and fid != '").append(billInfo.getId().toString()).append("'");
        }
        iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (iRowSet.next()) {
                String number = iRowSet.getString("fnumber");
                throw new FaLeaseException(FaLeaseException.BARGINNUMHASUSED1, new String[]{number, bargainNum});
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void updateLeaseInBillStatus(Context ctx, BOSUuid leaseInBillID, int status) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("update t_fa_faleaseinbill set fbizStatus = ").append(status);
        sql.append(" where fid = '").append(leaseInBillID).append("'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private void clearLeaseInEntryChangeBillId(Context ctx, BOSUuid leaseInBillID) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("update t_fa_faleaseinbillentry set fchangebillid = null where fheadid = '").append(leaseInBillID).append("'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private void clearLeaseInEntryClearBillId(Context ctx, BOSUuid leaseInBillID) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("update t_fa_faleaseinbill set fclearbillid = null where fid = '").append(leaseInBillID).append("'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private void setClearBillID(Context ctx, BOSUuid billID, IObjectPK clearBillPK) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("update t_fa_faleaseinbill set fclearbillid = '").append(clearBillPK).append("'");
        sql.append(" where fid = '").append(billID).append("'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private void setChangeBillID(Context ctx, BOSUuid id, IObjectPK changeBillPK) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("update t_fa_faleaseinbillentry set fchangebillid = '").append(changeBillPK).append("'");
        sql.append(" where fid = '").append(id).append("'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private void clearLeaseInEntryCardId(Context ctx, BOSUuid leaseInBillID) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("update t_fa_faleaseinbillentry set fcurcardid = null where fheadid = '").append(leaseInBillID).append("'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private String getAuditedCard(Context ctx, BOSUuid id) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select c.fnumber as cardNumber,c.fassetname as cardName from t_fa_faleaseinbill b ");
        sql.append(" inner join t_fa_faleaseinbillentry e on b.fid = e.fheadid");
        sql.append(" inner join t_fa_facurcard c on c.fid = e.fcurcardid");
        sql.append(" where c.fcheckedstatus = ").append(2);
        sql.append(" and b.fid = '").append(id).append("'");
        IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        StringBuffer msg = new StringBuffer();
        try {
            while (iRowSet.next()) {
                msg.append("\u3001");
                String cardNumber = iRowSet.getString("cardNumber");
                String cardName = iRowSet.getString("cardName");
                msg.append(cardNumber).append("(").append(cardName).append(")");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return msg.length() == 0 ? null : msg.substring(1);
    }

    private String getPaymentBills(Context ctx, BOSUuid id) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select e.fnumber as FNumber,e.FIsPayment as isPayment from t_Fa_Faleasebalancebill b ");
        sql.append(" inner join T_FA_FaLeaseBalanceEntry e on b.fid = e.fbillid");
        sql.append(" where b.FLeaseInBillID = '").append(id).append("'");
        IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        StringBuffer msg = new StringBuffer();
        StringBuffer gatherMsg = new StringBuffer();
        StringBuffer paymentMsg = new StringBuffer();
        String gatheringBill = ResourceBase.getString((String)RES_PATH, (String)"gatheringBill", (Locale)ctx.getOriginLocale());
        String paymentBill = ResourceBase.getString((String)RES_PATH, (String)"paymentBill", (Locale)ctx.getOriginLocale());
        try {
            while (iRowSet.next()) {
                if (iRowSet.getBoolean("isPayment")) {
                    paymentMsg.append("\u3001");
                    paymentMsg.append(iRowSet.getString("FNumber"));
                    continue;
                }
                gatherMsg.append("\u3001");
                gatherMsg.append(iRowSet.getString("FNumber"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (gatherMsg.length() > 0) {
            msg.append(gatheringBill).append(gatherMsg.substring(1));
        }
        if (paymentMsg.length() > 0) {
            if (gatherMsg.length() > 0) {
                msg.append("\uff0c");
            }
            msg.append(paymentBill).append(paymentMsg.substring(1));
        }
        return msg.length() == 0 ? null : msg.toString();
    }

    private void updateEntryCardID(Context ctx, BOSUuid entryID, IObjectPK curCardPK) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("update t_fa_faleaseinbillentry set fcurcardid = '").append(curCardPK).append("'");
        sql.append(",fcardNumber = (select c.fnumber from t_fa_facurcard c where c.fid = '").append(curCardPK).append("')");
        sql.append(" where fid = '").append(entryID).append("'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private IObjectPK innerSaveBill(Context ctx, FaLeaseInBillInfo info, boolean isSubmit) throws BOSException, EASBizException {
        this.verifyBargainNum(ctx, (IObjectValue)info);
        info.setPeriod(this.getCurrentPeriod(ctx, info));
        info.setBizDate(DateTimeUtils.truncateDate((Date)new Date()));
        info.setDeletedStatus(DeletedStatusEnum.NORMAL);
        info.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
        info.setBlockedStatus(BlockedStatusEnum.UNBLOCKED);
        info.setFiVouchered(false);
        info.setHasEffected(true);
        info.setEffectedStatus(isSubmit ? EffectedStatusEnum.EFFECTED : EffectedStatusEnum.TEMPSTORE);
        IFaLeaseInBill iLeaseInBill = FaLeaseInBillFactory.getLocalInstance(ctx);
        PrcFaLeaseInStrategy.setBillInfoNumber(ctx, info, iLeaseInBill);
        return isSubmit ? iLeaseInBill.submitSelf(info) : iLeaseInBill.saveSelf(info);
    }
}

