/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.FaBillTypeEnum;
import com.kingdee.eas.fi.fa.manage.FaBizStatusEnum;
import com.kingdee.eas.fi.fa.manage.FaCardException;
import com.kingdee.eas.fi.fa.manage.FaCurCardFactory;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.fi.fa.manage.FaMaintainEntryCollection;
import com.kingdee.eas.fi.fa.manage.FaMaintainEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaMaintainFactory;
import com.kingdee.eas.fi.fa.manage.FaMaintainInfo;
import com.kingdee.eas.fi.fa.manage.IFaMaintain;
import com.kingdee.eas.fi.fa.manage.app.AbstractPrcFaManageStrategy;
import com.kingdee.eas.fi.fa.manage.app.FaLastPeriodChangeUtils;
import com.kingdee.eas.fi.fa.manage.app.FaLocalUtils;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;

public class PrcFaMaintainStrategy
extends AbstractPrcFaManageStrategy {
    @Override
    protected void deleteBill(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        IFaMaintain iFaMaintain = FaMaintainFactory.getLocalInstance(ctx);
        FaMaintainInfo billInfo = iFaMaintain.getFaMaintainInfo("SELECT id,number,company WHERE id ='" + pk + "'");
        FaLastPeriodChangeUtils.restoreBakAndCleanUp(ctx, (CoreBaseInfo)billInfo, new String[]{"fbizstatus", "flastbillid"}, null);
        this.recycleNumber(ctx, billInfo);
        iFaMaintain.deleteSelf(pk);
        DbUtil.execute((Context)ctx, (String)"update t_fa_facurcard set fbizstatus = ?,flastupdatetime = GETDATE() where fid in (select FCurCardID from t_fa_famaintainentry where FEntryID =? )", (Object[])new Object[]{"9999", billInfo.get("id").toString()});
    }

    @Override
    protected IObjectPK saveBill(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        return this.innerSaveBill(ctx, (FaMaintainInfo)model, false);
    }

    @Override
    protected IObjectPK submitBill(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        return this.innerSaveBill(ctx, (FaMaintainInfo)model, true);
    }

    @Override
    protected void auditBill(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        DbUtil.execute((Context)ctx, (String)"update t_fa_facurcard set fbizstatus = ?,flastupdatetime = GETDATE() where fid in (select FCurCardID from t_fa_famaintainentry where FEntryID =? )", (Object[])new Object[]{"1299", model.get("id").toString()});
        FaMaintainInfo faMaintainInfo = (FaMaintainInfo)model;
        FaMaintainFactory.getLocalInstance(ctx).passAuditSelf((IObjectPK)new ObjectStringPK(faMaintainInfo.getId().toString()), faMaintainInfo);
    }

    @Override
    protected void unAuditBill(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        DbUtil.execute((Context)ctx, (String)"update t_fa_facurcard set fbizstatus = ?,flastupdatetime = GETDATE() where fid in (select FCurCardID from t_fa_famaintainentry where FEntryID =? )", (Object[])new Object[]{"1201", model.get("id").toString()});
        FaMaintainInfo faMaintainInfo = (FaMaintainInfo)model;
        FaMaintainFactory.getLocalInstance(ctx).unpassAuditSelf((IObjectPK)new ObjectStringPK(faMaintainInfo.getId().toString()), faMaintainInfo);
    }

    @Override
    protected void generateVourcher(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
    }

    private IObjectPK innerSaveBill(Context ctx, FaMaintainInfo info, boolean isSubmit) throws BOSException, EASBizException {
        IFaMaintain iMaintain = FaMaintainFactory.getLocalInstance(ctx);
        info.setMaintainBeginDate(DateTimeUtils.truncateDate((Date)info.getMaintainBeginDate()));
        info.setMaintainEndDate(DateTimeUtils.truncateDate((Date)info.getMaintainEndDate()));
        PrcFaMaintainStrategy.setBillInfoNumber(ctx, info, iMaintain);
        this.checkFaCurCardValid(ctx, this.getCardColFromEntry((IObjectCollection)info.getMaintainEntry()));
        FaLastPeriodChangeUtils.restoreBakAndCleanUp(ctx, (CoreBaseInfo)info, new String[]{"fbizstatus", "flastbillid"}, null);
        Map tempTableNames = PrcFaMaintainStrategy.createBizBakTempTable(ctx);
        IObjectPK billId = isSubmit ? iMaintain.submitSelf(info) : iMaintain.saveSelf(info);
        String selectCardId = "SELECT fcurcardid FROM T_FA_FaMaintainEntry WHERE FEntryID = '" + billId + "'";
        this.saveBizBakCard(ctx, new String[]{selectCardId, "T_FA_FaMaintainEntry", billId.toString(), "FEntryID"}, FaBillTypeEnum.MAINTAIN, FaBizStatusEnum.MAINTAINING, tempTableNames);
        return billId;
    }

    @Override
    protected void checkForAudit(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        super.checkForAudit(ctx, pk);
    }

    @Override
    protected void checkForUnAudit(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        super.checkForUnAudit(ctx, pk);
    }

    @Override
    protected void checkForUnAudit(Context ctx, BillBaseInfo billInfo, boolean isFromSource) throws EASBizException, BOSException {
        FaMaintainInfo billInfo1 = (FaMaintainInfo)billInfo;
        StringBuffer sbHasCapOrExpense = new StringBuffer();
        if (billInfo1.getAlreadyCapitalMeltAmout() != null && billInfo1.getAlreadyCapitalMeltAmout().compareTo(new BigDecimal("0")) != 0) {
            sbHasCapOrExpense.append(ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.FaMaintainResource", (String)"Has_Cap", (Locale)ctx.getOriginLocale()));
            throw new FaCardException(FaCardException.CANNOT_BE_UNAUDITED, new String[]{"", sbHasCapOrExpense.toString()});
        }
        if (billInfo1.getAlreadyExpenseMeltAmout() != null && billInfo1.getAlreadyExpenseMeltAmout().compareTo(new BigDecimal("0")) != 0) {
            sbHasCapOrExpense.append(ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.FaMaintainResource", (String)"Has_Expense", (Locale)ctx.getOriginLocale()));
            throw new FaCardException(FaCardException.CANNOT_BE_UNAUDITED, new String[]{"", sbHasCapOrExpense.toString()});
        }
        FaMaintainEntryCollection maintainBillEntryCol = billInfo1.getMaintainEntry();
        Iterator iMaintainEntry = maintainBillEntryCol.iterator();
        while (iMaintainEntry.hasNext()) {
            FaMaintainEntryInfo element = (FaMaintainEntryInfo)iMaintainEntry.next();
            FaCurCardInfo curCard = element.getFaCurCard();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("lastBillID"));
            sic.add(new SelectorItemInfo("assetName"));
            sic.add(new SelectorItemInfo("number"));
            curCard = FaCurCardFactory.getLocalInstance(ctx).getFaCurCardInfo((IObjectPK)new ObjectUuidPK(curCard.getId()), sic);
            if (curCard.getLastBillID() == null || curCard.getLastBillID().equals(billInfo1.getId().toString())) continue;
            throw new FaCardException(FaCardException.CURCARD_HASOTHEROPRATION, new String[]{curCard.getNumber() + "(" + curCard.getAssetName() + ")", "", FaLocalUtils.getEntityAlias(ctx, BOSUuid.getBOSObjectType((String)curCard.getLastBillID(), (boolean)false))});
        }
    }

    @Override
    protected SelectorItemCollection getStatusSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo(" maintainEntry.*"));
        return sic;
    }
}

