/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.FaBillBaseInfo;
import com.kingdee.eas.fi.fa.manage.FaBillTypeEnum;
import com.kingdee.eas.fi.fa.manage.FaBizStatusEnum;
import com.kingdee.eas.fi.fa.manage.FaStocktakingBillFactory;
import com.kingdee.eas.fi.fa.manage.FaStocktakingBillInfo;
import com.kingdee.eas.fi.fa.manage.FaStocktakingException;
import com.kingdee.eas.fi.fa.manage.FaStocktakingTaskBillFactory;
import com.kingdee.eas.fi.fa.manage.IFaStocktakingBill;
import com.kingdee.eas.fi.fa.manage.IFaStocktakingTaskBill;
import com.kingdee.eas.fi.fa.manage.app.AbstractPrcFaManageStrategy;
import com.kingdee.eas.fi.fa.manage.app.FaLastPeriodChangeUtils;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.DateTimeUtils;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Map;

public class PrcFaStocktakingStrategy
extends AbstractPrcFaManageStrategy {
    @Override
    protected void auditBill(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        String id = model.get("id").toString();
        String sql = "update t_fa_stocktakingtaskbill set FStocktakingStatus = 4,flastupdatetime=? where fid = (select ftaskbillid from t_fa_stocktakingbill where fid = ?)";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Date(System.currentTimeMillis()), id});
        sql = "update t_fa_stocktakingbill set FStocktakingStatus = 2,flastupdatetime=? where fid = ?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Date(System.currentTimeMillis()), id});
        sql = "update t_fa_facurcard set FBlockedStatus = 1,FBizStatus='1099',flastupdatetime=? where fid in (select fcurcardid from t_fa_stocktakingbillentry where fbillid = ?)";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Date(System.currentTimeMillis()), id});
        FaStocktakingBillFactory.getLocalInstance(ctx).passAuditSelf((IObjectPK)new ObjectUuidPK(id), (FaBillBaseInfo)model);
    }

    @Override
    protected void deleteBill(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        String sql = "update t_fa_stocktakingtaskbill set FStocktakingStatus = 2,flastupdatetime=? where fid = (select ftaskbillid from t_fa_stocktakingbill where fid = ?)";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Date(System.currentTimeMillis()), pk.toString()});
        IFaStocktakingBill iStock = FaStocktakingBillFactory.getLocalInstance(ctx);
        FaStocktakingBillInfo billInfo = iStock.getFaStocktakingBillInfo("select id,number,company where id ='" + pk + "'");
        FaLastPeriodChangeUtils.restoreBakAndCleanUp(ctx, (CoreBaseInfo)billInfo, new String[]{"fbizstatus", "flastbillid", "fblockedstatus"}, null);
        this.recycleNumber(ctx, billInfo);
        iStock.deleteSelf(pk);
    }

    @Override
    protected void generateVourcher(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
    }

    @Override
    protected IObjectPK saveBill(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        return this.innerSaveBill(ctx, model, false);
    }

    private IObjectPK innerSaveBill(Context ctx, IObjectValue model, boolean isSubmit) throws BOSException, EASBizException {
        FaStocktakingBillInfo info = (FaStocktakingBillInfo)model;
        IFaStocktakingBill iStock = FaStocktakingBillFactory.getLocalInstance(ctx);
        IFaStocktakingTaskBill iStockTask = FaStocktakingTaskBillFactory.getLocalInstance(ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getTaskBill().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("stocktakingStatus", (Object)new Integer(2)));
        filter.getFilterItems().add(new FilterItemInfo("stocktakingStatus", (Object)new Integer(3)));
        filter.setMaskString("#0 and (#1 or #2)");
        if (!iStockTask.exists(filter)) {
            throw new FaStocktakingException(FaStocktakingException.TASKINFO_NOT_SYC);
        }
        if (info.getBeginDate() != null) {
            info.setBeginDate(DateTimeUtils.truncateDate((java.util.Date)info.getBeginDate()));
        }
        if (info.getEndDate() != null) {
            info.setEndDate(DateTimeUtils.truncateDate((java.util.Date)info.getEndDate()));
        }
        PrcFaStocktakingStrategy.setBillInfoNumber(ctx, info, iStock);
        this.checkFaCurCardValid(ctx, this.getCardColFromEntry((IObjectCollection)info.getEntries()));
        FaLastPeriodChangeUtils.restoreBakAndCleanUp(ctx, (CoreBaseInfo)info, new String[]{"fbizstatus", "flastbillid", "fblockedstatus"}, null);
        Map tempTableNames = PrcFaStocktakingStrategy.createBizBakTempTable(ctx);
        IObjectPK pk = isSubmit ? iStock.submitSelf(info) : iStock.saveSelf(info);
        String selectCardId = "select fcurcardid from t_fa_stocktakingbillentry entry where fbillid = '" + pk + "'";
        this.saveBizBakCard(ctx, new String[]{selectCardId, "t_fa_stocktakingbillentry", pk.toString(), "FBillID"}, FaBillTypeEnum.STOCKTAKING, FaBizStatusEnum.STOCKING, tempTableNames);
        String sql = "update t_fa_stocktakingtaskbill set FStocktakingStatus = 3,flastupdatetime=? where fid = ?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Timestamp(System.currentTimeMillis()), info.getTaskBill().getId().toString()});
        if (info.getTaskBill().isBlockCard()) {
            sql = "update t_fa_facurcard set FBlockedStatus = 2,flastupdatetime=? where fid in (select fcurcardid from t_fa_stocktakingbillentry where fbillid = ?)";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Timestamp(System.currentTimeMillis()), pk.toString()});
        }
        return pk;
    }

    @Override
    protected IObjectPK submitBill(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        return this.innerSaveBill(ctx, model, true);
    }

    @Override
    protected void unAuditBill(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        String id = model.get("id").toString();
        String sql = "update t_fa_stocktakingtaskbill set FStocktakingStatus = 3,flastupdatetime=? where fid = (select ftaskbillid from t_fa_stocktakingbill where fid = ?)";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Timestamp(System.currentTimeMillis()), id});
        sql = "update t_fa_stocktakingbill set FStocktakingStatus = 1,flastupdatetime=? where fid = ?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Timestamp(System.currentTimeMillis()), id});
        boolean blockCard = FaStocktakingBillFactory.getLocalInstance(ctx).exists("where taskBill.blockCard=1 and id ='" + id + "'");
        sql = blockCard ? "update t_fa_facurcard set FBlockedStatus = 2,FBizStatus='1001',flastupdatetime=? where fid in (select fcurcardid from t_fa_stocktakingbillentry where fbillid = ?)" : "update t_fa_facurcard set FBizStatus='1001',flastupdatetime=? where fid in (select fcurcardid from t_fa_stocktakingbillentry where fbillid = ?)";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Timestamp(System.currentTimeMillis()), id});
        FaStocktakingBillFactory.getLocalInstance(ctx).unpassAuditSelf((IObjectPK)new ObjectUuidPK(id), (FaBillBaseInfo)model);
    }

    @Override
    protected void checkForAudit(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        super.checkForAudit(ctx, pk);
    }

    @Override
    protected void checkForDelete(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        super.checkForDelete(ctx, pk);
    }

    @Override
    protected void checkForUnAudit(Context ctx, BillBaseInfo billInfo, boolean isFromSource) throws EASBizException, BOSException {
        super.checkForUnAudit(ctx, billInfo, isFromSource);
        FaStocktakingBillInfo _billInfo = (FaStocktakingBillInfo)billInfo;
        if (_billInfo.getStocktakingStatus().getValue() != 2) {
            throw new FaStocktakingException(FaStocktakingException.TASKINFO_NOT_SYC);
        }
    }
}

