/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app.dataimp;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.FaCardCache;
import com.kingdee.eas.fi.fa.manage.FaDataImportFacadeFactory;
import com.kingdee.eas.fi.fa.manage.TaskEntryInfo;
import com.kingdee.eas.fi.fa.manage.TaskInfo;
import com.kingdee.eas.fi.fa.manage.app.dataimp.AbstractFaDataImport;
import com.kingdee.eas.fi.fa.manage.app.dataimp.FaDataImportReader;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.tools.datatask.ErrorHandleModeEnum;
import com.kingdee.eas.tools.datatask.TaskStateEnum;
import com.kingdee.eas.tools.datatask.log.SysLog;
import com.kingdee.eas.tools.datatask.record.RecordCollection;
import com.kingdee.eas.tools.datatask.task.FileUtil;
import com.kingdee.eas.tools.datatask.task.ITaskParameter;
import com.kingdee.eas.tools.datatask.task.TaskExternalCode;
import com.kingdee.eas.tools.datatask.task.TaskTemplateAdapter;
import com.kingdee.eas.tools.datatask.task.util.TaskRunnerException;
import com.kingdee.eas.tools.datatask.util.EASServerResource;
import com.kingdee.eas.util.ResourceBase;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class AbstractFaBatchDataRunner {
    private static Logger logger = SysLog.getLogger(AbstractFaBatchDataRunner.class);
    private Context ctx;
    private String cacheId = this.getClass().getName() + "_" + BOSUuid.create((String)"ABCD1234");
    private Map<String, Object> result = new HashMap<String, Object>();
    private Map<String, Object> iResult = null;
    private List<String> errors = null;
    protected ErrorHandleModeEnum errorHandleMode = null;
    protected boolean continueCondition = false;
    private int nCurCount;
    private int nSuccessCount;
    private int nFailCount;
    private Locale locale = null;
    private String sheetName = "";
    private int blockSize = 1000;
    private TaskEntryInfo taskEntry = null;

    public void beforeImport(Context ctx, Map params) throws Exception {
        this.taskEntry = new TaskEntryInfo();
        this.taskEntry.setTaskId((String)params.get("taskId"));
        this.taskEntry.setStep(0);
        FaCardCache.initCache(this.cacheId);
    }

    public void afterImport(Context ctx, Map params) {
        FaCardCache.clearCache(this.cacheId);
    }

    public boolean isContinueCondition() {
        return this.continueCondition;
    }

    public Map importData(Context ctx, Map params) throws Throwable {
        this.ctx = ctx;
        this.progress(ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"259_AbstractFaBatchDataRunner", (Locale)ctx.getLocale()));
        this.locale = ctx.getLocale();
        DatataskParameter param = (DatataskParameter)params.get("param");
        String fileName = param.getOpenFileName();
        String fileType = param.getFileType();
        ArrayList sheetNames = (ArrayList)params.get("sheetNames");
        Integer tBlockSize = (Integer)params.get("blockSize");
        if (tBlockSize != null && tBlockSize > 0) {
            this.blockSize = tBlockSize;
        }
        this.errorHandleMode = (ErrorHandleModeEnum)param.getContextParam().get("errorHandleMode");
        this.continueCondition = true;
        List<String[]> solutions = this.getSolutions(ctx, params);
        try {
            for (String[] solution : solutions) {
                if (!this.continueCondition) break;
                String alias = solution[0];
                String solutionName = solution[1];
                if (!sheetNames.contains(alias)) continue;
                param.alias = alias;
                param.solutionName = solutionName;
                this.importSheet(ctx, param);
            }
            int r = this.result.containsKey("state") ? 2 : 1;
            this.updateTask(100, 2, r);
        }
        catch (Throwable t) {
            this.progress(t.getMessage());
            this.updateTask(100, 2, 2);
            throw t;
        }
        finally {
            this.progress(ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"260_AbstractFaBatchDataRunner", (Locale)ctx.getLocale()));
            FileUtil.removeFile((String)fileName);
        }
        if (!this.result.containsKey("state")) {
            this.result.put("state", TaskStateEnum.SUCCESSEND);
        }
        return this.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void importSheet(Context ctx, DatataskParameter param) throws Exception {
        this.sheetName = param.alias;
        TaskExternalCode taskCode = TaskTemplateAdapter.getTaskExternalCode((String)param.solutionName, (Context)ctx);
        taskCode.setTaskParameter((ITaskParameter)param);
        Class<?> classDefinition = Class.forName(taskCode.getDataTransmissionClassName());
        AbstractFaDataImport iObject = (AbstractFaDataImport)((Object)classDefinition.newInstance());
        HashMap<String, Integer> contextParam = new HashMap<String, Integer>();
        DatataskParameter dp = (DatataskParameter)taskCode.getTaskParameter();
        Map myParam = dp.getContextParam();
        if (myParam != null) {
            contextParam.putAll(myParam);
        }
        contextParam.put("DATATASKMODE", new Integer(dp.datataskMode));
        iObject.setContextParameter(contextParam);
        this.iResult = new HashMap<String, Object>();
        this.result.put(this.sheetName, this.iResult);
        this.errors = new LinkedList<String>();
        this.iResult.put("errors", this.errors);
        try (FaDataImportReader reader = new FaDataImportReader(taskCode, ctx.getLocale(), this.blockSize);){
            int index = -1;
            this.nSuccessCount = 0;
            this.nFailCount = 0;
            while (reader.hasNextBlock() && this.continueCondition) {
                this.progress(param.alias + ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"261_AbstractFaBatchDataRunner", (Locale)ctx.getLocale()));
                RecordCollection coll = reader.getNextBlock();
                if (index < 0) {
                    index = reader.getBiginIndex();
                }
                if (coll == null || coll.size() <= 0) continue;
                this.nSuccessCount += iObject.importData(ctx, this, param, coll, index);
                index += coll.size();
            }
            this.iResult.put("nSuccessCount", this.nSuccessCount);
            this.iResult.put("nFailCount", this.nFailCount);
            if (this.nFailCount > 0) {
                this.result.put("state", TaskStateEnum.FAILEND);
            }
        }
    }

    protected List<String[]> getSolutions(Context ctx, Map params) {
        ArrayList<String[]> solutions = new ArrayList<String[]>();
        return solutions;
    }

    public void onDataError(int index, Object error) throws TaskRunnerException {
        if (this.errorHandleMode == null || this.errorHandleMode.equals((Object)ErrorHandleModeEnum.ReturnRightnow)) {
            this.continueCondition = false;
        }
        this.nCurCount = index;
        String cause = error instanceof Throwable ? ((Throwable)error).getMessage() : error.toString();
        String errMsg = this.getMsgOnDataErr();
        this.errors.add(errMsg + "\n" + cause);
        ++this.nFailCount;
    }

    protected String getMsgOnDataErr() {
        String rowNumber = String.valueOf(this.nCurCount);
        return EASServerResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"importNo", (Locale)this.locale) + rowNumber + EASServerResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"lineData", (Locale)this.locale);
    }

    public void updateTask(int progress, int status, int result) throws EASBizException, BOSException {
        try {
            TaskInfo task = new TaskInfo();
            task.setId(this.taskEntry.getTaskId());
            task.setProgress(progress);
            task.setStatus(status);
            task.setResult(result);
            FaDataImportFacadeFactory.getLocalInstance(this.ctx).updateTask(task);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void progress(String content) throws EASBizException, BOSException {
        try {
            if (content != null) {
                if (content.length() > 120) {
                    content = content.substring(0, 120);
                }
                this.taskEntry.setStep(this.taskEntry.getStep() + 1);
                this.taskEntry.setContent(content);
                FaDataImportFacadeFactory.getLocalInstance(this.ctx).addTaskEntry(this.taskEntry);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

