/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app.dataimp;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.FaBizStatusEnum;
import com.kingdee.eas.fi.fa.manage.FaCardCache;
import com.kingdee.eas.fi.fa.manage.FaCardInfo;
import com.kingdee.eas.fi.fa.manage.FaCardOriginEnum;
import com.kingdee.eas.fi.fa.manage.FaCardValidatorImpl;
import com.kingdee.eas.fi.fa.manage.FaCurAsstActCompositCollection;
import com.kingdee.eas.fi.fa.manage.FaCurAsstActCompositFactory;
import com.kingdee.eas.fi.fa.manage.FaCurAsstActCompositInfo;
import com.kingdee.eas.fi.fa.manage.FaCurCardFactory;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.fi.fa.manage.FaCurCostCenterCollection;
import com.kingdee.eas.fi.fa.manage.FaCurCostCenterInfo;
import com.kingdee.eas.fi.fa.manage.FaDepreciationFactory;
import com.kingdee.eas.fi.fa.manage.FaManageUtils;
import com.kingdee.eas.fi.fa.manage.FaMonCardInfo;
import com.kingdee.eas.fi.fa.manage.app.FaLocalUtils;
import com.kingdee.eas.fi.fa.manage.app.PrcFaCoreManager;
import com.kingdee.eas.fi.fa.manage.app.dataimp.FaDataImportUtils;
import com.kingdee.eas.fi.fa.manage.app.dataimp.FaMonCardDataImport;
import com.kingdee.eas.framework.CheckedStatusEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.EffectedStatusEnum;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.NumericExceptionSubItem;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;

public class FaCurCardDataImport
extends FaMonCardDataImport {
    private Boolean isDepCal = null;

    @Override
    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return FaCurCardFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        try {
            boolean isUseOneRule;
            if (coreBaseInfo.getId() != null) {
                if (coreBaseInfo instanceof FaCurCardInfo) {
                    FaCurCardInfo curCard = (FaCurCardInfo)coreBaseInfo;
                    FaCurCostCenterCollection curCostCenter = curCard.getFaCurCostCenter();
                    for (int i = 0; i < curCostCenter.size(); ++i) {
                        FaCurCostCenterInfo curCostCenterInfo = curCostCenter.get(i);
                        FaCurAsstActCompositCollection asstActCollection = curCostCenterInfo.getFaCurAsstActComposit();
                        for (int j = 0; j < asstActCollection.size(); ++j) {
                            FaCurAsstActCompositInfo asstActInfo = asstActCollection.get(j);
                            if (asstActInfo.getAsstActItem() != null && asstActInfo.getAsstActType() != null) continue;
                            String asstActId = asstActInfo.getId().toString();
                            FaCurAsstActCompositInfo dataBaseAsstActInfo = FaCurAsstActCompositFactory.getLocalInstance(ctx).getFaCurAsstActCompositInfo((IObjectPK)new ObjectUuidPK(asstActId));
                            asstActInfo.setAsstActType(dataBaseAsstActInfo.getAsstActType());
                            asstActInfo.setAsstActItem(dataBaseAsstActInfo.getAsstActItem());
                        }
                    }
                }
                this.getController(ctx).update((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()), coreBaseInfo);
            } else {
                this.getController(ctx).addnew(coreBaseInfo);
            }
            coreBaseInfo.put("isNewCard", (Object)true);
            FaCardCache cache = FaCardCache.getCache();
            if (coreBaseInfo instanceof FaCurCardInfo && cache != null) {
                cache.cacheCurCard((FaCurCardInfo)coreBaseInfo);
            }
            if ((isUseOneRule = "true".equals(this.hmParam.get("FA_033").toString())) && coreBaseInfo.getId() != null && coreBaseInfo instanceof FaCurCardInfo) {
                FaCurCardInfo curCard = (FaCurCardInfo)coreBaseInfo;
                curCard.setNumber(null);
                curCard.setEffectedStatus(EffectedStatusEnum.EFFECTED);
                this.setNewCardNumber(ctx, curCard);
                if (!FaCurCardFactory.getLocalInstance(ctx).exists("where number = '" + curCard.getNumber() + "' and company.id = '" + curCard.getCompany().getId().toString() + "'") && CodingRuleManagerFactory.getLocalInstance((Context)ctx).isExist((IObjectValue)curCard, curCard.getCompany().getId().toString(), "effectedStatus") && CodingRuleManagerFactory.getLocalInstance((Context)ctx).isUseIntermitNumber((IObjectValue)curCard, curCard.getCompany().getId().toString(), "effectedStatus")) {
                    CodingRuleManagerFactory.getLocalInstance((Context)ctx).recycleNumber((IObjectValue)curCard, curCard.getCompany().getId().toString(), "effectedStatus", "", curCard.getNumber());
                }
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), (Throwable)ex);
        }
    }

    @Override
    public CoreBaseInfo transmit(Hashtable data, Context ctx) throws TaskExternalException {
        FaMonCardInfo _moncard = (FaMonCardInfo)super.transmit(data, ctx);
        FaCurCardInfo _curcard = FaManageUtils.MonCard2CurCard(_moncard);
        _curcard.setId(_moncard.getId());
        _curcard.setDescription("import");
        try {
            PeriodInfo period = null;
            PeriodInfo info = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)_curcard.getCompany());
            period = _curcard.getFiAccountDate() != null ? (DateTimeUtils.dayAfter((Date)_curcard.getFiAccountDate(), (Date)info.getEndDate()) ? PeriodUtils.getPeriodInfo((Context)ctx, (Date)_curcard.getFiAccountDate(), (CompanyOrgUnitInfo)_curcard.getCompany()) : info) : info;
            if (period != null && period.isIsAdjustPeriod()) {
                throw new EASBizException(new NumericExceptionSubItem("1", ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"328_AdjustmentPeriodNoBusiness", (Locale)ctx.getOriginLocale())));
            }
            _curcard.setPeriod(period);
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return _curcard;
    }

    @Override
    public FilterInfo getExportFilterForQuery(Context ctx) {
        return FaDataImportUtils.getFilterForExp(ctx, super.getExportFilterForQuery(ctx), false);
    }

    @Override
    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.fi.fa.manage.FaCurCardExpQuery";
    }

    @Override
    protected void verifyBeforeTran(Context ctx, boolean isImp) throws TaskExternalException {
        super.verifyBeforeTran(ctx, isImp);
        if (isImp) {
            boolean isdep = false;
            if (this.isDepCal != null) {
                isdep = this.isDepCal;
            } else {
                CompanyOrgUnitInfo _comp = this.company;
                try {
                    isdep = FaDepreciationFactory.getLocalInstance(ctx).checkUnAuditFaDep(FaCardCache.getCurrentPeriod(ctx, _comp.getId().toString()), _comp, null);
                }
                catch (Exception e) {
                    throw new TaskExternalException(e.getMessage(), (Throwable)e);
                }
                this.isDepCal = isdep;
            }
            if (isdep) {
                String errMsg = ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.FaDepreciationResource", (String)"FaDepCal_NoAudit", (Locale)ctx.getOriginLocale());
                errMsg = errMsg + ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.FaDepreciationResource", (String)"FaDepCal_DoAction", (Locale)ctx.getOriginLocale());
                throw new TaskExternalException(errMsg);
            }
        }
    }

    @Override
    protected boolean isInitCard() {
        return false;
    }

    @Override
    protected void validate(Context ctx, FaCardInfo card) throws TaskExternalException {
        if (this.validator == null) {
            this.validator = new FaCardValidatorImpl(ctx, new FaCurCardInfo(), false);
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("Company", this.cache.CURRENTCOMP);
        params.put("isRelAccount", this.cache.ISRELACCOUNT);
        params.put("importCard", Boolean.TRUE);
        params.put("currentPeriod", this.cache.CURRENTPERIOD);
        this.validator.setParam(params);
        this.setDefaultValue(card);
        FaCurCardInfo verifyBill = FaManageUtils.MonCard2CurCard((FaMonCardInfo)card);
        verifyBill.setId(card.getId());
        this.validator.setBillInfo(verifyBill);
        boolean result = this.validator.validate();
        if (!result) {
            throw new TaskExternalException(this.validator.getInvalidMsg());
        }
    }

    private void setDefaultValue(FaCardInfo card) {
        card.setPeriod(this.cache.CURRENTPERIOD);
        card.setEffectedStatus(EffectedStatusEnum.TEMPSTORE);
        card.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
        card.setFiVouchered(false);
        boolean isOverride = this.isSltImportUpdate();
        if (!isOverride || card.getOriginFlag().getValue() != 4) {
            card.setOriginFlag(FaCardOriginEnum.ADDNEW);
        }
        card.setBizStatus(FaBizStatusEnum.ADDING);
        card.setHasNew(true);
    }

    private void setNewCardNumber(Context ctx, FaCurCardInfo aFaCurCardInfo) throws EASBizException, BOSException {
        boolean isUseInitCardRule = "true".equals(this.gethmParam(ctx).get("FA_055").toString());
        if (isUseInitCardRule) {
            FaMonCardInfo aFaMonCardInfo = PrcFaCoreManager.CurCard2MonCard(aFaCurCardInfo);
            FaLocalUtils.setNewCardNumber(ctx, aFaMonCardInfo);
            aFaCurCardInfo.setNumber(aFaMonCardInfo.getNumber());
        } else {
            FaLocalUtils.setNewCardNumber(ctx, aFaCurCardInfo);
        }
    }
}

