/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app.dataimp;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fi.fa.manage.FaCurCostCenterFactory;
import com.kingdee.eas.fi.fa.manage.FaCurCostCenterInfo;
import com.kingdee.eas.fi.fa.manage.FaDepreciationFactory;
import com.kingdee.eas.fi.fa.manage.app.FaLastPeriodChangeUtils;
import com.kingdee.eas.fi.fa.manage.app.FaLocalUtils;
import com.kingdee.eas.fi.fa.manage.app.dataimp.FaDataImportUtils;
import com.kingdee.eas.fi.fa.manage.app.dataimp.FaMonCostCenterDataImport;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.util.ResourceBase;
import java.util.Hashtable;
import java.util.Locale;

public class FaCurCostCenterDataImport
extends FaMonCostCenterDataImport {
    private Boolean isDepCal = null;

    @Override
    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        try {
            if (coreBaseInfo.getId() != null) {
                this.getController(ctx).update((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()), coreBaseInfo);
            } else {
                this.getController(ctx).submit(coreBaseInfo);
            }
            boolean isLastestPeriod = (Boolean)this.getContextParameter("card_islastestperiod");
            if (!isLastestPeriod) {
                String cardId = ((FaCurCostCenterInfo)coreBaseInfo).getFaCurCard().getId().toString();
                FaLastPeriodChangeUtils.updateCurCardLastPeriodChangeForImport(ctx, cardId);
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), (Throwable)ex);
        }
    }

    @Override
    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return FaCurCostCenterFactory.getLocalInstance(ctx);
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), (Throwable)ex);
        }
    }

    @Override
    public CoreBaseInfo transmit(Hashtable data, Context ctx) throws TaskExternalException {
        CoreBaseInfo _cost = super.transmit(data, ctx);
        FaCurCostCenterInfo curCostCenterInfo = new FaCurCostCenterInfo();
        FaDataImportUtils.cloneObjectInfo(_cost, (CoreBaseInfo)curCostCenterInfo);
        try {
            if (!(_cost instanceof FaCurCostCenterInfo)) {
                FaDataImportUtils.copyMultiAsstActInfo(_cost, (CoreBaseInfo)curCostCenterInfo, true);
            }
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        curCostCenterInfo.setFaCurCard(this.getCard());
        curCostCenterInfo.setId(_cost.getId());
        return curCostCenterInfo;
    }

    @Override
    public FilterInfo getExportFilterForQuery(Context ctx) {
        return FaDataImportUtils.getFilterForExp(ctx, super.getExportFilterForQuery(ctx), false);
    }

    @Override
    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.fi.fa.manage.FaCurCardCostCenterExpQuery";
    }

    @Override
    protected void verifyBeforeTran(Context ctx, boolean isImp) throws TaskExternalException {
        super.verifyBeforeTran(ctx, isImp);
        if (isImp) {
            boolean isdep = false;
            if (this.isDepCal != null) {
                isdep = this.isDepCal;
            } else {
                CompanyOrgUnitInfo _comp = this.company;
                try {
                    isdep = FaDepreciationFactory.getLocalInstance(ctx).checkUnAuditFaDep(FaLocalUtils.getCurrentPeriod(ctx, _comp.getId().toString()), _comp, null);
                }
                catch (Exception e) {
                    throw new TaskExternalException(e.getMessage(), (Throwable)e);
                }
                this.isDepCal = isdep;
            }
            if (isdep) {
                String errMsg = ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.FaDepreciationResource", (String)"FaDepCal_NoAudit", (Locale)ctx.getOriginLocale());
                errMsg = errMsg + ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.FaDepreciationResource", (String)"FaDepCal_DoAction", (Locale)ctx.getOriginLocale());
                throw new TaskExternalException(errMsg);
            }
        }
    }

    @Override
    protected boolean isInitCard() {
        return false;
    }
}

