/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app.dataimp;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.assistant.AddressInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.IMeasureUnit;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.account.AccountTools;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.IAccountView;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.IAsstActType;
import com.kingdee.eas.basedata.master.cssp.CustomerCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.ICustomer;
import com.kingdee.eas.basedata.master.cssp.ISupplier;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.ICostCenterOrgUnit;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.basedata.FaAlterModeFactory;
import com.kingdee.eas.fi.fa.basedata.FaAlterModeInfo;
import com.kingdee.eas.fi.fa.basedata.FaCatFactory;
import com.kingdee.eas.fi.fa.basedata.FaCatInfo;
import com.kingdee.eas.fi.fa.basedata.FaDepreciationModeFactory;
import com.kingdee.eas.fi.fa.basedata.FaDepreciationModeInfo;
import com.kingdee.eas.fi.fa.basedata.FaEconomicPurpFactory;
import com.kingdee.eas.fi.fa.basedata.FaEconomicPurpInfo;
import com.kingdee.eas.fi.fa.basedata.FaResUtil;
import com.kingdee.eas.fi.fa.basedata.FaUseStatusFactory;
import com.kingdee.eas.fi.fa.basedata.FaUseStatusInfo;
import com.kingdee.eas.fi.fa.basedata.IFaAlterMode;
import com.kingdee.eas.fi.fa.basedata.IFaCat;
import com.kingdee.eas.fi.fa.basedata.IFaDepreciationMode;
import com.kingdee.eas.fi.fa.basedata.IFaEconomicPurp;
import com.kingdee.eas.fi.fa.basedata.IFaUseStatus;
import com.kingdee.eas.fi.fa.def.FaDefPropertyCollection;
import com.kingdee.eas.fi.fa.def.FaDefPropertyInfo;
import com.kingdee.eas.fi.fa.manage.FaBakCostCenterInfo;
import com.kingdee.eas.fi.fa.manage.FaBizCostCenterInfo;
import com.kingdee.eas.fi.fa.manage.FaCardInfo;
import com.kingdee.eas.fi.fa.manage.FaCurCardFactory;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.fi.fa.manage.FaCurCostCenterInfo;
import com.kingdee.eas.fi.fa.manage.FaDataImportException;
import com.kingdee.eas.fi.fa.manage.FaFacilityFactory;
import com.kingdee.eas.fi.fa.manage.FaFacilityInfo;
import com.kingdee.eas.fi.fa.manage.FaManageUtils;
import com.kingdee.eas.fi.fa.manage.FaMonCardFactory;
import com.kingdee.eas.fi.fa.manage.FaMonCardInfo;
import com.kingdee.eas.fi.fa.manage.FaMonCostCenterInfo;
import com.kingdee.eas.fi.fa.manage.FaPeriodCloseFacadeFactory;
import com.kingdee.eas.fi.fa.manage.FaPeriodException;
import com.kingdee.eas.fi.fa.manage.IFaCurCard;
import com.kingdee.eas.fi.fa.manage.IFaFacility;
import com.kingdee.eas.fi.fa.manage.IFaMonCard;
import com.kingdee.eas.fi.fa.manage.app.FaLocalUtils;
import com.kingdee.eas.framework.CheckedStatusEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.enums.IntEnum;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public final class FaDataImportUtils {
    private static final BigDecimal ZERO = new BigDecimal("0");

    private FaDataImportUtils() {
    }

    public static void setBigDecimalData(Context ctx, Map data, String[] fieldNames, String[] propNames, String[] fieldCHN, CoreBaseInfo info, boolean supportNull, boolean allowNegative, int scale) throws TaskExternalException {
        BigDecimal value = null;
        int size = fieldNames.length;
        for (int i = 0; i < size; ++i) {
            Object obj = FaDataImportUtils.getValue(data, fieldNames[i]);
            if (FaDataImportUtils.isEmpty(obj)) {
                value = supportNull ? null : ZERO;
            } else {
                try {
                    value = new BigDecimal(obj.toString());
                    value = value.setScale(scale, 4);
                    if (value.compareTo(ZERO) < 0 && !allowNegative) {
                        throw new TaskExternalException(fieldCHN[i] + FaResUtil.getRes((String)"amountLess0", (Locale)ctx.getOriginLocale()));
                    }
                    if (value.compareTo(FaLocalUtils.MAX_DECIMAL) > 0) {
                        throw new TaskExternalException(fieldCHN[i] + FaResUtil.getRes((String)"morethanMaxValue", (Locale)ctx.getOriginLocale()) + FaLocalUtils.MAX_DECIMAL.toString());
                    }
                }
                catch (NumberFormatException e) {
                    throw new TaskExternalException(MessageFormat.format(FaResUtil.getRes((String)"formatErrorAmount", (Locale)ctx.getOriginLocale()), fieldCHN[i]));
                }
            }
            info.setBigDecimal(propNames[i], value);
        }
    }

    public static void setBigDecimalData(Context ctx, Map data, String[] fieldNames, String[] propNames, String[] fieldCHN, CoreBaseInfo info, boolean supportNull, int scale) throws TaskExternalException {
        FaDataImportUtils.setBigDecimalData(ctx, data, fieldNames, propNames, fieldCHN, info, supportNull, false, scale);
    }

    public static void setBigDecimalData(Context ctx, Map data, String[] fieldNames, String[] propNames, String[] fieldCHN, CoreBaseInfo info) throws TaskExternalException {
        FaDataImportUtils.setBigDecimalData(ctx, data, fieldNames, propNames, fieldCHN, info, false, false, 2);
    }

    public static void setBooleanData(Context ctx, Map data, String[] fieldNames, String[] propNames, CoreBaseInfo info) {
        boolean value = false;
        int size = fieldNames.length;
        for (int i = 0; i < size; ++i) {
            Object obj = FaDataImportUtils.getValue(data, fieldNames[i]);
            value = FaDataImportUtils.isEmpty(obj) ? false : FaDataImportUtils.getBooleanValue(ctx, obj.toString().trim());
            info.setBoolean(propNames[i], value);
        }
    }

    public static void setDateTimeData(Context ctx, Map data, String[] fieldNames, String[] propNames, String[] fieldsCHN, CoreBaseInfo info, boolean supportNull) throws TaskExternalException {
        Date value = null;
        Date today = new Date();
        int size = fieldNames.length;
        for (int i = 0; i < size; ++i) {
            Object obj = FaDataImportUtils.getValue(data, fieldNames[i]);
            if (FaDataImportUtils.isEmpty(obj)) {
                value = supportNull ? null : today;
            } else if (obj instanceof Date) {
                value = (Date)obj;
            } else if (obj instanceof String) {
                try {
                    value = new SimpleDateFormat("yyyy-MM-dd").parse(obj.toString().trim());
                }
                catch (ParseException e) {
                    throw new TaskExternalException(MessageFormat.format(FaResUtil.getRes((String)"formatErrorDate", (Locale)ctx.getOriginLocale()), fieldsCHN[i]));
                }
            } else {
                throw new TaskExternalException(MessageFormat.format(FaResUtil.getRes((String)"formatErrorDate", (Locale)ctx.getOriginLocale()), fieldsCHN[i]));
            }
            info.setDate(propNames[i], value);
        }
    }

    public static void setDateTimeData(Context ctx, Map data, String[] fieldNames, String[] propNames, String[] fieldsCHN, CoreBaseInfo info) throws TaskExternalException {
        FaDataImportUtils.setDateTimeData(ctx, data, fieldNames, propNames, fieldsCHN, info, true);
    }

    public static void setIntegerData(Context ctx, Map data, String[] fieldNames, String[] propNames, String[] fieldCHN, CoreBaseInfo info, int defaultValue) throws TaskExternalException {
        int value = 0;
        for (int i = 0; i < fieldNames.length; ++i) {
            Object obj = FaDataImportUtils.getValue(data, fieldNames[i]);
            if (FaDataImportUtils.isEmpty(obj)) {
                value = defaultValue;
            } else {
                try {
                    value = Integer.parseInt(obj.toString());
                    if (value < 0) {
                        throw new TaskExternalException(MessageFormat.format(FaResUtil.getRes((String)"canNotLess0", (Locale)ctx.getOriginLocale()), fieldCHN[i]));
                    }
                }
                catch (NumberFormatException e) {
                    throw new TaskExternalException(MessageFormat.format(FaResUtil.getRes((String)"formatErrorAmount", (Locale)ctx.getOriginLocale()), fieldCHN[i]));
                }
            }
            info.setInt(propNames[i], value);
        }
    }

    public static void setDefaultIntegerData(String[] propNames, int defaultValue, CoreBaseInfo info) {
        int size = propNames.length;
        for (int i = 0; i < size; ++i) {
            info.setInt(propNames[i], defaultValue);
        }
    }

    public static void setDefaultDecimalData(String[] propNames, BigDecimal defaultValue, CoreBaseInfo info, int scale) {
        int size = propNames.length;
        for (int i = 0; i < size; ++i) {
            defaultValue = defaultValue.setScale(scale, 4);
            info.setBigDecimal(propNames[i], defaultValue);
        }
    }

    public static void setDefaultStringData(String[] propNames, String defaultValue, CoreBaseInfo info) {
        int size = propNames.length;
        for (int i = 0; i < size; ++i) {
            info.setString(propNames[i], defaultValue);
        }
    }

    public static void setDefaultBooleanData(String[] propNames, boolean defaultValue, CoreBaseInfo info) {
        int size = propNames.length;
        for (int i = 0; i < size; ++i) {
            info.setBoolean(propNames[i], defaultValue);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void setStringData(Context ctx, Map data, String[] fieldNames, String[] propNames, String[] fieldCHN, CoreBaseInfo info, boolean supportNull, String defaultValue) throws TaskExternalException {
        String value = null;
        for (int i = 0; i < fieldNames.length; ++i) {
            Object obj = FaDataImportUtils.getValue(data, fieldNames[i]);
            if (FaDataImportUtils.isEmpty(obj)) {
                if (defaultValue != null) {
                    value = defaultValue.trim();
                } else {
                    if (!supportNull) throw new TaskExternalException(MessageFormat.format(FaResUtil.getRes((String)"columnCanNotNull", (Locale)ctx.getOriginLocale()), fieldCHN[i]));
                    value = "";
                }
            } else {
                value = obj.toString().trim();
            }
            info.setString(propNames[i], value);
        }
    }

    public static void setStringData(Context ctx, Map data, String[] fieldNames, String[] propNames, String[] fieldCHN, CoreBaseInfo info, String defaultValue) throws TaskExternalException {
        FaDataImportUtils.setStringData(ctx, data, fieldNames, propNames, fieldCHN, info, true, defaultValue);
    }

    public static void setStringData(Context ctx, Map data, String[] fieldNames, String[] propNames, String[] fieldCHN, CoreBaseInfo info) throws TaskExternalException {
        FaDataImportUtils.setStringData(ctx, data, fieldNames, propNames, fieldCHN, info, true, null);
    }

    public static MeasureUnitInfo getMeasureUnitInfo(Context ctx, String oql) throws TaskExternalException {
        if (FaDataImportUtils.isEmpty(oql)) {
            return null;
        }
        try {
            IMeasureUnit iMeasureUnit = MeasureUnitFactory.getLocalInstance((Context)ctx);
            return (MeasureUnitInfo)iMeasureUnit.getValue(oql);
        }
        catch (ObjectNotFoundException obje) {
            FaDataImportUtils.procException(ctx, FaResUtil.getRes((String)"measureunitInfo", (Locale)ctx.getOriginLocale()), obje);
            return null;
        }
        catch (EASBizException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public static MeasureUnitInfo getWLMeasureUnitInfo(Context ctx, String oql) throws TaskExternalException {
        if (FaDataImportUtils.isEmpty(oql)) {
            return null;
        }
        try {
            IMeasureUnit iMeasureUnit = MeasureUnitFactory.getLocalInstance((Context)ctx);
            return (MeasureUnitInfo)iMeasureUnit.getValue(oql);
        }
        catch (ObjectNotFoundException obje) {
            FaDataImportUtils.procException(ctx, FaResUtil.getRes((String)"wlMeasureunitInfo", (Locale)ctx.getOriginLocale()), obje);
            return null;
        }
        catch (EASBizException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public static FaDepreciationModeInfo getDeprModeInfo(Context ctx, String oql) throws TaskExternalException {
        if (FaDataImportUtils.isEmpty(oql)) {
            return null;
        }
        try {
            IFaDepreciationMode iDeprMode = FaDepreciationModeFactory.getLocalInstance((Context)ctx);
            return (FaDepreciationModeInfo)iDeprMode.getValue(oql);
        }
        catch (ObjectNotFoundException obje) {
            FaDataImportUtils.procException(ctx, FaResUtil.getRes((String)"dprMethod", (Locale)ctx.getOriginLocale()), obje);
            return null;
        }
        catch (EASBizException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public static AccountViewInfo getAcctViewInfo(Context ctx, String number) throws TaskExternalException {
        if (FaDataImportUtils.isEmpty(number)) {
            return null;
        }
        try {
            AccountTools.checkCompanyAccountTable((Context)ctx, (CompanyOrgUnitInfo)ContextUtil.getCurrentFIUnit((Context)ctx));
            String accountId = ContextUtil.getCurrentFIUnit((Context)ctx).getAccountTable().getId().toString();
            String fiid = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
            IAccountView iAcctView = AccountViewFactory.getLocalInstance((Context)ctx);
            return iAcctView.getAccountViewInfo("WHERE NUMBER = '" + number + "' AND companyID.id ='" + fiid + "' AND accountTableID.id ='" + accountId + "'");
        }
        catch (ObjectNotFoundException obje) {
            FaDataImportUtils.procException(ctx, FaResUtil.getRes((String)"accountView", (Locale)ctx.getOriginLocale()), obje);
            return null;
        }
        catch (EASBizException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public static AccountViewInfo getAcctViewInfo(Context ctx, CompanyOrgUnitInfo company, String number) throws TaskExternalException {
        if (FaDataImportUtils.isEmpty(number)) {
            return null;
        }
        try {
            AccountTools.checkCompanyAccountTable((Context)ctx, (CompanyOrgUnitInfo)company);
            String accountId = company.getAccountTable().getId().toString();
            String fiid = company.getId().toString();
            IAccountView iAcctView = AccountViewFactory.getLocalInstance((Context)ctx);
            return iAcctView.getAccountViewInfo("WHERE NUMBER = '" + number + "' AND companyID.id ='" + fiid + "' AND accountTableID.id ='" + accountId + "'");
        }
        catch (ObjectNotFoundException obje) {
            FaDataImportUtils.procException(ctx, FaResUtil.getRes((String)"accountView", (Locale)ctx.getOriginLocale()), obje);
            return null;
        }
        catch (EASBizException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public static FaEconomicPurpInfo getFaEconomicPurpInfo(Context ctx, String oql) throws TaskExternalException {
        if (FaDataImportUtils.isEmpty(oql)) {
            return null;
        }
        try {
            IFaEconomicPurp iFaEconomicPurp = FaEconomicPurpFactory.getLocalInstance((Context)ctx);
            return (FaEconomicPurpInfo)iFaEconomicPurp.getValue(oql);
        }
        catch (ObjectNotFoundException obje) {
            FaDataImportUtils.procException(ctx, FaResUtil.getRes((String)"economicPurp", (Locale)ctx.getOriginLocale()), obje);
            return null;
        }
        catch (EASBizException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public static FaCatInfo getFaCatInfo(Context ctx, String oql) throws TaskExternalException {
        if (FaDataImportUtils.isEmpty(oql)) {
            return null;
        }
        try {
            IFaCat iFaCat = FaCatFactory.getLocalInstance((Context)ctx);
            return (FaCatInfo)iFaCat.getValue(oql);
        }
        catch (ObjectNotFoundException obje) {
            FaDataImportUtils.procException(ctx, FaResUtil.getRes((String)"assetCat", (Locale)ctx.getOriginLocale()), obje);
            return null;
        }
        catch (EASBizException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public static String getFaCurCardId(Context ctx, String cardNumber, String companyId) throws TaskExternalException {
        String result = null;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FID FROM T_FA_FACURCARD WHERE FNUMBER = ? AND FCOMPANYID = ? ");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{cardNumber, companyId});
            if (rs.next()) {
                result = rs.getString("FID");
                return result;
            }
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public static FaCurCardInfo getFaCurCardInfo(Context ctx, String oql) throws TaskExternalException {
        if (FaDataImportUtils.isEmpty(oql)) {
            return null;
        }
        try {
            IFaCurCard iFaCurCard = FaCurCardFactory.getLocalInstance(ctx);
            return iFaCurCard.getFaCurCardInfo(oql);
        }
        catch (ObjectNotFoundException obje) {
            FaDataImportUtils.procException(ctx, FaResUtil.getRes((String)"cardInfo", (Locale)ctx.getOriginLocale()), obje);
            return null;
        }
        catch (EASBizException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public static FaMonCardInfo getFaMonCardInfo(Context ctx, String oql) throws TaskExternalException {
        if (FaDataImportUtils.isEmpty(oql)) {
            return null;
        }
        try {
            IFaMonCard iFaCurCard = FaMonCardFactory.getLocalInstance(ctx);
            return iFaCurCard.getFaMonCardInfo(oql);
        }
        catch (ObjectNotFoundException obje) {
            FaDataImportUtils.procException(ctx, FaResUtil.getRes((String)"moncardInfo", (Locale)ctx.getOriginLocale()), obje);
            return null;
        }
        catch (EASBizException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public static String getFaMonCardID(Context ctx, String cardNumber, String companyId) throws TaskExternalException {
        String result = null;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FID FROM T_FA_FAMONCARD WHERE FNUMBER = ? AND FCOMPANYID = ? AND FFAPERIODID IS NULL");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{cardNumber, companyId});
            if (rs.next()) {
                result = rs.getString("FID");
                return result;
            }
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public static FaUseStatusInfo getFaUseStatusInfo(Context ctx, String oql) throws TaskExternalException {
        if (FaDataImportUtils.isEmpty(oql)) {
            return null;
        }
        try {
            IFaUseStatus iUseStatus = FaUseStatusFactory.getLocalInstance((Context)ctx);
            return (FaUseStatusInfo)iUseStatus.getValue(oql);
        }
        catch (ObjectNotFoundException obje) {
            FaDataImportUtils.procException(ctx, FaResUtil.getRes((String)"statusInfo", (Locale)ctx.getOriginLocale()), obje);
            return null;
        }
        catch (EASBizException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public static AddressInfo getAddressInfo(Context ctx, String companyId, String number) throws TaskExternalException {
        if (FaDataImportUtils.isEmpty(number)) {
            return null;
        }
        String sql = "SELECT ADDRESS.FID FROM T_BD_Address ADDRESS INNER JOIN T_ORG_CtrlUnit CU ON ADDRESS.FControlUnitID = CU.FID WHERE (ADDRESS.FAdminCUID = ? OR ADDRESS.FID IN (SELECT FDataBaseDID FROM T_BD_DataBaseDAssign WHERE (FBOSObjectType = 'A8E556C9' AND FAssignCUID = ?))) AND ADDRESS.FNUMBER = ?";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{companyId, companyId, number});
            if (rs.next()) {
                String addressId = rs.getString(1);
                AddressInfo addressInfo = new AddressInfo();
                addressInfo.setId(BOSUuid.read((String)addressId));
                return addressInfo;
            }
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        throw new TaskExternalException(FaResUtil.getRes((String)"noAddress", (Locale)ctx.getOriginLocale()) + number);
    }

    public static AdminOrgUnitInfo getAdminOrgUnitInfo(Context ctx, String number, String tip) throws TaskExternalException {
        if (FaDataImportUtils.isEmpty(number)) {
            return null;
        }
        try {
            IAdminOrgUnit iAdminOrgUnit;
            String adminId = null;
            String cuId = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
            String sqla = "select fid from t_org_admin where fcontrolunitid = ? and fnumber = ?";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqla, (Object[])new Object[]{cuId, number});
            if (rs.next()) {
                adminId = rs.getString(1);
            } else {
                sqla = "select flongnumber||'%' from t_org_admin where fcontrolunitid = ?";
                rs = DbUtil.executeQuery((Context)ctx, (String)sqla, (Object[])new Object[]{cuId});
                while (rs.next()) {
                    IRowSet rs2 = DbUtil.executeQuery((Context)ctx, (String)"select fid from t_org_admin where fcontrolunitid = ? and flongnumber like ? and fnumber = ?", (Object[])new Object[]{cuId, rs.getString(1), number});
                    if (!rs2.next()) continue;
                    adminId = rs2.getString(1);
                    break;
                }
            }
            if (adminId == null) {
                iAdminOrgUnit = AdminOrgUnitFactory.getLocalInstance((Context)ctx);
                return (AdminOrgUnitInfo)iAdminOrgUnit.getValue("where number='" + number + "'");
            }
            if (adminId != null && adminId.trim().length() > 0) {
                iAdminOrgUnit = AdminOrgUnitFactory.getLocalInstance((Context)ctx);
                return iAdminOrgUnit.getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(rs.getString(1)));
            }
            throw new TaskExternalException(MessageFormat.format(FaResUtil.getRes((String)"cannotFound", (Locale)ctx.getOriginLocale()), tip + "[" + number + "]"));
        }
        catch (ObjectNotFoundException obje) {
            throw new TaskExternalException(MessageFormat.format(FaResUtil.getRes((String)"cannotFound", (Locale)ctx.getOriginLocale()), tip + "[" + number + "]"));
        }
        catch (EASBizException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public static AdminOrgUnitInfo getAdminOrgUnitInfo(Context ctx, String cuId, String number, String tip) throws TaskExternalException {
        if (FaDataImportUtils.isEmpty(number)) {
            return null;
        }
        try {
            IAdminOrgUnit iAdminOrgUnit;
            String adminId = null;
            String sqla = "select fid from t_org_admin where fcontrolunitid = ? and fnumber = ?";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqla, (Object[])new Object[]{cuId, number});
            if (rs.next()) {
                adminId = rs.getString(1);
            } else {
                sqla = "select flongnumber||'%' from t_org_admin where fcontrolunitid = ?";
                rs = DbUtil.executeQuery((Context)ctx, (String)sqla, (Object[])new Object[]{cuId});
                while (rs.next()) {
                    IRowSet rs2 = DbUtil.executeQuery((Context)ctx, (String)"select fid from t_org_admin where fcontrolunitid = ? and flongnumber like ? and fnumber = ?", (Object[])new Object[]{cuId, rs.getString(1), number});
                    if (!rs2.next()) continue;
                    adminId = rs2.getString(1);
                    break;
                }
            }
            if (adminId == null) {
                iAdminOrgUnit = AdminOrgUnitFactory.getLocalInstance((Context)ctx);
                return (AdminOrgUnitInfo)iAdminOrgUnit.getValue("where number='" + number + "'");
            }
            if (adminId != null && adminId.trim().length() > 0) {
                iAdminOrgUnit = AdminOrgUnitFactory.getLocalInstance((Context)ctx);
                return iAdminOrgUnit.getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(rs.getString(1)));
            }
            throw new TaskExternalException(MessageFormat.format(FaResUtil.getRes((String)"cannotFound", (Locale)ctx.getOriginLocale()), tip + "[" + number + "]"));
        }
        catch (ObjectNotFoundException obje) {
            throw new TaskExternalException(MessageFormat.format(FaResUtil.getRes((String)"cannotFound", (Locale)ctx.getOriginLocale()), tip + "[" + number + "]"));
        }
        catch (EASBizException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public static CompanyOrgUnitInfo getCompanyOrgUnitInfo(Context ctx, String oql) throws TaskExternalException {
        if (FaDataImportUtils.isEmpty(oql)) {
            return null;
        }
        try {
            ICompanyOrgUnit iCompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
            return iCompany.getCompanyOrgUnitInfo(oql);
        }
        catch (ObjectNotFoundException obje) {
            FaDataImportUtils.procException(ctx, FaResUtil.getRes((String)"companyInfo", (Locale)ctx.getOriginLocale()), obje);
            return null;
        }
        catch (EASBizException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public static PersonInfo getPersonInfo(Context ctx, String number) throws TaskExternalException {
        return FaDataImportUtils.getPersonInfo(ctx, ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString(), number);
    }

    public static PersonInfo getPersonInfo(Context ctx, String cuId, String number) throws TaskExternalException {
        if (FaDataImportUtils.isEmpty(number)) {
            return null;
        }
        String sqla = "select FLONGNUMBER||'%' from t_org_admin where fcontrolunitid = '" + cuId + "'";
        String tempTableName = "";
        try {
            String personId = null;
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqla);
            int modeSize = 100;
            boolean haveRowSet = false;
            if (rs.size() > 100) {
                String insertSql;
                tempTableName = FaDataImportUtils.createTempTableForIds(ctx);
                StringBuffer partBuffer = new StringBuffer();
                int i = 0;
                while (rs.next()) {
                    if (!haveRowSet) {
                        haveRowSet = true;
                    }
                    partBuffer.append("FLONGNUMBER like '" + rs.getString(1) + "' OR ");
                    if (++i % 100 != 0) continue;
                    insertSql = " insert into " + tempTableName + " (fid) (SELECT FID FROM T_ORG_ADMIN WHERE (" + partBuffer.substring(0, partBuffer.length() - "OR ".length()) + "))";
                    DbUtil.execute((Context)ctx, (String)insertSql);
                    partBuffer.setLength(0);
                }
                if (partBuffer.length() > 0) {
                    insertSql = " insert into " + tempTableName + " (fid) (SELECT FID FROM T_ORG_ADMIN WHERE (" + partBuffer.substring(0, partBuffer.length() - "OR ".length()) + "))";
                    DbUtil.execute((Context)ctx, (String)insertSql);
                }
                if (haveRowSet) {
                    String sql = "SELECT PERSON.FID FROM T_BD_Person PERSON INNER JOIN T_ORG_PositionMember POSITIONMEMBER ON PERSON.FID = POSITIONMEMBER.FPersonID INNER JOIN T_ORG_CtrlUnit CU ON PERSON.FControlUnitID = CU.FID INNER JOIN T_ORG_Position POSITION ON POSITIONMEMBER.FPositionID = POSITION.FID WHERE POSITION.FAdminOrgUnitID IN (select fid from " + tempTableName + ") and PERSON.FNUMBER = '" + number + "'";
                    rs = DbUtil.executeQuery((Context)ctx, (String)sql);
                    if (rs.next()) {
                        personId = rs.getString(1);
                    } else {
                        sqla = "select fid from t_bd_person where fnumber = '" + number + "'";
                        rs = DbUtil.executeQuery((Context)ctx, (String)sqla);
                        if (rs.next()) {
                            personId = rs.getString(1);
                            if (rs.next()) {
                                throw new TaskExternalException(MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"66_FaDataImportUtils", (Locale)ctx.getOriginLocale()), number));
                            }
                        }
                    }
                } else {
                    sqla = "select fid from t_bd_person where fnumber = '" + number + "'";
                    rs = DbUtil.executeQuery((Context)ctx, (String)sqla);
                    if (rs.next()) {
                        personId = rs.getString(1);
                        if (rs.next()) {
                            throw new TaskExternalException(MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"66_FaDataImportUtils", (Locale)ctx.getOriginLocale()), number));
                        }
                    }
                }
            } else {
                StringBuffer buffer = new StringBuffer();
                while (rs.next()) {
                    buffer.append("FLONGNUMBER like '" + rs.getString(1) + "' OR ");
                }
                if (buffer.length() != 0) {
                    String sql = "SELECT PERSON.FID FROM T_BD_Person PERSON INNER JOIN T_ORG_PositionMember POSITIONMEMBER ON PERSON.FID = POSITIONMEMBER.FPersonID INNER JOIN T_ORG_CtrlUnit CU ON PERSON.FControlUnitID = CU.FID INNER JOIN T_ORG_Position POSITION ON POSITIONMEMBER.FPositionID = POSITION.FID WHERE POSITION.FAdminOrgUnitID IN (SELECT FID FROM T_ORG_ADMIN WHERE (" + buffer.substring(0, buffer.length() - "OR ".length()) + ")) and PERSON.FNUMBER = '" + number + "'";
                    rs = DbUtil.executeQuery((Context)ctx, (String)sql);
                    if (rs.next()) {
                        personId = rs.getString(1);
                    } else {
                        sqla = "select fid from t_bd_person where fnumber = '" + number + "'";
                        rs = DbUtil.executeQuery((Context)ctx, (String)sqla);
                        if (rs.next()) {
                            personId = rs.getString(1);
                            if (rs.next()) {
                                throw new TaskExternalException(MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"66_FaDataImportUtils", (Locale)ctx.getOriginLocale()), number));
                            }
                        }
                    }
                } else {
                    sqla = "select fid from t_bd_person where fnumber = '" + number + "'";
                    rs = DbUtil.executeQuery((Context)ctx, (String)sqla);
                    if (rs.next()) {
                        personId = rs.getString(1);
                        if (rs.next()) {
                            throw new TaskExternalException(MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"66_FaDataImportUtils", (Locale)ctx.getOriginLocale()), number));
                        }
                    }
                }
            }
            if (personId != null) {
                PersonInfo personInfo = new PersonInfo();
                personInfo.setId(BOSUuid.read((String)personId));
                PersonInfo personInfo2 = personInfo;
                return personInfo2;
            }
            try {
                throw new TaskExternalException(MessageFormat.format(FaResUtil.getRes((String)"noPerson", (Locale)ctx.getOriginLocale()), number));
            }
            catch (SQLException e) {
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
            catch (BOSException e) {
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
        }
        finally {
            if (!"".equals(tempTableName)) {
                TempTablePool.getInstance((Context)ctx).releaseTable(tempTableName);
            }
        }
    }

    private static String createTempTableForIds(Context ctx) throws BOSException {
        String tempTableName = "";
        StringBuffer createTableSql = new StringBuffer();
        createTableSql.append("create table t_org_adminIds\t\t\t\t\r\n");
        createTableSql.append(" (FID VARCHAR(44) )\t\r\n");
        try {
            tempTableName = TempTablePool.getInstance((Context)ctx).createTempTable(createTableSql.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tempTableName;
    }

    public static CurrencyInfo getCurrencyInfo(Context ctx, String oql) throws TaskExternalException {
        if (FaDataImportUtils.isEmpty(oql)) {
            return null;
        }
        try {
            ICurrency iCurrency = CurrencyFactory.getLocalInstance((Context)ctx);
            return (CurrencyInfo)iCurrency.getValue(oql);
        }
        catch (ObjectNotFoundException obje) {
            FaDataImportUtils.procException(ctx, FaResUtil.getRes((String)"currencyInfo", (Locale)ctx.getOriginLocale()), obje);
            return null;
        }
        catch (EASBizException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public static FaFacilityInfo getFacilityInfo(Context ctx, String oql) throws TaskExternalException {
        if (FaDataImportUtils.isEmpty(oql)) {
            return null;
        }
        try {
            IFaFacility iFacility = FaFacilityFactory.getLocalInstance(ctx);
            return (FaFacilityInfo)iFacility.getValue(oql);
        }
        catch (ObjectNotFoundException obje) {
            FaDataImportUtils.procException(ctx, FaResUtil.getRes((String)"facilityInfo", (Locale)ctx.getOriginLocale()), obje);
            return null;
        }
        catch (EASBizException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public static CostCenterOrgUnitInfo getCostCenterInfo(Context ctx, String number) throws TaskExternalException {
        if (FaDataImportUtils.isEmpty(number)) {
            return null;
        }
        try {
            String longNumber = ContextUtil.getCurrentCtrlUnit((Context)ctx).getLongNumber();
            String sql = "select c.fid from t_org_costcenter c inner join t_org_ctrlunit u on c.fcontrolunitid=u.fid where u.flongnumber like '" + longNumber + "%' and c.fnumber ='" + number + "'";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rs.next()) {
                ICostCenterOrgUnit iCostCenter = CostCenterOrgUnitFactory.getLocalInstance((Context)ctx);
                return (CostCenterOrgUnitInfo)iCostCenter.getValue("where id ='" + rs.getString(1) + "'");
            }
            throw new TaskExternalException(MessageFormat.format(FaResUtil.getRes((String)"cannotFound", (Locale)ctx.getOriginLocale()), FaResUtil.getRes((String)"costcenterInfo", (Locale)ctx.getOriginLocale()) + "[" + number + "]"));
        }
        catch (SQLException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        catch (EASBizException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public static FaAlterModeInfo getFaAlterModeInfo(Context ctx, String oql) throws TaskExternalException {
        if (FaDataImportUtils.isEmpty(oql)) {
            return null;
        }
        try {
            IFaAlterMode iFaAlterMode = FaAlterModeFactory.getLocalInstance((Context)ctx);
            return (FaAlterModeInfo)iFaAlterMode.getValue(oql);
        }
        catch (ObjectNotFoundException obje) {
            FaDataImportUtils.procException(ctx, FaResUtil.getRes((String)"OriginMethod", (Locale)ctx.getOriginLocale()), obje);
            return null;
        }
        catch (EASBizException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public static CustomerInfo getCustomerInfo(Context ctx, String oql) throws TaskExternalException {
        if (FaDataImportUtils.isEmpty(oql)) {
            return null;
        }
        try {
            ICustomer iCustomer = CustomerFactory.getLocalInstance((Context)ctx);
            return iCustomer.getCustomerInfo(oql);
        }
        catch (ObjectNotFoundException obje) {
            FaDataImportUtils.procException(ctx, FaResUtil.getRes((String)"customerInfo", (Locale)ctx.getOriginLocale()), obje);
            return null;
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        catch (EASBizException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public static CustomerInfo getCustomerInfo(Context ctx, String cuId, String number) throws TaskExternalException {
        if (FaDataImportUtils.isEmpty(cuId)) {
            return null;
        }
        try {
            ObjectUuidPK pk = new ObjectUuidPK(cuId);
            FilterInfo filter = CustomerFactory.getLocalInstance((Context)ctx).getDatabaseDFilter((IObjectPK)pk, "id", "adminCU");
            FilterItemInfo filterItem = new FilterItemInfo("number", (Object)number, CompareType.EQUALS);
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(filterItem);
            filter.mergeFilter(fi, "and");
            ICustomer iCustomer = CustomerFactory.getLocalInstance((Context)ctx);
            EntityViewInfo entityView = new EntityViewInfo();
            entityView.setFilter(filter);
            CustomerCollection costomerColl = iCustomer.getCustomerCollection(entityView);
            if (costomerColl != null && costomerColl.get(0) != null) {
                return costomerColl.get(0);
            }
            return null;
        }
        catch (ObjectNotFoundException obje) {
            FaDataImportUtils.procException(ctx, FaResUtil.getRes((String)"customerInfo", (Locale)ctx.getOriginLocale()), obje);
            return null;
        }
        catch (EASBizException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public static SupplierInfo getSupplierInfo(Context ctx, String oql) throws TaskExternalException {
        if (FaDataImportUtils.isEmpty(oql)) {
            return null;
        }
        try {
            ISupplier iSupplier = SupplierFactory.getLocalInstance((Context)ctx);
            return iSupplier.getSupplierInfo(oql);
        }
        catch (ObjectNotFoundException obje) {
            FaDataImportUtils.procException(ctx, FaResUtil.getRes((String)"suppliersInfo", (Locale)ctx.getOriginLocale()), obje);
            return null;
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        catch (EASBizException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public static void cloneObjectInfo(CoreBaseInfo from, CoreBaseInfo to) {
        Enumeration enums = from.keys();
        while (enums.hasMoreElements()) {
            String key = (String)enums.nextElement();
            to.put(key, from.get(key));
        }
    }

    private static String getCostCenterPreFix(CoreBaseInfo info) {
        String cardPreFix = "";
        if (info instanceof FaBakCostCenterInfo) {
            cardPreFix = "fabak";
        }
        if (info instanceof FaBizCostCenterInfo) {
            cardPreFix = "fabiz";
        }
        if (info instanceof FaCurCostCenterInfo) {
            cardPreFix = "facur";
        }
        if (info instanceof FaMonCostCenterInfo) {
            cardPreFix = "famon";
        }
        return cardPreFix;
    }

    public static void copyMultiAsstActInfo(CoreBaseInfo srcCostCenterObj, CoreBaseInfo descCostCenterObj, boolean includeID) throws Exception {
        String destPreFix = FaDataImportUtils.getCostCenterPreFix(descCostCenterObj);
        String srcPreFix = FaDataImportUtils.getCostCenterPreFix(srcCostCenterObj);
        if (srcCostCenterObj != null && descCostCenterObj != null) {
            CoreBaseInfo srColObj = srcCostCenterObj;
            CoreBaseInfo aDesCostCenter = descCostCenterObj;
            Object asstActObj = srColObj.get(srcPreFix + "AsstActComposit");
            if (aDesCostCenter != null) {
                Class asstActClass = FaManageUtils.getCollectionObject(aDesCostCenter.get(destPreFix + "AsstActComposit"));
                if (asstActObj instanceof IObjectCollection) {
                    IObjectCollection colAsstActObj = (IObjectCollection)asstActObj;
                    int size = colAsstActObj.size();
                    for (int k = 0; k < size; ++k) {
                        IObjectValue asstActObjNew = (IObjectValue)asstActClass.newInstance();
                        String[] excludeAsstActElement = new String[]{srcPreFix + "CostCenter"};
                        FaManageUtils.copyValueNoID(colAsstActObj.getObject(k), asstActObjNew, excludeAsstActElement, includeID);
                        asstActObjNew.put(destPreFix + "CostCenter", (Object)aDesCostCenter);
                        ((IObjectCollection)aDesCostCenter.get(destPreFix + "AsstActComposit")).addObject(asstActObjNew);
                    }
                }
            }
        }
    }

    public static IntEnum getEnumByName(Context ctx, List enums, String name) throws TaskExternalException {
        if (FaDataImportUtils.isEmpty(name)) {
            return null;
        }
        int size = enums.size();
        for (int i = 0; i < size; ++i) {
            IntEnum intEnum = (IntEnum)enums.get(i);
            if (!intEnum.getName().equalsIgnoreCase(name) && !intEnum.getAlias().equalsIgnoreCase(name)) continue;
            return intEnum;
        }
        throw new TaskExternalException(FaResUtil.getRes((String)"noMatchInfo", (Locale)ctx.getOriginLocale()) + name);
    }

    public static Object getValue(Map data, String fieldName) {
        if (data.get(fieldName) == null) {
            return null;
        }
        return ((DataToken)data.get((Object)fieldName)).data;
    }

    public static boolean getBooleanValue(Context ctx, String value) {
        if (FaDataImportUtils.isEmpty(value)) {
            return false;
        }
        return !value.equalsIgnoreCase("N") && !value.equalsIgnoreCase("NO") && !value.equalsIgnoreCase("0") && !value.equalsIgnoreCase(ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"68_FaDataImportUtils", (Locale)ctx.getOriginLocale()));
    }

    private static boolean isEmpty(Object obj) {
        return obj == null || obj.toString().trim().length() == 0;
    }

    private static void procException(Context ctx, String title, ObjectNotFoundException obje) throws TaskExternalException {
        int start;
        int end;
        String msg = obje.getMessage();
        StringBuffer buffer = new StringBuffer();
        Locale locale = ctx.getOriginLocale();
        if (msg != null && msg.toLowerCase().indexOf(" cu.id ") != -1) {
            buffer.append(" [" + FaResUtil.getRes((String)"controlunitDis", (Locale)locale) + "] ");
        }
        if (msg != null && msg.toLowerCase().indexOf(" number ") != -1 && (end = msg.indexOf("'", (start = msg.indexOf("'", msg.toLowerCase().indexOf(" number "))) + 1)) != -1) {
            buffer.append("[" + FaResUtil.getRes((String)"number5", (Locale)locale) + msg.substring(start + 1, end).trim() + "]");
        }
        if (buffer.length() > 0) {
            throw new TaskExternalException(MessageFormat.format(FaResUtil.getRes((String)"noMatchPassBy", (Locale)locale), buffer, title), (Throwable)obje);
        }
        throw new TaskExternalException(MessageFormat.format(FaResUtil.getRes((String)"noMatch", (Locale)locale), title), (Throwable)obje);
    }

    public static void verfyBeforeEndInit(Context ctx) throws EASBizException, BOSException {
        CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)ctx);
        company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo("SELECT * , baseCurrency.precision WHERE ID ='" + company.getId() + "'");
        String companyId = company.getId().toString();
        StringBuffer cardNums = new StringBuffer();
        try {
            boolean showEval;
            StringBuffer cardDup = new StringBuffer();
            String numberDupSql = "select fnumber,count(fid) from t_fa_famoncard where fcompanyid = ? and ffaperiodid is null and foriginflag = 0 group by fnumber having count(fid) > 1";
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)numberDupSql, (Object[])new Object[]{companyId});
            while (rowSet.next()) {
                cardDup.append("  " + rowSet.getString("fnumber") + "  ");
            }
            if (cardDup.length() > 0) {
                if (cardDup.length() > 100) {
                    cardDup = new StringBuffer(cardDup.substring(0, 100) + "..");
                }
                throw new FaDataImportException(FaDataImportException.INITCARD_EXIST_DUPNUMBER, new Object[]{cardDup.toString()});
            }
            String sql = "select card.fnumber from t_fa_famoncostcenter costcenter inner join t_fa_famoncard card on card.fid = costcenter.ffamoncardid where card.fcompanyid = ? and card.FFaPeriodID is null group by card.fnumber having sum(fapportionscale)!=100";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{companyId});
            while (rs.next()) {
                cardNums.append(rs.getString(1) + "  ");
            }
            if (cardNums.length() > 0) {
                if (cardNums.length() > 100) {
                    cardNums = new StringBuffer(cardNums.substring(0, 100) + "..");
                }
                throw new FaDataImportException(FaDataImportException.COSTCENTER_SUMUP_INVALID, new Object[]{cardNums.toString()});
            }
            sql = "select card.fnumber from t_fa_famoncard card where card.fcompanyid = ? and card.FFaPeriodID is null and not exists (select 1 from t_fa_famondepartment where FFaMonCardID = card.fid)";
            rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{companyId});
            while (rs.next()) {
                cardNums.append(rs.getString(1) + "  ");
            }
            if (cardNums.length() > 0) {
                if (cardNums.length() > 100) {
                    cardNums = new StringBuffer(cardNums.substring(0, 100) + "..");
                }
                throw new FaDataImportException(FaDataImportException.INITDATA_NO_DEPARTMENT, new Object[]{cardNums.toString()});
            }
            String strWorkLoadId = FaLocalUtils.getWorkloadMethodID(ctx);
            ObjectUuidPK pk = new ObjectUuidPK(company.getId());
            HashMap<String, ObjectUuidPK> paramKeyMap = new HashMap<String, ObjectUuidPK>();
            paramKeyMap.put("FA_021", pk);
            HashMap result = ParamManager.getParamHashMap((Context)ctx, paramKeyMap);
            boolean bl = showEval = result.get("FA_021") == null ? false : Boolean.valueOf(result.get("FA_021").toString());
            if (showEval && (rs = DbUtil.executeQuery((Context)ctx, (String)(sql = "select mon.fid from t_fa_famoncard mon left outer join T_FA_DepreciationMode depr on mon.fdeprMethodId = depr.fid where mon.FEvalAssetValue is null and mon.FFaPeriodID is null and depr.fnumber != '006' and mon.fcompanyid = ?"), (Object[])new Object[]{company.getId().toString()})).next()) {
                throw new FaDataImportException(FaDataImportException.TAX_EVAL_REQUIRED);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e.getMessage(), (Throwable)e);
        }
    }

    public static int getSeq(Context ctx, String cardId, String tblName) throws TaskExternalException {
        String querySql = "select max(fseq) from " + tblName + " where ffacurcardid = ?";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)querySql, (Object[])new Object[]{cardId});
            if (rs.next()) {
                if (rs.getString(1) != null) {
                    return rs.getInt(1) + 1;
                }
                return 1;
            }
            return 1;
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        catch (SQLException e2) {
            throw new TaskExternalException(e2.getMessage(), (Throwable)e2);
        }
    }

    public static int getSeq(Context ctx, String cardId, String tblName, boolean isInitCard) throws TaskExternalException {
        String cardIdField = "ffacurcardid";
        if (isInitCard) {
            cardIdField = "ffaMoncardid";
        }
        String querySql = "select max(fseq) from " + tblName + " where " + cardIdField + " = ?";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)querySql, (Object[])new Object[]{cardId});
            if (rs.next()) {
                if (rs.getString(1) != null) {
                    return rs.getInt(1) + 1;
                }
                return 1;
            }
            return 1;
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        catch (SQLException e2) {
            throw new TaskExternalException(e2.getMessage(), (Throwable)e2);
        }
    }

    private static String dateToString(Date date) throws TaskExternalException {
        if (date == null) {
            return null;
        }
        return new SimpleDateFormat("yyyy-MM-dd").format(date);
    }

    public static Hashtable setDataForExport(String[] fields, String[] keys, IRowSet rs, Map precisions) throws SQLException, TaskExternalException {
        int i;
        if (fields.length != keys.length) {
            throw new IllegalArgumentException("field length not match key length :" + fields.length + " " + keys.length);
        }
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        int baseScale = 0;
        int originScale = 0;
        int quantityScale = 0;
        int rateScale = 0;
        int depreScale = 4;
        if (precisions != null) {
            if (precisions.get("baseScale") != null) {
                baseScale = (Integer)precisions.get("baseScale");
            }
            if (precisions.get("originScale") != null) {
                originScale = (Integer)precisions.get("originScale");
            }
            if (precisions.get("quantityScale") != null) {
                quantityScale = (Integer)precisions.get("quantityScale");
            }
            if (precisions.get("rateScale") != null) {
                rateScale = (Integer)precisions.get("rateScale");
            }
            if (precisions.get("depreScale") != null) {
                depreScale = (Integer)precisions.get("depreScale");
            }
        }
        HashMap<String, Integer> typeMap = new HashMap<String, Integer>();
        for (i = 1; i <= rs.getMetaData().getColumnCount(); ++i) {
            int columnType = rs.getMetaData().getColumnType(i);
            String columnName = rs.getMetaData().getColumnName(i);
            typeMap.put(columnName, new Integer(columnType));
        }
        for (i = 0; i < fields.length; ++i) {
            Object obj;
            String field = fields[i];
            String key = keys[i];
            if (!typeMap.containsKey(key) || (obj = rs.getObject(key)) == null) continue;
            int type = (Integer)typeMap.get(key);
            if (type == 91 || type == 92 || type == 93) {
                java.sql.Date date = rs.getDate(key);
                result.put(field, FaDataImportUtils.dateToString(date));
                continue;
            }
            if (type == 3 || type == 2) {
                if (key.equals("originAmt") || key.equals("unitPrice") || key.equals("originAmount") || key.equals("taxOriginAmt") || key.equals("inputTax")) {
                    result.put(field, rs.getBigDecimal(key).setScale(originScale, 4).toString());
                    continue;
                }
                if (key.equals("assetAmt") || key.equals("facility.quantity") || key.equals("initData.assetAmtBeginQty") || key.equals("initData.assetAmtIncQty") || key.equals("initData.assetAmtDecQty")) {
                    result.put(field, rs.getBigDecimal(key).setScale(quantityScale, 4).toString());
                    continue;
                }
                if (key.equals("exRate")) {
                    result.put(field, rs.getBigDecimal(key).setScale(rateScale, 4).toString());
                    continue;
                }
                if (key.equals("deprTermCount") || key.equals("useTermCount") || key.equals("evalLeftPeriod")) {
                    result.put(field, rs.getBigDecimal(key).setScale(2, 4).toString());
                    continue;
                }
                if (key.equals("evalUseTermCount") || key.equals("evalDeprPeriodNum") || key.equals("evalTaxLeftPeriod")) {
                    result.put(field, rs.getBigDecimal(key).setScale(2, 4));
                    continue;
                }
                if (key.equals("costCenter.apportionScale") || key.equals("neatLeftRate") || key.equals("inputTaxRate")) {
                    result.put(field, rs.getBigDecimal(key).setScale(2, 4).toString());
                    continue;
                }
                if (key.equals("useYears")) {
                    result.put(field, rs.getBigDecimal(key).setScale(1, 4).toString());
                    continue;
                }
                if (key.equals("monthDepreRate")) {
                    result.put(field, rs.getBigDecimal(key).setScale(depreScale, 4).toString());
                    continue;
                }
                if (key.indexOf("PV.") != -1) {
                    result.put(field, rs.getBigDecimal(key));
                    continue;
                }
                if (key.equals("assetValue") || key.equals("neatValue") || key.equals("neatAmt")) {
                    result.put(field, rs.getBigDecimal(key).setScale(baseScale, 4).toString());
                    continue;
                }
                result.put(field, rs.getBigDecimal(key).setScale(baseScale, 4).toString());
                continue;
            }
            result.put(field, rs.getString(key));
        }
        return result;
    }

    public static Hashtable setDataForExport2(String[] fields, String[] keys, IRowSet rs, Map precisions, FaDefPropertyCollection pc, Context ctx) throws SQLException, TaskExternalException {
        int i;
        if (fields.length != keys.length) {
            throw new IllegalArgumentException("field length not match key length :" + fields.length + " " + keys.length);
        }
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        int baseScale = 0;
        int originScale = 0;
        int quantityScale = 0;
        int rateScale = 0;
        int depreScale = 4;
        if (precisions != null) {
            if (precisions.get("baseScale") != null) {
                baseScale = (Integer)precisions.get("baseScale");
            }
            if (precisions.get("originScale") != null) {
                originScale = (Integer)precisions.get("originScale");
            }
            if (precisions.get("quantityScale") != null) {
                quantityScale = (Integer)precisions.get("quantityScale");
            }
            if (precisions.get("rateScale") != null) {
                rateScale = (Integer)precisions.get("rateScale");
            }
            if (precisions.get("depreScale") != null) {
                depreScale = (Integer)precisions.get("depreScale");
            }
        }
        HashMap<String, Integer> typeMap = new HashMap<String, Integer>();
        for (i = 1; i <= rs.getMetaData().getColumnCount(); ++i) {
            int columnType = rs.getMetaData().getColumnType(i);
            String columnName = rs.getMetaData().getColumnName(i);
            typeMap.put(columnName, new Integer(columnType));
        }
        for (i = 0; i < fields.length; ++i) {
            Object obj;
            String field = fields[i];
            String key = keys[i];
            if (!typeMap.containsKey(key) || (obj = rs.getObject(key)) == null) continue;
            int type = (Integer)typeMap.get(key);
            if (type == 91 || type == 92 || type == 93) {
                java.sql.Date date = rs.getDate(key);
                result.put(field, FaDataImportUtils.dateToString(date));
                continue;
            }
            if (type == 3 || type == 2) {
                if (key.equals("originAmt") || key.equals("unitPrice") || key.equals("originAmount")) {
                    result.put(field, rs.getBigDecimal(key).setScale(originScale, 4).toString());
                    continue;
                }
                if (key.equals("assetAmt") || key.equals("facility.quantity") || key.equals("initData.assetAmtBeginQty") || key.equals("initData.assetAmtIncQty") || key.equals("initData.assetAmtDecQty")) {
                    result.put(field, rs.getBigDecimal(key).setScale(quantityScale, 4).toString());
                    continue;
                }
                if (key.equals("exRate")) {
                    result.put(field, rs.getBigDecimal(key).setScale(rateScale, 4).toString());
                    continue;
                }
                if (key.equals("deprTermCount") || key.equals("useTermCount") || key.equals("evalLeftPeriod")) {
                    result.put(field, rs.getBigDecimal(key).setScale(2, 4).toString());
                    continue;
                }
                if (key.equals("evalUseTermCount") || key.equals("evalDeprPeriodNum") || key.equals("evalTaxLeftPeriod")) {
                    result.put(field, rs.getBigDecimal(key).setScale(2, 4));
                    continue;
                }
                if (key.equals("costCenter.apportionScale") || key.equals("neatLeftRate")) {
                    result.put(field, rs.getBigDecimal(key).setScale(2, 4).toString());
                    continue;
                }
                if (key.equals("useYears")) {
                    result.put(field, rs.getBigDecimal(key).setScale(1, 4).toString());
                    continue;
                }
                if (key.equals("monthDepreRate")) {
                    result.put(field, rs.getBigDecimal(key).setScale(depreScale, 4).toString());
                    continue;
                }
                if (key.indexOf("PV.") != -1) {
                    result.put(field, rs.getBigDecimal(key).stripTrailingZeros());
                    rs.updateBigDecimal(key, rs.getBigDecimal(key).stripTrailingZeros());
                    continue;
                }
                if (key.equals("assetValue") || key.equals("neatValue") || key.equals("neatAmt")) {
                    result.put(field, rs.getBigDecimal(key));
                    continue;
                }
                result.put(field, rs.getBigDecimal(key).setScale(baseScale, 4).toString());
                continue;
            }
            if (key.startsWith("PV.") && FaDataImportUtils.isAsstActItem(pc, key.substring(3))) {
                try {
                    String cardId = rs.getString("id");
                    String cardTable = "T_FA_FaCurCard";
                    BOSObjectType bosType = BOSUuid.getBOSObjectType((String)cardId, (boolean)true);
                    if (bosType.toString().equals(new FaMonCardInfo().getBOSType().toString())) {
                        cardTable = "T_FA_FaMonCard";
                    }
                    FaDefPropertyInfo p = FaDataImportUtils.getDefProByNumber(pc, key.substring(3));
                    AsstActTypeInfo actType = AsstActTypeFactory.getLocalInstance((Context)ctx).getAsstActTypeInfo((IObjectPK)new ObjectUuidPK(p.getAsstActType().getId()));
                    String actTable = actType.getRealtionDataObject();
                    StringBuffer asstSql = new StringBuffer();
                    String loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
                    if (field.toLowerCase().contains("_longnumber")) {
                        asstSql.append("SELECT asst.FLongNumber longnumber FROM ").append(actTable).append(" asst");
                    } else {
                        asstSql.append("SELECT asst.FName_").append(loc).append(" longnumber FROM ").append(actTable).append(" asst");
                    }
                    asstSql.append(" WHERE asst.FID = (");
                    asstSql.append(" SELECT dp.F").append(key.substring(3)).append(" FROM ").append(cardTable).append(" card");
                    asstSql.append(" INNER JOIN T_FA_FaDefPropertyValue dp ON dp.FID = card.FPropertyValueId");
                    asstSql.append(" WHERE card.FID = '").append(cardId).append("')");
                    IRowSet asstRs = DbUtil.executeQuery((Context)ctx, (String)asstSql.toString());
                    if (asstRs != null && asstRs.next()) {
                        result.put(field, asstRs.getString("longnumber"));
                        rs.updateString(key, asstRs.getString("longnumber"));
                        continue;
                    }
                    result.put(field, "");
                    continue;
                }
                catch (Exception e) {
                    throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"159_FaDataImportUtils", (Locale)ctx.getLocale()), (Throwable)e);
                }
            }
            result.put(field, rs.getString(key));
        }
        return result;
    }

    public static boolean isAsstActItem(FaDefPropertyCollection pc, String number) {
        FaDefPropertyInfo p = FaDataImportUtils.getDefProByNumber(pc, number);
        return p != null && p.getType().getValue() == 5;
    }

    public static FaDefPropertyInfo getDefProByNumber(FaDefPropertyCollection pc, String number) {
        for (int i = 0; i < pc.size(); ++i) {
            FaDefPropertyInfo p = pc.get(i);
            if (!p.getNumber().equalsIgnoreCase(number)) continue;
            return p;
        }
        return null;
    }

    public static boolean checkExistLongNumberField(Context ctx, String table) throws BOSException, SQLException {
        String sql = "select 1 from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FLongNumber' and KSQL_COL_TABNAME = ?";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{table});
        return rs != null && rs.next();
    }

    public static FilterInfo getFilterForExp(Context ctx, FilterInfo baseFilter, boolean isMonCard) {
        String companyId = ContextUtil.getCurrentFIUnit((Context)ctx) != null ? ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString() : null;
        FilterInfo filter = new FilterInfo();
        if (isMonCard) {
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
            filter.getFilterItems().add(new FilterItemInfo("faPeriod.id", null));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
        }
        return filter;
    }

    public static AsstActTypeInfo getAsstActType(Context ctx, String oql) throws TaskExternalException {
        if (FaDataImportUtils.isEmpty(oql)) {
            return null;
        }
        try {
            IAsstActType iActtype = AsstActTypeFactory.getLocalInstance((Context)ctx);
            return (AsstActTypeInfo)iActtype.getValue(oql);
        }
        catch (ObjectNotFoundException obje) {
            FaDataImportUtils.procException(ctx, FaResUtil.getRes((String)"FAsstActType", (Locale)ctx.getOriginLocale()), obje);
            return null;
        }
        catch (EASBizException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public static void verifyForLastestPeriod(Context ctx, FaCardInfo card, Hashtable params, boolean isInitCard) throws TaskExternalException {
        if (card.getId() == null) {
            return;
        }
        try {
            HashSet<String> allPeriods;
            PeriodInfo currPeriod = (PeriodInfo)params.get("card_currentPeriod");
            HashSet laterPeriods = (HashSet)params.get("card_laterperiods");
            String companyId = card.getCompany().getId().toString();
            if (currPeriod == null) {
                PeriodInfo[] p = FaPeriodCloseFacadeFactory.getLocalInstance(ctx).getLastestPeriod(companyId);
                params.put("card_currentPeriod", p[1]);
                currPeriod = p[1];
                laterPeriods = FaLocalUtils.getLaterPeriodIdSet(ctx, currPeriod.getId().toString());
                params.put("card_laterperiods", laterPeriods);
                allPeriods = new HashSet((Collection)laterPeriods.clone());
                allPeriods.add(currPeriod.getId().toString());
                params.put("card_allperiods", allPeriods);
                params.put("card_islastestperiod", p[1].getId().toString().equals(p[0].getId().toString()));
            }
            HashSet<String> cardSet = new HashSet<String>();
            if (card instanceof FaMonCardInfo) {
                FaMonCardInfo moncard = (FaMonCardInfo)card;
                if (moncard.getFaCurCard() != null) {
                    cardSet.add(moncard.getFaCurCard().getId().toString());
                }
            } else if (card instanceof FaCurCardInfo) {
                FaCurCardInfo curcard = (FaCurCardInfo)card;
                cardSet.add(curcard.getId().toString());
            }
            allPeriods = new HashSet<String>((Collection)laterPeriods.clone());
            allPeriods.add(currPeriod.getId().toString());
            if (cardSet.size() > 0) {
                FaLocalUtils.checkLaterPeriodDep(ctx, companyId, allPeriods, cardSet, true);
                FaLocalUtils.hasFANewBiz(ctx, allPeriods, cardSet, companyId);
            }
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public static boolean verifyBusiDataForLastestPeriod(Context ctx, FaCardInfo card, Hashtable params, boolean isInitCard) throws TaskExternalException {
        if (card.getId() == null) {
            return false;
        }
        boolean result = false;
        try {
            PeriodInfo currPeriod = (PeriodInfo)params.get("card_currentPeriod");
            HashSet laterPeriods = (HashSet)params.get("card_laterperiods");
            String companyId = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
            if (currPeriod == null) {
                PeriodInfo[] p = FaPeriodCloseFacadeFactory.getLocalInstance(ctx).getLastestPeriod(companyId);
                params.put("card_currentPeriod", p[1]);
                currPeriod = p[1];
                laterPeriods = FaLocalUtils.getLaterPeriodIdSet(ctx, currPeriod.getId().toString());
                params.put("card_laterperiods", laterPeriods);
                HashSet<String> allPeriods = new HashSet<String>((Collection)laterPeriods.clone());
                allPeriods.add(currPeriod.getId().toString());
                params.put("card_allperiods", allPeriods);
                params.put("card_islastestperiod", p[1].getId().toString().equals(p[0].getId().toString()));
            }
            HashSet<String> allPeriods = new HashSet<String>((Collection)laterPeriods.clone());
            allPeriods.add(currPeriod.getId().toString());
            result = FaLocalUtils.checkLaterPeriodDepreciation(ctx, companyId, allPeriods);
            if (result) {
                return result;
            }
            result = FaLocalUtils.hasFANewBizForInitCardImport(ctx, allPeriods, companyId);
            if (result) {
                return result;
            }
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return false;
    }

    public static void verifyAuditCardForImport(Context ctx, FaCardInfo card, Hashtable params, boolean isInitCard) throws TaskExternalException {
        FaDataImportUtils.verifyForLastestPeriod(ctx, card, params, isInitCard);
        if (!isInitCard) {
            FaDataImportUtils.verifyIsLastestPeriod(ctx, card, params);
        }
    }

    public static void verifyIsLastestPeriod(Context ctx, Hashtable params) throws TaskExternalException {
        Boolean islastestperiod = (Boolean)params.get("card_islastestperiod");
        try {
            String companyId = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
            if (islastestperiod == null) {
                PeriodInfo[] p = FaPeriodCloseFacadeFactory.getLocalInstance(ctx).getLastestPeriod(companyId);
                params.put("card_islastestperiod", p[1].getId().toString().equals(p[0].getId().toString()));
                islastestperiod = p[1].getId().toString().equals(p[0].getId().toString());
            }
            if (!islastestperiod.booleanValue()) {
                throw new FaPeriodException(FaPeriodException.LASTPERIODOPERNOTALLOW);
            }
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public static void verifyIsLastestPeriod(Context ctx, FaCardInfo card, Hashtable params) throws TaskExternalException {
        Boolean islastestperiod = (Boolean)params.get("card_islastestperiod");
        try {
            String companyId = card.getCompany().getId().toString();
            if (islastestperiod == null) {
                PeriodInfo[] p = FaPeriodCloseFacadeFactory.getLocalInstance(ctx).getLastestPeriod(companyId);
                params.put("card_islastestperiod", p[1].getId().toString().equals(p[0].getId().toString()));
                islastestperiod = p[1].getId().toString().equals(p[0].getId().toString());
            }
            if (!islastestperiod.booleanValue()) {
                throw new FaPeriodException(FaPeriodException.LASTPERIODOPERNOTALLOW);
            }
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    protected static void checkCardAudit(Context ctx, FaCardInfo card, HashMap params) throws TaskExternalException {
        String isImportInfoForAuditCard = params.get("FA_037").toString();
        if (CheckedStatusEnum.AUDITED.equals((Object)card.getCheckedStatus()) && "false".equals(isImportInfoForAuditCard)) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"69_FaDataImportUtils", (Locale)ctx.getOriginLocale()));
        }
    }
}

