/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app.dataimp;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.AddressInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeAuxFactory;
import com.kingdee.eas.basedata.assistant.ExchangeAuxInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.IExchangeAux;
import com.kingdee.eas.basedata.assistant.IExchangeRate;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountTools;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.cssp.UsedStatusEnum;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.basedata.FaAlterModeInfo;
import com.kingdee.eas.fi.fa.basedata.FaCatInfo;
import com.kingdee.eas.fi.fa.basedata.FaDepreciationModeInfo;
import com.kingdee.eas.fi.fa.basedata.FaEconomicPurpInfo;
import com.kingdee.eas.fi.fa.basedata.FaResUtil;
import com.kingdee.eas.fi.fa.basedata.FaUseStatusInfo;
import com.kingdee.eas.fi.fa.basedata.FaUtils;
import com.kingdee.eas.fi.fa.manage.FaBizStatusEnum;
import com.kingdee.eas.fi.fa.manage.FaCardCache;
import com.kingdee.eas.fi.fa.manage.FaCardInfo;
import com.kingdee.eas.fi.fa.manage.FaCardOriginEnum;
import com.kingdee.eas.fi.fa.manage.FaCardValidatorImpl;
import com.kingdee.eas.fi.fa.manage.FaChangeStatusEnmu;
import com.kingdee.eas.fi.fa.manage.FaCurCardCollection;
import com.kingdee.eas.fi.fa.manage.FaCurCardFactory;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.fi.fa.manage.FaCurInitDataFactory;
import com.kingdee.eas.fi.fa.manage.FaCurInitDataInfo;
import com.kingdee.eas.fi.fa.manage.FaFromUnitCatEnum;
import com.kingdee.eas.fi.fa.manage.FaInitDataInfo;
import com.kingdee.eas.fi.fa.manage.FaMonCardCollection;
import com.kingdee.eas.fi.fa.manage.FaMonCardFactory;
import com.kingdee.eas.fi.fa.manage.FaMonCardInfo;
import com.kingdee.eas.fi.fa.manage.FaMonInitDataFactory;
import com.kingdee.eas.fi.fa.manage.FaMonInitDataInfo;
import com.kingdee.eas.fi.fa.manage.FaPeriodCloseFacadeFactory;
import com.kingdee.eas.fi.fa.manage.IFaBillValidator;
import com.kingdee.eas.fi.fa.manage.IFaMonCard;
import com.kingdee.eas.fi.fa.manage.app.FaLocalUtils;
import com.kingdee.eas.fi.fa.manage.app.dataimp.AbstractFaBatchDataRunner;
import com.kingdee.eas.fi.fa.manage.app.dataimp.AbstractFaDataImport;
import com.kingdee.eas.fi.fa.manage.app.dataimp.FaDataImportUtils;
import com.kingdee.eas.framework.BlockedStatusEnum;
import com.kingdee.eas.framework.CheckedStatusEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.framework.EffectedStatusEnum;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.record.IRecord;
import com.kingdee.eas.tools.datatask.record.RecordCollection;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.IRowSetMetaData;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class FaMonCardDataImport
extends AbstractFaDataImport {
    private static final Logger logger = Logger.getLogger(FaMonCardDataImport.class);
    private static final BigDecimal ZERO = new BigDecimal("0");
    private String[] DECIMAL_FIELDS = new String[]{"FLocalAmount", "FNeatValue", "FNeatAmount", "FAdditiveAmount", "FBuyOriginalValue", "FBuyAddUpDep", "FExpUsePeriod", "FDepPeriod", "FAddUPDep", "FExpNeatLeftValue", "FAddUPDepThisYear", "FDecPrepare", "FFairValue", "FTreatmentIncome", "FAddonFare", "FInputTax", "FWrtyPeriod"};
    private String[] DECIMAL_OBJS = new String[]{"assetValue", "neatValue", "neatAmt", "addons", "buyValue", "buyAccuDepr", "useTermCount", "deprTermCount", "accuDepr", "neatRemValue", "accuDeprTYear", "decValue", "fairValue", "treatmentIncome", "addonFare", "inputTax", "wrtyPeriod"};
    private String[] DECIMAL_OBJS_NOT_IN_FILE = new String[]{"accuDeprChg", "accuDeprAccuChg", "accuDeprAccuClean", "deprTTerm", "accuDeprAccuChgTYear", "accuDeprAccuCleanTYear", "decValueChg", "decValueAccuChg", "originDif", "originAccuDif", "accuDeprForCal", "wellDeprValue", "tempDeprTermCount", "tempUseTermCount"};
    private String[] NUMBER_OBJS_NOT_IN_FILE = new String[]{"leftYear", "leftYearUp", "deprCount", "lastPeriodCount"};
    private String[] DATE_FIELDS = new String[]{"FRecordDate", "FLeaveFactoryDate", "FDeliverDate", "FStartDate", "FFiAccountDate"};
    private String[] DATE_OBJS = new String[]{"accountDate", "levFrDate", "deliverDate", "startUseDate", "fiAccountDate"};
    private String[] BOOLEAN_OBJS = new String[]{"hasChanged", "hasCleared", "hasEvaled", "hasNew", "hasSplited", "hasSplited", "isNeedReDepr"};
    private String[] ENUM_FIELDS = new String[]{"FFromType"};
    private String[] STRING_FIELDS = new String[]{"FNumber", "Fspecs", "FArea_L1", "Fmanufacturer", "FPaperNo", "Fremark", "FWrtyNumber", "FGroupNumber", "FBarCode"};
    private String[] STRING_OBJS = new String[]{"number", "specs", "pArea", "mfr", "paperNo", "remark", "wrtyNumber", "groupNumber", "barCode"};
    private String[] STRING_OBJS_NOT_IN_FILE = new String[]{"lastBillID", "tempDeprMethod", "sourceFunction", "description"};
    private String[] EXP_FIELD_IN_FILE = new String[]{"FOrgUnitID", "FFaCatID", "FNumber", "FOldNumber", "FAssetName", "FAssetAmount", "FMeasureUnitID", "FRecordDate", "FOrigin", "FFaUseStatusID", "FEconomyPurpose", "FStoreCityID", "Fspecs", "FArea_L1", "Fmanufacturer", "FLeaveFactoryDate", "FPaperNo", "FFromType", "FFromUnit", "FManageDepartmentID", "FKeeperID", "Fremark", "FCurrencyID", "FExchangeRate", "FOriginalAmount", "FTaxOriginAmt", "FInputTaxRate", "FIsDeduct", "FIsHasTax", "FAdditiveAmount", "FLocalAmount", "FFairValue", "FBuyOriginalValue", "FBuyAddUpDep", "FTreatmentIncome", "FDeliverDate", "FStartDate", "FExpUseYears", "FExpUsePeriod", "FDepPeriod", "FAddUPDep", "FExpNeatLeftValue", "FNeatValue", "FAddUPDepThisYear", "FDecPrepare", "FNeatAmount", "FFaDepreciationModeID", "FLoadMeasureUnitID", "FAccountFixedAssetsID", "FAccountDepreciationID", "FAccountDecPrepareID", "FInitEvalValue", "FEvalPeriodLeft", "FAccuDeprAll", "FHasDisabled", "FCreatorNumber", "FCreateTime", "FEconomyPurpose", "FNeatLeftRate", "FAddonFare", "FFiAccountDate", "FMonthRate", "FInputTax", "FWrtyPeriod", "FWrtyNumber", "FGroupNumber", "FBarCode"};
    private String[] EXP_FIELD_IN_QUERY = new String[]{"company.number", "assetCat.number", "number", "oldNumber", "assetName", "assetAmt", "measureUnit.number", "accountDate", "originMethod.number", "useStatus.number", "economicPurp.number", "storeCity.number", "specs", "pArea", "mfr", "levFrDate", "paperNo", "originType", "originUnit", "dept.number", "keeper.number", "remark", "currency.number", "exRate", "originAmt", "taxOriginAmt", "inputTaxRate", "isDeduct", "isHasTax", "addons", "assetValue", "fairValue", "buyValue", "buyAccuDepr", "treatmentIncome", "deliverDate", "startUseDate", "useYears", "useTermCount", "deprTermCount", "accuDepr", "neatRemValue", "neatValue", "accuDeprTYear", "decValue", "neatAmt", "deprMethod.number", "measureUnitWL.number", "accountAsset.number", "accountAccuDepr.number", "accountDecValue.number", "initEvalValue", "evalLeftPeriod", "accuDeprAll", "deletedStatus", "creator.number", "createTime", "economicPurp.number", "neatLeftRate", "addonFare", "fiAccountDate", "monthDepreRate", "inputTax", "wrtyPeriod", "wrtyNumber", "groupNumber", "barCode"};
    private CurrencyInfo baseCurrency;
    private CurrencyInfo currency;
    protected CompanyOrgUnitInfo company;
    private boolean isRelAccount = false;
    private PeriodInfo currenctPeriod;
    private int quantityScale = 0;
    private int rateScale = 2;
    private int originScale = 10;
    private int baseScale = 10;
    private String cu;
    private String fi;
    protected QueryObjCacheInfo cache = new QueryObjCacheInfo();
    private Map<String, QueryObjCacheInfo> cacheMap = new HashMap<String, QueryObjCacheInfo>();
    HashMap workloadSchemes = null;
    protected IFaBillValidator validator;
    protected HashMap hmParam;
    private boolean isAddOnNull = true;
    private boolean isTreatmentIncomeNull = true;

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return FaMonCardFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        try {
            boolean isNewCard = false;
            if (this.isInitCard() && coreBaseInfo.getId() == null) {
                isNewCard = true;
            }
            IObjectPK monCardPK = ((IFaMonCard)this.getController(ctx)).submitInit(coreBaseInfo);
            FaMonCardInfo monCardInfo = (FaMonCardInfo)coreBaseInfo;
            monCardInfo.setId(BOSUuid.read((String)monCardPK.toString()));
            FaInitDataInfo initDataInfo = new FaInitDataInfo();
            FaDataImportUtils.setDefaultDecimalData(new String[]{"originIncQty", "originDecQty", "deprIncQty", "deprDecQty", "decValueIncQty", "decValueDecQty", "assetAmtIncQty", "assetAmtDecQty"}, ZERO, initDataInfo, this.baseScale);
            initDataInfo.setOriginBeginQty(monCardInfo.getAssetValue());
            initDataInfo.setDeprBeginQty(monCardInfo.getAccuDepr().subtract(monCardInfo.getAccuDeprTYear()).setScale(this.baseScale, 4));
            initDataInfo.setDecValueBeginQty(monCardInfo.getDecValue());
            initDataInfo.setAssetAmtBeginQty(monCardInfo.getAssetAmt());
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)("SELECT INITDATA.FID AS FID FROM T_FA_FAMONCARD MONCARD INNER JOIN T_FA_FAMONINITDATA INITDATA ON MONCARD.FID = INITDATA.FFaMonCardID WHERE MONCARD.FID ='" + monCardPK + "'"));
            if (!rs.next()) {
                FaMonInitDataInfo monInitData = new FaMonInitDataInfo();
                FaDataImportUtils.cloneObjectInfo(initDataInfo, monInitData);
                monInitData.setFaMonCard(monCardInfo);
                FaMonInitDataFactory.getLocalInstance(ctx).addnew(monInitData);
            } else {
                String id = rs.getString("FID");
                FaMonInitDataInfo monInitData = new FaMonInitDataInfo();
                FaDataImportUtils.cloneObjectInfo(initDataInfo, monInitData);
                monInitData.setFaMonCard(monCardInfo);
                monInitData.setId(BOSUuid.read((String)id));
                FaMonInitDataFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(id), monInitData);
            }
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)("SELECT INITDATA.FID AS FID FROM T_FA_FACURCARD CURCARD INNER JOIN T_FA_FACURINITDATA INITDATA ON CURCARD.FID = INITDATA.FFaCurCardID WHERE CURCARD.FNUMBER ='" + monCardInfo.getNumber() + "' AND CURCARD.FCOMPANYID = '" + this.company.getId() + "'"));
            rs = DbUtil.executeQuery((Context)ctx, (String)("SELECT CURCARD.FID FROM T_FA_FACURCARD CURCARD WHERE CURCARD.FNUMBER ='" + monCardInfo.getNumber() + "' AND CURCARD.FCOMPANYID = '" + this.company.getId() + "'"));
            if (rs.next()) {
                FaCurCardInfo curCardInfo = new FaCurCardInfo();
                curCardInfo.setId(BOSUuid.read((String)rs.getString(1)));
                FaCurInitDataInfo curInitData = new FaCurInitDataInfo();
                FaDataImportUtils.cloneObjectInfo(initDataInfo, curInitData);
                curInitData.setFaCurCard(curCardInfo);
                if (!rowSet.next()) {
                    FaCurInitDataFactory.getLocalInstance(ctx).addnew(curInitData);
                } else {
                    String id = rowSet.getString("FID");
                    curInitData.setId(BOSUuid.read((String)id));
                    FaCurInitDataFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(id), curInitData);
                }
            }
            String sql = "update t_fa_famoncard set FEffectedStatus=1 where fid='" + monCardPK.toString() + "'";
            DbUtil.execute((Context)ctx, (String)sql);
            sql = "update t_fa_facurcard set FEffectedStatus=1 where fid in (select ffacurcardid from t_fa_famoncard  where fid='" + monCardPK.toString() + "')";
            DbUtil.execute((Context)ctx, (String)sql);
            FaCardCache faCardCache = FaCardCache.getCache();
            if (faCardCache != null && isNewCard) {
                faCardCache.cacheMonCardNum(monCardInfo.getNumber());
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), (Throwable)ex);
        }
    }

    private void validateNeatLeftValue(FaCardInfo cardInfo, Context ctx) throws TaskExternalException {
        BigDecimal hundred = new BigDecimal("100");
        BigDecimal neatLeftRate = cardInfo.getNeatLeftRate();
        if (neatLeftRate != null) {
            neatLeftRate = neatLeftRate.divide(hundred);
        }
        BigDecimal neatRemValue = cardInfo.getNeatRemValue();
        BigDecimal localAmount = cardInfo.getAssetValue();
        if (this.isAddOnNull && this.isTreatmentIncomeNull) {
            if (localAmount == null || neatRemValue == null || neatLeftRate == null) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"161_FaMonCardDataImport", (Locale)ctx.getLocale()));
            }
            if (neatLeftRate.multiply(localAmount).compareTo(neatRemValue) != 0) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"161_FaMonCardDataImport", (Locale)ctx.getLocale()));
            }
        }
    }

    public CoreBaseInfo transmit(Hashtable data, Context ctx) throws TaskExternalException {
        String oldNumber;
        Boolean isLastPeriod;
        AccountViewInfo _acct;
        String obj;
        String companyNumber;
        FaCardCache faCardCache = FaCardCache.getCache();
        if (data.get("FAdditiveAmount").toString().length() > 0) {
            this.isAddOnNull = false;
        }
        if (data.get("FTreatmentIncome").toString().length() > 0) {
            this.isTreatmentIncomeNull = false;
        }
        if ((companyNumber = this.getValue(data, "FOrgUnitID")) != null && !"".equals(companyNumber)) {
            if (this.cacheMap.containsKey(companyNumber)) {
                this.cache = this.cacheMap.get(companyNumber);
            } else {
                this.cache = new QueryObjCacheInfo();
                this.cacheMap.put(companyNumber, this.cache);
            }
        } else {
            if (!this.isInitCard()) {
                throw new TaskExternalException(FaResUtil.getRes((String)"fOrgUnitIDIsNull", (Locale)ctx.getOriginLocale()));
            }
            companyNumber = ContextUtil.getCurrentFIUnit((Context)ctx).getNumber();
            this.cache = new QueryObjCacheInfo();
            this.cacheMap.put(companyNumber, this.cache);
        }
        if (this.cache.CURRENTCOMP != null) {
            this.company = this.cache.CURRENTCOMP;
        } else {
            try {
                this.company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo("SELECT * , baseCurrency.* WHERE NUMBER ='" + companyNumber + "'");
            }
            catch (Exception e) {
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
            this.cache.CURRENTCOMP = this.company;
        }
        this.verifyBeforeTran(ctx, true);
        this.cu = this.company.getCU().getId().toString();
        this.fi = this.company.getId().toString();
        this.baseCurrency = this.company.getBaseCurrency();
        Locale locale = ctx.getOriginLocale();
        this.assertNotNull(this.baseCurrency, FaResUtil.getRes((String)"standardMondeyIsNull", (Locale)locale));
        if (this.cache.ISRELACCOUNT != null) {
            this.isRelAccount = this.cache.ISRELACCOUNT;
        } else {
            try {
                this.isRelAccount = SystemStatusCtrolUtils.isRelAccount((Context)ctx, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)this.company);
            }
            catch (Exception e) {
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
            this.cache.ISRELACCOUNT = this.isRelAccount;
        }
        if (this.cache.CURRENCY.containsKey(this.getValue(data, "FCurrencyID"))) {
            this.currency = (CurrencyInfo)this.cache.CURRENCY.get(this.getValue(data, "FCurrencyID"));
        } else {
            this.currency = FaDataImportUtils.getCurrencyInfo(ctx, this.getBaseDataOql(this.getValue(data, "FCurrencyID"), true, false));
            this.cache.CURRENCY.put(this.getValue(data, "FCurrencyID"), this.currency);
        }
        this.assertNotNull(this.currency, FaResUtil.getRes((String)"currencyIsNull", (Locale)locale));
        try {
            this.initScale(ctx);
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        FaMonCardInfo card = new FaMonCardInfo();
        card.setCompany(this.company);
        String[] DECIMAL_CHN = new String[]{FaResUtil.getRes((String)"assetOrgValue", (Locale)locale), FaResUtil.getRes((String)"netValue", (Locale)locale), FaResUtil.getRes((String)"netAmount", (Locale)locale), FaResUtil.getRes((String)"addFei", (Locale)locale), FaResUtil.getRes((String)"purchaseOrgValue", (Locale)locale), FaResUtil.getRes((String)"purchaseDpr", (Locale)locale), FaResUtil.getRes((String)"preUsingPeriod", (Locale)locale), FaResUtil.getRes((String)"alreadyDprPeriod", (Locale)locale), FaResUtil.getRes((String)"totalDpr", (Locale)locale), FaResUtil.getRes((String)"preNetAmountValue", (Locale)locale), FaResUtil.getRes((String)"yearTotaoDpr", (Locale)locale), FaResUtil.getRes((String)"devaluePre", (Locale)locale), FaResUtil.getRes((String)"fairValue", (Locale)locale), FaResUtil.getRes((String)"treatmentIncome", (Locale)locale), FaResUtil.getRes((String)"addonFare", (Locale)locale), FaResUtil.getRes((String)"inputTax", (Locale)locale), FaResUtil.getRes((String)"wrtyPeriod", (Locale)locale)};
        FaDataImportUtils.setBigDecimalData(ctx, data, this.DECIMAL_FIELDS, this.DECIMAL_OBJS, DECIMAL_CHN, (CoreBaseInfo)card, false, this.baseScale);
        FaDataImportUtils.setBigDecimalData(ctx, data, new String[]{"FAssetAmount"}, new String[]{"assetAmt"}, new String[]{FaResUtil.getRes((String)"assetQuantity2", (Locale)locale)}, (CoreBaseInfo)card, false, this.quantityScale);
        FaDataImportUtils.setBigDecimalData(ctx, data, new String[]{"FExchangeRate"}, new String[]{"exRate"}, new String[]{FaResUtil.getRes((String)"rate", (Locale)locale)}, (CoreBaseInfo)card, false, this.rateScale);
        FaDataImportUtils.setBigDecimalData(ctx, data, new String[]{"FOriginalAmount"}, new String[]{"originAmt"}, new String[]{FaResUtil.getRes((String)"orgAmount1", (Locale)locale)}, (CoreBaseInfo)card, false, this.originScale);
        FaDataImportUtils.setBigDecimalData(ctx, data, new String[]{"FTaxOriginAmt"}, new String[]{"taxOriginAmt"}, new String[]{FaResUtil.getRes((String)"taxOriginAmt", (Locale)locale)}, (CoreBaseInfo)card, false, this.originScale);
        FaDataImportUtils.setBigDecimalData(ctx, data, new String[]{"FInputTaxRate"}, new String[]{"inputTaxRate"}, new String[]{FaResUtil.getRes((String)"inputTaxRate", (Locale)locale)}, (CoreBaseInfo)card, false, 2);
        FaDataImportUtils.setBigDecimalData(ctx, data, new String[]{"FNeatLeftRate"}, new String[]{"neatLeftRate"}, new String[]{FaResUtil.getRes((String)"neatLeftRate", (Locale)locale)}, (CoreBaseInfo)card, false, 2);
        FaDataImportUtils.setBigDecimalData(ctx, data, new String[]{"FWrtyPeriod"}, new String[]{"wrtyPeriod"}, new String[]{FaResUtil.getRes((String)"wrtyPeriod", (Locale)locale)}, (CoreBaseInfo)card, false, this.quantityScale);
        FaDataImportUtils.setBigDecimalData(ctx, data, new String[]{"FExpUseYears"}, new String[]{"useYears"}, new String[]{FaResUtil.getRes((String)"preUseingYears", (Locale)locale)}, (CoreBaseInfo)card, false, false, 1);
        int periodCount = 12;
        try {
            if (this.cache.PERIODCOUNT != null) {
                periodCount = this.cache.PERIODCOUNT;
            } else {
                periodCount = FaMonCardDataImport.getPeriodNumOfYear(ctx, this.currenctPeriod);
                this.cache.PERIODCOUNT = periodCount;
            }
            this.hmParam = this.gethmParam(ctx);
        }
        catch (EASBizException e1) {
            logger.error((Object)e1.getMessage());
        }
        catch (BOSException e1) {
            logger.error((Object)e1.getMessage());
        }
        boolean isWorkMethod = false;
        if (this.getValue(data, "FFaDepreciationModeID") != null && !"".equals(this.getValue(data, "FFaDepreciationModeID"))) {
            isWorkMethod = "002".equals(this.getValue(data, "FFaDepreciationModeID"));
        }
        String isKeepUseYearWithPeriod = (String)this.hmParam.get("FA_023");
        if (!(isWorkMethod || isKeepUseYearWithPeriod == null || "".equals(isKeepUseYearWithPeriod) || !new Boolean(isKeepUseYearWithPeriod).booleanValue() || this.getValue(data, "FExpUseYears") == null || "".equals(this.getValue(data, "FExpUseYears")) || this.getValue(data, "FExpUsePeriod") == null || "".equals(this.getValue(data, "FExpUsePeriod")))) {
            double UseYearsDouble = Double.parseDouble(this.getValue(data, "FExpUseYears"));
            double UsePeriodDouble = Double.parseDouble(this.getValue(data, "FExpUsePeriod"));
            if (new BigDecimal(periodCount).multiply(new BigDecimal(UseYearsDouble)).setScale(0, 4).compareTo(new BigDecimal(UsePeriodDouble)) != 0) {
                throw new TaskExternalException(FaResUtil.getRes((String)"useYearPeriodNotMatch", (Locale)ctx.getOriginLocale()));
            }
        }
        if (this.getValue(data, "FWrtyPeriod") != null && !this.getValue(data, "FWrtyPeriod").equalsIgnoreCase("")) {
            String obj2 = this.getValue(data, "FWrtyPeriod");
            if (obj2 != null && obj2.toString().trim().length() != 0) {
                try {
                    double valueDouble = Double.parseDouble(obj2.toString());
                    long value = Math.round(valueDouble);
                    if (value < 0L) {
                        throw new TaskExternalException(FaResUtil.getRes((String)"wrtyPeriod", (Locale)ctx.getOriginLocale()) + " " + FaResUtil.getRes((String)"canNotLess0", (Locale)ctx.getOriginLocale()));
                    }
                    card.setWrtyPeriod(new BigDecimal(value + ""));
                }
                catch (NumberFormatException e) {
                    throw new TaskExternalException(FaResUtil.getRes((String)"wrtyPeriod", (Locale)ctx.getOriginLocale()) + " " + FaResUtil.getRes((String)"formatIntError", (Locale)ctx.getOriginLocale()), (Throwable)e);
                }
            }
        } else {
            card.setWrtyPeriod(null);
        }
        if (this.getValue(data, "FExchangeRate") != null && !this.getValue(data, "FExchangeRate").equalsIgnoreCase("") && (obj = this.getValue(data, "FExchangeRate")) != null && obj.toString().trim().length() != 0) {
            try {
                BigDecimal value = new BigDecimal(obj.toString());
                value = value.setScale(this.rateScale, 4);
                if (this.currency.getId().equals((Object)this.baseCurrency.getId()) && new BigDecimal("1").compareTo(value) != 0) {
                    throw new TaskExternalException(MessageFormat.format(FaResUtil.getRes((String)"baseRateNotEqual1", (Locale)ctx.getOriginLocale()), this.baseCurrency.getName()));
                }
            }
            catch (NumberFormatException e) {
                throw new TaskExternalException(MessageFormat.format(FaResUtil.getRes((String)"formatErrorAmount", (Locale)ctx.getOriginLocale()), FaResUtil.getRes((String)"rate", (Locale)ctx.getOriginLocale())));
            }
        }
        String[] DATE_CHNS = new String[]{FaResUtil.getRes((String)"passEntriesDate", (Locale)locale), FaResUtil.getRes((String)"leaveFactoryDate", (Locale)locale), FaResUtil.getRes((String)"deliveryDate", (Locale)locale), FaResUtil.getRes((String)"startUseDate", (Locale)locale), FaResUtil.getRes((String)"fiAccountDate", (Locale)locale)};
        FaDataImportUtils.setDateTimeData(ctx, data, this.DATE_FIELDS, this.DATE_OBJS, DATE_CHNS, (CoreBaseInfo)card);
        String[] STRING_CHN = new String[]{FaResUtil.getRes((String)"cardNumber3", (Locale)locale), FaResUtil.getRes((String)"spec", (Locale)locale), FaResUtil.getRes((String)"producingArea", (Locale)locale), FaResUtil.getRes((String)"manufacture", (Locale)locale), FaResUtil.getRes((String)"wrtyNumber", (Locale)locale), FaResUtil.getRes((String)"groupNumber", (Locale)locale), FaResUtil.getRes((String)"barCode", (Locale)locale), FaResUtil.getRes((String)"pictureNumber", (Locale)locale), FaResUtil.getRes((String)"remark", (Locale)locale)};
        FaDataImportUtils.setStringData(ctx, data, this.STRING_FIELDS, this.STRING_OBJS, STRING_CHN, (CoreBaseInfo)card);
        FaDataImportUtils.setStringData(ctx, data, new String[]{"FAssetName"}, new String[]{"assetName"}, new String[]{FaResUtil.getRes((String)"assetName4", (Locale)locale)}, (CoreBaseInfo)card, true, null);
        this.setCardInfoOverrided(ctx, card);
        if (this.cache.ISCHECKBUSSINESSDATA != null) {
            boolean isCheckBussinessData = this.cache.ISCHECKBUSSINESSDATA;
            if (isCheckBussinessData) {
                FaDataImportUtils.verifyForLastestPeriod(ctx, card, this.getContextParameter(), this.isInitCard());
            }
        } else {
            boolean verifyResult = FaDataImportUtils.verifyBusiDataForLastestPeriod(ctx, card, this.getContextParameter(), this.isInitCard());
            if (verifyResult) {
                FaDataImportUtils.verifyForLastestPeriod(ctx, card, this.getContextParameter(), this.isInitCard());
            }
            this.cache.ISCHECKBUSSINESSDATA = verifyResult;
        }
        FaDataImportUtils.setDefaultDecimalData(this.DECIMAL_OBJS_NOT_IN_FILE, new BigDecimal("0"), (CoreBaseInfo)card, 0);
        FaDataImportUtils.setDefaultIntegerData(this.NUMBER_OBJS_NOT_IN_FILE, 0, (CoreBaseInfo)card);
        FaDataImportUtils.setDefaultStringData(this.STRING_OBJS_NOT_IN_FILE, null, (CoreBaseInfo)card);
        card.setBizDate(new Date());
        if (this.cache.DEPRECIATIONMODE.containsKey(this.getValue(data, "FFaDepreciationModeID"))) {
            card.setDeprMethod((FaDepreciationModeInfo)this.cache.DEPRECIATIONMODE.get(this.getValue(data, "FFaDepreciationModeID")));
        } else {
            FaDepreciationModeInfo _deprMode = faCardCache == null ? FaDataImportUtils.getDeprModeInfo(ctx, this.getBaseDataOql(this.getValue(data, "FFaDepreciationModeID"), true, false)) : faCardCache.getDeprModeInfo(ctx, this.getValue(data, "FFaDepreciationModeID"));
            card.setDeprMethod(_deprMode);
            this.cache.DEPRECIATIONMODE.put(this.getValue(data, "FFaDepreciationModeID"), _deprMode);
        }
        FaDepreciationModeInfo aFaDepreciationModeInfo = card.getDeprMethod();
        if (aFaDepreciationModeInfo != null) {
            if (FaUtils.isWorkLoadMethod((FaDepreciationModeInfo)aFaDepreciationModeInfo)) {
                card.setUseTermCount(card.getUseTermCount().setScale(2, 4));
                card.setDeprTermCount(card.getDeprTermCount().setScale(2, 4));
            } else {
                card.setUseTermCount(card.getUseTermCount().setScale(0, 4));
                card.setDeprTermCount(card.getDeprTermCount().setScale(0, 4));
            }
        }
        boolean isEvaledBefore = false;
        String initEvalValue = this.getValue(ctx, data, "FInitEvalValue", FaResUtil.getRes((String)"evaluateAmount", (Locale)locale), true);
        if (initEvalValue != null && initEvalValue.toString().trim().length() > 0) {
            FaDataImportUtils.setBigDecimalData(ctx, data, new String[]{"FInitEvalValue"}, new String[]{"initEvalValue"}, new String[]{FaResUtil.getRes((String)"evaluateAmount", (Locale)locale)}, (CoreBaseInfo)card, false, this.baseScale);
            isEvaledBefore = true;
        }
        card.setIsEvaledBefore(isEvaledBefore);
        if (!isEvaledBefore) {
            card.setInitEvalValue(card.getAssetValue());
            card.setEvalLeftPeriod(card.getUseTermCount());
            card.setAccuDeprAll(card.getAccuDepr());
        } else {
            String evalPeriodLeft = this.getValue(ctx, data, "FEvalPeriodLeft", FaResUtil.getRes((String)"evaluateSparePeriod", (Locale)locale), true);
            if (evalPeriodLeft == null || evalPeriodLeft.toString().trim().length() == 0) {
                card.setEvalLeftPeriod(card.getUseTermCount());
            } else {
                FaDataImportUtils.setBigDecimalData(ctx, data, new String[]{"FEvalPeriodLeft"}, new String[]{"evalLeftPeriod"}, new String[]{FaResUtil.getRes((String)"evaluateSparePeriod", (Locale)locale)}, (CoreBaseInfo)card, false, this.baseScale);
            }
            String accuDeprAll = this.getValue(ctx, data, "FAccuDeprAll", FaResUtil.getRes((String)"accuDeprAll", (Locale)locale), true);
            if (accuDeprAll == null || accuDeprAll.toString().trim().length() == 0) {
                card.setAccuDeprAll(card.getAccuDepr());
            } else {
                FaDataImportUtils.setBigDecimalData(ctx, data, new String[]{"FAccuDeprAll"}, new String[]{"accuDeprAll"}, new String[]{FaResUtil.getRes((String)"accuDeprAll", (Locale)locale)}, (CoreBaseInfo)card, false, this.baseScale);
            }
        }
        card.setLastEvalValue(card.getInitEvalValue());
        if (this.cache.FACAT.containsKey(this.getValue(data, "FFaCatID"))) {
            card.setAssetCat((FaCatInfo)this.cache.FACAT.get(this.getValue(data, "FFaCatID")));
        } else {
            FaCatInfo _facat = faCardCache == null ? FaDataImportUtils.getFaCatInfo(ctx, this.getCatOql(this.getValue(data, "FFaCatID"))) : faCardCache.getFaCatInfo(ctx, this.fi, this.getValue(data, "FFaCatID"));
            card.setAssetCat(_facat);
            this.cache.FACAT.put(this.getValue(data, "FFaCatID"), _facat);
        }
        if (this.cache.MEASUREUNIT.containsKey(this.getValue(data, "FMeasureUnitID"))) {
            card.setMeasureUnit((MeasureUnitInfo)this.cache.MEASUREUNIT.get(this.getValue(data, "FMeasureUnitID")));
        } else {
            MeasureUnitInfo _measureunit = faCardCache == null ? FaDataImportUtils.getMeasureUnitInfo(ctx, this.getBaseDataOql(this.getValue(data, "FMeasureUnitID"), false, false)) : faCardCache.getMeasureUnitInfo(ctx, this.getValue(data, "FMeasureUnitID"));
            card.setMeasureUnit(_measureunit);
            this.cache.MEASUREUNIT.put(this.getValue(data, "FMeasureUnitID"), _measureunit);
        }
        if (this.cache.ORIGINMETHOD.containsKey(this.getValue(data, "FOrigin"))) {
            card.setOriginMethod((FaAlterModeInfo)this.cache.ORIGINMETHOD.get(this.getValue(data, "FOrigin")));
        } else {
            FaAlterModeInfo _originmethod = faCardCache == null ? FaDataImportUtils.getFaAlterModeInfo(ctx, this.getOuIsolateOql(this.getValue(data, "FOrigin"), true, true)) : faCardCache.getFaAlterModeInfo(ctx, this.fi, this.getValue(data, "FOrigin"));
            card.setOriginMethod(_originmethod);
            this.cache.ORIGINMETHOD.put(this.getValue(data, "FOrigin"), _originmethod);
        }
        if (this.cache.USESTATUS.containsKey(this.getValue(data, "FFaUseStatusID"))) {
            card.setUseStatus((FaUseStatusInfo)this.cache.USESTATUS.get(this.getValue(data, "FFaUseStatusID")));
        } else {
            FaUseStatusInfo _usestatus = faCardCache == null ? FaDataImportUtils.getFaUseStatusInfo(ctx, this.getOuIsolateOql(this.getValue(data, "FFaUseStatusID"), true, true)) : faCardCache.getFaUseStatusInfo(ctx, this.fi, this.getValue(data, "FFaUseStatusID"));
            card.setUseStatus(_usestatus);
            this.cache.USESTATUS.put(this.getValue(data, "FFaUseStatusID"), _usestatus);
        }
        if (this.cache.ECONOMICPURP.containsKey(this.getValue(data, "FEconomyPurpose"))) {
            card.setEconomicPurp((FaEconomicPurpInfo)this.cache.ECONOMICPURP.get(this.getValue(data, "FEconomyPurpose")));
        } else {
            FaEconomicPurpInfo _economicpurp = faCardCache == null ? FaDataImportUtils.getFaEconomicPurpInfo(ctx, this.getOuIsolateOql(this.getValue(data, "FEconomyPurpose"), true, true)) : faCardCache.getFaEconomicPurpInfo(ctx, this.fi, this.getValue(data, "FEconomyPurpose"));
            card.setEconomicPurp(_economicpurp);
            this.cache.ECONOMICPURP.put(this.getValue(data, "FEconomyPurpose"), _economicpurp);
        }
        if (this.cache.ADDRESS.containsKey(this.getValue(data, "FStoreCityID"))) {
            card.setStoreCity((AddressInfo)this.cache.ADDRESS.get(this.getValue(data, "FStoreCityID")));
        } else {
            AddressInfo _address = faCardCache == null ? FaDataImportUtils.getAddressInfo(ctx, this.company.getCU().getId().toString(), this.getValue(data, "FStoreCityID")) : faCardCache.getAddressInfo(ctx, this.cu, this.getValue(data, "FStoreCityID"));
            card.setStoreCity(_address);
            this.cache.ADDRESS.put(this.getValue(data, "FStoreCityID"), _address);
        }
        if (this.cache.ADMINDEPT.containsKey(this.getValue(data, "FManageDepartmentID"))) {
            card.setDept((AdminOrgUnitInfo)this.cache.ADMINDEPT.get(this.getValue(data, "FManageDepartmentID")));
        } else {
            AdminOrgUnitInfo _admindept = FaDataImportUtils.getAdminOrgUnitInfo(ctx, this.cu, this.getValue(data, "FManageDepartmentID"), FaResUtil.getRes((String)"CUInfo", (Locale)locale));
            card.setDept(_admindept);
            this.cache.ADMINDEPT.put(this.getValue(data, "FManageDepartmentID"), _admindept);
        }
        if (this.cache.KEEPER.containsKey(this.getValue(data, "FKeeperID"))) {
            card.setKeeper((PersonInfo)this.cache.KEEPER.get(this.getValue(data, "FKeeperID")));
        } else {
            PersonInfo _keeper = FaDataImportUtils.getPersonInfo(ctx, this.cu, this.getValue(data, "FKeeperID"));
            card.setKeeper(_keeper);
            this.cache.KEEPER.put(this.getValue(data, "FKeeperID"), _keeper);
        }
        card.setCurrency(this.currency);
        if (this.cache.MEASUREUNIT.containsKey(this.getValue(data, "FLoadMeasureUnitID"))) {
            card.setMeasureUnitWL((MeasureUnitInfo)this.cache.MEASUREUNIT.get(this.getValue(data, "FLoadMeasureUnitID")));
        } else {
            MeasureUnitInfo _measureunitwl = faCardCache == null ? FaDataImportUtils.getWLMeasureUnitInfo(ctx, this.getBaseDataOql(this.getValue(data, "FLoadMeasureUnitID"), false, false)) : faCardCache.getWLMeasureUnitInfo(ctx, this.getValue(data, "FLoadMeasureUnitID"));
            card.setMeasureUnitWL(_measureunitwl);
            this.cache.MEASUREUNIT.put(this.getValue(data, "FLoadMeasureUnitID"), _measureunitwl);
        }
        if (this.cache.ACCOUNTVIEW.containsKey(this.getValue(data, "FAccountFixedAssetsID"))) {
            card.setAccountAsset((AccountViewInfo)this.cache.ACCOUNTVIEW.get(this.getValue(data, "FAccountFixedAssetsID")));
        } else {
            _acct = faCardCache == null ? FaDataImportUtils.getAcctViewInfo(ctx, this.company, this.getValue(data, "FAccountFixedAssetsID")) : faCardCache.getAcctViewInfo(ctx, this.company.getId().toString(), this.getValue(data, "FAccountFixedAssetsID"));
            card.setAccountAsset(_acct);
            this.cache.ACCOUNTVIEW.put(this.getValue(data, "FAccountFixedAssetsID"), _acct);
        }
        if (this.cache.ACCOUNTVIEW.containsKey(this.getValue(data, "FAccountDepreciationID"))) {
            card.setAccountAccuDepr((AccountViewInfo)this.cache.ACCOUNTVIEW.get(this.getValue(data, "FAccountDepreciationID")));
        } else {
            _acct = faCardCache == null ? FaDataImportUtils.getAcctViewInfo(ctx, this.company, this.getValue(data, "FAccountDepreciationID")) : faCardCache.getAcctViewInfo(ctx, this.company.getId().toString(), this.getValue(data, "FAccountDepreciationID"));
            card.setAccountAccuDepr(_acct);
            this.cache.ACCOUNTVIEW.put(this.getValue(data, "FAccountDepreciationID"), _acct);
        }
        if (this.cache.ACCOUNTVIEW.containsKey(this.getValue(data, "FAccountDecPrepareID"))) {
            card.setAccountDecValue((AccountViewInfo)this.cache.ACCOUNTVIEW.get(this.getValue(data, "FAccountDecPrepareID")));
        } else {
            _acct = faCardCache == null ? FaDataImportUtils.getAcctViewInfo(ctx, this.company, this.getValue(data, "FAccountDecPrepareID")) : faCardCache.getAcctViewInfo(ctx, this.company.getId().toString(), this.getValue(data, "FAccountDecPrepareID"));
            card.setAccountDecValue(_acct);
            this.cache.ACCOUNTVIEW.put(this.getValue(data, "FAccountDecPrepareID"), _acct);
        }
        card.setVoucher(null);
        card.setPeriod(null);
        card.setFaPeriod(null);
        UserInfo currentUser = ContextUtil.getCurrentUserInfo((Context)ctx);
        card.setHandler(currentUser);
        card.setAuditor(currentUser);
        boolean isDeduct = FaDataImportUtils.getBooleanValue(ctx, this.getValue(data, "FIsDeduct"));
        card.setIsDeduct(isDeduct);
        boolean isHasTax = FaDataImportUtils.getBooleanValue(ctx, this.getValue(data, "FIsHasTax"));
        card.setIsHasTax(isHasTax);
        this.setInitAmt(ctx, card);
        if (card.getDeprTermCount() == null) {
            card.setDeprTermCount(ZERO);
        }
        card.setIsOveraged(card.getUseTermCount().compareTo(card.getDeprTermCount()) <= 0);
        boolean isDeleted = FaDataImportUtils.getBooleanValue(ctx, this.getValue(data, "FHasDisabled"));
        card.setDeletedStatus(isDeleted ? DeletedStatusEnum.DELETED : DeletedStatusEnum.NORMAL);
        card.setHasDisabled(isDeleted);
        FaDataImportUtils.setDefaultBooleanData(this.BOOLEAN_OBJS, false, (CoreBaseInfo)card);
        card.setFiVouchered(true);
        card.setIsInitial(true);
        card.setHasEffected(true);
        boolean isOverride = this.isSltImportUpdate();
        if (!isOverride || card.getOriginFlag().getValue() != 4) {
            card.setOriginFlag(FaCardOriginEnum.INITIAL);
        }
        card.setBizStatus(FaBizStatusEnum.HAVE_ADDED);
        card.setCheckedStatus(CheckedStatusEnum.AUDITED);
        card.setEffectedStatus(EffectedStatusEnum.EFFECTED);
        card.setBlockedStatus(BlockedStatusEnum.UNBLOCKED);
        card.setIsInitChange(FaChangeStatusEnmu.HasNotChanged);
        FaFromUnitCatEnum catEnum = (FaFromUnitCatEnum)FaDataImportUtils.getEnumByName(ctx, FaFromUnitCatEnum.getEnumList(), this.getValue(data, this.ENUM_FIELDS[0]));
        if (catEnum == null) {
            card.setOriginType(FaFromUnitCatEnum.NULL);
            card.setOriginUnit(null);
        } else {
            card.setOriginType(catEnum);
        }
        if (!StringUtils.isEmpty((String)this.getValue(data, "FFromUnit"))) {
            FaFromUnitCatEnum originType = card.getOriginType();
            String number = this.getValue(data, "FFromUnit");
            String originUnitId = null;
            if (originType == FaFromUnitCatEnum.CUSTOMER) {
                if (this.cache.CUSTOMER.containsKey(number)) {
                    originUnitId = (String)this.cache.CUSTOMER.get(number);
                } else {
                    CustomerInfo customerInfo = FaDataImportUtils.getCustomerInfo(ctx, this.cu, number);
                    originUnitId = customerInfo == null ? null : customerInfo.getId().toString();
                    this.cache.CUSTOMER.put(number, originUnitId);
                }
            } else if (originType == FaFromUnitCatEnum.SUPPLIER) {
                if (this.cache.SUPPLIER.containsKey(number)) {
                    originUnitId = (String)this.cache.SUPPLIER.get(number);
                } else {
                    SupplierInfo supplierInfo = FaDataImportUtils.getSupplierInfo(ctx, this.getBaseDataOql(number, true, false));
                    UsedStatusEnum usedStatus = supplierInfo.getUsedStatus();
                    if (usedStatus != UsedStatusEnum.APPROVED) {
                        throw new TaskExternalException(MessageFormat.format(FaResUtil.getRes((String)"supplierUnapproved", (Locale)ctx.getOriginLocale()), supplierInfo.getName()));
                    }
                    originUnitId = supplierInfo == null ? null : supplierInfo.getId().toString();
                    this.cache.SUPPLIER.put(number, originUnitId);
                }
            } else if (originType == FaFromUnitCatEnum.INNER_COMPANY) {
                if (this.cache.COMPANY.containsKey(number)) {
                    originUnitId = (String)this.cache.COMPANY.get(number);
                } else {
                    CompanyOrgUnitInfo companyInfo = FaDataImportUtils.getCompanyOrgUnitInfo(ctx, this.getBaseDataOql(number, false, false));
                    originUnitId = companyInfo == null ? null : companyInfo.getId().toString();
                    this.cache.COMPANY.put(number, originUnitId);
                }
            }
            card.setOriginUnit(originUnitId);
        }
        if (card.getDeprMethod() != null && FaUtils.isStraightAccountMethod((FaDepreciationModeInfo)card.getDeprMethod())) {
            card.setMonthDepreRate(null);
            int depreScale = this.cache.PARAMS.get("FA_007") == null ? 4 : Integer.parseInt(this.cache.PARAMS.get("FA_007").toString());
            FaDataImportUtils.setBigDecimalData(ctx, data, new String[]{"FMonthRate"}, new String[]{"monthDepreRate"}, new String[]{FaResUtil.getRes((String)"monthDepreRate", (Locale)locale)}, (CoreBaseInfo)card, true, depreScale);
        }
        if ((isLastPeriod = (Boolean)this.getContextParameter("card_islastestperiod")) == null) {
            try {
                PeriodInfo[] periods = FaPeriodCloseFacadeFactory.getLocalInstance(ctx).getLastestPeriod(this.company.getId().toString());
                isLastPeriod = periods[0].getId().toString().equals(periods[1].getId().toString());
                this.getContextParameter().put("card_islastestperiod", isLastPeriod);
            }
            catch (Exception e) {
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
        }
        if (!isLastPeriod.booleanValue()) {
            card.setLastPeriodChange(true);
        }
        if (!StringUtils.isEmpty((String)(oldNumber = this.getValue(data, "FOldNumber")))) {
            card.setOldNumber(oldNumber);
        }
        card.setDescription("import");
        this.validate(ctx, card);
        return card;
    }

    private void setCardInfoOverrided(Context ctx, FaCardInfo card) throws TaskExternalException {
        block7: {
            boolean isOverride = this.isSltImportUpdate();
            String number = card.getNumber();
            if (number == null || number.length() == 0) {
                return;
            }
            boolean isInitCard = this.isInitCard();
            String companyId = this.cache.CURRENTCOMP.getId().toString();
            try {
                if (isInitCard) {
                    FaMonCardCollection cards = FaMonCardFactory.getLocalInstance(ctx).getFaMonCardCollection("select id,faCurCard.id,faMonFacility.*,faMonCostCenter.*,faMonInitData.*,faMonDepartment.* where number='" + number + "' and company.id='" + companyId + "' and faPeriod is null ");
                    if (cards.size() <= 0) break block7;
                    if (isOverride) {
                        FaMonCardInfo savedCard = cards.get(0);
                        card.setId(cards.get(0).getId());
                        card.put("faMonCostCenter", (Object)savedCard.getFaMonCostCenter());
                        card.put("faMonDepartment", (Object)savedCard.getFaMonDepartment());
                        card.put("faMonFacility", (Object)savedCard.getFaMonFacility());
                        card.put("faMonInitData", (Object)savedCard.getFaMonInitData());
                        ((FaMonCardInfo)card).setFaCurCard(savedCard.getFaCurCard());
                        break block7;
                    }
                    throw new TaskExternalException(FaResUtil.getRes((String)"evalInfo23", (Locale)ctx.getOriginLocale()));
                }
                FaCurCardCollection cards = FaCurCardFactory.getLocalInstance(ctx).getFaCurCardCollection("select id,effectedStatus, originFlag,faCurFacility.*,faCurCostCenter.*,faCurInitData.*,faCurDepartment.* where number='" + number + "' and company.id='" + companyId + "'");
                if (cards.size() <= 0) break block7;
                if (isOverride) {
                    FaCurCardInfo savedCard = cards.get(0);
                    if (savedCard.getEffectedStatus().getValue() != 1) {
                        throw new TaskExternalException(FaResUtil.getRes((String)"tempCardCanOverride", (Locale)ctx.getOriginLocale()));
                    }
                    card.setId(cards.get(0).getId());
                    card.put("faCurCostCenter", (Object)savedCard.getFaCurCostCenter());
                    card.put("faCurDepartment", (Object)savedCard.getFaCurDepartment());
                    card.put("faCurFacility", (Object)savedCard.getFaCurFacility());
                    card.put("faCurInitData", (Object)savedCard.getFaCurInitData());
                    card.setOriginFlag(savedCard.getOriginFlag());
                    break block7;
                }
                throw new TaskExternalException(FaResUtil.getRes((String)"evalInfo23", (Locale)ctx.getOriginLocale()));
            }
            catch (BOSException e) {
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
        }
    }

    protected void validate(Context ctx, FaCardInfo card) throws TaskExternalException {
        if (this.validator == null) {
            this.validator = new FaCardValidatorImpl(ctx, new FaMonCardInfo(), false);
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("Company", this.cache.CURRENTCOMP);
        params.put("isRelAccount", this.cache.ISRELACCOUNT);
        params.put("importCard", Boolean.TRUE);
        params.put("currentPeriod", this.cache.CURRENTPERIOD);
        this.validator.setParam(params);
        this.validator.setBillInfo(card);
        boolean result = this.validator.validate();
        if (!result) {
            throw new TaskExternalException(this.validator.getInvalidMsg());
        }
    }

    protected void verifyBeforeTran(Context ctx, boolean isImp) throws TaskExternalException {
        CompanyOrgUnitInfo _comp = this.company;
        if (_comp == null) {
            String strMsg = ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResource.Company_Null", (Locale)ctx.getOriginLocale());
            throw new TaskExternalException(strMsg);
        }
        if (!_comp.isIsBizUnit()) {
            String strMsg = ResourceBase.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource.vitualComNotAllowUseThisFun", (Locale)ctx.getOriginLocale());
            throw new TaskExternalException(strMsg);
        }
        if (this.isInitCard()) {
            boolean isstart = false;
            if (this.cache.ISSTART != null) {
                isstart = this.cache.ISSTART;
            } else {
                try {
                    isstart = SystemStatusCtrolUtils.isStart((Context)ctx, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)this.company);
                }
                catch (Exception e) {
                    throw new TaskExternalException(e.getMessage(), (Throwable)e);
                }
                this.cache.ISSTART = isstart;
            }
            if (isstart && isImp) {
                String errMsg = FaResUtil.getRes((String)"assetInitialization", (Locale)ctx.getOriginLocale());
                throw new TaskExternalException(errMsg);
            }
        }
    }

    private void assertNotNull(Object property, String msg) throws TaskExternalException {
        if (property == null) {
            throw new TaskExternalException(msg);
        }
        if (property instanceof String && property.toString().length() == 0) {
            throw new TaskExternalException(msg);
        }
    }

    private void setInitAmt(Context ctx, FaMonCardInfo card) throws TaskExternalException {
        BigDecimal chekInputTaxRate;
        BigDecimal chekOriginAmt = card.getOriginAmt() == null ? new BigDecimal("0") : card.getOriginAmt();
        BigDecimal chekTaxOriginAmt = card.getTaxOriginAmt() == null ? new BigDecimal("0") : card.getTaxOriginAmt();
        BigDecimal chekInputTax = card.getInputTax() == null ? new BigDecimal("0") : card.getInputTax();
        BigDecimal bigDecimal = chekInputTaxRate = card.getInputTaxRate() == null ? new BigDecimal("0") : card.getInputTaxRate();
        if (chekOriginAmt.compareTo(chekTaxOriginAmt.add(chekInputTax)) != 0) {
            throw new TaskExternalException(MessageFormat.format(FaResUtil.getRes((String)"taxOriginIsNot", (Locale)ctx.getOriginLocale()), chekTaxOriginAmt.add(chekInputTax), chekOriginAmt));
        }
        BigDecimal inputTax = ZERO;
        BigDecimal inputTaxRate = ZERO;
        if (chekTaxOriginAmt.compareTo(ZERO) != 0) {
            inputTax = chekTaxOriginAmt.multiply(chekInputTaxRate).divide(new BigDecimal(100));
            inputTaxRate = chekInputTax.multiply(new BigDecimal(100)).divide(chekTaxOriginAmt, 2, 4);
        }
        if ((chekInputTax = chekInputTax.setScale(this.baseScale, 4)).compareTo(inputTax = inputTax.setScale(this.baseScale, 4)) != 0 && chekInputTaxRate.compareTo(inputTaxRate) != 0) {
            throw new TaskExternalException(FaResUtil.getRes((String)"inputTaxRateIsNot", (Locale)ctx.getOriginLocale()));
        }
        BigDecimal addons = card.getAddons() == null ? new BigDecimal("0") : card.getAddons();
        BigDecimal originAmt = ZERO;
        if (card.getCurrency().getId().equals((Object)card.getCompany().getBaseCurrency().getId())) {
            originAmt = card.isIsDeduct() ? card.getTaxOriginAmt().multiply(new BigDecimal("1")).add(card.getAddonFare()).add(addons) : card.getOriginAmt().multiply(new BigDecimal("1")).add(card.getAddonFare()).add(addons);
        } else {
            ExchangeAuxInfo exChangeAuxinfo = null;
            try {
                IExchangeAux iExchangeAux = ExchangeAuxFactory.getLocalInstance((Context)ctx);
                exChangeAuxinfo = (ExchangeAuxInfo)iExchangeAux.getValue("where sourceCurrency.id = '" + card.getCurrency().getId() + "' and targetCurrency.id = '" + card.getCompany().getBaseCurrency().getId() + "' and exchangeTable.id = '" + card.getCompany().getBaseExchangeTable().getId() + "'");
                originAmt = exChangeAuxinfo.getConvertMode().getValue() == 0 ? (card.isIsDeduct() ? card.getTaxOriginAmt().multiply(card.getExRate()).add(card.getAddonFare()).add(addons) : card.getOriginAmt().multiply(card.getExRate()).add(card.getAddonFare()).add(addons)) : (card.isIsDeduct() ? card.getTaxOriginAmt().divide(card.getExRate(), RoundingMode.HALF_UP).add(card.getAddonFare()).add(addons) : card.getOriginAmt().divide(card.getExRate(), RoundingMode.HALF_UP).add(card.getAddonFare()).add(addons));
            }
            catch (Exception e) {
                logger.error((Object)e);
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
        }
        originAmt = originAmt.setScale(this.baseScale, 4);
        Locale locale = ctx.getOriginLocale();
        if (originAmt.compareTo(card.getAssetValue()) != 0) {
            throw new TaskExternalException(MessageFormat.format(FaResUtil.getRes((String)"assetOriginIsNot", (Locale)locale), originAmt, card.getAssetValue()));
        }
        card.setAssetValue(originAmt);
        if (card.getAssetCat() == null) {
            throw new TaskExternalException(FaResUtil.getRes((String)"assetCatCanNotNull", (Locale)locale));
        }
        boolean isCalcuByEvaluate = card.getAssetCat().isCalcuByEvaluate();
        BigDecimal neatValue = ZERO;
        neatValue = isCalcuByEvaluate ? card.getInitEvalValue().subtract(card.getAccuDepr()) : card.getAssetValue().subtract(card.getAccuDepr());
        if ((neatValue = neatValue.setScale(this.baseScale, 4)).compareTo(card.getNeatValue()) != 0) {
            throw new TaskExternalException(MessageFormat.format(FaResUtil.getRes((String)"assetNetValueIsNot", (Locale)locale), neatValue, card.getNeatValue()));
        }
        card.setNeatValue(neatValue);
        BigDecimal neatAmt = card.getNeatValue().subtract(card.getDecValue());
        neatAmt = neatAmt.setScale(this.baseScale, 4);
        if (neatAmt.compareTo(card.getNeatAmt()) != 0) {
            throw new TaskExternalException(MessageFormat.format(FaResUtil.getRes((String)"assetNetAmountIsNot", (Locale)locale), neatAmt, card.getNeatAmt()));
        }
        card.setNeatAmt(neatAmt);
        card.setAccuDeprChgTYear(card.getAccuDeprTYear());
    }

    private String getBaseDataOql(String number, boolean getAll, boolean isCuIsoluate) {
        if (StringUtils.isEmpty((String)number)) {
            return null;
        }
        if (getAll) {
            if (isCuIsoluate) {
                return "WHERE NUMBER = '" + number + "' AND CU.id = '" + this.cu + "'";
            }
            return "WHERE NUMBER = '" + number + "'";
        }
        if (isCuIsoluate) {
            return "SELECT ID WHERE NUMBER = '" + number + "' AND CU.id = '" + this.cu + "'";
        }
        return "SELECT ID WHERE NUMBER = '" + number + "'";
    }

    private String getOuIsolateOql(String number, boolean getAll, boolean isOuIsoluate) {
        if (StringUtils.isEmpty((String)number)) {
            return null;
        }
        if (getAll) {
            if (isOuIsoluate) {
                return "WHERE NUMBER = '" + number + "' AND company.id = '" + this.fi + "'";
            }
            return "WHERE NUMBER = '" + number + "'";
        }
        if (isOuIsoluate) {
            return "SELECT ID WHERE NUMBER = '" + number + "' AND company.id = '" + this.fi + "'";
        }
        return "SELECT ID WHERE NUMBER = '" + number + "'";
    }

    private String getCatOql(String number) {
        if (StringUtils.isEmpty((String)number)) {
            return null;
        }
        return "SELECT *,DepreciationPolicy.DeprRule WHERE NUMBER = '" + number + "' AND company.id = '" + this.fi + "'";
    }

    private String getValue(Map data, String fieldName) {
        if (data.get(fieldName) == null) {
            return null;
        }
        Object obj = ((DataToken)data.get((Object)fieldName)).data;
        return obj == null ? null : obj.toString();
    }

    private String getValue(Context ctx, Map data, String fieldName, String fieldCHN, boolean supportNull) throws TaskExternalException {
        String result = this.getValue(data, fieldName);
        if (StringUtils.isEmpty((String)result) && !supportNull) {
            throw new TaskExternalException(MessageFormat.format(FaResUtil.getRes((String)"columnCanNotNull", (Locale)ctx.getOriginLocale()), fieldCHN));
        }
        return result;
    }

    private void initScale(Context ctx) throws EASBizException, BOSException {
        HashMap hmParam = this.cache.PARAMS;
        if (hmParam == null) {
            this.cache.PARAMS = hmParam = FaCardCache.getFAParameter(this.company.getBOSUuid("id"), ctx);
        }
        if (this.cache.QUANTITYSCALE != null) {
            this.quantityScale = this.cache.QUANTITYSCALE;
        } else {
            String quantity = (String)hmParam.get("FA_008");
            this.quantityScale = quantity != null && quantity.trim().length() > 0 ? Integer.parseInt((String)hmParam.get("FA_008")) : 2;
            this.cache.QUANTITYSCALE = new Integer(this.quantityScale);
        }
        this.originScale = this.currency.getPrecision();
        this.baseScale = this.baseCurrency.getPrecision();
        if (this.cache.EXCHANGERATE.containsKey(this.currency.getId().toString())) {
            this.rateScale = (Integer)this.cache.EXCHANGERATE.get(this.currency.getId().toString());
        } else if (this.company.getBaseExchangeTable() != null) {
            if (this.cache.CURRENTPERIOD != null) {
                this.currenctPeriod = this.cache.CURRENTPERIOD;
            } else {
                this.cache.CURRENTPERIOD = this.currenctPeriod = FaLocalUtils.getCurrentPeriod(ctx, this.company.getId().toString());
            }
            IExchangeRate iExchangeRate = ExchangeRateFactory.getLocalInstance((Context)ctx);
            ExchangeRateInfo exchangeRateInfo = iExchangeRate.getExchangeRate((IObjectPK)new ObjectUuidPK(this.company.getBaseExchangeTable().getId()), (IObjectPK)new ObjectUuidPK(this.currency.getId()), (IObjectPK)new ObjectUuidPK(this.baseCurrency.getId()), (Date)this.cache.CURRENTPERIOD.getEndDate());
            if (exchangeRateInfo != null) {
                this.rateScale = exchangeRateInfo.getPrecision();
            }
            this.cache.EXCHANGERATE.put(this.currency.getId().toString(), new Integer(this.rateScale));
        }
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        HashMap<String, Boolean> columnsMap = new HashMap<String, Boolean>();
        try {
            IRowSetMetaData md = rs.getRowSetMetaData();
            int columnsCount = md.getColumnCount();
            for (int i = 1; i <= columnsCount; ++i) {
                columnsMap.put(md.getColumnName(i), Boolean.TRUE);
            }
        }
        catch (Exception e1) {
            logger.error((Object)e1);
        }
        try {
            String deprModeNumber;
            BigDecimal FWrtyPeriod;
            String number;
            if (this.workloadSchemes == null) {
                this.workloadSchemes = FaUtils.getUserDepreciationMode((Context)ctx, (boolean)true);
            }
            if (this.cacheMap.containsKey(number = ContextUtil.getCurrentFIUnit((Context)ctx).getNumber())) {
                this.cache = this.cacheMap.get(number);
            } else {
                this.cache = new QueryObjCacheInfo();
                this.cacheMap.put(number, this.cache);
            }
            if (this.cache.CURRENTCOMP != null) {
                this.company = this.cache.CURRENTCOMP;
            } else {
                this.cache.CURRENTCOMP = this.company = ContextUtil.getCurrentFIUnit((Context)ctx);
            }
            this.verifyBeforeTran(ctx, false);
            String compId = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
            this.baseCurrency = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo("SELECT * , baseCurrency.* WHERE id ='" + compId + "'").getBaseCurrency();
            this.currency = (CurrencyInfo)CurrencyFactory.getLocalInstance((Context)ctx).getValue("where number = '" + rs.getString("currency.number") + "'");
            this.initScale(ctx);
            HashMap<String, Integer> precisions = new HashMap<String, Integer>();
            precisions.put("baseScale", new Integer(this.baseScale));
            precisions.put("originScale", new Integer(this.originScale));
            precisions.put("quantityScale", new Integer(this.quantityScale));
            precisions.put("rateScale", new Integer(this.rateScale));
            int depreScale = this.cache.PARAMS.get("FA_007") == null ? 4 : Integer.parseInt(this.cache.PARAMS.get("FA_007").toString());
            precisions.put("depreScale", new Integer(depreScale));
            Hashtable result = null;
            result = this.isInitCard() ? FaDataImportUtils.setDataForExport(Arrays.copyOfRange(this.EXP_FIELD_IN_FILE, 1, this.EXP_FIELD_IN_FILE.length), Arrays.copyOfRange(this.EXP_FIELD_IN_QUERY, 1, this.EXP_FIELD_IN_QUERY.length), rs, precisions) : FaDataImportUtils.setDataForExport(this.EXP_FIELD_IN_FILE, this.EXP_FIELD_IN_QUERY, rs, precisions);
            if (columnsMap.get("wrtyPeriod") != null && (FWrtyPeriod = rs.getBigDecimal("wrtyPeriod")) != null) {
                result.put("FWrtyPeriod", FWrtyPeriod.toBigInteger());
            }
            if (result.get("FFromType") != null) {
                int fromUnit = Integer.parseInt(result.get("FFromType").toString());
                result.put("FFromType", FaFromUnitCatEnum.getEnum(fromUnit).getAlias());
                String originUnit = (String)result.get("FFromUnit");
                if (originUnit != null && originUnit.trim().length() > 0) {
                    String queryOql = "select number where id = '" + originUnit + "'";
                    if (fromUnit == 1) {
                        if (this.cache.CUSTOMER.containsKey(originUnit)) {
                            result.put("FFromUnit", this.cache.CUSTOMER.get(originUnit));
                        } else {
                            CustomerInfo customerInfo = FaDataImportUtils.getCustomerInfo(ctx, queryOql);
                            result.put("FFromUnit", customerInfo.getNumber());
                            this.cache.CUSTOMER.put(originUnit, customerInfo.getNumber());
                        }
                    } else if (fromUnit == 0) {
                        if (this.cache.SUPPLIER.containsKey(originUnit)) {
                            result.put("FFromUnit", this.cache.SUPPLIER.get(originUnit));
                        } else {
                            SupplierInfo supplierInfo = FaDataImportUtils.getSupplierInfo(ctx, queryOql);
                            result.put("FFromUnit", supplierInfo.getNumber());
                            this.cache.SUPPLIER.put(originUnit, supplierInfo.getNumber());
                        }
                    } else if (fromUnit == 2) {
                        if (this.cache.COMPANY.containsKey(originUnit)) {
                            result.put("FFromUnit", this.cache.COMPANY.get(originUnit));
                        } else {
                            CompanyOrgUnitInfo companyInfo = FaDataImportUtils.getCompanyOrgUnitInfo(ctx, queryOql);
                            result.put("FFromUnit", companyInfo.getNumber());
                            this.cache.COMPANY.put(originUnit, companyInfo.getNumber());
                        }
                    }
                }
            }
            if (result.get("FHasDisabled") != null) {
                int hasDeleted = Integer.parseInt(result.get("FHasDisabled").toString());
                if (hasDeleted == 1) {
                    result.put("FHasDisabled", EASResource.getString((String)"com.kingdee.eas.fi.fa.basedata.FaResource.NG"));
                } else {
                    result.put("FHasDisabled", EASResource.getString((String)"com.kingdee.eas.fi.fa.basedata.FaResource.YES"));
                }
            }
            if (result.get("FIsDeduct") != null) {
                String isDeduct = result.get("FIsDeduct").toString();
                if (isDeduct.equals("true")) {
                    result.put("FIsDeduct", EASResource.getString((String)"com.kingdee.eas.fi.fa.basedata.FaResource.YES"));
                } else {
                    result.put("FIsDeduct", EASResource.getString((String)"com.kingdee.eas.fi.fa.basedata.FaResource.NG"));
                }
            }
            if (result.get("FIsHasTax") != null) {
                String isHasTax = result.get("FIsHasTax").toString();
                if (isHasTax.equals("true")) {
                    result.put("FIsHasTax", EASResource.getString((String)"com.kingdee.eas.fi.fa.basedata.FaResource.YES"));
                } else {
                    result.put("FIsHasTax", EASResource.getString((String)"com.kingdee.eas.fi.fa.basedata.FaResource.NG"));
                }
            }
            String string = deprModeNumber = result.get("FFaDepreciationModeID") == null ? null : result.get("FFaDepreciationModeID").toString();
            if (deprModeNumber != null && !deprModeNumber.equals("002") && !this.workloadSchemes.containsKey(deprModeNumber)) {
                if (result.get("FDepPeriod") != null) {
                    result.put("FDepPeriod", rs.getBigDecimal("deprTermCount").setScale(0, 4).toString());
                }
                if (result.get("FExpUsePeriod") != null) {
                    result.put("FExpUsePeriod", rs.getBigDecimal("useTermCount").setScale(0, 4).toString());
                }
                if (result.get("FEvalPeriodLeft") != null) {
                    result.put("FEvalPeriodLeft", rs.getBigDecimal("evalLeftPeriod").setScale(0, 4).toString());
                }
            }
            if (!rs.getBoolean("isEvaledBefore")) {
                result.remove("FInitEvalValue");
            }
            return result;
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        return FaDataImportUtils.getFilterForExp(ctx, super.getExportFilterForQuery(ctx), true);
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.fi.fa.manage.FaMonCardExpQuery";
    }

    protected boolean isInitCard() {
        return true;
    }

    public static int getPeriodNumOfYear(Context ctx, PeriodInfo period) throws BOSException {
        int periodYear = period.getPeriodYear();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodYear", (Object)new Integer(periodYear), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)period.getPeriodType().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isAdjustPeriod", (Object)"0", CompareType.EQUALS));
        filter.setMaskString("#0 and #1 and #2");
        evi.setFilter(filter);
        PeriodCollection periodc = null;
        IPeriod iPeriod = PeriodFactory.getLocalInstance((Context)ctx);
        periodc = iPeriod.getPeriodCollection(evi);
        if (periodc == null) {
            return 12;
        }
        int periodCount = periodc.size();
        return periodCount;
    }

    protected HashMap gethmParam(Context ctx) throws BOSException, EASBizException {
        if (this.hmParam == null || this.hmParam.size() == 0) {
            this.hmParam = FaCardCache.getFAParameter(this.company.getId(), ctx);
        }
        return this.hmParam;
    }

    @Override
    protected int importData(Context ctx, AbstractFaBatchDataRunner runner, DatataskParameter param, RecordCollection coll, int beginIndex) throws Exception {
        runner.progress(param.alias + ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"162_FaMonCardDataImport", (Locale)ctx.getLocale()) + (beginIndex + 1) + "->" + (beginIndex + coll.size()));
        HashSet<String> dmNumbers = new HashSet<String>();
        HashSet<String> acNumbers = new HashSet<String>();
        HashSet<String> muNumbers = new HashSet<String>();
        HashSet<String> originNumbers = new HashSet<String>();
        HashSet<String> useStatusNumbers = new HashSet<String>();
        HashSet<String> epNumbers = new HashSet<String>();
        HashSet<String> scNumbers = new HashSet<String>();
        HashSet<String> avNumbers = new HashSet<String>();
        for (int i = 0; i < coll.size(); ++i) {
            IRecord record = coll.get(i);
            Map data = record.getMap();
            String number = this.getValue(data, "FFaDepreciationModeID");
            if (number != null && number.length() > 0) {
                dmNumbers.add(number);
            }
            if ((number = this.getValue(data, "FFaCatID")) != null && number.length() > 0) {
                acNumbers.add(number);
            }
            if ((number = this.getValue(data, "FMeasureUnitID")) != null && number.length() > 0) {
                muNumbers.add(number);
            }
            if ((number = this.getValue(data, "FOrigin")) != null && number.length() > 0) {
                originNumbers.add(number);
            }
            if ((number = this.getValue(data, "FFaUseStatusID")) != null && number.length() > 0) {
                useStatusNumbers.add(number);
            }
            if ((number = this.getValue(data, "FEconomyPurpose")) != null && number.length() > 0) {
                epNumbers.add(number);
            }
            if ((number = this.getValue(data, "FStoreCityID")) != null && number.length() > 0) {
                scNumbers.add(number);
            }
            if ((number = this.getValue(data, "FLoadMeasureUnitID")) != null && number.length() > 0) {
                muNumbers.add(number);
            }
            if ((number = this.getValue(data, "FAccountFixedAssetsID")) != null && number.length() > 0) {
                avNumbers.add(number);
            }
            if ((number = this.getValue(data, "FAccountDepreciationID")) != null && number.length() > 0) {
                avNumbers.add(number);
            }
            if ((number = this.getValue(data, "FAccountDecPrepareID")) == null || number.length() <= 0) continue;
            avNumbers.add(number);
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        String companyId = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        params.put("companyId", companyId);
        String cuId = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        params.put("cuId", cuId);
        FaCardCache.getCache().cacheInfos(ctx, "deprModes", null, dmNumbers, params);
        FaCardCache.getCache().cacheInfos(ctx, "assetCats", companyId, acNumbers, params);
        FaCardCache.getCache().cacheInfos(ctx, "measureUnits", null, muNumbers, params);
        FaCardCache.getCache().cacheInfos(ctx, "origins", companyId, originNumbers, params);
        FaCardCache.getCache().cacheInfos(ctx, "usestatuses", companyId, useStatusNumbers, params);
        FaCardCache.getCache().cacheInfos(ctx, "economyPurposes", companyId, epNumbers, params);
        cuId = ContextUtil.getCurrentFIUnit((Context)ctx).getCU().getId().toString();
        params.put("cuId", cuId);
        FaCardCache.getCache().cacheInfos(ctx, "storeCitys", cuId, scNumbers, params);
        AccountTools.checkCompanyAccountTable((Context)ctx, (CompanyOrgUnitInfo)ContextUtil.getCurrentFIUnit((Context)ctx));
        String tableId = ContextUtil.getCurrentFIUnit((Context)ctx).getAccountTable().getId().toString();
        params.put("tableId", tableId);
        FaCardCache.getCache().cacheInfos(ctx, "accounts", companyId, avNumbers, params);
        return super.importData(ctx, runner, param, coll, beginIndex);
    }

    class QueryObjCacheInfo {
        public HashMap CURRENCY = new HashMap();
        public Boolean ISRELACCOUNT = null;
        public Integer QUANTITYSCALE = null;
        public HashMap EXCHANGERATE = new HashMap();
        public HashMap DEPRECIATIONMODE = new HashMap();
        public HashMap FACAT = new HashMap();
        public HashMap MEASUREUNIT = new HashMap();
        public HashMap ORIGINMETHOD = new HashMap();
        public HashMap USESTATUS = new HashMap();
        public HashMap ECONOMICPURP = new HashMap();
        public HashMap ADDRESS = new HashMap();
        public HashMap ADMINDEPT = new HashMap();
        public HashMap KEEPER = new HashMap();
        public HashMap ACCOUNTVIEW = new HashMap();
        public HashMap CUSTOMER = new HashMap();
        public HashMap SUPPLIER = new HashMap();
        public HashMap COMPANY = new HashMap();
        public HashMap PARAMS = null;
        public PeriodInfo CURRENTPERIOD = null;
        public CompanyOrgUnitInfo CURRENTCOMP = null;
        public Boolean ISSTART = null;
        public Integer PERIODCOUNT = null;
        public Boolean ISCHECKBUSSINESSDATA = null;

        QueryObjCacheInfo() {
        }
    }
}

