/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app.depreciationbatch.validate.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.ormapping.IORMappingDAO;
import com.kingdee.bos.dao.ormapping.ORMappingDAO;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.FaDepreciationCollection;
import com.kingdee.eas.fi.fa.manage.FaDepreciationInfo;
import com.kingdee.eas.fi.fa.manage.FaManageUtils;
import com.kingdee.eas.fi.fa.manage.app.depreciationbatch.validate.abs.AbstractDepreciationBatchValidateBase;
import com.kingdee.eas.fi.fa.manage.app.depreciationbatch.validate.vo.DepreciationBatchValidateCheckParam;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;

public class FaDepCalDepErrAudit
extends AbstractDepreciationBatchValidateBase {
    @Override
    protected void validateHandle(Context ctx, DepreciationBatchValidateCheckParam depreciationBatchValidateCheckParam) throws BOSException, EASBizException {
        String canUnAudit;
        String currCompanyId = depreciationBatchValidateCheckParam.getCompany().getId().toString();
        HashMap hm = FaManageUtils.getFAParameter(ctx, new String[]{"FA_010"}, currCompanyId);
        String string = canUnAudit = hm.get("FA_010") != null ? (String)hm.get("FA_010") : null;
        if (canUnAudit != null && Boolean.valueOf(canUnAudit).booleanValue()) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            FaDepreciationInfo depInfo = this.getDepreciationInfo(ctx, sic, depreciationBatchValidateCheckParam.getCompany());
            if (depInfo != null && this.queryNoAudit(ctx, depInfo.getId().toString(), this.getCurrentPeriod(ctx).getId().toString(), currCompanyId) < 1) {
                throw new EASBizException(new NumericExceptionSubItem("1", FaDepCalDepErrAudit.getResource(ctx, "com.kingdee.eas.fi.fa.manage.FaDepreciationResource", "FaDepCal_depErr_audit")));
            }
        }
    }

    @Override
    protected String setNoteUrl() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FaDepreciationInfo getDepreciationInfo(Context ctx, SelectorItemCollection sic, CompanyOrgUnitInfo currCompany) throws BOSException, EASBizException {
        EntityViewInfo entityView = new EntityViewInfo();
        entityView.getSelector().addObjectCollection((IObjectCollection)sic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("period", (Object)this.getCurrentPeriod(ctx, currCompany.getId().toString()).getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("company", (Object)currCompany.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("depType", (Object)new Integer(0), CompareType.EQUALS));
        entityView.setFilter(filter);
        Connection cn = null;
        try {
            try {
                cn = EJBFactory.getConnection((Context)ctx);
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new BOSException("EJBFactory.getConnection : " + e);
            }
            FaDepreciationCollection c = (FaDepreciationCollection)this.getDAO(ctx, cn).getCollectionNoChild(entityView);
            if (c.size() < 1) {
                FaDepreciationInfo faDepreciationInfo = null;
                return faDepreciationInfo;
            }
            FaDepreciationInfo faDepreciationInfo = c.get(0);
            return faDepreciationInfo;
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
    }

    public int queryNoAudit(Context ctx, String depID, String periodID, String companyID) throws EASBizException, BOSException {
        int result = 0;
        StringBuffer sql = new StringBuffer();
        try {
            IRowSet rowSet;
            if (depID != null) {
                sql.append("SELECT count(ffacurcardid) AS COUNT \n");
                sql.append("  FROM t_fa_fadepreciationentry \n");
                sql.append(" WHERE fstate <> 3 AND flnkfadepreentry = ? \n");
                Object[] sqlPara = new Object[]{depID};
                rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])sqlPara);
                if (rowSet.next()) {
                    result = rowSet.getInt("COUNT");
                }
            }
            if (result < 1) {
                sql = new StringBuffer();
                sql.append("SELECT count(e.ffacurcardid) AS COUNT \n");
                sql.append("  FROM t_fa_faevaldepreciationentry e inner join t_fa_faevaldepreciation b on b.fid=e.flnkfadepreentry\n");
                sql.append(" WHERE e.fstate <> 3 AND b.fperiod = ? and b.fcompanyid=?\n");
                rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{periodID, companyID});
                if (rowSet.next()) {
                    result = rowSet.getInt("COUNT");
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    public IORMappingDAO getDAO(Context ctx, Connection cn) throws BOSException {
        return ORMappingDAO.getInstance((BOSObjectType)BOSObjectType.create((String)"FD47C291"), (Context)ctx, (Connection)cn);
    }
}

