/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app.falog.listener.strategy;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.FaAppLogFactory;
import com.kingdee.eas.fi.fa.manage.FaAppLogInfo;
import com.kingdee.eas.fi.fa.manage.app.falog.event.FaEventTypeEnum;
import com.kingdee.eas.fi.fa.manage.app.falog.event.FaRPCMethodEvent;
import com.kingdee.eas.fi.fa.manage.app.falog.listener.AbstractFaRPCMethodListener;
import com.kingdee.eas.fi.fa.manage.app.falog.listener.annotation.FaListenerEventType;
import java.util.HashMap;
import org.apache.log4j.Logger;

@FaListenerEventType(value=FaEventTypeEnum.FA_APP_LOG)
public class FaAppLogRPCMethodListener
extends AbstractFaRPCMethodListener<FaAppLogInfo> {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.fa.manage.app.falog.listener.strategy.FaAppLogRPCMethodListener");
    private static final ThreadLocal<HashMap<String, String>> faAppLogIdThreadLocal = new ThreadLocal();

    @Override
    public void invokeMethodCalcBefore(FaRPCMethodEvent<FaAppLogInfo> faRPCMethodEvent) throws BOSException, EASBizException {
        FaAppLogInfo faAppLogInfo = faRPCMethodEvent.getDetailMessage();
        HashMap<String, FaAppLogInfo> params = new HashMap<String, FaAppLogInfo>();
        params.put("faAppLogInfo", faAppLogInfo);
        FaAppLogFactory.getLocalInstance(faRPCMethodEvent.getContext()).requiresNewMethod("FaAppLogFactory.addnew", params);
        if (faAppLogIdThreadLocal.get() != null) {
            HashMap<String, String> hashMap = faAppLogIdThreadLocal.get();
            hashMap.put(faAppLogInfo.getOperationPK(), faAppLogInfo.getId().toString());
        } else {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put(faAppLogInfo.getOperationPK(), faAppLogInfo.getId().toString());
            faAppLogIdThreadLocal.set(hashMap);
        }
    }

    @Override
    public void invokeMethodCalcAfter(FaRPCMethodEvent<FaAppLogInfo> faRPCMethodEvent) throws BOSException, EASBizException {
        HashMap<String, String> hashMap = faAppLogIdThreadLocal.get();
        FaAppLogInfo faAppLogInfo = faRPCMethodEvent.getDetailMessage();
        faAppLogInfo.setId(BOSUuid.read((String)hashMap.get(faAppLogInfo.getOperationPK())));
        faAppLogInfo.setIsSuccessed(true);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("threadActiveCountAfter");
        sic.add("methodTimeAfter");
        sic.add("isSuccessed");
        sic.add("instanceID");
        HashMap<String, FaAppLogInfo> params = new HashMap<String, FaAppLogInfo>();
        params.put("faAppLogInfo", faAppLogInfo);
        params.put("sic", (FaAppLogInfo)sic);
        FaAppLogFactory.getLocalInstance(faRPCMethodEvent.getContext()).requiresNewMethod("FaAppLogFactory.updatePartial", params);
        hashMap.remove(faAppLogInfo.getOperationPK());
    }
}

