/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app.falog.listener.strategy;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.FaAppLogFactory;
import com.kingdee.eas.fi.fa.manage.FaDataChangeLogForDataChangeRecordTypeEnum;
import com.kingdee.eas.fi.fa.manage.FaDataChangeLogForDataChangeTypeEnum;
import com.kingdee.eas.fi.fa.manage.FaDataChangeLogInfo;
import com.kingdee.eas.fi.fa.manage.app.falog.event.FaEventTypeEnum;
import com.kingdee.eas.fi.fa.manage.app.falog.event.FaRPCMethodEvent;
import com.kingdee.eas.fi.fa.manage.app.falog.listener.AbstractFaRPCMethodListener;
import com.kingdee.eas.fi.fa.manage.app.falog.listener.annotation.FaListenerEventType;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.HashMap;
import org.apache.log4j.Logger;

@FaListenerEventType(value=FaEventTypeEnum.FA_MONTHLY_SETTLEMENT_LOSS)
public class FaLogForMonthlySettlementLoss
extends AbstractFaRPCMethodListener<FaDataChangeLogInfo> {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.fa.manage.app.falog.listener.strategy.FaLogForMonthlySettlementLoss");
    private static final ThreadLocal<HashMap<String, String>> FaMonthlySettlementLossTempTableNameThreadLocal = new ThreadLocal();
    private static final ThreadLocal<HashMap<String, FaRPCMethodEvent<FaDataChangeLogInfo>>> faRPCMethodEventThreadLocal = new ThreadLocal();

    @Override
    public void invokeMethodCalcBefore(FaRPCMethodEvent<FaDataChangeLogInfo> faRPCMethodEvent) throws BOSException, EASBizException {
        block7: {
            try {
                PeriodInfo faCurPeriodInfo = faRPCMethodEvent.getFaCurPeriodInfo();
                CompanyOrgUnitInfo faCurCompany = faRPCMethodEvent.getFaCurCompany();
                String tempTableName = this.createTempTable(faRPCMethodEvent.getContext());
                StringBuilder calcSQL = new StringBuilder();
                calcSQL.append(" INSERT INTO " + tempTableName + " \n");
                calcSQL.append(" SELECT FFACURCARDID FROM t_fa_famoncard \n");
                calcSQL.append(" where FFAPERIODID = ? and FCOMPANYID = ? \n");
                Object[] calcParams = new Object[]{faCurPeriodInfo.getId().toString(), faCurCompany.getId().toString()};
                DbUtil.execute((Context)faRPCMethodEvent.getContext(), (String)calcSQL.toString(), (Object[])calcParams);
                if (FaMonthlySettlementLossTempTableNameThreadLocal.get() != null) {
                    HashMap<String, String> hashMap = FaMonthlySettlementLossTempTableNameThreadLocal.get();
                    hashMap.put(faRPCMethodEvent.getSvcCtx().getOperationPK().toString(), tempTableName);
                } else {
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put(faRPCMethodEvent.getSvcCtx().getOperationPK().toString(), tempTableName);
                    FaMonthlySettlementLossTempTableNameThreadLocal.set(hashMap);
                }
                if (faRPCMethodEventThreadLocal.get() != null) {
                    HashMap<String, FaRPCMethodEvent<FaDataChangeLogInfo>> hashMapID = faRPCMethodEventThreadLocal.get();
                    hashMapID.put(faRPCMethodEvent.getSvcCtx().getOperationPK().toString(), faRPCMethodEvent);
                } else {
                    HashMap<String, FaRPCMethodEvent<FaDataChangeLogInfo>> hashMapID = new HashMap<String, FaRPCMethodEvent<FaDataChangeLogInfo>>();
                    hashMapID.put(faRPCMethodEvent.getSvcCtx().getOperationPK().toString(), faRPCMethodEvent);
                    faRPCMethodEventThreadLocal.set(hashMapID);
                }
            }
            catch (Exception e) {
                logger.error((Object)("FaLogForMonthlySettlementLoss Before Exception:" + e));
                StackTraceElement[] stackTraceElements = e.getStackTrace();
                if (stackTraceElements == null) break block7;
                for (StackTraceElement stackTraceElement : stackTraceElements) {
                    logger.error((Object)("FaLogForMonthlySettlementLoss Before Exception stackTraceElements:" + stackTraceElement));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void invokeMethodCalcAfter(FaRPCMethodEvent<FaDataChangeLogInfo> faRPCMethodEvent) throws BOSException, EASBizException {
        String tempTableName = null;
        try {
            HashMap<String, String> hashMap = FaMonthlySettlementLossTempTableNameThreadLocal.get();
            tempTableName = hashMap.get(faRPCMethodEvent.getSvcCtx().getOperationPK().toString());
            FaRPCMethodEvent<FaDataChangeLogInfo> faRPCMethodEventOld = faRPCMethodEventThreadLocal.get().get(faRPCMethodEvent.getSvcCtx().getOperationPK().toString());
            PeriodInfo faCurPeriodInfo = faRPCMethodEventOld.getFaCurPeriodInfo();
            CompanyOrgUnitInfo faCurCompany = faRPCMethodEventOld.getFaCurCompany();
            StringBuilder selectSql = new StringBuilder();
            selectSql.append(" SELECT faCardId FROM " + tempTableName + " \n");
            selectSql.append(" where faCardId not in (select FFACURCARDID from t_fa_famoncard where FFAPERIODID = ? and FCOMPANYID = ?) \n");
            IRowSet rs = DbUtil.executeQuery((Context)faRPCMethodEvent.getContext(), (String)selectSql.toString(), (Object[])new Object[]{faCurPeriodInfo.getId().toString(), faCurCompany.getId().toString()});
            while (rs.next()) {
                FaDataChangeLogInfo faDataChangeLogInfo = new FaDataChangeLogInfo();
                faDataChangeLogInfo.setId(BOSUuid.create((BOSObjectType)faDataChangeLogInfo.getBOSType()));
                faDataChangeLogInfo.setAppLogID(faRPCMethodEventOld.getDetailMessage().getAppLogID());
                faDataChangeLogInfo.setDataChangeType(FaDataChangeLogForDataChangeTypeEnum.FA_MOTHLY_SETTLEMENT_LOSS);
                faDataChangeLogInfo.setDataChangeRecordType(FaDataChangeLogForDataChangeRecordTypeEnum.FA_DATA_COUNT_CHANGE);
                faDataChangeLogInfo.setDataChangeTable("t_fa_famoncard");
                faDataChangeLogInfo.setBusinessID(rs.getString("faCardId"));
                faDataChangeLogInfo.setDataChangeFields("");
                faDataChangeLogInfo.setDataChangeFieldsValue("");
                faDataChangeLogInfo.setDataChangeRecords(1);
                HashMap<String, FaDataChangeLogInfo> params = new HashMap<String, FaDataChangeLogInfo>();
                params.put("faDataChangeLogInfo", faDataChangeLogInfo);
                FaAppLogFactory.getLocalInstance(faRPCMethodEvent.getContext()).requiresNewMethod("FaDataChangeLogFactory.addnew", params);
            }
            if (tempTableName == null) return;
        }
        catch (Exception e) {
            try {
                logger.error((Object)("FaLogForMonthlySettlementLoss After Exception:" + e));
                StackTraceElement[] stackTraceElements = e.getStackTrace();
                if (stackTraceElements != null) {
                    for (StackTraceElement stackTraceElement : stackTraceElements) {
                        logger.error((Object)("FaLogForMonthlySettlementLoss After Exception stackTraceElements:" + stackTraceElement));
                    }
                }
                if (tempTableName == null) return;
            }
            catch (Throwable throwable) {
                if (tempTableName == null) throw throwable;
                TempTablePool.getInstance((Context)faRPCMethodEvent.getContext()).releaseTable(tempTableName);
                throw throwable;
            }
            TempTablePool.getInstance((Context)faRPCMethodEvent.getContext()).releaseTable(tempTableName);
            return;
        }
        TempTablePool.getInstance((Context)faRPCMethodEvent.getContext()).releaseTable(tempTableName);
        return;
    }

    private String createTempTable(Context ctx) throws BOSException {
        String tempTableName;
        StringBuilder tempTableSQL = new StringBuilder();
        tempTableSQL.append("CREATE TABLE T_Temp_FaLogForMonthlySettlementLoss( faCardId VARCHAR(44) )");
        try {
            tempTableName = TempTablePool.getInstance((Context)ctx).createTempTable(tempTableSQL.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tempTableName;
    }
}

