/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app.falog.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.service.ServiceContext;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.FaAppLogForBusinessTypeEnum;
import com.kingdee.eas.fi.fa.manage.FaAppLogInfo;
import com.kingdee.eas.fi.fa.manage.FaDataChangeLogInfo;
import com.kingdee.eas.fi.fa.manage.FaRpcMethodMappingCollection;
import com.kingdee.eas.fi.fa.manage.FaRpcMethodMappingFactory;
import com.kingdee.eas.fi.fa.manage.FaRpcMethodMappingInfo;
import com.kingdee.eas.fi.fa.manage.app.falog.event.FaEventTypeEnum;
import com.kingdee.eas.fi.fa.manage.app.falog.event.FaMethodCalcOrderEnum;
import com.kingdee.eas.fi.fa.manage.app.falog.utils.FaRPCMethodEventFactory;
import com.kingdee.eas.fi.fa.manage.app.falog.utils.FaRPCMethodEventPublish;
import com.kingdee.eas.fi.fa.manage.app.falog.utils.entity.FaRPCMethodMappingEntity;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.app.ContextUtil;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class FaRPCMethodMappingUtils {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.fa.manage.app.falog.utils.FaRPCMethodMappingUtils");

    private FaRPCMethodMappingUtils() {
    }

    public static void invokeRPCMethodEventListener(ServiceContext svcCtx, FaAppLogForBusinessTypeEnum faAppLogForBusinessTypeEnum, FaMethodCalcOrderEnum methodCalcOrder) {
        block9: {
            try {
                ArrayList<FaEventTypeEnum> listenerType = new ArrayList<FaEventTypeEnum>();
                FaRpcMethodMappingInfo faRpcMethodMappingInfo = FaRPCMethodMappingUtils.getRPCMethodListenerStatus(svcCtx, svcCtx.getOperationPK().toString(), listenerType);
                if (faRpcMethodMappingInfo == null) break block9;
                ArrayList rpcMethodEvents = new ArrayList();
                BOSUuid faAppLogInfoID = BOSUuid.create((String)"EDF18967");
                CompanyOrgUnitInfo companyOrgUnitInfo = svcCtx.getContext().get((Object)"CompanyInfo") != null ? (CompanyOrgUnitInfo)svcCtx.getContext().get((Object)"CompanyInfo") : ContextUtil.getCurrentFIUnit((Context)svcCtx.getContext());
                PeriodInfo faCurPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)svcCtx.getContext(), (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)companyOrgUnitInfo);
                FaRPCMethodMappingEntity faRPCMethodMappingEntity = new FaRPCMethodMappingEntity(faRpcMethodMappingInfo, faAppLogInfoID, companyOrgUnitInfo, faCurPeriodInfo);
                for (FaEventTypeEnum eventType : listenerType) {
                    if (eventType == FaEventTypeEnum.FA_APP_LOG) {
                        rpcMethodEvents.add(FaRPCMethodEventFactory.getRPCMethodEvents(svcCtx, svcCtx.getContext(), eventType, faAppLogForBusinessTypeEnum, methodCalcOrder, new FaAppLogInfo(), faRPCMethodMappingEntity));
                        continue;
                    }
                    rpcMethodEvents.add(FaRPCMethodEventFactory.getRPCMethodEvents(svcCtx, svcCtx.getContext(), eventType, faAppLogForBusinessTypeEnum, methodCalcOrder, new FaDataChangeLogInfo(), faRPCMethodMappingEntity));
                }
                FaRPCMethodEventPublish.rpcMethodEventPublish(rpcMethodEvents);
            }
            catch (EASBizException e) {
                logger.error((Object)("FaRPCMethodMappingUtils EASBizException:" + (Object)((Object)e)));
                StackTraceElement[] stackTraceElements = e.getStackTrace();
                if (stackTraceElements == null) break block9;
                for (StackTraceElement stackTraceElement : stackTraceElements) {
                    logger.error((Object)("FaRPCMethodMappingUtils EASBizException stackTraceElements:" + stackTraceElement));
                }
            }
            catch (BOSException e) {
                logger.error((Object)("FaRPCMethodMappingUtils BOSException:" + (Object)((Object)e)));
                StackTraceElement[] stackTraceElements = e.getStackTrace();
                if (stackTraceElements == null) break block9;
                for (StackTraceElement stackTraceElement : stackTraceElements) {
                    logger.error((Object)("FaRPCMethodMappingUtils BOSException stackTraceElements:" + stackTraceElement));
                }
            }
            catch (Exception e) {
                logger.error((Object)("FaRPCMethodMappingUtils Exception:" + e));
                StackTraceElement[] stackTraceElements = e.getStackTrace();
                if (stackTraceElements == null) break block9;
                for (StackTraceElement stackTraceElement : stackTraceElements) {
                    logger.error((Object)("FaRPCMethodMappingUtils Exception stackTraceElements:" + stackTraceElement));
                }
            }
        }
    }

    public static FaRpcMethodMappingInfo getRPCMethodListenerStatus(ServiceContext svcCtx, String innerID, List<FaEventTypeEnum> listenerType) throws BOSException {
        FaRpcMethodMappingCollection rpcMethodMappingCollection = FaRpcMethodMappingFactory.getLocalInstance(svcCtx.getContext()).getFaRpcMethodMappingCollection("select * where innerID = '" + innerID + "'");
        if (rpcMethodMappingCollection.size() == 0) {
            return null;
        }
        FaRpcMethodMappingInfo rpcMethodMappingInfo = rpcMethodMappingCollection.get(0);
        if (rpcMethodMappingInfo.isIsListenerForFaAppLog()) {
            listenerType.add(FaEventTypeEnum.FA_APP_LOG);
        }
        if (rpcMethodMappingInfo.getListenerType() != null) {
            String[] types;
            for (String type : types = rpcMethodMappingInfo.getListenerType().split(",")) {
                listenerType.add(FaEventTypeEnum.valueOf(type));
            }
        }
        return rpcMethodMappingInfo.isIsListenerStatus() ? rpcMethodMappingInfo : null;
    }

    public static void updateRPCMethodMappingValues(Context ctx) throws BOSException {
        String[] shouldUpdateClass = new String[]{"com.kingdee.eas.fi.fa.manage.app.FaCurCardController", "com.kingdee.eas.fi.fa.manage.app.FaClearBillController", "com.kingdee.eas.fi.fa.manage.app.FaChangeBillController", "com.kingdee.eas.fi.fa.manage.app.FaSplitBillController", "com.kingdee.eas.fi.fa.manage.app.FaCombinBillController", "com.kingdee.eas.fi.fa.manage.app.FaMortagBillController", "com.kingdee.eas.fi.fa.manage.app.FaDispatchBillController", "com.kingdee.eas.fi.fa.manage.app.FaEvaluateBillController", "com.kingdee.eas.fi.fa.manage.app.FaDecValueController", "com.kingdee.eas.fi.fa.manage.app.FaStocktakingBillController", "com.kingdee.eas.fi.fa.manage.app.FaMaintainController", "com.kingdee.eas.fi.fa.manage.app.FaDepCalFacadeController", "com.kingdee.eas.fi.fa.manage.app.FaPeriodCloseFacadeController", "com.kingdee.eas.fi.fa.manage.app.FaAccountBalanceController", "com.kingdee.eas.fi.fa.manage.app.FaCurInitFacadeController", "com.kingdee.eas.fi.fa.manage.app.FaDepreciationBatchFacadeController", "com.kingdee.eas.fi.fa.manage.app.FaPeriodCloseBatchFacadeController", "com.kingdee.eas.fi.fa.manage.app.FaDepreciationController", "com.kingdee.eas.fi.fa.manage.app.FaStocktakingTaskBillController"};
        try {
            for (String updateClass : shouldUpdateClass) {
                Method[] rpcClassMethods;
                Class<?> rpcClass = Class.forName(updateClass);
                for (Method rpcClassMethod : rpcClassMethods = rpcClass.getMethods()) {
                    int n;
                    FaRpcMethodMappingInfo rpcMethodMappingInfo = new FaRpcMethodMappingInfo();
                    rpcMethodMappingInfo.setId(BOSUuid.create((BOSObjectType)rpcMethodMappingInfo.getBOSType()));
                    rpcMethodMappingInfo.setRpcClass(rpcClassMethod.getDeclaringClass().getName());
                    Class<?> methodClass = Class.forName(rpcClassMethod.getDeclaringClass().getName());
                    if (methodClass.getInterfaces().length != 0) {
                        rpcMethodMappingInfo.setRpcClassParent(methodClass.getInterfaces()[0].getName());
                    }
                    rpcMethodMappingInfo.setInnerID("");
                    rpcMethodMappingInfo.setRpcMethodName(rpcClassMethod.getName());
                    StringBuilder stringBuilder = new StringBuilder();
                    rpcMethodMappingInfo.setInstanceIdPosition(-1);
                    int m = rpcClassMethod.getParameterTypes().length;
                    for (n = 0; n < m; ++n) {
                        Class<?> tmpClass;
                        stringBuilder.append(rpcClassMethod.getParameterTypes()[n].getName()).append(",");
                        if ("int".equals(rpcClassMethod.getParameterTypes()[n].getName()) || "boolean".equals(rpcClassMethod.getParameterTypes()[n].getName()) || !CoreBaseInfo.class.isAssignableFrom(tmpClass = Class.forName(rpcClassMethod.getParameterTypes()[n].getName()))) continue;
                        rpcMethodMappingInfo.setInstanceIdPosition(n);
                    }
                    if (rpcMethodMappingInfo.getInstanceIdPosition() == -1) {
                        m = rpcClassMethod.getParameterTypes().length;
                        for (n = 0; n < m; ++n) {
                            if (!"com.kingdee.bos.dao.IObjectPK".equals(rpcClassMethod.getParameterTypes()[n].getName())) continue;
                            rpcMethodMappingInfo.setInstanceIdPosition(n);
                        }
                    }
                    String rpcFiledName = stringBuilder.substring(0, stringBuilder.length() - 1);
                    rpcMethodMappingInfo.setRpcFiledName(rpcFiledName);
                    rpcMethodMappingInfo.setIsListenerStatus(true);
                    rpcMethodMappingInfo.setIsListenerForFaAppLog(true);
                    rpcMethodMappingInfo.setListenerType("");
                    if (FaRpcMethodMappingFactory.getLocalInstance(ctx).exists("where rpcClass = '" + rpcMethodMappingInfo.getRpcClass() + "' and rpcMethodName = '" + rpcMethodMappingInfo.getRpcMethodName() + "' and rpcFiledName = '" + rpcMethodMappingInfo.getRpcFiledName() + "'")) continue;
                    FaRpcMethodMappingFactory.getLocalInstance(ctx).addnew(rpcMethodMappingInfo);
                }
            }
        }
        catch (ClassNotFoundException e) {
            throw new BOSException((Throwable)e);
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
    }
}

