/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app.fleventlistener.listener;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.AbstractNLMAccountBalanceInfo;
import com.kingdee.eas.fi.fa.manage.FaLeaseInBillNewInfo;
import com.kingdee.eas.fi.fa.manage.FaLeaseTypeEnum;
import com.kingdee.eas.fi.fa.manage.NLMAccountBalanceDetailCollection;
import com.kingdee.eas.fi.fa.manage.NLMAccountBalanceDetailFactory;
import com.kingdee.eas.fi.fa.manage.NLMAccountBalanceFactory;
import com.kingdee.eas.fi.fa.manage.NLMAccountBalanceInfo;
import com.kingdee.eas.fi.fa.manage.NLMBillFieldNameEnum;
import com.kingdee.eas.fi.fa.manage.NLMBillSourceTypeEnum;
import com.kingdee.eas.fi.fa.manage.app.fleventlistener.event.EventTypeEnum;
import com.kingdee.eas.fi.fa.manage.app.fleventlistener.event.RPCMethodEvent;
import com.kingdee.eas.fi.fa.manage.app.fleventlistener.listener.AbstractRPCMethodListener;
import com.kingdee.eas.fi.fa.manage.app.fleventlistener.listener.annotation.ListenerEventType;
import com.kingdee.eas.fi.fa.manage.app.fleventlistener.listener.strategy.UpdateBalanceTableForLeaseBillEnum;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.app.ContextUtil;
import java.math.BigDecimal;

public class FaLeaseBillRPCMethodListener
extends AbstractRPCMethodListener<FaLeaseInBillNewInfo> {
    @ListenerEventType(value=EventTypeEnum.UPDATE_BALANCE_TABLE)
    public void updateBalanceTable(RPCMethodEvent<FaLeaseInBillNewInfo> rpcMethodEvent) throws BOSException, EASBizException {
        FaLeaseInBillNewInfo detailMessage = rpcMethodEvent.getDetailMessage();
        UpdateBalanceTableForLeaseBillEnum updateBalanceTableForLeaseBillEnum = UpdateBalanceTableForLeaseBillEnum.getEnumAccordingToBillType(detailMessage.getSourceType().getName());
        if (updateBalanceTableForLeaseBillEnum == null) {
            updateBalanceTableForLeaseBillEnum = UpdateBalanceTableForLeaseBillEnum.getEnumAccordingToBillType(detailMessage.getLeaseType() == null ? FaLeaseTypeEnum.OPERATING_LEASE.getName() : detailMessage.getLeaseType().getName());
        }
        NLMAccountBalanceDetailCollection nlmAccountBalanceDetailCollection = updateBalanceTableForLeaseBillEnum.getNLMAccountBalanceDetailCollection(rpcMethodEvent);
        this.deleteBalanceValue(rpcMethodEvent);
        this.deleteBalanceDetailValue(rpcMethodEvent);
        int j = nlmAccountBalanceDetailCollection.size();
        for (int i = 0; i < j; ++i) {
            NLMAccountBalanceDetailFactory.getLocalInstance(rpcMethodEvent.getContext()).addnew(nlmAccountBalanceDetailCollection.get(i));
        }
        NLMBillSourceTypeEnum nlmBillSourceTypeEnum = updateBalanceTableForLeaseBillEnum.getNlmBillSourceTypeEnum();
        NLMAccountBalanceInfo nlmAccountBalanceInfo = this.getNLMAccountBalanceInfo(rpcMethodEvent.getContext(), nlmBillSourceTypeEnum, detailMessage, nlmAccountBalanceDetailCollection);
        NLMAccountBalanceFactory.getLocalInstance(rpcMethodEvent.getContext()).addnew(nlmAccountBalanceInfo);
    }

    @ListenerEventType(value=EventTypeEnum.DELETE_BALANCE_TABLE)
    public void deleteBalanceTable(RPCMethodEvent<FaLeaseInBillNewInfo> rpcMethodEvent) throws EASBizException, BOSException {
        this.deleteBalanceValue(rpcMethodEvent);
        this.deleteBalanceDetailValue(rpcMethodEvent);
    }

    private void deleteBalanceDetailValue(RPCMethodEvent<FaLeaseInBillNewInfo> rpcMethodEvent) throws BOSException, EASBizException {
        FaLeaseInBillNewInfo detailMessage = rpcMethodEvent.getDetailMessage();
        CompanyOrgUnitInfo companyOrgUnitInfo = detailMessage.getCompany();
        NLMAccountBalanceDetailFactory.getLocalInstance(rpcMethodEvent.getContext()).delete("where company.id = '" + companyOrgUnitInfo.getId().toString() + "' and nlmBillID = '" + detailMessage.getId().toString() + "'");
    }

    private void deleteBalanceValue(RPCMethodEvent<FaLeaseInBillNewInfo> rpcMethodEvent) throws EASBizException, BOSException {
        FaLeaseInBillNewInfo detailMessage = rpcMethodEvent.getDetailMessage();
        CompanyOrgUnitInfo companyOrgUnitInfo = detailMessage.getCompany();
        NLMAccountBalanceFactory.getLocalInstance(rpcMethodEvent.getContext()).delete("where company.id = '" + companyOrgUnitInfo.getId().toString() + "' and leaseInBill.id = '" + detailMessage.getId().toString() + "'");
    }

    private NLMAccountBalanceInfo getNLMAccountBalanceInfo(Context context, NLMBillSourceTypeEnum nlmBillSourceTypeEnum, FaLeaseInBillNewInfo detailMessage, NLMAccountBalanceDetailCollection nlmAccountBalanceDetailCollection) throws EASBizException, BOSException {
        CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)context);
        PeriodInfo periodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)context, (SystemEnum)SystemEnum.FINANCE_LEASE, (CompanyOrgUnitInfo)company);
        NLMAccountBalanceInfo nlmAccountBalanceInfoNew = new NLMAccountBalanceInfo();
        nlmAccountBalanceInfoNew.setId(BOSUuid.create((BOSObjectType)nlmAccountBalanceInfoNew.getBOSType()));
        nlmAccountBalanceInfoNew.setLeaseInBill(detailMessage);
        nlmAccountBalanceInfoNew.setCompany(detailMessage.getCompany());
        nlmAccountBalanceInfoNew.setCurrency(detailMessage.getCurrency());
        nlmAccountBalanceInfoNew.setPeriod(periodInfo);
        nlmAccountBalanceInfoNew.setOpeningBalanceForAsset(new BigDecimal("0"));
        nlmAccountBalanceInfoNew.setCurrentBorrowingForAsset(new BigDecimal("0"));
        nlmAccountBalanceInfoNew.setCurrentLoanForAsset(new BigDecimal("0"));
        nlmAccountBalanceInfoNew.setEndingBalanceForAsset(new BigDecimal("0"));
        nlmAccountBalanceInfoNew.setOpeningBalanceForDep(new BigDecimal("0"));
        nlmAccountBalanceInfoNew.setCurrentBorrowingForDep(new BigDecimal("0"));
        nlmAccountBalanceInfoNew.setCurrentLoanForDep(new BigDecimal("0"));
        nlmAccountBalanceInfoNew.setEndingBalanceForDep(new BigDecimal("0"));
        nlmAccountBalanceInfoNew.setOpeningBalanceForDec(new BigDecimal("0"));
        nlmAccountBalanceInfoNew.setCurrentBorrowingForDec(new BigDecimal("0"));
        nlmAccountBalanceInfoNew.setCurrentLoanForDec(new BigDecimal("0"));
        nlmAccountBalanceInfoNew.setEndingBalanceForDec(new BigDecimal("0"));
        if (nlmBillSourceTypeEnum == NLMBillSourceTypeEnum.LEASE_BILL_GL_BALANCE_ENTRY) {
            nlmAccountBalanceInfoNew.setOpeningBalanceForAsset(this.getValueForNLMBillFieldName(NLMBillFieldNameEnum.LEASE_BILL_ASSET, nlmAccountBalanceDetailCollection));
            nlmAccountBalanceInfoNew.setOpeningBalanceForDep(this.getValueForNLMBillFieldName(NLMBillFieldNameEnum.LEASE_BILL_ACC_DEP, nlmAccountBalanceDetailCollection));
            nlmAccountBalanceInfoNew.setOpeningBalanceForDec(this.getValueForNLMBillFieldName(NLMBillFieldNameEnum.LEASE_BILL_DEC, nlmAccountBalanceDetailCollection));
        }
        if (nlmBillSourceTypeEnum == NLMBillSourceTypeEnum.LEASE_BILL_FINANCE_LEASE) {
            nlmAccountBalanceInfoNew.setCurrentBorrowingForAsset(this.getValueForNLMBillFieldName(NLMBillFieldNameEnum.LEASE_BILL_ASSET, nlmAccountBalanceDetailCollection));
            nlmAccountBalanceInfoNew.setCurrentLoanForDep(this.getValueForNLMBillFieldName(NLMBillFieldNameEnum.LEASE_BILL_ACC_DEP, nlmAccountBalanceDetailCollection));
            nlmAccountBalanceInfoNew.setCurrentLoanForDec(this.getValueForNLMBillFieldName(NLMBillFieldNameEnum.LEASE_BILL_DEC, nlmAccountBalanceDetailCollection));
        }
        if (nlmBillSourceTypeEnum == NLMBillSourceTypeEnum.LEASE_BILL_OPERATING_LEASE) {
            nlmAccountBalanceInfoNew.setCurrentBorrowingForAsset(this.getValueForNLMBillFieldName(NLMBillFieldNameEnum.LEASE_BILL_INIT_ASSET, nlmAccountBalanceDetailCollection));
            nlmAccountBalanceInfoNew.setCurrentLoanForDep(this.getValueForNLMBillFieldName(NLMBillFieldNameEnum.LEASE_BILL_INIT_ACC_DEP, nlmAccountBalanceDetailCollection).add(this.getValueForNLMBillFieldName(NLMBillFieldNameEnum.LEASE_BILL_ACC_DEP_RECORD, nlmAccountBalanceDetailCollection)));
            nlmAccountBalanceInfoNew.setCurrentLoanForDec(this.getValueForNLMBillFieldName(NLMBillFieldNameEnum.LEASE_BILL_DEC, nlmAccountBalanceDetailCollection));
        }
        if (nlmBillSourceTypeEnum == NLMBillSourceTypeEnum.LEASE_BILL_ADJUST) {
            nlmAccountBalanceInfoNew.setCurrentBorrowingForAsset(this.getValueForNLMBillFieldName(NLMBillFieldNameEnum.LEASE_BILL_ASSET_ADJUST, nlmAccountBalanceDetailCollection));
            nlmAccountBalanceInfoNew.setCurrentLoanForDep(this.getValueForNLMBillFieldName(NLMBillFieldNameEnum.LEASE_BILL_ACC_DEP_ADJUST, nlmAccountBalanceDetailCollection).add(this.getValueForNLMBillFieldName(NLMBillFieldNameEnum.LEASE_BILL_ACC_DEP_RECORD, nlmAccountBalanceDetailCollection)));
            nlmAccountBalanceInfoNew.setCurrentLoanForDec(this.getValueForNLMBillFieldName(NLMBillFieldNameEnum.LEASE_BILL_DEC_ADJUST, nlmAccountBalanceDetailCollection));
        }
        if (nlmBillSourceTypeEnum == NLMBillSourceTypeEnum.LEASE_BILL_RETR_ADJUST) {
            nlmAccountBalanceInfoNew.setCurrentBorrowingForAsset(this.getValueForNLMBillFieldName(NLMBillFieldNameEnum.LEASE_BILL_ASSET_ADJUST, nlmAccountBalanceDetailCollection));
            nlmAccountBalanceInfoNew.setCurrentLoanForDep(this.getValueForNLMBillFieldName(NLMBillFieldNameEnum.LEASE_BILL_ACC_DEP_ADJUST_RETR, nlmAccountBalanceDetailCollection).add(this.getValueForNLMBillFieldName(NLMBillFieldNameEnum.LEASE_BILL_ACC_DEP_RECORD, nlmAccountBalanceDetailCollection)));
        }
        if (nlmBillSourceTypeEnum == NLMBillSourceTypeEnum.LEASE_BILL_TERMINATE) {
            nlmAccountBalanceInfoNew.setCurrentBorrowingForAsset(this.getValueForNLMBillFieldName(NLMBillFieldNameEnum.LEASE_BILL_ASSET_ADJUST, nlmAccountBalanceDetailCollection));
        }
        PeriodInfo perPeriod = PeriodUtils.getPrePeriodInfo((Context)context, (PeriodInfo)periodInfo);
        AbstractNLMAccountBalanceInfo nlmAccountBalanceInfoOld = null;
        if (perPeriod != null && NLMAccountBalanceFactory.getLocalInstance(context).exists("where leaseInBill.id = '" + detailMessage.getId().toString() + "' and period.id = '" + perPeriod.getId().toString() + "'")) {
            nlmAccountBalanceInfoOld = NLMAccountBalanceFactory.getLocalInstance(context).getNLMAccountBalanceInfo("where leaseInBill.id = '" + detailMessage.getId().toString() + "' and period.id = '" + perPeriod.getId().toString() + "'");
        }
        if (nlmAccountBalanceInfoOld != null) {
            nlmAccountBalanceInfoNew.setOpeningBalanceForAsset(nlmAccountBalanceInfoNew.getOpeningBalanceForAsset().add(nlmAccountBalanceInfoOld.getEndingBalanceForAsset()));
            nlmAccountBalanceInfoNew.setOpeningBalanceForDep(nlmAccountBalanceInfoNew.getOpeningBalanceForDep().add(nlmAccountBalanceInfoOld.getEndingBalanceForDep()));
            nlmAccountBalanceInfoNew.setOpeningBalanceForDec(nlmAccountBalanceInfoNew.getOpeningBalanceForDec().add(nlmAccountBalanceInfoOld.getEndingBalanceForDec()));
        }
        nlmAccountBalanceInfoNew.setEndingBalanceForAsset(nlmAccountBalanceInfoNew.getOpeningBalanceForAsset().add(nlmAccountBalanceInfoNew.getCurrentBorrowingForAsset()).subtract(nlmAccountBalanceInfoNew.getCurrentLoanForAsset()));
        nlmAccountBalanceInfoNew.setEndingBalanceForDep(nlmAccountBalanceInfoNew.getOpeningBalanceForDep().subtract(nlmAccountBalanceInfoNew.getCurrentBorrowingForDep()).add(nlmAccountBalanceInfoNew.getCurrentLoanForDep()));
        nlmAccountBalanceInfoNew.setEndingBalanceForDec(nlmAccountBalanceInfoNew.getOpeningBalanceForDec().subtract(nlmAccountBalanceInfoNew.getCurrentBorrowingForDec()).add(nlmAccountBalanceInfoNew.getCurrentLoanForDec()));
        return nlmAccountBalanceInfoNew;
    }

    private BigDecimal getValueForNLMBillFieldName(NLMBillFieldNameEnum nlmBillFieldNameEnum, NLMAccountBalanceDetailCollection nlmAccountBalanceDetailCollection) {
        int j = nlmAccountBalanceDetailCollection.size();
        for (int i = 0; i < j; ++i) {
            if (nlmAccountBalanceDetailCollection.get(i).getNlmBillGetFieldName() != nlmBillFieldNameEnum) continue;
            return nlmAccountBalanceDetailCollection.get(i).getNlmBillGetFieldValue() == null ? new BigDecimal("0") : nlmAccountBalanceDetailCollection.get(i).getNlmBillGetFieldValue();
        }
        return new BigDecimal("0");
    }
}

