/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app.fleventlistener.listener;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.FaTerminateBillEntryCollection;
import com.kingdee.eas.fi.fa.manage.FaTerminateBillInfo;
import com.kingdee.eas.fi.fa.manage.FaTerminateMode;
import com.kingdee.eas.fi.fa.manage.NLMAccountBalanceDetailCollection;
import com.kingdee.eas.fi.fa.manage.NLMAccountBalanceDetailFactory;
import com.kingdee.eas.fi.fa.manage.NLMAccountBalanceDetailInfo;
import com.kingdee.eas.fi.fa.manage.NLMAccountBalanceException;
import com.kingdee.eas.fi.fa.manage.NLMAccountBalanceFactory;
import com.kingdee.eas.fi.fa.manage.NLMAccountBalanceInfo;
import com.kingdee.eas.fi.fa.manage.NLMBillFieldNameEnum;
import com.kingdee.eas.fi.fa.manage.NLMBillSourceTypeEnum;
import com.kingdee.eas.fi.fa.manage.app.fleventlistener.event.EventTypeEnum;
import com.kingdee.eas.fi.fa.manage.app.fleventlistener.event.RPCMethodEvent;
import com.kingdee.eas.fi.fa.manage.app.fleventlistener.listener.AbstractRPCMethodListener;
import com.kingdee.eas.fi.fa.manage.app.fleventlistener.listener.annotation.ListenerEventType;
import com.kingdee.eas.fi.fa.manage.app.fleventlistener.listener.strategy.UpdateBalanceTableForTerminateBillEnum;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class FaTerminateBillRPCMethodListener
extends AbstractRPCMethodListener<FaTerminateBillInfo> {
    @ListenerEventType(value=EventTypeEnum.UPDATE_BALANCE_TABLE)
    public void updateBalanceTable(RPCMethodEvent<FaTerminateBillInfo> rpcMethodEvent) throws BOSException, EASBizException {
        FaTerminateBillInfo detailMessage = rpcMethodEvent.getDetailMessage();
        UpdateBalanceTableForTerminateBillEnum updateBalanceTableForTerminateBillEnum = UpdateBalanceTableForTerminateBillEnum.getEnumAccordingToBillType(detailMessage.getTerminateMode().getName());
        NLMAccountBalanceDetailCollection nlmAccountBalanceDetailCollection = updateBalanceTableForTerminateBillEnum.getNLMAccountBalanceDetailCollection(rpcMethodEvent);
        this.deleteBalanceValue(rpcMethodEvent);
        this.deleteBalanceDetailValue(rpcMethodEvent);
        int j = nlmAccountBalanceDetailCollection.size();
        for (int i = 0; i < j; ++i) {
            NLMAccountBalanceDetailFactory.getLocalInstance(rpcMethodEvent.getContext()).addnew(nlmAccountBalanceDetailCollection.get(i));
        }
        NLMBillSourceTypeEnum nlmBillSourceTypeEnum = updateBalanceTableForTerminateBillEnum.getNlmBillSourceTypeEnum();
        this.updateNLMAccountBalanceInfo(rpcMethodEvent.getContext(), nlmBillSourceTypeEnum, detailMessage, nlmAccountBalanceDetailCollection);
    }

    @ListenerEventType(value=EventTypeEnum.DELETE_BALANCE_TABLE)
    public void deleteBalanceTable(RPCMethodEvent<FaTerminateBillInfo> rpcMethodEvent) throws EASBizException, BOSException {
        this.deleteBalanceValue(rpcMethodEvent);
        this.deleteBalanceDetailValue(rpcMethodEvent);
    }

    private void deleteBalanceDetailValue(RPCMethodEvent<FaTerminateBillInfo> rpcMethodEvent) throws BOSException, EASBizException {
        FaTerminateBillInfo detailMessage = rpcMethodEvent.getDetailMessage();
        CompanyOrgUnitInfo companyOrgUnitInfo = detailMessage.getCompany();
        PeriodInfo periodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)rpcMethodEvent.getContext(), (SystemEnum)SystemEnum.FINANCE_LEASE, (CompanyOrgUnitInfo)companyOrgUnitInfo);
        NLMAccountBalanceDetailFactory.getLocalInstance(rpcMethodEvent.getContext()).delete("where company.id = '" + companyOrgUnitInfo.getId().toString() + "' and period.id = '" + periodInfo.getId().toString() + "' and nlmBillID = '" + detailMessage.getId().toString() + "' and nlmBillType = 1");
    }

    private void deleteBalanceValue(RPCMethodEvent<FaTerminateBillInfo> rpcMethodEvent) throws EASBizException, BOSException {
        CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)rpcMethodEvent.getContext());
        PeriodInfo periodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)rpcMethodEvent.getContext(), (SystemEnum)SystemEnum.FINANCE_LEASE, (CompanyOrgUnitInfo)company);
        FaTerminateBillEntryCollection faTerminateBillEntryCollection = rpcMethodEvent.getDetailMessage().getEntry();
        int j = faTerminateBillEntryCollection.size();
        for (int i = 0; i < j; ++i) {
            String leaseInBillNumber = faTerminateBillEntryCollection.get(i).getLeaseInBillNumber();
            NLMAccountBalanceDetailCollection detailInfoCollection = this.getNLMAccountBalanceDetailInfoList(rpcMethodEvent.getContext(), rpcMethodEvent.getDetailMessage(), leaseInBillNumber);
            ArrayList<NLMAccountBalanceDetailInfo> detailInfos = new ArrayList<NLMAccountBalanceDetailInfo>();
            int m = detailInfoCollection.size();
            for (int n = 0; n < m; ++n) {
                detailInfos.add(detailInfoCollection.get(n));
            }
            if (detailInfos.size() == 0) continue;
            if (!NLMAccountBalanceFactory.getLocalInstance(rpcMethodEvent.getContext()).exists("where leaseInBill.id = '" + ((NLMAccountBalanceDetailInfo)detailInfos.get(0)).getNlmLeaseBillID() + "' and period.id = '" + periodInfo.getId().toString() + "'")) {
                throw new NLMAccountBalanceException(NLMAccountBalanceException.NOT_ACCOUNT_VALUE, new Object[]{leaseInBillNumber});
            }
            NLMAccountBalanceInfo nlmAccountBalanceInfo = NLMAccountBalanceFactory.getLocalInstance(rpcMethodEvent.getContext()).getNLMAccountBalanceInfo("where leaseInBill.id = '" + ((NLMAccountBalanceDetailInfo)detailInfos.get(0)).getNlmLeaseBillID() + "' and period.id = '" + periodInfo.getId().toString() + "'");
            BigDecimal currentLoanForAsset = this.getValueForNLMBillFieldName(NLMBillFieldNameEnum.TERMINATE_BILL_TER_INIT_ASSET, detailInfos);
            BigDecimal currentBorrowingForDep = this.getValueForNLMBillFieldName(NLMBillFieldNameEnum.TERMINATE_BILL_TER_ACC_DEP, detailInfos);
            BigDecimal currentBorrowingForDec = this.getValueForNLMBillFieldName(NLMBillFieldNameEnum.TERMINATE_BILL_TER_DEC_VALUE, detailInfos);
            if (rpcMethodEvent.getDetailMessage().getTerminateMode() == FaTerminateMode.RETROSPECT_TERMINATION) {
                BigDecimal retrAccDep = this.getValueForNLMBillFieldName(NLMBillFieldNameEnum.TERMINATE_BILL_TER_RETR_ACC_DEP, detailInfos);
                BigDecimal retrDecValue = this.getValueForNLMBillFieldName(NLMBillFieldNameEnum.TERMINATE_BILL_TER_RETR_DEC_VALUE, detailInfos);
                currentLoanForAsset = nlmAccountBalanceInfo.getCurrentLoanForAsset().subtract(currentLoanForAsset);
                currentBorrowingForDep = nlmAccountBalanceInfo.getCurrentBorrowingForDep().subtract(currentBorrowingForDep).subtract(retrAccDep);
                currentBorrowingForDec = nlmAccountBalanceInfo.getCurrentBorrowingForDec().subtract(currentBorrowingForDec).subtract(retrDecValue);
                BigDecimal endingBalanceForAsset = nlmAccountBalanceInfo.getOpeningBalanceForAsset().add(nlmAccountBalanceInfo.getCurrentBorrowingForAsset()).subtract(currentLoanForAsset);
                BigDecimal endingBalanceForDep = nlmAccountBalanceInfo.getOpeningBalanceForDep().subtract(currentBorrowingForDep).add(nlmAccountBalanceInfo.getCurrentLoanForDep());
                BigDecimal endingBalanceForDec = nlmAccountBalanceInfo.getOpeningBalanceForDec().subtract(currentBorrowingForDec).add(nlmAccountBalanceInfo.getCurrentLoanForDec());
                String updateSql = "UPDATE T_NLM_NLMAccountBalance SET FCurrentLoanForAsset = ?, FCurrentBorrowingForDep = ?, FCurrentBorrowingForDec = ?, FEndingBalanceForAsset = ?, FEndingBalanceForDep = ?, FEndingBalanceForDec = ? WHERE FID = ?";
                DbUtil.execute((Context)rpcMethodEvent.getContext(), (String)updateSql, (Object[])new Object[]{currentLoanForAsset, currentBorrowingForDep, currentBorrowingForDec, endingBalanceForAsset, endingBalanceForDep, endingBalanceForDec, nlmAccountBalanceInfo.getId().toString()});
                continue;
            }
            currentLoanForAsset = nlmAccountBalanceInfo.getCurrentLoanForAsset().subtract(currentLoanForAsset);
            currentBorrowingForDep = nlmAccountBalanceInfo.getCurrentBorrowingForDep().subtract(currentBorrowingForDep);
            currentBorrowingForDec = nlmAccountBalanceInfo.getCurrentBorrowingForDec().subtract(currentBorrowingForDec);
            BigDecimal endingBalanceForAsset = nlmAccountBalanceInfo.getOpeningBalanceForAsset().add(nlmAccountBalanceInfo.getCurrentBorrowingForAsset()).subtract(currentLoanForAsset);
            BigDecimal endingBalanceForDep = nlmAccountBalanceInfo.getOpeningBalanceForDep().subtract(currentBorrowingForDep).add(nlmAccountBalanceInfo.getCurrentLoanForDep());
            BigDecimal endingBalanceForDec = nlmAccountBalanceInfo.getOpeningBalanceForDec().subtract(currentBorrowingForDec).add(nlmAccountBalanceInfo.getCurrentLoanForDec());
            String updateSql = "UPDATE T_NLM_NLMAccountBalance SET FCurrentLoanForAsset = ?, FCurrentBorrowingForDep = ?, FCurrentBorrowingForDec = ?, FEndingBalanceForAsset = ?, FEndingBalanceForDep = ?, FEndingBalanceForDec = ? WHERE FID = ?";
            DbUtil.execute((Context)rpcMethodEvent.getContext(), (String)updateSql, (Object[])new Object[]{currentLoanForAsset, currentBorrowingForDep, currentBorrowingForDec, endingBalanceForAsset, endingBalanceForDep, endingBalanceForDec, nlmAccountBalanceInfo.getId().toString()});
        }
    }

    private void updateNLMAccountBalanceInfo(Context context, NLMBillSourceTypeEnum nlmBillSourceTypeEnum, FaTerminateBillInfo detailMessage, NLMAccountBalanceDetailCollection nlmAccountBalanceDetailCollection) throws EASBizException, BOSException {
        CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)context);
        PeriodInfo periodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)context, (SystemEnum)SystemEnum.FINANCE_LEASE, (CompanyOrgUnitInfo)company);
        HashMap nlmAccountBalanceDetailMap = new HashMap();
        int j = nlmAccountBalanceDetailCollection.size();
        for (int i = 0; i < j; ++i) {
            List<NLMAccountBalanceDetailInfo> list;
            NLMAccountBalanceDetailInfo detailInfo = nlmAccountBalanceDetailCollection.get(i);
            if (!nlmAccountBalanceDetailMap.containsKey(detailInfo.getNlmBillNumber())) {
                list = new ArrayList<NLMAccountBalanceDetailInfo>();
                list.add(detailInfo);
                nlmAccountBalanceDetailMap.put(detailInfo.getNlmBillNumber(), list);
                continue;
            }
            list = (List)nlmAccountBalanceDetailMap.get(detailInfo.getNlmBillNumber());
            list.add(detailInfo);
        }
        FaTerminateBillEntryCollection faTerminateBillEntryCollection = detailMessage.getEntry();
        int j2 = faTerminateBillEntryCollection.size();
        for (int i = 0; i < j2; ++i) {
            String leaseInBillNumber = faTerminateBillEntryCollection.get(i).getLeaseInBillNumber();
            List detailInfos = (List)nlmAccountBalanceDetailMap.get(leaseInBillNumber);
            if (!NLMAccountBalanceFactory.getLocalInstance(context).exists("where leaseInBill.id = '" + ((NLMAccountBalanceDetailInfo)detailInfos.get(0)).getNlmLeaseBillID() + "' and period.id = '" + periodInfo.getId().toString() + "'")) {
                throw new NLMAccountBalanceException(NLMAccountBalanceException.NOT_ACCOUNT_VALUE, new Object[]{leaseInBillNumber});
            }
            NLMAccountBalanceInfo nlmAccountBalanceInfo = NLMAccountBalanceFactory.getLocalInstance(context).getNLMAccountBalanceInfo("where leaseInBill.id = '" + ((NLMAccountBalanceDetailInfo)detailInfos.get(0)).getNlmLeaseBillID() + "' and period.id = '" + periodInfo.getId().toString() + "'");
            BigDecimal currentLoanForAsset = this.getValueForNLMBillFieldName(NLMBillFieldNameEnum.TERMINATE_BILL_TER_INIT_ASSET, detailInfos);
            BigDecimal currentBorrowingForDep = this.getValueForNLMBillFieldName(NLMBillFieldNameEnum.TERMINATE_BILL_TER_ACC_DEP, detailInfos);
            BigDecimal currentBorrowingForDec = this.getValueForNLMBillFieldName(NLMBillFieldNameEnum.TERMINATE_BILL_TER_DEC_VALUE, detailInfos);
            if (nlmBillSourceTypeEnum == NLMBillSourceTypeEnum.TER_RETROSPECT_TERMINATION) {
                BigDecimal retrAccDep = this.getValueForNLMBillFieldName(NLMBillFieldNameEnum.TERMINATE_BILL_TER_RETR_ACC_DEP, detailInfos);
                BigDecimal retrDecValue = this.getValueForNLMBillFieldName(NLMBillFieldNameEnum.TERMINATE_BILL_TER_RETR_DEC_VALUE, detailInfos);
                currentLoanForAsset = currentLoanForAsset.add(nlmAccountBalanceInfo.getCurrentLoanForAsset());
                currentBorrowingForDep = currentBorrowingForDep.add(nlmAccountBalanceInfo.getCurrentBorrowingForDep()).add(retrAccDep);
                currentBorrowingForDec = currentBorrowingForDec.add(nlmAccountBalanceInfo.getCurrentBorrowingForDec()).add(retrDecValue);
                BigDecimal endingBalanceForAsset = nlmAccountBalanceInfo.getOpeningBalanceForAsset().add(nlmAccountBalanceInfo.getCurrentBorrowingForAsset()).subtract(currentLoanForAsset);
                BigDecimal endingBalanceForDep = nlmAccountBalanceInfo.getOpeningBalanceForDep().subtract(currentBorrowingForDep).add(nlmAccountBalanceInfo.getCurrentLoanForDep());
                BigDecimal endingBalanceForDec = nlmAccountBalanceInfo.getOpeningBalanceForDec().subtract(currentBorrowingForDec).add(nlmAccountBalanceInfo.getCurrentLoanForDec());
                String updateSql = "UPDATE T_NLM_NLMAccountBalance SET FCurrentLoanForAsset = ?, FCurrentBorrowingForDep = ?, FCurrentBorrowingForDec = ?, FEndingBalanceForAsset = ?, FEndingBalanceForDep = ?, FEndingBalanceForDec = ? WHERE FID = ?";
                DbUtil.execute((Context)context, (String)updateSql, (Object[])new Object[]{currentLoanForAsset, currentBorrowingForDep, currentBorrowingForDec, endingBalanceForAsset, endingBalanceForDep, endingBalanceForDec, nlmAccountBalanceInfo.getId().toString()});
                continue;
            }
            currentLoanForAsset = currentLoanForAsset.add(nlmAccountBalanceInfo.getCurrentLoanForAsset());
            currentBorrowingForDep = currentBorrowingForDep.add(nlmAccountBalanceInfo.getCurrentBorrowingForDep());
            currentBorrowingForDec = currentBorrowingForDec.add(nlmAccountBalanceInfo.getCurrentBorrowingForDec());
            BigDecimal endingBalanceForAsset = nlmAccountBalanceInfo.getOpeningBalanceForAsset().add(nlmAccountBalanceInfo.getCurrentBorrowingForAsset()).subtract(currentLoanForAsset);
            BigDecimal endingBalanceForDep = nlmAccountBalanceInfo.getOpeningBalanceForDep().subtract(currentBorrowingForDep).add(nlmAccountBalanceInfo.getCurrentLoanForDep());
            BigDecimal endingBalanceForDec = nlmAccountBalanceInfo.getOpeningBalanceForDec().subtract(currentBorrowingForDec).add(nlmAccountBalanceInfo.getCurrentLoanForDec());
            String updateSql = "UPDATE T_NLM_NLMAccountBalance SET FCurrentLoanForAsset = ?, FCurrentBorrowingForDep = ?, FCurrentBorrowingForDec = ?, FEndingBalanceForAsset = ?, FEndingBalanceForDep = ?, FEndingBalanceForDec = ? WHERE FID = ?";
            DbUtil.execute((Context)context, (String)updateSql, (Object[])new Object[]{currentLoanForAsset, currentBorrowingForDep, currentBorrowingForDec, endingBalanceForAsset, endingBalanceForDep, endingBalanceForDec, nlmAccountBalanceInfo.getId().toString()});
        }
    }

    private BigDecimal getValueForNLMBillFieldName(NLMBillFieldNameEnum nlmBillFieldNameEnum, List<NLMAccountBalanceDetailInfo> nlmAccountBalanceDetailCollection) {
        for (NLMAccountBalanceDetailInfo nlmAccountBalanceDetailInfo : nlmAccountBalanceDetailCollection) {
            if (nlmAccountBalanceDetailInfo.getNlmBillGetFieldName() != nlmBillFieldNameEnum) continue;
            return nlmAccountBalanceDetailInfo.getNlmBillGetFieldValue() == null ? new BigDecimal("0") : nlmAccountBalanceDetailInfo.getNlmBillGetFieldValue();
        }
        return new BigDecimal("0");
    }

    private NLMAccountBalanceDetailCollection getNLMAccountBalanceDetailInfoList(Context context, FaTerminateBillInfo detailMessage, String leaseInBillNumber) throws EASBizException, BOSException {
        CompanyOrgUnitInfo companyOrgUnitInfo = detailMessage.getCompany();
        PeriodInfo periodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)context, (SystemEnum)SystemEnum.FINANCE_LEASE, (CompanyOrgUnitInfo)companyOrgUnitInfo);
        return NLMAccountBalanceDetailFactory.getLocalInstance(context).getNLMAccountBalanceDetailCollection("where company.id = '" + companyOrgUnitInfo.getId().toString() + "' and period.id = '" + periodInfo.getId().toString() + "' and nlmBillNumber = '" + leaseInBillNumber + "' and nlmBillType = 1");
    }
}

