/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app.fleventlistener.listener.strategy;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.basedata.FaContractCatFactory;
import com.kingdee.eas.fi.fa.basedata.FaContractCatInfo;
import com.kingdee.eas.fi.fa.manage.AccessTypeEnum;
import com.kingdee.eas.fi.fa.manage.FaDepreAndAmortCollection;
import com.kingdee.eas.fi.fa.manage.FaDepreAndAmortInfo;
import com.kingdee.eas.fi.fa.manage.FaLeaseInBillNewFactory;
import com.kingdee.eas.fi.fa.manage.FaLeaseInBillNewInfo;
import com.kingdee.eas.fi.fa.manage.LendingDirectionEnum;
import com.kingdee.eas.fi.fa.manage.NLMAccountBalanceDetailCollection;
import com.kingdee.eas.fi.fa.manage.NLMAccountBalanceDetailInfo;
import com.kingdee.eas.fi.fa.manage.NLMBillContractCatFieldNameEnum;
import com.kingdee.eas.fi.fa.manage.NLMBillFieldNameEnum;
import com.kingdee.eas.fi.fa.manage.NLMBillSourceTypeEnum;
import com.kingdee.eas.fi.fa.manage.NLMBillTypeEnum;
import com.kingdee.eas.fi.fa.manage.app.fleventlistener.event.RPCMethodEvent;
import com.kingdee.eas.framework.SystemEnum;

public enum UpdateBalanceTableForDepreAndAmortEnum {
    DEPRE_AND_AMORT(null, new NLMBillFieldNameEnum[]{NLMBillFieldNameEnum.DEP_BILL_MONTH_DEP_AMT}, new NLMBillContractCatFieldNameEnum[]{NLMBillContractCatFieldNameEnum.USUFRUCT_ASSET_ACC_DEP});

    private final NLMBillSourceTypeEnum nlmBillSourceTypeEnum;
    private final NLMBillFieldNameEnum[] nlmBillFieldNameEnums;
    private final NLMBillContractCatFieldNameEnum[] nlmBillContractCatFieldNameEnums;

    private UpdateBalanceTableForDepreAndAmortEnum(NLMBillSourceTypeEnum nlmBillSourceTypeEnum, NLMBillFieldNameEnum[] nlmBillFieldNameEnums, NLMBillContractCatFieldNameEnum[] nlmBillContractCatFieldNameEnums) {
        this.nlmBillSourceTypeEnum = nlmBillSourceTypeEnum;
        this.nlmBillFieldNameEnums = nlmBillFieldNameEnums;
        this.nlmBillContractCatFieldNameEnums = nlmBillContractCatFieldNameEnums;
    }

    public NLMAccountBalanceDetailCollection getNLMAccountBalanceDetailCollection(RPCMethodEvent<FaDepreAndAmortCollection> rpcMethodEvent) throws EASBizException, BOSException {
        return this.getDetailInfo(rpcMethodEvent.getContext(), rpcMethodEvent.getDetailMessage(), SystemStatusCtrolUtils.getCurrentPeriod((Context)rpcMethodEvent.getContext(), (SystemEnum)SystemEnum.FINANCE_LEASE, (CompanyOrgUnitInfo)rpcMethodEvent.getDetailMessage().get(0).getCompany()));
    }

    public NLMAccountBalanceDetailCollection getDetailInfo(Context ctx, FaDepreAndAmortCollection billInfo, PeriodInfo curPeriod) throws EASBizException, BOSException {
        NLMAccountBalanceDetailCollection nlmAccountBalanceDetailCollection = new NLMAccountBalanceDetailCollection();
        int j = billInfo.size();
        for (int i = 0; i < j; ++i) {
            NLMAccountBalanceDetailInfo detailInfo = new NLMAccountBalanceDetailInfo();
            FaDepreAndAmortInfo faDepreAndAmortInfo = billInfo.get(i);
            FaLeaseInBillNewInfo faLeaseInBillNewInfo = faDepreAndAmortInfo.getLeaseInBill();
            faLeaseInBillNewInfo = FaLeaseInBillNewFactory.getLocalInstance(ctx).getFaLeaseInBillNewInfo((IObjectPK)new ObjectUuidPK(faLeaseInBillNewInfo.getId().toString()));
            detailInfo.setId(BOSUuid.create((BOSObjectType)detailInfo.getBOSType()));
            detailInfo.setCompany(faDepreAndAmortInfo.getCompany());
            detailInfo.setCurrency(faLeaseInBillNewInfo.getCurrency());
            detailInfo.setPeriod(curPeriod);
            detailInfo.setNlmLeaseBillID(faLeaseInBillNewInfo.getId().toString());
            detailInfo.setNlmBillNumber(faLeaseInBillNewInfo.getNumber());
            detailInfo.setNlmBillContractCat(faLeaseInBillNewInfo.getContractCat());
            detailInfo.setNlmBillID(faDepreAndAmortInfo.getId().toString());
            detailInfo.setNlmBillType(NLMBillTypeEnum.DEP_BILL);
            detailInfo.setNlmBillSourceType(this.nlmBillSourceTypeEnum);
            detailInfo.setContractCatFieldName(this.nlmBillContractCatFieldNameEnums[0]);
            FaContractCatInfo faContractCatInfo = FaContractCatFactory.getLocalInstance((Context)ctx).getFaContractCatInfo((IObjectPK)new ObjectUuidPK(faLeaseInBillNewInfo.getContractCat().getId().toString()));
            detailInfo.setContractCatFieldValue((AccountViewInfo)faContractCatInfo.get(this.getContractCatFieldName(this.nlmBillContractCatFieldNameEnums[0])));
            detailInfo.setNlmBillGetFieldName(this.nlmBillFieldNameEnums[0]);
            detailInfo.setNlmBillGetFieldValue(faDepreAndAmortInfo.getMonthlyDepreAmt());
            detailInfo.setLendingDirection(LendingDirectionEnum.LOAN);
            detailInfo.setAccessType(AccessTypeEnum.AMOUNT_INCURRED);
            nlmAccountBalanceDetailCollection.add(detailInfo);
        }
        return nlmAccountBalanceDetailCollection;
    }

    protected String getContractCatFieldName(NLMBillContractCatFieldNameEnum nlmBillContractCatFieldNameEnum) {
        String result = "";
        if (nlmBillContractCatFieldNameEnum == NLMBillContractCatFieldNameEnum.USUFRUCT_ASSET_ACT) {
            result = "usufructAssetAcct";
        }
        if (nlmBillContractCatFieldNameEnum == NLMBillContractCatFieldNameEnum.USUFRUCT_ASSET_ACC_DEP) {
            result = "usufructAssetAcctACM";
        }
        if (nlmBillContractCatFieldNameEnum == NLMBillContractCatFieldNameEnum.USUFRUCT_ASSET_DEC_VALUE) {
            result = "usufructAssetAcctDEC";
        }
        return result;
    }
}

