/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app.fleventlistener.listener.strategy;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.basedata.FaContractCatFactory;
import com.kingdee.eas.fi.fa.basedata.FaContractCatInfo;
import com.kingdee.eas.fi.fa.manage.AccessTypeEnum;
import com.kingdee.eas.fi.fa.manage.FaLeaseInBillNewFactory;
import com.kingdee.eas.fi.fa.manage.FaLeaseInBillNewInfo;
import com.kingdee.eas.fi.fa.manage.FaTerminateBillEntryCollection;
import com.kingdee.eas.fi.fa.manage.FaTerminateBillEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaTerminateBillInfo;
import com.kingdee.eas.fi.fa.manage.LendingDirectionEnum;
import com.kingdee.eas.fi.fa.manage.NLMAccountBalanceDetailCollection;
import com.kingdee.eas.fi.fa.manage.NLMAccountBalanceDetailInfo;
import com.kingdee.eas.fi.fa.manage.NLMBillContractCatFieldNameEnum;
import com.kingdee.eas.fi.fa.manage.NLMBillFieldNameEnum;
import com.kingdee.eas.fi.fa.manage.NLMBillSourceTypeEnum;
import com.kingdee.eas.fi.fa.manage.NLMBillTypeEnum;
import com.kingdee.eas.fi.fa.manage.app.fleventlistener.event.RPCMethodEvent;
import com.kingdee.eas.framework.SystemEnum;
import java.math.BigDecimal;

public enum UpdateBalanceTableForTerminateBillEnum {
    COMPLETELYL_TERMINATION(NLMBillSourceTypeEnum.TER_COMPLETELYL_TERMINATION, new NLMBillFieldNameEnum[]{NLMBillFieldNameEnum.TERMINATE_BILL_TER_INIT_ASSET, NLMBillFieldNameEnum.TERMINATE_BILL_TER_ACC_DEP, NLMBillFieldNameEnum.TERMINATE_BILL_TER_DEC_VALUE}, new NLMBillContractCatFieldNameEnum[]{NLMBillContractCatFieldNameEnum.USUFRUCT_ASSET_ACT, NLMBillContractCatFieldNameEnum.USUFRUCT_ASSET_ACC_DEP, NLMBillContractCatFieldNameEnum.USUFRUCT_ASSET_DEC_VALUE}),
    EARLY_TERMINATION(NLMBillSourceTypeEnum.TER_EARLY_TERMINATION, new NLMBillFieldNameEnum[]{NLMBillFieldNameEnum.TERMINATE_BILL_TER_INIT_ASSET, NLMBillFieldNameEnum.TERMINATE_BILL_TER_ACC_DEP, NLMBillFieldNameEnum.TERMINATE_BILL_TER_DEC_VALUE}, new NLMBillContractCatFieldNameEnum[]{NLMBillContractCatFieldNameEnum.USUFRUCT_ASSET_ACT, NLMBillContractCatFieldNameEnum.USUFRUCT_ASSET_ACC_DEP, NLMBillContractCatFieldNameEnum.USUFRUCT_ASSET_DEC_VALUE}),
    FULL_TERMINATION(NLMBillSourceTypeEnum.TER_FULL_TERMINATION, new NLMBillFieldNameEnum[]{NLMBillFieldNameEnum.TERMINATE_BILL_TER_INIT_ASSET, NLMBillFieldNameEnum.TERMINATE_BILL_TER_ACC_DEP, NLMBillFieldNameEnum.TERMINATE_BILL_TER_DEC_VALUE}, new NLMBillContractCatFieldNameEnum[]{NLMBillContractCatFieldNameEnum.USUFRUCT_ASSET_ACT, NLMBillContractCatFieldNameEnum.USUFRUCT_ASSET_ACC_DEP, NLMBillContractCatFieldNameEnum.USUFRUCT_ASSET_DEC_VALUE}),
    RETROSPECT_TERMINATION(NLMBillSourceTypeEnum.TER_RETROSPECT_TERMINATION, new NLMBillFieldNameEnum[]{NLMBillFieldNameEnum.TERMINATE_BILL_TER_INIT_ASSET, NLMBillFieldNameEnum.TERMINATE_BILL_TER_ACC_DEP, NLMBillFieldNameEnum.TERMINATE_BILL_TER_DEC_VALUE, NLMBillFieldNameEnum.TERMINATE_BILL_TER_RETR_ACC_DEP, NLMBillFieldNameEnum.TERMINATE_BILL_TER_RETR_DEC_VALUE}, new NLMBillContractCatFieldNameEnum[]{NLMBillContractCatFieldNameEnum.USUFRUCT_ASSET_ACT, NLMBillContractCatFieldNameEnum.USUFRUCT_ASSET_ACC_DEP, NLMBillContractCatFieldNameEnum.USUFRUCT_ASSET_DEC_VALUE, NLMBillContractCatFieldNameEnum.USUFRUCT_ASSET_ACC_DEP, NLMBillContractCatFieldNameEnum.USUFRUCT_ASSET_DEC_VALUE});

    private final NLMBillSourceTypeEnum nlmBillSourceTypeEnum;
    private final NLMBillFieldNameEnum[] nlmBillFieldNameEnums;
    private final NLMBillContractCatFieldNameEnum[] nlmBillContractCatFieldNameEnums;

    private UpdateBalanceTableForTerminateBillEnum(NLMBillSourceTypeEnum nlmBillSourceTypeEnum, NLMBillFieldNameEnum[] nlmBillFieldNameEnums, NLMBillContractCatFieldNameEnum[] nlmBillContractCatFieldNameEnums) {
        this.nlmBillSourceTypeEnum = nlmBillSourceTypeEnum;
        this.nlmBillFieldNameEnums = nlmBillFieldNameEnums;
        this.nlmBillContractCatFieldNameEnums = nlmBillContractCatFieldNameEnums;
    }

    public NLMAccountBalanceDetailCollection getNLMAccountBalanceDetailCollection(RPCMethodEvent<FaTerminateBillInfo> rpcMethodEvent) throws EASBizException, BOSException {
        return this.getDetailInfo(rpcMethodEvent.getContext(), rpcMethodEvent.getDetailMessage(), SystemStatusCtrolUtils.getCurrentPeriod((Context)rpcMethodEvent.getContext(), (SystemEnum)SystemEnum.FINANCE_LEASE, (CompanyOrgUnitInfo)rpcMethodEvent.getDetailMessage().getCompany()));
    }

    public static UpdateBalanceTableForTerminateBillEnum getEnumAccordingToBillType(String billType) {
        UpdateBalanceTableForTerminateBillEnum[] enums;
        for (UpdateBalanceTableForTerminateBillEnum value : enums = UpdateBalanceTableForTerminateBillEnum.values()) {
            if (!billType.equals(value.name())) continue;
            return value;
        }
        return null;
    }

    public NLMAccountBalanceDetailCollection getDetailInfo(Context ctx, FaTerminateBillInfo billInfo, PeriodInfo curPeriod) throws EASBizException, BOSException {
        NLMAccountBalanceDetailCollection nlmAccountBalanceDetailCollection = new NLMAccountBalanceDetailCollection();
        FaTerminateBillEntryCollection entry = billInfo.getEntry();
        int j = entry.size();
        for (int i = 0; i < j; ++i) {
            FaTerminateBillEntryInfo faTerminateBillEntryInfo = entry.get(i);
            FaLeaseInBillNewInfo faLeaseInBillNewInfo = faTerminateBillEntryInfo.getLeaseInBill();
            faLeaseInBillNewInfo = FaLeaseInBillNewFactory.getLocalInstance(ctx).getFaLeaseInBillNewInfo((IObjectPK)new ObjectUuidPK(faLeaseInBillNewInfo.getId().toString()));
            int m = this.nlmBillFieldNameEnums.length;
            for (int n = 0; n < m; ++n) {
                NLMAccountBalanceDetailInfo detailInfo = new NLMAccountBalanceDetailInfo();
                detailInfo.setId(BOSUuid.create((BOSObjectType)detailInfo.getBOSType()));
                detailInfo.setCompany(billInfo.getCompany());
                detailInfo.setCurrency(faLeaseInBillNewInfo.getCurrency());
                detailInfo.setPeriod(curPeriod);
                detailInfo.setNlmLeaseBillID(faLeaseInBillNewInfo.getId().toString());
                detailInfo.setNlmBillNumber(faLeaseInBillNewInfo.getNumber());
                detailInfo.setNlmBillContractCat(faLeaseInBillNewInfo.getContractCat());
                detailInfo.setNlmBillID(billInfo.getId().toString());
                detailInfo.setNlmBillType(NLMBillTypeEnum.TERMINATE_BILL);
                detailInfo.setNlmBillSourceType(this.nlmBillSourceTypeEnum);
                detailInfo.setContractCatFieldName(this.nlmBillContractCatFieldNameEnums[n]);
                FaContractCatInfo faContractCatInfo = FaContractCatFactory.getLocalInstance((Context)ctx).getFaContractCatInfo((IObjectPK)new ObjectUuidPK(faLeaseInBillNewInfo.getContractCat().getId().toString()));
                detailInfo.setContractCatFieldValue((AccountViewInfo)faContractCatInfo.get(this.getContractCatFieldName(this.nlmBillContractCatFieldNameEnums[n])));
                detailInfo.setNlmBillGetFieldName(this.nlmBillFieldNameEnums[n]);
                detailInfo.setNlmBillGetFieldValue((BigDecimal)faTerminateBillEntryInfo.get(this.getNlmBillGetFieldName(this.nlmBillFieldNameEnums[n])));
                detailInfo.setLendingDirection(detailInfo.getContractCatFieldName() == NLMBillContractCatFieldNameEnum.USUFRUCT_ASSET_ACT ? LendingDirectionEnum.LOAN : LendingDirectionEnum.LEND);
                detailInfo.setAccessType(AccessTypeEnum.AMOUNT_INCURRED);
                nlmAccountBalanceDetailCollection.add(detailInfo);
            }
        }
        return nlmAccountBalanceDetailCollection;
    }

    protected String getContractCatFieldName(NLMBillContractCatFieldNameEnum nlmBillContractCatFieldNameEnum) {
        String result = "";
        if (nlmBillContractCatFieldNameEnum == NLMBillContractCatFieldNameEnum.USUFRUCT_ASSET_ACT) {
            result = "usufructAssetAcct";
        }
        if (nlmBillContractCatFieldNameEnum == NLMBillContractCatFieldNameEnum.USUFRUCT_ASSET_ACC_DEP) {
            result = "usufructAssetAcctACM";
        }
        if (nlmBillContractCatFieldNameEnum == NLMBillContractCatFieldNameEnum.USUFRUCT_ASSET_DEC_VALUE) {
            result = "usufructAssetAcctDEC";
        }
        return result;
    }

    protected String getNlmBillGetFieldName(NLMBillFieldNameEnum nlmBillFieldNameEnum) {
        String result = "";
        if (nlmBillFieldNameEnum == NLMBillFieldNameEnum.TERMINATE_BILL_TER_INIT_ASSET) {
            result = "terInitialAsset";
        }
        if (nlmBillFieldNameEnum == NLMBillFieldNameEnum.TERMINATE_BILL_TER_ACC_DEP) {
            result = "terAcumDepreAmt";
        }
        if (nlmBillFieldNameEnum == NLMBillFieldNameEnum.TERMINATE_BILL_TER_DEC_VALUE) {
            result = "terInitialAssetDecValue";
        }
        if (nlmBillFieldNameEnum == NLMBillFieldNameEnum.TERMINATE_BILL_TER_RETR_ACC_DEP) {
            result = "terRetrAcumDepreAmt";
        }
        if (nlmBillFieldNameEnum == NLMBillFieldNameEnum.TERMINATE_BILL_TER_RETR_DEC_VALUE) {
            result = "terRetrDecValue";
        }
        return result;
    }

    public NLMBillSourceTypeEnum getNlmBillSourceTypeEnum() {
        return this.nlmBillSourceTypeEnum;
    }
}

