/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app.periodclose;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.FaClearBillEntryFactory;
import com.kingdee.eas.fi.fa.manage.FaManageUtils;
import com.kingdee.eas.fi.fa.manage.IFaClearBillEntry;
import com.kingdee.eas.fi.fa.manage.app.periodclose.AbstractFaCheckBeforePeriodClose;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.util.HashMap;

public class FaClearBillCheckBeforePeriodClose
extends AbstractFaCheckBeforePeriodClose {
    @Override
    protected void checkBeforeCarrayForward(Context ctx, PeriodInfo period, CompanyOrgUnitInfo company, HashMap<String, Boolean> hmPara) throws BOSException, EASBizException {
        boolean isCheckVoucher = hmPara.get("isCheckVoucher");
        if (this.hasCleanCard(ctx, company, period, isCheckVoucher)) {
            throw new EASBizException(new NumericExceptionSubItem("1", this.getResource(ctx, "com.kingdee.eas.fi.fa.manage.FaPeriodClose", "forward_HasClean")));
        }
    }

    @Override
    protected void checkBeforeCarrayBack(Context ctx, PeriodInfo period, CompanyOrgUnitInfo company, HashMap<String, Boolean> hmPara) throws BOSException, EASBizException {
    }

    private boolean hasCleanCard(Context ctx, CompanyOrgUnitInfo company, PeriodInfo period, boolean notGenVoucher) throws BOSException, EASBizException {
        IFaClearBillEntry iclean = FaClearBillEntryFactory.getLocalInstance(ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("entry.period.id", (Object)period.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("entry.company.id", (Object)company.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("entry.checkedStatus", (Object)new Integer(2), CompareType.NOTEQUALS));
        filter.setMaskString("#0 and #1 and #2");
        boolean hasNotAudit = iclean.exists(filter);
        if (notGenVoucher) {
            String mask;
            filter.getFilterItems().add(new FilterItemInfo("entry.fiVouchered", (Object)"1", CompareType.NOTEQUALS));
            filter.getFilterItems().add(new FilterItemInfo("curCard.assetValue", (Object)new BigDecimal("0"), CompareType.NOTEQUALS));
            HashMap hmParam = FaManageUtils.getFAParameter(company.getId(), ctx);
            boolean isSplitOrCombineNoVourcher = "true".equals(hmParam.get("FA_048").toString());
            if (isSplitOrCombineNoVourcher) {
                filter.getFilterItems().add(new FilterItemInfo("entry.billtype", (Object)"1000", CompareType.NOTEQUALS));
                filter.getFilterItems().add(new FilterItemInfo("entry.billtype", (Object)"2000", CompareType.NOTEQUALS));
                filter.getFilterItems().add(new FilterItemInfo("entry.billtype", null, CompareType.EQUALS));
                mask = "#0 and #1 and (#2 or #3) and #4 and ((#5 and #6) or #7)";
                filter.setMaskString(mask);
            } else {
                mask = "#0 and #1 and (#2 or #3) and #4";
                filter.setMaskString(mask);
            }
            boolean hasVoucher = iclean.exists(filter);
            if (hasNotAudit && hasVoucher) {
                throw new EASBizException(new NumericExceptionSubItem("1", this.getResource(ctx, "com.kingdee.eas.fi.fa.manage.FaPeriodClose", "forward_NoAuditNoVoucher")), (Object[])new String[]{this.getResource(ctx, "com.kingdee.eas.fi.fa.manage.FaPeriodClose", "forward_ClearBill")});
            }
            if (!hasNotAudit && hasVoucher) {
                throw new EASBizException(new NumericExceptionSubItem("1", this.getResource(ctx, "com.kingdee.eas.fi.fa.manage.FaPeriodClose", "forward_HasClean_NoVoucher")));
            }
        }
        if (hasNotAudit) {
            throw new EASBizException(new NumericExceptionSubItem("1", this.getResource(ctx, "com.kingdee.eas.fi.fa.manage.FaPeriodClose", "forward_HasClean_NoAudit")));
        }
        return false;
    }
}

