/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app.periodclose;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.FaCurCardFactory;
import com.kingdee.eas.fi.fa.manage.FaManageUtils;
import com.kingdee.eas.fi.fa.manage.IFaCurCard;
import com.kingdee.eas.fi.fa.manage.app.FaLocalUtils;
import com.kingdee.eas.fi.fa.manage.app.periodclose.AbstractFaCheckBeforePeriodClose;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;

public class FaCurCardCheckBeforePeriodClose
extends AbstractFaCheckBeforePeriodClose {
    @Override
    protected void checkBeforeCarrayForward(Context ctx, PeriodInfo period, CompanyOrgUnitInfo company, HashMap<String, Boolean> hmPara) throws BOSException, EASBizException {
        boolean allowPassPeriodAudit;
        boolean isCheckVoucher = hmPara.get("isCheckVoucher");
        if (this.hasNewCard(ctx, company, period, isCheckVoucher, allowPassPeriodAudit = hmPara.get("allowPassPeriodAudit").booleanValue())) {
            throw new EASBizException(new NumericExceptionSubItem("1", this.getResource(ctx, "com.kingdee.eas.fi.fa.manage.FaPeriodClose", "forward_HasNewCard")));
        }
        if (this.hasNeedAuditPassPeriodCard(ctx, company, period, allowPassPeriodAudit)) {
            throw new EASBizException(new NumericExceptionSubItem("1", this.getResource(ctx, "com.kingdee.eas.fi.fa.manage.FaPeriodClose", "forward_HasPassPeriodNeedAuditCard")));
        }
    }

    @Override
    protected void checkBeforeCarrayBack(Context ctx, PeriodInfo period, CompanyOrgUnitInfo company, HashMap<String, Boolean> hmPara) throws BOSException, EASBizException {
    }

    private boolean hasNewCard(Context ctx, CompanyOrgUnitInfo company, PeriodInfo period, boolean notGenVoucher, boolean allowPassPeriodAudit) throws BOSException, EASBizException {
        IFaCurCard icard = FaCurCardFactory.getLocalInstance(ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("period", (Object)period.getId(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("company", (Object)company.getId(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("checkedStatus", (Object)new Integer(2), CompareType.NOTEQUALS));
        if (allowPassPeriodAudit) {
            filter.getFilterItems().add(new FilterItemInfo("fiAccountDate", null, CompareType.NOTEQUALS));
            filter.getFilterItems().add(new FilterItemInfo("period", (Object)period.getId(), CompareType.EQUALS));
        }
        boolean hasNotAudit = icard.exists(filter);
        if (notGenVoucher) {
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("period", (Object)period.getId(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("company", (Object)company.getId(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("checkedStatus", (Object)new Integer(2)));
            filter.getFilterItems().add(new FilterItemInfo("fiVouchered", (Object)"1", CompareType.NOTEQUALS));
            filter.getFilterItems().add(new FilterItemInfo("originFlag", (Object)new Integer(0), CompareType.NOTEQUALS));
            filter.getFilterItems().add(new FilterItemInfo("originFlag", (Object)new Integer(6), CompareType.NOTEQUALS));
            HashMap hmParam = FaManageUtils.getFAParameter(company.getId(), ctx);
            boolean isSplitOrCombineNoVourcher = "true".equals(hmParam.get("FA_048").toString());
            if (isSplitOrCombineNoVourcher) {
                filter.getFilterItems().add(new FilterItemInfo("originFlag", (Object)new Integer(2), CompareType.NOTEQUALS));
                filter.getFilterItems().add(new FilterItemInfo("originFlag", (Object)new Integer(3), CompareType.NOTEQUALS));
            }
            filter.getFilterItems().add(new FilterItemInfo("assetValue", (Object)new BigDecimal("0"), CompareType.NOTEQUALS));
            boolean hasVoucher = icard.exists(filter);
            if (hasNotAudit && hasVoucher) {
                throw new EASBizException(new NumericExceptionSubItem("1", this.getResource(ctx, "com.kingdee.eas.fi.fa.manage.FaPeriodClose", "forward_NoAuditNoVoucher")), (Object[])new String[]{this.getResource(ctx, "com.kingdee.eas.fi.fa.manage.FaPeriodClose", "forward_CurCard")});
            }
            if (hasVoucher) {
                throw new EASBizException(new NumericExceptionSubItem("1", this.getResource(ctx, "com.kingdee.eas.fi.fa.manage.FaPeriodClose", "forward_HasNewCard_NoVoucher")));
            }
        }
        if (hasNotAudit) {
            throw new EASBizException(new NumericExceptionSubItem("1", this.getResource(ctx, "com.kingdee.eas.fi.fa.manage.FaPeriodClose", "forward_HasNewCard_NoAudit")));
        }
        return false;
    }

    private boolean hasNeedAuditPassPeriodCard(Context ctx, CompanyOrgUnitInfo company, PeriodInfo period, boolean allowPassPeriodAudit) throws BOSException, EASBizException {
        IFaCurCard icard = FaCurCardFactory.getLocalInstance(ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("period.id", (Object)period.getId().toString(), CompareType.NOTEQUALS));
        HashSet laterPeriods = FaLocalUtils.getLaterPeriodIdSet(ctx, period.getId().toString());
        if (laterPeriods.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("period.id", (Object)laterPeriods, CompareType.NOTINCLUDE));
        }
        filter.getFilterItems().add(new FilterItemInfo("company", (Object)company.getId(), CompareType.EQUALS));
        if (allowPassPeriodAudit) {
            filter.getFilterItems().add(new FilterItemInfo("fiAccountDate", null, CompareType.NOTEQUALS));
            filter.getFilterItems().add(new FilterItemInfo("period", (Object)period.getId(), CompareType.EQUALS));
        }
        filter.getFilterItems().add(new FilterItemInfo("checkedStatus", (Object)new Integer(2), CompareType.NOTEQUALS));
        return icard.exists(filter);
    }
}

