/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app.provider;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.data.datasource.BOSQueryDataSource;
import com.kingdee.bos.ctrl.kdf.data.impl.BOSQueryDelegate;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.wssc.BillImageMapCollection;
import com.kingdee.eas.base.wssc.BillImageMapFactory;
import com.kingdee.eas.base.wssc.BillImageMapInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.FaBakCardInfo;
import com.kingdee.eas.fi.fa.manage.FaClearBillEntryCollection;
import com.kingdee.eas.fi.fa.manage.FaClearBillEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaClearBillFactory;
import com.kingdee.eas.fi.fa.manage.FaClearBillInfo;
import com.kingdee.eas.fi.fa.manage.FaManageUtils;
import com.kingdee.eas.fi.fa.manage.IFaClearBill;
import com.kingdee.eas.framework.BillEntryBaseInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.ColInfo;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.Enum;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.UIManager;
import org.apache.log4j.Logger;

public class FaClearBillPrintCardDataProvider
implements BOSQueryDelegate {
    Logger logger = Logger.getLogger(FaClearBillPrintCardDataProvider.class);
    private Context ctx = null;
    private Set ids = null;
    private IMetaDataPK qpk = null;
    private static final BigDecimal ZERO = new BigDecimal("0");
    private String companyId = null;
    private CompanyOrgUnitInfo companyInfo = null;
    private int currencyScale = 2;
    private HashMap faParameter = null;
    private IObjectCollection dataCollection;
    List allColumns = new ArrayList();
    static final String[] columsForClear = new String[]{"clrQty", "clrOriginal", "clrAddupDep", "clrDecPrep", "clrFare", "spilthMoveIn", "spilthIncome", "splithDeal", "comment", "curCard.id", "bizCard.id", "bizCard.faBakCard.assetCat.name", "bizCard.faBakCard.number", "bizCard.faBakCard.assetName", "bizCard.faBakCard.specs", "bizCard.faBakCard.measureUnit.name", "bizCard.faBakCard.assetAmt", "bizCard.faBakCard.assetValue", "bizCard.faBakCard.accuDepr", "bizCard.faBakCard.decValue", "bizCard.faBakCard.accountDate", "bizCard.faBakCard.deprTTerm"};

    public FaClearBillPrintCardDataProvider(Context ctx, List id, IMetaDataPK qpk) {
        this.ctx = ctx;
        this.ids = new HashSet(id);
        this.qpk = qpk;
    }

    public IRowSet execute(BOSQueryDataSource ds) {
        IRowSet iRowSet = null;
        try {
            if (this.faParameter == null || this.faParameter.size() == 0) {
                try {
                    this.faParameter = FaManageUtils.getFAParameter(this.ctx, new String[]{"FA_008"}, this.companyId);
                }
                catch (EASBizException e) {
                    this.logger.error((Object)e.getMessage(), (Throwable)e);
                }
                catch (BOSException e) {
                    this.logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            this.dataCollection = new CoreBaseCollection();
            Iterator itor = this.ids.iterator();
            IFaClearBill iFaClearBill = FaClearBillFactory.getLocalInstance(this.ctx);
            SelectorItemCollection selectors = this.getSelector();
            while (itor.hasNext()) {
                String id = (String)itor.next();
                FaClearBillInfo clearBillInfo = (FaClearBillInfo)iFaClearBill.getValue((IObjectPK)new ObjectUuidPK(id), selectors);
                if (clearBillInfo == null) continue;
                if (this.companyId == null) {
                    this.companyId = clearBillInfo.getCompany().getId().toString();
                }
                if (this.companyInfo == null) {
                    this.companyInfo = clearBillInfo.getCompany();
                }
                BigDecimal clrAssetValue = ZERO;
                BigDecimal clrNeatValue = ZERO;
                BigDecimal clrAccuDepr = ZERO;
                int currencyScale = -1;
                currencyScale = FaManageUtils.getCurrencyScale(clearBillInfo.getCompany().getBaseCurrency().getId(), this.ctx);
                if (clearBillInfo.getClearBillEntry() != null && clearBillInfo.getClearBillEntry().size() > 0) {
                    for (int j = 0; j < clearBillInfo.getClearBillEntry().size(); ++j) {
                        BigDecimal cellClrAccuDepr;
                        BigDecimal cellAssetValue = clearBillInfo.getClearBillEntry().get(j).getClrOriginal() == null ? ZERO : clearBillInfo.getClearBillEntry().get(j).getClrOriginal();
                        BigDecimal cellInitEvalValue = clearBillInfo.getClearBillEntry().get(j).getClrEvalValue() == null ? ZERO : clearBillInfo.getClearBillEntry().get(j).getClrEvalValue();
                        boolean isEvaledBefore = clearBillInfo.getClearBillEntry().get(j).getCurCard().isIsEvaledBefore();
                        boolean calcuByEvaluate = clearBillInfo.getClearBillEntry().get(j).getCurCard().getAssetCat().isCalcuByEvaluate();
                        isEvaledBefore = isEvaledBefore && calcuByEvaluate;
                        BigDecimal bigDecimal = cellClrAccuDepr = clearBillInfo.getClearBillEntry().get(j).getClrAddupDep() == null ? ZERO : clearBillInfo.getClearBillEntry().get(j).getClrAddupDep();
                        if (isEvaledBefore) {
                            BigDecimal assetAmt = new BigDecimal(clearBillInfo.getClearBillEntry().get(j).getBizCard().getFaBakCard().getAssetAmt().toString());
                            BigDecimal quantity = new BigDecimal(clearBillInfo.getClearBillEntry().get(j).getClrQty() == null ? "0" : clearBillInfo.getClearBillEntry().get(j).getClrQty().toString());
                            cellInitEvalValue = cellInitEvalValue.multiply(quantity).divide(assetAmt, currencyScale, 4);
                        }
                        clrAssetValue = clrAssetValue.add(cellAssetValue);
                        clrNeatValue = clrNeatValue.add(isEvaledBefore ? cellInitEvalValue.subtract(cellClrAccuDepr) : cellAssetValue.subtract(cellClrAccuDepr));
                        clrAccuDepr = clrAccuDepr.add(cellClrAccuDepr);
                    }
                }
                clearBillInfo.put("assetValueTotal", FaClearBillPrintCardDataProvider.formatDecimal(clrAssetValue, currencyScale));
                clearBillInfo.put("neatValueTotal", FaClearBillPrintCardDataProvider.formatDecimal(clrNeatValue, currencyScale));
                clearBillInfo.put("accuDeprTotal", FaClearBillPrintCardDataProvider.formatDecimal(clrAccuDepr, currencyScale));
                String[] formatColumns = new String[]{"clrOriginal", "clrAddupDep", "clrDecPrep", "clrFare", "spilthMoveIn", "spilthIncome", "clrEvalValue", "price"};
                int quantityScale = Integer.valueOf(this.faParameter.get("FA_008") == null ? "0" : (String)this.faParameter.get("FA_008"));
                FaClearBillEntryCollection faClearBillEntryCollection = clearBillInfo.getClearBillEntry();
                for (int j = 0; j < faClearBillEntryCollection.size(); ++j) {
                    FaBakCardInfo faBakCardInfo;
                    FaClearBillEntryInfo faBillEntryInfo = faClearBillEntryCollection.get(j);
                    if (faBillEntryInfo == null) continue;
                    this.dealNumricalPrint(faBillEntryInfo, formatColumns, currencyScale);
                    this.dealNumricalPrint(faBillEntryInfo, new String[]{"clrQty"}, quantityScale);
                    if (faBillEntryInfo.getBizCard() == null || (faBakCardInfo = faBillEntryInfo.getBizCard().getFaBakCard()) == null || faBakCardInfo.getAssetAmt() == null) continue;
                    faBakCardInfo.setAssetAmt(faBakCardInfo.getAssetAmt().setScale(quantityScale, 4));
                }
                this.dataCollection.appendObject((IObjectValue)clearBillInfo);
            }
            if (this.dataCollection != null && this.dataCollection.size() == 1) {
                IObjectValue obj = this.dataCollection.getObject(0);
                List column = this.getAllKey(obj, "");
                column = this.beforeBuildColumn(column);
                iRowSet = this.buildRowSet(column);
            } else if (this.dataCollection != null && this.dataCollection.size() > 1) {
                List column = this.putAllFieldsInColumn();
                column = this.beforeBuildColumn(column);
                iRowSet = this.buildRowSet(column);
            } else {
                return iRowSet;
            }
            iRowSet.beforeFirst();
            for (int i = 0; i < this.dataCollection.size(); ++i) {
                IObjectValue obj = this.dataCollection.getObject(i);
                iRowSet.moveToInsertRow();
                this.clearRow(iRowSet);
                FaClearBillInfo info = (FaClearBillInfo)obj;
                this.insertRowFromInfo(obj, iRowSet, "");
                this.afterHeadFill(iRowSet, obj);
                this.insertRowFromInfo(iRowSet, columsForClear, obj, "clearBillEntry", info);
            }
            iRowSet.beforeFirst();
        }
        catch (Exception ex) {
            this.logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
        return iRowSet;
    }

    private static String formatDecimal(BigDecimal val, int scale) {
        DecimalFormat decimalFormat = new DecimalFormat();
        decimalFormat.applyPattern(FaClearBillPrintCardDataProvider.getFormatPattern(scale));
        return decimalFormat.format(val.setScale(scale, 4));
    }

    public static NumberFormat getDecimalFormat() {
        Object obj = UIManager.get("decimalFormat");
        if (obj != null) {
            if (obj instanceof DecimalFormat) {
                ((DecimalFormat)obj).setDecimalFormatSymbols(FaClearBillPrintCardDataProvider.getDecimalFormatSymbols());
            }
            return (NumberFormat)obj;
        }
        return null;
    }

    public static DecimalFormatSymbols getDecimalFormatSymbols() {
        Object obj = UIManager.get("decimalFormatSymbols");
        if (obj != null) {
            return (DecimalFormatSymbols)obj;
        }
        return new DecimalFormatSymbols();
    }

    private static String getFormatPattern(int scale) {
        String pattern = null;
        switch (scale) {
            case 0: {
                pattern = "#,##0";
                break;
            }
            case 1: {
                pattern = "#,##0.0";
                break;
            }
            case 2: {
                pattern = "#,##0.00";
                break;
            }
            case 3: {
                pattern = "#,##0.000";
                break;
            }
            case 4: {
                pattern = "#,##0.0000";
                break;
            }
            default: {
                StringBuffer buf = new StringBuffer("#,##0.00000");
                for (int i = 5; i < scale; ++i) {
                    buf.append("0");
                }
                pattern = buf.toString();
            }
        }
        return pattern;
    }

    private void dealNumricalPrint(BillEntryBaseInfo billEntryBaseInfo, String[] param, int scale) {
        try {
            for (int i = 0; i < param.length; ++i) {
                if (billEntryBaseInfo.get(param[i]) == null) continue;
                BigDecimal bigDecimal = (BigDecimal)billEntryBaseInfo.get(param[i]);
                billEntryBaseInfo.setBigDecimal(param[i], bigDecimal.setScale(scale, 4));
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e);
        }
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("number"));
        selectors.add(new SelectorItemInfo("description"));
        selectors.add(new SelectorItemInfo("clearDate"));
        selectors.add(new SelectorItemInfo("clearMode.name"));
        selectors.add(new SelectorItemInfo("handler.name"));
        selectors.add(new SelectorItemInfo("auditor.name"));
        selectors.add(new SelectorItemInfo("bizDate"));
        selectors.add(new SelectorItemInfo("createTime"));
        selectors.add(new SelectorItemInfo("company.id"));
        selectors.add(new SelectorItemInfo("company.name"));
        selectors.add(new SelectorItemInfo("company.number"));
        selectors.add(new SelectorItemInfo("company.baseCurrency.precision"));
        selectors.add(new SelectorItemInfo("company.baseCurrency.id"));
        selectors.add(new SelectorItemInfo("clearBillEntry.clrQty"));
        selectors.add(new SelectorItemInfo("clearBillEntry.clrOriginal"));
        selectors.add(new SelectorItemInfo("clearBillEntry.clrAddupDep"));
        selectors.add(new SelectorItemInfo("clearBillEntry.clrDecPrep"));
        selectors.add(new SelectorItemInfo("clearBillEntry.clrFare"));
        selectors.add(new SelectorItemInfo("clearBillEntry.clrEvalValue"));
        selectors.add(new SelectorItemInfo("clearBillEntry.splithDeal"));
        selectors.add(new SelectorItemInfo("clearBillEntry.spilthMoveIn"));
        selectors.add(new SelectorItemInfo("clearBillEntry.price"));
        selectors.add(new SelectorItemInfo("clearBillEntry.spilthIncome"));
        selectors.add(new SelectorItemInfo("clearBillEntry.comment"));
        selectors.add(new SelectorItemInfo("clearBillEntry.bizCard.faBakCard.assetcat.name"));
        selectors.add(new SelectorItemInfo("clearBillEntry.bizCard.faBakCard.number"));
        selectors.add(new SelectorItemInfo("clearBillEntry.bizCard.faBakCard.assetAmt"));
        selectors.add(new SelectorItemInfo("clearBillEntry.bizCard.faBakCard.assetname"));
        selectors.add(new SelectorItemInfo("clearBillEntry.bizCard.faBakCard.specs"));
        selectors.add(new SelectorItemInfo("clearBillEntry.bizCard.faBakCard.measureunit.name"));
        selectors.add(new SelectorItemInfo("clearBillEntry.bizCard.faBakCard.assetValue"));
        selectors.add(new SelectorItemInfo("clearBillEntry.bizCard.faBakCard.accuDepr"));
        selectors.add(new SelectorItemInfo("clearBillEntry.bizCard.faBakCard.decValue"));
        selectors.add(new SelectorItemInfo("clearBillEntry.bizCard.faBakCard.accountDate"));
        selectors.add(new SelectorItemInfo("clearBillEntry.bizCard.faBakCard.deprTTerm"));
        selectors.add(new SelectorItemInfo("clearBillEntry.bizCard.faBakCard.initEvalValue"));
        selectors.add(new SelectorItemInfo("clearBillEntry.curCard.assetValue"));
        selectors.add(new SelectorItemInfo("clearBillEntry.curCard.isEvaledBefore"));
        selectors.add(new SelectorItemInfo("clearBillEntry.curCard.assetCat.calcuByEvaluate"));
        selectors.add(new SelectorItemInfo("clearBillEntry.curCard.accuDepr"));
        selectors.add(new SelectorItemInfo("assetValueTotal"));
        selectors.add(new SelectorItemInfo("neatValueTotal"));
        selectors.add(new SelectorItemInfo("accuDeprTotal"));
        return selectors;
    }

    protected ArrayList getAllKey(IObjectValue sourceInfo, String upper) {
        ArrayList<String> result = new ArrayList<String>();
        Enumeration enumKeys = sourceInfo.keys();
        while (enumKeys.hasMoreElements()) {
            String key = enumKeys.nextElement().toString();
            Object info = sourceInfo.get(key);
            if (info instanceof IObjectCollection) {
                IObjectCollection collection = (IObjectCollection)info;
                if (collection.size() <= 0) continue;
                AbstractObjectValue baseInfo = (AbstractObjectValue)collection.getObject(0);
                if (this.hasSameKey(upper, key)) continue;
                result.addAll(this.getAllKey((IObjectValue)baseInfo, upper + key + "."));
                continue;
            }
            if (info instanceof IObjectValue) {
                if (this.hasSameKey(upper, key)) continue;
                IObjectValue baseInfo = (IObjectValue)info;
                result.addAll(this.getAllKey(baseInfo, upper + key + "."));
                continue;
            }
            result.add(upper + key);
        }
        return result;
    }

    protected boolean hasSameKey(String srcString, String key) {
        if (srcString == null || key == null) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(srcString, ".");
        while (st.hasMoreTokens()) {
            if (!st.nextToken().equalsIgnoreCase(key)) continue;
            return true;
        }
        return false;
    }

    protected List beforeBuildColumn(List columns) {
        if (!columns.contains("operator")) {
            columns.add("operator");
        }
        if (!columns.contains("printdate")) {
            columns.add("printdate");
        }
        if (!columns.contains("imageNumber")) {
            columns.add("imageNumber");
        }
        return columns;
    }

    protected IRowSet buildRowSet(List columns) throws Exception {
        this.allColumns = columns;
        DynamicRowSet rs = new DynamicRowSet(columns.size());
        for (int i = 0; i < columns.size(); ++i) {
            String values = (String)columns.get(i);
            ColInfo ci = new ColInfo();
            ci.colType = 12;
            ci.columnName = values;
            rs.setColInfo(i + 1, ci);
        }
        return rs;
    }

    private ArrayList putAllFieldsInColumn() {
        HashSet<String> set = new HashSet<String>();
        for (IObjectValue obj : this.dataCollection) {
            ArrayList column = this.getAllKey(obj, "");
            Iterator iterB = column.iterator();
            while (iterB.hasNext()) {
                set.add((String)iterB.next());
            }
        }
        ArrayList<String> result = new ArrayList<String>();
        if (set != null && set.size() != 0) {
            Iterator iter = set.iterator();
            while (iter.hasNext()) {
                result.add((String)iter.next());
            }
        }
        return result;
    }

    protected void clearRow(IRowSet rs) throws Exception {
        int n = rs.getRowSetMetaData().getColumnCount();
        for (int i = 1; i <= n; ++i) {
            rs.updateObject(i, (Object)"");
        }
    }

    protected void insertRowFromInfo(IObjectValue sourceInfo, IRowSet rs, String upper) throws Exception {
        Enumeration enumKeys = sourceInfo.keys();
        while (enumKeys.hasMoreElements()) {
            String key = enumKeys.nextElement().toString();
            Object info = sourceInfo.get(key);
            if (info == null) continue;
            if (info instanceof IObjectCollection) {
                this.logger.info((Object)"do nothing");
                continue;
            }
            if (info instanceof IObjectValue) {
                if (this.hasSameKey(upper, key)) continue;
                IObjectValue baseInfo = (IObjectValue)info;
                this.insertRowFromInfo(baseInfo, rs, upper + key + ".");
                continue;
            }
            try {
                rs.updateString(upper + key, this.convertObject(info));
            }
            catch (Exception ex) {
                this.logger.error((Object)("insertRowFromInfo(IObjectValue sourceInfo, IRowSet rs, String upper)--" + upper + key));
                this.logger.error((Object)ex);
            }
        }
    }

    protected String convertObject(Object o) {
        if (o == null) {
            return "";
        }
        if (o instanceof Date) {
            return DateTimeUtils.format((Date)((Date)o), (String)"yyyy-MM-dd");
        }
        if (o instanceof Enum) {
            return ((Enum)o).getAlias();
        }
        return o.toString();
    }

    protected void afterHeadFill(IRowSet rs, IObjectValue sourceInfo) throws Exception {
        FaClearBillInfo info = (FaClearBillInfo)sourceInfo;
        rs.updateString("printdate", FaClearBillPrintCardDataProvider.transDateToStr((Date)info.get("printdate")));
        rs.updateString("cleardate", FaClearBillPrintCardDataProvider.transDateToStr(info.getClearDate()));
        rs.updateString("createtime", FaClearBillPrintCardDataProvider.transDateToStr(info.getCreateTime()));
        rs.updateString("bizdate", FaClearBillPrintCardDataProvider.transDateToStr(info.getBizDate()));
        String imageNumber = this.getImageNumber(new FaClearBillInfo().getBOSType().toString(), info.getId().toString());
        rs.updateString("imageNumber", imageNumber);
    }

    private static String transDateToStr(Date date) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        return dateFormat.format(date);
    }

    private String getImageNumber(String bosType, String billID) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("bosType", (Object)bosType));
        filter.getFilterItems().add(new FilterItemInfo("billID", (Object)billID));
        BillImageMapCollection billImageMapCollection = BillImageMapFactory.getLocalInstance((Context)this.ctx).getBillImageMapCollection(view);
        if (billImageMapCollection != null && billImageMapCollection.size() > 0) {
            BillImageMapInfo billImageMapInfo = billImageMapCollection.get(0);
            return billImageMapInfo.getImageNumber();
        }
        return "";
    }

    protected void insertRowFromInfo(IRowSet rs, String[] columns, IObjectValue sourceInfo, String key, FaClearBillInfo billInfo) throws Exception {
        IObjectCollection collection = (IObjectCollection)sourceInfo.get(key);
        if (collection == null) {
            return;
        }
        if (collection.size() == 0) {
            rs.insertRow();
        }
        for (int count = 0; count < collection.size(); ++count) {
            IObjectValue obj = collection.getObject(count);
            if (count != 0) {
                rs.moveToInsertRow();
                this.clearRow(rs);
                this.insertRowFromInfo(sourceInfo, rs, "");
                this.afterHeadFill(rs, sourceInfo);
            }
            this.updateRowFromInfo(rs, columns, obj, key, billInfo);
            rs.insertRow();
        }
    }

    protected void updateRowFromInfo(IRowSet rs, String[] columns, IObjectValue sourceInfo, String key, FaClearBillInfo billInfo) throws Exception {
        int n = columns.length;
        for (int i = 0; i < n; ++i) {
            if (columns[i] == null || "".equals(columns[i])) continue;
            String[] subItems = StringUtils.split((String)columns[i], (String)".");
            IObjectValue subObj = sourceInfo;
            int l = subItems.length - 1;
            for (int k = 0; k < l && (subObj = (IObjectValue)subObj.get(subItems[k].toLowerCase())) != null; ++k) {
            }
            if (subObj == null) continue;
            try {
                rs.updateString(key.equals("") ? columns[i] : key + "." + columns[i].toLowerCase(), this.convertObject(subObj.get(subItems[subItems.length - 1])));
                continue;
            }
            catch (Exception ex) {
                this.logger.error((Object)("updateRowFromInfo(IRowSet rs, String[] columns, IObjectValue sourceInfo, String key)--" + new String(key.equals("") ? columns[i] : key + "." + columns[i].toLowerCase())));
                this.logger.error((Object)ex);
            }
        }
        this.afterDetailFill(rs, sourceInfo, billInfo);
    }

    protected void afterDetailFill(IRowSet rs, IObjectValue sourceInfo, FaClearBillInfo billInfo) throws Exception {
        FaClearBillEntryInfo info = (FaClearBillEntryInfo)sourceInfo;
        if (info != null && info.getSplithDeal() != null) {
            rs.updateString("clearBillEntry.splithDeal", info.getSplithDeal().toString());
        }
        if (info.getClrOriginal() != null) {
            rs.updateString("clearbillentry.clroriginal", FaClearBillPrintCardDataProvider.transBigDecimalToStr(info.getClrOriginal()));
        }
        if (info.getClrAddupDep() != null) {
            rs.updateString("clearbillentry.clraddupdep", FaClearBillPrintCardDataProvider.transBigDecimalToStr(info.getClrAddupDep()));
        }
        if (info.getClrDecPrep() != null) {
            rs.updateString("clearbillentry.clrdecprep", FaClearBillPrintCardDataProvider.transBigDecimalToStr(info.getClrDecPrep()));
        }
        if (info.getClrFare() != null) {
            rs.updateString("clearbillentry.clrfare", FaClearBillPrintCardDataProvider.transBigDecimalToStr(info.getClrFare()));
        }
        if (info.getSpilthMoveIn() != null) {
            rs.updateString("clearbillentry.spilthmovein", FaClearBillPrintCardDataProvider.transBigDecimalToStr(info.getSpilthMoveIn()));
        }
        if (info.getSpilthIncome() != null) {
            rs.updateString("clearbillentry.spilthincome", FaClearBillPrintCardDataProvider.transBigDecimalToStr(info.getSpilthIncome()));
        }
    }

    private static String transBigDecimalToStr(BigDecimal val) {
        String pattern = null;
        if (val == null) {
            return null;
        }
        int scale = val.scale();
        switch (scale) {
            case 0: {
                pattern = "#,##0";
                break;
            }
            case 1: {
                pattern = "#,##0.0";
                break;
            }
            case 2: {
                pattern = "#,##0.00";
                break;
            }
            case 3: {
                pattern = "#,##0.000";
                break;
            }
            case 4: {
                pattern = "#,##0.0000";
                break;
            }
            default: {
                StringBuffer buf = new StringBuffer("#,##0.00000");
                for (int i = 5; i < scale; ++i) {
                    buf.append("0");
                }
                pattern = buf.toString();
            }
        }
        DecimalFormat decimalFormat = new DecimalFormat();
        decimalFormat.applyPattern(pattern);
        return decimalFormat.format(val);
    }
}

