/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.excelUtils;

import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.excelUtils.ExcelUtil;
import com.kingdee.eas.fi.fa.manage.excelUtils.ExcelUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class Excel2003Util
implements Serializable,
ExcelUtils {
    protected HSSFWorkbook workBook = null;
    protected HSSFSheet sheet = null;
    protected int rowCount = 0;
    protected int colCount = 0;
    protected InputStream fis = null;

    private Excel2003Util() {
    }

    public Excel2003Util(String fileName, String sheetName) throws Exception {
        if (StringUtils.isEmpty((String)fileName)) {
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"254_Excel2003Util")});
        }
        this.fis = new FileInputStream(new File(fileName));
        this.workBook = new HSSFWorkbook(this.fis);
        this.sheet = StringUtils.isEmpty((String)sheetName) ? this.workBook.getSheetAt(0) : this.workBook.getSheet(sheetName);
        if (this.sheet == null) {
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"255_Excel2003Util")});
        }
        this.rowCount = this.sheet.getLastRowNum() - this.sheet.getFirstRowNum() + 1;
        this.colCount = this.sheet.getRow(0).getLastCellNum();
    }

    @Override
    public String getCellData(int rowNum, int colNum) {
        if (rowNum >= this.rowCount || this.sheet.getRow(rowNum) == null || colNum >= this.colCount) {
            return "";
        }
        HSSFRow row = this.sheet.getRow(rowNum);
        HSSFCell cell = row.getCell(colNum);
        return ExcelUtil.getCellValue(cell);
    }

    @Override
    public int getRowCount() {
        return this.rowCount;
    }

    @Override
    public int getColCount() {
        return this.colCount;
    }

    public void close() throws Exception {
        try {
            if (this.fis != null) {
                this.fis.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

