/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.excelUtils;

import com.kingdee.bos.ctrl.common.GlobalLocator;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.xssf.usermodel.XSSFCell;

public class ExcelUtil {
    public static void showFile(String fileName) throws IOException {
        String os = System.getProperty("os.name");
        String[] cmd = null;
        if (os.toLowerCase(Locale.ENGLISH).startsWith("win")) {
            File f = GlobalLocator.getInstance().locateResourceFile("/client/LanchFile.bat");
            if (f != null) {
                cmd = new String[]{"\"" + f.getAbsolutePath() + "\"", "\"excel\"", "\"" + fileName + "\""};
            }
        } else {
            cmd = os.toLowerCase(Locale.ENGLISH).startsWith("mac") ? new String[]{"open", fileName} : new String[]{"xdg-open", fileName};
        }
        if (cmd == null) {
            throw new IOException();
        }
        Runtime.getRuntime().exec(cmd);
    }

    public static String getCellValue(HSSFCell cell) {
        if (cell == null) {
            return "";
        }
        switch (cell.getCellType()) {
            case STRING: {
                return cell.getStringCellValue() == null ? "" : cell.getStringCellValue().trim();
            }
            case NUMERIC: {
                double d = cell.getNumericCellValue();
                if (HSSFDateUtil.isCellDateFormatted((Cell)cell)) {
                    Date cal = HSSFDateUtil.getJavaDate((double)d);
                    return ExcelUtil.getStringByDate(cal);
                }
                BigDecimal bd = new BigDecimal(new Double(d).toString());
                String s = bd.toString();
                if (s.endsWith(".0")) {
                    s = s.substring(0, s.length() - 2);
                }
                return s;
            }
            case FORMULA: {
                String valueStr = null;
                valueStr = cell.getStringCellValue();
                if (valueStr != null && valueStr.trim().length() > 0) {
                    return valueStr.trim();
                }
                double value = cell.getNumericCellValue();
                BigDecimal bd = new BigDecimal(new Double(value).toString());
                valueStr = bd.toString();
                if (valueStr.endsWith(".0")) {
                    valueStr = valueStr.substring(0, valueStr.length() - 2);
                }
                return valueStr;
            }
            case BOOLEAN: {
                return String.valueOf(cell.getBooleanCellValue());
            }
            case BLANK: {
                return "";
            }
        }
        return cell.getStringCellValue() == null ? "" : cell.getStringCellValue().trim();
    }

    public static String getCellValue(XSSFCell cell) {
        if (cell == null) {
            return "";
        }
        switch (cell.getCellType()) {
            case STRING: {
                return cell.getStringCellValue() == null ? "" : cell.getStringCellValue().trim();
            }
            case NUMERIC: {
                double d = cell.getNumericCellValue();
                if (HSSFDateUtil.isCellDateFormatted((Cell)cell)) {
                    Date cal = HSSFDateUtil.getJavaDate((double)d);
                    return ExcelUtil.getStringByDate(cal);
                }
                BigDecimal bd = new BigDecimal(new Double(d).toString());
                String s = bd.toString();
                if (s.endsWith(".0")) {
                    s = s.substring(0, s.length() - 2);
                }
                return s;
            }
            case FORMULA: {
                String valueStr = null;
                valueStr = cell.getStringCellValue();
                if (valueStr != null && valueStr.trim().length() > 0) {
                    return valueStr.trim();
                }
                double value = cell.getNumericCellValue();
                BigDecimal bd = new BigDecimal(new Double(value).toString());
                valueStr = bd.toString();
                if (valueStr.endsWith(".0")) {
                    valueStr = valueStr.substring(0, valueStr.length() - 2);
                }
                return valueStr;
            }
            case BOOLEAN: {
                return String.valueOf(cell.getBooleanCellValue());
            }
            case BLANK: {
                return "";
            }
        }
        return cell.getStringCellValue() == null ? "" : cell.getStringCellValue().trim();
    }

    private static String getStringByDate(Date d) {
        Calendar cl = Calendar.getInstance();
        cl.setTime(d);
        String fix = "-";
        StringBuffer dateStr = new StringBuffer();
        dateStr.append(cl.get(1));
        dateStr.append(fix);
        int month = cl.get(2) + 1;
        if (month < 10) {
            dateStr.append("0");
        }
        dateStr.append(month);
        dateStr.append(fix);
        int day = cl.get(5);
        if (day < 10) {
            dateStr.append("0");
        }
        dateStr.append(day);
        return dateStr.toString();
    }
}

