;//chapter1	EBI controller
EBIPR      EQU						0x48800000	;//Bus priority decision
BANK_CFG   EQU           0x48800004	;//Bank Configuration 


;;//chapter3 MOBILE DRAM CONTROLLER
BANKCFG    EQU           0x48000000	;;//Mobile DRAM configuration
BANKCON1    EQU           0x48000004	;;//Mobile DRAM control 
BANKCON2    EQU           0x48000008	;;//Mobile DRAM timing control 
BANKCON3    EQU           0x4800000C	;;//Mobile DRAM (E)MRS 
REFRESH    EQU           0x48000010	;;//Mobile DRAM refresh control
TIMEOUT    EQU           0x48000014	;;//Write Buffer Time out control 


;//chapter4 SSMC
SMBIDCYR0   EQU           0x4F000000	;//Bank0 idle cycle control 
SMBIDCYR1   EQU           0x4F000020	;//Bank1 idle cycle control 
SMBIDCYR2   EQU           0x4F000040	;//Bank2 idle cycle control 
SMBIDCYR3   EQU           0x4F000060	;//Bank3 idle cycle control 
SMBIDCYR4   EQU           0x4F000080	;//Bank0 idle cycle control 
SMBIDCYR5   EQU           0x4F0000A0	;//Bank5 idle cycle control 
SMBWSTRDR0  EQU           0x4F000004	;//Bank0 read wait state control 
SMBWSTRDR1  EQU           0x4F000024	;//Bank1 read wait state control
SMBWSTRDR2  EQU           0x4F000044	;//Bank2 read wait state control
SMBWSTRDR3  EQU           0x4F000064	;//Bank3 read wait state control 
SMBWSTRDR4  EQU           0x4F000084	;//Bank4 read wait state control 
SMBWSTRDR5  EQU           0x4F0000A4	;//Bank5 read wait state control 
SMBWSTWRR0  EQU           0x4F000008	;//Bank0 write wait state control 
SMBWSTWRR1  EQU           0x4F000028	;//Bank1 write wait state control 
SMBWSTWRR2  EQU           0x4F000048	;//Bank2 write wait state control 
SMBWSTWRR3  EQU           0x4F000068	;//Bank3 write wait state control 
SMBWSTWRR4  EQU           0x4F000088	;//Bank4 write wait state control 
SMBWSTWRR5  EQU           0x4F0000A8	;//Bank5 write wait state control 
SMBWSTOENR0 EQU           0x4F00000C	;//Bank0 output enable assertion delay control 
SMBWSTOENR1 EQU           0x4F00002C	;//Bank1 output enable assertion delay control 
SMBWSTOENR2 EQU           0x4F00004C	;//Bank2 output enable assertion delay control
SMBWSTOENR3 EQU           0x4F00006C	;//Bank3 output enable assertion delay control 
SMBWSTOENR4 EQU           0x4F00008C	;//Bank4 output enable assertion delay control
SMBWSTOENR5 EQU           0x4F0000AC	;//Bank5 output enable assertion delay control 
SMBWSTWENR0 EQU           0x4F000010	;//Bank0 write enable assertion delay control 
SMBWSTWENR1 EQU           0x4F000030	;//Bank1 write enable assertion delay control 
SMBWSTWENR2 EQU           0x4F000050	;//Bank2 write enable assertion delay control 
SMBWSTWENR3 EQU           0x4F000070	;//Bank3 write enable assertion delay control 
SMBWSTWENR4 EQU           0x4F000090	;//Bank4 write enable assertion delay control 
SMBWSTWENR5 EQU           0x4F0000B0	;//Bank5 write enable assertion delay control 
SMBCR0      EQU           0x4F000014	;//Bank0 control 
SMBCR1      EQU           0x4F000034	;//Bank1 control 
SMBCR2      EQU           0x4F000054	;//Bank2 control 
SMBCR3      EQU           0x4F000074	;//Bank3 control 
SMBCR4      EQU           0x4F000094	;//Bank4 control 
SMBCR5      EQU           0x4F0000B4	;//Bank5 control 
SMBSR0      EQU           0x4F000018	;//Bank0 status 
SMBSR1      EQU           0x4F000038	;//Bank1 status 
SMBSR2      EQU           0x4F000058	;//Bank2 status 
SMBSR3      EQU           0x4F000078	;//Bank3 status 
SMBSR4      EQU           0x4F000098	;//Bank4 status 
SMBSR5      EQU           0x4F0000B8	;//Bank5 status 
SMBWSTBRDR0 EQU           0x4F00001C	;//Bank0 burst read wait delay control 
SMBWSTBRDR1 EQU           0x4F00003C	;//Bank1 burst read wait delay control 
SMBWSTBRDR2 EQU           0x4F00005C	;//Bank2 burst read wait delay control 
SMBWSTBRDR3 EQU           0x4F00007C	;//Bank3 burst read wait delay control 
SMBWSTBRDR4 EQU           0x4F00009C	;//Bank4 burst read wait delay control 
SMBWSTBRDR5 EQU           0x4F0000BC	;//Bank5 burst read wait delay control 
SSMCSR      EQU           0x4F000200	;//SROMC status 
SSMCCR      EQU           0x4F000204	;//SROMC control 


;//chapter5 Nand Flash
NFCONF		  EQU           0x4E000000		  ;//NAND Flash configuration
NFCONT		  EQU           0x4E000004      ;//NAND Flash control
NFCMD		  EQU           0x4E000008      ;//NAND Flash command 
NFADDR		  EQU           0x4E00000C      ;//NAND Flash address
NFDATA		  EQU           0x4E000010      ;//NAND Flash data                         
NFMECCD0	  EQU           0x4E000014      ;//NAND Flash ECC for Main 
NFMECCD1	  EQU           0x4E000018      ;//NAND Flash ECC for Main 
NFSECCD	  EQU           0x4E00001C	  	;//NAND Flash ECC for Spare Area
NFSBLK 	  EQU           0x4E000020		  ;//NAND Flash programmable start block address
NFEBLK 	  EQU           0x4E000024 	    ;//NAND Flash programmable end block address     
NFSTAT 	  EQU           0x4E000028      ;//NAND Flash operation status 
NFECCERR0	EQU           0x4E00002C      ;//NAND Flash ECC Error Status for I/O [7:0]
NFECCERR1	EQU           0x4E000030      ;//NAND Flash ECC Error Status for I/O [15:8]
NFMECC0		EQU           0x4E000034      ;//SLC or MLC NAND Flash ECC status
NFMECC1		EQU           0x4E000038	    ;//SLC or MLC NAND Flash ECC status	
NFSECC 		EQU           0x4E00003C  		;//NAND Flash ECC for I/O[15:0]
NFMLCBITPT	EQU           0x4E000040  		;//NAND Flash 4-bit ECC Error Pattern for data[7:0]

;//chapter6 SYSEM CONTROLLER
LOCKTIME 	EQU           0x4C000000  		;//MPLL/UPLL lock time conuter
MPLLCON  	EQU           0x4C000004  		;//MPLL configuration
UPLLCON  	EQU           0x4C000008  		;//UPLL configuration
CLKCON   	EQU           0x4C00000C  		;//Clock generator control
CLKDIVN  	EQU           0x4C000014  		;//Clock divider control
OSCSET   	EQU           0x4C000018  		;//Oscillator stabilization time counter
CLKSRC  	  EQU           0x4C00001C  		;//Clock source control
PWRMODECON EQU           0x4C000020  		;//Power management mode setting 
PWRCFG     EQU           0x4C000024  		;//Power management configuration
WKUPSTAT   EQU           0x4C000028  		;//Wakup status 
ENDIAN     EQU           0x4C00002C  		;//System endian control
SWRSTCON   EQU           0x4C000030  		;//S/W reset control
RSTCON     EQU           0x4C000034  		;//Reset control
RSTSTAT    EQU           0x4C000038  		;//Reset status
INFORM0    EQU           0x4C000070  		;//User defined informtion
INFORM1    EQU           0x4C000074  		;//User defined informtion
INFORM2    EQU           0x4C000078  		;//User defined informtion
INFORM3    EQU           0x4C00007C  		;//User defined informtion

;//chapter8 I/O PORT 
GPACON    EQU          0x56000000	;//Configure the pins of port A
GPADAT    EQU          0x56000004	;//The data for port A

GPBCON    EQU          0x56000010	;//Configure the pins of port B
GPBDAT    EQU          0x56000014	;//The data for port B
GPBDN     EQU          0x56000018	;//Pull-down disable for port 

GPBSLPCON EQU          0x5600001C	;//sleep mode configuration for port B

GPCCON    EQU          0x56000020	;//Configure the pins of port C
GPCDAT    EQU          0x56000024	;//The data for port C
GPCDN     EQU          0x56000028	;//Pull-down disable for port C
GPCSLPCON EQU          0x5600002C	;//sleep mode configuration for port C

GPDCON    EQU          0x56000030	;//Configure the pins of port D
GPDDAT    EQU          0x56000034	;//The data for port D
GPDDN     EQU          0x56000038	;//Pull-down disable for port D
GPDSLPCON EQU          0x5600003C	;//sleep mode configuration for port D

GPECON    EQU          0x56000040	;//Configure the pins of port E
GPEDAT    EQU          0x56000044	;//The data for port E
GPEDN     EQU          0x56000048	;//Pull-down disable for port E
GPESLPCON EQU          0x5600004C	;//sleep mode configuration for port E

GPFCON    EQU          0x56000050	;//Configure the pins of port F
GPFDAT    EQU          0x56000054	;//The data for port F
GPFDN     EQU          0x56000058	;//Pull-down disable for port F

GPGCON    EQU          0x56000060	;//Configure the pins of portt G 
GPGDAT    EQU          0x56000064	;//The data for port G 
GPGDN     EQU          0x56000068	;//Pull-down disable for port G
GPGSLPCON EQU          0x5600006C	;//sleep mode configuration for port G

GPHCON    EQU          0x56000070	;//Configure the pins of porttt H 
GPHDAT    EQU          0x56000074	;//The data for port H 
GPHDN     EQU          0x56000078	;//Pull-down disable for port H
GPHSLPCON EQU          0x5600007C	;//sleep mode configuration for port H

GPJCON    EQU          0x56000080	;//Configure the pins of portttt J
GPJDAT    EQU          0x56000084	;//The data for port J 
GPJDN     EQU          0x56000088	;//Pull-down disable for porl J
GPJSLPCON EQU          0x5600008C	;//sleep mode configuration for port J

MISCCR    EQU          0x56000090	;//Miscellaneous control
DCLKCON   EQU          0x56000094	;//DCLK0/1 control
EXTINT0   EQU          0x56000098	;//External interrupt control register 0
EXTINT1   EQU          0x5600009C	;//External interrupt control register 1
EXTINT2   EQU          0x560000A0	;//External interrupt control register 2
EINTFLT0  EQU          0x560000A4	;//Reserved
EINTFLT1  EQU          0x560000A8	;//Reserved
EINTFLT2  EQU          0x560000Ac	;//External interrupt filter control register 2
EINTFLT3  EQU          0x560000B0	;//External interrupt filter control register 3
EINTMASK  EQU          0x560000B4	;//External interrupt mask
EINTPEND  EQU          0x560000B8	;//External interrupt pending
GSTATUS0  EQU          0x560000BC	;//External pin status
GSTATUS1  EQU          0x560000C0	;//Chip ID(0x32440000)
GSTATUS2  EQU          0x560000C4	;//Infrom
GSTATUS3  EQU          0x560000C8	;//Infrom
GSTATUS4  EQU          0x560000CC	;//Infrom
GSTATUS5  EQU          0x560000D0	;//Infrom

;//chapter13 INTERRUPT 
SRCPND     EQU          0x4a000000	;//Interrupt request status
INTMOD     EQU          0x4a000004	;//Interrupt mode control
INTMSK     EQU          0x4a000008	;//Interrupt mask control
PRIORITY   EQU          0x4a00000c	;//IRQ priority control
INTPND     EQU          0x4a000010	;//Interrupt request status
INTOFFSET  EQU          0x4a000014	;//Interrupt request source offset
SUBSRCPND  EQU          0x4a000018	;//Interrupt request status
INTSUBMSK  EQU          0x4a00001c	;//Interrupt source mask

;// chapter17 WATCH DOG TIMER
WTCON   EQU          0x53000000	;//Watch-dog timer mode
WTDAT   EQU          0x53000004	;//Watch-dog timer data
WTCNT   EQU          0x53000008	;//Watch-dog timer count

	END