
_ISR_STARTADDRESS	EQU		0x20008f00	;0x33ffff00
top_of_stacks		EQU		_ISR_STARTADDRESS

;=====================================================================================
;	(42,1,1)=200Mhz, (47,1,1)=220Mhz, (72,2,1)=240Mhz, (57,1,1)=260Mhz, (125,4,1)=266Mhz
;	(62,1,1)=280Mhz, (67,1,1)=300Mhz, (72,4,0)=320Mhz, (63,3,0)=340Mhz, (52,2,0)=360Mhz
;   (42,1,0)=400Mhz,

Startup_MPLL		EQU		266000000

Startup_Mdiv		EQU 	125	;42
Startup_Pdiv		EQU 	4	;1
Startup_Sdiv		EQU 	1

Startup_ARMCLKdiv	EQU		0			;	0 :	ARMCLK	= MPLL
										;	1 :	ARMCLK	= MPLL/2
Startup_HCLKdiv		EQU		1			;	0 :	HCLK	= ARMCLK
										;	1 :	HCLK	= ARMCLK/2
										;	2 :	HCLK	= ARMCLK/3
										;	3 :	HCLK	= ARMCLK/4
Startup_PCLKdiv		EQU		1			;	0 :	PCLK	= HCLK
										;	1 :	PCLK	= HCLK/2

Startup_ARMCLK		EQU		Startup_MPLL/(Startup_ARMCLKdiv+1)
Startup_HCLK		EQU		Startup_ARMCLK/(Startup_HCLKdiv+1)
Startup_PCLK		EQU		Startup_HCLK/(Startup_PCLKdiv+1)

;======================================================================================
;	MEM config	[SDR, DDR]
;======================================================================================

					GBLL	mSDR		; 256Mbit x16 x2ea = 512Mbit mem size
					
	IF :DEF: mSDR
;---------------------------------------
; BANKCFG register  : DRAM configure
;---------------------------------------
RASBW0				EQU		2			;	RAS addr 00=11bit,01-12bit,10=13bit, 11=14bit
RASBW1				EQU		2			;	RAS addr 00=11bit,01-12bit,10=13bit, 11=14bit
CASBW0				EQU		1			;	CAS addr 00=8bit,01-9bit,10=10bit, 11=11bit
CASBW1				EQU		1			;	CAS addr 00=8bit,01-9bit,10=10bit, 11=11bit
ADDRCFG0			EQU		0			; 	addre configure
          		                        ;   00={BA,RAS,CAS}, 01={RAS,BA,CAS}
ADDRCFG1			EQU		0			; 	addre configure
          		                        ;   00={BA,RAS,CAS}, 01={RAS,BA,CAS}
MEMCFG				EQU		1			; 	Ext.Mem 00=SDR,01=MSDR,10=DDR, 11=MDDR
BW					EQU		0			; 	Bus width 00=32bit,01=16bit

;---------------------------------------
; BANKCON1 register : DRAM timing control
;---------------------------------------
BStop				EQU		0			;	read burst stop control
WBUF				EQU		1			;	write buffer control
AP					EQU		0			;	auto precharge control
PWRDN				EQU		0			;	power down mode

;---------------------------------------
; BANKCON1 register : DRAM timing control
;---------------------------------------
tRAS				EQU		5			;	Row active time
tRC					EQU		7			;	Row cycle time
CL					EQU		3			;	CAS latency control
tRCD				EQU		2			;	RAS to CAS delay
tRP					EQU		2			; 	Row pre-charge time
REFCYC				EQU		787			; 	refresh cycle
										;  	100MHz=787, 133MHz=1053

;---------------------------------------
; BANKCON3 register : MRS/EMRS register
;---------------------------------------
BA_EMRS				EQU		2			;	BA : EMRS
DS					EQU		0			;	Driver strength
PASR				EQU		0			;	PASR
BA_MRS				EQU		0			;	BA : MRS
TM					EQU		0			; 	Test Mode - mode register set
CL_MRS				EQU		3			; 	CAS Latency


	ELIF :DEF: mDDR


;---------------------------------------
; BANKCFG register  : DRAM configure
;---------------------------------------
RASBW0				EQU		2			;	RAS addr 00=11bit,01-12bit,10=13bit, 11=14bit
RASBW1				EQU		2			;	RAS addr 00=11bit,01-12bit,10=13bit, 11=14bit
CASBW0				EQU		2			;	CAS addr 00=8bit,01-9bit,10=10bit, 11=11bit
CASBW1				EQU		2			;	CAS addr 00=8bit,01-9bit,10=10bit, 11=11bit
ADDRCFG0			EQU		0			; 	addre configure
          		                        ;   00={BA,RAS,CAS}, 01={RAS,BA,CAS}
ADDRCFG1			EQU		0			; 	addre configure
          		                        ;   00={BA,RAS,CAS}, 01={RAS,BA,CAS}
MEMCFG				EQU		3			; 	Ext.Mem 00=SDR,01=MSDR,10=DDR, 11=MDDR
BW					EQU		1			; 	Bus width 00=32bit,01=16bit

;---------------------------------------
; BANKCON0 register : DRAM timing control
;---------------------------------------
BStop				EQU		0			;	read burst stop control
WBUF				EQU		1			;	write buffer control
AP					EQU		0			;	auto precharge control
PWRDN				EQU		0			;	power down mode

;---------------------------------------
; BANKCON1 register : DRAM timing control
;---------------------------------------
tRAS				EQU		5			;	Row active time
tRC					EQU		7			;	Row cycle time
CL					EQU		3			;	CAS latency control
tRCD				EQU		2			;	RAS to CAS delay
tRP					EQU		2			; 	Row pre-charge time
REFCYC				EQU		787			; 	refresh cycle
										;  	100MHz=787, 133MHz=1053

;---------------------------------------
; BANKCON2 register : MRS/EMRS register
;---------------------------------------
BA_EMRS				EQU		2			;	BA : EMRS
DS					EQU		0			;	Driver strength
PASR				EQU		0			;	PASR
BA_MRS				EQU		0			;	BA : MRS
TM					EQU		0			; 	Test Mode - mode register set
CL_MRS				EQU		3			; 	CAS Latency
;---------------------------------------------------------------------------

					
	ENDIF

;---------------------------------------
; nGCS0 = AMD Flash = Bank0 Controller Parameter setting
;---------------------------------------
IDCY0				EQU		0x0			;	Idle or turnaround cycles IDCY*HCLK
WSTRD0				EQU		0xe			;	Read wait state = tacc
WSTWR0				EQU		0xe			;	wrie wait state
WSTOEN0				EQU		0			; 	output enable assertion delay from CS
WSTWEN0				EQU		0			; 	write enable assertion delay

BlWriteEn			EQU		1			;bit21-SMBAA signal control:0-1at all times, 1 active for sync
AddrValidWriteEn	EQU		1			;bit20-SMADDRVALD during write:0-always high,1-active for write 	
BurstLenWrite		EQU		0			;bit1819-burst transfer length:0-4,1-8,3-continu(sync only) 	
SyncWriteDev		EQU		0			;bit17-0:async, 1:sync 	
BMWrite				EQU		0			;bit16-burt mode write : 0-non-burst, 1-burst 	
WrapRead			EQU		0			;bit14-0-disable, 1 enable
BlReadEn			EQU		1			;bit13-SMBAA signal :0-1 at all time, 1-active for sync read
AddrValidReadEn		EQU		1			;bit12-SMADDRVALID signal: 0-always HIGH, 1-active for async & sync read
BurstLenRead		EQU		0			;bit1011-burst transfer length:0-4,1-8,2-16,3-cont(sync only)
SyncReadDev			EQU		0			;bit9-sync access :0-async, 1-sync
BMRead				EQU		0			;bit8-burst mode red and async page mode
SMBLSPOL			EQU		0			;bit6-polarit of signal nSMBLS
MW					EQU		1			;bit45-memory width : 00-8bit,01-16bit,10-32bit
WP					EQU		0			;bit3-write protect
WaitEn				EQU		0			;bit2-external wait signal enable
WaitPol				EQU		0			;bit1-polarity of the external wait input for actiation
RBLE				EQU		0			;bit0-read byte lane enable
SMBCR0_0			EQU		((BMRead<<8)+(SMBLSPOL<<6)+(MW<<4)+(WP<<3)+(WaitEn<<2)+(WaitPol<<1)+RBLE)
SMBCR0_1			EQU		((WrapRead<<14)+(BlReadEn<<13)+(AddrValidReadEn<<12)+(BurstLenRead<<10)+(SyncReadDev<<9))
SMBCR0_2			EQU		((BlWriteEn<<21)+(AddrValidWriteEn<<20)+(BurstLenWrite<<18)+(SyncWriteDev<<17)+(BMWrite<<16))

WaitTourErr0			EQU		0			; external wait timeout error flag

WSTBRD0				EQU		0x1f			; burst read wait state

MemClkRatio			EQU		1			; SMMEMCLK :0-HCLK,1-HCLK/2,2-HCLK/3
SMClockEn			EQU		1			; SMCLK enable 0-only active during mem access,1-always running	


	END
