// SDK.h
#include "Define.h"
/////////////Color Define//////////////
#define COLOR_BLACK         0x000000
#define COLOR_BLUE          0xFF0000
#define COLOR_GREEN         0x00ff00
#define COLOR_CYAN          0xffff00
#define COLOR_RED           0x0000FF
#define COLOR_MAGENTA       0x8b008b
#define COLOR_BROWN         0x2a2aa5
#define COLOR_DARKGRAY      0x404040
#define COLOR_GRAY          0x808080
#define COLOR_LIGHTGRAY     0xd3d3d3
#define COLOR_LIGHTBLUE     0xff8080
#define COLOR_LIGHTGREEN    0x80ff80
#define COLOR_LIGHTCYAN     0x80ffff
#define COLOR_LIGHTRED      0x8080ff
#define COLOR_LIGHTMAGENTA  0xff80ff
#define COLOR_YELLOW        0x00ffff
#define COLOR_ORANGE        0x008cff
#define COLOR_WHITE         0xffffff
#define COLOR_INVALID_COLOR 0xfffffff      /* Invalid color - more than 24 bits */
/////////////////////////////////////////


#define CURSOR_OFF		0
#define CURSOR_UL		1
#define CURSOR_L		2
#define CURSOR_BLOCK	3

#define KEY_UP     0x05	
#define KEY_DOWN   0x06	
#define KEY_LEFT   0x07	
#define KEY_RIGHT  0x0b

#define KEY_ESC    0x1b
#define KEY_BS     0x08
#define KEY_CLEAR  0x01
#define KEY_ALPHA  0x02
#define KEY_PWR    0x03
#define KEY_BKLIT  0x04
#define KEY_CR     0x0d
#define KEY_DEL    0x7f

#define KEY_F1     0x0f
#define KEY_F2     0x10
#define KEY_F3     0x11
#define KEY_F4     0x12
#define KEY_F5     0x13
#define KEY_F6     0x14
#define KEY_P1     0x15
#define KEY_P2     0x16

#define ALPHA_123	0x0
#define ALPHA_abc	0x1
#define ALPHA_ABC	0x2

struct SMENU_COLOR 
{
    int total_entry;  
    int selected_entry;
    int ReturnFlag;
    char* title;
	int title_color;
	int menu_color;
	int reverse_menu_color;
    struct SMENU_ENTRY_COLOR* entry_list[14];
};

struct SMENU_ENTRY_COLOR
{
    int text_x;
    int text_y;
    char* text;
    void (*func)(void);
    struct SMENU_COLOR *sub_menu;
};

typedef struct SMENU_COLOR MENU_COLOR;
typedef struct SMENU_ENTRY_COLOR MENU_ENTRY_COLOR;




#define FORWARD     1
#define BACKWARD    2	   // No use...

#define CR_LF       2


typedef struct __DBMS
{
	_TFILE* filehd_C;
	char *filehd_D;          // D device file point.
	unsigned int filesize_D; // D device file size.
	unsigned char ausFielddlt[50];       // Character that is used for field delimiter
	int record_type;         // 0 = static length  ,1 = variable length.
	int record_length;       // If record_type=0, it need a value.If record_type=1,it's value
	                         // can be any value.This value is not include CR_LF byte.
	int total_field_no;      // Total number of fields in a record.
	int total_record_no;     // Total number of records in a file.
						     // If total_record_no=-1,it will count total record auto.
	int pos_pre_record;	     // Position of precently filepoint.

}_DBMS;


//////////////Blue Tooth////////////////

typedef struct __BT_INFO
{
	char assLocalAddress[16];		
	char assLocalName[20];			

	BOOL bLocalSecurity;			
	BOOL bLocalEncryption;		

	int stInquiryTimeout;	
	int stInquirytMaxResponse;	

	char assLinkAddress[16];
	char assPinCode[20];	
	
}_BT_INFO;


typedef struct __BT_DEVINFO_STORE
{
	char assDevAddress[16];
	char assDevName[20];

}_BT_DEVINFO_STORE;


typedef struct __BT_DEVINFO
{
	_BT_DEVINFO_STORE stDevInfo[10];
	int slDevNum;
}_BT_DEVINFO;

/***********************          BlueTooth         ****************************/

#define BT_OK			1
#define BT_ERROR		2
#define BT_UNKNOWN		3
#define BT_FAILED		4
#define BT_TIMEOUT		5
#define BT_NOMODULE		6
#define BT_NOSTART		7
#define BT_START		8
#define BT_DISCONNECT	9
#define BT_CONNECT		10


int BT_Start(void);
int BT_Stop(void);
int BT_Open(void);
int BT_Close(void);
int BT_Read(char* pssBuf, int slReadSize, int* pslGetSize);
int BT_Write(char* pssBuf, int slWriteSize, int* pslPutSize);
int BT_GetLocalInfo(_BT_INFO* stInfo);
int BT_SetLocalSet(_BT_INFO* stSet);
int BT_Inquiry(_BT_DEVINFO* stBT_DevInfo, BOOL bGetDevName);

/***********************           Reader           ****************************/

#define CODEBUF_LEN 100
#define FULL_CODEBUF_LEN 200

extern char CodeBuf[CODEBUF_LEN];
extern char FullCodeBuf[FULL_CODEBUF_LEN],CodeID[4],CodeName[40];
extern char Preamble[24],Postamble[24],Terminator[24];
extern int CodeLen;



void InitScanner1(void);
int Decode(void);
void HaltScanner1(void);

int TriggerStatus(void);

BOOL Scanner_Reset(void);
void Scanner_Config_Start(void);
void Scanner_Config_End(void);
BOOL SCAN_SendCommand(int Command1,int Command2,char *pValue);
BOOL SCAN_QueryStatus(int Command1,int Command2,char *pReturn);
BOOL ScannerSetFromFile(char *pssFilePath);
BOOL Scanner_Version(char* Returnbuf);
/***************************      Buzzer      *********************************/
int beeper_status(void);
void off_beeper(void);
void on_beeper(int *sequence);
void SetBuzzerVol(int slVol);//slVol ==   0:close   1:Low  2:Medium   3:High

/**************************      Calendar      ********************************/
int DayOfWeek(void);
int get_time(char* time_buf);
int set_time(char* time_buf);  

/**********************     File Manipulation:       **************************/
extern int fErrorCode;

int __access(const char *Filename);
int append(int fd, char* buffer, int count);
int appendln(int fd, char* buffer);
int chsize(int fd, long size);
int close(int fd);
int delete_top(int fd, int count);
int delete_topln(int fd);
int eof(int fd);
long filelength(int fd);
int filelist(char* file_list);
long lseek(int fd, long offset, int origin);
int open(const char* file_name);
int read(int fd, char* buffer, int count);
int read_error_code(void);
int readln(int fd, char* buffer, unsigned int max_count);
int _remove(const char* file_name);
int _rename(char* old_name,char* new_name);
long tell(int fd);
int write(int fd, char* buffer, int count);
int writeln(int fd, char* buffer);

int DiskC_format(void);
int DiskD_format(void);

unsigned int DiskC_totalsize(void);
unsigned int DiskD_totalsize(void);
unsigned int DiskC_usedsize(void);
unsigned int DiskD_usedsize(void);
unsigned int DiskC_freesize(void);
unsigned int DiskD_freesize(void);

int getDirNum(char *pssPath);
int getFileNum(char *pssPath);
int getDirList(char *pssPath, char *pssBuffer);
int getFileList(char *pssPath, char *pssBuffer);


_TFILE* _fopen(const char*filename, const char *access_mode);
char* _fopenLookup(char* pssFName, unsigned int* pulSize);
int _fclose(_TFILE* file_pointer);
void _fcloseAll(void);
int _fseek(_TFILE *file_pointer, long offset, int origin);
unsigned int _filelength(_TFILE* file_pointer);
unsigned int _fread(const void *buffer, U32 size, U32 count, _TFILE *file_pointer);
unsigned int _fwrite(const void *buffer, U32 size, U32 count, _TFILE *file_pointer);

/***************************       DBMS         *******************************/
int Ini_Search(_TFILE* filehd,_DBMS* F_Search, unsigned char *pusFielddlt, int record_type,
			   int record_length, int total_field_no, int total_record_no);
int Close_Search(_DBMS* F_Search);
int SearchField(_DBMS* F_Search, char* field, int search_fieldno, int recordno, int flag);
int SearchField_GR(_DBMS* F_Search, char* field, int search_fieldno, int recordno,
				  char* R_Buffer, int flag);
int SearchField_GF(_DBMS* F_Search, char* field, int search_fieldno, int recordno, 
				  int get_field_no, char* F_Buffer, int flag);
int SearchMultiField_GF(_DBMS* F_Search, char* multi_field, int recordno, int get_field_no, 
					   char* F_Buffer, int flag);
long SeekRecord(_DBMS* F_Search,int recordno);
int GetRecordNum(_DBMS* F_Search);
int DeleteRecord(_DBMS* F_Search,int recordnum);
int DeleteLastRecord(_DBMS* F_Search);
int AppendRecord(_DBMS* F_Search,char* record);
int WriteField(_DBMS* F_Search, int recordno, int fieldno, char* field);
int WriteRecord(_DBMS* F_Search, int recordno, char* record);
int ReadField(_DBMS* F_Search, int recordno, int fieldno, char* buffer);
int ReadRecord(_DBMS* F_Search, int recordno, char* buffer);


/*****************************      LED      **********************************/
#define LED_GREEN       1
#define LED_RED         2
#define LED_ORANGE      3

#define LED_CLOSE       0
#define LED_OFF         1
#define LED_ON          2
#define LED_FLASH       3

#define LED_BLUE		1//For BlueTooth


void set_led(int led, int mode, int duration);


/****************************     Keypad     **********************************/
void clr_kb(void);
void dis_alpha(void);
void en_alpha(void);

int get_alpha_enable_state(void);


#define ALPHA_NUMERIC	0
#define ALPHA_LOWER		1
#define ALPHA_UPPER		2

void set_alpha_mode_state(int status);
int get_alpha_mode_state(void);

void set_keypad_BL(BOOL bStatus);
BOOL get_keypad_BL(void);
void set_keypad_BL_Timer(int slTimer);
int  get_keypad_BL_Timer(void);

int _getchar(void);
int GetKeyClick(void);
void SetKeyClick(int status);


///////Only for _scanf_color use/////////////////
void _scanf_ctrl_ScannerStatus(BOOL bStatus);
void _scanf_ctrl_ScannerReadConfirm(int nConfirm);	//bit all 0: no read confirm													
													//bit 0 => 1:LED on      0:LED off
													//bit 1 => 1:Buzzer on   0:Buzzer off
													//bit 2 => 1:Vibrate on  0:Vibrate off
void _scanf_ctrl_Vibrate(BOOL bEnable);
void _scanf_ctrl_ScanWithENT(BOOL bScanEnt);
void _scanf_ctrl_AlphaKey(BOOL bAlpha);
void _scanf_ctrl_AlphaKey_Mode(int slAlphaMode);
void _scanf_ctrl_password(char ssPassWord);
void _scanf_ctrl_KeypadLock(BOOL bLock);
int _scanf_color(int color, const char *format, ...);
int _scanf_color_DefaultStr(int color, char* assDefaultStr, const char *format, ...);
/////////////////////////////////////////////////

void FNKey_Reset(void);
char FNKey_GetState(short smKeyNum);
char FNKey_SetUserDef(short smKeyNum, void (*pslFunction)(void));

/**************************        LCD       **********************************/

void clr_eol(void);
void clr_rect(int left, int top, int width, int height);
void clr_scr(void);

void fill_rect(int left, int top, int width, int height);
void fill_rect_color(int color, int left, int top, int width, int height);

int Get_Cursor(void);
void Set_Cursor(int status);

int gotoxy(int x_position, int y_position);
int wherex(void);
int wherexy(int* column, int* row);
int wherey(void);

void lcd_backlit_Setlv(int level);
void lcd_backlit_SetTimer(int timer);
int lcd_backlit_Getlv(void);
int lcd_backlit_GetTimer(void);

int _printf_color(int color, char *format, ...);
int _putchar(char c);
int _putchar_color(int color, char c);
char _puts (char* string);
char _puts_color(int colorindex, char* string);


void show_image_bmp(int left, int top, int width, int height, const void *pat);

/****************************     TextBlock    ********************************/
#define	TYPE_COLOR		0
#define TYPE_IMAGE		1
#define TYPE_ORIGINAL	2

BOOL DefineTextBlock(S32 slBlockNo,S32 slSelFont,S32 slBGType,U32* ulBGData,S32 slColumn,S32 slRow,S32 slXPos,S32 slYPos);
BOOL SetTextBlock(S32 slBlockNo,BOOL bSF);
void ResetTextBlock(S32 slBlockNo);
POINT PrintTextBlock(S32 slBlockNo, S32 slColumn, S32 slRow, char* string, U32 ulFontColor);
POINT GetTextBlockCur(S32 slBlockNo);
void SetTextBlockCur(S32 slBlockNo,S32 slColumn,S32 slRow);
void ShowTextBlockCursor(S32 slBlockNo, BOOL bShow, S32 slType);

/*******************************     Font    **********************************/
BOOL DispFont_SetFont(S32 slSelFont, const char *filename);
BOOL DispFont_SetPFont(S32 slSelFont, char* pfile);
BOOL DispFont_GetFontInfo(S32 slSelFont, S32* slType, S32* slWidth, S32* slHeight);

/**********************     Communication Ports     ***************************/
#define     COMM_DIRECT			0
#define     COMM_DOCKING		1
#define     COMM_IR				2
#define     COMM_IrDA			3
#define     COMM_RF				4



////RS-232////
void clear_com(int port);
int close_com(int port);
int com_cts(int port);
int com_eot(int port);
int com_overrun(int port);
void com_rts(int port, int val);
int nwrite_com(int port, char *s, int count);
int open_com(int com_port, int setting);
int read_com(int port, char *c);
int write_com(int port, char *s);


////USB////
void USB_Open(void);
void USB_Close(void);
int USB_Read(unsigned char *rbuf, unsigned int rLength);
void USB_Write(unsigned char *wbuf, unsigned int wLength);


/**********************         Remote Link          ***************************/
#define		INTERFACE_USB		0
#define		INTERFACE_COM		1


#define REMOTE_115200		0
#define REMOTE_57600		1
#define REMOTE_38400		2
#define REMOTE_19200		3
#define REMOTE_9600			4
#define REMOTE_4800			5


void SetRemoteBaud(int slBaud);
int GetRemoteBaud(void);

void SetRemoteInterface(int slInterface);
int GetRemoteInterface(void);

void RemoteLink(void);////nקO_ar
void RemoteLink_RealTime(BOOL bStatus);

/***********************           System           ****************************/

void SysSuspend(void);
void SysDelay(unsigned int ulTime);

#define PWON_RESUME			0
#define PWON_RESTART		1
void SetPowerOnState(int slStatus);
int GetPowerOnState(void);

#define	APO_OFF		0
void SetAutoPWOff(int slTimer);
int GetAutoPWOff(void);

void SetStatausBAR(int slStatus);
int GetStatusBAR(void);

void SN_Get(char *pssSNBuffer);
void BIOS_SetDefault(void);
BOOL Check_AID(char* pssUser, char* pssPassword);

/***********************           Memory           ****************************/
void Tfree(void *mem_address);
void* Tmalloc(U32 num_bytes);

int TotalHeapSize(void);
int UsedHeapSize(void);
int FreeHeapSize(void);

/***********************           Vibrate          ****************************/
void off_vibrator(void);
void on_vibrator(void);
void set_vibrator_timer(unsigned char usTimer);
unsigned char get_vibrator_timer(void);

/***************************       Others        *******************************/
void prc_menu_color(MENU_COLOR *menu);

/***************************    For Simulator    *******************************/
void CopyFileToTerminal(char *pssPCFileName, char *pssPDTFileName);
void BackupDataFiletoPC(char *pTerminalFile, char *pPCFileName);

/***************************   Data Conversion   *******************************/
char * __itoa (int value, char *string, int radix);
char * __ltoa (long value, char *string, int radix);
char * __ultoa (unsigned long value, char *string, int radix);

