/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.rpt;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class DataReformUtil {
    private int index = 0;
    private ArrayList upLevelName = new ArrayList();
    public static final String TREE_STRU = "TREE";
    public static final String ENMU_STRU = "ENMU";
    public static final String DISPLAY_METHOD_ALLLEVEL = "ALL";
    public static final String DISPLAY_METHOD_LIST = "LIST";
    public static final String DISPLAY_METHOD_SPECIFY = "SPECIFY";
    public static final String STRU_KEY_SORT = "SORT";
    public static final String STRU_KEY_ADDDETAIL = "ADDDETAIL";
    public static final String STRU_KEY_ADDONTEMP = "ADDONTEMP";
    private static BigDecimal zeroValue = new BigDecimal("0");
    private static Logger logger = Logger.getLogger(DataReformUtil.class);
    private int addonCount;

    private DataReformUtil() {
    }

    public ArrayList groupData(ArrayList data, int group, boolean ascending) {
        int[] test = new int[1];
        boolean[] flag = new boolean[1];
        test[0] = group;
        flag[0] = ascending;
        return this.groupData(data, test, flag);
    }

    public ArrayList groupData(ArrayList data, int[] group, boolean[] ascending) {
        Object temp2;
        Comparator comp = null;
        if (!ascending[this.index]) {
            comp = Collections.reverseOrder();
        }
        ArrayList<ArrayList> result = new ArrayList<ArrayList>();
        TreeSet set = new TreeSet(comp);
        for (int i = 0; i < data.size(); ++i) {
            Object o1 = ((ArrayList)data.get(i)).get(group[this.index]);
            Object temp1 = o1;
            if (temp1 == null) {
                temp1 = "";
            } else if (o1 instanceof Calendar) {
                temp1 = DataReformUtil.calendarToString((Calendar)o1, "");
            }
            for (int j = 0; j < data.size(); ++j) {
                Object o2;
                temp2 = o2 = ((ArrayList)data.get(j)).get(group[this.index]);
                if (o2 instanceof Calendar && o2 != null) {
                    temp2 = DataReformUtil.calendarToString((Calendar)o2, "");
                }
                if (!temp1.equals(temp2)) continue;
                if (temp1 instanceof Boolean) {
                    set.add(temp1.toString());
                    continue;
                }
                set.add(temp1);
            }
        }
        for (Object temp1 : set) {
            int i;
            ArrayList temp = new ArrayList();
            for (i = 0; i < data.size(); ++i) {
                Object o = ((ArrayList)data.get(i)).get(group[this.index]);
                temp2 = o;
                if (temp2 != null && temp2 instanceof Boolean) {
                    temp2 = temp2.toString();
                }
                if (o instanceof Calendar && o != null) {
                    temp2 = DataReformUtil.calendarToString((Calendar)o, "");
                }
                if (!temp1.equals(temp2)) continue;
                temp.add((ArrayList)data.get(i));
            }
            if (this.index + 1 < group.length) {
                ++this.index;
                temp = this.groupData(temp, group, ascending);
                --this.index;
            }
            for (i = 0; i < temp.size(); ++i) {
                result.add((ArrayList)temp.get(i));
            }
        }
        return result;
    }

    public static List beginAddOn(List data, int[] group, int[] column, HashMap[] columnStru) {
        DataReformUtil util = new DataReformUtil();
        for (int i = 0; i < columnStru.length; ++i) {
            boolean isTreeStru = DataReformUtil.isCurColumnTreeStru(columnStru[i]);
            String displayFormat = columnStru[i].get("DISPLAY").toString();
            int offset = 0;
            if (isTreeStru && DISPLAY_METHOD_ALLLEVEL.equals(displayFormat)) {
                Object[] columnObject = DataReformUtil.getDistinctValue(true, group[i], data);
                TreeNode root = (TreeNode)columnStru[i].get("VALUE");
                TreeNode rootBak = DataReformUtil.cloneTreeNode(root);
                DataReformUtil.removeInvalidNode(rootBak, columnObject);
                offset = DataReformUtil.countCurNodeLevel(rootBak) - 1;
            }
            columnStru[i].put("OFFSET", new Integer(offset));
        }
        return util.addOn(data, group, column, columnStru);
    }

    public static List beginAddOn(List data, int[] column, String addonTemplate) {
        if (data.size() < 1) {
            return new ArrayList();
        }
        if (addonTemplate == null) {
            addonTemplate = "Total";
        }
        data.add(DataReformUtil.getAddonLine(data, column, addonTemplate));
        return data;
    }

    public static List getAddonLine(List data, int[] column, String addonTemplate) {
        ArrayList<Object> result = new ArrayList<Object>();
        BigDecimal zero = new BigDecimal("0");
        BigDecimal[] curColumnAddon = new BigDecimal[column.length];
        for (int i = 0; i < data.size(); ++i) {
            List lineData = (List)data.get(i);
            for (int j = 0; j < column.length; ++j) {
                BigDecimal bo = (BigDecimal)lineData.get(column[j]);
                if (curColumnAddon[j] == null) {
                    curColumnAddon[j] = zero;
                }
                curColumnAddon[j] = curColumnAddon[j].add(bo == null ? zero : bo);
            }
        }
        List lineData = (List)data.get(0);
        int size = lineData.size();
        for (int i = 0; i < size; ++i) {
            if (i == 0) {
                result.add(addonTemplate);
                continue;
            }
            boolean flag = false;
            for (int j = 0; j < column.length; ++j) {
                if (i != column[j]) continue;
                result.add(curColumnAddon[j]);
                flag = true;
            }
            if (flag) continue;
            result.add("");
        }
        return result;
    }

    protected ArrayList addOn(List data, int[] group, int[] column, HashMap[] columnStru) {
        int i;
        boolean isAscending = columnStru[this.index].get(STRU_KEY_SORT) != null ? (Boolean)columnStru[this.index].get(STRU_KEY_SORT) : true;
        boolean isAddDetail = columnStru[this.index].get(STRU_KEY_ADDDETAIL) != null ? (Boolean)columnStru[this.index].get(STRU_KEY_ADDDETAIL) : true;
        String addonTemplate = columnStru[this.index].get(STRU_KEY_ADDONTEMP) != null ? (String)columnStru[this.index].get(STRU_KEY_ADDONTEMP) : "Total";
        ArrayList<ArrayList> result = new ArrayList<ArrayList>();
        int offset = columnStru[this.index].get("OFFSET") != null ? (Integer)columnStru[this.index].get("OFFSET") : 0;
        boolean isTreeStru = DataReformUtil.isCurColumnTreeStru(columnStru[this.index]);
        String displayFormat = columnStru[this.index].get("DISPLAY").toString();
        Object[] columnObject = DataReformUtil.getDistinctValue(isAscending, group[this.index], data);
        HashMap allAddon = null;
        allAddon = isTreeStru ? DataReformUtil.genAllLevelAddon(column.length, DataReformUtil.getColumnData(columnStru[this.index], columnObject)) : DataReformUtil.genAllLevelAddon(column.length, columnObject);
        int[] curColumnIndex = new int[column.length];
        int[] curGroup = new int[group.length];
        for (i = 0; i < group.length; ++i) {
            curGroup[i] = group[i];
            if (group[this.index] <= curGroup[i] || i < this.index) continue;
            int n = i;
            curGroup[n] = curGroup[n] + 1;
        }
        curGroup[this.index] = this.index;
        if (isTreeStru) {
            columnObject = DataReformUtil.getTreeNodeCollection((TreeNode)columnStru[this.index].get("VALUE"), columnObject, false);
        }
        for (int setCount = 0; setCount < columnObject.length; ++setCount) {
            Object oTemp1 = columnObject[setCount];
            String temp1 = oTemp1 == null ? "" : oTemp1.toString();
            BigDecimal[] add = DataReformUtil.getCurLevelAddon(allAddon, temp1);
            ArrayList allLevel = new ArrayList();
            if (DISPLAY_METHOD_ALLLEVEL.equals(displayFormat) || DISPLAY_METHOD_SPECIFY.equals(displayFormat)) {
                allLevel = DataReformUtil.getCurNodeTreePath((TreeNode)columnStru[this.index].get("VALUE"), temp1, false);
            }
            for (int i2 = 0; i2 < column.length; ++i2) {
                curColumnIndex[i2] = column[i2] < group[this.index] ? column[i2] + 1 : column[i2];
            }
            ArrayList temp = this.getCurrentColumnList(temp1, column, add, group[this.index], data);
            if (this.index + 1 < group.length) {
                ++this.index;
                this.upLevelName.add(temp1);
                temp = this.addOn(temp, curGroup, curColumnIndex, columnStru);
                if (this.upLevelName.size() > 0) {
                    this.upLevelName.remove(this.upLevelName.size() - 1);
                }
                --this.index;
            }
            for (int i3 = 0; i3 < temp.size(); ++i3) {
                ArrayList line = (ArrayList)temp.get(i3);
                if (DISPLAY_METHOD_ALLLEVEL.equals(displayFormat)) {
                    for (int j = 0; j < offset - allLevel.size(); ++j) {
                        line.add(this.index + 1, "");
                    }
                }
                if (!isAddDetail && this.index + 1 >= group.length) continue;
                if (!DISPLAY_METHOD_SPECIFY.equals(displayFormat)) {
                    result.add(this.buildAllLevel(line, allLevel));
                    continue;
                }
                result.add(this.buildAllLevel(line, new ArrayList()));
            }
            if (result == null || temp.size() <= 0) continue;
            int columnCount = ((ArrayList)temp.get(temp.size() - 1)).size();
            ArrayList addLine = new ArrayList();
            if (DISPLAY_METHOD_ALLLEVEL.equals(displayFormat)) {
                int[] treeStruColumnIndex = new int[curColumnIndex.length];
                for (int i4 = 0; i4 < curColumnIndex.length; ++i4) {
                    treeStruColumnIndex[i4] = curColumnIndex[i4] + offset - allLevel.size();
                }
                addLine = this.genAddonLine(columnCount, treeStruColumnIndex, add, oTemp1, addonTemplate);
                result.add(this.buildAllLevel(addLine, allLevel));
            }
            if (DISPLAY_METHOD_LIST.equals(displayFormat)) {
                addLine = this.genAddonLine(columnCount, curColumnIndex, add, oTemp1, addonTemplate);
                result.add(this.buildAllLevel(addLine, allLevel));
            }
            if (DISPLAY_METHOD_SPECIFY.equals(displayFormat) && allLevel.size() <= Integer.parseInt(columnStru[this.index].get("LEVEL").toString())) {
                addLine = this.genAddonLine(columnCount, curColumnIndex, add, oTemp1, addonTemplate);
                result.add(this.buildAllLevel(addLine, new ArrayList()));
            }
            if (isTreeStru && !DISPLAY_METHOD_LIST.equals(displayFormat)) {
                TreeNode root = (TreeNode)columnStru[this.index].get("VALUE");
                TreeNode rootBak = DataReformUtil.cloneTreeNode(root);
                DataReformUtil.removeInvalidNode(rootBak, columnObject);
                int sourceRootDeep = offset + 1;
                ArrayList newLine = null;
                if (DISPLAY_METHOD_ALLLEVEL.equals(displayFormat)) {
                    newLine = this.addNewLine(temp1, rootBak, sourceRootDeep, curColumnIndex, allAddon, true, columnCount - (offset - allLevel.size()), addonTemplate);
                }
                if (DISPLAY_METHOD_LIST.equals(displayFormat)) {
                    newLine = this.addNewLine(temp1, rootBak, sourceRootDeep, curColumnIndex, allAddon, false, columnCount, addonTemplate);
                }
                if (DISPLAY_METHOD_SPECIFY.equals(displayFormat)) {
                    newLine = this.addNewLine(temp1, rootBak, sourceRootDeep, curColumnIndex, allAddon, false, columnCount, Integer.parseInt(columnStru[this.index].get("LEVEL").toString()), addonTemplate);
                }
                if (newLine != null && newLine.size() > 0) {
                    result.addAll(newLine);
                }
            }
            if (!DISPLAY_METHOD_LIST.equals(displayFormat) || this.index != 0 || setCount != columnObject.length - 1) continue;
            BigDecimal[] listAddon = new BigDecimal[column.length];
            this.calculateAddon(listAddon, columnObject, allAddon);
            addLine = this.genAddonLine(columnCount, curColumnIndex, listAddon, null, addonTemplate);
            result.add(this.buildAllLevel(addLine, allLevel));
        }
        for (i = 0; i < column.length; ++i) {
            column[i] = curColumnIndex[i] + (isTreeStru && DISPLAY_METHOD_ALLLEVEL.equals(displayFormat) ? offset : 0);
        }
        return result;
    }

    private void calculateAddon(BigDecimal[] desData, Object[] keys, HashMap allAddon) {
        if (keys != null) {
            for (int addOnCount = 0; addOnCount < keys.length; ++addOnCount) {
                BigDecimal[] childAddon = (BigDecimal[])allAddon.get(keys[addOnCount]);
                for (int j = 0; childAddon != null && j < childAddon.length; ++j) {
                    if (desData[j] == null) {
                        desData[j] = new BigDecimal("0");
                    }
                    desData[j] = desData[j].add(childAddon[j]).setScale(6, 4);
                }
            }
        }
    }

    private ArrayList getCurrentColumnList(String columnName, int[] column, BigDecimal[] curColumnAddon, int columnIndex, List source) {
        ArrayList<ArrayList> temp = new ArrayList<ArrayList>();
        for (int i = 0; i < source.size(); ++i) {
            String temp2;
            Object oTemp2 = ((List)source.get(i)).get(columnIndex);
            String string = temp2 = oTemp2 == null ? "" : oTemp2.toString();
            if (!temp2.equals(columnName)) continue;
            temp.add(this.moveColumn((List)source.get(i), columnIndex));
            for (int j = 0; j < curColumnAddon.length; ++j) {
                if (curColumnAddon[j] == null) {
                    curColumnAddon[j] = new BigDecimal("0");
                }
                curColumnAddon[j] = curColumnAddon[j].add(new BigDecimal(((List)source.get(i)).get(column[j]) == null ? "0" : ((List)source.get(i)).get(column[j]).toString())).setScale(6, 4);
            }
        }
        return temp;
    }

    protected static Object[] getDistinctValue(boolean isAscending, int columnIndex, List source) {
        Comparator comp = !isAscending ? Collections.reverseOrder() : null;
        TreeSet set = new TreeSet(comp);
        for (int i = 0; i < source.size(); ++i) {
            Object oTemp1 = ((List)source.get(i)).get(columnIndex);
            set.add(oTemp1 == null ? "" : oTemp1);
        }
        return set.toArray();
    }

    protected ArrayList buildAllLevel(ArrayList source, ArrayList addColumn) {
        ArrayList result = new ArrayList(source);
        for (int j = 0; j < addColumn.size(); ++j) {
            result.add(this.index, addColumn.get(j));
        }
        return result;
    }

    protected ArrayList moveColumn(List source, int groupIndex) {
        ArrayList result = new ArrayList(source);
        Object columnData = result.get(groupIndex);
        result.remove(groupIndex);
        result.add(this.index, columnData);
        return result;
    }

    protected static ArrayList getCurNodeTreePath(TreeNode root, String leaf, boolean includeRoot) {
        ArrayList<String> result = new ArrayList<String>();
        TreeNode parent = DataReformUtil.getParent(root, leaf);
        if (parent != null && (!((DefaultMutableTreeNode)parent).isRoot() || includeRoot)) {
            result.add(parent.toString());
            if (parent.getParent() != null && (!((DefaultMutableTreeNode)parent.getParent()).isRoot() || includeRoot)) {
                ArrayList nodeList = DataReformUtil.getCurNodeTreePath(parent.getParent(), parent.toString(), includeRoot);
                for (int i = 0; i < nodeList.size(); ++i) {
                    result.add((String)nodeList.get(i));
                }
            }
        }
        return result;
    }

    public static int countCurNodeLevel(TreeNode root) {
        int result = 0;
        Enumeration<? extends TreeNode> e = root.children();
        boolean flag = true;
        while (e.hasMoreElements()) {
            if (flag) {
                ++result;
            }
            flag = false;
            TreeNode node = e.nextElement();
            if (node.isLeaf()) continue;
            int curLevel = DataReformUtil.countCurNodeLevel(node);
            result = result - 1 < curLevel ? curLevel + 1 : result;
        }
        return result;
    }

    protected static TreeNode cloneTreeNode(TreeNode sourceNode) {
        TreeNode result = (TreeNode)((DefaultMutableTreeNode)sourceNode).clone();
        Enumeration<? extends TreeNode> e = sourceNode.children();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.nextElement();
            if (node.isLeaf()) {
                ((DefaultMutableTreeNode)result).add((DefaultMutableTreeNode)node.clone());
                continue;
            }
            ((DefaultMutableTreeNode)result).add((DefaultMutableTreeNode)DataReformUtil.cloneTreeNode(node));
        }
        return result;
    }

    protected ArrayList addNewLine(String curLeaf, TreeNode partRoot, int sourceRootDeep, int[] columnIndex, HashMap allAddon, boolean isAllLevel, int columnCount, String addonTemplate) {
        return this.addNewLine(curLeaf, partRoot, sourceRootDeep, columnIndex, allAddon, isAllLevel, columnCount, -1, addonTemplate);
    }

    protected ArrayList addNewLine(String curLeaf, TreeNode partRoot, int sourceRootDeep, int[] columnIndex, HashMap allAddon, boolean isAllLevel, int columnCount, int deep, String addonTemplate) {
        TreeNode curParent = DataReformUtil.isLastLeafOfParent(partRoot, curLeaf);
        ArrayList<ArrayList> result = new ArrayList<ArrayList>();
        if (curParent != null) {
            if (((DefaultMutableTreeNode)curParent).isRoot() && this.index != 0) {
                return result;
            }
            Object[] count = DataReformUtil.getCurLevelChildren(curParent);
            BigDecimal[] parentAddon = DataReformUtil.getCurLevelAddon(allAddon, curParent.toString());
            this.calculateAddon(parentAddon, count, allAddon);
            ArrayList allLevel = new ArrayList();
            int offset = 0;
            if (isAllLevel || deep != -1) {
                allLevel = DataReformUtil.getCurNodeTreePath(partRoot, curParent.toString(), false);
                offset = sourceRootDeep - 1;
            }
            ArrayList treeStru = new ArrayList();
            if (isAllLevel) {
                int[] treeStruColumnIndex = new int[columnIndex.length];
                for (int i = 0; i < columnIndex.length; ++i) {
                    treeStruColumnIndex[i] = columnIndex[i] + offset - allLevel.size();
                }
                treeStru = ((DefaultMutableTreeNode)curParent).isRoot() && this.index == 0 ? this.genAddonLine(columnCount + offset - allLevel.size(), treeStruColumnIndex, parentAddon, null, addonTemplate) : this.genAddonLine(columnCount + offset - allLevel.size(), treeStruColumnIndex, parentAddon, curParent.toString(), addonTemplate);
            } else {
                ArrayList arrayList = treeStru = ((DefaultMutableTreeNode)curParent).isRoot() && this.index == 0 ? this.genAddonLine(columnCount, columnIndex, parentAddon, null, addonTemplate) : this.genAddonLine(columnCount, columnIndex, parentAddon, curParent.toString(), addonTemplate);
            }
            if (deep != -1 && deep >= allLevel.size()) {
                result.add(this.buildAllLevel(treeStru, new ArrayList()));
            }
            if (deep == -1) {
                result.add(this.buildAllLevel(treeStru, allLevel));
            }
            if (curParent.getParent() != null) {
                result.addAll(this.addNewLine(curParent.toString(), partRoot, sourceRootDeep, columnIndex, allAddon, isAllLevel, columnCount, deep, addonTemplate));
            }
        }
        return result;
    }

    protected ArrayList genAddonLine(int columnCount, int[] columnIndex, BigDecimal[] addOn, Object object, String template) {
        ++this.addonCount;
        ArrayList<Object> value = new ArrayList<Object>();
        boolean flag = false;
        for (int i = 0; i < columnCount; ++i) {
            if (this.upLevelName.size() > i) {
                value.add(this.upLevelName.get(i));
                continue;
            }
            for (int j = 0; j < columnIndex.length; ++j) {
                if (i == columnIndex[j]) {
                    value.add(addOn[j]);
                    flag = false;
                    break;
                }
                flag = true;
            }
            if (flag && i != this.index && i != this.index + 1) {
                if (this.addonCount % 2 == 0) {
                    value.add(" ");
                    continue;
                }
                value.add(null);
                continue;
            }
            if (i != this.index) continue;
            if (object == null) {
                value.add(template);
                if (i == columnIndex[0] - 1) continue;
                if (this.addonCount % 2 == 0) {
                    value.add(" ");
                    continue;
                }
                value.add(null);
                continue;
            }
            value.add(object);
            if (i == columnIndex[0] - 1) continue;
            value.add(template);
        }
        return value;
    }

    public static String calendarToString(Calendar calendar, String sDateformat) {
        if (calendar == null) {
            return null;
        }
        if (sDateformat == null || sDateformat.length() == 0) {
            sDateformat = "yyyy-MM-dd";
        }
        SimpleDateFormat dateformater = null;
        try {
            dateformater = new SimpleDateFormat(sDateformat);
        }
        catch (Exception e) {
            dateformater = new SimpleDateFormat("yyyy-MM-dd");
        }
        return dateformater.format(calendar.getTime());
    }

    protected static TreeNode isLastLeafOfParent(TreeNode root, String leaf) {
        TreeNode result = DataReformUtil.getParent(root, leaf);
        if (result != null) {
            if (result.getChildAt(result.getChildCount() - 1).toString().equals(leaf)) {
                return result;
            }
            return null;
        }
        return result;
    }

    protected static void removeInvalidNode(TreeNode root, Object[] columnObject) {
        for (int childrenCount = root.getChildCount() - 1; childrenCount >= 0; --childrenCount) {
            TreeNode node = root.getChildAt(childrenCount);
            if (node.isLeaf()) {
                boolean flag = true;
                for (int setCount = 0; setCount < columnObject.length; ++setCount) {
                    if (!columnObject[setCount].toString().equals(node.toString())) continue;
                    flag = false;
                    break;
                }
                if (!flag) continue;
                ((DefaultMutableTreeNode)node).removeFromParent();
                continue;
            }
            DataReformUtil.removeInvalidNode(node, columnObject);
            if (node.getChildCount() != 0) continue;
            ((DefaultMutableTreeNode)node).removeFromParent();
        }
    }

    protected static TreeNode getParent(TreeNode root, String leaf) {
        TreeNode result = null;
        if (root.toString().equals(leaf)) {
            return root.getParent();
        }
        Enumeration<? extends TreeNode> e = root.children();
        while (e.hasMoreElements()) {
            TreeNode node = e.nextElement();
            if (node.isLeaf()) {
                if (!leaf.equals(node.toString())) continue;
                return root;
            }
            result = DataReformUtil.getParent(node, leaf);
            if (result == null) continue;
            return result;
        }
        return result;
    }

    protected static BigDecimal[] getCurLevelAddon(HashMap allAddon, String leaf) {
        return (BigDecimal[])allAddon.get(leaf);
    }

    protected static HashMap genAllLevelAddon(int column, Object[] addon) {
        HashMap<String, BigDecimal[]> result = new HashMap<String, BigDecimal[]>();
        if (addon == null) {
            return result;
        }
        for (int i = 0; i < addon.length; ++i) {
            BigDecimal[] bd = new BigDecimal[column];
            for (int j = 0; j < column; ++j) {
                bd[j] = new BigDecimal("0");
            }
            result.put(addon[i].toString(), bd);
        }
        return result;
    }

    protected static Object[] getColumnData(HashMap columnData, Object[] set) {
        Object[] addon = null;
        if (columnData.get("TYPE").toString().equals(TREE_STRU)) {
            addon = DataReformUtil.getTreeNodeCollection((TreeNode)columnData.get("VALUE"), set, true);
        }
        if (columnData.get("TYPE").toString().equals(ENMU_STRU)) {
            addon = ((ArrayList)columnData.get("VALUE")).toArray();
        }
        return addon;
    }

    protected static Object[] getCurLevelChildren(TreeNode leaf) {
        Object[] children = new Object[leaf.getChildCount()];
        for (int i = 0; i < leaf.getChildCount(); ++i) {
            TreeNode node = leaf.getChildAt(i);
            children[i] = node.toString();
        }
        return children;
    }

    private static Object[] getTreeNodeCollection(TreeNode node, Object[] set, boolean isIncludeParent) {
        if (node == null) {
            return null;
        }
        return DataReformUtil.getAllNode(node, set, isIncludeParent).toArray();
    }

    protected static ArrayList getAllNode(TreeNode node, Object[] set, boolean isIncludeParent) {
        ArrayList<String> result = new ArrayList<String>();
        if (node != null && isIncludeParent) {
            result.add(node.toString());
        }
        if (!node.isLeaf()) {
            for (int children = 0; children < node.getChildCount(); ++children) {
                TreeNode tn = node.getChildAt(children);
                if (tn.isLeaf()) {
                    boolean flag = false;
                    for (int setCount = 0; setCount < set.length; ++setCount) {
                        if (!set[setCount].toString().equals(tn.toString())) continue;
                        flag = true;
                    }
                    if (!flag) continue;
                    result.add(tn.toString());
                    continue;
                }
                ArrayList nodeList = DataReformUtil.getAllNode(tn, set, isIncludeParent);
                for (int i = 0; i < nodeList.size(); ++i) {
                    result.add((String)nodeList.get(i));
                }
            }
        }
        return result;
    }

    protected static boolean isCurColumnTreeStru(HashMap columnData) {
        return columnData.get("TYPE").toString().equals(TREE_STRU);
    }
}

