/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.rpt;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.sql.SqlTranslateException;
import com.kingdee.bos.sql.TransUtil;
import com.kingdee.eas.fi.fa.rpt.FaCreateTempTableResult;
import com.kingdee.eas.fi.fa.rpt.FaDBUtilConfig;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Locale;
import org.apache.log4j.Logger;

public class FaDBUtil {
    private static final Logger logger = Logger.getLogger(FaDBUtil.class);
    private static final String DIALECT_TAG = "/*dialect*/";
    private static final FaDBUtil dbutil = new FaDBUtil();
    public static final IDialect DIALECT_KSQL = dbutil.new KSQLDialect();
    private static final int IDS_LENGTH = 999;

    public static KSQLDialect getKSQLDialect() {
        return (KSQLDialect)DIALECT_KSQL;
    }

    private static IDialect getDialect(Connection con) throws SQLException {
        return DIALECT_KSQL;
    }

    public static FaCreateTempTableResult executeSelectInto(Context ctx, String sql, SqlParams pp, Connection con, FaDBUtilConfig cf) throws SQLException, BOSException {
        IDialect dialect = FaDBUtil.getDialect(con);
        return dialect.executeSelectInto(ctx, sql, pp, con, cf);
    }

    public static int executeUpdate(String sql, Connection con) throws SQLException {
        return FaDBUtil.executeUpdate(sql, null, con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int executeUpdate(String sql, SqlParams pp, Connection con) throws SQLException {
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(sql);
            if (pp != null) {
                pp.putToStatement(ps);
            }
            int n = ps.executeUpdate();
            return n;
        }
        finally {
            SQLUtils.cleanup((Statement)ps);
        }
    }

    public static String getSplitInSql(String strCompanyInclude, String mark) {
        int i;
        String[] IDsArr;
        int num;
        logger.error((Object)"strCompanyInclude start---------------------------------------------------------------");
        logger.error((Object)strCompanyInclude);
        logger.error((Object)"strCompanyInclude end---------------------------------------------------------------");
        if (strCompanyInclude.indexOf("(") >= 0) {
            strCompanyInclude = strCompanyInclude.replace(" ", "");
            strCompanyInclude = strCompanyInclude.replace("(", "");
            strCompanyInclude = strCompanyInclude.replace(")", "");
        }
        if ((num = 999) > (IDsArr = strCompanyInclude.split(",")).length) {
            if (strCompanyInclude.indexOf("(") >= 0) {
                return new StringBuffer(" in ").append(strCompanyInclude).toString();
            }
            return new StringBuffer(" in (").append(strCompanyInclude).append(")").toString();
        }
        StringBuilder sqlStr = new StringBuilder();
        StringBuilder IDs = new StringBuilder();
        StringBuilder lastIDs = new StringBuilder();
        int lastIndex = 0;
        for (i = 0; i < IDsArr.length; ++i) {
            IDs.append(IDsArr[i]).append(",");
            if ((i + 1) % num != 0) continue;
            String ss = IDs.substring(0, IDs.lastIndexOf(","));
            if (i + 1 == num) {
                sqlStr.append("  in (").append(ss).append(")");
            } else {
                sqlStr.append(" or " + mark + " in (").append(ss).append(")");
            }
            IDs = new StringBuilder();
            lastIndex = i;
        }
        for (i = lastIndex + 1; i < IDsArr.length; ++i) {
            lastIDs.append(IDsArr[i]).append(",");
        }
        if (lastIDs.length() > 0) {
            sqlStr.append("  or " + mark + " in (").append(lastIDs.substring(0, IDs.lastIndexOf(","))).append(")");
        }
        String aaa = sqlStr.toString();
        logger.error((Object)"or in start ---------------------------------------------------------------");
        logger.error((Object)aaa);
        logger.error((Object)"or in end---------------------------------------------------------------");
        return sqlStr.toString();
    }

    public class KSQLDialect
    extends BaseDialect {
        @Override
        public String translateSql(String sql) throws SQLException {
            return sql;
        }

        @Override
        public String getLimitString(String sql, int from, int length) {
            if (length < 0) {
                return sql;
            }
            int topCount = from + length;
            int i = sql.toLowerCase().indexOf("select ");
            String s = "select top " + topCount + " " + sql.substring(i + 7);
            return s;
        }

        @Override
        public FaCreateTempTableResult executeSelectInto(Context ctx, String sql, SqlParams pp, Connection con, FaDBUtilConfig cf) throws BOSException, SQLException {
            BaseDialect.SelectIntoSql siq = new BaseDialect.SelectIntoSql(sql);
            siq.analysisSelectInto();
            StringBuffer sb = new StringBuffer().append("select * from(").append(siq.selectFields).append(siq.fromWhere).append(") as temp_ where 1=0");
            IRowSet rs = null;
            FaCreateTempTableResult result = new FaCreateTempTableResult();
            try {
                if (pp != null) {
                    int length = pp.getParams().length;
                    String sqlString = sb.toString();
                    for (int i = 0; i < length; ++i) {
                        String param = pp.getParams()[i].toString();
                        param = "'" + param.replaceAll("'", "") + "'";
                        sqlString = sqlString.replaceFirst("[?]", param);
                    }
                    logger.error((Object)"print log start----------------------------------------------------");
                    logger.error((Object)sb.toString());
                    logger.error((Object)pp);
                    logger.error((Object)"print log end----------------------------------------------------");
                    rs = DbUtil.executeQuery((Context)ctx, (String)sqlString);
                } else {
                    logger.error((Object)"print log start----------------------------------------------------");
                    logger.error((Object)sb.toString());
                    logger.error((Object)pp);
                    logger.error((Object)"print log end----------------------------------------------------");
                    rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
                }
                String createTableSql = this.buildCreateTableString(siq.intoTableName, rs.getMetaData(), cf);
                siq.intoTableName = TempTablePool.getInstance((Context)ctx).createTempTable(createTableSql);
                result.setTempTable(siq.intoTableName);
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
            StringBuffer si = new StringBuffer().append("insert into ").append(siq.intoTableName).append(" ").append(siq.selectFields).append(siq.fromWhere);
            result.setSuccessNum(FaDBUtil.executeUpdate(si.toString(), pp, con));
            return result;
        }
    }

    class MSsqlDialect
    extends KSQLDialect {
        MSsqlDialect() {
        }
    }

    class DB2Dialect
    extends BaseDialect {
        DB2Dialect() {
        }

        @Override
        public String translateSql(String sql) throws SQLException {
            try {
                return TransUtil.Translate((String)sql, (int)1);
            }
            catch (SqlTranslateException e) {
                throw new SQLException("translate sql exception, message is \n" + e.getMessage());
            }
        }

        @Override
        public String getLimitString(String ksql, int from, int length) throws SQLException {
            String sql = this.translateSql(ksql);
            sql = sql.substring(FaDBUtil.DIALECT_TAG.length());
            int startOfSelect = sql.toLowerCase().indexOf("select");
            StringBuffer pagingSelect = new StringBuffer(sql.length() + 100).append(FaDBUtil.DIALECT_TAG).append(sql.substring(0, startOfSelect)).append("select * from ( select ").append(this.getRowNumber(sql));
            if (this.hasDistinct(sql)) {
                pagingSelect.append(" row_.* from ( ").append(sql.substring(startOfSelect)).append(" ) as row_");
            } else {
                pagingSelect.append(sql.substring(startOfSelect + 6));
            }
            pagingSelect.append(" ) as temp_ where rownumber_ ");
            if (length >= 0) {
                pagingSelect.append("between " + (from < 0 ? 0 : from) + " and " + (from < 0 ? 0 : from + length - 1));
            } else {
                pagingSelect.append(">= " + (from < 0 ? 0 : from));
            }
            return pagingSelect.toString();
        }

        private boolean hasDistinct(String sql) {
            return sql.toLowerCase().indexOf("select distinct") >= 0;
        }

        private String getRowNumber(String sql) {
            StringBuffer rownumber = new StringBuffer(50).append("rownumber() over(");
            int orderByIndex = sql.toLowerCase().lastIndexOf("order by");
            if (orderByIndex > 0 && !this.hasDistinct(sql)) {
                rownumber.append(sql.substring(orderByIndex));
            }
            rownumber.append(") as rownumber_,");
            return rownumber.toString();
        }

        @Override
        public RptRowSet parseResultSet(ResultSet rs, int startIndex, int length) throws SQLException {
            return super.parseResultSet(rs, 0, -1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public FaCreateTempTableResult executeSelectInto(Context ctx, String sql, SqlParams pp, Connection con, FaDBUtilConfig cf) throws SQLException, BOSException {
            StringBuffer sb = new StringBuffer();
            BaseDialect.SelectIntoSql siq = this.analysisSelectInto(sql);
            siq.fromWhere = this.translateFromWhere(siq.fromWhere);
            siq.selectFields = this.translateSelect(siq.selectFields);
            sb.append(FaDBUtil.DIALECT_TAG).append(siq.selectFields).append(' ').append(siq.fromWhere).append(" FETCH FIRST 1 ROWS ONLY");
            PreparedStatement ps = con.prepareStatement(sb.toString(), 1004, 1007);
            ResultSet rs = null;
            FaCreateTempTableResult result = new FaCreateTempTableResult();
            try {
                if (pp != null) {
                    pp.putToStatement(ps);
                }
                rs = ps.executeQuery();
                String createTableSql = this.buildCreateTableString(siq.intoTableName, rs.getMetaData(), cf);
                try {
                    siq.intoTableName = TempTablePool.getInstance((Context)ctx).createTempTable(createTableSql);
                    result.setTempTable(siq.intoTableName);
                }
                catch (Exception e) {
                    throw new BOSException((Throwable)e);
                }
            }
            finally {
                SQLUtils.cleanup((ResultSet)rs, (Statement)ps);
            }
            StringBuffer si = new StringBuffer();
            si.append(FaDBUtil.DIALECT_TAG).append(" insert into ").append(siq.intoTableName).append(' ').append(siq.selectFields).append(' ').append(siq.fromWhere);
            result.setSuccessNum(FaDBUtil.executeUpdate(si.toString(), pp, con));
            return result;
        }
    }

    class OracleDialect
    extends BaseDialect {
        OracleDialect() {
        }

        @Override
        public String translateSql(String sql) throws SQLException {
            try {
                return TransUtil.Translate((String)sql, (int)2);
            }
            catch (SqlTranslateException e) {
                throw new SQLException("translate sql exception, message is \n" + e.getMessage());
            }
        }

        @Override
        public String getLimitString(String sql, int from, int length) {
            boolean limitLength = length >= 0;
            StringBuffer pagingSelect = new StringBuffer(sql.length() + 100);
            pagingSelect.append(FaDBUtil.DIALECT_TAG);
            pagingSelect.append("select * from ( select row_.*, rownum rownum_ from ( ");
            pagingSelect.append(sql);
            if (limitLength) {
                pagingSelect.append(" ) row_ where rownum < " + (from < 0 ? 0 : (from + length < 0 ? 0 : length)) + ") where rownum_ >= " + (from < 0 ? 0 : from));
            } else {
                pagingSelect.append(" ) ) where rownum >= " + (from < 0 ? 0 : from));
            }
            return pagingSelect.toString();
        }

        @Override
        public String getClearTable(String tableName) {
            return "/*dialect*/truncate table " + tableName + " drop storage";
        }

        @Override
        public RptRowSet parseResultSet(ResultSet rs, int startIndex, int length) throws SQLException {
            return super.parseResultSet(rs, 0, -1);
        }

        @Override
        public FaCreateTempTableResult executeSelectInto(Context ctx, String sql, SqlParams pp, Connection con, FaDBUtilConfig cf) throws SQLException, BOSException {
            return DIALECT_KSQL.executeSelectInto(ctx, sql, pp, con, cf);
        }
    }

    abstract class BaseDialect
    implements IDialect {
        BaseDialect() {
        }

        @Override
        public abstract String translateSql(String var1) throws SQLException;

        @Override
        public abstract String getLimitString(String var1, int var2, int var3) throws SQLException;

        @Override
        public abstract FaCreateTempTableResult executeSelectInto(Context var1, String var2, SqlParams var3, Connection var4, FaDBUtilConfig var5) throws SQLException, BOSException;

        @Override
        public String getClearTable(String tableName) {
            return "/*dialect*/delete from " + tableName;
        }

        @Override
        public RptRowSet parseResultSet(ResultSet rs, int startIndex, int length) throws SQLException {
            return RptRowSet.parse((ResultSet)rs, (int)startIndex, (int)length);
        }

        protected SelectIntoSql analysisSelectInto(String eKsql) {
            SelectIntoSql siq = new SelectIntoSql(eKsql);
            siq.analysisSelectInto();
            return siq;
        }

        public String buildCreateTableString(String tableName, ResultSetMetaData rsm, FaDBUtilConfig cf) throws SQLException {
            StringBuffer sql = new StringBuffer();
            sql.append("create table ").append(tableName).append("(\n");
            int columnCount = rsm.getColumnCount();
            for (int i = 1; i <= columnCount; ++i) {
                String colName;
                String typeName = rsm.getColumnTypeName(i);
                int type = rsm.getColumnType(i);
                int colSize = rsm.getColumnDisplaySize(i);
                if (colSize == 0) {
                    colSize = 1;
                }
                if ((colName = rsm.getColumnName(i)).equalsIgnoreCase("adminNum") || colName.equalsIgnoreCase("adminDepartment")) {
                    type = 12;
                }
                sql.append("\n").append(colName).append("\t");
                switch (type) {
                    case -6: 
                    case -5: 
                    case 4: 
                    case 5: {
                        sql.append("int");
                        break;
                    }
                    case 2: 
                    case 6: 
                    case 7: 
                    case 8: {
                        sql.append("decimal(").append(19).append(",").append("MONTHDEPRERATE".equalsIgnoreCase(colName) || "TAXMonthDepreRate".equalsIgnoreCase(colName) ? 9 : 4).append(")");
                        break;
                    }
                    case 3: {
                        sql.append("decimal(").append(19).append(",").append("MONTHDEPRERATE".equalsIgnoreCase(colName) || "TAXMonthDepreRate".equalsIgnoreCase(colName) ? 9 : 4).append(")");
                        break;
                    }
                    case -15: 
                    case -9: 
                    case 1: 
                    case 12: {
                        String colType = "nvarchar";
                        int tmpSize = -1;
                        if (cf != null) {
                            tmpSize = cf.getFiledSize(colName);
                        }
                        if (tmpSize != -1) {
                            colSize = tmpSize;
                        } else {
                            int rate = 1;
                            if (cf != null) {
                                rate = cf.getFiledConfig(colName);
                            }
                            int n = colSize = colSize * rate > 250 ? 250 : colSize * rate;
                            if (colName.toUpperCase(Locale.getDefault()).endsWith("ID")) {
                                colSize = 44;
                            } else if (colName.toUpperCase(Locale.getDefault()).endsWith("NAME") || colName.equalsIgnoreCase("adminNum") || colName.equalsIgnoreCase("adminDepartment")) {
                                colSize = 200;
                            } else if (colName.toUpperCase(Locale.getDefault()).equals("SPECS") || colName.toUpperCase(Locale.getDefault()).equals("REMARK")) {
                                colSize = 800;
                            }
                            if (colSize == 0) {
                                colSize = 80;
                            }
                        }
                        if (colName.toUpperCase(Locale.getDefault()).endsWith("ID")) {
                            colType = "varchar";
                        }
                        if (colName.equalsIgnoreCase("COSTCENTER")) {
                            colSize = 800;
                        }
                        if (colName.equalsIgnoreCase("BCOSTCENTER")) {
                            colSize = 800;
                        }
                        sql.append(colType).append("(").append(colSize).append(")");
                        break;
                    }
                    case -1: {
                        sql.append("varchar(" + colSize + ")");
                        break;
                    }
                    case -2: {
                        sql.append("BINARY(" + colSize + ")");
                        break;
                    }
                    case -4: 
                    case -3: {
                        sql.append("VARBINARY(" + colSize + ")");
                        break;
                    }
                    case 2004: {
                        sql.append("BLOB(" + colSize + ")");
                        break;
                    }
                    case 2005: {
                        if (colSize > 0x40000000) {
                            colSize = 0x40000000;
                        }
                        sql.append("CLOB(" + colSize + ")");
                        break;
                    }
                    case 91: 
                    case 92: 
                    case 93: {
                        sql.append("DateTime");
                        break;
                    }
                    default: {
                        throw new SQLException("invalid col.DataType:" + typeName + " Type(" + type + ")", "");
                    }
                }
                sql.append(",");
            }
            sql.deleteCharAt(sql.length() - 1);
            sql.append("\n)");
            return sql.toString();
        }

        protected String translateSelect(String selectPartKsql) throws SQLException {
            String select = this.translateSql(selectPartKsql + " FROM A");
            select = select.substring(0, select.length() - " FROM A".length());
            return select;
        }

        protected String translateFromWhere(String fromWherePartKsql) throws SQLException {
            String fw = this.translateSql("SELECT 1 " + fromWherePartKsql);
            fw = fw.substring("SELECT 1 ".length());
            return fw;
        }

        class SelectIntoSql {
            String originalSql;
            String selectFields;
            String intoTableName;
            String fromWhere;

            SelectIntoSql(String sql) {
                this.originalSql = sql;
            }

            public SelectIntoSql analysisSelectInto() {
                char[] chs = this.originalSql.toCharArray();
                int intoPos = -1;
                StringBuffer sf = new StringBuffer();
                int quote = 0;
                for (int i = 0; i < chs.length; ++i) {
                    char ch = chs[i];
                    if (ch == '\'') {
                        ++quote;
                    } else if (ch == ' ' && quote % 2 == 0 && (intoPos = this.nextIsInto(chs, i + 1)) != -1) {
                        sf.append(ch);
                        break;
                    }
                    sf.append(ch);
                }
                this.selectFields = sf.toString();
                int tabPos = intoPos + "into ".length();
                this.intoTableName = this.nextWord(chs, tabPos);
                String buf = this.originalSql.substring(tabPos);
                int fromWherePos = buf.indexOf(this.intoTableName);
                this.fromWhere = buf.substring(fromWherePos + this.intoTableName.length() + 1);
                return this;
            }

            private int nextIsInto(char[] chs, int from) {
                int beginPos = -1;
                StringBuffer sb = new StringBuffer();
                int len = chs.length;
                boolean enterWord = false;
                for (int i = from; i < len; ++i) {
                    char ch = chs[i];
                    if (ch == ' ') {
                        if (!enterWord) continue;
                        break;
                    }
                    if (!enterWord) {
                        enterWord = true;
                        beginPos = i;
                    }
                    sb.append(ch);
                }
                if ("into".equalsIgnoreCase(sb.toString())) {
                    return beginPos;
                }
                return -1;
            }

            private String nextWord(char[] chs, int from) {
                StringBuffer sb = new StringBuffer();
                int len = chs.length;
                boolean enterWord = false;
                for (int i = from; i < len; ++i) {
                    char ch = chs[i];
                    if (ch == ' ' || ch == '\n') {
                        if (!enterWord) continue;
                        break;
                    }
                    if (!enterWord) {
                        enterWord = true;
                    }
                    sb.append(ch);
                }
                return sb.toString();
            }
        }
    }

    static interface IDialect {
        public String translateSql(String var1) throws SQLException;

        public String getLimitString(String var1, int var2, int var3) throws SQLException;

        public FaCreateTempTableResult executeSelectInto(Context var1, String var2, SqlParams var3, Connection var4, FaDBUtilConfig var5) throws SQLException, BOSException;

        public String getClearTable(String var1);

        public RptRowSet parseResultSet(ResultSet var1, int var2, int var3) throws SQLException;
    }
}

