/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.rpt.app.dao;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.app.FaLocalUtils;
import com.kingdee.eas.fi.fa.rpt.FaDBUtilConfig;
import com.kingdee.eas.fi.fa.rpt.app.dao.FaDaoBase;
import com.kingdee.eas.util.app.DbUtil;
import java.util.Map;

public class FaAmountStatRptDao
extends FaDaoBase {
    protected String sumSql;
    private boolean isByEvalue;
    private boolean isByInit;

    @Override
    protected void initEvVar(EntityViewInfo ev) throws EASBizException, BOSException {
        super.initEvVar(ev);
        Map m = (Map)ev.get("customcond");
        this.isByEvalue = (Boolean)m.get("isByEvalue");
        this.isByInit = (Boolean)m.get("initperiod");
    }

    @Override
    protected void buildSql() {
        StringBuffer sql = new StringBuffer();
        sql.append(" DISTINCT FACURCARD.FId , ");
        if (this.sumOption.isHasSum()) {
            String strNameFields = this.sumOption.getStrNameFields();
            String oldString = "MeasureUnit.FName_" + this.ctx.getLocale().toString() + " AS MeasureUnitName";
            String newString = "concat(concat(MeasureUnit.FNumber,'-'),MeasureUnit.FName_" + this.ctx.getLocale().toString() + ") AS MeasureUnitName";
            if (strNameFields.indexOf(oldString) >= 0) {
                strNameFields = strNameFields.replace(oldString, newString);
            }
            sql.append(strNameFields + ", ");
        }
        sql.append(" FACURCARD.FAssetAmt , ");
        if (this.isByEvalue) {
            sql.append("CASE FACURCARD.FIsEvaledBefore WHEN 0 THEN FACURCARD.FAssetValue ELSE FACURCARD.FInitEvalValue END AS FAssetValue, ");
        } else {
            sql.append("FACURCARD.FAssetValue AS FAssetValue, ");
        }
        sql.append(" 0 AS isSum  ");
        sql.append(this.def.getSelectPart(""));
        if (this.isVirCompany) {
            sql.append(",FACURCARD.CompanyFLevel AS SumLevel");
        }
        if (this.sumOption.isHasSum()) {
            sql.append(", ").append(this.sumOption.getStrLongNumberFields());
        }
        this.daoSql.setSelect(sql.toString());
        sql = new StringBuffer();
        this.getCardSql(sql);
        sql.append(" INNER JOIN T_BD_Address AS STORECITY ON FACURCARD.FStoreCityID = STORECITY.FID");
        sql.append(" LEFT OUTER JOIN T_BD_MeasureUnit AS MEASUREUNIT ON FACURCARD.FMeasureUnitID = MEASUREUNIT.FID");
        sql.append(" INNER JOIN T_ORG_Admin AS DEPT ON FACURCARD.FDeptID = DEPT.FID");
        String tableName = "";
        if (this.isVirCompany && (tableName = this.getSumItemJoinSql("orgArchitecture")) != null) {
            sql.append(" INNER JOIN ").append(tableName).append(" AS ").append("orgArchitecture");
            sql.append(" ON FACURCARD.FCompanyID = ").append("orgArchitecture").append(".FID");
        }
        tableName = this.isLevelSum("assetCat") ? this.getSumItemJoinSql("assetCat") : this.getSumItemTableName("assetCat");
        sql.append(" INNER JOIN ").append(tableName).append(" AS ").append("assetCat");
        sql.append(" ON FACURCARD.FAssetCatID = ").append("assetCat").append(".FID");
        tableName = this.isLevelSum("originMethod") ? this.getSumItemJoinSql("originMethod") : this.getSumItemTableName("originMethod");
        sql.append(" INNER JOIN ").append(tableName).append(" AS ").append("originMethod");
        sql.append(" ON FACURCARD.FOriginMethodID = ").append("originMethod").append(".FID");
        tableName = this.isLevelSum("useStatus") ? this.getSumItemJoinSql("useStatus") : this.getSumItemTableName("useStatus");
        sql.append(" INNER JOIN ").append(tableName).append(" AS ").append("useStatus");
        sql.append(" ON FACURCARD.FUseStatusID = ").append("useStatus").append(".FID");
        if (this.isSum("useDepartment") || this.filter != null && this.filter.indexOf("useDepartment.fnumber") != -1) {
            tableName = this.isLevelSum("useDepartment") ? this.getSumItemJoinSql("useDepartment") : this.getSumItemTableName("useDepartment");
            sql.append(" INNER JOIN ").append(tableName).append(" AS ").append("useDepartment");
            sql.append(" ON FACURCARD.FUseDepartmentID = ").append("useDepartment").append(".FID");
        }
        if (this.isSum("asstActItem") || this.filter != null && (this.filter.indexOf("asstActItem.fname_l2") != -1 || this.filter.indexOf("asstActType.fnumber") != -1)) {
            tableName = this.isLevelSum("asstActItem") ? this.getSumItemJoinSql("asstActItem") : this.getSumItemTableName("asstActItem");
            sql.append(" INNER JOIN ").append(tableName).append(" AS ").append("asstActItem");
            sql.append(" ON FACURCARD.FAsstActTypeID = ").append("asstActItem").append(".FAsstacttypeID");
            sql.append(" and FACURCARD.FAsstActItem = ").append("asstActItem").append(".FID");
            sql.append(" INNER JOIN ").append(this.getSumItemTableName("asstActType")).append(" AS ").append("asstActType");
            sql.append(" ON ").append("asstActItem").append(".FAsstActTypeID = ").append("asstActType").append(".FID");
        }
        this.daoSql.setFrom(sql.toString());
        sql = new StringBuffer();
        if (this.filter != null) {
            sql.append(this.filter);
        }
        this.daoSql.setWhere(sql.toString());
        sql = new StringBuffer();
        if (this.sumOption.isHasSum()) {
            sql.append(this.sumOption.getStrSelectResult() + ", ");
        }
        sql.append(" FAssetAmt, FAssetValue ");
        sql.append(this.def.getSelectPart(""));
        if (this.isVirCompany) {
            sql.append(", SumLevel , isSum ");
        }
        this.resultSql.setSelect(sql.toString());
        this.resultSql.setWhere(" isSum = 1 ");
        this.resultSql.setOrder(this.sorter);
    }

    private void getCardSql(StringBuffer sql) {
        if (this.isVirCompany && !this.isByInit) {
            sql.append("(");
            this.getCurCardSql(sql);
            sql.append(" UNION ALL ");
            this.getMonCardSql(sql);
            sql.append(") AS FACURCARD");
        } else {
            sql.append("(");
            if (this.isCurrPeriod) {
                this.getCurCardSql(sql);
            } else {
                this.getMonCardSql(sql);
            }
            sql.append(") AS FACURCARD");
        }
    }

    private void getMonCardSql(StringBuffer sql) {
        sql.append(" SELECT FACURCARD.FAssetValue,FACURCARD.FId,FACURCARD.FAssetAmt,FACURCARD.FIsEvaledBefore,FACURCARD.FInitEvalValue,FaCurCard.fnumber,FaCurCard.foldNumber,");
        sql.append(" FACURCARD.FStoreCityID,FACURCARD.FMeasureUnitID,FACURCARD.FDeptID,FACURCARD.FCompanyID,FACURCARD.FAssetCatID,FaCurCard.fassetName,");
        sql.append(" FACURCARD.FOriginMethodID,FACURCARD.FUseStatusID,FACURDEPARTMENT.FUseDepartmentID,COMPOSIT.FAsstActType AS FAsstActTypeID,");
        sql.append(" COMPOSIT.FAsstActItem," + (this.isByInit ? "" : "PERIOD.FPERIODYEAR,PERIOD.FPERIODNUMBER,") + "FACURCARD.fDeletedStatus,COMPANY.FLevel AS CompanyFLevel");
        sql.append(this.def.getSelectPart(null));
        sql.append(" FROM T_FA_FaMonCard AS FACURCARD");
        sql.append(" INNER JOIN T_ORG_COMPANY AS COMPANY ON FACURCARD.FCOMPANYID = COMPANY.FID");
        if (!this.isByInit) {
            sql.append(" LEFT OUTER JOIN T_BD_Period AS PERIOD ON FACURCARD.FFaPeriodID = PERIOD.FID");
        }
        sql.append(" LEFT OUTER JOIN T_FA_FaMonCostCenter AS FACURCOSTCENTER ON FACURCARD.FID = FACURCOSTCENTER.FFaMonCardID ");
        sql.append(" LEFT OUTER JOIN T_FA_FAMonASSTACTCOMPOSIT COMPOSIT ON COMPOSIT.FFAMonCOSTCENTERID = FACURCOSTCENTER.FID");
        sql.append(" LEFT OUTER JOIN T_FA_FaMonDepartment AS FACURDEPARTMENT ON FACURCARD.FID = FACURDEPARTMENT.FFaMonCardID");
        try {
            sql.append(this.def.getJoinPart("FACURCARD.FPropertyValueID"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        sql.append(" WHERE " + this.getCompanyFilter(false) + " AND FACURCARD.FCheckedStatus = 2 AND FACURCARD.fDeletedStatus != 2");
        if (!this.isByInit) {
            sql.append(" AND period.fperiodyear = " + this.startYear + " AND period.fperiodnumber = " + this.startNumber);
        } else {
            sql.append(" AND FACURCARD.FFaPeriodID is null");
        }
        sql.append(" AND FACURCARD.FLaterPeriodData = 0");
    }

    private void getCurCardSql(StringBuffer sql) {
        sql.append(" SELECT FACURCARD.FAssetValue,FACURCARD.FId,FACURCARD.FAssetAmt,FACURCARD.FIsEvaledBefore,FACURCARD.FInitEvalValue,FaCurCard.fnumber,FaCurCard.foldNumber,");
        sql.append(" FACURCARD.FStoreCityID,FACURCARD.FMeasureUnitID,FACURCARD.FDeptID,FACURCARD.FCompanyID,FACURCARD.FAssetCatID,FaCurCard.fassetName,");
        sql.append(" FACURCARD.FOriginMethodID,FACURCARD.FUseStatusID,FACURDEPARTMENT.FUseDepartmentID,COMPOSIT.FAsstActType AS FAsstActTypeID,");
        sql.append(" COMPOSIT.FAsstActItem,PERIOD.FPERIODYEAR,PERIOD.FPERIODNUMBER,FACURCARD.fDeletedStatus,COMPANY.FLevel AS CompanyFLevel");
        sql.append(this.def.getSelectPart(null));
        sql.append(" FROM T_FA_FaCurCard AS FACURCARD");
        sql.append(" INNER JOIN T_ORG_COMPANY AS COMPANY ON FACURCARD.FCOMPANYID = COMPANY.FID");
        sql.append(" LEFT OUTER JOIN T_BD_Period AS PERIOD ON FACURCARD.FPeriodID = PERIOD.FID ");
        sql.append(" LEFT OUTER JOIN T_FA_FaCurCostCenter AS FACURCOSTCENTER ON FACURCARD.FID = FACURCOSTCENTER.FFaCurCardID ");
        sql.append(" LEFT OUTER JOIN T_FA_FACURASSTACTCOMPOSIT COMPOSIT ON COMPOSIT.FFACURCOSTCENTERID = FACURCOSTCENTER.FID");
        sql.append(" LEFT OUTER JOIN T_FA_FaCurDepartment AS FACURDEPARTMENT ON FACURCARD.FID = FACURDEPARTMENT.FFaCurCardID");
        try {
            sql.append(this.def.getJoinPart("FACURCARD.FPropertyValueID"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        sql.append(" WHERE " + this.getCompanyFilter(true) + " AND FACURCARD.FCheckedStatus = 2 AND FACURCARD.fDeletedStatus != 2");
        sql.append(" and Period.FNumber <= ").append(this.startYear * 100 + this.startNumber);
    }

    private String getCompanyFilter(boolean isCurrPeriod) {
        StringBuffer sbff = new StringBuffer();
        if (this.isVirCompany) {
            StringBuffer companyQuery = new StringBuffer();
            companyQuery.append(" SELECT company.fid FROM t_bd_SystemStatusCtrol ssc");
            companyQuery.append(" INNER JOIN t_bd_period period ON ssc.fcurrentperiodid = period.fid");
            companyQuery.append(" INNER JOIN t_org_company company ON ssc.fcompanyid = company.fid");
            companyQuery.append(" INNER JOIN t_bd_SystemStatus ss on ss.fid=ssc.fsystemstatusid");
            companyQuery.append(" WHERE ss.fname= ").append(14);
            if (!this.isByInit) {
                if (isCurrPeriod) {
                    companyQuery.append(" AND period.FPeriodYear = ?");
                    companyQuery.append(" AND period.fperiodnumber = ?");
                    this.params.addInt(this.startYear);
                    this.params.addInt(this.startNumber);
                } else {
                    companyQuery.append(" AND (period.FPeriodYear > ?");
                    companyQuery.append(" OR (period.FPeriodYear = ?");
                    companyQuery.append(" AND period.fperiodnumber > ?))");
                    this.params.addInt(this.startYear);
                    this.params.addInt(this.startYear);
                    this.params.addInt(this.startNumber);
                }
            }
            companyQuery.append(" AND company.fid IN (").append(this.strCompanyInclude).append(")");
            sbff.append(" FACURCARD.FCOMPANYID IN (").append(companyQuery).append(")");
        } else {
            sbff.append(" FACURCARD.FCOMPANYID = '" + this.currCompanyInfo.getId().toString() + "' ");
        }
        return sbff.toString();
    }

    @Override
    protected void buildData() throws BOSException {
        this.addDataTempTable(FaLocalUtils.transformLocal((Context)this.ctx, (String)this.daoSql.getSql()));
        this.resultSql.setFrom(this.tempTable);
        String select = " SUM(FAssetAmt) AS FAssetAmt, SUM(FAssetValue) AS FAssetValue, 1 AS isSum ";
        String distinctSelect = "FId,FAssetAmt,FAssetValue ";
        String sumSelect = null;
        String group = null;
        if (this.isVirCompany) {
            select = select + this.def.getSelectSumPart("");
            distinctSelect = distinctSelect + this.def.getNumFieldForSumPart();
        } else {
            sumSelect = select + this.def.getSelectSumPart("");
            select = select + this.def.getSelectSumPart("", false);
            distinctSelect = distinctSelect + this.def.getSelectPart("");
        }
        String where = "isSum = 0 ";
        this.sumSql = this.sumOption.getSumSql(this.tempTable, select, distinctSelect, where, group, false, sumSelect, false);
        if (this.sumSql != null && this.sumSql.trim().length() > 0) {
            DbUtil.execute((Context)this.ctx, (String)FaLocalUtils.transformLocal((Context)this.ctx, (String)this.sumSql));
        }
    }

    @Override
    protected String getFirstDisplayField() {
        return "MeasureUnitName";
    }

    @Override
    public Map getResult() throws BOSException {
        Map result = super.getResult();
        if (this.isVirCompany) {
            result.put("amtScal", this.getMaxAmtScal());
        }
        return result;
    }

    @Override
    protected String modifyDefFilterSql(String f) {
        return this.def.property2FieldAtFilterByWrapped(f);
    }

    @Override
    protected void tableFieldConfig(FaDBUtilConfig cf) {
        cf.addFiledSize("USEDEPARTMENT1NAME", 800);
        cf.addFiledSize("USEDEPARTMENT2NAME", 800);
        cf.addFiledSize("USEDEPARTMENT3NAME", 800);
        cf.addFiledSize("USEDEPARTMENT4NAME", 800);
        cf.addFiledSize("USEDEPARTMENT5NAME", 800);
        cf.addFiledSize("FNAME_L2", 800);
    }

    @Override
    protected String buildFilterSql(EntityViewInfo ev) {
        FilterInfo filterInfo = ev.getFilter();
        if (filterInfo == null || filterInfo.getFilterItems() == null || filterInfo.getFilterItems().isEmpty()) {
            return null;
        }
        String f = ev.getFilter().toString();
        return this.modifyDefFilterSql(f);
    }
}

