/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.rpt.app.dao;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.fa.manage.FaManageUtils;
import com.kingdee.eas.fi.fa.rpt.FaCreateTempTableResult;
import com.kingdee.eas.fi.fa.rpt.FaDBUtil;
import com.kingdee.eas.fi.fa.rpt.FaDBUtilConfig;
import com.kingdee.eas.fi.fa.rpt.app.FaRptLocalUtils;
import com.kingdee.eas.fi.fa.rpt.app.dao.FaDAO;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.JdbcRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class FaChgListRptDao
extends FaDAO {
    private EntityViewInfo ev;
    private static String fName;
    boolean isCurPeriod;
    private int year;
    private int month;
    private boolean bIncludeClnCard;
    private boolean bIncludeNotAuditCard;
    private String AcctAsstTableName;
    private static String local;

    public static FaChgListRptDao getFaChgListRptDao(Context ctx) {
        FaChgListRptDao dao = new FaChgListRptDao();
        dao.ctx = ctx;
        dao.locale = ctx.getLocale().toString();
        fName = "FName_" + dao.locale;
        local = dao.locale.toString();
        return dao;
    }

    private void initEvVar(EntityViewInfo ev) throws BOSException, EASBizException {
        this.ev = ev;
        PeriodInfo currPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)this.ctx, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)ContextUtil.getCurrentFIUnit((Context)this.ctx));
        this.year = new Integer(currPeriod.getPeriodYear());
        this.month = new Integer(currPeriod.getPeriodNumber());
        this.AcctAsstTableName = this.getAsstActItemTable(this.ctx);
    }

    private boolean isCurrentPeriod() throws BOSException, EASBizException {
        return true;
    }

    public Map findChgRecordList(EntityViewInfo ev) throws EASBizException, BOSException {
        this.initEvVar(ev);
        this.isCurPeriod = this.isCurrentPeriod();
        String cardId = (String)ev.get("cardId");
        HashMap<String, Object> rtnValue = new HashMap<String, Object>();
        IRowSet cardSet = this.getCardChgListRowSet(cardId);
        ArrayList<String> idList = new ArrayList<String>();
        try {
            while (cardSet.next()) {
                idList.add(cardSet.getString("FID"));
            }
            cardSet.beforeFirst();
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        rtnValue.put("chglist", cardSet);
        rtnValue.put("costcenter", this.findCostcenter(cardId, idList));
        rtnValue.put("UseDepartment", this.findUseDept(cardId, idList));
        return rtnValue;
    }

    private String handleIDList(ArrayList idList) {
        if (idList.size() == 0) {
            return " in ('') ";
        }
        StringBuffer sb = new StringBuffer(" in (");
        for (int i = 0; i < idList.size(); ++i) {
            sb.append(i == 0 ? "'" + idList.get(i).toString() + "'" : ",'" + idList.get(i).toString() + "'");
        }
        sb.append(" ) ");
        return sb.toString();
    }

    public IRowSet findChgCardIdList(EntityViewInfo ev) throws EASBizException, BOSException {
        FaRptLocalUtils.chgNumberKeyWord(ev);
        this.initEvVar(ev);
        this.isCurPeriod = this.isCurrentPeriod();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        JdbcRowSet result = null;
        Connection conn = null;
        try {
            conn = this.getConnection(this.ctx);
            stmt = conn.prepareStatement(this.getCardSql());
            rs = stmt.executeQuery();
            result = new JdbcRowSet();
            result.populate(rs);
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return result;
    }

    private Map findCostcenter(String cardId, ArrayList idList) throws EASBizException, BOSException {
        HashMap<String, String> costcenters = new HashMap<String, String>();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        Connection conn = null;
        try {
            conn = this.getConnection(this.ctx);
            stmt = conn.prepareStatement(this.getCostCenterSql(cardId, idList));
            rs = stmt.executeQuery();
            String preCardId = null;
            String curCardId = null;
            StringBuffer costcenter = new StringBuffer();
            while (rs.next()) {
                curCardId = rs.getString("CARDID");
                if (preCardId != null && !preCardId.equals(curCardId)) {
                    costcenter.delete(costcenter.length() - 1, costcenter.length());
                    costcenters.put(preCardId, costcenter.toString());
                    costcenter = new StringBuffer();
                }
                costcenter.append(rs.getString("accountViewNumber"));
                costcenter.append("-");
                costcenter.append(rs.getString("accountViewName"));
                costcenter.append(" ");
                costcenter.append(rs.getBigDecimal("FApportionScale").setScale(2));
                costcenter.append("%");
                costcenter.append(" ");
                if (rs.getString("FasstActLName") != null && rs.getString("FasstActLName").trim().length() != 0) {
                    costcenter.append(rs.getString("FasstActLName"));
                    costcenter.append(" ");
                }
                costcenter.append(";");
                preCardId = curCardId;
            }
            if (costcenter.length() > 0) {
                costcenter.delete(costcenter.length() - 1, costcenter.length());
                costcenters.put(preCardId, costcenter.toString());
            }
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return costcenters;
    }

    private Map findUseDept(String cardId, ArrayList idList) throws EASBizException, BOSException {
        HashMap<String, String> useDepts = new HashMap<String, String>();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        Connection conn = null;
        try {
            conn = this.getConnection(this.ctx);
            stmt = conn.prepareStatement(this.getUseDeptSql(cardId, idList));
            rs = stmt.executeQuery();
            String preCardId = null;
            String curCardId = null;
            StringBuffer useDept = new StringBuffer();
            while (rs.next()) {
                curCardId = rs.getString("CARDID");
                if (preCardId != null && !preCardId.equals(curCardId)) {
                    useDept.delete(useDept.length() - 1, useDept.length());
                    useDepts.put(preCardId, useDept.toString());
                    useDept = new StringBuffer();
                }
                boolean isDisplayDeptLName = FaManageUtils.isDisPlayDeptLName((Context)this.ctx);
                String useDeptName = "";
                useDeptName = isDisplayDeptLName ? rs.getString("UseDepartmentLName") : rs.getString("UseDepartment");
                useDept.append(useDeptName);
                useDept.append(" ");
                useDept.append(";");
                preCardId = curCardId;
            }
            if (useDept.length() > 0) {
                useDept.delete(useDept.length() - 1, useDept.length());
                useDepts.put(preCardId, useDept.toString());
            }
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return useDepts;
    }

    private IRowSet getCardChgListRowSet(String cardId) throws EASBizException, BOSException {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        JdbcRowSet result = null;
        Connection conn = null;
        try {
            conn = this.getConnection(this.ctx);
            stmt = conn.prepareStatement(this.getDetailSql(cardId));
            rs = stmt.executeQuery();
            result = new JdbcRowSet();
            result.populate(rs);
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return result;
    }

    public IRowSet getCardInfo(EntityViewInfo ev) throws EASBizException, BOSException {
        this.initEvVar(ev);
        this.isCurPeriod = this.isCurrentPeriod();
        String id = (String)ev.get("cardId");
        PreparedStatement stmt = null;
        ResultSet rs = null;
        JdbcRowSet result = null;
        Connection conn = null;
        try {
            conn = this.getConnection(this.ctx);
            stmt = conn.prepareStatement(this.getCardInfoSql(id));
            rs = stmt.executeQuery();
            result = new JdbcRowSet();
            result.populate(rs);
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return result;
    }

    private String getCardSql() throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT ");
        sql.append("A.ID2 ");
        sql.append("FROM ");
        sql.append("(");
        sql.append("\n");
        sql.append(this.getChangeBillSql());
        sql.append("\n");
        sql.append("UNION ");
        sql.append("\n");
        sql.append(this.getCleanBillSql());
        sql.append("\n");
        sql.append("UNION ");
        sql.append("\n");
        sql.append(this.getNewCardSql());
        sql.append("\n");
        sql.append(") AS A ");
        sql.append(this.getJoinSql());
        sql.append("WHERE 1=1 ");
        sql.append(this.getCondSql());
        if (this.getSorterSql().length() > 0) {
            sql.append(" ORDER BY ");
            sql.append(this.getSorterSql());
        }
        return sql.toString();
    }

    private String getJoinSql() {
        StringBuffer sql = new StringBuffer();
        sql.append("LEFT OUTER JOIN T_FA_FACURCARD AS CURCARD ");
        sql.append("ON A.ID2 = CURCARD.FID ");
        sql.append("LEFT OUTER JOIN T_FA_DepreciationMode AS DEPRMETHOD ");
        sql.append("ON A.FDeprMethodID = DEPRMETHOD.FID ");
        sql.append("LEFT OUTER JOIN T_BD_MeasureUnit AS MEASUREUNITWL ");
        sql.append("ON A.FMeasureUnitWLID = MEASUREUNITWL.FID ");
        sql.append("LEFT OUTER JOIN T_BD_Currency AS CURRENCY ");
        sql.append("ON A.FCurrencyID = CURRENCY.FID ");
        sql.append("LEFT OUTER JOIN T_BD_Person AS KEEPER ");
        sql.append("ON A.FKeeperID = KEEPER.FID ");
        sql.append("LEFT OUTER JOIN T_ORG_Admin AS DEPT_ADMIN ");
        sql.append("ON A.FDeptID = DEPT_ADMIN.FID ");
        sql.append("LEFT OUTER JOIN T_ORG_BaseUnit AS DEPT ");
        sql.append("ON DEPT_ADMIN.FID = DEPT.FID ");
        sql.append("LEFT OUTER JOIN T_FA_Cat AS ASSETCAT ");
        sql.append("ON A.FAssetCatID = ASSETCAT.FID ");
        sql.append("LEFT OUTER JOIN T_BD_MeasureUnit AS MEASUREUNIT ");
        sql.append("ON A.FMeasureUnitID = MEASUREUNIT.FID ");
        sql.append("LEFT OUTER JOIN T_FA_AlterMode AS changemode ");
        sql.append("ON A.changemode = changemode.FID ");
        sql.append("LEFT OUTER JOIN T_FA_UseStatus AS USESTATUS ");
        sql.append("ON A.FUseStatusID = USESTATUS.FID ");
        sql.append("LEFT OUTER JOIN T_FA_FaEconomicPurp AS EconomicPurp ");
        sql.append("ON A.FEconomicPurpID = EconomicPurp.FID ");
        sql.append("LEFT OUTER JOIN T_BD_Address AS STORECITY ");
        sql.append("ON A.FStoreCityID = STORECITY.FID ");
        sql.append("LEFT OUTER JOIN T_ORG_Company AS COMPANY ");
        sql.append("ON A.FCompanyID = COMPANY.FID ");
        if (this.isCurPeriod) {
            sql.append("LEFT OUTER JOIN T_FA_FaCurCostCenter AS FACOSTCENTER ");
            sql.append("ON A.ID2 = FACOSTCENTER.FFaCurCardID ");
        } else {
            sql.append("LEFT OUTER JOIN T_FA_FaMonCostCenter AS FACOSTCENTER ");
            sql.append("ON A.ID2 = FACOSTCENTER.FFaMonCardID ");
        }
        sql.append("LEFT OUTER JOIN ").append(this.AcctAsstTableName).append(" AS COSTCENTER ");
        sql.append("ON FACOSTCENTER.FAsstActItem = COSTCENTER.FID ");
        sql.append("LEFT OUTER JOIN t_fa_facurdepartment AS org_useDepartment ");
        sql.append("ON A.ID2 = org_useDepartment.FFaCurCardID ");
        sql.append("LEFT OUTER JOIN T_ORG_BaseUnit AS useDepartment ");
        sql.append("ON org_useDepartment.FuseDepartmentID = useDepartment.FID ");
        return sql.toString();
    }

    private String getChangeBillSql() throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("(SELECT ");
        if (this.isCurPeriod) {
            sql.append("D.FID AS ID2, ");
        } else {
            sql.append("D.FFACURCARDID AS ID2, ");
        }
        sql.append("D.FNumber AS ASSETNUMBER, ");
        sql.append("D.FAssetName AS ASSETNAME, ");
        sql.append("D.FAssetAmt AS ASSETAMT, ");
        sql.append("D.FFIAccountDate AS ACCOUNTDATE, ");
        sql.append("D.FEconomicPurpID AS FECONOMICPURPID, ");
        sql.append("D.FSpecs AS SPECS, ");
        sql.append("D.FPArea AS PAREA, ");
        sql.append("D.FMfr AS MFR, ");
        sql.append("D.FLevFrDate AS LEVFRDATE, ");
        sql.append(this.getOriginUnitSql("D.forigintype", "D.FOriginUnit") + " AS ORIGINUNIT, ");
        sql.append("D.FPaperNo AS PAPERNO, ");
        sql.append("D.FExRate AS EXRATE, ");
        sql.append("D.FOriginAmt AS ORIGINAMT, ");
        sql.append("D.FTreatmentIncome AS TREATMENTINCOME, ");
        sql.append("D.FAddons AS ADDONS, ");
        sql.append("D.FAddonFare AS ADDONFARE, ");
        sql.append("D.FAssetValue AS ASSETVALUE, ");
        sql.append("D.FBuyValue AS BUYVALUE, ");
        sql.append("D.FBuyAccuDepr AS BUYACCUDEPR, ");
        sql.append("D.FDeliverDate AS DELIVERDATE, ");
        sql.append("D.FStartUseDate AS STARTUSEDATE, ");
        sql.append("D.FUseYears AS USEYEARS, ");
        sql.append("D.FUseTermCount AS USETERMCOUNT, ");
        sql.append("D.FDeprTermCount AS DEPRTERMCOUNT, ");
        sql.append("D.FAccuDepr AS ACCUDEPR, ");
        sql.append("D.FAccuDeprTYear AS ACCUDEPRTYEAR, ");
        sql.append("D.FNeatRemValue AS NEATREMVALUE, ");
        sql.append("D.FNeatValue AS NEATVALUE, ");
        sql.append("D.FDecValue AS DECVALUE, ");
        sql.append("D.FNeatAmt AS NEATAMT, ");
        sql.append("D.FRemark AS REMARK, ");
        sql.append("A.FCHANGEDATE AS CHANGEDATE, ");
        sql.append("A.FCHANGEMODEID AS CHANGEMODE, ");
        sql.append("D.FCheckedStatus AS CHECKEDSTATUS, ");
        sql.append("D.FHasChanged AS HASCHANGED, ");
        sql.append("D.FHasCleared AS HASCLEARED, ");
        sql.append("D.FDeprMethodID, D.FMeasureUnitWLID, D.FCurrencyID, D.FKeeperID, ");
        sql.append("D.FDeptID, D.FAssetCatID, D.FMeasureUnitID, D.FOriginMethodID, ");
        sql.append("D.FUseStatusID, D.FStoreCityID, D.FCompanyID, D.foriginDif as originDif, d.faccuDeprChg as accuDeprChg, d.fdecValueChg as decValueChg, ");
        sql.append("(D.FUseTermCount - D.FDeprTermCount) as LeftTermCount ");
        sql.append("FROM T_FA_FACHANGEBILL AS A ");
        sql.append("LEFT OUTER JOIN T_FA_FACHANGEBILLENTRY AS B ON A.FID = B.FCHANGEBILLID ");
        sql.append("LEFT OUTER JOIN T_FA_FABIZCARD AS C ON B.FBIZCARDID = C.FID ");
        if (this.isCurPeriod) {
            sql.append("LEFT OUTER JOIN T_FA_FACURCARD AS D ON B.FCURCARDID = D.FID ");
        } else {
            sql.append("LEFT OUTER JOIN T_FA_FAMONCARD AS D ON B.FCURCARDID = D.FFACURCARDID ");
            sql.append("AND A.FPeriodID = D.FFaPeriodID ");
        }
        sql.append("LEFT OUTER JOIN T_BD_Period AS PERIOD ");
        sql.append("ON A.FPeriodID = PERIOD.FID ");
        String companyId = FaChgListRptDao.getCurrentCompanyId(this.ctx);
        sql.append("WHERE A.FCOMPANYID = '" + companyId + "'");
        sql.append(" AND PERIOD.fperiodyear = " + this.year + " and period.fperiodnumber = " + this.month);
        if (!this.bIncludeNotAuditCard) {
            sql.append(" AND A.FCheckedStatus = 2");
        } else {
            sql.append(" AND A.FEffectedStatus = 2");
        }
        if (!this.bIncludeClnCard) {
            sql.append(" AND D.FDeletedStatus != 2");
        }
        sql.append(")");
        return sql.toString();
    }

    private String getCleanBillSql() throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("(SELECT ");
        if (this.isCurPeriod) {
            sql.append("D.FID AS ID2, ");
        } else {
            sql.append("D.FFACURCARDID AS ID2, ");
        }
        sql.append("D.FNumber AS ASSETNUMBER, ");
        sql.append("D.FAssetName AS ASSETNAME, ");
        sql.append("D.FAssetAmt AS ASSETAMT, ");
        sql.append("D.FFIAccountDate AS ACCOUNTDATE, ");
        sql.append("D.FEconomicPurpID AS FECONOMICPURPID, ");
        sql.append("D.FSpecs AS SPECS, ");
        sql.append("D.FPArea AS PAREA, ");
        sql.append("D.FMfr AS MFR, ");
        sql.append("D.FLevFrDate AS LEVFRDATE, ");
        sql.append(this.getOriginUnitSql("D.forigintype", "D.FOriginUnit") + " AS ORIGINUNIT, ");
        sql.append("D.FPaperNo AS PAPERNO, ");
        sql.append("D.FExRate AS EXRATE, ");
        sql.append("D.FOriginAmt AS ORIGINAMT, ");
        sql.append("D.FTreatmentIncome AS TREATMENTINCOME, ");
        sql.append("D.FAddons AS ADDONS, ");
        sql.append("D.FAddonFare AS ADDONFARE, ");
        sql.append("D.FAssetValue AS ASSETVALUE, ");
        sql.append("D.FBuyValue AS BUYVALUE, ");
        sql.append("D.FBuyAccuDepr AS BUYACCUDEPR, ");
        sql.append("D.FDeliverDate AS DELIVERDATE, ");
        sql.append("D.FStartUseDate AS STARTUSEDATE, ");
        sql.append("D.FUseYears AS USEYEARS, ");
        sql.append("D.FUseTermCount AS USETERMCOUNT, ");
        sql.append("D.FDeprTermCount AS DEPRTERMCOUNT, ");
        sql.append("D.FAccuDepr AS ACCUDEPR, ");
        sql.append("D.FAccuDeprTYear AS ACCUDEPRTYEAR, ");
        sql.append("D.FNeatRemValue AS NEATREMVALUE, ");
        sql.append("D.FNeatValue AS NEATVALUE, ");
        sql.append("D.FDecValue AS DECVALUE, ");
        sql.append("D.FNeatAmt AS NEATAMT, ");
        sql.append("D.FRemark AS REMARK, ");
        sql.append("A.FCLEARDATE AS CHANGEDATE, ");
        sql.append("A.FCLEARMODEID AS CHANGEMODE, ");
        sql.append("D.FCheckedStatus AS CHECKEDSTATUS, ");
        sql.append("D.FHasChanged AS HASCHANGED, ");
        sql.append("D.FHasCleared AS HASCLEARED, ");
        sql.append("D.FDeprMethodID, D.FMeasureUnitWLID, D.FCurrencyID, D.FKeeperID, ");
        sql.append("D.FDeptID, D.FAssetCatID, D.FMeasureUnitID, D.FOriginMethodID, ");
        sql.append("D.FUseStatusID, D.FStoreCityID, D.FCompanyID, D.foriginDif as originDif, d.faccuDeprChg as accuDeprChg, d.fdecValueChg as decValueChg,  ");
        sql.append("(D.FUseTermCount - D.FDeprTermCount) as LeftTermCount ");
        sql.append("FROM T_FA_CLEARBILL AS A ");
        sql.append("LEFT OUTER JOIN T_FA_CLEARBILLENTRY AS B ON A.FID = B.FENTRYID ");
        sql.append("LEFT OUTER JOIN T_FA_FABIZCARD AS C ON B.FBIZCARDID = C.FID ");
        if (this.isCurPeriod) {
            sql.append("LEFT OUTER JOIN T_FA_FACURCARD AS D ON B.FCURCARDID = D.FID ");
        } else {
            sql.append("LEFT OUTER JOIN T_FA_FAMONCARD AS D ON B.FCURCARDID = D.FFACURCARDID ");
            sql.append("AND A.FPeriodID = D.FFaPeriodID ");
        }
        sql.append("LEFT OUTER JOIN T_BD_Period AS PERIOD ");
        sql.append("ON A.FPeriodID = PERIOD.FID ");
        String companyId = FaChgListRptDao.getCurrentCompanyId(this.ctx);
        sql.append("WHERE A.FCOMPANYID = '" + companyId + "'");
        sql.append(" AND PERIOD.fperiodyear = " + this.year + " and period.fperiodnumber = " + this.month);
        if (!this.bIncludeNotAuditCard) {
            sql.append(" AND A.FCheckedStatus = 2");
        } else {
            sql.append(" AND A.FEffectedStatus = 2");
        }
        if (!this.bIncludeClnCard) {
            sql.append(" AND D.FDeletedStatus != 2");
        }
        sql.append(")");
        return sql.toString();
    }

    private String getNewCardSql() throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("(SELECT ");
        sql.append("D.FFACURCARDID AS ID2, ");
        sql.append("D.FNumber AS ASSETNUMBER, ");
        sql.append("D.FAssetName AS ASSETNAME, ");
        sql.append("D.FAssetAmt AS ASSETAMT, ");
        sql.append("D.FFIAccountDate AS ACCOUNTDATE, ");
        sql.append("D.FEconomicPurpID AS FECONOMICPURPID, ");
        sql.append("D.FSpecs AS SPECS, ");
        sql.append("D.FPArea AS PAREA, ");
        sql.append("D.FMfr AS MFR, ");
        sql.append("D.FLevFrDate AS LEVFRDATE, ");
        sql.append(this.getOriginUnitSql("D.forigintype", "D.FOriginUnit") + " AS ORIGINUNIT, ");
        sql.append("D.FPaperNo AS PAPERNO, ");
        sql.append("D.FExRate AS EXRATE, ");
        sql.append("D.FOriginAmt AS ORIGINAMT, ");
        sql.append("D.FTreatmentIncome AS TREATMENTINCOME, ");
        sql.append("D.FAddons AS ADDONS, ");
        sql.append("D.FAddonFare AS ADDONFARE, ");
        sql.append("D.FAssetValue AS ASSETVALUE, ");
        sql.append("D.FBuyValue AS BUYVALUE, ");
        sql.append("D.FBuyAccuDepr AS BUYACCUDEPR, ");
        sql.append("D.FDeliverDate AS DELIVERDATE, ");
        sql.append("D.FStartUseDate AS STARTUSEDATE, ");
        sql.append("D.FUseYears AS USEYEARS, ");
        sql.append("D.FUseTermCount AS USETERMCOUNT, ");
        sql.append("D.FDeprTermCount AS DEPRTERMCOUNT, ");
        sql.append("D.FAccuDepr AS ACCUDEPR, ");
        sql.append("D.FAccuDeprTYear AS ACCUDEPRTYEAR, ");
        sql.append("D.FNeatRemValue AS NEATREMVALUE, ");
        sql.append("D.FNeatValue AS NEATVALUE, ");
        sql.append("D.FDecValue AS DECVALUE, ");
        sql.append("D.FNeatAmt AS NEATAMT, ");
        sql.append("D.FRemark AS REMARK, ");
        sql.append("D.FFIAccountDate AS CHANGEDATE, ");
        sql.append("D.FORIGINMETHODID AS CHANGEMODE, ");
        sql.append("D.FCheckedStatus AS CHECKEDSTATUS, ");
        sql.append("D.FHasChanged AS HASCHANGED, ");
        sql.append("D.FHasCleared AS HASCLEARED, ");
        sql.append("D.FDeprMethodID, D.FMeasureUnitWLID, D.FCurrencyID, D.FKeeperID, ");
        sql.append("D.FDeptID, D.FAssetCatID, D.FMeasureUnitID, D.FOriginMethodID, ");
        sql.append("D.FUseStatusID, D.FStoreCityID, D.FCompanyID, D.foriginDif as originDif, D.faccuDeprChg as accuDeprChg, D.fdecValueChg as decValueChg,  ");
        sql.append("(D.FUseTermCount - D.FDeprTermCount) as LeftTermCount ");
        sql.append("FROM T_FA_FABAKCARD AS D ");
        sql.append("LEFT OUTER JOIN T_BD_Period AS PERIOD ");
        sql.append("ON (D.FPeriodID = PERIOD.FID) ");
        if (!this.bIncludeClnCard) {
            if (this.isCurPeriod) {
                sql.append("LEFT OUTER JOIN T_FA_FACURCARD AS E ON D.FFACURCARDID = E.FID ");
            } else {
                sql.append("LEFT OUTER JOIN T_FA_FAMONCARD AS E ON D.FFACURCARDID = E.FFACURCARDID ");
                sql.append("AND D.FPeriodID = E.FFaPeriodID ");
            }
        }
        String companyId = FaChgListRptDao.getCurrentCompanyId(this.ctx);
        sql.append("WHERE D.FCOMPANYID = '" + companyId + "'");
        sql.append(" AND PERIOD.fperiodyear = " + this.year + " and period.fperiodnumber = " + this.month);
        sql.append(" AND D.FBILLTYPE = 1");
        if (!this.bIncludeClnCard) {
            sql.append(" AND E.FDeletedStatus != 2");
        }
        sql.append(")");
        if (this.bIncludeNotAuditCard) {
            sql.append("\n");
            sql.append("UNION ");
            sql.append(this.getNewCardNotAuditSql());
            sql.append("\n");
        }
        return sql.toString();
    }

    private String getNewCardNotAuditSql() throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("(SELECT ");
        sql.append("D.FID AS ID2, ");
        sql.append("D.FNumber AS ASSETNUMBER, ");
        sql.append("D.FAssetName AS ASSETNAME, ");
        sql.append("D.FAssetAmt AS ASSETAMT, ");
        sql.append("D.FFIAccountDate AS ACCOUNTDATE, ");
        sql.append("D.FEconomicPurpID AS FECONOMICPURPID, ");
        sql.append("D.FSpecs AS SPECS, ");
        sql.append("D.FPArea AS PAREA, ");
        sql.append("D.FMfr AS MFR, ");
        sql.append("D.FLevFrDate AS LEVFRDATE, ");
        sql.append(this.getOriginUnitSql("D.forigintype", "D.FOriginUnit") + " AS ORIGINUNIT, ");
        sql.append("D.FPaperNo AS PAPERNO, ");
        sql.append("D.FExRate AS EXRATE, ");
        sql.append("D.FOriginAmt AS ORIGINAMT, ");
        sql.append("D.FTreatmentIncome AS TREATMENTINCOME, ");
        sql.append("D.FAddons AS ADDONS, ");
        sql.append("D.FAddonFare AS ADDONFARE, ");
        sql.append("D.FAssetValue AS ASSETVALUE, ");
        sql.append("D.FBuyValue AS BUYVALUE, ");
        sql.append("D.FBuyAccuDepr AS BUYACCUDEPR, ");
        sql.append("D.FDeliverDate AS DELIVERDATE, ");
        sql.append("D.FStartUseDate AS STARTUSEDATE, ");
        sql.append("D.FUseYears AS USEYEARS, ");
        sql.append("D.FUseTermCount AS USETERMCOUNT, ");
        sql.append("D.FDeprTermCount AS DEPRTERMCOUNT, ");
        sql.append("D.FAccuDepr AS ACCUDEPR, ");
        sql.append("D.FAccuDeprTYear AS ACCUDEPRTYEAR, ");
        sql.append("D.FNeatRemValue AS NEATREMVALUE, ");
        sql.append("D.FNeatValue AS NEATVALUE, ");
        sql.append("D.FDecValue AS DECVALUE, ");
        sql.append("D.FNeatAmt AS NEATAMT, ");
        sql.append("D.FRemark AS REMARK, ");
        sql.append("D.FFIAccountDate AS CHANGEDATE, ");
        sql.append("D.FORIGINMETHODID AS CHANGEMODE, ");
        sql.append("D.FCheckedStatus AS CHECKEDSTATUS, ");
        sql.append("D.FHasChanged AS HASCHANGED, ");
        sql.append("D.FHasCleared AS HASCLEARED, ");
        sql.append("D.FDeprMethodID, D.FMeasureUnitWLID, D.FCurrencyID, D.FKeeperID, ");
        sql.append("D.FDeptID, D.FAssetCatID, D.FMeasureUnitID, D.FOriginMethodID, ");
        sql.append("D.FUseStatusID, D.FStoreCityID, D.FCompanyID, D.foriginDif as originDif, D.faccuDeprChg as accuDeprChg, D.fdecValueChg as decValueChg,  ");
        sql.append("(D.FUseTermCount - D.FDeprTermCount) as LeftTermCount ");
        sql.append("FROM T_FA_FACurCARD AS D ");
        sql.append("LEFT OUTER JOIN T_BD_Period AS PERIOD ");
        sql.append("ON (D.FPeriodID = PERIOD.FID) ");
        String companyId = FaChgListRptDao.getCurrentCompanyId(this.ctx);
        sql.append("WHERE D.FCOMPANYID = '" + companyId + "'");
        sql.append(" AND PERIOD.fperiodyear = " + this.year + " and period.fperiodnumber = " + this.month);
        sql.append(" AND D.FCheckedStatus = 1");
        sql.append(" AND D.FEffectedStatus = 2");
        sql.append(")");
        return sql.toString();
    }

    private String getCondSql() throws EASBizException, BOSException {
        StringBuffer condSql = new StringBuffer();
        if (this.ev.getFilter() != null && this.ev.getFilter().getFilterItems().size() > 0) {
            condSql.append(" and " + this.ev.getFilter().toString());
        }
        return condSql.toString();
    }

    private String getSorterSql() {
        StringBuffer sorterSql = new StringBuffer();
        SorterItemCollection sorters = this.ev.getSorter();
        if (sorters == null) {
            return "";
        }
        for (SorterItemInfo sorterItem : sorters) {
            sorterSql.append(sorterItem.toString());
            sorterSql.append(", ");
        }
        String sql = sorterSql.toString();
        if (sql.length() > 0) {
            sql = sql.substring(0, sql.length() - 2);
        }
        return sql;
    }

    private String getDetailSql(String id) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT ");
        sql.append("A.FID AS FID, ");
        sql.append("A.CHANGEDATE, ");
        sql.append("ALTERMETHOD." + fName + " AS ALTERMETHOD_NAME, ");
        sql.append("A.ASSETNUMBER, ");
        sql.append("A.ASSETNAME, ");
        sql.append("ASSETCAT." + fName + " AS ASSETCAT_NAME, ");
        sql.append("A.ASSETAMT, ");
        sql.append("MEASUREUNIT." + fName + " AS MEASUREUNIT_NAME, ");
        sql.append("USESTATUS." + fName + " AS USESTATUS_NAME, ");
        sql.append("ECONOMICPURP." + fName + " AS ECONOMICPURP, ");
        sql.append("STORECITY." + fName + " AS STORECITY_NAME, ");
        sql.append("NULL AS UseDepartment, ");
        sql.append("NULL AS CostCenter, ");
        sql.append("A.SPECS, ");
        sql.append("A.PAREA, ");
        sql.append("A.MFR, ");
        sql.append("A.LEVFRDATE, ");
        sql.append(this.getOriginUnitSql("A.forigintype", "A.ORIGINUNIT") + " AS ORIGINUNIT, ");
        sql.append("A.PAPERNO, ");
        sql.append("DEPRMETHOD." + fName + " AS DEPRMETHOD_NAME, ");
        sql.append("MEASUREUNITWL." + fName + " AS MEASUREUNITWL_NAME, ");
        sql.append("CURRENCY." + fName + " AS CURRENCY_NAME, ");
        sql.append("A.EXRATE, ");
        sql.append("A.ORIGINAMT, ");
        sql.append("A.TREATMENTINCOME, ");
        sql.append("A.ADDONS, ");
        sql.append("A.ADDONFARE, ");
        sql.append("A.ASSETVALUE, ");
        sql.append("A.ORIGINCHG, ");
        sql.append("A.BUYVALUE, ");
        sql.append("A.BUYACCUDEPR, ");
        sql.append("A.DELIVERDATE, ");
        sql.append("A.STARTUSEDATE, ");
        sql.append("A.USEYEARS, ");
        sql.append("A.USETERMCOUNT, ");
        sql.append("A.DEPRTERMCOUNT, ");
        sql.append("A.LEFTTERMCONT, ");
        sql.append("A.ACCUDEPR, ");
        sql.append("A.ACCUDEPRCHG,");
        sql.append("A.ACCUDEPRTYEAR, ");
        sql.append("A.NEATREMVALUE, ");
        sql.append("A.NEATVALUE, ");
        sql.append("A.DECVALUE, ");
        sql.append("A.DECVALUECHG, ");
        sql.append("A.NEATAMT, ");
        sql.append("COMPANY_PARENT0." + fName + " AS COMPANY_NAME, ");
        sql.append("DEPT_PARENT0." + fName + " AS DEPT_NAME, ");
        sql.append("KEEPER." + fName + " AS KEEPER_NAME, ");
        sql.append("A.REMARK ");
        sql.append("FROM ");
        sql.append("(");
        sql.append("\n");
        sql.append(this.getNewCardDetailSql(id));
        sql.append("\n");
        sql.append("UNION ");
        sql.append("\n");
        sql.append(this.getChangeBillDetailSql(id));
        sql.append("\n");
        sql.append("UNION ");
        sql.append("\n");
        sql.append(this.getCleanBillDetailSql(id));
        sql.append("\n");
        sql.append(") AS A ");
        sql.append("LEFT OUTER JOIN T_FA_DepreciationMode AS DEPRMETHOD ");
        sql.append("ON A.FDeprMethodID = DEPRMETHOD.FID ");
        sql.append("LEFT OUTER JOIN T_BD_MeasureUnit AS MEASUREUNITWL ");
        sql.append("ON A.FMeasureUnitWLID = MEASUREUNITWL.FID ");
        sql.append("LEFT OUTER JOIN T_BD_Currency AS CURRENCY ");
        sql.append("ON A.FCurrencyID = CURRENCY.FID ");
        sql.append("LEFT OUTER JOIN T_BD_Person AS KEEPER ");
        sql.append("ON A.FKeeperID = KEEPER.FID ");
        sql.append("LEFT OUTER JOIN T_ORG_Admin AS DEPT ");
        sql.append("ON A.FDeptID = DEPT.FID ");
        sql.append("LEFT OUTER JOIN T_FA_Cat AS ASSETCAT ");
        sql.append("ON A.FAssetCatID = ASSETCAT.FID ");
        sql.append("LEFT OUTER JOIN T_BD_MeasureUnit AS MEASUREUNIT ");
        sql.append("ON A.FMeasureUnitID = MEASUREUNIT.FID ");
        sql.append("LEFT OUTER JOIN T_FA_AlterMode AS ALTERMETHOD ");
        sql.append("ON A.CHANGEMODE = ALTERMETHOD.FID ");
        sql.append("LEFT OUTER JOIN T_FA_UseStatus AS USESTATUS ");
        sql.append("ON A.FUseStatusID = USESTATUS.FID ");
        sql.append("LEFT OUTER JOIN T_FA_FaEconomicPurp AS EconomicPurp ");
        sql.append("ON A.FEconomicPurpID = EconomicPurp.FID ");
        sql.append("LEFT OUTER JOIN T_BD_Address AS STORECITY ");
        sql.append("ON A.FStoreCityID = STORECITY.FID ");
        sql.append("LEFT OUTER JOIN T_ORG_Company AS COMPANY ");
        sql.append("ON A.FCompanyID = COMPANY.FID ");
        sql.append("LEFT OUTER JOIN T_ORG_BaseUnit AS DEPT_PARENT0 ");
        sql.append("ON DEPT.FID = DEPT_PARENT0.FID ");
        sql.append("LEFT OUTER JOIN T_ORG_BaseUnit AS COMPANY_PARENT0 ");
        sql.append("ON COMPANY.FID = COMPANY_PARENT0.FID");
        return sql.toString();
    }

    private String getChangeBillDetailSql(String id) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("(SELECT ");
        sql.append("C.FID, ");
        sql.append("C.FNumber AS ASSETNUMBER, ");
        sql.append("C.FAssetName AS ASSETNAME, ");
        sql.append("C.FAssetAmt AS ASSETAMT, ");
        sql.append("C.FFIAccountDate AS ACCOUNTDATE, ");
        sql.append("C.FEconomicPurpID AS FECONOMICPURPID, ");
        sql.append("C.FSpecs AS SPECS, ");
        sql.append("C.FPArea AS PAREA, ");
        sql.append("C.FMfr AS MFR, ");
        sql.append("C.FLevFrDate AS LEVFRDATE, ");
        sql.append("C.FOriginUnit AS ORIGINUNIT, ");
        sql.append("C.FPaperNo AS PAPERNO, ");
        sql.append("C.FExRate AS EXRATE, ");
        sql.append("C.FOriginAmt AS ORIGINAMT, ");
        sql.append("C.FTreatmentIncome AS TREATMENTINCOME, ");
        sql.append("C.FAddons AS ADDONS, ");
        sql.append("C.FAddonFare AS ADDONFARE, ");
        sql.append("C.FAssetValue AS ASSETVALUE, ");
        sql.append("C.FBuyValue AS BUYVALUE, ");
        sql.append("C.FBuyAccuDepr AS BUYACCUDEPR, ");
        sql.append("C.FDeliverDate AS DELIVERDATE, ");
        sql.append("C.FStartUseDate AS STARTUSEDATE, ");
        sql.append("C.FUseYears AS USEYEARS, ");
        sql.append("C.FUseTermCount AS USETERMCOUNT, ");
        sql.append("C.FDeprTermCount AS DEPRTERMCOUNT, ");
        sql.append("(C.FUseTermCount - C.FDeprTermCount) AS LEFTTERMCONT, ");
        sql.append("C.FAccuDepr AS ACCUDEPR, ");
        sql.append("C.FAccuDeprTYear AS ACCUDEPRTYEAR, ");
        sql.append("C.FNeatRemValue AS NEATREMVALUE, ");
        sql.append("C.FNeatValue AS NEATVALUE, ");
        sql.append("C.FDecValue AS DECVALUE, ");
        sql.append("C.FNeatAmt AS NEATAMT, ");
        sql.append("C.FRemark AS REMARK, ");
        sql.append("C.FDeprMethodID, C.FMeasureUnitWLID, C.FCurrencyID, C.FKeeperID, ");
        sql.append("C.FDeptID, C.FAssetCatID, C.FMeasureUnitID, C.FOriginMethodID, ");
        sql.append("C.FUseStatusID, C.FStoreCityID, A.FCompanyID, ");
        sql.append("C.FREMARK AS CHGREASON, ");
        sql.append("A.FCHANGEDATE AS CHANGEDATE, ");
        sql.append("A.FCHANGEMODEID AS CHANGEMODE, ");
        sql.append("B.TORIGINCHG AS ORIGINCHG, ");
        sql.append("B.TACCUDEPRCHG AS ACCUDEPRCHG, ");
        sql.append("B.TDECVALUECHG AS DECVALUECHG, ");
        sql.append("C.FBILLTYPE, ");
        sql.append("c.forigintype ");
        sql.append("FROM T_FA_FACHANGEBILL AS A ");
        sql.append("LEFT OUTER JOIN T_FA_FACHANGEBILLENTRY AS B ON A.FID = B.FCHANGEBILLID ");
        sql.append("LEFT OUTER JOIN T_FA_FABIZCARD AS C ON B.FBIZCARDID = C.FID ");
        if (!this.bIncludeClnCard) {
            if (this.isCurPeriod) {
                sql.append("LEFT OUTER JOIN T_FA_FACURCARD AS D ON B.FCURCARDID = D.FID ");
            } else {
                sql.append("LEFT OUTER JOIN T_FA_FAMONCARD AS D ON B.FCURCARDID = D.FFACURCARDID ");
                sql.append("AND A.FPeriodID = D.FFaPeriodID ");
            }
        }
        sql.append("LEFT OUTER JOIN T_BD_Period AS PERIOD ");
        sql.append("ON A.FPeriodID = PERIOD.FID ");
        String companyId = FaChgListRptDao.getCurrentCompanyId(this.ctx);
        sql.append("WHERE A.FCOMPANYID = '" + companyId + "'");
        sql.append(" AND ((PERIOD.fperiodyear = " + this.year + " and period.fperiodnumber <= " + this.month + ") OR (PERIOD.fperiodyear < " + this.year + ")) ");
        if (!this.bIncludeNotAuditCard) {
            sql.append(" AND A.FCheckedStatus = 2");
        } else {
            sql.append(" AND A.FEffectedStatus = 2");
        }
        sql.append(" AND B.FCURCARDID = '" + id + "'");
        sql.append(")");
        return sql.toString();
    }

    private String getCleanBillDetailSql(String id) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("(SELECT ");
        sql.append("C.FID, ");
        sql.append("C.FNumber AS ASSETNUMBER, ");
        sql.append("C.FAssetName AS ASSETNAME, ");
        sql.append("C.FAssetAmt AS ASSETAMT, ");
        sql.append("C.FFIAccountDate AS ACCOUNTDATE, ");
        sql.append("C.FEconomicPurpID AS FECONOMICPURPID, ");
        sql.append("C.FSpecs AS SPECS, ");
        sql.append("C.FPArea AS PAREA, ");
        sql.append("C.FMfr AS MFR, ");
        sql.append("C.FLevFrDate AS LEVFRDATE, ");
        sql.append("C.FOriginUnit AS ORIGINUNIT, ");
        sql.append("C.FPaperNo AS PAPERNO, ");
        sql.append("C.FExRate AS EXRATE, ");
        sql.append("C.FOriginAmt AS ORIGINAMT, ");
        sql.append("C.FTreatmentIncome AS TREATMENTINCOME, ");
        sql.append("C.FAddons AS ADDONS, ");
        sql.append("C.FAddonFare AS ADDONFARE, ");
        sql.append("C.FAssetValue AS ASSETVALUE, ");
        sql.append("C.FBuyValue AS BUYVALUE, ");
        sql.append("C.FBuyAccuDepr AS BUYACCUDEPR, ");
        sql.append("C.FDeliverDate AS DELIVERDATE, ");
        sql.append("C.FStartUseDate AS STARTUSEDATE, ");
        sql.append("C.FUseYears AS USEYEARS, ");
        sql.append("C.FUseTermCount AS USETERMCOUNT, ");
        sql.append("C.FDeprTermCount AS DEPRTERMCOUNT, ");
        sql.append("(C.FUseTermCount - C.FDeprTermCount) AS LEFTTERMCONT, ");
        sql.append("C.FAccuDepr AS ACCUDEPR, ");
        sql.append("C.FAccuDeprTYear AS ACCUDEPRTYEAR, ");
        sql.append("C.FNeatRemValue AS NEATREMVALUE, ");
        sql.append("C.FNeatValue AS NEATVALUE, ");
        sql.append("C.FDecValue AS DECVALUE, ");
        sql.append("C.FNeatAmt AS NEATAMT, ");
        sql.append("B.FCOMMENT AS REMARK, ");
        sql.append("C.FDeprMethodID, C.FMeasureUnitWLID, C.FCurrencyID, C.FKeeperID, ");
        sql.append("C.FDeptID, C.FAssetCatID, C.FMeasureUnitID, C.FOriginMethodID, ");
        sql.append("C.FUseStatusID, C.FStoreCityID, A.FCompanyID, ");
        sql.append("B.FCOMMENT AS CHGREASON, ");
        sql.append("A.FCLEARDATE AS CHANGEDATE, ");
        sql.append("A.FCLEARMODEID AS CHANGEMODE, ");
        sql.append("B.FCLRORIGINAL * -1 AS ORIGINCHG, ");
        sql.append("B.FCLRADDUPDEP * -1 AS ACCUDEPRCHG, ");
        sql.append("B.FCLRDECPREP * -1 AS DECVALUECHG, ");
        sql.append("C.FBILLTYPE, ");
        sql.append("c.forigintype ");
        sql.append("FROM T_FA_CLEARBILL AS A ");
        sql.append("LEFT OUTER JOIN T_FA_CLEARBILLENTRY AS B ON A.FID = B.FENTRYID ");
        sql.append("LEFT OUTER JOIN T_FA_FABIZCARD AS C ON B.FBIZCARDID = C.FID ");
        if (!this.bIncludeClnCard) {
            if (this.isCurPeriod) {
                sql.append("LEFT OUTER JOIN T_FA_FACURCARD AS D ON B.FCURCARDID = D.FID ");
            } else {
                sql.append("LEFT OUTER JOIN T_FA_FAMONCARD AS D ON B.FCURCARDID = D.FFACURCARDID ");
                sql.append("AND A.FPeriodID = D.FFaPeriodID ");
            }
        }
        sql.append("LEFT OUTER JOIN T_BD_Period AS PERIOD ");
        sql.append("ON A.FPeriodID = PERIOD.FID ");
        String companyId = FaChgListRptDao.getCurrentCompanyId(this.ctx);
        sql.append("WHERE A.FCOMPANYID = '" + companyId + "'");
        sql.append(" AND ((PERIOD.fperiodyear = " + this.year + " and period.fperiodnumber <= " + this.month + ") OR (PERIOD.fperiodyear < " + this.year + ")) ");
        sql.append(" AND B.FCURCARDID = '" + id + "'");
        if (!this.bIncludeClnCard) {
            sql.append(" AND D.FDeletedStatus != 2");
        }
        if (!this.bIncludeNotAuditCard) {
            sql.append(" AND A.FCheckedStatus = 2");
        } else {
            sql.append(" AND A.FEffectedStatus = 2");
        }
        sql.append(")");
        return sql.toString();
    }

    private String getNewCardDetailSql(String id) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("(SELECT ");
        sql.append("D.FID, ");
        sql.append("D.FNumber AS ASSETNUMBER, ");
        sql.append("D.FAssetName AS ASSETNAME, ");
        sql.append("D.FAssetAmt AS ASSETAMT, ");
        sql.append("D.FFIAccountDate AS ACCOUNTDATE, ");
        sql.append("D.FEconomicPurpID AS FECONOMICPURPID, ");
        sql.append("D.FSpecs AS SPECS, ");
        sql.append("D.FPArea AS PAREA, ");
        sql.append("D.FMfr AS MFR, ");
        sql.append("D.FLevFrDate AS LEVFRDATE, ");
        sql.append("D.FOriginUnit AS ORIGINUNIT, ");
        sql.append("D.FPaperNo AS PAPERNO, ");
        sql.append("D.FExRate AS EXRATE, ");
        sql.append("D.FOriginAmt AS ORIGINAMT, ");
        sql.append("D.FTreatmentIncome AS TREATMENTINCOME, ");
        sql.append("D.FAddons AS ADDONS, ");
        sql.append("D.FAddonFare AS ADDONFARE, ");
        sql.append("D.FAssetValue AS ASSETVALUE, ");
        sql.append("D.FBuyValue AS BUYVALUE, ");
        sql.append("D.FBuyAccuDepr AS BUYACCUDEPR, ");
        sql.append("D.FDeliverDate AS DELIVERDATE, ");
        sql.append("D.FStartUseDate AS STARTUSEDATE, ");
        sql.append("D.FUseYears AS USEYEARS, ");
        sql.append("D.FUseTermCount AS USETERMCOUNT, ");
        sql.append("D.FDeprTermCount AS DEPRTERMCOUNT, ");
        sql.append("(D.FUseTermCount - D.FDeprTermCount) AS LEFTTERMCONT, ");
        sql.append("D.FAccuDepr AS ACCUDEPR, ");
        sql.append("D.FAccuDeprTYear AS ACCUDEPRTYEAR, ");
        sql.append("D.FNeatRemValue AS NEATREMVALUE, ");
        sql.append("D.FNeatValue AS NEATVALUE, ");
        sql.append("D.FDecValue AS DECVALUE, ");
        sql.append("D.FNeatAmt AS NEATAMT, ");
        sql.append("D.FRemark AS REMARK, ");
        sql.append("D.FDeprMethodID, D.FMeasureUnitWLID, D.FCurrencyID, D.FKeeperID, ");
        sql.append("D.FDeptID, D.FAssetCatID, D.FMeasureUnitID, D.FOriginMethodID, ");
        sql.append("D.FUseStatusID, D.FStoreCityID, D.FCompanyID, ");
        sql.append("D.FREMARK AS CHGREASON, ");
        sql.append("D.FFIAccountDate AS CHANGEDATE, ");
        sql.append("D.FORIGINMETHODID AS CHANGEMODE, ");
        sql.append("D.FAssetValue AS ORIGINCHG, ");
        sql.append("D.FAccuDepr AS ACCUDEPRCHG, ");
        sql.append("D.FDecValue AS DECVALUECHG, ");
        sql.append("D.FBILLTYPE, ");
        sql.append("D.forigintype ");
        sql.append("FROM T_FA_FABAKCARD AS D ");
        if (!this.bIncludeClnCard) {
            if (this.isCurPeriod) {
                sql.append("LEFT OUTER JOIN T_FA_FACURCARD AS E ON D.FFACURCARDID = E.FID ");
            } else {
                sql.append("LEFT OUTER JOIN T_FA_FAMONCARD AS E ON D.FFACURCARDID = E.FFACURCARDID ");
                sql.append("AND D.FPeriodID = E.FFaPeriodID ");
            }
        }
        sql.append("LEFT OUTER JOIN T_BD_Period AS PERIOD ");
        sql.append("ON (D.FPeriodID = PERIOD.FID) ");
        String companyId = FaChgListRptDao.getCurrentCompanyId(this.ctx);
        sql.append("WHERE D.FCOMPANYID = '" + companyId + "'");
        sql.append(" AND ((PERIOD.fperiodyear = " + this.year + " and period.fperiodnumber <= " + this.month + ") OR (PERIOD.fperiodyear < " + this.year + ")) ");
        sql.append(" AND D.FBILLTYPE = 1");
        sql.append(" AND D.FFACURCARDID = '" + id + "'");
        if (!this.bIncludeClnCard) {
            sql.append(" AND E.FDeletedStatus != 2");
        }
        sql.append(")");
        if (this.bIncludeNotAuditCard) {
            sql.append("\n");
            sql.append("UNION ");
            sql.append(this.getNewCardNotAuditDetailSql(id));
            sql.append("\n");
        }
        return sql.toString();
    }

    private String getNewCardNotAuditDetailSql(String id) {
        StringBuffer sql = new StringBuffer();
        sql.append("(SELECT ");
        sql.append("D.FID, ");
        sql.append("D.FNumber AS ASSETNUMBER, ");
        sql.append("D.FAssetName AS ASSETNAME, ");
        sql.append("D.FAssetAmt AS ASSETAMT, ");
        sql.append("D.FFIAccountDate AS ACCOUNTDATE, ");
        sql.append("D.FEconomicPurpID AS FECONOMICPURPID, ");
        sql.append("D.FSpecs AS SPECS, ");
        sql.append("D.FPArea AS PAREA, ");
        sql.append("D.FMfr AS MFR, ");
        sql.append("D.FLevFrDate AS LEVFRDATE, ");
        sql.append("D.FOriginUnit AS ORIGINUNIT, ");
        sql.append("D.FPaperNo AS PAPERNO, ");
        sql.append("D.FExRate AS EXRATE, ");
        sql.append("D.FOriginAmt AS ORIGINAMT, ");
        sql.append("D.FTreatmentIncome AS TREATMENTINCOME, ");
        sql.append("D.FAddons AS ADDONS, ");
        sql.append("D.FAddonFare AS ADDONFARE, ");
        sql.append("D.FAssetValue AS ASSETVALUE, ");
        sql.append("D.FBuyValue AS BUYVALUE, ");
        sql.append("D.FBuyAccuDepr AS BUYACCUDEPR, ");
        sql.append("D.FDeliverDate AS DELIVERDATE, ");
        sql.append("D.FStartUseDate AS STARTUSEDATE, ");
        sql.append("D.FUseYears AS USEYEARS, ");
        sql.append("D.FUseTermCount AS USETERMCOUNT, ");
        sql.append("D.FDeprTermCount AS DEPRTERMCOUNT, ");
        sql.append("(D.FUseTermCount - D.FDeprTermCount) AS LEFTTERMCONT, ");
        sql.append("D.FAccuDepr AS ACCUDEPR, ");
        sql.append("D.FAccuDeprTYear AS ACCUDEPRTYEAR, ");
        sql.append("D.FNeatRemValue AS NEATREMVALUE, ");
        sql.append("D.FNeatValue AS NEATVALUE, ");
        sql.append("D.FDecValue AS DECVALUE, ");
        sql.append("D.FNeatAmt AS NEATAMT, ");
        sql.append("D.FRemark AS REMARK, ");
        sql.append("D.FDeprMethodID, D.FMeasureUnitWLID, D.FCurrencyID, D.FKeeperID, ");
        sql.append("D.FDeptID, D.FAssetCatID, D.FMeasureUnitID, D.FOriginMethodID, ");
        sql.append("D.FUseStatusID, D.FStoreCityID, D.FCompanyID, ");
        sql.append("D.FREMARK AS CHGREASON, ");
        sql.append("D.FFIAccountDate AS CHANGEDATE, ");
        sql.append("D.FORIGINMETHODID AS CHANGEMODE, ");
        sql.append("D.FAssetValue AS ORIGINCHG, ");
        sql.append("D.FAccuDepr AS ACCUDEPRCHG, ");
        sql.append("D.FDecValue AS DECVALUECHG, ");
        sql.append("0 AS FBILLTYPE, ");
        sql.append("D.forigintype ");
        sql.append("FROM T_FA_FACurCARD AS D ");
        sql.append("LEFT OUTER JOIN T_BD_Period AS PERIOD ");
        sql.append("ON (D.FPeriodID = PERIOD.FID) ");
        String companyId = FaChgListRptDao.getCurrentCompanyId(this.ctx);
        sql.append("WHERE D.FCOMPANYID = '" + companyId + "'");
        sql.append(" AND ((PERIOD.fperiodyear = " + this.year + " and period.fperiodnumber <= " + this.month + ") OR (PERIOD.fperiodyear < " + this.year + ")) ");
        sql.append(" AND D.FCheckedStatus = 1");
        sql.append(" AND D.FEffectedStatus = 2");
        sql.append(" AND D.FID = '" + id + "'");
        sql.append(")");
        return sql.toString();
    }

    private String getCardInfoSql(String id) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT A.FNUMBER, A.FASSETNAME FROM ");
        if (this.isCurPeriod) {
            sql.append("T_FA_FaCurCard A WHERE FID = '" + id + "'");
        } else {
            sql.append("T_FA_FaMonCard A ");
            sql.append("LEFT OUTER JOIN T_BD_Period AS PERIOD ");
            sql.append("ON A.FFAPeriodID = PERIOD.FID ");
            sql.append("WHERE PERIOD.fperiodyear = " + this.year + " and period.fperiodnumber = " + this.month);
            sql.append(" AND FFACURCARDID = '" + id + "'");
        }
        return sql.toString();
    }

    private String getCostCenterSql(String cardId, ArrayList idList) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT A.CARDID, A.accountViewNumber, A.accountViewName ,A.FasstActLName ,A.FApportionScale FROM ");
        sql.append("(SELECT ");
        sql.append("FACOSTCENTER.CARDID, ");
        sql.append("accountView.fnumber AS accountViewNumber, ");
        sql.append("accountView." + fName + " AS accountViewName, ");
        sql.append("FACOSTCENTER.FasstActLName AS FasstActLName, ");
        sql.append("FACOSTCENTER.FApportionScale AS FApportionScale ");
        sql.append("FROM ");
        sql.append("(");
        sql.append("SELECT FFaBizCardID AS CARDID, FAccountViewId,FasstActLName, FApportionScale FROM T_FA_FaBizCostCenter");
        sql.append(" where FFaBizCardID " + this.handleIDList(idList));
        sql.append(" UNION ALL ");
        sql.append("SELECT FFaBakCardID AS CARDID,FAccountViewId , FasstActLName, FApportionScale FROM T_FA_FaBakCostCenter ");
        sql.append(" where FFaBakCardID " + this.handleIDList(idList));
        sql.append(" UNION ALL ");
        sql.append(" SELECT ffacurcardid AS CARDID, FAccountViewId, FasstActLName,fapportionscale FROM T_FA_FaCurCostCenter ");
        sql.append(" WHERE  ffacurcardid " + this.handleIDList(idList));
        sql.append(") AS FACOSTCENTER ");
        sql.append(" INNER JOIN T_BD_AccountView accountView on accountView.Fid = FACOSTCENTER.FAccountViewId");
        sql.append(") AS A");
        sql.append(" ORDER BY CARDID ASC, FApportionScale DESC");
        return sql.toString();
    }

    private String getUseDeptSql(String cardId, ArrayList idList) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT A.CARDID, A.UseDepartment, A.UseDepartmentLName FROM ");
        sql.append("( SELECT ");
        sql.append("M.CARDID AS CARDID, ");
        sql.append("unit." + fName + " AS UseDepartment ,");
        sql.append("unit.FDisplayName_" + local + " AS UseDepartmentLName ");
        sql.append("FROM ( ");
        sql.append("SELECT FFaBakCardID AS CARDID, FUseDepartmentID FROM T_FA_FaBakDepartment ");
        sql.append(" where FFaBakCardID " + this.handleIDList(idList));
        sql.append(" UNION ALL ");
        sql.append("SELECT FFaBizCardID AS CARDID, FUseDepartmentID FROM T_FA_FaBizDepartment ");
        sql.append(" where FFaBizCardID " + this.handleIDList(idList));
        sql.append(" UNION ALL ");
        sql.append(" SELECT ffacurcardid AS cardid, fusedepartmentid FROM   t_fa_facurdepartment ");
        sql.append(" WHERE  ffacurcardid " + this.handleIDList(idList));
        sql.append(") AS M ");
        sql.append("LEFT OUTER JOIN T_ORG_Admin AS unit ON M.FUseDepartmentID = unit.FID ");
        sql.append(") AS A");
        sql.append(" ORDER BY CARDID ASC ");
        return sql.toString();
    }

    private String getOriginUnitSql(String originTypeField, String originUnitId) {
        StringBuffer sql = new StringBuffer();
        sql.append("(CASE WHEN(");
        sql.append(originTypeField);
        sql.append(" = 2) ");
        sql.append("THEN (SELECT CP." + fName + " FROM T_ORG_BaseUnit AS CP WHERE CP.FID = ");
        sql.append(originUnitId);
        sql.append(") WHEN(");
        sql.append(originTypeField);
        sql.append(" = 1) ");
        sql.append("THEN (SELECT CS." + fName + " FROM T_BD_Customer AS CS WHERE CS.FID = ");
        sql.append(originUnitId);
        sql.append(") ELSE (");
        sql.append("SELECT CS." + fName + " FROM T_BD_Supplier AS CS WHERE CS.FID = ");
        sql.append(originUnitId);
        sql.append(") END)");
        return sql.toString();
    }

    public static String getCurrentCompanyId(Context ctx) {
        CompanyOrgUnitInfo aCompanyOrgUnitInfo = null;
        aCompanyOrgUnitInfo = ctx != null ? ContextUtil.getCurrentFIUnit((Context)ctx) : SysContext.getSysContext().getCurrentFIUnit();
        String strCompanyOrgUnitInfoID = aCompanyOrgUnitInfo.getId().toString();
        return strCompanyOrgUnitInfoID;
    }

    protected String getAsstActItemTable(Context ctx) throws BOSException {
        FaCreateTempTableResult result;
        String tempTable = "faTempTable";
        CompanyOrgUnitInfo currCompanyInfo = ContextUtil.getCurrentFIUnit((Context)ctx);
        String assist = this.getAsstActItemSQLFrmAsstType(ctx);
        StringBuffer currCardSql = new StringBuffer();
        currCardSql.append("select cost.fid as fid,cost.fasstacttypeid,cost.fasstactitem from t_fa_facurcard c");
        currCardSql.append(" inner join t_fa_facurcostcenter cost on cost.ffacurcardid = c.fid");
        currCardSql.append(" where c.fcompanyid ").append(" = '" + currCompanyInfo.getId().toString() + "'");
        StringBuffer sql = new StringBuffer();
        sql.append("select distinct assist.* from (").append(currCardSql).append(") as cost");
        sql.append(" inner join (").append(assist).append(") as assist on assist.FAsstacttypeID = cost.fasstacttypeid and assist.FID = cost.fasstactitem");
        Connection con = null;
        try {
            String tmpSql = "select * into " + tempTable + " from (" + sql.toString() + ") as tmpTable";
            con = EJBFactory.getConnection((Context)ctx);
            FaDBUtilConfig cf = new FaDBUtilConfig();
            cf.addFiledSize("FASSTACTTYPEID", 44);
            cf.addFiledSize("FNAME_L1", 300);
            cf.addFiledSize("FNAME_L2", 300);
            cf.addFiledSize("FNAME_L3", 300);
            cf.addFiledSize("FCONTROLUNITID", 44);
            cf.addFiledSize("FPARENTID", 44);
            cf.addFiledSize("FLONGNUMBER", 300);
            result = FaDBUtil.executeSelectInto(ctx, tmpSql, null, con, cf);
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Connection)con);
        return result.getTempTable();
    }

    protected String getAsstActItemSQLFrmAsstType(Context ctx) throws BOSException {
        CoreBaseCollection AsstActTypes = AsstActTypeFactory.getLocalInstance((Context)ctx).getCollection("select id,realtionDataObject,groupTableName,isMultilevel ");
        String select = "select a.fid FID,a.fname_l1 FNAME_L1,a.fname_l2 FNAME_L2,a.fname_l3 FNAME_L3,a.fnumber FNUMBER,a.FCONTROLUNITID,a.FPARENTID,a.FAsstacttypeID,t.fname_l2 AS FAsstActName,a.fisleaf AS FISLEAF,a.flevel FLEVEL,a.flongnumber FLONGNUMBER from (";
        String selectCol = "SELECT fid AS fid, fname_l1 AS fname_l1, fname_l2 AS fname_l2, fname_l3 AS fname_l3, fnumber AS fnumber,fcontrolunitid AS fcontrolunitid ";
        StringBuffer sql = new StringBuffer();
        for (int i = 0; i < AsstActTypes.size(); ++i) {
            AsstActTypeInfo asstActType = (AsstActTypeInfo)AsstActTypes.get(i);
            String tableName = asstActType.getRealtionDataObject();
            if ("t_bd_GeneralAsstActType".equalsIgnoreCase(tableName) || "T_NCM_CostItem".equalsIgnoreCase(tableName)) continue;
            String asstActTypeId = "'" + asstActType.getId() + "' AS FAsstActTypeID";
            if (sql.length() > 0) {
                sql.append(" UNION ALL \n");
            }
            boolean hasLevel = asstActType.getBoolean("isMultilevel") && asstActType.getGroupTableName() == null;
            String selects = selectCol + "," + asstActTypeId + (hasLevel ? ", FPARENTID" : ", NULL AS FPARENTID");
            sql.append(selects).append(",").append(hasLevel ? "fisleaf" : "1").append(" AS fisleaf,");
            sql.append(hasLevel ? "flevel" : "1").append(" AS flevel,");
            sql.append(hasLevel ? "flongnumber" : "fnumber").append(" AS flongnumber FROM ").append(tableName).append(" \n");
        }
        String selects = "SELECT gt.fid AS fid, gt.fname_l1 AS fname_l1, gt.fname_l2 AS fname_l2, gt.fname_l3 AS fname_l3, gt.fnumber AS fnumber,gt.fcontrolunitid AS fcontrolunitid,t.FID AS FASSTACTTYPEID, gt.FPARENTID AS FPARENTID ";
        if (sql.length() > 0) {
            sql.append(" UNION ALL \n");
        }
        sql.append(selects + ", gt.fisleaf AS FISLEAF,gt.flevel AS FLEVEL,gt.flongnumber as FLONGNUMBER FROM t_bd_AsstActType AS t");
        sql.append(" inner join t_Bd_Generalasstacttypegroup g on t.fglasstacttypegrpid = g.fid");
        sql.append(" inner join t_bd_GeneralAsstActType gt on gt.fgroupid = g.fid \n");
        return select + sql.toString() + ") a  inner join t_bd_asstacttype t on t.fid = a.FASSTACTTYPEID";
    }
}

