/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.rpt.app.dao;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.app.FaLocalUtils;
import com.kingdee.eas.fi.fa.rpt.FaDBUtilConfig;
import com.kingdee.eas.fi.fa.rpt.FaDaoSqlObject;
import com.kingdee.eas.fi.fa.rpt.FaSumItemEnum;
import com.kingdee.eas.fi.fa.rpt.FaSumItemEnumX;
import com.kingdee.eas.fi.fa.rpt.LevelSumCompany;
import com.kingdee.eas.fi.fa.rpt.LevelSumOption;
import com.kingdee.eas.fi.fa.rpt.LevelSumSqlInfo;
import com.kingdee.eas.fi.fa.rpt.app.dao.FaShowNotAuditDao;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.enums.StringEnum;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class FaComposingDao
extends FaShowNotAuditDao {
    private static final Logger logger = Logger.getLogger(FaComposingDao.class);
    private String insertCompanySql;
    private String select;
    private String sumSql;
    private StringEnum composeMode;
    private boolean isShowNoCardCompany;
    private boolean isByEvalue;

    @Override
    protected void initEvVar(EntityViewInfo ev) throws EASBizException, BOSException {
        super.initEvVar(ev);
        Map m = (Map)ev.get("customcond");
        if (this.isVirCompany) {
            this.isShowNoCardCompany = (Boolean)m.get("isShowNoCardCompany");
        }
        this.composeMode = (StringEnum)m.get("composeMode");
        if (this.composeMode == null) {
            String defProperty = (String)m.get("composeModeX");
            this.composeMode = new FaSumItemEnumX(defProperty, defProperty);
        }
        this.isByEvalue = (Boolean)m.get("isByEvalue");
    }

    @Override
    protected void buildSql() throws BOSException {
        this.select = this.getSumSelectSql(true);
        this.buildResultSql();
    }

    @Override
    protected void buildData() throws BOSException {
        String sumSqlTwo;
        this.addDataTempTable(FaLocalUtils.transformLocal((Context)this.ctx, (String)this.buildQueryCardSQL()));
        if (this.isVirCompany && this.isShowNoCardCompany) {
            this.insertCompanySql = this.insertVacantCompany(this.tempTable, this.getSumSelectSql(false), this.strCompanyInclude);
        }
        if (this.isVirCompany && this.isShowNoCardCompany) {
            DbUtil.execute((Context)this.ctx, (String)FaLocalUtils.transformLocal((Context)this.ctx, (String)this.insertCompanySql));
        }
        this.sumSql = this.isVirCompany && !this.composeMode.equals((Object)FaSumItemEnum.asstActItem) || FaSumItemEnum.storeCity.equals(this.composeMode) || this.composeMode instanceof FaSumItemEnumX ? this.sumOption.getSumSql(this.tempTable, this.select, this.getSumSqlDistinctSelect(), null, null, true, false) : (this.isVirCompany && this.composeMode.equals((Object)FaSumItemEnum.asstActItem) ? this.sumOption.getSumSql(this.tempTable, this.select, this.getSumSqlDistinctSelect(), null, null, true, "isVirCompanyAsstActItem", false) : this.sumOption.getSumSqlForNode(this.tempTable, this.select, this.getSumSqlDistinctSelect(), null, null, true));
        if (!this.isVirCompany && (sumSqlTwo = this.sumOption.getSumSqlForNodeTwo(this.tempTable, this.select, this.getSumSqlDistinctSelect(), null, null, true, this.def.getSelectDefColumns("", ""))) != null && sumSqlTwo.trim().length() > 0) {
            DbUtil.execute((Context)this.ctx, (String)FaLocalUtils.transformLocal((Context)this.ctx, (String)sumSqlTwo));
        }
        if (this.sumSql != null && this.sumSql.trim().length() > 0) {
            DbUtil.execute((Context)this.ctx, (String)FaLocalUtils.transformLocal((Context)this.ctx, (String)this.sumSql));
        }
        if (this.isVirCompany && !this.composeMode.equals((Object)FaSumItemEnum.asstActItem)) {
            this.deleteUnNecessaryData();
            this.insertCompanySumData();
        } else if (!FaSumItemEnum.storeCity.equals(this.composeMode) && !(this.composeMode instanceof FaSumItemEnumX)) {
            this.insertAllCardSumData();
            this.updateOnAssctActNode();
        }
        if (!this.isVirCompany && FaSumItemEnum.useDepartment.equals(this.composeMode)) {
            int maxLevel = this.getSumItemMaxLevel("useDepartment");
            String maxLevelLongNumber = "useDepartment" + maxLevel + "LongNumber";
            for (int i = 1; i < maxLevel; ++i) {
                String iLevelLongNumber = "useDepartment" + i + "LongNumber";
                DbUtil.execute((Context)this.ctx, (String)FaLocalUtils.transformLocal((Context)this.ctx, (String)("update " + this.tempTable + " set " + maxLevelLongNumber + " = " + iLevelLongNumber + " where SumLevel = " + i)));
            }
        }
        this.fillSumAssetValue();
        this.result.put("totalAssetValue", this.getTotalAssetValue());
    }

    private String buildQueryCardSQL() {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT newBosID('00000000') AS FId  , ");
        sql.append(this.sumOption.getStrNameFields() + ", ");
        sql.append(this.getCardSelectSql());
        if (this.sumOption.isHasSum()) {
            sql.append(", " + this.sumOption.getStrLongNumberFields());
        }
        sql.append(" FROM ").append(this.getJoinSql(this.isCurrPeriod));
        if (this.filter != null) {
            sql.append(" WHERE ").append(this.filter);
        }
        return sql.toString();
    }

    private void buildResultSql() throws BOSException {
        StringBuffer sql = new StringBuffer();
        if (this.sumOption.isHasSum()) {
            sql.append(this.sumOption.getStrSelectResult() + ", ");
        }
        sql.append(this.getSelectResultSql());
        this.resultSql.setSelect(sql.toString());
        this.resultSql.setFrom(this.tempTable);
        sql = new StringBuffer();
        if (this.sumOption.isHasSum()) {
            sql.append(this.sumOption.getOrderFields().toString()).append(", ");
        }
        if (!this.isVirCompany && FaSumItemEnum.useDepartment.equals(this.composeMode)) {
            sql = new StringBuffer();
            sql.append("useDepartment").append(this.getSumItemMaxLevel("useDepartment")).append("LongNumber, ");
        }
        if (this.isVirCompany || !FaSumItemEnum.storeCity.equals(this.composeMode) && !(this.composeMode instanceof FaSumItemEnumX)) {
            sql.append(" SumLevel , ").append(" isSum DESC");
        } else {
            sql.append(" isSum");
        }
        sql.append(", fid");
        this.resultSql.setOrder(sql.toString());
    }

    private String getCardSelectSql() {
        StringBuffer sql = new StringBuffer();
        sql.append("FACURCARD.FNumber AS ASSETNUMBER, ");
        sql.append("FACURCARD.FoldNumber AS OLDERNUMBER, ");
        sql.append("FACURCARD.FGroupNumber AS GROUPNUMBER, ");
        sql.append("FACURCARD.FID AS CardID, ");
        sql.append("FACURCARD.FAssetName AS ASSETNAME, ");
        sql.append("1 AS cardNum, ");
        sql.append("FACURCARD.FAssetAmt AS ASSETAMT, ");
        sql.append("MEASUREUNIT.").append(this.fName).append(" AS MEASUREUNIT_NAME, ");
        if (this.isByEvalue) {
            sql.append("CASE FACURCARD.FIsEvaledBefore WHEN 0 THEN FACURCARD.FAssetValue ELSE FACURCARD.FInitEvalValue END AS ASSETVALUE, ");
        } else {
            sql.append("FACURCARD.FAssetValue AS ASSETVALUE, ");
        }
        sql.append("COMPANY.FID AS COMPANY_ID, ");
        sql.append("FACURCARD.FAssetValue AS TYPERATE, ");
        sql.append("0.00 AS RATE, ");
        sql.append("0 AS isSum");
        sql.append(this.def.getSelectPart(""));
        if (this.isVirCompany) {
            sql.append(",COMPANY.FLevel AS SumLevel");
        } else if (this.composeMode.equals((Object)FaSumItemEnum.assetCat)) {
            sql.append(",ASSETCAT.FLevel AS SumLevel");
        } else if (this.composeMode.equals((Object)FaSumItemEnum.useStatus)) {
            sql.append(",USESTATUS.FLevel AS SumLevel");
        } else if (this.composeMode.equals((Object)FaSumItemEnum.economicPurp)) {
            sql.append(",ECONOMICPURP.FLevel AS SumLevel");
        } else if (this.composeMode.equals((Object)FaSumItemEnum.originMethod)) {
            sql.append(",ORIGINMETHOD.FLevel AS SumLevel");
        } else if (this.composeMode.equals((Object)FaSumItemEnum.useDepartment)) {
            sql.append(",useDepartment.FLevel AS SumLevel");
        } else if (this.composeMode.equals((Object)FaSumItemEnum.asstActItem)) {
            sql.append(",asstActItem.FLevel AS SumLevel");
        }
        return sql.toString();
    }

    private String getSumSelectSql(boolean isSum) {
        StringBuffer sql = new StringBuffer();
        sql.append("TO_CHAR(null) AS ASSETNUMBER, ");
        sql.append("TO_CHAR(null) AS OLDERNUMBER, ");
        sql.append("TO_CHAR(null) AS GROUPNUMBER, ");
        sql.append("TO_CHAR(null) AS CardID, ");
        sql.append("TO_CHAR(null) AS ASSETNAME, ");
        sql.append(isSum ? "sum(cardNum)" : "0").append(" AS cardNum, ");
        sql.append("TO_INT(null) AS ASSETAMT, ");
        sql.append("TO_CHAR(null) AS MEASUREUNIT_NAME, ");
        sql.append(isSum ? "sum(AssetValue)" : "0").append(" AS ASSETVALUE, ");
        sql.append("TO_CHAR(null) AS COMPANY_ID, ");
        sql.append("0.00 AS TYPERATE, ");
        sql.append("0.00 AS RATE, ");
        sql.append(isSum ? "1" : "0").append(" AS isSum");
        if (isSum) {
            sql.append(this.def.getSelectSumPart(""));
        } else {
            sql.append(this.def.getSelectNoSumPart(""));
        }
        return sql.toString();
    }

    private String getSelectResultSql() {
        StringBuffer sql = new StringBuffer();
        sql.append(" ASSETNUMBER, ");
        sql.append(" OLDERNUMBER, ");
        sql.append(" GROUPNUMBER, ");
        sql.append(" CardID, ");
        sql.append(" ASSETNAME, ");
        sql.append(" cardNum, ");
        sql.append(" ASSETAMT, ");
        sql.append(" MEASUREUNIT_NAME, ");
        sql.append(" ASSETVALUE, ");
        sql.append(" COMPANY_ID, ");
        sql.append(" TYPERATE, ");
        sql.append(" RATE, ");
        sql.append(" isSum ");
        sql.append(this.def.getSelectPart(""));
        if (this.isVirCompany || !FaSumItemEnum.storeCity.equals(this.composeMode) && !(this.composeMode instanceof FaSumItemEnumX)) {
            sql.append(", SumLevel ");
        }
        return sql.toString();
    }

    protected String getSumSqlDistinctSelect() {
        StringBuffer sql = new StringBuffer();
        sql.append("CardID, ");
        sql.append("cardNum, ");
        sql.append("ASSETVALUE");
        sql.append(this.def.getNumFieldForSumPart());
        return sql.toString();
    }

    private String getJoinSql(boolean isCurPeriod) {
        String tableName;
        StringBuffer sql = new StringBuffer("(SELECT DISTINCT * FROM (");
        if (this.isVirCompany && !this.isInitPeriod) {
            sql.append(this.getCurCardSQL());
            sql.append(" UNION ");
            sql.append(this.getMonCardSQL());
        } else if (isCurPeriod) {
            sql.append(this.getCurCardSQL());
        } else {
            sql.append(this.getMonCardSQL());
        }
        sql.append(" )AS TMP) AS FACURCARD ");
        if (this.isVirCompany && (tableName = this.getSumItemJoinSql("orgArchitecture")) != null) {
            sql.append(" INNER JOIN ").append(tableName).append(" AS ").append("orgArchitecture");
            sql.append(" ON FACURCARD.FCompanyID = ").append("orgArchitecture").append(".FID ");
        }
        sql.append("INNER JOIN T_BD_MeasureUnit AS MEASUREUNIT ON FACURCARD.FMeasureUnitID = MEASUREUNIT.FID ");
        if (this.composeMode.equals((Object)FaSumItemEnum.assetCat)) {
            tableName = this.isVirCompany ? this.getSumItemTableName("assetCat") : this.getSumItemJoinSql("assetCat");
            sql.append("INNER JOIN ").append(tableName).append(" AS ").append("assetCat").append(" ON FACURCARD.FAssetCatID = ").append("assetCat").append(".FID");
        } else if (this.composeMode.equals((Object)FaSumItemEnum.useStatus)) {
            tableName = this.isVirCompany ? this.getSumItemTableName("useStatus") : this.getSumItemJoinSql("useStatus");
            sql.append("INNER JOIN ").append(tableName).append(" AS ").append("useStatus").append(" ON FACURCARD.FUseStatusID = ").append("useStatus").append(".FID ");
        } else if (this.composeMode.equals((Object)FaSumItemEnum.economicPurp)) {
            tableName = this.isVirCompany ? this.getSumItemTableName("economicPurp") : this.getSumItemJoinSql("economicPurp");
            sql.append("INNER JOIN ").append(tableName).append(" AS ").append("economicPurp").append(" ON FACURCARD.FEconomicPurpID = ").append("economicPurp").append(".FID ");
        } else if (this.composeMode.equals((Object)FaSumItemEnum.storeCity)) {
            tableName = this.getSumItemTableName("storeCity");
            sql.append("INNER JOIN ").append(tableName).append(" AS ").append("storeCity").append(" ON FACURCARD.FStoreCityID = ").append("storeCity").append(".FID ");
        } else if (this.composeMode.equals((Object)FaSumItemEnum.originMethod)) {
            tableName = this.isVirCompany ? this.getSumItemTableName("originMethod") : this.getSumItemJoinSql("originMethod");
            sql.append("INNER JOIN ").append(tableName).append(" AS ").append("originMethod").append(" ON FACURCARD.FOriginMethodID = ").append("originMethod").append(".FID ");
        } else if (this.composeMode.equals((Object)FaSumItemEnum.useDepartment)) {
            tableName = this.isVirCompany ? this.getSumItemTableName("useDepartment") : this.getSumItemJoinSql("useDepartment");
            sql.append("INNER JOIN ").append(tableName).append(" AS ").append("useDepartment").append(" ON FACURCARD.FUseDepartmentID = ").append("useDepartment").append(".FID ");
        } else if (this.composeMode.equals((Object)FaSumItemEnum.asstActItem)) {
            tableName = this.isVirCompany ? this.getSumItemTableName("asstActItem") : this.getSumItemJoinSql("asstActItem");
            sql.append("LEFT OUTER JOIN ").append(tableName).append(" AS ").append("asstActItem").append(" ON FACURCARD.FAsstActItem = ").append("asstActItem").append(".FID ");
            sql.append(" AND FACURCARD.FAsstActTypeID = ").append("asstActItem").append(".FAsstActTypeID ");
            sql.append(" LEFT OUTER JOIN ").append(this.getSumItemTableName("asstActType")).append(" AS ").append("asstActType");
            sql.append(" ON ").append("asstActItem").append(".FAsstActTypeID = ").append("asstActType").append(".FID");
        }
        sql.append(" INNER JOIN T_ORG_Company AS COMPANY ON FACURCARD.FCompanyID = COMPANY.FID ");
        return sql.toString();
    }

    private String getMonCardSQL() {
        FaDaoSqlObject sql = new FaDaoSqlObject();
        StringBuffer select = new StringBuffer();
        select.append("CARD.FID,CARD.FNumber,CARD.FOLDNUMBER,CARD.FGroupNumber,CARD.FAssetName,CARD.FAssetAmt,CARD.FAssetValue,CARD.FInitEvalValue,CARD.FIsEvaledBefore,");
        if (this.composeMode.equals((Object)FaSumItemEnum.assetCat)) {
            select.append("CARD.FAssetCatID,");
        } else if (this.composeMode.equals((Object)FaSumItemEnum.economicPurp)) {
            select.append("CARD.FEconomicPurpID,");
        } else if (this.composeMode.equals((Object)FaSumItemEnum.useStatus)) {
            select.append("CARD.FUseStatusID,");
        } else if (this.composeMode.equals((Object)FaSumItemEnum.storeCity)) {
            select.append("CARD.FStoreCityID,");
        } else if (this.composeMode.equals((Object)FaSumItemEnum.originMethod)) {
            select.append("CARD.FOriginMethodID,");
        }
        select.append("CARD.fCheckedStatus,CARD.fDeletedStatus,CARD.FMeasureUnitID,CARD.FCompanyID");
        select.append(this.def.getSelectPart(null));
        String join = this.isInitPeriod ? " LEFT OUTER JOIN " : " INNER JOIN ";
        StringBuffer from = new StringBuffer("T_FA_FaMonCard CARD");
        from.append(join).append("T_BD_Period PERIOD ON CARD.FFaPeriodID = PERIOD.FID");
        if (this.composeMode.equals((Object)FaSumItemEnum.useDepartment)) {
            from.append(" INNER JOIN T_FA_FaMonDepartment AS faDepartment ON CARD.FID = faDepartment.FFaMonCardID");
            select.append(",faDepartment.FUseDepartmentID AS FUseDepartmentID");
        }
        if (this.composeMode.equals((Object)FaSumItemEnum.asstActItem)) {
            from.append(" INNER JOIN T_FA_FaMonCostCenter AS FACOSTCENTER ON CARD.FID = FACOSTCENTER.FFaMonCardID");
            from.append(" LEFT OUTER JOIN T_FA_FAMonASSTACTCOMPOSIT COMPOSIT ON COMPOSIT.FFAMonCOSTCENTERID = FACOSTCENTER.FID");
            select.append(",COMPOSIT.FAsstActItem AS FAsstActItem, COMPOSIT.FAsstActtype FAsstActtypeID");
        }
        try {
            from.append(this.def.getJoinPart("CARD.FPropertyValueID"));
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        sql.setSelect(select.toString());
        sql.setFrom(from.toString());
        StringBuffer where = new StringBuffer();
        where.append(this.getCompanyFilter(false));
        if (this.isInitPeriod) {
            where.append("AND CARD.FFaPeriodID IS NULL");
        } else {
            where.append("AND period.fperiodyear = ? AND period.fperiodnumber = ? ");
            this.params.addInt(this.startYear);
            this.params.addInt(this.startNumber);
        }
        where.append(" AND CARD.fCheckedStatus = 2 AND CARD.fDeletedStatus != 2");
        sql.setWhere(where.toString());
        return sql.getSql();
    }

    private String getCurCardSQL() {
        FaDaoSqlObject sql = new FaDaoSqlObject();
        StringBuffer select = new StringBuffer();
        select.append("CARD.FID,CARD.FNumber,CARD.FoldNumber,CARD.FGroupNumber,CARD.FAssetName,CARD.FAssetAmt,CARD.FAssetValue,CARD.FInitEvalValue,CARD.FIsEvaledBefore,");
        if (this.composeMode.equals((Object)FaSumItemEnum.assetCat)) {
            select.append("CARD.FAssetCatID,");
        } else if (this.composeMode.equals((Object)FaSumItemEnum.economicPurp)) {
            select.append("CARD.FEconomicPurpID,");
        } else if (this.composeMode.equals((Object)FaSumItemEnum.useStatus)) {
            select.append("CARD.FUseStatusID,");
        } else if (this.composeMode.equals((Object)FaSumItemEnum.storeCity)) {
            select.append("CARD.FStoreCityID,");
        } else if (this.composeMode.equals((Object)FaSumItemEnum.originMethod)) {
            select.append("CARD.FOriginMethodID,");
        }
        select.append("CARD.fCheckedStatus,CARD.fDeletedStatus,CARD.FMeasureUnitID,CARD.FCompanyID");
        select.append(this.def.getSelectPart(null));
        StringBuffer from = new StringBuffer("T_FA_FaCurCard CARD");
        from.append(" INNER JOIN T_BD_Period PERIOD ON CARD.FPeriodID = PERIOD.FID");
        if (this.composeMode.equals((Object)FaSumItemEnum.useDepartment)) {
            from.append(" INNER JOIN T_FA_FaCurDepartment AS faDepartment ON CARD.FID = faDepartment.FFaCurCardID");
            select.append(",faDepartment.FUseDepartmentID AS FUseDepartmentID");
        }
        if (this.composeMode.equals((Object)FaSumItemEnum.asstActItem)) {
            from.append(" INNER JOIN T_FA_FaCurCostCenter AS FACOSTCENTER ON CARD.FID = FACOSTCENTER.FFaCurCardID");
            from.append(" LEFT OUTER JOIN T_FA_FACURASSTACTCOMPOSIT COMPOSIT ON COMPOSIT.FFACURCOSTCENTERID = FACOSTCENTER.FID");
            select.append(",COMPOSIT.FAsstActItem AS FAsstActItem, COMPOSIT.FAsstActtype AS FAsstActtypeID");
        }
        try {
            from.append(this.def.getJoinPart("CARD.FPropertyValueID"));
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new RuntimeException(e);
        }
        sql.setSelect(select.toString());
        sql.setFrom(from.toString());
        StringBuffer where = new StringBuffer();
        where.append(this.isShowNotAudit ? " CARD.FEffectedStatus = 2" : " CARD.fCheckedStatus = 2");
        where.append(" AND CARD.fDeletedStatus != 2");
        int periodNumber = this.startYear * 100 + this.startNumber;
        where.append(" AND PERIOD.fnumber <= ").append(periodNumber);
        where.append(" AND ").append(this.getCompanyFilter(true));
        sql.setWhere(where.toString());
        return sql.getSql();
    }

    private String getCompanyFilter(boolean isCurrPeriod) {
        StringBuffer sbff = new StringBuffer();
        if (this.isVirCompany) {
            StringBuffer companyQuery = new StringBuffer();
            companyQuery.append(" SELECT company.fid FROM t_bd_SystemStatusCtrol ssc");
            companyQuery.append(" INNER JOIN t_bd_period period ON ssc.fcurrentperiodid = period.fid");
            companyQuery.append(" INNER JOIN t_org_company company ON ssc.fcompanyid = company.fid");
            companyQuery.append(" INNER JOIN t_bd_SystemStatus ss on ss.fid=ssc.fsystemstatusid");
            if (isCurrPeriod) {
                companyQuery.append(" WHERE period.FPeriodYear = ? AND period.fperiodnumber = ? ");
                this.params.addInt(this.startYear);
                this.params.addInt(this.startNumber);
            } else {
                companyQuery.append(" WHERE (period.FPeriodYear > ? ");
                companyQuery.append(" OR (period.FPeriodYear = ? AND period.fperiodnumber > ? ))");
                this.params.addInt(this.startYear);
                this.params.addInt(this.startYear);
                this.params.addInt(this.startNumber);
            }
            companyQuery.append(" AND ss.fname= ").append(14);
            companyQuery.append(" AND company.fid IN (").append(this.strCompanyInclude).append(")");
            sbff.append(" CARD.FCOMPANYID IN (").append(companyQuery).append(")");
        } else {
            sbff.append(" CARD.FCOMPANYID = '" + this.currCompanyInfo.getId().toString() + "' ");
        }
        return sbff.toString();
    }

    private void insertAllCardSumData() throws BOSException {
    }

    private void updateOnAssctActNode() throws BOSException {
    }

    private void insertCompanySumData() throws BOSException {
        List sumGroup = this.sumOption.getSumInfoList();
        if (sumGroup.isEmpty()) {
            return;
        }
        String total = ResourceBase.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"total2", (Locale)this.ctx.getOriginLocale());
        LevelSumSqlInfo sumInfo = (LevelSumSqlInfo)sumGroup.get(0);
        StringBuffer sumNameItems = new StringBuffer();
        sumNameItems.append(",N'").append(total).append("' AS ").append(sumInfo.getNameField());
        StringBuffer sumNumberItems = new StringBuffer(",");
        sumNumberItems.append("N'").append(LevelSumOption.MAXCODE).append("' AS ").append(sumInfo.getLongNumberField());
        for (int n = 0; n < sumGroup.size(); ++n) {
            LevelSumSqlInfo sqlInfo = (LevelSumSqlInfo)sumGroup.get(n);
            if (sqlInfo instanceof LevelSumCompany || n <= 0) continue;
            sumNameItems.append(", NULL AS ").append(sqlInfo.getNameField());
            sumNumberItems.append(", NULL AS ").append(sqlInfo.getLongNumberField());
        }
        StringBuffer sql = new StringBuffer();
        int k = 0;
        Iterator sumItems = sumGroup.iterator();
        StringBuffer from = null;
        while (sumItems.hasNext()) {
            LevelSumSqlInfo currSumInfo = (LevelSumSqlInfo)sumItems.next();
            if (!(currSumInfo instanceof LevelSumCompany)) {
                ++k;
                continue;
            }
            from = new StringBuffer("( SELECT DISTINCT ").append(this.getSumSqlDistinctSelect()).append(",").append("isSum");
            if (sql.length() > 0) {
                sql.append(" UNION ALL ");
            }
            sql.append(" SELECT ");
            sql.append(" newBOSID('00000000') AS FId");
            StringBuffer selectName = new StringBuffer();
            StringBuffer selectLongNumber = new StringBuffer();
            StringBuffer groupName = new StringBuffer();
            StringBuffer groupLongNumber = new StringBuffer();
            int size = sumGroup.size();
            for (int i = 0; i < size; ++i) {
                LevelSumSqlInfo sumSqlInfo = (LevelSumSqlInfo)sumGroup.get(i);
                if (!(sumSqlInfo instanceof LevelSumCompany)) continue;
                if (i <= k) {
                    selectName.append(",").append(sumSqlInfo.getNameField());
                    selectLongNumber.append(",").append(sumSqlInfo.getLongNumberField());
                    groupName.append(",").append(sumSqlInfo.getNameField());
                    groupLongNumber.append(",").append(sumSqlInfo.getLongNumberField());
                    continue;
                }
                selectName.append(", NULL AS ").append(sumSqlInfo.getNameField());
                selectLongNumber.append(", N'").append("NULL").append("' AS ").append(sumSqlInfo.getLongNumberField());
            }
            from.append(groupLongNumber).append(groupName);
            sql.append(sumNameItems);
            sql.append(selectName.toString()).append(",");
            sql.append(this.select).append(", ").append(currSumInfo.getLevel()).append(" AS sumlevel");
            sql.append(sumNumberItems);
            sql.append(selectLongNumber.toString());
            sql.append(" FROM ").append(from).append(" FROM ").append(this.tempTable).append(") AS t");
            sql.append(" WHERE isSum = 0 AND ").append(currSumInfo.getLongNumberField()).append(" IS NOT NULL");
            sql.append(" GROUP BY ").append(groupLongNumber.substring(1)).append(groupName.toString());
            ++k;
        }
        DbUtil.execute((Context)this.ctx, (String)("INSERT INTO " + this.tempTable + sql.toString()));
    }

    private void deleteUnNecessaryData() throws BOSException {
        String companyName = "orgArchitecture" + this.currCompanyInfo.getLevel() + "NAME";
        StringBuffer sql = new StringBuffer();
        sql.append("DELETE FROM ");
        sql.append(this.tempTable);
        sql.append(" WHERE (ISSUM=0 AND ASSETNUMBER IS NULL) OR ").append(companyName).append(" IS NULL");
        DbUtil.execute((Context)this.ctx, (String)sql.toString());
    }

    private void fillSumAssetValue() throws BOSException {
        List sumGroup = this.sumOption.getSumInfoList();
        if (sumGroup.size() > 0) {
            LevelSumSqlInfo sumSqlInfo = (LevelSumSqlInfo)sumGroup.get(0);
            StringBuffer sql = new StringBuffer();
            sql.append("UPDATE ").append(this.tempTable).append(" SET typerate = ");
            sql.append("(SELECT MAX(t.assetvalue) FROM ").append(this.tempTable).append(" t ");
            sql.append(" WHERE ").append(this.tempTable).append(".").append(sumSqlInfo.getLongNumberField());
            sql.append("= t.").append(sumSqlInfo.getLongNumberField());
            if ((!"asstActType".equals(sumSqlInfo.getResource()) || this.isVirCompany) && "asstActType".equals(sumSqlInfo.getResource())) {
                sql.append(" AND ").append(this.tempTable).append(".asstActItemLongNumber = t.asstActItemLongNumber ");
            }
            sql.append(" AND t.issum = 1)");
            DbUtil.execute((Context)this.ctx, (String)sql.toString());
        }
    }

    private BigDecimal getTotalAssetValue() throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT SUM(VVV.ASSETVALUE) AS ASSETVALUE FROM (SELECT DISTINCT CARDID,ASSETVALUE FROM ").append(this.tempTable).append("  WHERE ISSUM=0 AND CARDID IS NOT NULL) AS VVV ");
        IRowSet rowSet = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
        try {
            if (rowSet.next()) {
                return rowSet.getBigDecimal("ASSETVALUE");
            }
            throw new BOSException("Not found the total assetValue!");
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
    }

    @Override
    protected void tableFieldConfig(FaDBUtilConfig cf) {
        cf.addFiledSize("FNAME_L2", 800);
        cf.addFiledSize("ASSTACTITEM1NAME", 800);
        cf.addFiledSize("ASSTACTITEM2NAME", 800);
        cf.addFiledSize("ASSTACTITEM3NAME", 800);
        cf.addFiledSize("ASSTACTITEMNAME", 800);
    }
}

