/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.rpt.app.dao;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.JdbcRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class FaDAO {
    protected Context ctx = null;
    protected String locale = null;

    public void initDAO(Context ctx) {
        this.ctx = ctx;
        this.locale = ctx.getLocale().toString();
    }

    public static FaDAO getFaDAOInstant(Context ctx) {
        FaDAO dao = new FaDAO();
        dao.initDAO(ctx);
        return dao;
    }

    public int[] insertData(ResultSet rs, String tableName) throws EASBizException, SQLDataException {
        int[] result = null;
        PreparedStatement stat = null;
        Connection conn = this.getConnection(this.ctx);
        try {
            stat = conn.prepareStatement(this.getInsertSql(rs, tableName));
            while (rs.next()) {
                this.setValue(stat, rs);
                stat.addBatch();
            }
            result = stat.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new EASBizException(EASBizException.CHECKNUMBLANK, (Throwable)e, new Object[]{tableName});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stat);
                SQLUtils.cleanup((Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stat);
        SQLUtils.cleanup((Connection)conn);
        return result;
    }

    protected void setValue(PreparedStatement stat, ResultSet rs) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        int i = 1;
        int endIndex = rsmd.getColumnCount() + 1;
        block9: for (i = 1; i < endIndex; ++i) {
            int type = rsmd.getColumnType(i);
            switch (type) {
                case 4: {
                    stat.setInt(i, rs.getInt(i));
                    continue block9;
                }
                case 1: {
                    stat.setString(i, rs.getString(i));
                    continue block9;
                }
                case 12: {
                    stat.setString(i, rs.getString(i));
                    continue block9;
                }
                case 91: {
                    stat.setDate(i, rs.getDate(i));
                    continue block9;
                }
                case 93: {
                    stat.setTimestamp(i, rs.getTimestamp(i));
                    continue block9;
                }
                case 92: {
                    stat.setTime(i, rs.getTime(i));
                    continue block9;
                }
                case 3: {
                    stat.setBigDecimal(i, rs.getBigDecimal(i));
                    continue block9;
                }
            }
        }
    }

    public String getInsertSql(ResultSet rs, String tableName) throws EASBizException, SQLDataException {
        StringBuffer sb = new StringBuffer();
        try {
            int i;
            ResultSetMetaData rsmd = rs.getMetaData();
            sb.append("Insert into " + tableName + "( ");
            int endIndex = rsmd.getColumnCount() + 1;
            for (i = 1; i < endIndex; ++i) {
                String name = rsmd.getColumnName(i);
                sb.append(name + ",");
            }
            sb.replace(sb.length() - 1, sb.length(), ")");
            sb.append("values(");
            endIndex = rsmd.getColumnCount() + 1;
            for (i = 1; i < endIndex; ++i) {
                sb.append("?,");
            }
            sb.replace(sb.length() - 1, sb.length(), ")");
            rsmd = null;
        }
        catch (SQLException exp) {
            throw new SQLDataException(exp);
        }
        return sb.toString();
    }

    public void createTable(String sql) throws EASBizException, SQLDataException {
        PreparedStatement createStmt = null;
        Connection conn = this.getConnection(this.ctx);
        try {
            createStmt = conn.prepareStatement(sql);
            createStmt.execute();
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        finally {
            SQLUtils.cleanup((Statement)createStmt);
            SQLUtils.cleanup((Connection)conn);
        }
    }

    public String buildCreateTableSql(ResultSet rs, String tableName) throws EASBizException, SQLDataException {
        StringBuffer sb = new StringBuffer();
        try {
            ResultSetMetaData rsmd = rs.getMetaData();
            sb.append("Create Table " + tableName + " (");
            int endIndex = rsmd.getColumnCount() + 1;
            block11: for (int i = 1; i < endIndex; ++i) {
                String name = rsmd.getColumnName(i);
                int type = rsmd.getColumnType(i);
                int size = rsmd.getColumnDisplaySize(i);
                switch (type) {
                    case 4: {
                        sb.append(name + " int ,");
                        continue block11;
                    }
                    case 1: {
                        sb.append(name + " char (" + size + "),");
                        continue block11;
                    }
                    case 12: {
                        sb.append(name + " varchar (" + size + "),");
                        continue block11;
                    }
                    case 91: {
                        sb.append(name + " datetime ,");
                        continue block11;
                    }
                    case 92: {
                        sb.append(name + " datetime ,");
                        continue block11;
                    }
                    case 93: {
                        sb.append(name + " datetime ,");
                        continue block11;
                    }
                    case 3: {
                        sb.append(name + " decimal(28,10),");
                        continue block11;
                    }
                }
            }
            sb.replace(sb.length() - 1, sb.length(), ")");
            rsmd = null;
        }
        catch (SQLException exp) {
            throw new SQLDataException(exp);
        }
        return sb.toString();
    }

    protected IRowSet getResultSet(String tableName) throws EASBizException, SQLDataException {
        JdbcRowSet result = null;
        String sql = "select * from " + tableName;
        PreparedStatement stat = null;
        ResultSet rs = null;
        Connection conn = this.getConnection(this.ctx);
        try {
            stat = conn.prepareStatement(sql);
            rs = stat.executeQuery();
            result = new JdbcRowSet();
            result.populate(rs);
        }
        catch (SQLException e1) {
            try {
                throw new SQLDataException(e1);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)stat);
                SQLUtils.cleanup((Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stat);
        SQLUtils.cleanup((Connection)conn);
        return result;
    }

    protected String storeDB(String tableName, PreparedStatement stat) {
        return null;
    }

    protected Connection getConnection(Context ctx) throws SQLDataException {
        try {
            return EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException sqle) {
            throw new SQLDataException(sqle);
        }
    }

    public int getPeriodSerial(BOSUuid id) throws BOSException, EASBizException {
        ResultSet rs;
        PreparedStatement stmt;
        Connection conn;
        block4: {
            int n;
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT FPeriodYear*100 + FPeriodNumber FROM T_BD_Period WHERE FID = ? ");
            conn = null;
            stmt = null;
            rs = null;
            try {
                conn = this.getConnection(this.ctx);
                stmt = conn.prepareStatement(sql.toString());
                stmt.setString(1, id.toString());
                rs = stmt.executeQuery();
                if (!rs.next()) break block4;
                n = rs.getInt(1);
            }
            catch (SQLException exp) {
                try {
                    throw new SQLDataException(exp);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, stmt, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
            return n;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return -1;
    }

    public List getPeriodIDList(int beginYear, int beginNumber, int endYear, int endNumber, String typeIDs) throws EASBizException, BOSException {
        String sql = " SELECT FID, FTypeID FROM T_BD_Period WHERE (FPeriodYear * 100 + FPeriodNumber BETWEEN ? AND ?) AND (FTypeID IN (?))";
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<String> list = null;
        Connection conn = this.getConnection(this.ctx);
        try {
            stmt = conn.prepareStatement(sql);
            int number = 1;
            stmt.setInt(number++, beginYear * 100 + beginNumber);
            stmt.setInt(number++, endYear * 100 + endNumber);
            stmt.setString(number++, typeIDs);
            rs = stmt.executeQuery();
            list = new ArrayList<String>();
            while (rs.next()) {
                list.add(rs.getString(1));
            }
        }
        catch (SQLException ex) {
            try {
                throw new SQLDataException(ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)stmt);
                SQLUtils.cleanup((Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
        SQLUtils.cleanup((Connection)conn);
        return list;
    }

    public PeriodInfo getPeriodInfo(java.util.Date date, BOSUuid companyId) throws BOSException, EASBizException {
        String sql = "SELECT P.FID, P.FTypeID, P.FPeriodYear, P.FPeriodQuarter, P.FPeriodNumber, P.FBeginDate, P.FEndDate FROM T_BD_Period P INNER JOIN  T_BD_PeriodType PT ON P.FTypeID = PT.FID INNER JOIN  T_ORG_Company C ON PT.FID = C.FAccountPeriodID WHERE   (? BETWEEN P.FBeginDate AND P.FEndDate)  AND (C.FID = ?)";
        Connection conn = null;
        PreparedStatement stmt = null;
        PeriodInfo info = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection(this.ctx);
            stmt = conn.prepareStatement(sql);
            stmt.setDate(1, new Date(date.getTime()));
            stmt.setString(2, companyId.toString());
            rs = stmt.executeQuery();
            if (rs.next()) {
                info = new PeriodInfo();
                info.setId(BOSUuid.read((String)rs.getString("FID")));
                info.setPeriodNumber(rs.getInt("FPeriodNumber"));
                info.setPeriodYear(rs.getInt("FPeriodYear"));
                info.setPeriodQuarter(rs.getInt("FPeriodQuarter"));
                info.setPeriodType(new PeriodTypeInfo());
                info.getPeriodType().setId(BOSUuid.read((String)rs.getString("FTypeID")));
            }
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return info;
    }
}

