/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.rpt.app.dao;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.BOSTempTableUtil;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.books.AcountSchemeInfo;
import com.kingdee.eas.fi.fa.def.DefSumOptionProvider;
import com.kingdee.eas.fi.fa.def.DefSumSQLOptionProviderImpl;
import com.kingdee.eas.fi.fa.def.app.common.FaDaoDefPart;
import com.kingdee.eas.fi.fa.manage.app.FaLocalUtils;
import com.kingdee.eas.fi.fa.rpt.FaCreateTempTableResult;
import com.kingdee.eas.fi.fa.rpt.FaDBUtil;
import com.kingdee.eas.fi.fa.rpt.FaDBUtilConfig;
import com.kingdee.eas.fi.fa.rpt.FaDaoSqlObject;
import com.kingdee.eas.fi.fa.rpt.FaSumLevelEnum;
import com.kingdee.eas.fi.fa.rpt.FaSumOptnObject;
import com.kingdee.eas.fi.fa.rpt.LevelSumAsstActItem;
import com.kingdee.eas.fi.fa.rpt.LevelSumCompany;
import com.kingdee.eas.fi.fa.rpt.LevelSumMeasureUnit;
import com.kingdee.eas.fi.fa.rpt.LevelSumNonTree;
import com.kingdee.eas.fi.fa.rpt.LevelSumOption;
import com.kingdee.eas.fi.fa.rpt.LevelSumSqlInfo;
import com.kingdee.eas.fi.fa.rpt.LevelSumStoreCity;
import com.kingdee.eas.fi.fa.rpt.LevelSumUseDepartMent;
import com.kingdee.eas.fi.fa.rpt.SumGroupInfo;
import com.kingdee.eas.fi.fa.rpt.app.FaRptLocalUtils;
import com.kingdee.eas.fi.fa.rpt.app.dao.FaComposingDao;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import org.apache.log4j.Logger;

public abstract class FaDaoBase {
    private static final Logger logger = Logger.getLogger(FaDaoBase.class);
    protected static final String RES_PATH = "com.kingdee.eas.fi.fa.rpt.FaRptResource";
    protected Map result = new HashMap();
    protected FaDaoSqlObject daoSql = new FaDaoSqlObject();
    protected FaDaoSqlObject resultSql = new FaDaoSqlObject();
    protected HashMap sumItemJoinSqlMap = new HashMap();
    protected boolean isCurrPeriod = false;
    protected boolean isInitPeriod = false;
    protected SqlParams params = new SqlParams();
    protected String fName;
    protected String fDisplayName;
    protected Context ctx;
    protected CompanyOrgUnitInfo currCompanyInfo;
    protected PeriodInfo currPeriod;
    protected String strCompanyInclude;
    protected SqlParams includeCompays;
    protected int startYear;
    protected int startNumber;
    protected int endYear;
    protected int endNumber;
    protected String filter;
    protected String tempTable;
    protected String scTempTable;
    protected LevelSumOption sumOption;
    protected String subTotal;
    protected String sorter;
    protected FaDBUtilConfig cf;
    protected String acctAsstTableName;
    protected boolean isHasAsstActSum = false;
    protected boolean isVirCompany = false;
    protected HashMap hmParam;
    protected boolean isUseDepartDisLName = false;
    protected ArrayList sumItemList;
    protected FaDaoDefPart def = null;
    protected List tempTableList = new ArrayList();

    public void init(Context ctx, EntityViewInfo ev) throws EASBizException, BOSException {
        this.def = new FaDaoDefPart(ev, ctx);
        this.ctx = ctx;
        FaRptLocalUtils.chgNumberKeyWord(ev);
        this.isHasAsstActSum = this.isHasAsstActSum(ev);
        this.fName = "FName_" + ctx.getLocale().toString();
        this.fDisplayName = "FDisplayName_" + ctx.getLocale().toString();
        this.currCompanyInfo = this.getRptCompany(ctx, ev);
        this.isVirCompany = !this.currCompanyInfo.isIsBizUnit();
        this.subTotal = ResourceBase.getString((String)RES_PATH, (String)"subTotal", (Locale)ctx.getOriginLocale());
        this.setProperCurPeriod(ctx);
        this.initEvVar(ev);
        if (this.isCreateTempTable()) {
            this.tempTable = this.getProperTempTable(ctx);
        }
        if (this.isCreateAcctAsstTable(ev)) {
            this.acctAsstTableName = this.getAsstActItemTable(ctx);
        }
        Map cond = (Map)ev.get("customcond");
        if (this.isVirCompany || cond.get("sumOption") != null) {
            this.sumItemList = (ArrayList)cond.get("sumOption");
            List levelSqlList = this.buildLevelSumSqlList(this.sumItemList);
            this.sumOption = new LevelSumOption(ctx, this.currCompanyInfo, levelSqlList, ev);
        }
        this.filter = this.buildFilterSql(ev);
        this.sorter = this.buildSorterSql(ev);
        if (this.isCreateTempTable()) {
            this.sorter = this.sorter == null || this.sorter.equals("") ? "FID" : this.sorter + ",FID";
        }
    }

    protected void setProperCurPeriod(Context ctx) throws BOSException, EASBizException {
        this.currPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)this.currCompanyInfo);
    }

    protected List buildLevelSumSqlList(List sumOption) throws BOSException {
        ArrayList<LevelSumSqlInfo> levelSumSqlList = new ArrayList<LevelSumSqlInfo>();
        if (sumOption != null) {
            int n = sumOption.size();
            for (int i = 0; i < n; ++i) {
                int j;
                String key;
                FaSumOptnObject fsoo = (FaSumOptnObject)sumOption.get(i);
                if (!fsoo.isSum() || (key = fsoo.getFieldName()) == null) continue;
                if (key.equals("asstActItem")) {
                    levelSumSqlList.add(this.getLevelSumSqlInfo(this.ctx, "asstActType", 0, fsoo.isNode()));
                }
                if (fsoo.getLevelType() == FaSumLevelEnum.detail) {
                    if ("useDepartment".equals(key)) {
                        this.isUseDepartisLName();
                    }
                    levelSumSqlList.add(this.getLevelSumSqlInfo(this.ctx, key, 0, fsoo.isNode()));
                    continue;
                }
                int maxLevel = this.getSumItemMaxLevel(key);
                int n2 = j = fsoo.isNode() && this instanceof FaComposingDao ? 0 : 1;
                if (maxLevel < j) {
                    maxLevel = j;
                }
                this.buildSumItemSql(j, maxLevel, key);
                if (fsoo.getLevelType() == FaSumLevelEnum.specified && fsoo.getLevel() < maxLevel) {
                    maxLevel = fsoo.getLevel();
                }
                while (j <= maxLevel) {
                    levelSumSqlList.add(this.getLevelSumSqlInfo(this.ctx, key, j, fsoo.isNode()));
                    ++j;
                }
            }
        }
        if (this.isVirCompany) {
            int maxLevel = this.getSumItemMaxLevel("orgArchitecture");
            int minLevel = this.currCompanyInfo.getLevel();
            this.buildSumItemSql(minLevel, maxLevel, "orgArchitecture");
            for (int j = minLevel; j <= maxLevel; ++j) {
                levelSumSqlList.add(this.getLevelSumSqlInfo(this.ctx, "orgArchitecture", j, true));
            }
        }
        return levelSumSqlList;
    }

    protected void isUseDepartisLName() {
        this.isUseDepartDisLName = this.hmParam != null && this.hmParam.get("FA_025") != null && "true".equals(this.hmParam.get("FA_025"));
    }

    protected CompanyOrgUnitInfo getRptCompany(Context ctx, EntityViewInfo ev) throws EASBizException, BOSException {
        Map cond = (Map)ev.get("customcond");
        if (cond == null) {
            return ContextUtil.getCurrentFIUnit((Context)ctx);
        }
        Object companys = cond.get("company");
        if (companys != null && companys instanceof CompanyOrgUnitInfo[]) {
            CompanyOrgUnitInfo[] companyArray = (CompanyOrgUnitInfo[])companys;
            if (companyArray.length == 1) {
                return companyArray[0];
            }
            for (int i = 0; i < companyArray.length; ++i) {
                if (companyArray[i].isIsBizUnit()) continue;
                return companyArray[i];
            }
            return ContextUtil.getCurrentFIUnit((Context)ctx);
        }
        return ContextUtil.getCurrentFIUnit((Context)ctx);
    }

    protected String getProperTempTable(Context ctx) throws BOSException {
        return "FaTempTable";
    }

    public Map getResult() throws BOSException {
        this.buildSql();
        this.buildData();
        this.resultSql.setFrom(this.tempTable);
        this.resultSql.setSecondTable(this.scTempTable);
        List returnColumn = new ArrayList();
        if (this.isVirCompany) {
            this.removeField();
        }
        if (this.sumOption != null && this.sumOption.getSumInfoList().size() > 0) {
            returnColumn = this.removeNullColumn();
            this.updateNullToBlank();
        }
        this.dropTable(this.acctAsstTableName);
        this.acctAsstTableName = null;
        this.result.put("sumOption", this.sumOption);
        this.result.put("resultSql", this.resultSql);
        this.result.put("tempTableName", this.tempTable);
        this.result.put("sumColumnName", returnColumn);
        this.result.put("pc", this.def.getPc());
        this.clearInnerTempTable();
        return this.result;
    }

    protected void dropTable(String tempTableName) throws BOSException {
        if (this.acctAsstTableName != null) {
            try {
                TempTablePool.getInstance((Context)this.ctx).releaseTable(tempTableName);
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    protected void initEvVar(EntityViewInfo ev) throws EASBizException, BOSException {
        FaRptLocalUtils.chgNumberKeyWord(ev);
        Map cond = (Map)ev.get("customcond");
        if (cond.get("initperiod") != null && ((Boolean)cond.get("initperiod")).booleanValue()) {
            this.isCurrPeriod = false;
            this.isInitPeriod = true;
        } else {
            if (cond.get("endYear") == null || cond.get("endNumber") == null) {
                if (cond.get("year") != null && cond.get("month") != null) {
                    this.endYear = this.startYear = ((Integer)cond.get("year")).intValue();
                    this.endNumber = this.startNumber = ((Integer)cond.get("month")).intValue();
                }
            } else {
                this.startYear = (Integer)cond.get("startYear");
                this.startNumber = (Integer)cond.get("startNumber");
                this.endYear = (Integer)cond.get("endYear");
                this.endNumber = (Integer)cond.get("endNumber");
            }
            if (!this.isVirCompany) {
                this.isCurrPeriod = this.endYear == this.startYear && this.endNumber == this.startNumber && this.currPeriod.getPeriodYear() == this.startYear && this.currPeriod.getPeriodNumber() == this.startNumber;
            }
        }
        Object companys = cond.get("company");
        if (companys != null && companys instanceof DefaultMutableTreeNode) {
            IRowSet set;
            String sql;
            StringBuffer companyCond = new StringBuffer();
            StringBuffer mainCompanyID = new StringBuffer();
            StringBuffer useCompanyID = new StringBuffer();
            this.tree((DefaultMutableTreeNode)companys, companyCond);
            if (cond.get("bookScheme") != null) {
                String companyIds = companyCond.substring(0, companyCond.lastIndexOf(","));
                AcountSchemeInfo schemeInfo = (AcountSchemeInfo)cond.get("bookScheme");
                if (schemeInfo.getId() != null) {
                    sql = " select com.fid ,com.FMainOrgID from t_Org_Company com\t\t  inner join T_BKS_AcountScheme sche on sche.fid=com.faccountschemeid \twhere sche.fid=?  and   sche.FIsMaster=0 and com.FMainOrgID in (" + companyIds + ") ";
                    set = DbUtil.executeQuery((Context)this.ctx, (String)sql, (Object[])new Object[]{schemeInfo.getId().toString()});
                    try {
                        while (set != null && set.next()) {
                            companyCond.append("'" + set.getString("fid") + "',");
                            mainCompanyID.append("'" + set.getString("FMainOrgID") + "',");
                        }
                    }
                    catch (SQLException e) {
                        logger.error((Object)e);
                        throw new BOSException((Throwable)e);
                    }
                }
            }
            String mainIds = null;
            if (mainCompanyID.length() > 0) {
                mainIds = mainCompanyID.substring(0, mainCompanyID.lastIndexOf(","));
            }
            String companyIds = companyCond.substring(0, companyCond.lastIndexOf(","));
            sql = null;
            sql = mainIds != null ? "select fid  from t_Org_Company where fid in (" + companyIds + ") and fid not in (" + mainIds + ")" : "select fid  from t_Org_Company where fid in (" + companyIds + ") ";
            set = DbUtil.executeQuery((Context)this.ctx, (String)sql);
            try {
                while (set != null && set.next()) {
                    useCompanyID.append("'" + set.getString("fid") + "',");
                }
            }
            catch (SQLException e) {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            companyIds = useCompanyID.substring(0, useCompanyID.lastIndexOf(","));
            this.strCompanyInclude = this.getCompanysInPeriod(companyIds, this.startYear, this.startNumber, this.endYear, this.endNumber);
        } else if (companys != null && companys instanceof CompanyOrgUnitInfo[]) {
            CompanyOrgUnitInfo[] companyArray = (CompanyOrgUnitInfo[])companys;
            if (((CompanyOrgUnitInfo[])companys).length > 1) {
                this.setCompanyIncludeFilter(cond, companyArray);
            } else {
                this.strCompanyInclude = "'" + companyArray[0].getId().toString() + "'";
                if (this.strCompanyInclude == null) {
                    this.strCompanyInclude = "'" + this.currCompanyInfo.getId().toString() + "'";
                }
            }
        } else {
            this.strCompanyInclude = "'" + this.currCompanyInfo.getId().toString() + "'";
        }
        this.cf = new FaDBUtilConfig();
        this.tableFieldConfig(this.cf);
    }

    private void setCompanyIncludeFilter(Map cond, CompanyOrgUnitInfo[] companyArray) throws BOSException {
        IRowSet set;
        String sql;
        StringBuffer companyCond = new StringBuffer();
        StringBuffer mainCompanyID = new StringBuffer();
        StringBuffer useCompanyID = new StringBuffer();
        for (int i = 0; i < companyArray.length; ++i) {
            companyCond.append("'");
            companyCond.append(companyArray[i].getId().toString());
            companyCond.append("', ");
        }
        if (cond.get("bookScheme") != null) {
            String companyIds = companyCond.substring(0, companyCond.lastIndexOf(","));
            AcountSchemeInfo schemeInfo = (AcountSchemeInfo)cond.get("bookScheme");
            if (schemeInfo.getId() != null) {
                sql = " select com.fid ,com.FMainOrgID from t_Org_Company com\t\t  inner join T_BKS_AcountScheme sche on sche.fid=com.faccountschemeid \twhere sche.fid=?  and   sche.FIsMaster=0 and com.FMainOrgID in (" + companyIds + ") ";
                set = DbUtil.executeQuery((Context)this.ctx, (String)sql, (Object[])new Object[]{schemeInfo.getId().toString()});
                try {
                    while (set != null && set.next()) {
                        companyCond.append("'" + set.getString("fid") + "',");
                        mainCompanyID.append("'" + set.getString("FMainOrgID") + "',");
                    }
                }
                catch (SQLException e) {
                    logger.error((Object)e);
                    throw new BOSException((Throwable)e);
                }
            }
        }
        String mainIds = null;
        if (mainCompanyID.length() > 0) {
            mainIds = mainCompanyID.substring(0, mainCompanyID.lastIndexOf(","));
        }
        String companyIds = companyCond.substring(0, companyCond.lastIndexOf(","));
        sql = null;
        sql = mainIds != null ? "select fid  from t_Org_Company where fid in (" + companyIds + ") and fid not in (" + mainIds + ")" : "select fid  from t_Org_Company where fid in (" + companyIds + ") ";
        set = DbUtil.executeQuery((Context)this.ctx, (String)sql);
        try {
            while (set != null && set.next()) {
                useCompanyID.append("'" + set.getString("fid") + "',");
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        companyIds = useCompanyID.substring(0, useCompanyID.lastIndexOf(","));
        this.strCompanyInclude = this.getCompanysInPeriod(companyIds, this.startYear, this.startNumber, this.endYear, this.endNumber);
    }

    protected void tableFieldConfig(FaDBUtilConfig cf) {
    }

    protected String buildSorterSql(EntityViewInfo ev) {
        StringBuffer sorterSql = new StringBuffer();
        if (this.sumOption != null) {
            if (this.sumOption.isHasSum()) {
                sorterSql.append(this.sumOption.getOrderFields().toString()).append(", ");
            }
            if (this.isVirCompany) {
                sorterSql.append(" SumLevel , ").append(" isSum DESC");
            } else {
                sorterSql.append(" isSum");
            }
        }
        if (ev.getSorter().toString() != null && ev.getSorter().toString().length() > 0) {
            if (sorterSql.length() > 0) {
                sorterSql.append(",");
            }
            sorterSql.append(this.modifyDefSorterPartSql(ev.getSorter().toString()));
        }
        return sorterSql.toString();
    }

    protected String modifyDefSorterPartSql(String sorterSqlPart) {
        sorterSqlPart = this.isCreateTempTable() ? this.def.property2FieldAtFilterByWrapped(sorterSqlPart) : this.def.property2FieldAtFilter(sorterSqlPart);
        return sorterSqlPart;
    }

    protected String buildFilterSql(EntityViewInfo ev) {
        FilterInfo filterInfo = ev.getFilter();
        if (filterInfo == null || filterInfo.getFilterItems() == null || filterInfo.getFilterItems().isEmpty()) {
            return null;
        }
        FilterItemCollection filterColl = filterInfo.getFilterItems();
        for (int i = 0; i < filterColl.size(); ++i) {
            FilterItemInfo filter = filterColl.get(i);
            this.def.dealWithFilter(filter);
        }
        String f = ev.getFilter().toString();
        return this.modifyDefFilterSql(f);
    }

    protected String modifyDefFilterSql(String f) {
        return this.def.property2FieldAtFilter(f);
    }

    protected abstract void buildSql() throws BOSException;

    protected void buildData() throws BOSException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String addDataTempTable(String sql) throws BOSException {
        sql = "select * into " + this.tempTable + " from (" + sql + ") as tempTable ";
        Connection con = null;
        try {
            con = EJBFactory.getConnection((Context)this.ctx);
            FaCreateTempTableResult result = FaDBUtil.executeSelectInto(this.ctx, FaLocalUtils.transformLocal((Context)this.ctx, (String)sql), this.params, con, this.cf);
            this.tempTable = result.getTempTable();
        }
        catch (Exception exc) {
            try {
                throw new BOSException("Sql execute exception : " + this.params.getSqlWithParams(sql), (Throwable)exc);
            }
            catch (SQLException e) {
                logger.error((Object)e);
            }
        }
        finally {
            SQLUtils.cleanup((Connection)con);
        }
        return this.tempTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String addDataInnerTempTable(String sql) throws BOSException {
        String tableName = BOSTempTableUtil.getTableManagerNew((Context)this.ctx).getTableName("FI_FA");
        sql = "select * into " + tableName + " from (" + sql + ") as tempTable ";
        Connection con = null;
        try {
            con = EJBFactory.getConnection((Context)this.ctx);
            FaCreateTempTableResult result = FaDBUtil.executeSelectInto(this.ctx, FaLocalUtils.transformLocal((Context)this.ctx, (String)sql), this.params, con, this.cf);
            tableName = result.getTempTable();
            this.tempTableList.add(tableName);
        }
        catch (Exception exc) {
            try {
                throw new BOSException("Sql execute exception : " + this.params.getSqlWithParams(sql), (Throwable)exc);
            }
            catch (SQLException e) {
                logger.error((Object)e);
            }
        }
        finally {
            SQLUtils.cleanup((Connection)con);
        }
        return tableName;
    }

    protected void clearInnerTempTable() throws BOSException {
        for (int i = 0; i < this.tempTableList.size(); ++i) {
            String tableName = (String)this.tempTableList.get(i);
            BOSTempTableUtil.getTableManagerNew((Context)this.ctx).releaseTable(tableName);
        }
    }

    protected List removeNullColumn() throws BOSException {
        List columns = this.sumOption.getSumColNameList();
        for (int i = columns.size() - 1; i >= 0; --i) {
            SumGroupInfo group = (SumGroupInfo)columns.get(i);
            if (!this.isNullColumn(group.getNumber())) continue;
            group.setVisualable(false);
        }
        return columns;
    }

    protected void updateToNull() throws BOSException {
        if (this.sumOption == null) {
            return;
        }
        List sumGroup = this.sumOption.getSumInfoList();
        String cuID = ContextUtil.getCurrentCtrlUnit((Context)this.ctx).getId().toString();
        Connection conA = null;
        Statement stA = null;
        StringBuffer msg = new StringBuffer();
        try {
            conA = EJBFactory.getConnection((Context)this.ctx);
            stA = conA.createStatement();
            int size = sumGroup.size();
            for (int i = 0; i < size; ++i) {
                LevelSumSqlInfo sumSqlInfo = (LevelSumSqlInfo)sumGroup.get(i);
                if (sumSqlInfo instanceof LevelSumCompany || sumSqlInfo instanceof LevelSumAsstActItem || sumSqlInfo.getLevel() == 0) continue;
                StringBuffer sql = new StringBuffer();
                sql.append("UPDATE ");
                sql.append(this.tempTable);
                sql.append(" SET ");
                sql.append(sumSqlInfo.getNameField());
                sql.append("=NULL,");
                sql.append(sumSqlInfo.getLongNumberField());
                sql.append("=NULL");
                sql.append(" WHERE ");
                sql.append(sumSqlInfo.getLongNumberField());
                sql.append(" NOT IN (SELECT FLongNumber FROM ");
                sql.append(sumSqlInfo.getTableName());
                sql.append(" WHERE fcontrolunitid = '");
                sql.append(cuID);
                sql.append("')");
                stA.addBatch(sql.toString());
                msg.append(sql + "\n");
            }
            stA.executeBatch();
        }
        catch (SQLException exc) {
            try {
                throw new BOSException("Sql execute exception : " + msg.toString(), (Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stA, (Connection)conA);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stA, (Connection)conA);
    }

    protected void updateNullToBlank() throws BOSException {
        List sumGroup = this.sumOption.getSumInfoList();
        Connection conA = null;
        Statement stA = null;
        Connection conB = null;
        Statement stB = null;
        StringBuffer msg = new StringBuffer();
        try {
            conA = EJBFactory.getConnection((Context)this.ctx);
            stA = conA.createStatement();
            conB = EJBFactory.getConnection((Context)this.ctx);
            stB = conB.createStatement();
            int size = sumGroup.size();
            for (int i = 0; i < size; ++i) {
                String delRecored;
                LevelSumSqlInfo sumSqlInfo = (LevelSumSqlInfo)sumGroup.get(i);
                StringBuffer sql = new StringBuffer();
                sql.append("UPDATE ");
                sql.append(this.tempTable);
                sql.append(" SET ");
                sql.append(sumSqlInfo.getLongNumberField());
                if (sumSqlInfo.getLongNumberField().equals("changeDateNumber")) {
                    sql.append(" = TO_DATE('1990-01-01 00:00:00') ");
                } else {
                    sql.append(" = '.'");
                }
                sql.append(" WHERE ");
                sql.append(sumSqlInfo.getLongNumberField());
                sql.append(" IS NULL");
                stA.addBatch(sql.toString());
                msg.append(sql + "\n");
                if (sumSqlInfo.isEnable()) continue;
                String string = delRecored = i + 1 == size ? this.getFirstDisplayField() : ((LevelSumSqlInfo)sumGroup.get(i + 1)).getLongNumberField();
                if (this.getFirstDisplayField() == null) continue;
                String mask = i + 1 == size ? this.subTotal : LevelSumOption.MAXCODE;
                sql = new StringBuffer();
                sql.append("DELETE FROM ");
                sql.append(this.tempTable);
                sql.append(" WHERE ");
                sql.append(delRecored);
                sql.append(" = '").append(mask).append("'");
                stB.addBatch(sql.toString());
                msg.append(sql + "\n");
            }
            stA.executeBatch();
            stB.executeBatch();
        }
        catch (SQLException exc) {
            try {
                throw new BOSException("Sql execute exception : " + msg.toString(), (Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stA, (Connection)conA);
                SQLUtils.cleanup(stB, conB);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stA, (Connection)conA);
        SQLUtils.cleanup((Statement)stB, (Connection)conB);
    }

    protected boolean isNullColumn(String column) throws BOSException {
        StringBuffer sql = new StringBuffer("select Top 1 fid from ");
        sql.append(this.tempTable);
        sql.append(" where ");
        sql.append("TO_CHAR(").append(column).append(") != '").append(this.subTotal).append("' AND ");
        sql.append(column).append(" IS NOT NULL ");
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
        try {
            if (!rs.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            throw new BOSException("Sql execute exception : " + sql, (Throwable)e);
        }
        return false;
    }

    protected String getCompanysInPeriod(String selectedIds, int startYear, int startNumber, int endYear, int endNumber) throws BOSException {
        int startPeriod = startYear * 100 + startNumber;
        int endPeriod = endYear * 100 + endNumber;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT company.FID AS COMPANYID FROM T_BD_SystemStatusCtrol ssc");
        sql.append(" INNER JOIN T_BD_Period currPeriod ON ssc.FCurrentPeriodID = currPeriod.FID");
        sql.append(" INNER JOIN T_BD_Period startPeriod ON ssc.FStartPeriodID = startPeriod.FID");
        sql.append(" INNER JOIN T_ORG_Company company ON ssc.FCompanyID = company.FID");
        sql.append(" INNER JOIN T_BD_SystemStatus ss ON ss.FID = ssc.FSystemStatusID");
        sql.append(" WHERE ss.FName = ").append(14);
        if (!this.isInitPeriod) {
            sql.append(" AND currPeriod.Fnumber >= ").append(startPeriod);
            sql.append(" AND startPeriod.Fnumber <= ").append(endPeriod);
        }
        sql.append(" AND company.FID IN (").append(selectedIds).append(")");
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
        StringBuffer companyIds = new StringBuffer();
        try {
            while (rs.next()) {
                companyIds.append(",").append("'").append(rs.getString("COMPANYID")).append("'");
            }
        }
        catch (SQLException e) {
            throw new BOSException("Sql execute exception : " + sql, (Throwable)e);
        }
        if (companyIds.length() == 0) {
            return "''";
        }
        return companyIds.substring(1);
    }

    private void removeField() throws BOSException {
        LevelSumSqlInfo invalidField = null;
        LevelSumSqlInfo enableField = null;
        List sumList = this.sumOption.getSumInfoList();
        Connection conA = null;
        Statement stA = null;
        StringBuffer msg = new StringBuffer();
        try {
            conA = EJBFactory.getConnection((Context)this.ctx);
            stA = conA.createStatement();
            for (int i = 0; i < sumList.size(); ++i) {
                LevelSumSqlInfo sumInfo = (LevelSumSqlInfo)sumList.get(i);
                if (invalidField == null && !sumInfo.isEnable()) {
                    invalidField = sumInfo;
                }
                if (invalidField != null && sumInfo.isEnable()) {
                    enableField = sumInfo;
                }
                if (invalidField == null || enableField == null) continue;
                StringBuffer sql = new StringBuffer();
                sql.append("UPDATE ").append(this.tempTable);
                sql.append(" SET ").append(enableField.getLongNumberField()).append(" = ").append(invalidField.getLongNumberField());
                sql.append(",").append(enableField.getNameField()).append(" = ").append(invalidField.getNameField());
                sql.append(" WHERE ISSUM = 1 AND ").append(invalidField.getNameField()).append("='").append(this.subTotal).append("'");
                stA.addBatch(sql.toString());
                msg.append(sql.toString() + "\n");
                invalidField = null;
                enableField = null;
            }
            stA.executeBatch();
        }
        catch (SQLException exc) {
            try {
                throw new BOSException("Sql execute exception : " + msg.toString(), (Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stA, (Connection)conA);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stA, (Connection)conA);
    }

    protected boolean isQueryCurrPeriod() {
        return this.currPeriod.getPeriodYear() == this.endYear && this.currPeriod.getPeriodNumber() == this.endNumber;
    }

    protected boolean isQueryMonPeriod() {
        return this.currPeriod.getPeriodYear() != this.startYear || this.currPeriod.getPeriodNumber() != this.startNumber;
    }

    protected void dropTempTable() throws BOSException {
        try {
            TempTablePool.getInstance((Context)this.ctx).releaseTable(this.tempTable);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected final IRowSet getData(String sql) throws BOSException {
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql);
        return rs;
    }

    private void tree(DefaultMutableTreeNode treeNode, StringBuffer sb) {
        String companyId = ((CompanyOrgUnitInfo)treeNode.getUserObject()).getId().toString();
        sb.append("'");
        sb.append(companyId);
        sb.append("', ");
        if (!treeNode.isLeaf()) {
            for (int i = 0; i < treeNode.getChildCount(); ++i) {
                this.tree((DefaultMutableTreeNode)treeNode.getChildAt(i), sb);
            }
        }
    }

    protected boolean isCreateTempTable() {
        return true;
    }

    protected boolean isCreateAcctAsstTable(EntityViewInfo ev) {
        boolean isHasAsstActFilter = false;
        if (ev != null && ev.getFilter() != null) {
            String filter = ev.getFilter().toString();
            isHasAsstActFilter = filter.indexOf("asstActItem.fname_l2") != -1 || filter.indexOf("asstActType.fnumber") != -1 || filter.indexOf("asstActType.number") != -1;
        }
        return isHasAsstActFilter || this.isHasAsstActSum;
    }

    protected boolean isHasAsstActSum(EntityViewInfo ev) {
        boolean isHasAsstActSum = false;
        Map cond = (Map)ev.get("customcond");
        List sumItems = (List)cond.get("sumOption");
        if (sumItems != null) {
            for (int i = 0; i < sumItems.size(); ++i) {
                FaSumOptnObject fsoo = (FaSumOptnObject)sumItems.get(i);
                if (!"asstActItem".equals(fsoo.getFieldName()) || !fsoo.isSum()) continue;
                isHasAsstActSum = true;
                break;
            }
        }
        return isHasAsstActSum;
    }

    protected String getFirstDisplayField() {
        return null;
    }

    protected String getAsstActItemTable(Context ctx) throws BOSException {
        FaCreateTempTableResult result;
        String tableName = "faTempTabel";
        String assist = this.getAsstActItemSQLFrmAsstType(ctx);
        StringBuffer cardSql = this.getUsedAsstActItemSql();
        StringBuffer sql = new StringBuffer();
        sql.append("select distinct assist.* from (").append(cardSql.toString()).append(") as cost");
        sql.append(" inner join (").append(assist).append(") as assist on assist.FAsstacttypeID = cost.fasstacttypeid and assist.FID = cost.fasstactitem");
        if (this.isHasAsstActSum) {
            sql.append(" union  ");
            sql.append(assist).append(" where a.fisleaf = 0");
        }
        Connection con = null;
        try {
            String tmpSql = "select * into " + tableName + " from (" + sql.toString() + ") as tmpTable";
            con = EJBFactory.getConnection((Context)ctx);
            result = FaDBUtil.executeSelectInto(ctx, tmpSql, this.includeCompays, con, this.cf);
            tableName = result.getTempTable();
            TempTablePool.getInstance((Context)ctx).createIndex(tableName, "fid,fparentid", false, false);
        }
        catch (Exception ex) {
            try {
                throw new BOSException("error sql:" + sql.toString(), (Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Connection)con);
        return result.getTempTable();
    }

    protected String getSumItemJoinSql(String key) {
        return (String)this.sumItemJoinSqlMap.get(key);
    }

    protected StringBuffer getUsedAsstActItemSql() {
        StringBuffer cardSql = new StringBuffer();
        StringBuffer monCardSql = new StringBuffer();
        StringBuffer currCardSql = new StringBuffer();
        if (this.isVirCompany || this.startYear * 100 + this.startNumber < this.currPeriod.getPeriodYear() * 100 + this.currPeriod.getPeriodNumber()) {
            monCardSql.append(" select mc.fcompanyid as fcompanyid,cost.fid as fid,composit.FAsstActType AS FASSTACTTYPEID,composit.FAsstActItem ");
            monCardSql.append(" from t_fa_famoncard mc");
            monCardSql.append(" inner join t_fa_famoncostcenter cost on cost.ffamoncardid = mc.fid");
            monCardSql.append(" inner join T_FA_FamonAsstActComposit composit on composit.FFamonCostCenterID = cost.fid");
            if (this.startYear == 0 && this.startNumber == 0) {
                monCardSql.append(" where mc.fperiodid is null ");
            } else {
                monCardSql.append(" inner join t_bd_period p on p.fid = mc.ffaperiodid");
                monCardSql.append(" where mc.fcompanyid in (").append(this.strCompanyInclude).append(") ");
                monCardSql.append(" and p.FNumber >=").append(this.startYear * 100 + this.startNumber);
                monCardSql.append(" and p.FNumber <=").append(this.endYear * 100 + this.endNumber);
            }
            monCardSql.append(" union ");
            monCardSql.append(" select bc.fcompanyid as fcompanyid,cost.fid as fid,composit.FAsstActType AS FASSTACTTYPEID,composit.FAsstActItem ");
            monCardSql.append(" from t_fa_fabakcard bc");
            monCardSql.append(" inner join t_fa_fabakcostcenter cost on cost.FFaBakCardID = bc.fid");
            monCardSql.append(" inner join T_FA_FabakAsstActComposit composit on composit.FFabakCostCenterID = cost.fid");
            monCardSql.append(" where bc.fcompanyid in (" + this.strCompanyInclude + ") ");
            if (this.startYear == 0 && this.startNumber == 0) {
                monCardSql.append(" and bc.fperiodid is null ");
            }
        }
        if (this.isVirCompany || this.endYear == this.currPeriod.getPeriodYear() && this.endNumber == this.currPeriod.getPeriodNumber()) {
            currCardSql.append(" select c.fcompanyid as fcompanyid,cost.fid as fid,composit.FAsstActType AS FASSTACTTYPEID,composit.FAsstActItem ");
            currCardSql.append(" from t_fa_facurcard c");
            currCardSql.append(" inner join t_fa_facurcostcenter cost on cost.ffacurcardid = c.fid");
            currCardSql.append(" inner join T_FA_FacurAsstActComposit composit on composit.FFacurCostCenterID = cost.fid");
            currCardSql.append(" where c.fcompanyid in (" + this.strCompanyInclude + ") ");
            currCardSql.append(" union ");
            currCardSql.append(" select bc.fcompanyid as fcompanyid,cost.fid as fid,composit.FAsstActType AS FASSTACTTYPEID,composit.FAsstActItem ");
            currCardSql.append(" from t_fa_fabakcard bc");
            currCardSql.append(" inner join t_fa_fabakcostcenter cost on cost.FFaBakCardID = bc.fid");
            currCardSql.append(" inner join T_FA_FabakAsstActComposit composit on composit.FFabakCostCenterID = cost.fid");
            currCardSql.append(" where bc.fcompanyid in (" + this.strCompanyInclude + ") ");
        }
        if (!this.isVirCompany && this.startYear * 100 + this.startNumber > this.currPeriod.getPeriodYear() * 100 + this.currPeriod.getPeriodNumber()) {
            currCardSql.append(" select c.fcompanyid as fcompanyid,cost.fid as fid,composit.FAsstActType AS FASSTACTTYPEID,composit.FAsstActItem ");
            currCardSql.append(" from t_fa_facurcard c");
            currCardSql.append(" inner join t_fa_facurcostcenter cost on cost.ffacurcardid = c.fid");
            currCardSql.append(" inner join T_FA_FacurAsstActComposit composit on composit.FFacurCostCenterID = cost.fid");
            currCardSql.append(" where c.fcompanyid in (" + this.strCompanyInclude + ") ");
            currCardSql.append(" union ");
            currCardSql.append(" select bc.fcompanyid as fcompanyid,cost.fid as fid,composit.FAsstActType AS FASSTACTTYPEID,composit.FAsstActItem ");
            currCardSql.append(" from t_fa_fabakcard bc");
            currCardSql.append(" inner join t_fa_fabakcostcenter cost on cost.FFaBakCardID = bc.fid");
            currCardSql.append(" inner join T_FA_FabakAsstActComposit composit on composit.FFabakCostCenterID = cost.fid");
            currCardSql.append(" where bc.fcompanyid in (" + this.strCompanyInclude + ") ");
        }
        if (monCardSql.length() > 0 && currCardSql.length() > 0) {
            monCardSql.append(" union ");
        }
        cardSql.append(" select asstItem.fid,asstItem.fasstacttypeid,asstItem.fasstactitem from (");
        cardSql.append(monCardSql).append(currCardSql);
        cardSql.append(") as asstItem ");
        cardSql.append(" where asstItem.fcompanyid ");
        cardSql.append(this.getSplitInSql(this.strCompanyInclude, 999, "asstItem.fcompanyid"));
        return cardSql;
    }

    protected String getSplitInSql(String strCompanyInclude, int num, String mark) {
        int i;
        String[] IDsArr = strCompanyInclude.split("\\,");
        if (num > IDsArr.length) {
            return new StringBuffer(" in (").append(strCompanyInclude).append(")").toString();
        }
        StringBuilder sqlStr = new StringBuilder();
        StringBuilder IDs = new StringBuilder();
        StringBuilder lastIDs = new StringBuilder();
        int lastIndex = 0;
        for (i = 0; i < IDsArr.length; ++i) {
            IDs.append(IDsArr[i]).append(",");
            if ((i + 1) % num != 0) continue;
            String ss = IDs.substring(0, IDs.lastIndexOf(","));
            if (i + 1 == num) {
                sqlStr.append("  in (").append(ss).append(")");
            } else {
                sqlStr.append(" or " + mark + " in (").append(ss).append(")");
            }
            IDs = new StringBuilder();
            lastIndex = i;
        }
        for (i = lastIndex + 1; i < IDsArr.length; ++i) {
            lastIDs.append(IDsArr[i]).append(",");
        }
        if (lastIDs.length() > 0) {
            sqlStr.append("  or " + mark + " in (").append(lastIDs.substring(0, IDs.lastIndexOf(","))).append(")");
        }
        return sqlStr.toString();
    }

    protected String getAsstActItemSQLFrmAsstType(Context ctx) throws BOSException {
        CoreBaseCollection AsstActTypes = AsstActTypeFactory.getLocalInstance((Context)ctx).getCollection("select id,realtionDataObject,groupTableName,isMultilevel ");
        StringBuffer select = new StringBuffer();
        select.append("select a.fid FID,a.").append(this.fName).append(" as FName_l2");
        select.append(",a.fnumber FNUMBER,a.FCONTROLUNITID,a.FPARENTID,a.FAsstacttypeID as FAsstacttypeID");
        select.append(",a.fisleaf AS FISLEAF,a.flevel FLEVEL,a.flongnumber FLONGNUMBER from (");
        String selectCol = "SELECT fid AS fid, " + this.fName + ", fnumber AS fnumber,fcontrolunitid AS fcontrolunitid ";
        StringBuffer sql = new StringBuffer();
        for (int i = 0; i < AsstActTypes.size(); ++i) {
            AsstActTypeInfo asstActType = (AsstActTypeInfo)AsstActTypes.get(i);
            String tableName = asstActType.getRealtionDataObject();
            if ("t_bd_GeneralAsstActType".equalsIgnoreCase(tableName) || "T_NCM_CostItem".equalsIgnoreCase(tableName) || "T_CM_CostItem".equalsIgnoreCase(tableName) || "T_FDC_ProductType".equalsIgnoreCase(tableName)) continue;
            String asstActTypeId = "'" + asstActType.getId() + "' AS FAsstActTypeID";
            if (sql.length() > 0) {
                sql.append(" UNION ALL \n");
            }
            boolean hasLevel = asstActType.getBoolean("isMultilevel") && asstActType.getGroupTableName() == null;
            String selects = selectCol + "," + asstActTypeId + (hasLevel ? ", FPARENTID" : ", NULL AS FPARENTID");
            sql.append(selects).append(",").append(hasLevel ? "fisleaf" : "1").append(" AS fisleaf,");
            sql.append(hasLevel ? "flevel" : "1").append(" AS flevel,");
            sql.append(hasLevel ? "flongnumber" : "fnumber").append(" AS flongnumber FROM ").append(tableName).append(" \n");
        }
        String selects = "SELECT gt.fid AS fid, gt." + this.fName + " AS " + this.fName + ", gt.fnumber AS fnumber,gt.fcontrolunitid AS fcontrolunitid,t.FID AS FASSTACTTYPEID, gt.FPARENTID AS FPARENTID ";
        if (sql.length() > 0) {
            sql.append(" UNION ALL \n");
        }
        sql.append(selects + ", gt.fisleaf AS FISLEAF,gt.flevel AS FLEVEL,gt.flongnumber as FLONGNUMBER FROM t_bd_AsstActType AS t");
        sql.append(" inner join t_Bd_Generalasstacttypegroup g on t.fglasstacttypegrpid = g.fid");
        sql.append(" inner join t_bd_GeneralAsstActType gt on gt.fgroupid = g.fid \n");
        return select + sql.toString() + ") a ";
    }

    protected int getSumItemMaxLevel(String key) throws BOSException {
        String tableName = this.getSumItemTableName(key);
        if (tableName != null) {
            String sql = "select Max(FLevel) AS MasLevel from " + tableName;
            IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql);
            try {
                if (rs != null && rs.next()) {
                    if ("useDepartment".equals(key) && rs.getInt("MasLevel") > 10 || "dept".equals(key) && rs.getInt("MasLevel") > 10 || "asstActItem".equals(key) && rs.getInt("MasLevel") > 10) {
                        return 10;
                    }
                    return rs.getInt("MasLevel");
                }
                return 0;
            }
            catch (SQLException e) {
                throw new BOSException("Sql execute exception : " + sql, (Throwable)e);
            }
        }
        throw new BOSException("Not support the sumIem '" + key + "'!");
    }

    protected String getSumItemTableName(String resource) {
        if ("assetCat".equals(resource)) {
            return "T_FA_Cat";
        }
        if ("originMethod".equals(resource)) {
            return "T_FA_AlterMode";
        }
        if ("useStatus".equals(resource)) {
            return "T_FA_UseStatus";
        }
        if ("storeCity".equals(resource)) {
            return "T_BD_Address";
        }
        if ("dept".equals(resource) || "useDepartment".equals(resource) || "lcmDept".equals(resource)) {
            return "T_ORG_Admin";
        }
        if ("orgArchitecture".equals(resource)) {
            return "T_ORG_Company";
        }
        if ("measureUnit".equals(resource)) {
            return "T_BD_MeasureUnit";
        }
        if ("economicPurp".equals(resource)) {
            return "T_FA_FaEconomicPurp";
        }
        if ("userDefineName".equals(resource)) {
            return "T_Fa_UserDefinedSort";
        }
        if ("accountName".equals(resource) || "assetAccount".equals(resource) || "accDeprAccount".equals(resource) || "decAccount".equals(resource)) {
            return "T_BD_AccountView";
        }
        if ("lcmCat".equals(resource)) {
            return "T_LCM_LCMLcmCat";
        }
        if ("lcmSourceType".equals(resource)) {
            return "T_LCM_LCMAlterMode";
        }
        if ("lcmName".equals(resource)) {
            return "T_LCM_LCMCurCard";
        }
        if ("lcmUser".equals(resource)) {
            return "T_PM_User";
        }
        if ("asstActType".equals(resource)) {
            return "T_BD_AsstActType";
        }
        if ("asstActItem".equals(resource)) {
            return this.acctAsstTableName;
        }
        if ("Period".equals(resource)) {
            return "T_BD_Period";
        }
        return null;
    }

    protected boolean isSumDefFieldBeWrapped() {
        return true;
    }

    protected LevelSumSqlInfo getLevelSumSqlInfo(Context ctx, String resource, int level, boolean isNode) {
        DefSumSQLOptionProviderImpl defProvider = this.def.getSumSQLOption(resource, this.isSumDefFieldBeWrapped());
        String tableName = this.getSumItemTableName(resource);
        if ("assetCat".equals(resource)) {
            return new LevelSumSqlInfo(ctx, tableName, resource, level, resource, isNode, (DefSumOptionProvider)defProvider);
        }
        if ("originMethod".equals(resource)) {
            return new LevelSumSqlInfo(ctx, tableName, resource, level, resource, isNode, (DefSumOptionProvider)defProvider);
        }
        if ("useStatus".equals(resource)) {
            return new LevelSumSqlInfo(ctx, tableName, resource, level, resource, isNode, (DefSumOptionProvider)defProvider);
        }
        if ("storeCity".equals(resource)) {
            return new LevelSumStoreCity(ctx);
        }
        if ("orgArchitecture".equals(resource)) {
            return new LevelSumCompany(ctx, tableName, resource, level, resource, (DefSumOptionProvider)defProvider);
        }
        if ("useDepartment".equals(resource)) {
            return new LevelSumUseDepartMent(ctx, tableName, "useDepartment", level, resource, this.isUseDepartDisLName, isNode, (DefSumOptionProvider)defProvider);
        }
        if ("measureUnit".equals(resource)) {
            return new LevelSumMeasureUnit(ctx, (DefSumOptionProvider)defProvider);
        }
        if ("economicPurp".equals(resource)) {
            return new LevelSumSqlInfo(ctx, tableName, resource, level, resource, isNode, (DefSumOptionProvider)defProvider);
        }
        if ("userDefineName".equals(resource)) {
            return new LevelSumSqlInfo(ctx, "T_Fa_UserDefinedSort", "userDefine", level, resource, (DefSumOptionProvider)defProvider);
        }
        if ("accountName".equals(resource)) {
            return new LevelSumSqlInfo(ctx, tableName, "account", level, resource, (DefSumOptionProvider)defProvider);
        }
        if ("lcmCat".equals(resource)) {
            return new LevelSumSqlInfo(ctx, tableName, resource, level, resource, (DefSumOptionProvider)defProvider);
        }
        if ("lcmSourceType".equals(resource)) {
            return new LevelSumSqlInfo(ctx, tableName, resource, level, resource, (DefSumOptionProvider)defProvider);
        }
        if ("lcmDept".equals(resource)) {
            return new LevelSumSqlInfo(ctx, tableName, "USEDEPT", level, resource, (DefSumOptionProvider)defProvider);
        }
        if ("lcmName".equals(resource)) {
            return new LevelSumSqlInfo(ctx, "T_LCM_LCMCurCard", "LCMCURCARD", level, resource, (DefSumOptionProvider)defProvider);
        }
        if ("lcmUser".equals(resource)) {
            return new LevelSumSqlInfo(ctx, "T_PM_User", "USEPERSON", level, resource, (DefSumOptionProvider)defProvider);
        }
        if ("asstActType".equals(resource)) {
            return new LevelSumSqlInfo(ctx, tableName, "asstActType", level, resource, (DefSumOptionProvider)defProvider);
        }
        if ("asstActItem".equals(resource)) {
            return new LevelSumSqlInfo(ctx, this.acctAsstTableName, "asstActItem", level, resource, isNode, (DefSumOptionProvider)defProvider);
        }
        if ("Period".equals(resource)) {
            return new LevelSumSqlInfo(ctx, tableName, resource, level, resource, (DefSumOptionProvider)defProvider);
        }
        if ("assetAccount".equals(resource)) {
            return new LevelSumSqlInfo(ctx, "T_BD_AccountView", "assetAccount", level, resource, (DefSumOptionProvider)defProvider);
        }
        if ("accDeprAccount".equals(resource)) {
            return new LevelSumSqlInfo(ctx, "T_BD_AccountView", "accDeprAccount", level, resource, (DefSumOptionProvider)defProvider);
        }
        if ("decAccount".equals(resource)) {
            return new LevelSumSqlInfo(ctx, "T_BD_AccountView", "decAccount", level, resource, (DefSumOptionProvider)defProvider);
        }
        if ("dept".equals(resource)) {
            return new LevelSumSqlInfo(ctx, tableName, resource, level, resource, isNode, (DefSumOptionProvider)defProvider);
        }
        return new LevelSumNonTree(ctx, resource, resource, (DefSumOptionProvider)defProvider);
    }

    public String insertVacantCompany(String tempTable, String select, String companyIds) {
        StringBuffer sql = new StringBuffer();
        StringBuffer numberField = new StringBuffer();
        StringBuffer nameField = new StringBuffer();
        StringBuffer nameFields = new StringBuffer();
        StringBuffer numberFields = new StringBuffer();
        List sumInfoList = this.sumOption.getSumInfoList();
        int n = sumInfoList.size();
        for (int i = 0; i < n; ++i) {
            LevelSumSqlInfo sumSqlInfo = (LevelSumSqlInfo)sumInfoList.get(i);
            if (sumInfoList.get(i) instanceof LevelSumCompany) {
                nameFields.append(",").append("orgArchitecture").append(".").append(sumSqlInfo.getNameFields());
                numberFields.append(",").append("orgArchitecture").append(".").append(sumSqlInfo.getLongNumberFields());
                continue;
            }
            nameField.append(",").append("tempTable.").append(sumSqlInfo.getNameField());
            numberField.append(",").append("tempTable.").append(sumSqlInfo.getLongNumberField());
        }
        sql.append("SELECT newBOSID('00000000') AS FId");
        sql.append(nameField).append(nameFields);
        sql.append(", ").append(select);
        sql.append(", COMPANY.FLevel AS SUMLEVEL");
        sql.append(numberField).append(numberFields);
        sql.append(" FROM ");
        if (nameField.length() > 0) {
            sql.append(tempTable).append(" AS tempTable,");
        }
        sql.append(" T_ORG_Company COMPANY ");
        String tableName = this.getSumItemJoinSql("orgArchitecture");
        if (tableName != null) {
            sql.append(" INNER JOIN ").append(tableName).append(" AS ").append("orgArchitecture");
            sql.append(" ON COMPANY.FID = ").append("orgArchitecture").append(".FID");
        }
        sql.append(" WHERE COMPANY.FID IN (");
        sql.append(companyIds);
        sql.append(")");
        return "INSERT INTO " + tempTable + " " + sql.toString();
    }

    private void buildSumItemSql(int minLevel, int maxLevel, String key) {
        String sumItemTableName = this.getSumItemTableName(key);
        boolean isAsstActItem = "asstActItem".equals(key);
        StringBuffer sql = new StringBuffer();
        for (int i = minLevel; i <= maxLevel; ++i) {
            StringBuffer strSelect = new StringBuffer("\n select ");
            StringBuffer strFrom = new StringBuffer();
            StringBuffer strWhere = new StringBuffer();
            if (sql.length() > 0) {
                sql.append("\n union all ");
            }
            strSelect.append(i).append(" as FLevel ");
            String total = ResourceBase.getString((String)RES_PATH, (String)"AllAssets", (Locale)this.ctx.getOriginLocale());
            if (isAsstActItem) {
                total = ResourceBase.getString((String)RES_PATH, (String)key, (Locale)this.ctx.getOriginLocale());
            }
            if (i < 1) {
                strSelect.append(",to_char(null) as fid");
                strSelect.append(",to_char(null) as fnumber");
                if (isAsstActItem) {
                    strSelect.append(",N'").append(total).append("' as FName_l2");
                    strSelect.append(",to_char(null) as FasstactTypeID");
                } else {
                    strSelect.append(",N'").append(total).append("' as ").append(this.fName);
                }
            } else {
                strSelect.append(",").append(key).append(i).append(".fid as fid");
                strSelect.append(",").append(key).append(i).append(".fnumber as fnumber");
                if (isAsstActItem) {
                    strSelect.append(",").append(key).append(i).append(".FName_l2").append(" as FName_l2");
                    strSelect.append(",").append(key).append(i).append(".FasstactTypeID");
                } else {
                    strSelect.append(",").append(key).append(i).append(".").append(this.fName).append(" as ").append(this.fName);
                }
                strFrom.append("\n from ").append(sumItemTableName).append(" as ").append(key).append(minLevel < 1 ? 1 : minLevel);
                if (!"useDepartment".equalsIgnoreCase(key) && !"dept".equalsIgnoreCase(key)) {
                    strWhere.append("\n where ").append(key).append(i).append(".fisleaf = 1 ");
                }
            }
            for (int j = minLevel; j <= maxLevel; ++j) {
                if (j <= i) {
                    if (j < 1) {
                        strSelect.append(",N'").append(total).append("' as ").append(key).append(j).append("Name");
                        strSelect.append(",N'").append(LevelSumOption.MAXCODE).append("' as ").append(key).append(j).append("LongNumber");
                    } else {
                        if (isAsstActItem) {
                            strSelect.append(",").append(key).append(j).append(".FName_l2").append(" as ").append(key).append(j).append("Name");
                        } else {
                            strSelect.append(",").append(key).append(j).append(".").append(this.fName).append(" as ").append(key).append(j).append("Name");
                        }
                        strSelect.append(",").append(key).append(j).append(".flongnumber as ").append(key).append(j).append("LongNumber");
                        if ("useDepartment".equalsIgnoreCase(key) || "dept".equalsIgnoreCase(key)) {
                            strWhere.append(strWhere.length() == 0 ? " where " : " and ").append(key).append(j).append(".flevel = ").append(j);
                        } else {
                            strWhere.append(" and ").append(key).append(j).append(".flevel = ").append(j);
                        }
                    }
                } else {
                    strSelect.append(",to_char(null) as ").append(key).append(j).append("Name");
                    strSelect.append(",to_char(null) as ").append(key).append(j).append("LongNumber");
                }
                if (j >= i || j < 1) continue;
                strFrom.append(" inner join ").append(sumItemTableName).append(" as ").append(key).append(j + 1);
                strFrom.append(" on ").append(key).append(j + 1).append(".fparentid = ").append(key).append(j).append(".fid");
                if (!isAsstActItem) continue;
                strFrom.append(" and ").append(key).append(j + 1).append(".FasstactTypeID = ").append(key).append(j).append(".FasstactTypeID");
            }
            if (this.isLevelSum("assetCat") && key.equalsIgnoreCase("assetCat") && i >= 1) {
                strSelect.append(",").append(key).append(i).append(".FCalcuByEvaluate ");
            } else {
                strSelect.append(",to_int(null) as FCalcuByEvaluate ");
            }
            sql.append(strSelect).append(strFrom).append(strWhere);
        }
        if (sql.length() > 0) {
            this.sumItemJoinSqlMap.put(key, "(" + sql.toString() + ")");
        }
    }

    protected boolean isSum(String key) {
        if (this.sumItemList == null || key == null) {
            return false;
        }
        int n = this.sumItemList.size();
        for (int i = 0; i < n; ++i) {
            FaSumOptnObject fsoo = (FaSumOptnObject)this.sumItemList.get(i);
            if (!fsoo.isSum() || !key.equals(fsoo.getFieldName())) continue;
            return true;
        }
        return false;
    }

    protected boolean isSpecLevelSum(String key) {
        if (this.sumItemList == null || key == null) {
            return false;
        }
        int n = this.sumItemList.size();
        for (int i = 0; i < n; ++i) {
            FaSumOptnObject fsoo = (FaSumOptnObject)this.sumItemList.get(i);
            if (!fsoo.isSum() || !key.equals(fsoo.getFieldName()) || FaSumLevelEnum.specified != fsoo.getLevelType()) continue;
            return true;
        }
        return false;
    }

    protected boolean isLevelSum(String key) {
        if (this.sumItemList == null || key == null) {
            return false;
        }
        int n = this.sumItemList.size();
        for (int i = 0; i < n; ++i) {
            FaSumOptnObject fsoo = (FaSumOptnObject)this.sumItemList.get(i);
            if (!fsoo.isSum() || !key.equals(fsoo.getFieldName()) || FaSumLevelEnum.level != fsoo.getLevelType() && FaSumLevelEnum.specified != fsoo.getLevelType()) continue;
            return true;
        }
        return false;
    }

    protected boolean isDetailSum(String key) {
        if (this.sumItemList == null || key == null) {
            return false;
        }
        int n = this.sumItemList.size();
        for (int i = 0; i < n; ++i) {
            FaSumOptnObject fsoo = (FaSumOptnObject)this.sumItemList.get(i);
            if (!fsoo.isSum() || !key.equals(fsoo.getFieldName()) || FaSumLevelEnum.detail != fsoo.getLevelType()) continue;
            return true;
        }
        return false;
    }

    protected String getMaxAmtScal() {
        String sql = "select max(a.fvalue_l1) from t_bas_paramitem a inner join T_BAS_Param b on a.fkeyid = b.fid where fnumber = 'FA_008'";
        try {
            IRowSet row = DbUtil.executeQuery((Context)this.ctx, (String)FaLocalUtils.transformLocal((Context)this.ctx, (String)sql));
            row.next();
            return row.getString(1);
        }
        catch (Exception e) {
            return "4";
        }
    }
}

