/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.rpt.app.dao;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.fa.manage.FaCurCardFactory;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.fi.fa.manage.FaMonCardFactory;
import com.kingdee.eas.fi.fa.manage.FaMonCardInfo;
import com.kingdee.eas.fi.fa.manage.app.FaLocalUtils;
import com.kingdee.eas.fi.fa.rpt.FaDBUtilConfig;
import com.kingdee.eas.fi.fa.rpt.FaSumLevelEnum;
import com.kingdee.eas.fi.fa.rpt.FaSumOptnObject;
import com.kingdee.eas.fi.fa.rpt.app.dao.FaDaoBase;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class FaDeprDao
extends FaDaoBase {
    private static Logger logger = Logger.getLogger(FaDeprDao.class);
    private boolean deprZeroCard = false;
    private boolean cleanCard = false;
    private boolean allCleanCard = false;
    private boolean isListStyle;
    private boolean isShowNotAudit = false;
    private boolean displayEvalData = false;
    private boolean displayDepMultipData = false;
    private BigDecimal ZERO = new BigDecimal(0.0);

    @Override
    protected void buildSql() throws BOSException {
        this.buildResultSql();
    }

    @Override
    protected void buildData() throws BOSException {
        this.addDataTempTable(FaLocalUtils.transformLocal((Context)this.ctx, (String)this.getDeprDetailSql()));
        String sumSql = this.sumOption.getSumSql(this.tempTable, this.getSumSelectSql(), this.getSumSqlDistinctSelect(), null, null, this.isListStyle, false);
        if (this.displayDepMultipData && !this.isVirCompany) {
            try {
                TempTablePool.getInstance((Context)this.ctx).createIndex(this.tempTable, "fid", false, false);
            }
            catch (Exception e) {
                throw new BOSException("createIndex exception : ", (Throwable)e);
            }
            this.buildDepMultipData(this.ctx);
        }
        if (sumSql != null && sumSql.trim().length() > 0) {
            DbUtil.execute((Context)this.ctx, (String)sumSql);
            if (!this.isVirCompany) {
                this.setAddUpYearDepre(this.ctx);
                this.setAddUpYearDepreForDetail(this.ctx);
                this.setAddUpBeginBalanceDepre(this.ctx);
                this.setAddUpBeginDepreForDetail(this.ctx);
            } else {
                this.setAddUpYearDepre_VirtualBodySearch(this.ctx);
                this.setAddUpBeginDepre_VirtualBodySearch(this.ctx);
            }
        }
        if (!this.isListStyle && this.sumOption.isHasSum()) {
            this.deleteUnnecessaryData();
        }
        this.result.put("hasNoAudit", new Boolean(false));
    }

    private void buildDepMultipData(Context ctx) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT fid, cardid, periodid FROM ");
        sql.append(this.tempTable);
        sql.append(" where cardid is not null ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        IRowSet rs6 = null;
        IRowSet rs1 = null;
        String updateSql = "update " + this.tempTable + " set  beginAddUpYearDepre=?, beginAccuDeprCreditTyear=?, accuDeprCleanTYear=?, AccuDeprChgTYear=?, endAccuDeprCreditTyear=?,  newcardaccudeprtterm=?, addAccuDeprChgTTerm=?, lessAccuDeprChgTTerm=?, accuDeprCleanTTerm=?, newCardAccuDeprTYear=?,  addAccuDeprChgTYear=?, lessAccuDeprChgTYear=?  where fid = ? ";
        try {
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
            StringBuffer sql1 = new StringBuffer();
            while (rs.next()) {
                PeriodInfo periodInfo;
                String fid = rs.getString("fid");
                String cardid = rs.getString("cardid");
                String periodid = rs.getString("periodid");
                if (new FaCurCardInfo().getBOSType().equals((Object)new ObjectUuidPK(cardid).getObjectType())) {
                    periodInfo = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(periodid));
                    FaMonCardInfo preFaMonCardInfo = null;
                    PeriodInfo prePeriodInfo = PeriodUtils.getPrePeriodInfo((Context)ctx, (PeriodInfo)periodInfo);
                    if (prePeriodInfo != null) {
                        try {
                            preFaMonCardInfo = FaMonCardFactory.getLocalInstance((Context)ctx).getFaMonCardInfo("select AccuDeprTYear,AccuDeprAccuCleanTYear where faPeriod.id ='" + prePeriodInfo.getId() + "' and faCurCard.id='" + cardid + "'");
                        }
                        catch (ObjectNotFoundException e) {
                            preFaMonCardInfo = null;
                        }
                    }
                    BigDecimal beginAccuDeprCreditTyear = this.ZERO;
                    BigDecimal beginAddUpYearDepre = this.ZERO;
                    BigDecimal endAccuDeprCreditTyear = this.ZERO;
                    FaCurCardInfo faCurCardInfo = FaCurCardFactory.getLocalInstance((Context)ctx).getFaCurCardInfo((IObjectPK)new ObjectUuidPK(cardid));
                    PeriodInfo startPeriodInfo = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)faCurCardInfo.getCompany());
                    if (periodInfo.getPeriodNumber() == 1) {
                        beginAddUpYearDepre = this.ZERO;
                        beginAccuDeprCreditTyear = this.ZERO;
                    } else if (periodInfo.getId().toString().equals(startPeriodInfo.getId().toString()) && faCurCardInfo.getOriginFlag() != null && faCurCardInfo.getOriginFlag().getValue() == 0) {
                        try {
                            FaMonCardInfo faMonCardInfo = FaMonCardFactory.getLocalInstance((Context)ctx).getFaMonCardInfo("select AccuDeprTYear where faPeriod.id is null and faCurCard.id='" + cardid + "' and OriginFlag = 0 ");
                            beginAddUpYearDepre = faMonCardInfo.getAccuDeprTYear();
                            beginAccuDeprCreditTyear = faMonCardInfo.getAccuDeprTYear();
                        }
                        catch (ObjectNotFoundException e) {
                            beginAddUpYearDepre = faCurCardInfo.getAccuDeprTYear();
                            beginAccuDeprCreditTyear = faCurCardInfo.getAccuDeprTYear();
                        }
                    } else {
                        beginAddUpYearDepre = preFaMonCardInfo == null ? this.ZERO : preFaMonCardInfo.getAccuDeprTYear();
                        BigDecimal accuDeprtTermTYear = this.ZERO;
                        sql1.delete(0, sql1.length());
                        sql1.append("SELECT b.FACCUDEPR  FROM T_FA_FABakCARD b  LEFT OUTER JOIN T_BD_PERIOD p ON b.FPERIODID = P.FID  where b.FFACURCARDID = '" + cardid + "' and FBillType = 1  and p.FPERIODYEAR = " + periodInfo.getPeriodYear() + " and p.FPERIODNUMBER  > 0 and p.FPERIODNUMBER <  " + periodInfo.getPeriodNumber());
                        rs1 = DbUtil.executeQuery((Context)ctx, (String)sql1.toString());
                        while (rs1.next()) {
                            accuDeprtTermTYear = rs1.getBigDecimal("FACCUDEPR");
                        }
                        BigDecimal accuDeprChgTTerm = this.ZERO;
                        sql1.delete(0, sql1.length());
                        sql1.append("SELECT sum(e.TACCUDEPRCHG) TACCUDEPRCHG FROM  T_FA_fachangebill b  LEFT OUTER JOIN T_BD_PERIOD p ON B.FPERIODID = P.FID  INNER JOIN T_FA_FACHANGEBILLENTRY e ON B.FID = e.FCHANGEBILLID  where e.FCURCARDID = '" + cardid + "'  and p.FPERIODYEAR = " + periodInfo.getPeriodYear() + " and p.FPERIODNUMBER  > 0 and p.FPERIODNUMBER <  " + periodInfo.getPeriodNumber());
                        rs1 = DbUtil.executeQuery((Context)ctx, (String)sql1.toString());
                        while (rs1.next()) {
                            accuDeprChgTTerm = rs1.getBigDecimal("TACCUDEPRCHG") == null ? this.ZERO : rs1.getBigDecimal("TACCUDEPRCHG");
                        }
                        BigDecimal depreciationSum = this.ZERO;
                        sql1.delete(0, sql1.length());
                        sql1.append("SELECT sum(e.FDEPRECIATION) FDEPRECIATION FROM T_FA_FADEPRECIATION d  LEFT OUTER JOIN T_FA_FADEPRECIATIONENTRY e on d.FID = e.FLNKFADEPREENTRY  LEFT OUTER JOIN T_BD_PERIOD p ON D.FPERIOD = P.FID  where e.FFACURCARDID = '" + cardid + "'  and p.FPERIODYEAR = " + periodInfo.getPeriodYear() + " and p.FPERIODNUMBER  > 0 and p.FPERIODNUMBER <  " + periodInfo.getPeriodNumber());
                        rs1 = DbUtil.executeQuery((Context)ctx, (String)sql1.toString());
                        while (rs1.next()) {
                            depreciationSum = rs1.getBigDecimal("FDEPRECIATION") == null ? this.ZERO : rs1.getBigDecimal("FDEPRECIATION");
                        }
                        BigDecimal evalDepreciationSum = this.ZERO;
                        sql1.delete(0, sql1.length());
                        sql1.append("SELECT sum(e.FDEPRECIATION) FDEVALEPRECIATION FROM T_FA_FAEVALDEPRECIATION d  LEFT OUTER JOIN T_FA_FAEVALDEPRECIATIONENTRY e on d.FID = e.FLNKFADEPREENTRY  LEFT OUTER JOIN T_BD_PERIOD p ON D.FPERIOD = P.FID  where e.FFACURCARDID = '" + cardid + "'  and p.FPERIODYEAR = " + periodInfo.getPeriodYear() + " and p.FPERIODNUMBER  > 0 and p.FPERIODNUMBER <  " + periodInfo.getPeriodNumber());
                        rs1 = DbUtil.executeQuery((Context)ctx, (String)sql1.toString());
                        while (rs1.next()) {
                            evalDepreciationSum = rs1.getBigDecimal("FDEVALEPRECIATION") == null ? this.ZERO : rs1.getBigDecimal("FDEVALEPRECIATION");
                        }
                        beginAccuDeprCreditTyear = accuDeprtTermTYear.add(accuDeprChgTTerm).add(depreciationSum).add(evalDepreciationSum);
                    }
                    BigDecimal newCardAccuDeprtTerm1 = this.ZERO;
                    sql1.delete(0, sql1.length());
                    sql1.append("SELECT b.FACCUDEPR  FROM T_FA_FABakCARD b  LEFT OUTER JOIN T_BD_PERIOD p ON b.FPERIODID = P.FID  where b.FFACURCARDID = '" + cardid + "' and FBillType = 1  and p.FPERIODYEAR = " + periodInfo.getPeriodYear() + " and p.FPERIODNUMBER =  " + periodInfo.getPeriodNumber());
                    rs1 = DbUtil.executeQuery((Context)ctx, (String)sql1.toString());
                    while (rs1.next()) {
                        newCardAccuDeprtTerm1 = rs1.getBigDecimal("FACCUDEPR");
                    }
                    BigDecimal accuDeprChgTTerm1 = this.ZERO;
                    sql1.delete(0, sql1.length());
                    sql1.append("SELECT sum(e.TACCUDEPRCHG) TACCUDEPRCHG FROM  T_FA_fachangebill b  LEFT OUTER JOIN T_BD_PERIOD p ON B.FPERIODID = P.FID  INNER JOIN T_FA_FACHANGEBILLENTRY e ON B.FID = e.FCHANGEBILLID  where e.FCURCARDID = '" + cardid + "'  and p.FPERIODYEAR = " + periodInfo.getPeriodYear() + " and p.FPERIODNUMBER =  " + periodInfo.getPeriodNumber());
                    rs1 = DbUtil.executeQuery((Context)ctx, (String)sql1.toString());
                    while (rs1.next()) {
                        accuDeprChgTTerm1 = rs1.getBigDecimal("TACCUDEPRCHG") == null ? this.ZERO : rs1.getBigDecimal("TACCUDEPRCHG");
                    }
                    BigDecimal depreciationSum1 = this.ZERO;
                    sql1.delete(0, sql1.length());
                    sql1.append("SELECT sum(e.FDEPRECIATION) FDEPRECIATION FROM T_FA_FADEPRECIATION d  LEFT OUTER JOIN T_FA_FADEPRECIATIONENTRY e on d.FID = e.FLNKFADEPREENTRY  LEFT OUTER JOIN T_BD_PERIOD p ON D.FPERIOD = P.FID  where e.FFACURCARDID = '" + cardid + "'  and p.FPERIODYEAR = " + periodInfo.getPeriodYear() + " and p.FPERIODNUMBER =  " + periodInfo.getPeriodNumber());
                    rs1 = DbUtil.executeQuery((Context)ctx, (String)sql1.toString());
                    while (rs1.next()) {
                        depreciationSum1 = rs1.getBigDecimal("FDEPRECIATION") == null ? this.ZERO : rs1.getBigDecimal("FDEPRECIATION");
                    }
                    BigDecimal evalDepreciationSum1 = this.ZERO;
                    sql1.delete(0, sql1.length());
                    sql1.append("SELECT sum(e.FDEPRECIATION) FDEVALEPRECIATION FROM T_FA_FAEVALDEPRECIATION d  LEFT OUTER JOIN T_FA_FAEVALDEPRECIATIONENTRY e on d.FID = e.FLNKFADEPREENTRY  LEFT OUTER JOIN T_BD_PERIOD p ON D.FPERIOD = P.FID  where e.FFACURCARDID = '" + cardid + "'  and p.FPERIODYEAR = " + periodInfo.getPeriodYear() + " and p.FPERIODNUMBER =  " + periodInfo.getPeriodNumber());
                    rs1 = DbUtil.executeQuery((Context)ctx, (String)sql1.toString());
                    while (rs1.next()) {
                        evalDepreciationSum1 = rs1.getBigDecimal("FDEVALEPRECIATION") == null ? this.ZERO : rs1.getBigDecimal("FDEVALEPRECIATION");
                    }
                    BigDecimal newCardAccuDeprtTerm = this.ZERO;
                    BigDecimal newCardAccuDeprTYear = this.ZERO;
                    StringBuffer sql6 = new StringBuffer();
                    sql6.append("SELECT b.FACCUDEPR newCardAccuDeprtTerm, b.FACCUDEPRTYEAR newCardAccuDeprTYear FROM T_FA_FABakCARD b  LEFT OUTER JOIN T_BD_PERIOD p ON b.FPERIODID = P.FID  where b.FFACURCARDID = '" + cardid + "' and FBillType = 1  and p.FPERIODYEAR = " + periodInfo.getPeriodYear() + " and p.FPERIODNUMBER =  " + periodInfo.getPeriodNumber());
                    rs6 = DbUtil.executeQuery((Context)ctx, (String)sql6.toString());
                    while (rs6.next()) {
                        newCardAccuDeprtTerm = rs6.getBigDecimal("newCardAccuDeprtTerm");
                        newCardAccuDeprTYear = rs6.getBigDecimal("newCardAccuDeprTYear");
                    }
                    BigDecimal addAccuDeprChgTTerm = this.ZERO;
                    sql6.delete(0, sql6.length());
                    sql6.append("SELECT sum(e.TACCUDEPRCHG) addAccuDeprChgTTerm FROM  T_FA_fachangebill b  LEFT OUTER JOIN T_BD_PERIOD p ON B.FPERIODID = P.FID  INNER JOIN T_FA_FACHANGEBILLENTRY e ON B.FID = e.FCHANGEBILLID  where e.FCURCARDID = '" + cardid + "' and e.TACCUDEPRCHG > 0  and p.FPERIODYEAR = " + periodInfo.getPeriodYear() + " and p.FPERIODNUMBER =  " + periodInfo.getPeriodNumber());
                    rs6 = DbUtil.executeQuery((Context)ctx, (String)sql6.toString());
                    while (rs6.next()) {
                        addAccuDeprChgTTerm = rs6.getBigDecimal("addAccuDeprChgTTerm") == null ? this.ZERO : rs6.getBigDecimal("addAccuDeprChgTTerm");
                    }
                    BigDecimal lessAccuDeprChgTTerm = this.ZERO;
                    sql6.delete(0, sql6.length());
                    sql6.append("SELECT sum(e.TACCUDEPRCHG) lessAccuDeprChgTTerm FROM  T_FA_fachangebill b  LEFT OUTER JOIN T_BD_PERIOD p ON B.FPERIODID = P.FID  INNER JOIN T_FA_FACHANGEBILLENTRY e ON B.FID = e.FCHANGEBILLID  where e.FCURCARDID = '" + cardid + "' and e.TACCUDEPRCHG < 0  and p.FPERIODYEAR = " + periodInfo.getPeriodYear() + " and p.FPERIODNUMBER =  " + periodInfo.getPeriodNumber());
                    rs6 = DbUtil.executeQuery((Context)ctx, (String)sql6.toString());
                    while (rs6.next()) {
                        lessAccuDeprChgTTerm = rs6.getBigDecimal("lessAccuDeprChgTTerm") == null ? this.ZERO : rs6.getBigDecimal("lessAccuDeprChgTTerm").abs();
                    }
                    BigDecimal accuDeprCleanTTerm = this.ZERO;
                    sql6.delete(0, sql6.length());
                    sql6.append("SELECT sum(e.FCLRADDUPDEP) accuDeprCleanTTerm FROM  T_FA_CLEARBILL b  LEFT OUTER JOIN T_BD_PERIOD p ON B.FPERIODID = P.FID  INNER JOIN T_FA_CLEARBILLENTRY e ON B.FID = e.FENTRYID  where e.FCURCARDID = '" + cardid + "'  and p.FPERIODYEAR = " + periodInfo.getPeriodYear() + " and p.FPERIODNUMBER =  " + periodInfo.getPeriodNumber());
                    rs6 = DbUtil.executeQuery((Context)ctx, (String)sql6.toString());
                    while (rs6.next()) {
                        accuDeprCleanTTerm = rs6.getBigDecimal("accuDeprCleanTTerm") == null ? this.ZERO : rs6.getBigDecimal("accuDeprCleanTTerm");
                    }
                    BigDecimal addAccuDeprChgTYear = this.ZERO;
                    sql6.delete(0, sql6.length());
                    sql6.append("SELECT sum(z.FACCUDEPRTYEAR- k.FACCUDEPRTYEAR) as addAccuDeprChgTYear FROM  T_FA_FACHANGEBILL c  LEFT OUTER JOIN T_BD_PERIOD p ON C.FPERIODID = P.FID   INNER JOIN T_FA_FACHANGEBILLENTRY e ON C.FID = E.FCHANGEBILLID  INNER JOIN T_FA_FABIZCARD z on z.FID = e.FBIZCARDID  INNER JOIN T_FA_FABAKCARD k on k.FID = z.FFABAKCARDID  where e.FCURCARDID = '" + cardid + "' and z.FACCUDEPRTYEAR- k.FACCUDEPRTYEAR > 0  and p.FPERIODYEAR = " + periodInfo.getPeriodYear() + " and p.FPERIODNUMBER =  " + periodInfo.getPeriodNumber());
                    rs6 = DbUtil.executeQuery((Context)ctx, (String)sql6.toString());
                    while (rs6.next()) {
                        addAccuDeprChgTYear = rs6.getBigDecimal("addAccuDeprChgTYear") == null ? this.ZERO : rs6.getBigDecimal("addAccuDeprChgTYear");
                    }
                    BigDecimal lessAccuDeprChgTYear = this.ZERO;
                    sql6.delete(0, sql6.length());
                    sql6.append("SELECT sum(z.FACCUDEPRTYEAR- k.FACCUDEPRTYEAR) as lessAccuDeprChgTYear FROM  T_FA_FACHANGEBILL c  LEFT OUTER JOIN T_BD_PERIOD p ON C.FPERIODID = P.FID   INNER JOIN T_FA_FACHANGEBILLENTRY e ON C.FID = E.FCHANGEBILLID  INNER JOIN T_FA_FABIZCARD z on z.FID = e.FBIZCARDID  INNER JOIN T_FA_FABAKCARD k on k.FID = z.FFABAKCARDID  where e.FCURCARDID = '" + cardid + "' and z.FACCUDEPRTYEAR- k.FACCUDEPRTYEAR < 0  and p.FPERIODYEAR = " + periodInfo.getPeriodYear() + " and p.FPERIODNUMBER =  " + periodInfo.getPeriodNumber());
                    rs6 = DbUtil.executeQuery((Context)ctx, (String)sql6.toString());
                    while (rs6.next()) {
                        lessAccuDeprChgTYear = rs6.getBigDecimal("lessAccuDeprChgTYear") == null ? this.ZERO : rs6.getBigDecimal("lessAccuDeprChgTYear").abs();
                    }
                    BigDecimal accuDeprCleanTYear = this.ZERO;
                    if (faCurCardInfo.isHasDisabled() || DeletedStatusEnum.DELETED == faCurCardInfo.getDeletedStatus()) {
                        BigDecimal accuDeprCleanTYearPart = this.ZERO;
                        BigDecimal accuDeprCleanTYearFull = this.ZERO;
                        sql6.delete(0, sql6.length());
                        sql6.append("SELECT sum(k.FACCUDEPRTYEAR- z.FACCUDEPRTYEAR) as accuDeprCleanTYear FROM  T_FA_ClearBill c  LEFT OUTER JOIN T_BD_PERIOD p ON C.FPERIODID = P.FID   INNER JOIN T_FA_ClearBillENTRY e ON C.FID = E.FENTRYID  INNER JOIN T_FA_FABIZCARD z on z.FID = e.FBIZCARDID  INNER JOIN T_FA_FABAKCARD k on k.FID = z.FFABAKCARDID  where e.FCURCARDID = '" + cardid + "' and e.FCLRQTY < k.FASSETAMT  and p.FPERIODYEAR = " + periodInfo.getPeriodYear() + " and p.FPERIODNUMBER =  " + periodInfo.getPeriodNumber());
                        rs6 = DbUtil.executeQuery((Context)ctx, (String)sql6.toString());
                        while (rs6.next()) {
                            accuDeprCleanTYearPart = rs6.getBigDecimal("accuDeprCleanTYear") == null ? this.ZERO : rs6.getBigDecimal("accuDeprCleanTYear");
                        }
                        sql6.delete(0, sql6.length());
                        sql6.append("SELECT z.FACCUDEPRTYEAR as accuDeprCleanTYear FROM  T_FA_ClearBill c  LEFT OUTER JOIN T_BD_PERIOD p ON C.FPERIODID = P.FID   INNER JOIN T_FA_ClearBillENTRY e ON C.FID = E.FENTRYID  INNER JOIN T_FA_FABIZCARD z on z.FID = e.FBIZCARDID  INNER JOIN T_FA_FABAKCARD k on k.FID = z.FFABAKCARDID  where e.FCURCARDID = '" + cardid + "' and e.FCLRQTY = k.FASSETAMT  and p.FPERIODYEAR = " + periodInfo.getPeriodYear() + " and p.FPERIODNUMBER =  " + periodInfo.getPeriodNumber());
                        rs6 = DbUtil.executeQuery((Context)ctx, (String)sql6.toString());
                        while (rs6.next()) {
                            accuDeprCleanTYearFull = rs6.getBigDecimal("accuDeprCleanTYear") == null ? this.ZERO : rs6.getBigDecimal("accuDeprCleanTYear");
                        }
                        accuDeprCleanTYear = accuDeprCleanTYearPart.add(accuDeprCleanTYearFull);
                    } else {
                        sql6.delete(0, sql6.length());
                        sql6.append("SELECT sum(k.FACCUDEPRTYEAR- z.FACCUDEPRTYEAR) as accuDeprCleanTYear FROM  T_FA_ClearBill c  LEFT OUTER JOIN T_BD_PERIOD p ON C.FPERIODID = P.FID   INNER JOIN T_FA_ClearBillENTRY e ON C.FID = E.FENTRYID  INNER JOIN T_FA_FABIZCARD z on z.FID = e.FBIZCARDID  INNER JOIN T_FA_FABAKCARD k on k.FID = z.FFABAKCARDID  where e.FCURCARDID = '" + cardid + "' and e.FCLRQTY < k.FASSETAMT  and p.FPERIODYEAR = " + periodInfo.getPeriodYear() + " and p.FPERIODNUMBER =  " + periodInfo.getPeriodNumber());
                        rs6 = DbUtil.executeQuery((Context)ctx, (String)sql6.toString());
                        while (rs6.next()) {
                            accuDeprCleanTYear = rs6.getBigDecimal("accuDeprCleanTYear") == null ? this.ZERO : rs6.getBigDecimal("accuDeprCleanTYear");
                        }
                    }
                    endAccuDeprCreditTyear = beginAccuDeprCreditTyear.add(newCardAccuDeprtTerm1).add(accuDeprChgTTerm1).add(depreciationSum1).add(evalDepreciationSum1);
                    BigDecimal AccuDeprChgTYear = newCardAccuDeprTYear.add(addAccuDeprChgTYear).subtract(lessAccuDeprChgTYear).subtract(accuDeprCleanTYear);
                    paramsList.add(new Object[]{beginAddUpYearDepre, beginAccuDeprCreditTyear, accuDeprCleanTYear, AccuDeprChgTYear, endAccuDeprCreditTyear, newCardAccuDeprtTerm, addAccuDeprChgTTerm, lessAccuDeprChgTTerm, accuDeprCleanTTerm, newCardAccuDeprTYear, addAccuDeprChgTYear, lessAccuDeprChgTYear, fid});
                    continue;
                }
                if (!new FaMonCardInfo().getBOSType().equals((Object)new ObjectUuidPK(cardid).getObjectType())) continue;
                periodInfo = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(periodid));
                PeriodInfo prePeriodInfo = PeriodUtils.getPrePeriodInfo((Context)ctx, (PeriodInfo)periodInfo);
                FaMonCardInfo faMonCardInfo = FaMonCardFactory.getLocalInstance((Context)ctx).getFaMonCardInfo((IObjectPK)new ObjectUuidPK(cardid));
                String curCardid = faMonCardInfo.getFaCurCard().getId().toString();
                FaMonCardInfo preFaMonCardInfo = null;
                if (prePeriodInfo != null) {
                    try {
                        preFaMonCardInfo = FaMonCardFactory.getLocalInstance((Context)ctx).getFaMonCardInfo("select AccuDeprTYear,AccuDeprAccuCleanTYear where faPeriod.id ='" + prePeriodInfo.getId() + "' and faCurCard.id='" + curCardid + "'");
                    }
                    catch (ObjectNotFoundException e) {
                        preFaMonCardInfo = null;
                    }
                }
                BigDecimal beginAddUpYearDepre = this.ZERO;
                BigDecimal beginAccuDeprCreditTyear = this.ZERO;
                BigDecimal endAccuDeprCreditTyear = this.ZERO;
                PeriodInfo startPeriodInfo = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)faMonCardInfo.getCompany());
                if (periodInfo.getPeriodNumber() == 1) {
                    beginAddUpYearDepre = this.ZERO;
                    beginAccuDeprCreditTyear = this.ZERO;
                } else if (periodInfo.getId().toString().equals(startPeriodInfo.getId().toString()) && faMonCardInfo.getOriginFlag() != null && faMonCardInfo.getOriginFlag().getValue() == 0) {
                    try {
                        FaMonCardInfo faMonInitCardInfo = FaMonCardFactory.getLocalInstance((Context)ctx).getFaMonCardInfo("select AccuDeprTYear where faPeriod.id is null and faCurCard.id='" + curCardid + "' and OriginFlag = 0 ");
                        beginAddUpYearDepre = faMonInitCardInfo.getAccuDeprTYear();
                        beginAccuDeprCreditTyear = faMonInitCardInfo.getAccuDeprTYear();
                    }
                    catch (ObjectNotFoundException e) {
                        beginAddUpYearDepre = faMonCardInfo.getAccuDeprTYear();
                        beginAccuDeprCreditTyear = faMonCardInfo.getAccuDeprTYear();
                    }
                } else {
                    beginAddUpYearDepre = preFaMonCardInfo == null ? this.ZERO : preFaMonCardInfo.getAccuDeprTYear();
                    BigDecimal newCardAccuDeprtTerm = this.ZERO;
                    sql1.delete(0, sql1.length());
                    sql1.append("SELECT b.FACCUDEPR  FROM T_FA_FABakCARD b  LEFT OUTER JOIN T_BD_PERIOD p ON b.FPERIODID = P.FID  where b.FFACURCARDID = '" + curCardid + "' and FBillType = 1  and p.FPERIODYEAR = " + periodInfo.getPeriodYear() + " and p.FPERIODNUMBER  > 0 and p.FPERIODNUMBER <  " + periodInfo.getPeriodNumber());
                    rs1 = DbUtil.executeQuery((Context)ctx, (String)sql1.toString());
                    while (rs1.next()) {
                        newCardAccuDeprtTerm = rs1.getBigDecimal("FACCUDEPR");
                    }
                    BigDecimal accuDeprChgTTerm = this.ZERO;
                    sql1.delete(0, sql1.length());
                    sql1.append("SELECT sum(e.TACCUDEPRCHG) TACCUDEPRCHG FROM  T_FA_fachangebill b  LEFT OUTER JOIN T_BD_PERIOD p ON B.FPERIODID = P.FID  INNER JOIN T_FA_FACHANGEBILLENTRY e ON B.FID = e.FCHANGEBILLID   where e.FCURCARDID = '" + curCardid + "'  and p.FPERIODYEAR = " + periodInfo.getPeriodYear() + " and p.FPERIODNUMBER  > 0 and p.FPERIODNUMBER <  " + periodInfo.getPeriodNumber());
                    rs1 = DbUtil.executeQuery((Context)ctx, (String)sql1.toString());
                    while (rs1.next()) {
                        accuDeprChgTTerm = rs1.getBigDecimal("TACCUDEPRCHG") == null ? this.ZERO : rs1.getBigDecimal("TACCUDEPRCHG");
                    }
                    BigDecimal depreciationSum = this.ZERO;
                    sql1.delete(0, sql1.length());
                    sql1.append("SELECT sum(e.FDEPRECIATION) FDEPRECIATION FROM T_FA_FADEPRECIATION d  LEFT OUTER JOIN T_FA_FADEPRECIATIONENTRY e on d.FID = e.FLNKFADEPREENTRY  LEFT OUTER JOIN T_BD_PERIOD p ON D.FPERIOD = P.FID  where e.FFACURCARDID = '" + curCardid + "'  and p.FPERIODYEAR = " + periodInfo.getPeriodYear() + " and p.FPERIODNUMBER  > 0 and p.FPERIODNUMBER <  " + periodInfo.getPeriodNumber());
                    rs1 = DbUtil.executeQuery((Context)ctx, (String)sql1.toString());
                    while (rs1.next()) {
                        depreciationSum = rs1.getBigDecimal("FDEPRECIATION") == null ? this.ZERO : rs1.getBigDecimal("FDEPRECIATION");
                    }
                    BigDecimal evalDepreciationSum = this.ZERO;
                    sql1.delete(0, sql1.length());
                    sql1.append("SELECT sum(e.FDEPRECIATION) FDEVALEPRECIATION FROM T_FA_FAEVALDEPRECIATION d  LEFT OUTER JOIN T_FA_FAEVALDEPRECIATIONENTRY e on d.FID = e.FLNKFADEPREENTRY  LEFT OUTER JOIN T_BD_PERIOD p ON D.FPERIOD = P.FID  where e.FFACURCARDID = '" + curCardid + "'  and p.FPERIODYEAR = " + periodInfo.getPeriodYear() + " and p.FPERIODNUMBER  > 0 and p.FPERIODNUMBER <  " + periodInfo.getPeriodNumber());
                    rs1 = DbUtil.executeQuery((Context)ctx, (String)sql1.toString());
                    while (rs1.next()) {
                        evalDepreciationSum = rs1.getBigDecimal("FDEVALEPRECIATION") == null ? this.ZERO : rs1.getBigDecimal("FDEVALEPRECIATION");
                    }
                    beginAccuDeprCreditTyear = newCardAccuDeprtTerm.add(accuDeprChgTTerm).add(depreciationSum).add(evalDepreciationSum);
                }
                BigDecimal newCardAccuDeprtTerm1 = this.ZERO;
                sql1.delete(0, sql1.length());
                sql1.append("SELECT b.FACCUDEPR  FROM T_FA_FABakCARD b  LEFT OUTER JOIN T_BD_PERIOD p ON b.FPERIODID = P.FID  where b.FFACURCARDID = '" + curCardid + "' and FBillType = 1  and p.FPERIODYEAR = " + periodInfo.getPeriodYear() + " and p.FPERIODNUMBER =  " + periodInfo.getPeriodNumber());
                rs1 = DbUtil.executeQuery((Context)ctx, (String)sql1.toString());
                while (rs1.next()) {
                    newCardAccuDeprtTerm1 = rs1.getBigDecimal("FACCUDEPR");
                }
                BigDecimal accuDeprChgTTerm1 = this.ZERO;
                sql1.delete(0, sql1.length());
                sql1.append("SELECT sum(e.TACCUDEPRCHG) TACCUDEPRCHG FROM  T_FA_fachangebill b  LEFT OUTER JOIN T_BD_PERIOD p ON B.FPERIODID = P.FID  INNER JOIN T_FA_FACHANGEBILLENTRY e ON B.FID = e.FCHANGEBILLID  where e.FCURCARDID = '" + curCardid + "'  and p.FPERIODYEAR = " + periodInfo.getPeriodYear() + " and p.FPERIODNUMBER =  " + periodInfo.getPeriodNumber());
                rs1 = DbUtil.executeQuery((Context)ctx, (String)sql1.toString());
                while (rs1.next()) {
                    accuDeprChgTTerm1 = rs1.getBigDecimal("TACCUDEPRCHG") == null ? this.ZERO : rs1.getBigDecimal("TACCUDEPRCHG");
                }
                BigDecimal depreciationSum1 = this.ZERO;
                sql1.delete(0, sql1.length());
                sql1.append("SELECT sum(e.FDEPRECIATION) FDEPRECIATION FROM T_FA_FADEPRECIATION d  LEFT OUTER JOIN T_FA_FADEPRECIATIONENTRY e on d.FID = e.FLNKFADEPREENTRY  LEFT OUTER JOIN T_BD_PERIOD p ON D.FPERIOD = P.FID  where e.FFACURCARDID = '" + curCardid + "'  and p.FPERIODYEAR = " + periodInfo.getPeriodYear() + " and p.FPERIODNUMBER =  " + periodInfo.getPeriodNumber());
                rs1 = DbUtil.executeQuery((Context)ctx, (String)sql1.toString());
                while (rs1.next()) {
                    depreciationSum1 = rs1.getBigDecimal("FDEPRECIATION") == null ? this.ZERO : rs1.getBigDecimal("FDEPRECIATION");
                }
                BigDecimal evalDepreciationSum1 = this.ZERO;
                sql1.delete(0, sql1.length());
                sql1.append("SELECT sum(e.FDEPRECIATION) FDEVALEPRECIATION FROM T_FA_FAEVALDEPRECIATION d  LEFT OUTER JOIN T_FA_FAEVALDEPRECIATIONENTRY e on d.FID = e.FLNKFADEPREENTRY  LEFT OUTER JOIN T_BD_PERIOD p ON D.FPERIOD = P.FID  where e.FFACURCARDID = '" + curCardid + "'  and p.FPERIODYEAR = " + periodInfo.getPeriodYear() + " and p.FPERIODNUMBER =  " + periodInfo.getPeriodNumber());
                rs1 = DbUtil.executeQuery((Context)ctx, (String)sql1.toString());
                while (rs1.next()) {
                    evalDepreciationSum1 = rs1.getBigDecimal("FDEVALEPRECIATION") == null ? this.ZERO : rs1.getBigDecimal("FDEVALEPRECIATION");
                }
                endAccuDeprCreditTyear = beginAccuDeprCreditTyear.add(newCardAccuDeprtTerm1).add(accuDeprChgTTerm1).add(depreciationSum1).add(evalDepreciationSum1);
                BigDecimal newCardAccuDeprtTerm = this.ZERO;
                BigDecimal newCardAccuDeprTYear = this.ZERO;
                StringBuffer sql6 = new StringBuffer();
                sql6.append("SELECT b.FACCUDEPR newCardAccuDeprtTerm, b.FACCUDEPRTYEAR newCardAccuDeprTYear FROM T_FA_FABakCARD b  LEFT OUTER JOIN T_BD_PERIOD p ON b.FPERIODID = P.FID  where b.FFACURCARDID = '" + curCardid + "' and FBillType = 1  and p.FPERIODYEAR = " + periodInfo.getPeriodYear() + " and p.FPERIODNUMBER =  " + periodInfo.getPeriodNumber());
                rs6 = DbUtil.executeQuery((Context)ctx, (String)sql6.toString());
                while (rs6.next()) {
                    newCardAccuDeprtTerm = rs6.getBigDecimal("newCardAccuDeprtTerm");
                    newCardAccuDeprTYear = rs6.getBigDecimal("newCardAccuDeprTYear");
                }
                BigDecimal addAccuDeprChgTTerm = this.ZERO;
                sql6.delete(0, sql6.length());
                sql6.append("SELECT sum(e.TACCUDEPRCHG) addAccuDeprChgTTerm FROM  T_FA_fachangebill b  LEFT OUTER JOIN T_BD_PERIOD p ON B.FPERIODID = P.FID  INNER JOIN T_FA_FACHANGEBILLENTRY e ON B.FID = e.FCHANGEBILLID  where e.FCURCARDID = '" + curCardid + "' and e.TACCUDEPRCHG > 0  and p.FPERIODYEAR = " + periodInfo.getPeriodYear() + " and p.FPERIODNUMBER =  " + periodInfo.getPeriodNumber());
                rs6 = DbUtil.executeQuery((Context)ctx, (String)sql6.toString());
                while (rs6.next()) {
                    addAccuDeprChgTTerm = rs6.getBigDecimal("addAccuDeprChgTTerm") == null ? this.ZERO : rs6.getBigDecimal("addAccuDeprChgTTerm");
                }
                BigDecimal lessAccuDeprChgTTerm = this.ZERO;
                sql6.delete(0, sql6.length());
                sql6.append("SELECT sum(e.TACCUDEPRCHG) lessAccuDeprChgTTerm FROM  T_FA_fachangebill b  LEFT OUTER JOIN T_BD_PERIOD p ON B.FPERIODID = P.FID  INNER JOIN T_FA_FACHANGEBILLENTRY e ON B.FID = e.FCHANGEBILLID  where e.FCURCARDID = '" + curCardid + "' and e.TACCUDEPRCHG < 0  and p.FPERIODYEAR = " + periodInfo.getPeriodYear() + " and p.FPERIODNUMBER =  " + periodInfo.getPeriodNumber());
                rs6 = DbUtil.executeQuery((Context)ctx, (String)sql6.toString());
                while (rs6.next()) {
                    lessAccuDeprChgTTerm = rs6.getBigDecimal("lessAccuDeprChgTTerm") == null ? this.ZERO : rs6.getBigDecimal("lessAccuDeprChgTTerm").abs();
                }
                BigDecimal accuDeprCleanTTerm = this.ZERO;
                sql6.delete(0, sql6.length());
                sql6.append("SELECT sum(e.FCLRADDUPDEP) accuDeprCleanTTerm FROM  T_FA_CLEARBILL b  LEFT OUTER JOIN T_BD_PERIOD p ON B.FPERIODID = P.FID  INNER JOIN T_FA_CLEARBILLENTRY e ON B.FID = e.FENTRYID  where e.FCURCARDID = '" + curCardid + "'  and p.FPERIODYEAR = " + periodInfo.getPeriodYear() + " and p.FPERIODNUMBER =  " + periodInfo.getPeriodNumber());
                rs6 = DbUtil.executeQuery((Context)ctx, (String)sql6.toString());
                while (rs6.next()) {
                    accuDeprCleanTTerm = rs6.getBigDecimal("accuDeprCleanTTerm") == null ? this.ZERO : rs6.getBigDecimal("accuDeprCleanTTerm");
                }
                BigDecimal addAccuDeprChgTYear = this.ZERO;
                sql6.delete(0, sql6.length());
                sql6.append("SELECT sum(z.FACCUDEPRTYEAR- k.FACCUDEPRTYEAR) as addAccuDeprChgTYear FROM  T_FA_FACHANGEBILL c  LEFT OUTER JOIN T_BD_PERIOD p ON C.FPERIODID = P.FID   INNER JOIN T_FA_FACHANGEBILLENTRY e ON C.FID = E.FCHANGEBILLID  INNER JOIN T_FA_FABIZCARD z on z.FID = e.FBIZCARDID  INNER JOIN T_FA_FABAKCARD k on k.FID = z.FFABAKCARDID  where e.FCURCARDID = '" + curCardid + "' and z.FACCUDEPRTYEAR- k.FACCUDEPRTYEAR > 0  and p.FPERIODYEAR = " + periodInfo.getPeriodYear() + " and p.FPERIODNUMBER =  " + periodInfo.getPeriodNumber());
                rs6 = DbUtil.executeQuery((Context)ctx, (String)sql6.toString());
                while (rs6.next()) {
                    addAccuDeprChgTYear = rs6.getBigDecimal("addAccuDeprChgTYear") == null ? this.ZERO : rs6.getBigDecimal("addAccuDeprChgTYear");
                }
                BigDecimal lessAccuDeprChgTYear = this.ZERO;
                sql6.delete(0, sql6.length());
                sql6.append("SELECT sum(z.FACCUDEPRTYEAR- k.FACCUDEPRTYEAR) as lessAccuDeprChgTYear FROM  T_FA_FACHANGEBILL c  LEFT OUTER JOIN T_BD_PERIOD p ON C.FPERIODID = P.FID   INNER JOIN T_FA_FACHANGEBILLENTRY e ON C.FID = E.FCHANGEBILLID  INNER JOIN T_FA_FABIZCARD z on z.FID = e.FBIZCARDID  INNER JOIN T_FA_FABAKCARD k on k.FID = z.FFABAKCARDID  where e.FCURCARDID = '" + curCardid + "' and z.FACCUDEPRTYEAR- k.FACCUDEPRTYEAR < 0  and p.FPERIODYEAR = " + periodInfo.getPeriodYear() + " and p.FPERIODNUMBER =  " + periodInfo.getPeriodNumber());
                rs6 = DbUtil.executeQuery((Context)ctx, (String)sql6.toString());
                while (rs6.next()) {
                    lessAccuDeprChgTYear = rs6.getBigDecimal("lessAccuDeprChgTYear") == null ? this.ZERO : rs6.getBigDecimal("lessAccuDeprChgTYear").abs();
                }
                BigDecimal accuDeprCleanTYear = this.ZERO;
                sql6.delete(0, sql6.length());
                if (faMonCardInfo.isHasDisabled() || DeletedStatusEnum.DELETED == faMonCardInfo.getDeletedStatus()) {
                    sql6.append("SELECT z.FACCUDEPRTYEAR as accuDeprCleanTYear FROM  T_FA_ClearBill c  LEFT OUTER JOIN T_BD_PERIOD p ON C.FPERIODID = P.FID   INNER JOIN T_FA_ClearBillENTRY e ON C.FID = E.FENTRYID  INNER JOIN T_FA_FABIZCARD z on z.FID = e.FBIZCARDID  INNER JOIN T_FA_FABAKCARD k on k.FID = z.FFABAKCARDID  where e.FCURCARDID = '" + curCardid + "' and e.FCLRQTY = k.FASSETAMT  and p.FPERIODYEAR = " + periodInfo.getPeriodYear() + " and p.FPERIODNUMBER =  " + periodInfo.getPeriodNumber());
                    rs6 = DbUtil.executeQuery((Context)ctx, (String)sql6.toString());
                    while (rs6.next()) {
                        accuDeprCleanTYear = rs6.getBigDecimal("accuDeprCleanTYear") == null ? this.ZERO : rs6.getBigDecimal("accuDeprCleanTYear");
                    }
                } else {
                    sql6.append("SELECT sum(k.FACCUDEPRTYEAR- z.FACCUDEPRTYEAR) as accuDeprCleanTYear FROM  T_FA_ClearBill c  LEFT OUTER JOIN T_BD_PERIOD p ON C.FPERIODID = P.FID   INNER JOIN T_FA_ClearBillENTRY e ON C.FID = E.FENTRYID  INNER JOIN T_FA_FABIZCARD z on z.FID = e.FBIZCARDID  INNER JOIN T_FA_FABAKCARD k on k.FID = z.FFABAKCARDID  where e.FCURCARDID = '" + curCardid + "' and e.FCLRQTY < k.FASSETAMT  and p.FPERIODYEAR = " + periodInfo.getPeriodYear() + " and p.FPERIODNUMBER =  " + periodInfo.getPeriodNumber());
                    rs6 = DbUtil.executeQuery((Context)ctx, (String)sql6.toString());
                    while (rs6.next()) {
                        accuDeprCleanTYear = rs6.getBigDecimal("accuDeprCleanTYear") == null ? this.ZERO : rs6.getBigDecimal("accuDeprCleanTYear");
                    }
                }
                BigDecimal AccuDeprChgTYear = newCardAccuDeprTYear.add(addAccuDeprChgTYear).subtract(lessAccuDeprChgTYear).subtract(accuDeprCleanTYear);
                paramsList.add(new Object[]{beginAddUpYearDepre, beginAccuDeprCreditTyear, accuDeprCleanTYear, AccuDeprChgTYear, endAccuDeprCreditTyear, newCardAccuDeprtTerm, addAccuDeprChgTTerm, lessAccuDeprChgTTerm, accuDeprCleanTTerm, newCardAccuDeprTYear, addAccuDeprChgTYear, lessAccuDeprChgTYear, fid});
            }
            if (paramsList.size() > 0) {
                DbUtil.executeBatch((Context)ctx, (String)updateSql, paramsList);
            }
        }
        catch (SQLException e) {
            throw new BOSException("Sql execute exception : ", (Throwable)e);
        }
        catch (Exception e1) {
            throw new BOSException("exception : ", (Throwable)e1);
        }
        finally {
            try {
                if (rs1 != null) {
                    rs1.close();
                }
                if (rs != null) {
                    rs.close();
                }
                if (rs6 != null) {
                    rs6.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    protected boolean isStartPeriod(PeriodInfo periodInfo) {
        boolean isStartPeriod = false;
        try {
            CompanyOrgUnitInfo aCompanyOrgUnitInfo = SysContext.getSysContext().getCurrentFIUnit();
            PeriodInfo startPeriodInfo = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)aCompanyOrgUnitInfo);
            if (periodInfo == null || startPeriodInfo == null) {
                String strMsg = EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardInitResource.FaCardPeriodIsNull");
                isStartPeriod = false;
            }
            isStartPeriod = periodInfo.getId().toString().equals(startPeriodInfo.getId().toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return isStartPeriod;
    }

    private void setAddUpYearDepre_VirtualBodySearch(Context ctx) throws BOSException {
        boolean usedepartment;
        StringBuffer sql = new StringBuffer();
        String total = ResourceBase.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"total2", (Locale)ctx.getOriginLocale());
        String subTotal = ResourceBase.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"subTotal", (Locale)ctx.getOriginLocale());
        sql.append("UPDATE ").append(this.tempTable).append(" SET (AddUpYearDepre,beginNetvalue,beginNetAmount,endNetAmount,endNetValue,RealBeginBalanceFor,RealEndBalanceFor,DepreBeginBalanceFor,DepreEndBalanceFor,DecValueBeginBalanceFor,DecValueEndBalanceFor) = ");
        sql.append(" (select AddUpYearDepre,beginNetvalue,beginNetAmount,endNetAmount,endNetValue,RealBeginBalanceFor,RealEndBalanceFor ,DepreBeginBalanceFor,DepreEndBalanceFor,DecValueBeginBalanceFor,DecValueEndBalanceFor from  \n");
        sql.append(" (select sum(AddUpYearDepre) AddUpYearDepre ,sum(beginNetvalue) beginNetvalue, sum(beginNetAmount) beginNetAmount ,sum(endNetAmount) endNetAmount ,sum(endNetValue) endNetValue,sum(RealBeginBalanceFor) RealBeginBalanceFor,sum(RealEndBalanceFor) RealEndBalanceFor   ,sum(DepreBeginBalanceFor) DepreBeginBalanceFor ,sum(DepreEndBalanceFor) DepreEndBalanceFor,sum(DecValueBeginBalanceFor) DecValueBeginBalanceFor,sum(DecValueEndBalanceFor) DecValueEndBalanceFor from ").append(this.tempTable);
        sql.append(" where periodlongnumber in (");
        sql.append(" SELECT max(PeriodLongNumber) from ").append(this.tempTable);
        sql.append(" WHERE PeriodLongNumber like '2%' ) and issum=1 ");
        boolean facat = this.isLevelSum("assetCat");
        boolean ecnomi = this.isLevelSum("assetCat") || this.isLevelSum("economicPurp");
        boolean usestatus = this.isLevelSum("assetCat") || this.isLevelSum("economicPurp") || this.isLevelSum("useStatus");
        boolean ourcemode = this.isLevelSum("assetCat") || this.isLevelSum("economicPurp") || this.isLevelSum("useStatus") || this.isLevelSum("originMethod");
        boolean bl = usedepartment = this.isLevelSum("assetCat") || this.isLevelSum("economicPurp") || this.isLevelSum("useStatus") || this.isLevelSum("originMethod") || this.isLevelSum("useDepartment");
        if (!(this.isLevelSum("assetCat") || this.isLevelSum("economicPurp") || this.isLevelSum("useStatus") || this.isLevelSum("originMethod") || this.isLevelSum("useDepartment") || this.isLevelSum("asstActItem") || facat || ecnomi || usestatus || ourcemode || usedepartment)) {
            sql.append("and fid=( select top 1 fid  from ").append(this.tempTable).append(" where periodname=(select max(periodname) periodname from ").append(this.tempTable).append(" where PeriodLongNumber like '2%' )").append("  and ISSUM=1  order by realbeginbalancefor desc )");
        }
        sql.append(this.getMinNo(subTotal));
        if (!usedepartment && !this.isLevelSum("asstActItem") && this.sumItemList != null) {
            int n = this.sumItemList.size();
            for (int i = 0; i < n; ++i) {
                FaSumOptnObject fsoo = (FaSumOptnObject)this.sumItemList.get(i);
                if (!fsoo.isSum() || !fsoo.getFieldName().toLowerCase(Locale.getDefault()).startsWith("def_")) continue;
                sql.append(" and " + fsoo.getFieldName() + "Name = '" + subTotal + "'");
                break;
            }
        }
        sql.append(" tmp )) where periodname = '" + total + "'");
        DbUtil.execute((Context)ctx, (String)FaLocalUtils.transformLocal((Context)ctx, (String)sql.toString()));
    }

    private void setAddUpYearDepreForDetail_VirtualBodySearch(Context ctx) throws BOSException {
        boolean usedepartment1;
        boolean bl = usedepartment1 = this.isLevelSum("assetCat") || this.isLevelSum("economicPurp") || this.isLevelSum("useStatus") || this.isLevelSum("originMethod") || this.isLevelSum("useDepartment") || this.isLevelSum("asstActItem");
        if (!usedepartment1) {
            boolean usedepartment;
            StringBuffer sql = new StringBuffer();
            String total = ResourceBase.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"total2", (Locale)ctx.getOriginLocale());
            String subTotal = ResourceBase.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"subTotal", (Locale)ctx.getOriginLocale());
            sql.append("UPDATE ").append(this.tempTable).append(" SET (AddUpYearDepre,beginNetvalue,beginNetAmount,endNetAmount,endNetValue,RealBeginBalanceFor,RealEndBalanceFor,DepreBeginBalanceFor,DepreEndBalanceFor,DecValueBeginBalanceFor,DecValueEndBalanceFor) = ");
            sql.append(" (select AddUpYearDepre,beginNetvalue,beginNetAmount,endNetAmount,endNetValue,RealBeginBalanceFor,RealEndBalanceFor ,DepreBeginBalanceFor,DepreEndBalanceFor,DecValueBeginBalanceFor,DecValueEndBalanceFor from  \n");
            sql.append(" (select sum(AddUpYearDepre) AddUpYearDepre ,sum(beginNetvalue) beginNetvalue, sum(beginNetAmount) beginNetAmount ,sum(endNetAmount) endNetAmount ,sum(endNetValue) endNetValue,sum(RealBeginBalanceFor) RealBeginBalanceFor,sum(RealEndBalanceFor) RealEndBalanceFor   ,sum(DepreBeginBalanceFor) DepreBeginBalanceFor ,sum(DepreEndBalanceFor) DepreEndBalanceFor,sum(DecValueBeginBalanceFor) DecValueBeginBalanceFor,sum(DecValueEndBalanceFor) DecValueEndBalanceFor from ").append(this.tempTable);
            sql.append(" where periodlongnumber in (");
            sql.append(" SELECT max(PeriodLongNumber) from ").append(this.tempTable);
            sql.append(" WHERE PeriodLongNumber like '2%' ) and issum=1 ");
            boolean facat = this.isDetailSum("assetCat");
            boolean ecnomi = this.isDetailSum("assetCat") || this.isDetailSum("economicPurp");
            boolean usestatus = this.isDetailSum("assetCat") || this.isDetailSum("economicPurp") || this.isDetailSum("useStatus");
            boolean address = this.isDetailSum("assetCat") || this.isDetailSum("economicPurp") || this.isDetailSum("useStatus") || this.isDetailSum("storeCity");
            boolean ourcemode = this.isDetailSum("assetCat") || this.isDetailSum("economicPurp") || this.isDetailSum("useStatus") || this.isDetailSum("originMethod") || this.isDetailSum("storeCity");
            boolean bl2 = usedepartment = this.isDetailSum("assetCat") || this.isDetailSum("economicPurp") || this.isDetailSum("useStatus") || this.isDetailSum("originMethod") || this.isDetailSum("useDepartment") || this.isDetailSum("storeCity");
            if (!(this.isLevelSum("assetCat") || this.isLevelSum("economicPurp") || this.isLevelSum("useStatus") || this.isLevelSum("originMethod") || this.isLevelSum("useDepartment") || this.isLevelSum("asstActItem") || facat || ecnomi || usestatus || address || ourcemode || usedepartment)) {
                sql.append("and fid=( select top 1 fid  from ").append(this.tempTable).append(" where periodname=(select  max(periodname) periodname from ").append(this.tempTable).append(" where PeriodLongNumber like '2%'  )").append("  and ISSUM=1  order by realbeginbalancefor desc )");
            }
            sql.append(this.getMinNoDetail(subTotal));
            if (!usedepartment && !this.isDetailSum("asstActItem") && this.sumItemList != null) {
                int n = this.sumItemList.size();
                for (int i = 0; i < n; ++i) {
                    FaSumOptnObject fsoo = (FaSumOptnObject)this.sumItemList.get(i);
                    if (!fsoo.isSum() || !fsoo.getFieldName().toLowerCase(Locale.getDefault()).startsWith("def_")) continue;
                    sql.append(" and " + fsoo.getFieldName() + "Name = '" + subTotal + "'");
                    break;
                }
            }
            sql.append(" tmp )) where periodname = '" + total + "'");
            DbUtil.execute((Context)ctx, (String)FaLocalUtils.transformLocal((Context)ctx, (String)sql.toString()));
        }
    }

    private void setAddUpYearDepre(Context ctx) throws BOSException {
        StringBuffer sql = new StringBuffer();
        String total = ResourceBase.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"total2", (Locale)ctx.getOriginLocale());
        String subTotal = ResourceBase.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"subTotal", (Locale)ctx.getOriginLocale());
        sql.append("UPDATE ").append(this.tempTable).append(" SET (AddUpYearDepre,beginNetvalue,beginNetAmount,endNetAmount,endNetValue,RealBeginBalanceFor,RealEndBalanceFor,DepreBeginBalanceFor,DepreEndBalanceFor,DecValueBeginBalanceFor,DecValueEndBalanceFor) = ");
        sql.append(" (select AddUpYearDepre,beginNetvalue,beginNetAmount,endNetAmount,endNetValue,RealBeginBalanceFor,RealEndBalanceFor ,DepreBeginBalanceFor,DepreEndBalanceFor,DecValueBeginBalanceFor,DecValueEndBalanceFor from  \n");
        sql.append(" (select sum(AddUpYearDepre) AddUpYearDepre ,sum(beginNetvalue) beginNetvalue, sum(beginNetAmount) beginNetAmount ,sum(endNetAmount) endNetAmount ,sum(endNetValue) endNetValue,sum(RealBeginBalanceFor) RealBeginBalanceFor,sum(RealEndBalanceFor) RealEndBalanceFor   ,sum(DepreBeginBalanceFor) DepreBeginBalanceFor ,sum(DepreEndBalanceFor) DepreEndBalanceFor,sum(DecValueBeginBalanceFor) DecValueBeginBalanceFor,sum(DecValueEndBalanceFor) DecValueEndBalanceFor from ").append(this.tempTable);
        sql.append(" where periodlongnumber in (");
        sql.append(" SELECT max(PeriodLongNumber) from ").append(this.tempTable);
        sql.append(" WHERE PeriodLongNumber like '2%' ) and issum=1 ");
        boolean facat = this.isLevelSum("assetCat");
        boolean ecnomi = this.isLevelSum("assetCat") || this.isLevelSum("economicPurp");
        boolean usestatus = this.isLevelSum("assetCat") || this.isLevelSum("economicPurp") || this.isLevelSum("useStatus");
        boolean ourcemode = this.isLevelSum("assetCat") || this.isLevelSum("economicPurp") || this.isLevelSum("useStatus") || this.isLevelSum("originMethod");
        boolean usedepartment = this.isLevelSum("assetCat") || this.isLevelSum("economicPurp") || this.isLevelSum("useStatus") || this.isLevelSum("originMethod") || this.isLevelSum("useDepartment");
        sql.append(this.getMinNo(subTotal));
        if (!usedepartment && !this.isLevelSum("asstActItem") && this.sumItemList != null) {
            int n = this.sumItemList.size();
            for (int i = 0; i < n; ++i) {
                FaSumOptnObject fsoo = (FaSumOptnObject)this.sumItemList.get(i);
                if (!fsoo.isSum() || !fsoo.getFieldName().toLowerCase(Locale.getDefault()).startsWith("def_")) continue;
                sql.append(" and " + fsoo.getFieldName() + "Name = '" + subTotal + "'");
                break;
            }
        }
        sql.append(" tmp )) where periodname = '" + total + "'");
        DbUtil.execute((Context)ctx, (String)FaLocalUtils.transformLocal((Context)ctx, (String)sql.toString()));
    }

    protected int isHasAsstActSum(String key) {
        if (this.sumItemList == null || key == null) {
            return 200;
        }
        int n = this.sumItemList.size();
        for (int i = 0; i < n; ++i) {
            FaSumOptnObject fsoo = (FaSumOptnObject)this.sumItemList.get(i);
            if (!fsoo.isSum() || !key.equals(fsoo.getFieldName()) || FaSumLevelEnum.level != fsoo.getLevelType() && FaSumLevelEnum.specified != fsoo.getLevelType()) continue;
            return fsoo.getOrderNo();
        }
        return 100;
    }

    protected String getMinNo(String subTotal) {
        String appString = " ";
        int j = 50;
        if (this.isHasAsstActSum("assetCat") < j) {
            j = this.isHasAsstActSum("assetCat");
            appString = " and ASSETCAT1NAME = '" + subTotal + "'";
        }
        if (this.isHasAsstActSum("economicPurp") < j) {
            j = this.isHasAsstActSum("economicPurp");
            appString = " and ECONOMICPURP1NAME = '" + subTotal + "'";
        }
        if (this.isHasAsstActSum("useStatus") < j) {
            j = this.isHasAsstActSum("useStatus");
            appString = " and USESTATUS1NAME = '" + subTotal + "'";
        }
        if (this.isHasAsstActSum("storeCity") < j) {
            j = this.isHasAsstActSum("storeCity");
            appString = " and STORECITY1NAME = '" + subTotal + "'";
        }
        if (this.isHasAsstActSum("originMethod") < j) {
            j = this.isHasAsstActSum("originMethod");
            appString = " and ORIGINMETHOD1NAME = '" + subTotal + "'";
        }
        if (this.isHasAsstActSum("useDepartment") < j) {
            j = this.isHasAsstActSum("useDepartment");
            appString = " and USEDEPARTMENT1NAME = '" + subTotal + "'";
        }
        if (this.isHasAsstActSum("asstActItem") < j) {
            j = this.isHasAsstActSum("asstActItem");
            appString = " and ASSTACTTYPENAME = '" + subTotal + "'";
        }
        return appString;
    }

    protected int isHasAsstActDetail(String key) {
        if (this.sumItemList == null || key == null) {
            return 100;
        }
        int n = this.sumItemList.size();
        for (int i = 0; i < n; ++i) {
            FaSumOptnObject fsoo = (FaSumOptnObject)this.sumItemList.get(i);
            if (!fsoo.isSum() || !key.equals(fsoo.getFieldName()) || FaSumLevelEnum.detail != fsoo.getLevelType()) continue;
            return fsoo.getOrderNo();
        }
        return 100;
    }

    protected String getMinNoDetail(String subTotal) {
        String appString = " ";
        int j = 50;
        if (this.isHasAsstActDetail("assetCat") < j) {
            j = this.isHasAsstActDetail("assetCat");
            appString = " and ASSETCATNAME = '" + subTotal + "'";
        }
        if (this.isHasAsstActDetail("economicPurp") < j) {
            j = this.isHasAsstActDetail("economicPurp");
            appString = " and ECONOMICPURPNAME = '" + subTotal + "'";
        }
        if (this.isHasAsstActDetail("useStatus") < j) {
            j = this.isHasAsstActDetail("useStatus");
            appString = " and USESTATUSNAME = '" + subTotal + "'";
        }
        if (this.isHasAsstActDetail("storeCity") < j) {
            j = this.isHasAsstActDetail("storeCity");
            appString = " and STORECITYNAME = '" + subTotal + "'";
        }
        if (this.isHasAsstActDetail("originMethod") < j) {
            j = this.isHasAsstActDetail("originMethod");
            appString = " and ORIGINMETHODNAME = '" + subTotal + "'";
        }
        if (this.isHasAsstActDetail("useDepartment") < j) {
            j = this.isHasAsstActDetail("useDepartment");
            appString = " and USEDEPARTMENTNAME = '" + subTotal + "'";
        }
        if (this.isHasAsstActDetail("asstActItem") < j) {
            j = this.isHasAsstActDetail("asstActItem");
            appString = " and ASSTACTTYPENAME = '" + subTotal + "'";
        }
        return appString;
    }

    private void setAddUpYearDepreForDetail(Context ctx) throws BOSException {
        boolean usedepartment1;
        boolean bl = usedepartment1 = this.isLevelSum("assetCat") || this.isLevelSum("economicPurp") || this.isLevelSum("useStatus") || this.isLevelSum("originMethod") || this.isLevelSum("useDepartment") || this.isLevelSum("asstActItem");
        if (!usedepartment1) {
            StringBuffer sql = new StringBuffer();
            String total = ResourceBase.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"total2", (Locale)ctx.getOriginLocale());
            String subTotal = ResourceBase.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"subTotal", (Locale)ctx.getOriginLocale());
            sql.append("UPDATE ").append(this.tempTable).append(" SET (AddUpYearDepre,beginNetvalue,beginNetAmount,endNetAmount,endNetValue,RealBeginBalanceFor,RealEndBalanceFor,DepreBeginBalanceFor,DepreEndBalanceFor,DecValueBeginBalanceFor,DecValueEndBalanceFor) = ");
            sql.append(" (select AddUpYearDepre,beginNetvalue,beginNetAmount,endNetAmount,endNetValue,RealBeginBalanceFor,RealEndBalanceFor ,DepreBeginBalanceFor,DepreEndBalanceFor,DecValueBeginBalanceFor,DecValueEndBalanceFor from  \n");
            sql.append(" (select sum(AddUpYearDepre) AddUpYearDepre ,sum(beginNetvalue) beginNetvalue, sum(beginNetAmount) beginNetAmount ,sum(endNetAmount) endNetAmount ,sum(endNetValue) endNetValue,sum(RealBeginBalanceFor) RealBeginBalanceFor,sum(RealEndBalanceFor) RealEndBalanceFor   ,sum(DepreBeginBalanceFor) DepreBeginBalanceFor ,sum(DepreEndBalanceFor) DepreEndBalanceFor,sum(DecValueBeginBalanceFor) DecValueBeginBalanceFor,sum(DecValueEndBalanceFor) DecValueEndBalanceFor from ").append(this.tempTable);
            sql.append(" where periodlongnumber in (");
            sql.append(" SELECT max(PeriodLongNumber) from ").append(this.tempTable);
            sql.append(" WHERE PeriodLongNumber like '2%' ) and issum=1 ");
            boolean facat = this.isDetailSum("assetCat");
            boolean ecnomi = this.isDetailSum("assetCat") || this.isDetailSum("economicPurp");
            boolean usestatus = this.isDetailSum("assetCat") || this.isDetailSum("economicPurp") || this.isDetailSum("useStatus");
            boolean address = this.isDetailSum("assetCat") || this.isDetailSum("economicPurp") || this.isDetailSum("useStatus") || this.isDetailSum("storeCity");
            boolean ourcemode = this.isDetailSum("assetCat") || this.isDetailSum("economicPurp") || this.isDetailSum("useStatus") || this.isDetailSum("originMethod") || this.isDetailSum("storeCity");
            boolean usedepartment = this.isDetailSum("assetCat") || this.isDetailSum("economicPurp") || this.isDetailSum("useStatus") || this.isDetailSum("originMethod") || this.isDetailSum("useDepartment") || this.isDetailSum("storeCity");
            sql.append(this.getMinNoDetail(subTotal));
            if (!usedepartment && !this.isDetailSum("asstActItem") && this.sumItemList != null) {
                int n = this.sumItemList.size();
                for (int i = 0; i < n; ++i) {
                    FaSumOptnObject fsoo = (FaSumOptnObject)this.sumItemList.get(i);
                    if (!fsoo.isSum() || !fsoo.getFieldName().toLowerCase(Locale.getDefault()).startsWith("def_")) continue;
                    sql.append(" and " + fsoo.getFieldName() + "Name = '" + subTotal + "'");
                    break;
                }
            }
            sql.append(" tmp )) where periodname = '" + total + "'");
            DbUtil.execute((Context)ctx, (String)FaLocalUtils.transformLocal((Context)ctx, (String)sql.toString()));
        }
    }

    private void setAddUpBeginDepreForDetail_VirtualBodySearch(Context ctx) throws BOSException {
        boolean usedepartment1;
        boolean bl = usedepartment1 = this.isLevelSum("assetCat") || this.isLevelSum("economicPurp") || this.isLevelSum("useStatus") || this.isLevelSum("originMethod") || this.isLevelSum("useDepartment") || this.isLevelSum("asstActItem");
        if (!usedepartment1) {
            boolean usedepartment;
            StringBuffer sql = new StringBuffer();
            String total = ResourceBase.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"total2", (Locale)ctx.getOriginLocale());
            String subTotal = ResourceBase.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"subTotal", (Locale)ctx.getOriginLocale());
            sql.append("UPDATE ").append(this.tempTable).append(" SET (RealBeginBalanceFor,DepreBeginBalanceFor,beginNetvalue,DecValueBeginBalanceFor,beginNetAmount) = ");
            sql.append(" (select RealBeginBalanceFor,DepreBeginBalanceFor,beginNetvalue,DecValueBeginBalanceFor,beginNetAmount  from  \n");
            sql.append(" (select sum(RealBeginBalanceFor) RealBeginBalanceFor,sum(DepreBeginBalanceFor) DepreBeginBalanceFor, sum(beginNetvalue) beginNetvalue ,sum(DecValueBeginBalanceFor) DecValueBeginBalanceFor ,sum(beginNetAmount) beginNetAmount from ").append(this.tempTable);
            sql.append(" where periodlongnumber in (");
            sql.append(" SELECT min(PeriodLongNumber) from ").append(this.tempTable);
            sql.append(" WHERE PeriodLongNumber like '2%' ) and issum=1 ");
            boolean facat = this.isDetailSum("assetCat");
            boolean ecnomi = this.isDetailSum("assetCat") || this.isDetailSum("economicPurp");
            boolean usestatus = this.isDetailSum("assetCat") || this.isDetailSum("economicPurp") || this.isDetailSum("useStatus");
            boolean address = this.isDetailSum("assetCat") || this.isDetailSum("economicPurp") || this.isDetailSum("useStatus") || this.isDetailSum("storeCity");
            boolean ourcemode = this.isDetailSum("assetCat") || this.isDetailSum("economicPurp") || this.isDetailSum("useStatus") || this.isDetailSum("originMethod") || this.isDetailSum("storeCity");
            boolean bl2 = usedepartment = this.isDetailSum("assetCat") || this.isDetailSum("economicPurp") || this.isDetailSum("useStatus") || this.isDetailSum("originMethod") || this.isDetailSum("useDepartment") || this.isDetailSum("storeCity");
            if (!(this.isLevelSum("assetCat") || this.isLevelSum("economicPurp") || this.isLevelSum("useStatus") || this.isLevelSum("originMethod") || this.isLevelSum("useDepartment") || this.isLevelSum("asstActItem") || facat || ecnomi || usestatus || address || ourcemode || usedepartment)) {
                sql.append("and fid=( select top 1 fid  from ").append(this.tempTable).append(" where periodname=(select  min(periodname) periodname from ").append(this.tempTable).append(" where PeriodLongNumber like '2%'  )").append("  and ISSUM=1  order by realbeginbalancefor desc )");
            }
            sql.append(this.getMinNoDetail(subTotal));
            if (!usedepartment && !this.isDetailSum("asstActItem") && this.sumItemList != null) {
                int n = this.sumItemList.size();
                for (int i = 0; i < n; ++i) {
                    FaSumOptnObject fsoo = (FaSumOptnObject)this.sumItemList.get(i);
                    if (!fsoo.isSum() || !fsoo.getFieldName().toLowerCase(Locale.getDefault()).startsWith("def_")) continue;
                    sql.append(" and " + fsoo.getFieldName() + "Name = '" + subTotal + "'");
                    break;
                }
            }
            sql.append(" tmp )) where periodname = '" + total + "'");
            DbUtil.execute((Context)ctx, (String)FaLocalUtils.transformLocal((Context)ctx, (String)sql.toString()));
        }
    }

    private void setAddUpBeginBalanceDepre(Context ctx) throws BOSException {
        StringBuffer sql = new StringBuffer();
        String total = ResourceBase.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"total2", (Locale)ctx.getOriginLocale());
        String subTotal = ResourceBase.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"subTotal", (Locale)ctx.getOriginLocale());
        sql.append("UPDATE ").append(this.tempTable).append(" SET (RealBeginBalanceFor,DepreBeginBalanceFor,beginNetvalue,DecValueBeginBalanceFor,beginNetAmount) = ");
        sql.append(" (select RealBeginBalanceFor,DepreBeginBalanceFor,beginNetvalue,DecValueBeginBalanceFor,beginNetAmount from  \n");
        sql.append(" (select sum(RealBeginBalanceFor) RealBeginBalanceFor,sum(DepreBeginBalanceFor) DepreBeginBalanceFor, sum(beginNetvalue) beginNetvalue ,sum(DecValueBeginBalanceFor) DecValueBeginBalanceFor ,sum(beginNetAmount) beginNetAmount from ").append(this.tempTable);
        sql.append(" where periodlongnumber in (");
        sql.append(" SELECT min(PeriodLongNumber) from ").append(this.tempTable);
        sql.append(" WHERE PeriodLongNumber like '2%' ) and issum=1 ");
        boolean facat = this.isLevelSum("assetCat");
        boolean ecnomi = this.isLevelSum("assetCat") || this.isLevelSum("economicPurp");
        boolean usestatus = this.isLevelSum("assetCat") || this.isLevelSum("economicPurp") || this.isLevelSum("useStatus");
        boolean ourcemode = this.isLevelSum("assetCat") || this.isLevelSum("economicPurp") || this.isLevelSum("useStatus") || this.isLevelSum("originMethod");
        boolean usedepartment = this.isLevelSum("assetCat") || this.isLevelSum("economicPurp") || this.isLevelSum("useStatus") || this.isLevelSum("originMethod") || this.isLevelSum("useDepartment");
        sql.append(this.getMinNo(subTotal));
        if (!usedepartment && !this.isLevelSum("asstActItem") && this.sumItemList != null) {
            int n = this.sumItemList.size();
            for (int i = 0; i < n; ++i) {
                FaSumOptnObject fsoo = (FaSumOptnObject)this.sumItemList.get(i);
                if (!fsoo.isSum() || !fsoo.getFieldName().toLowerCase(Locale.getDefault()).startsWith("def_")) continue;
                sql.append(" and " + fsoo.getFieldName() + "Name = '" + subTotal + "'");
                break;
            }
        }
        sql.append(" tmp )) where periodname = '" + total + "'");
        DbUtil.execute((Context)ctx, (String)FaLocalUtils.transformLocal((Context)ctx, (String)sql.toString()));
        logger.debug((Object)sql.toString());
    }

    private void setAddUpBeginDepreForDetail(Context ctx) throws BOSException {
        boolean usedepartment1;
        boolean bl = usedepartment1 = this.isLevelSum("assetCat") || this.isLevelSum("economicPurp") || this.isLevelSum("useStatus") || this.isLevelSum("originMethod") || this.isLevelSum("useDepartment") || this.isLevelSum("asstActItem");
        if (!usedepartment1) {
            StringBuffer sql = new StringBuffer();
            String total = ResourceBase.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"total2", (Locale)ctx.getOriginLocale());
            String subTotal = ResourceBase.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"subTotal", (Locale)ctx.getOriginLocale());
            sql.append("UPDATE ").append(this.tempTable).append(" SET (RealBeginBalanceFor,DepreBeginBalanceFor,beginNetvalue,DecValueBeginBalanceFor,beginNetAmount) = ");
            sql.append(" (select RealBeginBalanceFor,DepreBeginBalanceFor,beginNetvalue,DecValueBeginBalanceFor,beginNetAmount from  \n");
            sql.append(" (select sum(RealBeginBalanceFor) RealBeginBalanceFor,sum(DepreBeginBalanceFor) DepreBeginBalanceFor, sum(beginNetvalue) beginNetvalue ,sum(DecValueBeginBalanceFor) DecValueBeginBalanceFor ,sum(beginNetAmount) beginNetAmount from ").append(this.tempTable);
            sql.append(" where periodlongnumber in (");
            sql.append(" SELECT min(PeriodLongNumber) from ").append(this.tempTable);
            sql.append(" WHERE PeriodLongNumber like '2%' ) and issum=1 ");
            boolean facat = this.isDetailSum("assetCat");
            boolean ecnomi = this.isDetailSum("assetCat") || this.isDetailSum("economicPurp");
            boolean usestatus = this.isDetailSum("assetCat") || this.isDetailSum("economicPurp") || this.isDetailSum("useStatus");
            boolean address = this.isDetailSum("assetCat") || this.isDetailSum("economicPurp") || this.isDetailSum("useStatus") || this.isDetailSum("storeCity");
            boolean ourcemode = this.isDetailSum("assetCat") || this.isDetailSum("economicPurp") || this.isDetailSum("useStatus") || this.isDetailSum("originMethod") || this.isDetailSum("storeCity");
            boolean usedepartment = this.isDetailSum("assetCat") || this.isDetailSum("economicPurp") || this.isDetailSum("useStatus") || this.isDetailSum("originMethod") || this.isDetailSum("useDepartment") || this.isDetailSum("storeCity");
            sql.append(this.getMinNoDetail(subTotal));
            if (!usedepartment && !this.isDetailSum("asstActItem") && this.sumItemList != null) {
                int n = this.sumItemList.size();
                for (int i = 0; i < n; ++i) {
                    FaSumOptnObject fsoo = (FaSumOptnObject)this.sumItemList.get(i);
                    if (!fsoo.isSum() || !fsoo.getFieldName().toLowerCase(Locale.getDefault()).startsWith("def_")) continue;
                    sql.append(" and " + fsoo.getFieldName() + "Name = '" + subTotal + "'");
                    break;
                }
            }
            sql.append(" tmp )) where periodname = '" + total + "'");
            DbUtil.execute((Context)ctx, (String)FaLocalUtils.transformLocal((Context)ctx, (String)sql.toString()));
        }
    }

    private void setAddUpBeginDepre_VirtualBodySearch(Context ctx) throws BOSException {
        boolean usedepartment;
        StringBuffer sql = new StringBuffer();
        String total = ResourceBase.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"total2", (Locale)ctx.getOriginLocale());
        String subTotal = ResourceBase.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"subTotal", (Locale)ctx.getOriginLocale());
        sql.append("UPDATE ").append(this.tempTable).append(" SET (RealBeginBalanceFor,DepreBeginBalanceFor,beginNetvalue,DecValueBeginBalanceFor,beginNetAmount) = ");
        sql.append(" (select RealBeginBalanceFor,DepreBeginBalanceFor,beginNetvalue,DecValueBeginBalanceFor,beginNetAmount from  \n");
        sql.append(" (select sum(RealBeginBalanceFor) RealBeginBalanceFor,sum(DepreBeginBalanceFor) DepreBeginBalanceFor, sum(beginNetvalue) beginNetvalue ,sum(DecValueBeginBalanceFor) DecValueBeginBalanceFor ,sum(beginNetAmount) beginNetAmount from ").append(this.tempTable);
        sql.append(" where periodlongnumber in (");
        sql.append(" SELECT min(PeriodLongNumber) from ").append(this.tempTable);
        sql.append(" WHERE PeriodLongNumber like '2%' ) and issum=1 ");
        boolean facat = this.isLevelSum("assetCat");
        boolean ecnomi = this.isLevelSum("assetCat") || this.isLevelSum("economicPurp");
        boolean usestatus = this.isLevelSum("assetCat") || this.isLevelSum("economicPurp") || this.isLevelSum("useStatus");
        boolean ourcemode = this.isLevelSum("assetCat") || this.isLevelSum("economicPurp") || this.isLevelSum("useStatus") || this.isLevelSum("originMethod");
        boolean bl = usedepartment = this.isLevelSum("assetCat") || this.isLevelSum("economicPurp") || this.isLevelSum("useStatus") || this.isLevelSum("originMethod") || this.isLevelSum("useDepartment");
        if (!(this.isLevelSum("assetCat") || this.isLevelSum("economicPurp") || this.isLevelSum("useStatus") || this.isLevelSum("originMethod") || this.isLevelSum("useDepartment") || this.isLevelSum("asstActItem") || facat || ecnomi || usestatus || ourcemode || usedepartment)) {
            sql.append("and fid=( select top 1 fid  from ").append(this.tempTable).append(" where periodname=(select min(periodname) periodname from ").append(this.tempTable).append(" where PeriodLongNumber like '2%' )").append("  and ISSUM=1  order by realbeginbalancefor desc )");
        }
        sql.append(this.getMinNo(subTotal));
        if (!usedepartment && !this.isLevelSum("asstActItem") && this.sumItemList != null) {
            int n = this.sumItemList.size();
            for (int i = 0; i < n; ++i) {
                FaSumOptnObject fsoo = (FaSumOptnObject)this.sumItemList.get(i);
                if (!fsoo.isSum() || !fsoo.getFieldName().toLowerCase(Locale.getDefault()).startsWith("def_")) continue;
                sql.append(" and " + fsoo.getFieldName() + "Name = '" + subTotal + "'");
                break;
            }
        }
        sql.append(" tmp )) where periodname = '" + total + "'");
        DbUtil.execute((Context)ctx, (String)FaLocalUtils.transformLocal((Context)ctx, (String)sql.toString()));
    }

    @Override
    protected void initEvVar(EntityViewInfo ev) throws EASBizException, BOSException {
        super.initEvVar(ev);
        Map cond = (Map)ev.get("customcond");
        this.deprZeroCard = (Boolean)cond.get("deprZeroCard");
        this.cleanCard = (Boolean)cond.get("cleanCard");
        this.allCleanCard = (Boolean)cond.get("allCleanCard");
        this.isListStyle = (Boolean)cond.get("sumstyle") == false;
        this.isShowNotAudit = (Boolean)cond.get("isShowNotAudit");
        this.displayEvalData = (Boolean)cond.get("displayEvalData");
        this.displayDepMultipData = cond.get("displayDepMultipData") == null ? false : (Boolean)cond.get("displayDepMultipData");
    }

    private String getSelectResultSql() {
        StringBuffer sql = new StringBuffer();
        if (this.isListStyle) {
            if (!this.sumOption.isHasFaCatSum()) {
                sql.append(" ASSETCAT_NAME, ");
                sql.append(" ASSETCAT_NUMBER, ");
            }
            sql.append(" ASSETNUMBER, ");
            sql.append(" oldNumber, ");
            sql.append(" GROUPNUMBER, ");
            sql.append(" ASSETNAME, ");
            sql.append(" SPECS, ");
            sql.append(" USETERMCOUNT, ");
            sql.append(" DEPRTERMCOUNT, ");
            sql.append(" DEPRMETHOD_NAME, ");
            sql.append(" DEPRMETHOD_NUMBER,");
            sql.append(" MonthDepreRate, ");
        }
        sql.append("CardID, ");
        sql.append("RealBeginBalanceFor, ");
        sql.append("DepreBeginBalanceFor, ");
        sql.append("beginNetvalue, ");
        sql.append("DecValueBeginBalanceFor, ");
        sql.append("beginNetAmount, ");
        sql.append("OriginDif, ");
        sql.append("AccuDeprChg, ");
        sql.append("DecValueChg, ");
        sql.append("ShouldDepre, ");
        sql.append("Depreciation, ");
        sql.append("AddUpYearDepre, ");
        sql.append("RealEndBalanceFor, ");
        sql.append("DepreEndBalanceFor, ");
        sql.append("endNetValue, ");
        sql.append("DecValueEndBalanceFor, ");
        sql.append("endNetAmount,");
        sql.append("BASEPREC,");
        sql.append("IsSum");
        if (this.displayDepMultipData) {
            sql.append(",beginAddUpYearDepre");
            sql.append(",beginAccuDeprCreditTyear");
            sql.append(",newCardAccuDeprTTerm");
            sql.append(",addAccuDeprChgTTerm");
            sql.append(",lessAccuDeprChgTTerm");
            sql.append(",accuDeprCleanTTerm");
            sql.append(",newCardAccuDeprTYear");
            sql.append(",addAccuDeprChgTYear");
            sql.append(",lessAccuDeprChgTYear");
            sql.append(",accuDeprCleanTYear");
            sql.append(",AccuDeprChgTYear");
            sql.append(",endAccuDeprCreditTyear ");
            sql.append(",AccuDeprChg as AccuDeprChg1 ");
        }
        sql.append(this.def.getSelectPart(""));
        if (this.isVirCompany) {
            sql.append(", SumLevel ");
        }
        return sql.toString();
    }

    private String getSumSelectSql() {
        StringBuffer sql = new StringBuffer();
        if (this.isListStyle) {
            if (!this.sumOption.isHasFaCatSum()) {
                sql.append("TO_CHAR(null) AS ASSETCAT_NAME, ");
                sql.append("TO_CHAR(null) AS ASSETCAT_NUMBER, ");
            }
            sql.append("TO_CHAR(null) AS ASSETNUMBER, ");
            sql.append("TO_CHAR(null) AS OLDNUMBER, ");
            sql.append("TO_CHAR(null) AS GROUPNUMBER, ");
            sql.append("TO_CHAR(null) AS ASSETNAME, ");
            sql.append("TO_CHAR(null) AS SPECS, ");
            sql.append("TO_DECIMAL(null) AS USETERMCOUNT, ");
            sql.append("TO_DECIMAL(null) DEPRTERMCOUNT, ");
            sql.append("TO_CHAR(null) AS DEPRMETHOD_NAME, ");
            sql.append("TO_CHAR(null) AS DEPRMETHOD_NUMBER,");
            sql.append("TO_DECIMAL(null) MonthDepreRate, ");
        }
        sql.append("TO_CHAR(null) AS CardID, ");
        sql.append("TO_CHAR(null) AS PERIODID, ");
        sql.append("SUM(RealBeginBalanceFor) AS RealBeginBalanceFor, ");
        sql.append("SUM(DepreBeginBalanceFor) AS DepreBeginBalanceFor, ");
        sql.append("SUM(beginNetvalue) AS beginNetvalue, ");
        sql.append("SUM(DecValueBeginBalanceFor) AS DecValueBeginBalanceFor, ");
        sql.append("SUM(beginNetAmount) AS beginNetAmount, ");
        sql.append("SUM(OriginDif) AS OriginDif, ");
        sql.append("SUM(AccuDeprChg) AS AccuDeprChg, ");
        sql.append("SUM(DecValueChg) AS DecValueChg, ");
        sql.append("SUM(ShouldDepre) AS ShouldDepre, ");
        sql.append("SUM(Depreciation) AS Depreciation, ");
        sql.append("SUM(AddUpYearDepre) AS AddUpYearDepre, ");
        sql.append("SUM(RealEndBalanceFor) AS RealEndBalanceFor, ");
        sql.append("SUM(DepreEndBalanceFor) AS DepreEndBalanceFor, ");
        sql.append("SUM(endNetValue) AS endNetValue, ");
        sql.append("SUM(DecValueEndBalanceFor) AS DecValueEndBalanceFor, ");
        sql.append("SUM(endNetAmount) AS endNetAmount,");
        sql.append("TO_INT(null) AS BASEPREC,");
        sql.append("1 AS isSum ");
        if (this.displayDepMultipData) {
            sql.append(", SUM(beginAddUpYearDepre) AS beginAddUpYearDepre ");
            sql.append(", SUM(beginAccuDeprCreditTyear) AS beginAccuDeprCreditTyear ");
            sql.append(", SUM(newCardAccuDeprTTerm) AS newCardAccuDeprTTerm ");
            sql.append(", SUM(addAccuDeprChgTTerm) AS addAccuDeprChgTTerm ");
            sql.append(", SUM(lessAccuDeprChgTTerm) AS lessAccuDeprChgTTerm ");
            sql.append(", SUM(accuDeprCleanTTerm) AS accuDeprCleanTTerm ");
            sql.append(", SUM(newCardAccuDeprTYear) AS newCardAccuDeprTYear ");
            sql.append(", SUM(addAccuDeprChgTYear) AS addAccuDeprChgTYear ");
            sql.append(", SUM(lessAccuDeprChgTYear) AS lessAccuDeprChgTYear ");
            sql.append(", SUM(accuDeprCleanTYear) AS accuDeprCleanTYear ");
            sql.append(", SUM(AccuDeprChgTYear) AS AccuDeprChgTYear ");
            sql.append(", SUM(endAccuDeprCreditTyear) AS endAccuDeprCreditTyear ");
        }
        sql.append(this.def.getSelectSumPart(""));
        return sql.toString();
    }

    protected String getSumSqlDistinctSelect() {
        StringBuffer sql = new StringBuffer();
        sql.append("CardID, ");
        sql.append("RealBeginBalanceFor, ");
        sql.append("DepreBeginBalanceFor, ");
        sql.append("beginNetvalue, ");
        sql.append("DecValueBeginBalanceFor, ");
        sql.append("beginNetAmount, ");
        sql.append("OriginDif, ");
        sql.append("AccuDeprChg, ");
        sql.append("DecValueChg, ");
        sql.append("ShouldDepre, ");
        sql.append("Depreciation, ");
        sql.append("AddUpYearDepre, ");
        sql.append("RealEndBalanceFor, ");
        sql.append("DepreEndBalanceFor, ");
        sql.append("endNetValue, ");
        sql.append("DecValueEndBalanceFor, ");
        sql.append("endNetAmount");
        if (this.displayDepMultipData) {
            sql.append(",beginAddUpYearDepre");
            sql.append(",beginAccuDeprCreditTyear");
            sql.append(",newCardAccuDeprTTerm");
            sql.append(",addAccuDeprChgTTerm");
            sql.append(",lessAccuDeprChgTTerm");
            sql.append(",accuDeprCleanTTerm");
            sql.append(",newCardAccuDeprTYear");
            sql.append(",addAccuDeprChgTYear");
            sql.append(",lessAccuDeprChgTYear");
            sql.append(",accuDeprCleanTYear");
            sql.append(",AccuDeprChgTYear");
            sql.append(",endAccuDeprCreditTyear ");
        }
        sql.append(this.def.getNumFieldForSumPart());
        return sql.toString();
    }

    @Override
    protected String buildSorterSql(EntityViewInfo ev) {
        Pattern pattern;
        StringBuffer sorterSql = new StringBuffer();
        if (this.sumOption != null) {
            if (this.sumOption.isHasSum()) {
                sorterSql.append(this.sumOption.getOrderFields().toString()).append(", ");
            }
            if (this.isVirCompany) {
                sorterSql.append(" SumLevel , ").append(" isSum DESC");
            } else {
                sorterSql.append(" isSum");
            }
        }
        if (!this.isListStyle) {
            return sorterSql.toString();
        }
        SorterItemCollection sorters = ev.getSorter();
        for (SorterItemInfo sorterItem : sorters) {
            if (sorterItem.getPropertyName().equals("USERDEFINENAME")) continue;
            sorterSql.append(", ");
            sorterSql.append(sorterItem.toString());
        }
        StringBuffer sortAll = new StringBuffer(sorterSql.toString());
        if (!(ev.getSorter().toString() != null && ev.getSorter().toString().trim().length() != 0 || this.isLevelSum("assetCat"))) {
            sortAll.append(",assetCat.fname_l2 ASC,ASSETNUMBER asc");
        }
        String sql = sortAll.toString();
        if (this.sumOption.isHasSum()) {
            if (!this.isLevelSum("assetCat") && this.sumOption.getStrSelectResult().indexOf("assetCat1Name") != -1 && this.sumOption.getStrSelectResult().indexOf("assetCat2Name") != -1) {
                sql = sql.replaceAll(",assetCat.fname_l2 ASC", "");
                sql = sql.replaceAll(",assetCat.fname_l2 DESC", "");
            }
            if (this.isLevelSum("assetCat")) {
                sql = sql.replaceAll("assetCat.fname_l2", " ASSETNUMBER  ");
            }
        }
        sql = sql.replaceAll("FDepreciation", "Depreciation");
        sql = sql.replaceAll("useYears", "USETERMCOUNT");
        sql = sql.replaceAll("deprMethod.fname_" + this.ctx.getLocale().toString(), "DEPRMETHOD_NAME");
        sql = !this.sumOption.isHasFaCatSum() ? sql.replaceAll("assetCat.fname_l2", "ASSETCAT_NUMBER") : (!(pattern = Pattern.compile("^.*ASSETNUMBER.*", 2)).matcher(sql).matches() ? sql.replaceAll("assetCat.fname_l2", " ASSETNUMBER  ") : sql.replaceAll("assetCat.fname_l2 ASC,", ""));
        sql = this.modifyDefSorterPartSql(sql);
        return sql;
    }

    private String getDeprDetailSql() throws BOSException {
        int start;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT ");
        if (this.isSpecLevelSum("asstActItem") || this.isSpecLevelSum("useDepartment")) {
            sql.append(" DISTINCT ");
        }
        if (this.sumOption.isHasSum()) {
            sql.append(this.sumOption.getStrNameFields() + ", ");
        }
        if (this.isListStyle) {
            if (!this.sumOption.isHasFaCatSum()) {
                sql.append("ASSETCAT.FName_L2 AS ASSETCAT_NAME, ");
                sql.append("assetCat.FNumber AS ASSETCAT_NUMBER, ");
            }
            sql.append("a.ASSETNUMBER,a.oldNumber, a.GROUPNUMBER ,a.assetname, a.SPECS, a.USETERMCOUNT, a.DEPRTERMCOUNT, ");
            sql.append("DEPRMETHOD.FName_" + this.ctx.getLocale().toString() + " AS DEPRMETHOD_NAME, ");
            sql.append("DEPRMETHOD.FNumber AS DEPRMETHOD_NUMBER, ");
            sql.append("a.FMonthDepreRate AS MonthDepreRate, ");
        }
        sql.append("a.fcardid as CardID,");
        sql.append("a.PERIODID,");
        sql.append("a.FrealBeginBalanceFor AS RealBeginBalanceFor, ");
        sql.append("a.FDepreBeginBalanceFor AS DepreBeginBalanceFor, ");
        sql.append("(a.FrealBeginBalanceFor - a.FDepreBeginBalanceFor) as beginNetvalue, ");
        sql.append("a.FDecValueBeginBalanceFor AS DecValueBeginBalanceFor, ");
        sql.append("(a.FrealBeginBalanceFor - a.FDepreBeginBalanceFor - a.FDecValueBeginBalanceFor) as beginNetAmount, ");
        sql.append("a.FOriginDif AS OriginDif, ");
        sql.append("a.FAccuDeprChg AS AccuDeprChg, ");
        sql.append("a.FDecValueChg AS DecValueChg, ");
        sql.append("a.FShouldDepre AS ShouldDepre, ");
        sql.append("a.FDepreciation AS Depreciation, ");
        sql.append("a.FaddUpYearDepre AS AddUpYearDepre, ");
        sql.append("a.FRealEndBalanceFor AS RealEndBalanceFor, ");
        sql.append("a.FDepreEndBalanceFor AS DepreEndBalanceFor, ");
        sql.append("(a.FRealEndBalanceFor - a.FDepreEndBalanceFor) as endNetValue, ");
        sql.append("a.FDecValueEndBalanceFor AS DecValueEndBalanceFor, ");
        sql.append("(a.FRealEndBalanceFor - a.FDepreEndBalanceFor - a.FDecValueEndBalanceFor) as endNetAmount,");
        sql.append("BASECURRENCY.FPrecision AS BASEPREC, ");
        sql.append("0 AS ISSUM ");
        if (this.displayDepMultipData) {
            sql.append(",0 AS beginAddUpYearDepre");
            sql.append(",0 AS beginAccuDeprCreditTyear");
            sql.append(",0 AS newCardAccuDeprTTerm");
            sql.append(",0 AS addAccuDeprChgTTerm");
            sql.append(",0 AS lessAccuDeprChgTTerm");
            sql.append(",0 AS accuDeprCleanTTerm");
            sql.append(",0 AS newCardAccuDeprTYear");
            sql.append(",0 AS addAccuDeprChgTYear");
            sql.append(",0 AS lessAccuDeprChgTYear");
            sql.append(",0 AS accuDeprCleanTYear");
            sql.append(",0 AS AccuDeprChgTYear");
            sql.append(",0 AS endAccuDeprCreditTyear");
        }
        sql.append(this.def.getSelectPart(""));
        if (this.isVirCompany) {
            sql.append(",COMPANY.FLevel AS SumLevel");
        }
        if (this.sumOption.isHasSum()) {
            sql.append(", ").append(this.sumOption.getStrLongNumberFields());
        }
        sql.append(" FROM (");
        StringBuffer deprSql = new StringBuffer();
        if (!this.isVirCompany && this.startYear == this.endYear && this.startNumber == this.endNumber) {
            if (this.isCurrentPeriod(this.ctx, this.currCompanyInfo, this.startYear, this.startNumber)) {
                deprSql.append(this.getDepredDetail(true));
            } else {
                deprSql.append(this.getDepredDetail(false));
            }
        } else {
            deprSql.append(this.getDepredDetail(true));
            deprSql.append(" UNION ALL ");
            deprSql.append(this.getDepredDetail(false));
        }
        if (this.deprZeroCard) {
            if (!this.isVirCompany && this.startYear == this.endYear && this.startNumber == this.endNumber) {
                if (this.isCurrentPeriod(this.ctx, this.currCompanyInfo, this.startYear, this.startNumber)) {
                    deprSql.append(" UNION ALL ");
                    deprSql.append(this.getUnDeprCard(true));
                } else {
                    deprSql.append(" UNION ALL ");
                    deprSql.append(this.getUnDeprCard(false));
                }
            } else {
                deprSql.append(" UNION ALL ");
                deprSql.append(this.getUnDeprCard(true));
                deprSql.append(" UNION ALL ");
                deprSql.append(this.getUnDeprCard(false));
            }
        }
        sql.append(deprSql);
        sql.append(") a");
        sql.append(this.getJoinSql());
        while (sql.indexOf("Period.FNumber") != -1) {
            start = sql.indexOf("Period.FNumber");
            sql.replace(start, start + "Period.FNumber".length(), "(TO_CHAR(Period.FPeriodYear) ||'-'|| TO_CHAR(Period.FPeriodNumber+10))");
        }
        while (sql.indexOf("Period.FName_" + this.ctx.getLocale().toString()) != -1) {
            start = sql.indexOf("Period.FName_" + this.ctx.getLocale().toString());
            sql.replace(start, start + ("Period.FName_" + this.ctx.getLocale().toString()).length(), "(TO_CHAR(Period.FPeriodYear) ||'-'|| TO_CHAR(Period.FPeriodNumber))");
        }
        String filt = "";
        if (this.filter != null) {
            filt = " where " + this.filter;
        }
        return "select newbosid('00000000') as fid,t.* from (" + sql.toString() + filt + ") as t ";
    }

    private boolean isCurrentPeriod(Context ctx, CompanyOrgUnitInfo currCompanyInfo, int startYear, int startNumber) throws BOSException {
        PeriodInfo currentPeriod;
        try {
            currentPeriod = FaLocalUtils.getCurrentPeriod((Context)ctx, (String)currCompanyInfo.getId().toString());
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
        return currentPeriod.getPeriodYear() == startYear && currentPeriod.getPeriodNumber() == startNumber;
    }

    @Override
    protected String modifyDefFilterSql(String f) {
        return this.def.property2FieldAtFilterByWrapped(f);
    }

    @Override
    protected String modifyDefSorterPartSql(String sorterSqlPart) {
        return super.modifyDefSorterPartSql(sorterSqlPart);
    }

    private StringBuffer getUnDeprCard(boolean isCurrPeriod) {
        StringBuffer sql = new StringBuffer();
        boolean hasCostCenter = this.isSum("asstActItem") || this.filter != null && (this.filter.indexOf("asstActItem.fname_l2") != -1 || this.filter.indexOf("asstActType.fnumber") != -1);
        boolean hasUseDepartMent = this.isSum("useDepartment") || this.filter != null && this.filter.indexOf("useDepartment.fnumber") != -1;
        sql.append("SELECT ");
        sql.append(" DISTINCT ");
        if (hasCostCenter) {
            sql.append(" to_char(COMPOSIT.FAsstActItem) AS FAsstActItem, COMPOSIT.FAsstActtype AS FAsstActtypeID,");
        }
        sql.append("0 as FMonthDepreRate, 0 as FShouldDepre, 0 as FDepreciation, ");
        sql.append("d.FrealBeginBalanceFor,");
        sql.append("d.FRealEndBalanceFor,");
        sql.append("d.fevaluebeginbalancefor as FEVALUEBEGINBALANCEFOR,");
        sql.append("d.fevalueendbalancefor as FEVALUEENDBALANCEFOR,");
        sql.append("d.FDepreBeginBalanceFor AS FDepreBeginBalanceFor, ");
        sql.append("case when c.fbizStatus = '0499' or c.fbizStatus = '0599' then 0 else d.FDepreEndBalanceFor end AS FDepreEndBalanceFor, ");
        sql.append("d.FDecValueBeginBalanceFor, d.FDecValueEndBalanceFor, ");
        sql.append("period.fid as PERIODID, ");
        if (hasUseDepartMent) {
            sql.append("faUseDepartment.fusedepartmentid as FUseDepartmentID, ");
        }
        if (this.displayEvalData) {
            sql.append("case when (c.fperiodid = period.fid and (c.foriginFlag = ").append(2).append(" or c.foriginFlag = ").append(3).append(")) or (cb.fcleardate < period.fbeginDate and (c.fbizStatus = '0499' or c.fbizStatus = '0599')) then 0 else c.FEvalYearDepr end AS FaddUpYearDepre, ");
        } else {
            sql.append("case when (c.fperiodid = period.fid and (c.foriginFlag = ").append(2).append(" or c.foriginFlag = ").append(3).append(")) or (cb.fcleardate < period.fbeginDate and (c.fbizStatus = '0499' or c.fbizStatus = '0599')) then 0 else c.FAccuDeprTYear end AS FaddUpYearDepre, ");
        }
        if (this.displayEvalData) {
            sql.append("d.FRealEndBalanceFor-d.FRealBeginBalanceFor as FOriginDif, ");
            sql.append("d.FDepreEndBalanceFor-d.FDepreBeginBalanceFor as FAccuDeprChg, ");
            sql.append("d.FDecValueEndBalanceFor-d.FDecValueBeginBalanceFor as FDecValueChg, ");
        } else {
            sql.append("c.FOriginDif, c.FAccuDeprChg, c.FDecValueChg, ");
        }
        sql.append("c.FNumber AS ASSETNUMBER, ");
        sql.append("c.FoldNumber AS oldNumber, ");
        sql.append("c.FGroupNumber AS GROUPNUMBER, ");
        sql.append("c.FAssetName AS ASSETNAME, ");
        sql.append("c.FAssetAmt AS ASSETAMT, ");
        sql.append("c.FAccountDate AS ACCOUNTDATE, ");
        if (this.displayEvalData) {
            sql.append("c.FEvalReInAccountDate AS FIACCOUNTDATE, ");
        } else {
            sql.append("c.FFiAccountDate AS FIACCOUNTDATE, ");
        }
        sql.append("c.FEconomicPurpID, ");
        sql.append("c.FSpecs AS SPECS, ");
        sql.append("c.FPArea AS PAREA, ");
        sql.append("c.FMfr AS MFR, ");
        sql.append("c.FLevFrDate AS LEVFRDATE, ");
        sql.append("c.FOriginUnit AS ORIGINUNIT, ");
        sql.append("c.FPaperNo AS PAPERNO, ");
        sql.append("c.FExRate AS EXRATE, ");
        sql.append("c.FOriginAmt AS ORIGINAMT, ");
        sql.append("c.FAddons AS ADDONS, ");
        if (this.displayEvalData) {
            sql.append("c.FEvalAssetValue AS ASSETVALUE, ");
        } else {
            sql.append("c.FAssetValue AS ASSETVALUE, ");
        }
        sql.append("c.FBuyValue AS BUYVALUE, ");
        sql.append("c.FBuyAccuDepr AS BUYACCUDEPR, ");
        sql.append("c.FDeliverDate AS DELIVERDATE, ");
        sql.append("c.FStartUseDate AS STARTUSEDATE, ");
        sql.append("c.FUseYears AS USEYEARS, ");
        if (this.displayEvalData) {
            sql.append("c.FEvalUseTermCount AS USETERMCOUNT, ");
            sql.append("c.FEvalDeprPeriodNum AS DEPRTERMCOUNT, ");
            sql.append("(c.FEvalUseTermCount - c.FEvalDeprPeriodNum) AS LEFTTERMCONT, ");
            sql.append("c.FEvalAddDepr AS ACCUDEPR, ");
            sql.append("c.FEvalYearDepr AS ACCUDEPRTYEAR, ");
            sql.append("c.FEvalRemValue AS NEATREMVALUE, ");
            sql.append("c.FEvalNeatValue AS NEATVALUE, ");
            sql.append("c.FEvalDecValue AS DECVALUE, ");
            sql.append("c.FEvalNeatAmt AS NEATAMT, ");
        } else {
            sql.append("c.FUseTermCount AS USETERMCOUNT, ");
            sql.append("c.FDeprTermCount AS DEPRTERMCOUNT, ");
            sql.append("(c.FUseTermCount - c.FDeprTermCount) AS LEFTTERMCONT, ");
            sql.append("c.FAccuDepr AS ACCUDEPR, ");
            sql.append("c.FAccuDeprTYear AS ACCUDEPRTYEAR, ");
            sql.append("c.FNeatRemValue AS NEATREMVALUE, ");
            sql.append("c.FNeatValue AS NEATVALUE, ");
            sql.append("c.FDecValue AS DECVALUE, ");
            sql.append("c.FNeatAmt AS NEATAMT, ");
        }
        sql.append("c.FRemark AS REMARK, ");
        sql.append("c.FCheckedStatus AS CHECKEDSTATUS, ");
        sql.append("c.FHasChanged AS HASCHANGED, ");
        sql.append("c.FHasCleared AS HASCLEARED, ");
        if (this.displayEvalData) {
            sql.append("c.FEvalDeprModeID as FDeprMethodID, c.FEvalMeasureUnitWL as FMeasureUnitWLID, c.FCurrencyID, c.FKeeperID, ");
        } else {
            sql.append("c.FDeprMethodID, c.FMeasureUnitWLID, c.FCurrencyID, c.FKeeperID, ");
        }
        sql.append("c.FDeptID, c.FAssetCatID, c.FMeasureUnitID, c.FOriginMethodID, ");
        sql.append("c.FUseStatusID, c.FStoreCityID, c.fid as fcardid, c.FCompanyID, ");
        if (this.displayEvalData) {
            sql.append("c.FDeletedStatus as DeletedStatus, (c.FEvalAssetValue - c.FEvalAddDepr - c.FEvalRemValue - c.FEvalDecValue) as FNotDepre ");
        } else {
            sql.append("c.FDeletedStatus as DeletedStatus, (c.FAssetValue - c.FAccuDepr - c.FNeatRemValue - c.FDecValue) as FNotDepre ");
        }
        sql.append(this.def.getSelectPart(null));
        sql.append("from ");
        if (isCurrPeriod) {
            sql.append(" t_fa_facurcard as c");
            if (hasCostCenter) {
                sql.append(" INNER JOIN T_FA_FaCurCostCenter costcenter on costcenter.ffacurcardid = c.fid");
                sql.append(" LEFT OUTER JOIN T_FA_FACURASSTACTCOMPOSIT COMPOSIT ON COMPOSIT.FFACURCOSTCENTERID = costcenter.FID");
            }
            if (this.displayEvalData) {
                sql.append(" INNER JOIN T_FA_FaEvalAccountBalance AS d on c.fid = d.cardid and fevaluebeginbalancefor is not  null ");
            } else {
                sql.append(" INNER JOIN T_FA_FaAccountBalance AS d on c.fid = d.FFaCurCardID");
            }
            if (hasUseDepartMent) {
                sql.append(" INNER JOIN T_FA_FaCurDepartment").append(" AS faUseDepartment ON c.fid = faUseDepartment.FFaCurCardID");
            }
            sql.append(" left outer join t_fa_clearbillentry ce on ce.fcurcardid = c.fid ");
            sql.append(" left outer join t_fa_clearbill cb on cb.fid = ce.fentryid ");
        } else {
            sql.append(" t_fa_famoncard as c");
            if (hasCostCenter) {
                sql.append(" INNER JOIN T_FA_FaMonCostCenter costcenter on costcenter.ffamoncardid = c.fid");
                sql.append(" LEFT OUTER JOIN T_FA_FAMonASSTACTCOMPOSIT COMPOSIT ON COMPOSIT.FFAMonCOSTCENTERID = costcenter.FID");
            }
            if (this.displayEvalData) {
                sql.append(" INNER JOIN T_FA_FaEvalAccountBalance AS d on c.FFaCurCardID = d.cardid and c.FFaPeriodID = d.curpid");
            } else {
                sql.append(" INNER JOIN T_FA_FaAccountBalance AS d on c.FFaCurCardID = d.FFaCurCardID and c.FFaPeriodID = d.FPeriodID");
            }
            if (hasUseDepartMent) {
                sql.append(" INNER JOIN T_FA_FaMonDepartment").append(" AS faUseDepartment ON c.fid = faUseDepartment.FFaMonCardID");
            }
            sql.append(" left outer join t_fa_clearbillentry ce on ce.fcurcardid = c.ffacurcardid ");
            sql.append(" left outer join t_fa_clearbill cb on cb.fid = ce.fentryid ");
        }
        sql.append(" INNER JOIN T_FA_Cat t ON c.fassetcatid = t.fid");
        if (isCurrPeriod) {
            sql.append(" INNER JOIN T_BD_SystemStatusCtrol AS ssc on (c.FCompanyID = ssc.FCompanyID)");
            sql.append(" INNER JOIN T_BD_SystemStatus ss ON (ssc.FsystemStatusID = ss.FID").append(" AND ss.FName = ").append("14)");
            if (this.displayEvalData) {
                sql.append(" INNER JOIN T_BD_Period AS period on (d.curpid = period.FID and period.FID = ssc.FCurrentPeriodID)");
            } else if (this.displayEvalData) {
                sql.append(" INNER JOIN T_BD_Period AS period on (d.curpid = period.FID and period.FID = ssc.FCurrentPeriodID)");
            } else {
                sql.append(" INNER JOIN T_BD_Period AS period on (d.FPeriodID = period.FID and period.FID = ssc.FCurrentPeriodID)");
            }
        } else if (this.displayEvalData) {
            sql.append(" INNER JOIN T_BD_Period AS period on c.FFaPeriodID = period.FID");
        } else {
            sql.append(" INNER JOIN T_BD_Period AS period on c.FFaPeriodID = period.FID");
        }
        try {
            sql.append(this.def.getJoinPart("c.FPropertyValueId"));
        }
        catch (Exception e) {
            logger.error((Object)"error!");
            throw new RuntimeException(e);
        }
        sql.append(" where c.FCompanyID in (").append(this.strCompanyInclude).append(")");
        sql.append(this.getPeriodCond(isCurrPeriod));
        sql.append(" and not exists(");
        if (this.displayEvalData) {
            sql.append("select b.ffacurcardid from t_fa_faevaldepreciation AS a");
            sql.append(" LEFT OUTER JOIN t_fa_faevaldepreciationentry AS b on (a.fid = b.FLnkFaDepreEntry)");
        } else {
            sql.append("select b.ffacurcardid from t_fa_fadepreciation AS a");
            sql.append(" LEFT OUTER JOIN t_fa_fadepreciationentry AS b on (a.fid = b.FLnkFaDepreEntry)");
        }
        sql.append(" where a.FCompanyID in (").append(this.strCompanyInclude).append(")");
        sql.append(" and a.FPeriod = period.FID");
        if (!this.displayEvalData) {
            sql.append(" and a.FDepType != 2 ");
        }
        sql.append(" and b.ffacurcardid = ");
        if (isCurrPeriod) {
            sql.append("c.fid");
        } else {
            sql.append("c.FFaCurCardID");
        }
        sql.append(")");
        sql.append(this.getCondSql(false));
        sql.append(" and c.FLaterPeriodData = 0");
        return sql;
    }

    private StringBuffer getDepredDetail(boolean isCurrPeriod) {
        boolean hasCostCenter = this.isSum("asstActItem") || this.filter != null && (this.filter.indexOf("asstActItem.fname_l2") != -1 || this.filter.indexOf("asstActType.fnumber") != -1);
        boolean hasUseDepartMent = this.isSum("useDepartment") || this.filter != null && this.filter.indexOf("useDepartment.fnumber") != -1;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT ");
        if (hasCostCenter || hasUseDepartMent) {
            sql.append(" DISTINCT ");
        }
        if (hasCostCenter) {
            sql.append(" to_char(COMPOSIT.FAsstActItem) AS FAsstActItem, COMPOSIT.FasstactTypeID AS FAsstActtypeID,");
        }
        sql.append("b.FMonthDepreRate, ");
        if (this.displayEvalData) {
            sql.append("b.FShouldDepre as FShouldDepre, ");
            sql.append("b.FDepreciation as FDepreciation, ");
        } else {
            sql.append("b.FShouldDepre - b.FWellCost as FShouldDepre, ");
            sql.append("b.FDepreciation - b.FWellCost as FDepreciation, ");
        }
        sql.append("d.FrealBeginBalanceFor,");
        sql.append("d.FRealEndBalanceFor,");
        sql.append("d.fevaluebeginbalancefor as FEVALUEBEGINBALANCEFOR,");
        sql.append("d.fevalueendbalancefor as FEVALUEENDBALANCEFOR,");
        sql.append("d.FDepreBeginBalanceFor, ");
        if (this.displayEvalData) {
            sql.append("d.FDepreEndBalanceFor as FDepreEndBalanceFor, ");
        } else {
            sql.append("d.FDepreBeginBalanceFor + c.FAccuDeprChg + b.FDepreciation - b.FWellCost as FDepreEndBalanceFor, ");
        }
        sql.append("d.FDecValueBeginBalanceFor, d.FDecValueEndBalanceFor, ");
        sql.append("a.Fperiod as PERIODID, ");
        if (hasUseDepartMent) {
            sql.append("faUseDepartment.fusedepartmentid as FUseDepartmentID, ");
        }
        if (this.displayEvalData) {
            sql.append("c.FEvalYearDepr - c.FEvalDeprTTerm + b.FDepreciation as FaddUpYearDepre, ");
        } else {
            sql.append("c.FAccuDeprTYear - c.FDeprTTerm + b.FDepreciation as FaddUpYearDepre, ");
        }
        if (this.displayEvalData) {
            sql.append("d.FRealEndBalanceFor-d.FRealBeginBalanceFor as FOriginDif, ");
            sql.append("d.FDepreEndBalanceFor-d.FDepreBeginBalanceFor-c.fevaldeprtterm as FAccuDeprChg, ");
            sql.append("d.FDecValueEndBalanceFor-d.FDecValueBeginBalanceFor as FDecValueChg, ");
        } else {
            sql.append("c.FOriginDif, c.FAccuDeprChg, c.FDecValueChg, ");
        }
        sql.append("c.FNumber AS ASSETNUMBER, ");
        sql.append("c.FoldNumber AS oldNumber, ");
        sql.append("c.FGroupNumber AS GROUPNUMBER, ");
        sql.append("c.FAssetName AS ASSETNAME, ");
        sql.append("c.FAssetAmt AS ASSETAMT, ");
        sql.append("c.FAccountDate AS ACCOUNTDATE, ");
        if (this.displayEvalData) {
            sql.append("c.FEvalReInAccountDate AS FIACCOUNTDATE, ");
        } else {
            sql.append("c.FFiAccountDate AS FIACCOUNTDATE, ");
        }
        sql.append("c.FEconomicPurpID, ");
        sql.append("c.FSpecs AS SPECS, ");
        sql.append("c.FPArea AS PAREA, ");
        sql.append("c.FMfr AS MFR, ");
        sql.append("c.FLevFrDate AS LEVFRDATE, ");
        sql.append("c.FOriginUnit AS ORIGINUNIT, ");
        sql.append("c.FPaperNo AS PAPERNO, ");
        sql.append("c.FExRate AS EXRATE, ");
        sql.append("c.FOriginAmt AS ORIGINAMT, ");
        sql.append("c.FAddons AS ADDONS, ");
        if (this.displayEvalData) {
            sql.append("c.FEvalAssetValue AS ASSETVALUE, ");
        } else {
            sql.append("c.FAssetValue AS ASSETVALUE, ");
        }
        sql.append("c.FBuyValue AS BUYVALUE, ");
        sql.append("c.FBuyAccuDepr AS BUYACCUDEPR, ");
        sql.append("c.FDeliverDate AS DELIVERDATE, ");
        sql.append("c.FStartUseDate AS STARTUSEDATE, ");
        sql.append("c.FUseYears AS USEYEARS, ");
        if (this.displayEvalData) {
            sql.append("c.FEvalUseTermCount AS USETERMCOUNT, ");
            sql.append("c.FEvalDeprPeriodNum AS DEPRTERMCOUNT, ");
            sql.append("(c.FEvalUseTermCount - c.FEvalDeprPeriodNum) AS LEFTTERMCONT, ");
            sql.append("c.FEvalAddDepr AS ACCUDEPR, ");
            sql.append("c.FEvalYearDepr AS ACCUDEPRTYEAR, ");
            sql.append("c.FEvalRemValue AS NEATREMVALUE, ");
            sql.append("c.FEvalNeatValue AS NEATVALUE, ");
            sql.append("c.FEvalDecValue AS DECVALUE, ");
            sql.append("c.FEvalNeatAmt AS NEATAMT, ");
        } else {
            sql.append("c.FUseTermCount AS USETERMCOUNT, ");
            sql.append("c.FDeprTermCount AS DEPRTERMCOUNT, ");
            sql.append("(c.FUseTermCount - c.FDeprTermCount) AS LEFTTERMCONT, ");
            sql.append("c.FAccuDepr AS ACCUDEPR, ");
            sql.append("c.FAccuDeprTYear AS ACCUDEPRTYEAR, ");
            sql.append("c.FNeatRemValue AS NEATREMVALUE, ");
            sql.append("c.FNeatValue AS NEATVALUE, ");
            sql.append("c.FDecValue AS DECVALUE, ");
            sql.append("c.FNeatAmt AS NEATAMT, ");
        }
        sql.append("c.FRemark AS REMARK, ");
        sql.append("c.FCheckedStatus AS CHECKEDSTATUS, ");
        sql.append("c.FHasChanged AS HASCHANGED, ");
        sql.append("c.FHasCleared AS HASCLEARED, ");
        if (this.displayEvalData) {
            sql.append("c.FEvalDeprModeID as FDeprMethodID, c.FEvalMeasureUnitWL as FMeasureUnitWLID, c.FCurrencyID, c.FKeeperID, ");
        } else {
            sql.append("c.FDeprMethodID, c.FMeasureUnitWLID, c.FCurrencyID, c.FKeeperID, ");
        }
        sql.append("c.FDeptID, c.FAssetCatID, c.FMeasureUnitID, c.FOriginMethodID, ");
        sql.append("c.FUseStatusID, c.FStoreCityID, c.fid as fcardid, c.FCompanyID, ");
        sql.append("c.FDeletedStatus as DeletedStatus, b.FNotDepre ");
        sql.append(this.def.getSelectPart(null));
        if (this.displayEvalData) {
            sql.append("from t_fa_faevaldepreciation AS a");
            sql.append(" LEFT OUTER JOIN t_fa_faevaldepreciationentry AS b on (a.fid = b.FLnkFaDepreEntry)");
        } else {
            sql.append("from t_fa_fadepreciation AS a");
            sql.append(" LEFT OUTER JOIN t_fa_fadepreciationentry AS b on (a.fid = b.FLnkFaDepreEntry)");
        }
        if (isCurrPeriod) {
            sql.append(" INNER JOIN T_BD_SystemStatusCtrol AS ssc on (a.FCompanyID = ssc.FCompanyID)");
            sql.append(" INNER JOIN T_BD_SystemStatus ss ON (ssc.FsystemStatusID = ss.FID").append(" AND ss.FName = ").append("14)");
            sql.append(" INNER JOIN T_BD_Period AS period on (a.Fperiod = period.FID and period.FID = ssc.FCurrentPeriodID)");
        } else {
            sql.append(" INNER JOIN T_BD_Period AS period on (a.Fperiod = period.FID)");
        }
        sql.append(" INNER JOIN ");
        if (isCurrPeriod) {
            sql.append("t_fa_facurcard AS c on (b.ffacurcardid = c.fid").append(this.getCondSql(true)).append(")");
            if (hasCostCenter) {
                sql.append(" INNER JOIN T_FA_FaDepDistribute costcenter on costcenter.FDepEntryID = b.fid");
                sql.append(" LEFT OUTER JOIN T_FA_FaDepAsstActComposit COMPOSIT ON COMPOSIT.fbillid = costcenter.FID");
            }
            if (hasUseDepartMent) {
                sql.append(" INNER JOIN T_FA_FaCurDepartment").append(" AS faUseDepartment ON c.fid = faUseDepartment.FFaCurCardID");
            }
        } else {
            sql.append("t_fa_famoncard AS c on (b.ffacurcardid = c.ffacurcardid and a.Fperiod = c.FFaPeriodID and c.FFaPeriodID = period.fid ").append(this.getCondSql(true)).append(")");
            if (hasCostCenter) {
                sql.append(" INNER JOIN T_FA_FaDepDistribute costcenter on costcenter.FDepEntryID = b.fid");
                sql.append(" LEFT OUTER JOIN T_FA_FaDepAsstActComposit COMPOSIT ON COMPOSIT.fbillid = costcenter.FID");
            }
            if (hasUseDepartMent) {
                sql.append(" INNER JOIN T_FA_FaMonDepartment").append(" AS faUseDepartment ON c.fid = faUseDepartment.FFaMonCardID");
            }
        }
        if (this.displayEvalData) {
            sql.append(" INNER JOIN T_FA_FaEvalAccountBalance AS d on b.ffacurcardid = d.cardid and a.Fperiod = d.curpid and d.curpid = period.fid");
        } else {
            sql.append(" INNER JOIN T_FA_FaAccountBalance AS d on b.ffacurcardid = d.FFaCurCardID and a.Fperiod = d.FPeriodID and d.FPeriodID = period.fid");
        }
        try {
            sql.append(this.def.getJoinPart("c.FPropertyValueId"));
        }
        catch (Exception e) {
            logger.error((Object)"error!");
            throw new RuntimeException(e);
        }
        sql.append(" where a.FCompanyID in (").append(this.strCompanyInclude).append(")");
        sql.append(this.getPeriodCond(isCurrPeriod));
        if (!this.displayEvalData) {
            sql.append(" and a.FDepType != 2 ");
        }
        sql.append(" and c.FLaterPeriodData = 0");
        return sql;
    }

    private String getJoinSql() {
        String tableName;
        StringBuffer sql = new StringBuffer();
        sql.append(" LEFT OUTER JOIN T_FA_DepreciationMode AS DEPRMETHOD ON a.FDeprMethodID = DEPRMETHOD.FID ");
        sql.append(" LEFT OUTER JOIN T_BD_Address AS ").append("storeCity").append(" ON a.FStoreCityID = ").append("storeCity").append(".FID ");
        sql.append(" LEFT OUTER JOIN T_BD_MeasureUnit AS MEASUREUNITWL ON a.FMeasureUnitWLID = MEASUREUNITWL.FID ");
        sql.append(" LEFT OUTER JOIN T_BD_Person AS KEEPER ON a.FKeeperID = KEEPER.FID ");
        sql.append(" LEFT OUTER JOIN T_ORG_Admin AS DEPT ON a.FDeptID = DEPT.FID ");
        sql.append(" LEFT OUTER JOIN T_BD_MeasureUnit AS MEASUREUNIT ON a.FMeasureUnitID = MEASUREUNIT.FID ");
        sql.append(" INNER JOIN T_ORG_Company AS COMPANY ON a.FCompanyID = COMPANY.FID ");
        sql.append(" INNER JOIN T_BD_Currency AS BASECURRENCY ON COMPANY.FBaseCurrencyID = BASECURRENCY.FID ");
        sql.append(" INNER JOIN T_BD_Period AS PERIOD ON a.PERIODID = PERIOD.FID");
        if (this.isVirCompany && (tableName = this.getSumItemJoinSql("orgArchitecture")) != null) {
            sql.append(" INNER JOIN ").append(tableName).append(" AS ").append("orgArchitecture");
            sql.append(" ON a.FCompanyID = ").append("orgArchitecture").append(".FID");
        }
        tableName = this.isLevelSum("assetCat") ? this.getSumItemJoinSql("assetCat") : this.getSumItemTableName("assetCat");
        sql.append(" INNER JOIN ").append(tableName).append(" AS ").append("assetCat");
        sql.append(" ON a.FAssetCatID = ").append("assetCat").append(".FID");
        tableName = this.isLevelSum("originMethod") ? this.getSumItemJoinSql("originMethod") : this.getSumItemTableName("originMethod");
        sql.append(" INNER JOIN ").append(tableName).append(" AS ").append("originMethod");
        sql.append(" ON a.FOriginMethodID = ").append("originMethod").append(".FID");
        tableName = this.isLevelSum("useStatus") ? this.getSumItemJoinSql("useStatus") : this.getSumItemTableName("useStatus");
        sql.append(" INNER JOIN ").append(tableName).append(" AS ").append("useStatus");
        sql.append(" ON a.FUseStatusID = ").append("useStatus").append(".FID");
        tableName = this.isLevelSum("economicPurp") ? this.getSumItemJoinSql("economicPurp") : this.getSumItemTableName("economicPurp");
        sql.append(" INNER JOIN ").append(tableName).append(" AS ").append("economicPurp");
        sql.append(" ON a.FEconomicPurpID = ").append("economicPurp").append(".FID");
        if (this.isSum("useDepartment") || this.filter != null && this.filter.indexOf("useDepartment.fnumber") != -1) {
            tableName = this.isLevelSum("useDepartment") ? this.getSumItemJoinSql("useDepartment") : this.getSumItemTableName("useDepartment");
            sql.append(" INNER JOIN ").append(tableName).append(" AS ").append("useDepartment");
            sql.append(" ON a.FUseDepartmentID = ").append("useDepartment").append(".FID");
        }
        if (this.isSum("asstActItem") || this.filter != null && (this.filter.indexOf("asstActItem.fname_l2") != -1 || this.filter.indexOf("asstActType.fnumber") != -1)) {
            tableName = this.isLevelSum("asstActItem") ? this.getSumItemJoinSql("asstActItem") : this.getSumItemTableName("asstActItem");
            sql.append(" LEFT OUTER JOIN ").append(tableName).append(" AS ").append("asstActItem");
            sql.append(" ON a.FAsstActTypeID = ").append("asstActItem").append(".FAsstacttypeID");
            sql.append(" and a.FAsstActItem = ").append("asstActItem").append(".FID");
            sql.append(" LEFT OUTER JOIN ").append(this.getSumItemTableName("asstActType")).append(" AS ").append("asstActType");
            sql.append(" ON ").append("asstActItem").append(".FAsstActTypeID = ").append("asstActType").append(".FID");
        }
        return sql.toString();
    }

    private String getCondSql(boolean flag) {
        StringBuffer sql = new StringBuffer();
        if (!(this.deprZeroCard || this.cleanCard || this.allCleanCard)) {
            sql.append(" and (b.FDepreciation " + (this.displayEvalData ? "" : "- b.FWellCost") + ") != 0 and c.FCheckedStatus = 2 and c.FHasCleared != 2 and c.FDeletedStatus != 2");
        } else if (this.deprZeroCard && !this.cleanCard && !this.allCleanCard) {
            sql.append(" and c.FCheckedStatus = 2 and c.FHasCleared != 2 and c.FDeletedStatus != 2");
        } else if (!this.deprZeroCard && this.cleanCard && !this.allCleanCard) {
            sql.append(" and (b.FDepreciation " + (this.displayEvalData ? "" : "- b.FWellCost") + ") != 0 and ((c.FCheckedStatus = 2 and c.FDeletedStatus != 2) or (c.FHasCleared = 2 and c.FDeletedStatus = 2))");
        } else if (this.deprZeroCard && this.cleanCard && !this.allCleanCard) {
            sql.append(" and ((c.FCheckedStatus = 2 and c.FDeletedStatus != 2) or (c.FHasCleared = 2 and c.FDeletedStatus = 2))");
        } else if (this.deprZeroCard && this.cleanCard && this.allCleanCard) {
            sql.append(" and (c.FCheckedStatus = 2)");
        } else if (!this.deprZeroCard && this.cleanCard && this.allCleanCard) {
            sql.append(" and (b.FDepreciation " + (this.displayEvalData ? "" : "- b.FWellCost") + ") != 0 and c.FCheckedStatus = 2");
        } else if (this.deprZeroCard && !this.cleanCard && this.allCleanCard) {
            sql.append(" and (c.FCheckedStatus = 2)");
        } else if (!this.deprZeroCard && !this.cleanCard && this.allCleanCard) {
            sql.append(" and (b.FDepreciation " + (this.displayEvalData ? "" : "- b.FWellCost") + ") != 0 and c.FCheckedStatus = 2");
        }
        if (!this.isShowNotAudit && flag) {
            sql.append(" and b.FState = 3");
        }
        return sql.toString();
    }

    private String getPeriodCond(boolean isCurrPeriod) {
        StringBuffer sql = new StringBuffer();
        if (this.startYear == this.endYear) {
            sql.append(" AND period.FPeriodYear = ? ");
            this.params.addInt(this.startYear);
            if (this.startNumber == this.endNumber) {
                sql.append(" AND period.FPeriodNumber = ? ");
                this.params.addInt(this.startNumber);
            } else {
                sql.append(" AND period.FPeriodNumber >= ? and period.FPeriodNumber <= ? ");
                if (!isCurrPeriod && this.currPeriod.getPeriodNumber() == this.endNumber) {
                    --this.endNumber;
                }
                this.params.addInt(this.startNumber);
                this.params.addInt(this.endNumber);
            }
        } else {
            sql.append(" AND (period.FPeriodYear>? or (period.FPeriodYear=? and period.FPeriodNumber >= ?))");
            sql.append(" AND (period.FPeriodYear<? or (period.FPeriodYear=? and period.FPeriodNumber <= ?))");
            this.params.addInt(this.startYear);
            this.params.addInt(this.startYear);
            this.params.addInt(this.startNumber);
            this.params.addInt(this.endYear);
            this.params.addInt(this.endYear);
            this.params.addInt(this.endNumber);
        }
        return sql.toString();
    }

    protected void deleteUnnecessaryData() throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("DELETE FROM ");
        sql.append(this.tempTable);
        sql.append(" WHERE ISSUM=0 ");
        DbUtil.execute((Context)this.ctx, (String)sql.toString());
    }

    private void buildResultSql() {
        StringBuffer sql = new StringBuffer();
        if (this.sumOption.isHasSum()) {
            sql.append(this.sumOption.getStrSelectResult() + ", ");
        }
        sql.append(this.getSelectResultSql());
        this.resultSql.setSelect(sql.toString());
        this.resultSql.setFrom(this.tempTable);
        this.resultSql.setOrder(this.sorter);
    }

    @Override
    protected String getFirstDisplayField() {
        return this.isListStyle ? "ASSETNUMBER" : null;
    }

    @Override
    public void init(Context ctx, EntityViewInfo ev) throws EASBizException, BOSException {
        ObjectUuidPK pk = new ObjectUuidPK(ContextUtil.getCurrentOrgUnit((Context)ctx).getId());
        HashMap<String, ObjectUuidPK> paramKeyMap = new HashMap<String, ObjectUuidPK>();
        paramKeyMap.put("FA_025", pk);
        this.hmParam = ParamManager.getParamHashMap((Context)ctx, paramKeyMap);
        super.init(ctx, ev);
    }

    @Override
    protected String buildFilterSql(EntityViewInfo ev) {
        FilterInfo filterInfo = ev.getFilter();
        if (filterInfo == null || filterInfo.getFilterItems() == null || filterInfo.getFilterItems().isEmpty()) {
            return null;
        }
        String f = ev.getFilter().toString();
        return this.modifyDefFilterSql(f);
    }

    @Override
    protected void tableFieldConfig(FaDBUtilConfig cf) {
        cf.addFiledSize("FNAME_L2", 800);
        cf.addFiledSize("ASSTACTITEM1NAME", 800);
        cf.addFiledSize("ASSTACTITEM2NAME", 800);
        cf.addFiledSize("ASSTACTITEM3NAME", 800);
        cf.addFiledSize("ASSTACTITEMNAME", 800);
    }
}

