/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.rpt.app.dao;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.FaManageUtils;
import com.kingdee.eas.fi.fa.manage.app.FaDepORMapping;
import com.kingdee.eas.fi.fa.manage.app.FaLocalUtils;
import com.kingdee.eas.fi.fa.rpt.FaDBUtilConfig;
import com.kingdee.eas.fi.fa.rpt.LevelSumSqlInfo;
import com.kingdee.eas.fi.fa.rpt.app.dao.FaDaoBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class FaDeprDistDao
extends FaDaoBase {
    private static final Logger logger = Logger.getLogger(FaDeprDistDao.class);
    private boolean isUserDefineSort;
    private boolean displayEvalData = false;
    private boolean isShowLongName = false;

    @Override
    protected void initEvVar(EntityViewInfo ev) throws EASBizException, BOSException {
        super.initEvVar(ev);
        this.isShowLongName = FaManageUtils.getFaParamValue((Context)this.ctx, (String)"FA_062", (String)this.currCompanyInfo.getId().toString());
        Map cond = (Map)ev.get("customcond");
        this.isUserDefineSort = (Boolean)cond.get("IsUserDefineSort");
        this.displayEvalData = (Boolean)cond.get("displayEvalData");
    }

    private String getDeprDistSql() throws BOSException {
        String join;
        PeriodInfo periodInfo;
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT newBOSID('00000000') AS FId");
        if (this.sumOption.isHasSum()) {
            if (this.isShowLongName) {
                String str = this.sumOption.getStrNameFields();
                str = str.replace("account.FName_", "account.FLongName_");
                sql.append(",").append(str);
            } else {
                sql.append(",").append(this.sumOption.getStrNameFields());
            }
        }
        sql.append(",a.amount AS AMOUNT");
        sql.append(",a.CardID AS CardID");
        sql.append(",a.FACCOUNTID AS FACCOUNTID");
        sql.append(",0 AS isSum ");
        sql.append(this.def.getSelectPart(""));
        if (this.isSum("asstActItem") || this.filter != null && (this.filter.indexOf("asstActItem.fname_l2") != -1 || this.filter.indexOf("asstActType.fnumber") != -1)) {
            sql.append(", a.FSeq AS FSEQ ");
        }
        if (this.sumOption.isHasSum()) {
            sql.append(", ").append(this.sumOption.getStrLongNumberFields());
        }
        sql.append(" FROM (");
        try {
            periodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)this.ctx, (SystemEnum)SystemEnum.FIXEDASSETS, (IObjectPK)new ObjectUuidPK(this.currCompanyInfo.getId()));
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        int curYear = periodInfo.getPeriodYear();
        int curMonth = periodInfo.getPeriodNumber();
        StringBuffer card = new StringBuffer();
        if (this.startYear == curYear && this.startNumber == curMonth) {
            card.append(" t_fa_facurcard AS c on (b.ffacurcardid = c.fid and a.Fperiod = '" + periodInfo.getId().toString() + "') ");
            if (this.isUserDefineSort || this.filter != null && this.filter.indexOf("userdefine.fnumber") != -1) {
                join = " LEFT OUTER JOIN";
                if (this.isUserDefineSort) {
                    join = " INNER JOIN";
                }
                card.append(join + " T_FA_UserDefineEntry AS userDefineEntry ON c.FID = userDefineEntry.FAssetCardID ");
            }
            sql.append(this.getDeprSql(card.toString(), null));
        } else if (this.endYear < curYear || this.endYear == curYear && this.endNumber < curMonth) {
            card.append(" t_fa_famoncard AS c on (b.ffacurcardid = c.FFaCurCardID and a.Fperiod = c.FFaPeriodID)");
            if (this.isUserDefineSort || this.filter != null && this.filter.indexOf("userdefine.fnumber") != -1) {
                join = " LEFT OUTER JOIN";
                if (this.isUserDefineSort) {
                    join = " INNER JOIN";
                }
                card.append(join + " T_FA_UserDefineEntry AS userDefineEntry ON c.FFaCurCardID = userDefineEntry.FAssetCardID ");
            }
            sql.append(this.getDeprSql(card.toString(), null));
        } else {
            sql.append("( ");
            card.append(" t_fa_facurcard AS c on (b.ffacurcardid = c.fid and a.Fperiod = '" + periodInfo.getId().toString() + "') ");
            if (this.isUserDefineSort || this.filter != null && this.filter.indexOf("userdefine.fnumber") != -1) {
                join = " LEFT OUTER JOIN";
                if (this.isUserDefineSort) {
                    join = " INNER JOIN";
                }
                card.append(join + " T_FA_UserDefineEntry AS userDefineEntry ON c.FID = userDefineEntry.FAssetCardID ");
            }
            sql.append(this.getDeprSql(card.toString(), "1"));
            sql.append(" ) UNION ( ");
            StringBuffer cardBuffer = new StringBuffer();
            cardBuffer.append(" t_fa_famoncard AS c on (b.ffacurcardid = c.FFaCurCardID and a.Fperiod = c.FFaPeriodID)");
            if (this.isUserDefineSort || this.filter != null && this.filter.indexOf("userdefine.fnumber") != -1) {
                String join2 = " LEFT OUTER JOIN";
                if (this.isUserDefineSort) {
                    join2 = " INNER JOIN";
                }
                cardBuffer.append(join2 + " T_FA_UserDefineEntry AS userDefineEntry ON c.FFaCurCardID = userDefineEntry.FAssetCardID ");
            }
            sql.append(this.getDeprSql(cardBuffer.toString(), "2"));
            sql.append(") ");
        }
        sql.append(") a ");
        sql.append("LEFT OUTER  JOIN T_BD_AccountView AS account ON a.FAccountID = account.FID ");
        sql.append("LEFT OUTER JOIN T_BD_Address AS STORECITY ON a.FStoreCityID = STORECITY.FID ");
        if (this.isUserDefineSort || this.filter != null && this.filter.indexOf("userdefine.fnumber") != -1) {
            sql.append(" LEFT OUTER JOIN T_Fa_UserDefinedSort AS userDefine ON a.FUserDefineSortID = userDefine.FID ");
        }
        String tableName = this.isLevelSum("assetCat") ? this.getSumItemJoinSql("assetCat") : this.getSumItemTableName("assetCat");
        sql.append(" INNER JOIN ").append(tableName).append(" AS ").append("assetCat");
        sql.append(" ON a.FAssetCatID = ").append("assetCat").append(".FID");
        tableName = this.isLevelSum("originMethod") ? this.getSumItemJoinSql("originMethod") : this.getSumItemTableName("originMethod");
        sql.append(" INNER JOIN ").append(tableName).append(" AS ").append("originMethod");
        sql.append(" ON a.FOriginMethodID = ").append("originMethod").append(".FID");
        tableName = this.isLevelSum("useStatus") ? this.getSumItemJoinSql("useStatus") : this.getSumItemTableName("useStatus");
        sql.append(" INNER JOIN ").append(tableName).append(" AS ").append("useStatus");
        sql.append(" ON a.FUseStatusID = ").append("useStatus").append(".FID");
        tableName = this.isLevelSum("economicPurp") ? this.getSumItemJoinSql("economicPurp") : this.getSumItemTableName("economicPurp");
        sql.append(" INNER JOIN ").append(tableName).append(" AS ").append("economicPurp");
        sql.append(" ON a.FEconomicPurpID = ").append("economicPurp").append(".FID");
        if (this.isSum("asstActItem") || this.filter != null && (this.filter.indexOf("asstActItem.fname_l2") != -1 || this.filter.indexOf("asstActType.fnumber") != -1)) {
            tableName = this.isLevelSum("asstActItem") ? this.getSumItemJoinSql("asstActItem") : this.getSumItemTableName("asstActItem");
            sql.append(" LEFT OUTER JOIN ").append(tableName).append(" AS ").append("asstActItem");
            sql.append(" ON a.FAsstActTypeID = ").append("asstActItem").append(".FAsstacttypeID");
            sql.append(" and a.FAsstActItem = ").append("asstActItem").append(".FID");
            sql.append(" LEFT OUTER JOIN ").append(this.getSumItemTableName("asstActType")).append(" AS ").append("asstActType");
            sql.append(" ON ").append("asstActItem").append(".FAsstActTypeID = ").append("asstActType").append(".FID");
        }
        if (this.filter != null) {
            sql.append(" where " + this.filter);
        }
        return sql.toString();
    }

    private String getDeprSql(String cardTable, String id) {
        StringBuffer sql = new StringBuffer();
        sql.append(" select ");
        if (id != null) {
            sql.append(id);
            sql.append(" AS TMP, ");
        }
        sql.append("d.FAccountViewID AS FACCOUNTID, ");
        sql.append("d.FAmount AS AMOUNT, ");
        sql.append("c.FEconomicPurpID, ");
        sql.append("c.FAssetCatID, c.FOriginMethodID, ");
        sql.append("c.FUseStatusID, c.FStoreCityID, c.FCompanyID, c.fid as CardID, ");
        sql.append("c.FDeletedStatus as DeletedStatus,d.fid ");
        if (this.isUserDefineSort || this.filter != null && this.filter.indexOf("userdefine.fnumber") != -1) {
            sql.append(",userDefineEntry.FUserDefineSortID AS FUserDefineSortID");
        }
        if (this.isSum("asstActItem") || this.filter != null && (this.filter.indexOf("asstActItem.fname_l2") != -1 || this.filter.indexOf("asstActType.fnumber") != -1)) {
            sql.append(", f.FAsstActItem, f.FAsstacttypeID, f.FSeq ");
        }
        sql.append(this.def.getSelectPart(null));
        if (this.displayEvalData) {
            sql.append(" from t_fa_faevaldepreciation AS a");
        } else {
            sql.append(" from t_fa_fadepreciation AS a");
        }
        if (this.displayEvalData) {
            sql.append(" inner join t_fa_faevaldepreciationentry AS b on (a.fid = b.FLnkFaDepreEntry)");
        } else {
            sql.append(" inner join t_fa_fadepreciationentry AS b on (a.fid = b.FLnkFaDepreEntry)");
        }
        sql.append(" inner join ");
        sql.append(cardTable);
        if (this.displayEvalData) {
            sql.append(" inner join t_fa_faevaldepdistribute AS d on (b.fid = d.FDepEntryID)");
        } else {
            sql.append(" inner join T_FA_FaDepDistribute AS d on (b.fid = d.FDepEntryID)");
        }
        if (this.isSum("asstActItem") || this.filter != null && (this.filter.indexOf("asstActItem.fname_l2") != -1 || this.filter.indexOf("asstActType.fnumber") != -1)) {
            if (this.displayEvalData) {
                sql.append(" left outer join T_FA_FaEvalDepAsstActComposit AS f on (d.fid = f.fbillid)");
            } else {
                sql.append(" left outer join T_FA_FaDepAsstActComposit AS f on (d.fid = f.fbillid)");
            }
        }
        sql.append(" inner join T_BD_Period AS e on (a.Fperiod = e.FID)");
        try {
            sql.append(this.def.getJoinPart("C.FPropertyValueId"));
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new RuntimeException(e);
        }
        sql.append(" where a.FCompanyID = '").append(this.currCompanyInfo.getId().toString()).append("' and ");
        if (!this.displayEvalData) {
            sql.append(" a.FDepType != 2 and ");
        }
        int tempStartYear = this.startYear * 100 + this.startNumber;
        int tempEndYear = this.endYear * 100 + this.endNumber;
        if (id != null && "2".equals(id)) {
            --tempEndYear;
        }
        sql.append(" (e.FNumber >= " + tempStartYear + " and e.FNumber <= " + tempEndYear + ") ");
        return sql.toString();
    }

    @Override
    protected void buildSql() throws BOSException {
        this.buildResultSql();
    }

    private void buildResultSql() {
        StringBuffer sql = new StringBuffer();
        if (this.sumOption.isHasSum()) {
            sql.append(this.sumOption.getStrSelectResult() + ", ");
        }
        sql.append("accountLongNumber,");
        sql.append(this.getSelectResultSql());
        this.resultSql.setSelect(sql.toString());
        this.resultSql.setFrom(this.tempTable);
        this.resultSql.setOrder(this.sorter);
    }

    private String getSelectResultSql() {
        StringBuffer sql = new StringBuffer();
        if (this.isUserDefineSort) {
            sql.append(" userDefineLongNumber, ");
        }
        sql.append("AMOUNT,");
        sql.append("isSum");
        sql.append(this.def.getSelectPart(""));
        return sql.toString();
    }

    private String getSumSelectSql() {
        StringBuffer sql = new StringBuffer();
        sql.append("sum(AMOUNT) AS AMOUNT, ");
        sql.append("TO_CHAR(NULL) AS CardID, ");
        sql.append("TO_CHAR(NULL) AS FACCOUNTID, ");
        sql.append("1 AS isSum ");
        return sql.toString();
    }

    @Override
    public Map getResult() throws BOSException {
        Map result = super.getResult();
        try {
            if (FaDepORMapping.hasNoAudit((Context)this.ctx, (int)this.endYear, (int)this.endNumber, (String)this.currCompanyInfo.getId().toString())) {
                result.put("hasNoAudit", new Boolean(true));
            } else {
                result.put("hasNoAudit", new Boolean(false));
            }
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        return result;
    }

    protected String getSumSqlDistinctSelect() {
        StringBuffer sql = new StringBuffer();
        sql.append("FID,");
        sql.append("CardID, ");
        sql.append("FACCOUNTID,");
        sql.append("AMOUNT ");
        return sql.toString();
    }

    @Override
    protected void buildData() throws BOSException {
        this.addDataTempTable(FaLocalUtils.transformLocal((Context)this.ctx, (String)this.getDeprDistSql()));
        String select = this.getSumSelectSql();
        String sumSelect = select + this.def.getSelectSumPart("");
        select = select + this.def.getSelectSumPart("", false);
        String group = null;
        String sumWhere = "";
        if (this.hasCostCenter()) {
            select = select + ", 1 AS FSEQ";
            sumSelect = sumSelect + ", 1 AS FSEQ";
            sumWhere = "FSEQ = 1 OR FSEQ IS NULL";
            if (this.filter != null && (this.filter.indexOf("asstActType.fnumber") != -1 || this.filter.indexOf("asstActItem.fname_l2") != -1 || this.filter.indexOf("asstActItem.fnumber") != -1)) {
                sumWhere = "";
            }
        }
        String sumSql = this.sumOption.getSumSql2(this.tempTable, select, this.sumItemList, null, group, false, sumSelect, sumWhere);
        if (this.hasCostCenter()) {
            sumSql = this.filterDuplicateSubTotal(sumSql);
        }
        if (sumSql != null && sumSql.trim().length() > 0) {
            DbUtil.execute((Context)this.ctx, (String)sumSql);
        }
        StringBuffer sql = new StringBuffer();
        sql.append("DELETE FROM ").append(this.tempTable).append(" WHERE ISSUM=0 ");
        DbUtil.execute((Context)this.ctx, (String)sql.toString());
    }

    @Override
    protected List buildLevelSumSqlList(List sumOption) throws BOSException {
        List levelSumSqlList = super.buildLevelSumSqlList(sumOption);
        LevelSumSqlInfo levelSuminfo = this.getLevelSumSqlInfo(this.ctx, "accountName", 0, false);
        levelSumSqlList.add(levelSuminfo);
        return levelSumSqlList;
    }

    @Override
    protected String getFirstDisplayField() {
        return "AMOUNT";
    }

    @Override
    protected String modifyDefFilterSql(String f) {
        return this.def.property2FieldAtFilterByWrapped(f);
    }

    @Override
    protected String buildFilterSql(EntityViewInfo ev) {
        FilterInfo filterInfo = ev.getFilter();
        if (filterInfo == null || filterInfo.getFilterItems() == null || filterInfo.getFilterItems().isEmpty()) {
            return null;
        }
        String f = ev.getFilter().toString();
        if (f.indexOf("asstActType.number") != -1) {
            f = f.replaceAll("asstActType.number", "asstActType.fnumber");
        }
        return this.modifyDefFilterSql(f);
    }

    @Override
    protected void tableFieldConfig(FaDBUtilConfig cf) {
        cf.addFiledSize("FNAME_L2", 800);
        cf.addFiledSize("ASSTACTITEM1NAME", 800);
        cf.addFiledSize("ASSTACTITEM2NAME", 800);
        cf.addFiledSize("ASSTACTITEM3NAME", 800);
        cf.addFiledSize("ASSTACTITEMNAME", 800);
    }

    @Override
    protected StringBuffer getUsedAsstActItemSql() {
        StringBuffer cardSql = new StringBuffer();
        StringBuffer monCardSql = new StringBuffer();
        StringBuffer currCardSql = new StringBuffer();
        if (this.isVirCompany || this.startYear * 100 + this.startNumber < this.currPeriod.getPeriodYear() * 100 + this.currPeriod.getPeriodNumber()) {
            monCardSql.append(" select mc.fcompanyid as fcompanyid,cost.fid as fid,composit.FAsstActType AS FASSTACTTYPEID,composit.FAsstActItem ");
            monCardSql.append(" from t_fa_famoncard mc");
            monCardSql.append(" inner join t_fa_famoncostcenter cost on cost.ffamoncardid = mc.fid");
            monCardSql.append(" inner join T_FA_FamonAsstActComposit composit on composit.FFamonCostCenterID = cost.fid");
            if (this.startYear == 0 && this.startNumber == 0) {
                monCardSql.append(" where mc.fcompanyid in (" + this.strCompanyInclude + ") and mc.fperiodid is null ");
            } else {
                monCardSql.append(" inner join t_bd_period p on p.fid = mc.ffaperiodid");
                monCardSql.append(" where mc.fcompanyid in (").append(this.strCompanyInclude).append(") ");
                monCardSql.append(" and p.FNumber >=").append(this.startYear * 100 + this.startNumber);
                monCardSql.append(" and p.FNumber <=").append(this.endYear * 100 + this.endNumber);
            }
            monCardSql.append(" union ");
            monCardSql.append(" select bc.fcompanyid as fcompanyid,cost.fid as fid,composit.FAsstActType AS FASSTACTTYPEID,composit.FAsstActItem ");
            monCardSql.append(" from t_fa_fabakcard bc");
            monCardSql.append(" inner join t_fa_fabakcostcenter cost on cost.FFaBakCardID = bc.fid");
            monCardSql.append(" inner join T_FA_FabakAsstActComposit composit on composit.FFabakCostCenterID = cost.fid");
            monCardSql.append(" where bc.fcompanyid in (" + this.strCompanyInclude + ") ");
            if (this.startYear == 0 && this.startNumber == 0) {
                monCardSql.append(" and bc.fperiodid is null ");
            }
        }
        if (this.isVirCompany || this.endYear == this.currPeriod.getPeriodYear() && this.endNumber == this.currPeriod.getPeriodNumber()) {
            currCardSql.append(" select c.fcompanyid as fcompanyid,cost.fid as fid,composit.FAsstActType AS FASSTACTTYPEID,composit.FAsstActItem ");
            currCardSql.append(" from t_fa_facurcard c");
            currCardSql.append(" inner join t_fa_facurcostcenter cost on cost.ffacurcardid = c.fid");
            currCardSql.append(" inner join T_FA_FacurAsstActComposit composit on composit.FFacurCostCenterID = cost.fid");
            currCardSql.append(" where c.fcompanyid in (" + this.strCompanyInclude + ") ");
            currCardSql.append(" union ");
            currCardSql.append(" select bc.fcompanyid as fcompanyid,cost.fid as fid,composit.FAsstActType AS FASSTACTTYPEID,composit.FAsstActItem ");
            currCardSql.append(" from t_fa_fabakcard bc");
            currCardSql.append(" inner join t_fa_fabakcostcenter cost on cost.FFaBakCardID = bc.fid");
            currCardSql.append(" inner join T_FA_FabakAsstActComposit composit on composit.FFabakCostCenterID = cost.fid");
            currCardSql.append(" where bc.fcompanyid in (" + this.strCompanyInclude + ") ");
        }
        if (!this.isVirCompany && this.startYear * 100 + this.startNumber > this.currPeriod.getPeriodYear() * 100 + this.currPeriod.getPeriodNumber()) {
            currCardSql.append(" select c.fcompanyid as fcompanyid,cost.fid as fid,composit.FAsstActType AS FASSTACTTYPEID,composit.FAsstActItem ");
            currCardSql.append(" from t_fa_facurcard c");
            currCardSql.append(" inner join t_fa_facurcostcenter cost on cost.ffacurcardid = c.fid");
            currCardSql.append(" inner join T_FA_FacurAsstActComposit composit on composit.FFacurCostCenterID = cost.fid");
            currCardSql.append(" where c.fcompanyid in (" + this.strCompanyInclude + ") ");
            currCardSql.append(" union ");
            currCardSql.append(" select bc.fcompanyid as fcompanyid,cost.fid as fid,composit.FAsstActType AS FASSTACTTYPEID,composit.FAsstActItem ");
            currCardSql.append(" from t_fa_fabakcard bc");
            currCardSql.append(" inner join t_fa_fabakcostcenter cost on cost.FFaBakCardID = bc.fid");
            currCardSql.append(" inner join T_FA_FabakAsstActComposit composit on composit.FFabakCostCenterID = cost.fid");
            currCardSql.append(" where bc.fcompanyid in (" + this.strCompanyInclude + ") ");
        }
        if (monCardSql.length() > 0 && currCardSql.length() > 0) {
            monCardSql.append(" union ");
        }
        cardSql.append(" select asstItem.fid,asstItem.fasstacttypeid,asstItem.fasstactitem from (");
        cardSql.append(monCardSql).append(currCardSql);
        cardSql.append(") as asstItem ");
        cardSql.append(" where asstItem.fcompanyid ");
        cardSql.append(" in (").append(this.strCompanyInclude).append(")");
        return cardSql;
    }

    private boolean hasCostCenter() {
        return this.isSum("asstActItem") || this.filter != null && (this.filter.indexOf("asstActType.fnumber") != -1 || this.filter.indexOf("asstActItem.fname_l2") != -1 || this.filter.indexOf("asstActItem.fnumber") != -1);
    }

    private String filterDuplicateSubTotal(String sumSql) {
        String retSumSql = null;
        if (sumSql == null || sumSql.trim().length() == 0) {
            return null;
        }
        if (!(this.hasCostCenter() && (this.isSum("assetCat") || this.isSum("economicPurp") || this.isSum("useStatus") || this.isSum("storeCity") || this.isSum("originMethod")))) {
            return sumSql;
        }
        String addPartSql = " AND FSEQ = 1 ";
        String replaceSql2 = addPartSql + "GROUP BY";
        String subTotal = ResourceBase.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"subTotal", (Locale)this.ctx.getOriginLocale());
        String costCenterSubTotal = "N'" + subTotal + "' AS asstActItem1Name";
        if (!this.isLevelSum("asstActItem")) {
            costCenterSubTotal = "N'" + subTotal + "' AS asstActItemName";
        }
        int replaceIdx = sumSql.indexOf(costCenterSubTotal);
        String firstPartSql = sumSql.substring(0, replaceIdx);
        String secondPartSql = sumSql.substring(replaceIdx);
        firstPartSql = firstPartSql.replaceAll("GROUP BY", replaceSql2);
        retSumSql = firstPartSql + secondPartSql;
        return retSumSql;
    }
}

