/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.rpt.app.dao;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.app.FaLocalUtils;
import com.kingdee.eas.fi.fa.rpt.FaDBUtilConfig;
import com.kingdee.eas.fi.fa.rpt.app.dao.FaShowNotAuditDao;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import java.util.Locale;
import java.util.Map;

public class FaMatureHintRptDao
extends FaShowNotAuditDao {
    private boolean isByEvalue = false;
    private String strEvalFilter = "";
    int count;

    @Override
    protected void initEvVar(EntityViewInfo ev) throws EASBizException, BOSException {
        Map m = (Map)ev.get("customcond");
        this.isByEvalue = (Boolean)m.get("isByEvalue");
        super.initEvVar(ev);
        if (this.isInitPeriod) {
            PeriodInfo startPeriod = SystemStatusCtrolUtils.getStartPeriod((Context)this.ctx, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)this.currCompanyInfo);
            this.startYear = startPeriod.getPeriodYear();
            this.startNumber = startPeriod.getPeriodNumber();
        }
        if (this.currPeriod == null) {
            this.currPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)this.ctx, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)this.currCompanyInfo);
        }
    }

    @Override
    public void init(Context ctx, EntityViewInfo ev) throws EASBizException, BOSException {
        super.init(ctx, ev);
        this.count = this.getHintPeriod();
        this.filter = this.buildFilterSql(ev);
    }

    @Override
    protected void buildData() throws BOSException {
        this.addDataTempTable(FaLocalUtils.transformLocal((Context)this.ctx, (String)this.daoSql.getSql()));
    }

    @Override
    protected void buildSql() throws BOSException {
        String year = ResourceBase.getString((String)"com.kingdee.eas.fi.fa.basedata.FaResource", (String)"yeae", (Locale)this.ctx.getOriginLocale());
        String period = ResourceBase.getString((String)"com.kingdee.eas.fi.fa.basedata.FaResource", (String)"period", (Locale)this.ctx.getOriginLocale());
        String hintYear = this.startYear + " + TO_INTEGER((" + this.startNumber + " + FACURCARD.FUseTermCount - FACURCARD.FDeprTermCount - 1)/" + this.count + ")";
        String hintPeriod = " 1 + TO_INTEGER((" + this.startNumber + " + FACURCARD.FUseTermCount - FACURCARD.FDeprTermCount - 1)%" + this.count + ")";
        StringBuffer sql = new StringBuffer();
        sql.append(" newBOSID('00000000') AS FID,");
        sql.append(" FACURCARD.FNumber AS ASSETNUMBER,");
        sql.append(" FACURCARD.FoldNumber AS OLDERNUMBER,");
        sql.append(" FACURCARD.FAssetName AS assetName,");
        sql.append(" ASSETCAT.").append(this.fName).append(" as ASSETCAT_NAME,");
        sql.append(" FACURCARD.FSpecs AS specs,");
        sql.append(" FACURCARD.FAccountDate AS accountDate,");
        sql.append(" FACURCARD.FFiAccountDate AS fiAccountDate,");
        sql.append(" FACURCARD.FStartUseDate AS startUseDate,");
        sql.append(" CASE WHEN FACURCARD.FUseTermCount - FACURCARD.FDeprTermCount <= 0 THEN TO_CHAR(");
        sql.append(this.currPeriod.getPeriodYear()).append(")||'" + year + "'||TO_CHAR(").append(this.currPeriod.getPeriodNumber()).append(")||'" + period + "'");
        sql.append(" WHEN DEPRMETHOD.FIsWorkload = 1 THEN TO_CHAR(year(FACURCARD.FStartUseDate) + TO_INT(FACURCARD.FUSEYEARS))||'" + year).append("'");
        sql.append(" ELSE TO_CHAR(" + hintYear + ")||'" + year + "'||TO_CHAR(" + hintPeriod + ")||'" + period + "' END as hintPeriod, ");
        sql.append(" USESTATUS.").append(this.fName).append(" as USESTATUS_NAME,");
        sql.append(" DEPT.").append(this.fName).append(" as DEPT_NAME,");
        sql.append(" DEPRMETHOD.").append(this.fName).append(" as DEPRMETHOD_NAME,");
        sql.append(" MEASUREUNIT.").append(this.fName).append(" as MEASUREUNIT_NAME,");
        sql.append(" FACURCARD.FAssetAmt AS assetAmt,");
        sql.append(" FACURCARD.FAssetValue AS assetValue,");
        if (this.isByEvalue) {
            sql.append("CASE FACURCARD.FIsEvaledBefore WHEN 0 THEN TO_DECIMAL(NULL) ELSE FACURCARD.FInitEvalValue END AS initEvalValue,");
        }
        sql.append(" FACURCARD.FAccuDepr AS accuDepr,");
        sql.append(" FACURCARD.FNeatRemValue AS neatRemValue,");
        sql.append(" FACURCARD.FNeatValue AS neatValue,");
        sql.append(" FACURCARD.FDecValue AS decValue,");
        sql.append(" FACURCARD.FNeatAmt AS neatAmt,");
        sql.append(" FACURCARD.FUseTermCount AS useTermCount,");
        sql.append(" FACURCARD.FWrtyPeriod AS wrtyPeriod,");
        sql.append(" FACURCARD.FWrtyNumber AS wrtyNumber,");
        sql.append(" (FACURCARD.FUseTermCount - FACURCARD.FDeprTermCount) AS REMLIFE ");
        this.daoSql.setSelect(sql.toString());
        sql = new StringBuffer();
        if (this.isCurrPeriod) {
            sql.append("  T_FA_FaCurCard AS FACURCARD");
            sql.append(" INNER JOIN T_BD_Period AS PERIOD ON FACURCARD.FPeriodID = PERIOD.FID ");
        } else {
            sql.append("  T_FA_FaMonCard AS FACURCARD");
            if (!this.isInitPeriod) {
                sql.append(" LEFT OUTER JOIN T_BD_Period AS PERIOD ON FACURCARD.FFaPeriodID = PERIOD.FID ");
            }
        }
        sql.append(" LEFT OUTER JOIN T_FA_Cat AS ASSETCAT ON FACURCARD.FAssetCatID = ASSETCAT.FID");
        sql.append(" LEFT OUTER JOIN T_BD_MeasureUnit AS MEASUREUNIT ON FACURCARD.FMeasureUnitID = MEASUREUNIT.FID");
        sql.append(" LEFT OUTER JOIN T_FA_DepreciationMode AS DEPRMETHOD ON FACURCARD.FDeprMethodID = DEPRMETHOD.FID");
        sql.append(" INNER JOIN T_ORG_Admin AS DEPT ON FACURCARD.FDeptID = DEPT.FID");
        sql.append(" INNER JOIN T_FA_UseStatus AS USESTATUS ON FACURCARD.FUseStatusID = USESTATUS.FID");
        this.daoSql.setFrom(sql.toString());
        sql = new StringBuffer();
        sql.append(" FACURCARD.FUSEYEARS IS NOT NULL AND FACURCARD.FUSEYEARS > 0");
        sql.append(" AND (DEPRMETHOD.FNumber IS NULL OR DEPRMETHOD.FNumber <> '006') AND FACURCARD.FCOMPANYID = '" + this.currCompanyInfo.getId().toString() + "' ");
        sql.append(" AND FACURCARD.fDeletedStatus != 2 AND");
        if (this.isInitPeriod) {
            sql.append(" FACURCARD.FPERIODID IS NULL  AND  FACURCARD.FCheckedStatus = 2 ");
        } else if (this.isCurrPeriod) {
            sql.append(this.isShowNotAudit ? " FACURCARD.FEffectedStatus = 2" : " FACURCARD.FCheckedStatus = 2");
            sql.append(" AND PERIOD.fNumber <= ").append(this.startYear * 100 + this.startNumber);
        } else {
            sql.append(" PERIOD.FPERIODYEAR = " + this.startYear + " AND PERIOD.FPERIODNUMBER = " + this.startNumber);
        }
        if (this.filter != null) {
            sql.append(" AND " + this.filter);
        }
        this.daoSql.setWhere(sql.toString());
        this.buildResultSql();
    }

    private void buildResultSql() {
        StringBuffer sql = new StringBuffer();
        sql.append(this.getSelectResultSql());
        this.resultSql.setSelect(sql.toString());
        this.resultSql.setFrom(this.tempTable);
        if (this.isByEvalue) {
            this.resultSql.setWhere(this.strEvalFilter);
        }
        this.resultSql.setOrder(this.sorter);
    }

    private String getSelectResultSql() {
        StringBuffer sql = new StringBuffer();
        sql.append("fid,");
        sql.append("ASSETNUMBER, ");
        sql.append("OLDERNUMBER, ");
        sql.append("assetName, ");
        sql.append("ASSETCAT_NAME, ");
        sql.append("specs, ");
        sql.append("accountDate, ");
        sql.append("fiAccountDate, ");
        sql.append("startUseDate, ");
        sql.append("hintPeriod, ");
        sql.append("USESTATUS_NAME, ");
        sql.append("DEPT_NAME, ");
        sql.append("DEPRMETHOD_NAME, ");
        sql.append("MEASUREUNIT_NAME, ");
        sql.append("assetAmt, ");
        sql.append("assetValue, ");
        if (this.isByEvalue) {
            sql.append("initEvalValue, ");
        }
        sql.append("accuDepr, ");
        sql.append("neatRemValue, ");
        sql.append("neatValue, ");
        sql.append("decValue, ");
        sql.append("neatAmt, ");
        sql.append("MEASUREUNIT_NAME, ");
        sql.append("useTermCount, ");
        sql.append("wrtyPeriod,");
        sql.append("wrtyNumber,");
        sql.append("REMLIFE ");
        return sql.toString();
    }

    @Override
    protected String buildFilterSql(EntityViewInfo ev) {
        for (FilterItemInfo filterItem : ev.getFilter().getFilterItems()) {
            if (!"FACURCARD.FInitEvalValue".equalsIgnoreCase(filterItem.getPropertyName())) continue;
            this.strEvalFilter = "initEvalValue" + filterItem.getCompareType().toString() + filterItem.getCompareValue().toString();
            filterItem.setPropertyName(filterItem.getCompareValue().toString());
            filterItem.setCompareType(CompareType.EQUALS);
        }
        String filter = super.buildFilterSql(ev);
        if (filter != null) {
            if (filter.indexOf("REMLIFE") != -1) {
                filter = filter.replaceAll("REMLIFE", "FACURCARD.FUseTermCount - FACURCARD.FDeprTermCount");
            }
            if (filter.indexOf("wrtyNumber") != -1) {
                filter = filter.replaceAll("wrtyNumber", "FACURCARD.FwrtyNumber");
            }
            if (filter.indexOf("wrtyPeriod") != -1) {
                filter = filter.replaceAll("wrtyPeriod", "FACURCARD.FwrtyPeriod");
            }
        }
        if (filter == null) {
            return filter;
        }
        StringBuffer tempFilter = new StringBuffer(filter);
        while (tempFilter.indexOf("hintPeriod") != -1) {
            int operatorEnd;
            String yearName = ResourceBase.getString((String)"com.kingdee.eas.fi.fa.basedata.FaResource", (String)"yeae", (Locale)this.ctx.getOriginLocale());
            String periodName = ResourceBase.getString((String)"com.kingdee.eas.fi.fa.basedata.FaResource", (String)"period", (Locale)this.ctx.getOriginLocale());
            String hintYear = this.startYear + " + TO_INTEGER((" + this.startNumber + " + FACURCARD.FUseTermCount - FACURCARD.FDeprTermCount - 1)/" + this.count + ")";
            String hintPeriod = " 1 + (" + this.startNumber + " + TO_INTEGER(FACURCARD.FUseTermCount - FACURCARD.FDeprTermCount) - 1)%" + this.count;
            int start = tempFilter.indexOf("hintPeriod");
            int operatorStart = tempFilter.indexOf(" ", start) + 1;
            String operator = tempFilter.substring(operatorStart, operatorEnd = tempFilter.indexOf(" ", operatorStart));
            if (operator.indexOf(">") != -1 || operator.indexOf("=") != -1 || operator.indexOf("<") != -1) {
                int nutStart = tempFilter.indexOf("'", start);
                int yearEnd = tempFilter.indexOf("-", nutStart);
                if (yearEnd != -1) {
                    int year = new Integer(tempFilter.substring(nutStart + 1, yearEnd));
                    int nutEnd = tempFilter.indexOf("'", yearEnd);
                    int month = new Integer(tempFilter.substring(yearEnd + 1, nutEnd));
                    String realFiler = " CASE WHEN DEPRMETHOD.FIsWorkload = 1 THEN (year(FACURCARD.FStartUseDate) + TO_INT(FACURCARD.FUSEYEARS))*100  ELSE ((" + hintYear + ")*100+" + hintPeriod + ") END " + operator + " " + year * 100 + "+ CASE WHEN DEPRMETHOD.FIsWorkload = 1 THEN 0 ELSE " + month + " END";
                    tempFilter.replace(start, nutEnd + 1, realFiler);
                    continue;
                }
                StringBuffer sbHintPeriod = new StringBuffer();
                sbHintPeriod.append("( CASE WHEN DEPRMETHOD.FIsWorkload = 1 THEN TO_CHAR(year(FACURCARD.FStartUseDate) + TO_INT(FACURCARD.FUSEYEARS))||'" + yearName).append("'");
                sbHintPeriod.append(" ELSE TO_CHAR(" + hintYear + ")||'" + yearName + "'||TO_CHAR(" + hintPeriod + ")||'" + periodName + "' END ) ");
                tempFilter.replace(start, start + "hintPeriod".length(), sbHintPeriod.toString());
                continue;
            }
            StringBuffer sbHintPeriod = new StringBuffer();
            sbHintPeriod.append("( CASE WHEN DEPRMETHOD.FIsWorkload = 1 THEN TO_CHAR(year(FACURCARD.FStartUseDate) + TO_INT(FACURCARD.FUSEYEARS))||'" + yearName).append("'");
            sbHintPeriod.append(" ELSE TO_CHAR(" + hintYear + ")||'" + yearName + "'||TO_CHAR(" + hintPeriod + ")||'" + periodName + "' END ) ");
            tempFilter.replace(start, start + "hintPeriod".length(), sbHintPeriod.toString());
        }
        return tempFilter.toString();
    }

    @Override
    protected String buildSorterSql(EntityViewInfo ev) {
        String sorter = super.buildSorterSql(ev);
        if (sorter != null) {
            if (sorter == null || sorter.trim().length() == 0) {
                sorter = "REMLIFE ASC";
            } else if (sorter.indexOf("REMLIFE") == -1) {
                sorter = sorter + ",REMLIFE ASC";
            }
        }
        return sorter;
    }

    private int getHintPeriod() throws BOSException {
        String type = ContextUtil.getCurrentFIUnit((Context)this.ctx).getAccountPeriodType().getId().toString();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodYear", (Object)new Integer(this.startYear), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)type, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isAdjustPeriod", (Object)"0", CompareType.EQUALS));
        filter.setMaskString("#0 and #1 and #2");
        evi.setFilter(filter);
        IPeriod iPeriod = PeriodFactory.getLocalInstance((Context)this.ctx);
        PeriodCollection periodc = iPeriod.getPeriodCollection(evi);
        int periodCount = periodc.size();
        return periodCount;
    }

    @Override
    public Map getResult() throws BOSException {
        Map result = super.getResult();
        result.put("result", this.getData(this.resultSql.getSql()));
        return result;
    }

    @Override
    protected void tableFieldConfig(FaDBUtilConfig cf) {
        cf.addFiledSize("DEPT_NAME", 800);
    }
}

