/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.rpt.app.dao;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.app.FaLocalUtils;
import com.kingdee.eas.fi.fa.rpt.FaDBUtilConfig;
import com.kingdee.eas.fi.fa.rpt.app.dao.FaShowNotAuditDao;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class FaSubLedgerNewDao
extends FaShowNotAuditDao {
    private static final Logger logger = Logger.getLogger(FaSubLedgerNewDao.class);
    private String sumSql;
    private static String resourceClass = "com.kingdee.eas.fi.fa.rpt.FaRptResource";
    private boolean isGroupByDep;
    private boolean isGroupByAssetType;
    private boolean isGroupByCard;
    private boolean isShowNoIncurredAmtCard;
    private String daoSql;
    private String select;
    private boolean isByEvalue;
    private boolean isQuerySingleCard = false;
    private boolean isFromPrintCard = false;

    @Override
    protected void initEvVar(EntityViewInfo ev) throws EASBizException, BOSException {
        super.initEvVar(ev);
        Map m = (Map)ev.get("customcond");
        this.isByEvalue = (Boolean)m.get("isByEvalue");
        this.isGroupByDep = m.get("isGroupByDep") == null ? false : (Boolean)m.get("isGroupByDep");
        this.isGroupByAssetType = m.get("isGroupByAssetType") == null ? false : (Boolean)m.get("isGroupByAssetType");
        this.isGroupByCard = m.get("isGroupByCard") == null ? false : (Boolean)m.get("isGroupByCard");
        this.isShowNoIncurredAmtCard = m.get("isShowNoIncurredAmtCard") == null ? false : (Boolean)m.get("isShowNoIncurredAmtCard");
        this.isFromPrintCard = ev.get("isFromPrint") != null;
        boolean bl = this.isQuerySingleCard = ev.getFilter().getFilterItems().size() > 0;
        if (this.isGroupByAssetType || this.isGroupByDep || this.isGroupByCard) {
            this.isQuerySingleCard = true;
        }
    }

    public String getCurrentCompanyPeriodType(Context ctx) {
        String strCompanyOUPeriodType = this.currCompanyInfo.getAccountPeriodType().getId().toString();
        return strCompanyOUPeriodType;
    }

    protected List getPeriodList() throws BOSException {
        String ftypeid = this.getCurrentCompanyPeriodType(this.ctx);
        int startPeriod = this.startYear * 100 + this.startNumber;
        int endPeriod = this.endYear * 100 + this.endNumber;
        StringBuffer sql = new StringBuffer("select ");
        sql.append("p.fid as fid, p.fperiodyear as fperiodyear, p.fperiodnumber as fperiodnumber, p.fendDate as fendDate");
        sql.append(" from t_bd_period p ");
        sql.append(" inner join T_BD_PeriodType t on p.ftypeid=t.fid ");
        sql.append(" where t.FID ='");
        sql.append(ftypeid + "' ");
        sql.append(" and p.FNumber>= ");
        sql.append(startPeriod);
        sql.append(" and p.FNumber<= ");
        sql.append(endPeriod);
        sql.append(" order by p.FPeriodYear,p.FPeriodNumber ");
        IRowSet periodRowSet = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
        ArrayList<PeriodInfo> periodList = new ArrayList<PeriodInfo>();
        try {
            while (periodRowSet.next()) {
                PeriodInfo period = new PeriodInfo();
                period.setId(BOSUuid.read((String)periodRowSet.getString("fid")));
                period.setPeriodYear(periodRowSet.getInt("fperiodyear"));
                period.setPeriodNumber(periodRowSet.getInt("fperiodnumber"));
                period.setEndDate(periodRowSet.getTimestamp("fendDate"));
                periodList.add(period);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return periodList;
    }

    @Override
    protected void buildSql() throws BOSException {
        this.select = this.getSumSelectSql();
    }

    @Override
    protected void tableFieldConfig(FaDBUtilConfig cf) {
        cf.addFiledSize("ASSETNUMBER", 80);
        cf.addFiledSize("UNIT", 80);
        cf.addFiledSize("CURRENCY", 80);
        cf.addFiledSize("oldernumber", 80);
        cf.addFiledSize("ADMINDEPARTMENT", 800);
        cf.addFiledSize("FNAME_L2", 800);
    }

    private String getCatAdminSql(boolean isBroupByDep, boolean isGroupByAssetType) {
        String assetNumber = ResourceBase.getString((String)resourceClass, (String)"assetNumber", (Locale)this.ctx.getOriginLocale());
        String assetName = ResourceBase.getString((String)resourceClass, (String)"assetName", (Locale)this.ctx.getOriginLocale());
        String depNumber = ResourceBase.getString((String)resourceClass, (String)"depNumber", (Locale)this.ctx.getOriginLocale());
        String depName = ResourceBase.getString((String)resourceClass, (String)"depName", (Locale)this.ctx.getOriginLocale());
        StringBuffer sql = new StringBuffer();
        this.isUseDepartisLName();
        String dispName = "fdisplayName_L2";
        if (!this.isUseDepartDisLName) {
            dispName = "fName_L2";
        }
        if (isGroupByAssetType) {
            sql.append("' " + assetNumber + ": '||assetCat.fnumber ||'    " + assetName + ": '||assetCat.fdisplayName_L2 as assetType, ");
            sql.append("assetCat.FLongNumber as catNum, ");
        } else {
            sql.append("TO_CHAR(NULL)  as assetType ,");
            sql.append("TO_CHAR(NULL)  as catNum ,");
        }
        if (isBroupByDep) {
            sql.append("' " + depNumber + ": '||useDepartment.fnumber ||'    " + depName + ": '||useDepartment.").append(dispName);
            sql.append("  as adminDepartment ,");
            sql.append("  useDepartment.FLongNumber as adminNum ,");
        } else {
            sql.append("TO_CHAR(NULL)  as adminDepartment ,");
            sql.append("TO_CHAR(NULL)  as adminNum ,");
        }
        return sql.toString();
    }

    private List[] getAssetCatList() throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT DISTINCT assetType,catNum");
        sql.append(" FROM ").append(this.tempTable);
        sql.append(" ORDER BY assetType");
        Connection conn = this.getConnection(this.ctx);
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<String> catDisList = new ArrayList<String>();
        ArrayList<String> catNumList = new ArrayList<String>();
        try {
            stmt = conn.prepareStatement(sql.toString());
            rs = stmt.executeQuery();
            while (rs.next()) {
                if (!catDisList.contains(rs.getString("assetType"))) {
                    catDisList.add(rs.getString("assetType"));
                }
                if (catNumList.contains(rs.getString("catNum"))) continue;
                catNumList.add(rs.getString("catNum"));
            }
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        List[] cat = new ArrayList[]{catDisList, catNumList};
        return cat;
    }

    private List[] getAdminDepartmentList() throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT DISTINCT adminDepartment,adminNum");
        sql.append(" FROM ").append(this.tempTable);
        sql.append(" ORDER BY adminDepartment");
        Connection conn = this.getConnection(this.ctx);
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<String> adminDisList = new ArrayList<String>();
        ArrayList<String> adminNumList = new ArrayList<String>();
        try {
            stmt = conn.prepareStatement(sql.toString());
            rs = stmt.executeQuery();
            while (rs.next()) {
                if (!adminDisList.contains(rs.getString("adminDepartment"))) {
                    adminDisList.add(rs.getString("adminDepartment"));
                }
                if (adminNumList.contains(rs.getString("adminNum"))) continue;
                adminNumList.add(rs.getString("adminNum"));
            }
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        List[] admin = new ArrayList[]{adminDisList, adminNumList};
        return admin;
    }

    private List[] getCardList() throws BOSException {
        StringBuffer sql = new StringBuffer();
        ArrayList<String> cardDisList = new ArrayList<String>();
        ArrayList<String> cardNumList = new ArrayList<String>();
        sql.append("SELECT CUR.FASSETNAME AS FASSETNAME,CUR.FNUMBER AS FNUMBER FROM T_FA_FACURCARD AS CUR ");
        sql.append(" WHERE CUR.FID IN( SELECT DISTINCT FACURCARDID FROM ").append(this.tempTable).append(" ");
        if (!this.isGroupByCard || this.isGroupByCard && !this.isShowNoIncurredAmtCard) {
            sql.append(" WHERE BILLID IS NOT NULL ");
        }
        sql.append(") ");
        sql.append(" AND NOT EXISTS (");
        sql.append(" SELECT 1 FROM T_FA_CLEARBILLENTRY AS CLE ");
        sql.append(" LEFT OUTER JOIN T_FA_CLEARBILL AS CL ON CL.FID=CLE.FENTRYID ");
        sql.append(" LEFT OUTER JOIN T_BD_PERIOD AS P ON P.FID=CL.FPERIODID ");
        sql.append(" WHERE P.FNUMBER < ? ");
        sql.append(" AND CLE.FCURCARDID=CUR.FID ");
        sql.append(") ORDER BY FNUMBER ");
        IRowSet result = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString(), (Object[])new Object[]{new Integer(this.startYear * 100 + 1)});
        try {
            while (result.next()) {
                cardDisList.add(result.getString("FASSETNAME"));
                cardNumList.add(result.getString("FNUMBER"));
            }
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        List[] card = new ArrayList[]{cardDisList, cardNumList};
        return card;
    }

    private String getSumSelectSql() {
        StringBuffer sql = new StringBuffer();
        sql.append("PERIODYEAR,");
        sql.append("PERIODNUMBER,");
        sql.append("SORT_COL, ");
        sql.append("isBegin,");
        sql.append("BIZDATE, ");
        sql.append("BRIEF, ");
        sql.append("TO_CHAR(NULL) AS ASSETTYPE, ");
        sql.append("TO_CHAR(NULL) AS CATNUM, ");
        sql.append("TO_CHAR(NULL) AS ADMINDEPARTMENT, ");
        sql.append("TO_CHAR(NULL) AS ADMINNUM, ");
        sql.append("TO_CHAR(NULL) AS BILLID, ");
        sql.append("TO_CHAR(NULL) AS FACURCARDID,");
        sql.append("TO_CHAR(NULL) AS FACURCARDNUM,");
        sql.append("TO_CHAR(NULL) AS BIZNUMBER, ");
        sql.append("TO_CHAR(NULL) AS VOUCHERNUMBER, ");
        sql.append("TO_CHAR(NULL) AS abstract,");
        sql.append("TO_INT(NULL) AS BILLTYPE, ");
        sql.append("TO_CHAR(NULL) AS ASSETNUMBER, ");
        sql.append("TO_CHAR(NULL) AS OLDERNUMBER, ");
        sql.append("TO_CHAR(NULL) AS GROUPNUMBER, ");
        sql.append("TO_CHAR(NULL) AS ASSETNAME, ");
        sql.append("TO_CHAR(NULL) AS UNIT, ");
        sql.append("TO_DECIMAL(NULL) AS ASSETAMT, ");
        sql.append("TO_CHAR(NULL) CURRENCY, ");
        sql.append("TO_INT(NULL) AS Fcurrencypre,");
        sql.append("TO_DECIMAL(NULL) AS FexRate,");
        sql.append("TO_DECIMAL(NULL) AS FOriginAmt,");
        sql.append("TO_DECIMAL(NULL) AS FAddons,");
        sql.append("TO_DECIMAL(NULL) AS FAssetValue,");
        sql.append("SUM(VALUEDEBIT) AS VALUEDEBIT,");
        sql.append("SUM(VALUECREDIT) AS VALUECREDIT,");
        sql.append("SUM(VALUEBAL) AS VALUEBAL,");
        sql.append("SUM(DEPRDEBIT) AS DEPRDEBIT,");
        sql.append("SUM(DEPRCREDIT) AS DEPRCREDIT,");
        sql.append("SUM(DEPRBAL) AS DEPRBAL,");
        sql.append("SUM(NETVALUE) AS NETVALUE,");
        sql.append("SUM(DEVALUEDEBIT) AS DEVALUEDEBIT,");
        sql.append("SUM(DEVALUECREDIT) AS DEVALUECREDIT,");
        sql.append("SUM(DEVALUEBAL) AS DEVALUEBAL,");
        sql.append("SUM(NETAMOUNT) AS NETAMOUNT,");
        sql.append("1 AS FYearOrMonth, ");
        sql.append("1 AS isSum,");
        sql.append("TO_CHAR(NULL) AS COMPANY_ID ");
        return sql.toString();
    }

    private String getYearMonthSumSql() throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(this.getSQLSelect());
        sql.append("FROM (");
        sql.append(this.getSumBalanceSql());
        if (this.isByEvalue) {
            StringBuffer evalSql = new StringBuffer();
            evalSql.append("SELECT DISTINCT ");
            evalSql.append("b.FCompanyID,");
            evalSql.append("p.FPeriodYear AS PERIODYEAR,");
            evalSql.append("p.FPeriodNumber AS PERIODNUMBER,");
            evalSql.append("b.FBIZDATE AS BIZDATE, ");
            evalSql.append("N'").append(ResourceBase.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"evalute", (Locale)this.ctx.getOriginLocale())).append("' AS BRIEF, ");
            evalSql.append(this.getCatAdminSql(this.isGroupByDep, this.isGroupByAssetType));
            evalSql.append("b.FID AS BILLID, ");
            evalSql.append("e.FCURCARDID AS FACURCARDID, ");
            evalSql.append("cur.fnumber AS FACURCARDNUM, ");
            evalSql.append("b.FNUMBER  AS bizNumber, ");
            evalSql.append("b.fvoucherNumber AS voucherNumber, ");
            evalSql.append("b.fabstract AS abstract,");
            evalSql.append("7 AS BILLTYPE, ");
            evalSql.append("c.FNUMBER AS ASSETNUMBER, ");
            evalSql.append("c.FOldNumber AS OLDERNUMBER, ");
            evalSql.append("c.FGroupNumber AS GROUPNUMBER, ");
            evalSql.append("c.FASSETNAME AS ASSETNAME, ");
            evalSql.append("MEASUREUNIT." + this.fName + " AS UNIT, ");
            evalSql.append("c.FASSETAMT AS ASSETAMT, ");
            evalSql.append("CURRENCY." + this.fName + " AS CURRENCY, ");
            evalSql.append("CURRENCY.Fprecision AS Fcurrencypre, ");
            evalSql.append("c.FexRate, ");
            evalSql.append("c.FOriginAmt, ");
            evalSql.append("c.FAddons, ");
            evalSql.append("c.FAssetValue, ");
            evalSql.append("CASE WHEN v.FEvaValue - c.FLastEvalValue >0 THEN v.FEvaValue - c.FLastEvalValue ELSE 0.00 END AS VALUEDEBIT, ");
            evalSql.append("CASE WHEN c.FLastEvalValue - v.FEvaValue >0 THEN c.FLastEvalValue - v.FEvaValue ELSE 0.00 END AS VALUECREDIT,");
            evalSql.append("0.00 AS VALUEBAL, ");
            evalSql.append("0.00 AS DEPRDEBIT,");
            evalSql.append("0.00 AS DEPRCREDIT,");
            evalSql.append("0.00 AS DEPRBAL,");
            evalSql.append("0.00 AS DEVALUEDEBIT, ");
            evalSql.append("0.00 AS DEVALUECREDIT, ");
            evalSql.append("0.00 AS DEVALUEBAL, ");
            evalSql.append("0 AS FYearOrMonth,  ");
            evalSql.append("'6' AS SORT_COL, ");
            evalSql.append("1 AS isBegin");
            evalSql.append(" FROM T_FA_FaEvaluateBill b ");
            evalSql.append(" INNER JOIN T_FA_FaEvaluateBillEntry e ON b.FID = e.FFaEvaluateBillID ");
            evalSql.append(" INNER JOIN T_FA_FaBizCard c ON e.FBizCardID = c.FID ");
            evalSql.append(" INNER JOIN T_FA_FaBakCard bak ON bak.FID = c.ffabakcardid ");
            evalSql.append(" INNER JOIN T_FA_FaCurCard cur ON cur.FID = bak.ffacurcardid ");
            evalSql.append(" LEFT OUTER JOIN T_FA_FaBizDepartment AS faDepartment ON c.fid = faDepartment.FFaBizCardID ");
            evalSql.append(" INNER JOIN T_ORG_ADMIN AS useDepartment ON faDepartment.FUseDepartmentID = useDepartment.FID ");
            if (this.filter != null && (this.filter.indexOf("asstActItem.fname_l2") != -1 || this.filter.indexOf("asstActType.fnumber") != -1)) {
                evalSql.append(" INNER JOIN T_FA_FABizCOSTCENTER costcenter on costcenter.ffabizcardid = c.fid");
                evalSql.append(" INNER JOIN T_FA_FABIZASSTACTCOMPOSIT composit on composit.FfaBizCostCenterId = costcenter.Fid");
                evalSql.append(" INNER JOIN t_bd_asstacttype asstActType on asstActType.Fid = composit.FasstActType");
                evalSql.append(" INNER JOIN " + this.acctAsstTableName + " AS asstActItem ON composit.FAsstActItem = asstActItem.FID AND asstActItem.fasstActTypeId = composit.fasstActType");
            }
            evalSql.append(" INNER JOIN T_FA_FaEvavalue v ON v.FEvaEntryID = e.FID ");
            evalSql.append(" INNER JOIN T_ORG_COMPANY com ON b.FCompanyID = com.FID ");
            evalSql.append(" INNER JOIN T_BD_PERIOD p ON p.FID = b.FPeriodID");
            evalSql.append(" INNER JOIN T_BD_Currency AS CURRENCY ON c.FCurrencyID = CURRENCY.FID ");
            evalSql.append(" INNER JOIN T_BD_MeasureUnit AS MEASUREUNIT ON c.FMeasureUnitID = MEASUREUNIT.FID ");
            evalSql.append(" INNER JOIN T_FA_Cat AS ASSETCAT ON c.FAssetCatID = ASSETCAT.FID ");
            evalSql.append(" WHERE v.FMainType = 1 AND v.FSUBTYPE = '00'");
            evalSql.append(" AND c.FCompanyID ");
            if (this.isVirCompany) {
                evalSql.append(" IN (").append(this.strCompanyInclude).append(") ");
            } else {
                evalSql.append(" = '").append(this.currCompanyInfo.getId().toString()).append("' ");
            }
            evalSql.append(" AND p.FNumber >= ").append(this.startYear * 100 + this.startNumber);
            evalSql.append(" AND p.FNumber <= ").append(this.endYear * 100 + this.endNumber);
            evalSql.append(" AND").append(this.isShowNotAudit ? " b.FEffectedStatus" : " b.FCheckedStatus").append(" = 2");
            if (this.filter != null && this.filter.trim().length() > 0) {
                String tmpFilter = this.filter.replaceAll("ASSETNUMBER", "cur.fnumber");
                tmpFilter = tmpFilter.replaceAll("assetName", "cur.fassetName");
                tmpFilter = tmpFilter.replaceAll("oldNumber", "cur.foldnumber");
                tmpFilter = tmpFilter.replaceAll("groupNumber", "cur.fgroupNumber");
                evalSql.append(" AND ").append(tmpFilter);
            }
            sql.append(" UNION ALL ");
            sql.append(evalSql);
        }
        sql.append(") AS A");
        if (this.isVirCompany) {
            sql.append(" INNER JOIN " + this.getSumItemJoinSql("orgArchitecture") + " COMPANY on COMPANY.fid = a.FCompanyID");
        }
        return sql.toString();
    }

    protected Connection getConnection(Context ctx) throws SQLDataException {
        try {
            return EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException sqle) {
            throw new SQLDataException(sqle);
        }
    }

    private String getSQLSelect() throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT ");
        sql.append("NEWBOSID('00000000') AS FId, ");
        if (this.sumOption != null && this.sumOption.isHasSum()) {
            sql.append(this.sumOption.getStrNameFields() + ", ");
        }
        sql.append("A.PERIODYEAR,");
        sql.append("A.PERIODNUMBER,");
        sql.append("A.SORT_COL, ");
        sql.append("A.isBegin,");
        sql.append("A.BIZDATE, ");
        sql.append("A.BRIEF, ");
        sql.append("A.assetType,");
        sql.append("A.catNum,");
        sql.append("A.adminDepartment,");
        sql.append("A.adminNum,");
        sql.append("A.BILLID, ");
        sql.append("A.FACURCARDID AS FACURCARDID, ");
        sql.append("A.FACURCARDNUM AS FACURCARDNUM, ");
        sql.append("A.bizNumber AS bizNumber,");
        sql.append("A.voucherNumber as VoucherNumber,");
        sql.append("A.abstract as abstract,");
        sql.append("A.BILLTYPE, ");
        sql.append("A.ASSETNUMBER, ");
        sql.append("A.OLDERNUMBER, ");
        sql.append("A.GROUPNUMBER, ");
        sql.append("A.ASSETNAME, ");
        sql.append("A.UNIT, ");
        sql.append("A.ASSETAMT, ");
        sql.append("A.CURRENCY, ");
        sql.append("A.Fcurrencypre, ");
        sql.append("A.FexRate, ");
        sql.append("A.FOriginAmt, ");
        sql.append("A.FAddons, ");
        sql.append("A.FAssetValue, ");
        sql.append("A.VALUEDEBIT, ");
        sql.append("A.VALUECREDIT, ");
        sql.append("A.VALUEBAL, ");
        sql.append("A.DEPRDEBIT, ");
        sql.append("A.DEPRCREDIT, ");
        sql.append("A.DEPRBAL, ");
        sql.append("000000000000.0000 AS NETVALUE, ");
        sql.append("A.DEVALUEDEBIT, ");
        sql.append("A.DEVALUECREDIT, ");
        sql.append("A.DEVALUEBAL, ");
        sql.append("000000000000.0000 AS NETAMOUNT, ");
        sql.append("A.FYearOrMonth, ");
        sql.append("0 AS isSum, ");
        sql.append("A.FCompanyID AS COMPANY_ID ");
        if (this.isVirCompany) {
            sql.append(",COMPANY.FLevel AS SumLevel");
        }
        if (this.sumOption != null && this.sumOption.isHasSum()) {
            sql.append(",").append(this.sumOption.getStrLongNumberFields());
        }
        return sql.toString();
    }

    private String getSumBalanceSelectSQL() {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT ");
        sql.append(" FCompanyID,");
        sql.append("PERIODYEAR,");
        sql.append("PERIODNUMBER,");
        sql.append("BIZDATE, ");
        sql.append("BRIEF, ");
        sql.append("TO_CHAR(NULL) AS ASSETTYPE,");
        sql.append("TO_CHAR(NULL) AS CATNUM,");
        sql.append("TO_CHAR(NULL) AS ADMINDEPARTMENT,");
        sql.append("TO_CHAR(NULL) AS ADMINNUM,");
        sql.append("TO_CHAR(NULL) AS BILLID, ");
        sql.append(this.isGroupByCard ? "ffacurcardid" : "TO_CHAR(NULL)").append(" AS FACURCARDID, ");
        sql.append(this.isGroupByCard ? "fnumber" : "TO_CHAR(NULL)").append(" AS FACURCARDNUM, ");
        sql.append("TO_CHAR(NULL) AS bizNumber, ");
        sql.append("TO_CHAR(NULL) AS voucherNumber, ");
        sql.append("TO_CHAR(NULL) AS abstract, ");
        sql.append("0 AS BILLTYPE, ");
        sql.append(this.isGroupByCard || this.isFromPrintCard ? "fnumber" : "TO_CHAR(NULL)").append(" AS ASSETNUMBER, ");
        sql.append("TO_CHAR(NULL) AS OLDERNUMBER, ");
        sql.append("TO_CHAR(NULL) AS GROUPNUMBER, ");
        sql.append(this.isGroupByCard || this.isFromPrintCard ? "fassetname" : "TO_CHAR(NULL)").append(" AS ASSETNAME, ");
        sql.append("TO_CHAR(NULL) AS UNIT, ");
        sql.append("TO_DECIMAL(NULL) AS ASSETAMT, ");
        sql.append("TO_CHAR(NULL) AS CURRENCY, ");
        sql.append("TO_INT(NULL) as Fcurrencypre, ");
        sql.append("TO_DECIMAL(NULL) AS FexRate, ");
        sql.append("TO_DECIMAL(NULL) AS FOriginAmt, ");
        sql.append("TO_DECIMAL(NULL) AS FAddons, ");
        sql.append("TO_DECIMAL(NULL) AS FAssetValue, ");
        sql.append("SUM(VALUEDEBIT) AS VALUEDEBIT, ");
        sql.append("SUM(VALUECREDIT) AS VALUECREDIT, ");
        sql.append("SUM(VALUEBAL) AS VALUEBAL, ");
        sql.append("SUM(DEPRDEBIT) AS DEPRDEBIT, ");
        sql.append("SUM(DEPRCREDIT) AS DEPRCREDIT, ");
        sql.append("SUM(DEPRBAL) AS DEPRBAL, ");
        sql.append("SUM(DEVALUEDEBIT) AS DEVALUEDEBIT, ");
        sql.append("SUM(DEVALUECREDIT) AS DEVALUECREDIT, ");
        sql.append("SUM(DEVALUEBAL) AS DEVALUEBAL, ");
        sql.append("1 AS FYearOrMonth, ");
        sql.append("SORT_COL,");
        sql.append("isBegin");
        return sql.toString();
    }

    private String getYearSumBalanceSQL() throws BOSException, EASBizException {
        if (!this.isGroupByAssetType) {
            return this.getYearSumBalanceSQLOld();
        }
        if (this.isVirCompany) {
            return this.getYearSumBalanceSQLNew(true) + " UNION " + this.getYearSumBalanceSQLNew(false);
        }
        int curr = this.currPeriod.getNumber();
        int start = this.startYear * 100 + this.startNumber;
        int end = this.endYear * 100 + this.endNumber;
        if (start <= curr && curr <= end) {
            return this.getYearSumBalanceSQLNew(true) + " UNION " + this.getYearSumBalanceSQLNew(false);
        }
        return this.getYearSumBalanceSQLNew(false);
    }

    private String getYearSumBalanceSQLOld() throws BOSException, EASBizException {
        List[] cardLists;
        List[] departmentLists;
        String filter;
        List[] cat;
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT DISTINCT ");
        if (this.isGroupByCard || this.isFromPrintCard) {
            sql.append("c.fnumber,c.fassetname,");
        }
        sql.append(" c.FCompanyID,c.FAssetValue,c.FAddons,T.ffacurcardid,T.PERIODYEAR,T.PERIODNUMBER,T.BIZDATE,T.BRIEF,");
        sql.append("T.SORT_COL,T.isBegin,T.VALUEBAL,T.DEPRBAL,T.DEVALUEBAL,T.VALUEDEBIT,T.VALUECREDIT,T.DEPRDEBIT,T.DEPRCREDIT,");
        sql.append("T.DEVALUEDEBIT,T.DEVALUECREDIT ");
        sql.append(" FROM (");
        StringBuffer yearSql = new StringBuffer();
        yearSql.append(" SELECT S.ffacurcardid,S.FPeriodID,PERIOD.FPERIODYEAR AS PERIODYEAR,");
        yearSql.append("0 AS PERIODNUMBER,");
        yearSql.append("TO_DATE(TO_CHAR(PERIOD.FPERIODYEAR)||'-1-1 00:00:00') AS BIZDATE, ");
        yearSql.append("N'" + ResourceBase.getString((String)"com.kingdee.eas.fi.fa.basedata.FaResource", (String)"startYearBalance", (Locale)this.ctx.getOriginLocale()) + "' AS BRIEF, ");
        yearSql.append("'0' AS SORT_COL,");
        yearSql.append("0 AS isBegin,");
        yearSql.append("0 AS VALUEDEBIT, ");
        yearSql.append("0 AS VALUECREDIT, ");
        yearSql.append("0 AS DEPRDEBIT, ");
        yearSql.append("0 AS DEPRCREDIT, ");
        yearSql.append("0 AS DEVALUEDEBIT, ");
        yearSql.append("0 AS DEVALUECREDIT, ");
        yearSql.append(" S.").append(this.isByEvalue ? "FEvalueBeginBalanceFor" : "FRealBeginBalanceFor").append(" AS VALUEBAL,");
        yearSql.append(" S.FDepreBeginBalanceFor AS DEPRBAL,");
        yearSql.append(" S.FDecValueBeginBalanceFor AS DEVALUEBAL");
        yearSql.append(" FROM T_FA_FaAccountBalance AS S ");
        yearSql.append(" INNER JOIN T_BD_Period AS PERIOD ON S.FPeriodID = PERIOD.FID  ");
        yearSql.append(" INNER JOIN T_BD_SystemStatusCtrol ssc on ssc.FCompanyID = S.FCompanyOrgUnitID ");
        yearSql.append(" INNER JOIN T_BD_SystemStatus ss ON ss.FID = ssc.FSystemStatusID AND ss.FName = ").append(14);
        yearSql.append(" INNER JOIN T_BD_PERIOD AS STARTPERIOD ON STARTPERIOD.FID = ssc.FStartPeriodID ");
        yearSql.append(" where PERIOD.FPERIODNUMBER = 1 AND PERIOD.FNUMBER > STARTPERIOD.FNUMBER");
        if (this.startYear == this.endYear) {
            yearSql.append(" AND PERIOD.FPERIODYEAR = ").append(this.startYear);
        } else {
            yearSql.append(" AND PERIOD.FPERIODYEAR >= ").append(this.startYear).append(" AND PERIOD.FPERIODYEAR <= ").append(this.endYear);
        }
        yearSql.append(" AND S.FCompanyOrgUnitID ");
        if (this.isVirCompany) {
            yearSql.append(" IN (").append(this.strCompanyInclude).append(") ");
        } else {
            yearSql.append(" = '").append(this.currCompanyInfo.getId().toString()).append("' ");
        }
        if (!this.isByEvalue) {
            yearSql.append(" UNION ALL ");
            yearSql.append(" select initcard.ffacurcardid,STARTPERIOD.FID,STARTPERIOD.FPERIODYEAR AS PERIODYEAR, ");
            yearSql.append(" 0 AS PERIODNUMBER, ");
            yearSql.append("TO_DATE(TO_CHAR(STARTPERIOD.FPERIODYEAR)||'-1-1 00:00:00') AS BIZDATE, ");
            yearSql.append("N'" + ResourceBase.getString((String)"com.kingdee.eas.fi.fa.basedata.FaResource", (String)"startYearBalance", (Locale)this.ctx.getOriginLocale()) + "' AS BRIEF, ");
            yearSql.append("'0' AS SORT_COL,");
            yearSql.append("0 AS isBegin,");
            yearSql.append("0 AS VALUEDEBIT, ");
            yearSql.append("0 AS VALUECREDIT, ");
            yearSql.append("0 AS DEPRDEBIT, ");
            yearSql.append("0 AS DEPRCREDIT, ");
            yearSql.append("0 AS DEVALUEDEBIT, ");
            yearSql.append("0 AS DEVALUECREDIT, ");
            yearSql.append("initdata.foriginBeginQty AS VALUEBAL,");
            yearSql.append("initdata.fdeprBeginQty AS DEPRBAL,");
            yearSql.append("initdata.fdecValueBeginQty AS DEVALUEBAL");
            yearSql.append(" from T_FA_FamonInitData as initData ");
            yearSql.append(" inner join t_fa_famoncard initCard on initCard.fid = initData.ffamoncardid ");
            yearSql.append(" INNER JOIN T_BD_SystemStatusCtrol ssc on ssc.FCompanyID = initcard.FCompanyID ");
            yearSql.append(" INNER JOIN T_BD_SystemStatus ss ON ss.FID = ssc.FSystemStatusID AND ss.FName = 14 ");
            yearSql.append(" INNER JOIN T_BD_Period AS STARTPERIOD on ssc.FStartPeriodID = STARTPERIOD.FID ");
            yearSql.append(" WHERE STARTPERIOD.FNumber >= ").append(this.startYear * 100 + this.startNumber).append(" AND STARTPERIOD.FNumber <= ").append(this.endYear * 100 + this.endNumber);
            yearSql.append(" AND initcard.FPeriodID IS NULL AND initcard.fDeletedStatus = ").append(1);
            yearSql.append(" AND initcard.fcompanyid ");
            if (this.isVirCompany) {
                yearSql.append(" IN (").append(this.strCompanyInclude).append(") ");
            } else {
                yearSql.append(" = '").append(this.currCompanyInfo.getId().toString()).append("' ");
            }
        }
        yearSql.append(" union all ");
        yearSql.append(" SELECT S.ffacurcardid,S.FPeriodID,PERIOD.FPERIODYEAR AS PERIODYEAR,");
        yearSql.append("0 AS PERIODNUMBER,");
        yearSql.append("TO_DATE(TO_CHAR(PERIOD.FPERIODYEAR)||'-1-1 00:00:00') AS BIZDATE, ");
        yearSql.append("N'" + ResourceBase.getString((String)"com.kingdee.eas.fi.fa.basedata.FaResource", (String)"startYearBalance", (Locale)this.ctx.getOriginLocale()) + "' AS BRIEF, ");
        yearSql.append("'0' AS SORT_COL,");
        yearSql.append("0 AS isBegin,");
        yearSql.append("0 AS VALUEDEBIT, ");
        yearSql.append("0 AS VALUECREDIT, ");
        yearSql.append("0 AS DEPRDEBIT, ");
        yearSql.append("0 AS DEPRCREDIT, ");
        yearSql.append("0 AS DEVALUEDEBIT, ");
        yearSql.append("0 AS DEVALUECREDIT, ");
        yearSql.append(" S.").append(this.isByEvalue ? "FEvalueBeginBalanceFor" : "FRealBeginBalanceFor").append(" AS VALUEBAL,");
        yearSql.append(" S.FDepreBeginBalanceFor AS DEPRBAL,");
        yearSql.append(" S.FDecValueBeginBalanceFor AS DEVALUEBAL");
        yearSql.append(" FROM T_FA_FaAccountBalance AS S ");
        yearSql.append(" INNER JOIN T_BD_Period AS PERIOD ON S.FPeriodID = PERIOD.FID ");
        yearSql.append(" INNER JOIN T_BD_SystemStatusCtrol ssc on ssc.FCompanyID = S.FCompanyOrgUnitID ");
        yearSql.append(" INNER JOIN T_BD_PERIOD AS STARTPERIOD ON STARTPERIOD.FID = ssc.FStartPeriodID ");
        yearSql.append(" INNER JOIN T_BD_SystemStatus ss ON ss.FID = ssc.FSystemStatusID AND ss.FName = ").append(14);
        if (this.startYear == this.endYear) {
            yearSql.append(" WHERE PERIOD.FPERIODYEAR = ").append(this.startYear);
        } else {
            yearSql.append(" WHERE PERIOD.FPERIODYEAR >= ").append(this.startYear).append(" AND PERIOD.FPERIODYEAR <= ").append(this.endYear);
        }
        yearSql.append(" AND PERIOD.FPERIODNUMBER = 1 and PERIOD.FNumber > STARTPERIOD.FNumber");
        yearSql.append(" AND PERIOD.FPERIODYEAR > STARTPERIOD.FPERIODYEAR ");
        yearSql.append(" AND S.FCompanyOrgUnitID ");
        if (this.isVirCompany) {
            yearSql.append(" IN (").append(this.strCompanyInclude).append(") ");
        } else {
            yearSql.append(" = '").append(this.currCompanyInfo.getId().toString()).append("' ");
        }
        yearSql.append(" UNION ALL ");
        yearSql.append("SELECT E.ffacurcardid,E.FPeriodID,");
        yearSql.append("PERIOD.FPeriodYear AS PERIODYEAR,");
        yearSql.append("PERIOD.FPeriodNumber AS PERIODNUMBER,");
        yearSql.append("PERIOD.FEndDate AS BIZDATE, ");
        yearSql.append("N'" + ResourceBase.getString((String)"com.kingdee.eas.fi.fa.basedata.FaResource", (String)"yearTotalAll", (Locale)this.ctx.getOriginLocale()) + "' AS BRIEF, ");
        yearSql.append("'9' AS SORT_COL,");
        yearSql.append("3 AS isBegin,");
        yearSql.append("E.").append(this.isByEvalue ? "FEvalueDebitFor" : "FRealDebitFor").append(" AS VALUEDEBIT, ");
        yearSql.append("E.").append(this.isByEvalue ? "FEvalueCreditFor" : "FRealCreditFor").append(" AS VALUECREDIT, ");
        yearSql.append("E.FDepreDebitFor AS DEPRDEBIT, ");
        yearSql.append("E.FdepreCreditFor AS DEPRCREDIT, ");
        yearSql.append("E.FDecValueDebitFor AS DEVALUEDEBIT, ");
        yearSql.append("E.FDecValueCreditFor AS DEVALUECREDIT, ");
        yearSql.append(" 0.00 AS VALUEBAL,");
        yearSql.append(" 0.00 AS DEPRBAL,");
        yearSql.append(" 0.00 AS DEVALUEBAL");
        yearSql.append(" FROM T_FA_FaAccountBalance AS E ");
        yearSql.append(" inner join t_org_company cp on cp.fid = E.Fcompanyorgunitid ");
        yearSql.append(" INNER JOIN T_BD_Period AS PERIOD ON E.FPeriodID = PERIOD.FID and cp.faccountperiodid = period.ftypeid");
        yearSql.append(" INNER JOIN T_BD_SystemStatusCtrol ssc on ssc.FCompanyID = E.FCompanyOrgUnitID ");
        yearSql.append(" INNER JOIN T_BD_PERIOD AS STARTPERIOD ON STARTPERIOD.FID = ssc.FStartPeriodID ");
        yearSql.append(" INNER JOIN T_BD_SystemStatus ss ON ss.FID = ssc.FSystemStatusID AND ss.FName = ").append(14);
        yearSql.append(" WHERE PERIOD.FNumber >= ").append(this.startYear * 100 + this.startNumber);
        yearSql.append(" AND PERIOD.FNumber <= ").append(this.endYear * 100 + this.endNumber);
        yearSql.append(" AND PERIOD.FNumber >= STARTPERIOD.FNumber");
        yearSql.append(" AND E.FCompanyOrgUnitID ");
        if (this.isVirCompany) {
            yearSql.append(" IN (").append(this.strCompanyInclude).append(") ");
        } else {
            yearSql.append(" = '").append(this.currCompanyInfo.getId().toString()).append("' ");
        }
        yearSql.append(" union all ");
        yearSql.append(" SELECT initcard.ffacurcardid,PERIOD.FID,");
        yearSql.append("PERIOD.FPeriodYear AS PERIODYEAR,");
        yearSql.append("PERIOD.FPeriodNumber AS PERIODNUMBER,");
        yearSql.append("PERIOD.FEndDate AS BIZDATE, ");
        yearSql.append("N'" + ResourceBase.getString((String)"com.kingdee.eas.fi.fa.basedata.FaResource", (String)"yearTotalAll", (Locale)this.ctx.getOriginLocale()) + "' AS BRIEF, ");
        yearSql.append("'9' AS SORT_COL,");
        yearSql.append(" 3 AS isBegin,");
        yearSql.append("initdata.FOriginIncQty AS VALUEDEBIT, ");
        yearSql.append("initdata.FOriginDecQty AS VALUECREDIT, ");
        yearSql.append("initdata.FDeprIncQty AS DEPRDEBIT, ");
        yearSql.append("initdata.FDeprDecQty+initcard.FAccuDeprTYear-initcard.FdeprTTerm AS DEPRCREDIT, ");
        yearSql.append("initdata.fdecValueIncQty AS DEVALUEDEBIT, ");
        yearSql.append("initdata.fdecValueDecQty AS DEVALUECREDIT, ");
        yearSql.append(" 0 AS VALUEBAL, ");
        yearSql.append(" 0 AS DEPRBAL,");
        yearSql.append(" 0 AS DEVALUEBAL ");
        yearSql.append(" FROM T_FA_Famoninitdata AS initdata ");
        yearSql.append(" inner join t_fa_famoncard initcard on initcard.fid = initdata.ffamoncardid ");
        yearSql.append(" INNER JOIN T_BD_SystemStatusCtrol ssc on ssc.FCompanyID = initcard.FCompanyID ");
        yearSql.append(" INNER JOIN T_BD_SystemStatus ss ON ss.FID = ssc.FSystemStatusID AND ss.FName = ").append(14);
        yearSql.append(" INNER JOIN T_BD_PERIOD AS STARTPERIOD ON STARTPERIOD.FID = ssc.FStartPeriodID ");
        yearSql.append(" inner join t_org_company cp on cp.fid = initcard.Fcompanyid ");
        yearSql.append(" INNER JOIN T_BD_PERIOD AS PERIOD ON PERIOD.FNumber >= ").append(this.startYear * 100 + this.startNumber).append(" AND PERIOD.FNumber <= ").append(this.endYear * 100 + this.endNumber);
        yearSql.append(" and cp.faccountperiodid = period.ftypeid");
        yearSql.append(" WHERE STARTPERIOD.FPeriodYear >= ").append(this.startYear).append(" AND STARTPERIOD.FPeriodYear <= ").append(this.endYear);
        yearSql.append(" AND initcard.FPeriodID IS NULL AND initcard.fDeletedStatus = ").append(1);
        yearSql.append(" AND initcard.fcompanyid ");
        if (this.isVirCompany) {
            yearSql.append(" IN (").append(this.strCompanyInclude).append(") ");
        } else {
            yearSql.append(" = '").append(this.currCompanyInfo.getId().toString()).append("' ");
        }
        sql.append(yearSql);
        sql.append(") AS T");
        sql.append(" INNER JOIN T_FA_FaCurCard c ON T.ffacurcardid = c.fid");
        sql.append(" INNER JOIN T_FA_Cat assetCat ON c.fassetcatid = assetCat.fid");
        sql.append(" INNER JOIN T_BD_currency currency ON currency.fid = c.fcurrencyid");
        if (this.isQuerySingleCard) {
            if (this.isGroupByDep || this.filter != null && this.filter.indexOf("useDepartment.fnumber") != -1) {
                sql.append(" LEFT OUTER JOIN T_FA_FaCurDepartment AS faDepartment ON c.fid = faDepartment.FFaCurCardID ");
                sql.append(" INNER JOIN T_ORG_ADMIN AS useDepartment ON faDepartment.FUseDepartmentID = useDepartment.FID ");
            }
            if (this.filter != null && (this.filter.indexOf("asstActItem.fname_l2") != -1 || this.filter.indexOf("asstActType.fnumber") != -1)) {
                sql.append(" INNER JOIN T_FA_FACURCOSTCENTER costcenter on costcenter.ffacurcardid = c.fid");
                sql.append(" INNER JOIN T_FA_FACURASSTACTCOMPOSIT composit on composit.FfaCurCostCenterId = costcenter.Fid");
                sql.append(" INNER JOIN t_bd_asstacttype asstActType on asstActType.Fid = composit.FasstActType");
                sql.append(" INNER JOIN " + this.acctAsstTableName + " AS asstActItem ON composit.FAsstActItem = asstActItem.FID AND asstActItem.fasstActTypeId = composit.fasstActType");
            }
        }
        sql.append(" WHERE c.FcompanyID ");
        if (this.isVirCompany) {
            sql.append(" IN (").append(this.strCompanyInclude).append(") ");
        } else {
            sql.append(" = '").append(this.currCompanyInfo.getId().toString()).append("' ");
        }
        if (this.filter != null && this.filter.trim().length() > 0) {
            String tmpFilter = this.filter.replaceAll("ASSETNUMBER", "c.fnumber");
            tmpFilter = tmpFilter.replaceAll("assetName", "c.fassetName");
            tmpFilter = tmpFilter.replaceAll("oldNumber", "c.foldnumber");
            tmpFilter = tmpFilter.replaceAll("groupNumber", "c.fgroupNumber");
            sql.append(" AND ").append(tmpFilter);
        }
        if (this.isGroupByAssetType && ((ArrayList)(cat = this.getAssetCatList())[1]).size() > 0) {
            filter = ((ArrayList)cat[1]).get(0).toString();
            sql.append(" and assetCat.flongnumber= '").append(filter).append("'");
        }
        if (this.isGroupByDep && ((ArrayList)(departmentLists = this.getAdminDepartmentList())[1]).size() > 0) {
            filter = ((ArrayList)departmentLists[1]).get(0).toString();
            sql.append(" and useDepartment.flongnumber= '").append(filter).append("'");
        }
        if (this.isGroupByCard && !this.isFromPrintCard && !this.isShowNoIncurredAmtCard && ((ArrayList)(cardLists = this.getCardList())[1]).size() > 0) {
            filter = ((ArrayList)cardLists[1]).get(0).toString();
            sql.append(" and c.fnumber= '").append(filter).append("'");
        }
        return sql.toString();
    }

    private String getYearSumBalanceSQLNew(boolean isIncludeCurrPeriod) throws BOSException, EASBizException {
        List[] cardLists;
        List[] departmentLists;
        String filter;
        List[] cat;
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT DISTINCT ");
        if (this.isGroupByCard || this.isFromPrintCard) {
            sql.append("c.fnumber,c.fassetname,");
        }
        sql.append(" c.FCompanyID,c.FAssetValue,c.FAddons,T.ffacurcardid,T.PERIODYEAR,T.PERIODNUMBER,T.BIZDATE,T.BRIEF,");
        sql.append("T.SORT_COL,T.isBegin,T.VALUEBAL,T.DEPRBAL,T.DEVALUEBAL,T.VALUEDEBIT,T.VALUECREDIT,T.DEPRDEBIT,T.DEPRCREDIT,");
        sql.append("T.DEVALUEDEBIT,T.DEVALUECREDIT ");
        sql.append(" FROM (");
        StringBuffer yearSql = new StringBuffer();
        yearSql.append(" SELECT S.ffacurcardid,S.FPeriodID,PERIOD.FPERIODYEAR AS PERIODYEAR,");
        yearSql.append("0 AS PERIODNUMBER,");
        yearSql.append("TO_DATE(TO_CHAR(PERIOD.FPERIODYEAR)||'-1-1 00:00:00') AS BIZDATE, ");
        yearSql.append("N'" + ResourceBase.getString((String)"com.kingdee.eas.fi.fa.basedata.FaResource", (String)"startYearBalance", (Locale)this.ctx.getLocale()) + "' AS BRIEF, ");
        yearSql.append("'0' AS SORT_COL,");
        yearSql.append("0 AS isBegin,");
        yearSql.append("0 AS VALUEDEBIT, ");
        yearSql.append("0 AS VALUECREDIT, ");
        yearSql.append("0 AS DEPRDEBIT, ");
        yearSql.append("0 AS DEPRCREDIT, ");
        yearSql.append("0 AS DEVALUEDEBIT, ");
        yearSql.append("0 AS DEVALUECREDIT, ");
        yearSql.append(" S.").append(this.isByEvalue ? "FEvalueBeginBalanceFor" : "FRealBeginBalanceFor").append(" AS VALUEBAL,");
        yearSql.append(" S.FDepreBeginBalanceFor AS DEPRBAL,");
        yearSql.append(" S.FDecValueBeginBalanceFor AS DEVALUEBAL");
        yearSql.append(" FROM T_FA_FaAccountBalance AS S ");
        yearSql.append(" INNER JOIN T_BD_Period AS PERIOD ON S.FPeriodID = PERIOD.FID  ");
        yearSql.append(" INNER JOIN T_BD_SystemStatusCtrol ssc on ssc.FCompanyID = S.FCompanyOrgUnitID ");
        yearSql.append(" INNER JOIN T_BD_SystemStatus ss ON ss.FID = ssc.FSystemStatusID AND ss.FName = ").append(14);
        yearSql.append(" INNER JOIN T_BD_PERIOD AS STARTPERIOD ON STARTPERIOD.FID = ssc.FStartPeriodID ");
        yearSql.append(" where PERIOD.FPERIODNUMBER = 1 AND PERIOD.FNUMBER > STARTPERIOD.FNUMBER");
        if (this.startYear == this.endYear) {
            yearSql.append(" AND PERIOD.FPERIODYEAR = ").append(this.startYear);
        } else {
            yearSql.append(" AND PERIOD.FPERIODYEAR >= ").append(this.startYear).append(" AND PERIOD.FPERIODYEAR <= ").append(this.endYear);
        }
        yearSql.append(" AND S.FCompanyOrgUnitID ");
        if (this.isVirCompany) {
            yearSql.append(" IN (").append(this.strCompanyInclude).append(") ");
        } else {
            yearSql.append(" = '").append(this.currCompanyInfo.getId().toString()).append("' ");
        }
        if (!this.isByEvalue) {
            yearSql.append(" UNION ALL ");
            yearSql.append(" select initcard.ffacurcardid,STARTPERIOD.FID,STARTPERIOD.FPERIODYEAR AS PERIODYEAR, ");
            yearSql.append(" 0 AS PERIODNUMBER, ");
            yearSql.append("TO_DATE(TO_CHAR(STARTPERIOD.FPERIODYEAR)||'-1-1 00:00:00') AS BIZDATE, ");
            yearSql.append("N'" + ResourceBase.getString((String)"com.kingdee.eas.fi.fa.basedata.FaResource", (String)"startYearBalance", (Locale)this.ctx.getLocale()) + "' AS BRIEF, ");
            yearSql.append("'0' AS SORT_COL,");
            yearSql.append("0 AS isBegin,");
            yearSql.append("0 AS VALUEDEBIT, ");
            yearSql.append("0 AS VALUECREDIT, ");
            yearSql.append("0 AS DEPRDEBIT, ");
            yearSql.append("0 AS DEPRCREDIT, ");
            yearSql.append("0 AS DEVALUEDEBIT, ");
            yearSql.append("0 AS DEVALUECREDIT, ");
            yearSql.append("initdata.foriginBeginQty AS VALUEBAL,");
            yearSql.append("initdata.fdeprBeginQty AS DEPRBAL,");
            yearSql.append("initdata.fdecValueBeginQty AS DEVALUEBAL");
            yearSql.append(" from T_FA_FamonInitData as initData ");
            yearSql.append(" inner join t_fa_famoncard initCard on initCard.fid = initData.ffamoncardid ");
            yearSql.append(" INNER JOIN T_BD_SystemStatusCtrol ssc on ssc.FCompanyID = initcard.FCompanyID ");
            yearSql.append(" INNER JOIN T_BD_SystemStatus ss ON ss.FID = ssc.FSystemStatusID AND ss.FName = 14 ");
            yearSql.append(" INNER JOIN T_BD_Period AS STARTPERIOD on ssc.FStartPeriodID = STARTPERIOD.FID ");
            yearSql.append(" WHERE STARTPERIOD.FNumber >= ").append(this.startYear * 100 + this.startNumber).append(" AND STARTPERIOD.FNumber <= ").append(this.endYear * 100 + this.endNumber);
            yearSql.append(" AND initcard.FPeriodID IS NULL AND initcard.fDeletedStatus = ").append(1);
            yearSql.append(" AND initcard.fcompanyid ");
            if (this.isVirCompany) {
                yearSql.append(" IN (").append(this.strCompanyInclude).append(") ");
            } else {
                yearSql.append(" = '").append(this.currCompanyInfo.getId().toString()).append("' ");
            }
        }
        yearSql.append(" union all ");
        yearSql.append(" SELECT S.ffacurcardid,S.FPeriodID,PERIOD.FPERIODYEAR AS PERIODYEAR,");
        yearSql.append("0 AS PERIODNUMBER,");
        yearSql.append("TO_DATE(TO_CHAR(PERIOD.FPERIODYEAR)||'-1-1 00:00:00') AS BIZDATE, ");
        yearSql.append("N'" + ResourceBase.getString((String)"com.kingdee.eas.fi.fa.basedata.FaResource", (String)"startYearBalance", (Locale)this.ctx.getLocale()) + "' AS BRIEF, ");
        yearSql.append("'0' AS SORT_COL,");
        yearSql.append("0 AS isBegin,");
        yearSql.append("0 AS VALUEDEBIT, ");
        yearSql.append("0 AS VALUECREDIT, ");
        yearSql.append("0 AS DEPRDEBIT, ");
        yearSql.append("0 AS DEPRCREDIT, ");
        yearSql.append("0 AS DEVALUEDEBIT, ");
        yearSql.append("0 AS DEVALUECREDIT, ");
        yearSql.append(" S.").append(this.isByEvalue ? "FEvalueBeginBalanceFor" : "FRealBeginBalanceFor").append(" AS VALUEBAL,");
        yearSql.append(" S.FDepreBeginBalanceFor AS DEPRBAL,");
        yearSql.append(" S.FDecValueBeginBalanceFor AS DEVALUEBAL");
        yearSql.append(" FROM T_FA_FaAccountBalance AS S ");
        yearSql.append(" INNER JOIN T_BD_Period AS PERIOD ON S.FPeriodID = PERIOD.FID ");
        yearSql.append(" INNER JOIN T_BD_SystemStatusCtrol ssc on ssc.FCompanyID = S.FCompanyOrgUnitID ");
        yearSql.append(" INNER JOIN T_BD_PERIOD AS STARTPERIOD ON STARTPERIOD.FID = ssc.FStartPeriodID ");
        yearSql.append(" INNER JOIN T_BD_SystemStatus ss ON ss.FID = ssc.FSystemStatusID AND ss.FName = ").append(14);
        if (this.startYear == this.endYear) {
            yearSql.append(" WHERE PERIOD.FPERIODYEAR = ").append(this.startYear);
        } else {
            yearSql.append(" WHERE PERIOD.FPERIODYEAR >= ").append(this.startYear).append(" AND PERIOD.FPERIODYEAR <= ").append(this.endYear);
        }
        yearSql.append(" AND PERIOD.FPERIODNUMBER = 1 and PERIOD.FNumber > STARTPERIOD.FNumber");
        yearSql.append(" AND PERIOD.FPERIODYEAR > STARTPERIOD.FPERIODYEAR ");
        yearSql.append(" AND S.FCompanyOrgUnitID ");
        if (this.isVirCompany) {
            yearSql.append(" IN (").append(this.strCompanyInclude).append(") ");
        } else {
            yearSql.append(" = '").append(this.currCompanyInfo.getId().toString()).append("' ");
        }
        yearSql.append(" UNION ALL ");
        yearSql.append("SELECT E.ffacurcardid,E.FPeriodID,");
        yearSql.append("PERIOD.FPeriodYear AS PERIODYEAR,");
        yearSql.append("PERIOD.FPeriodNumber AS PERIODNUMBER,");
        yearSql.append("PERIOD.FEndDate AS BIZDATE, ");
        yearSql.append("N'" + ResourceBase.getString((String)"com.kingdee.eas.fi.fa.basedata.FaResource", (String)"yearTotalAll", (Locale)this.ctx.getLocale()) + "' AS BRIEF, ");
        yearSql.append("'9' AS SORT_COL,");
        yearSql.append("3 AS isBegin,");
        yearSql.append("E.").append(this.isByEvalue ? "FEvalueDebitFor" : "FRealDebitFor").append(" AS VALUEDEBIT, ");
        yearSql.append("E.").append(this.isByEvalue ? "FEvalueCreditFor" : "FRealCreditFor").append(" AS VALUECREDIT, ");
        yearSql.append("E.FDepreDebitFor AS DEPRDEBIT, ");
        yearSql.append("E.FdepreCreditFor AS DEPRCREDIT, ");
        yearSql.append("E.FDecValueDebitFor AS DEVALUEDEBIT, ");
        yearSql.append("E.FDecValueCreditFor AS DEVALUECREDIT, ");
        yearSql.append(" 0.00 AS VALUEBAL,");
        yearSql.append(" 0.00 AS DEPRBAL,");
        yearSql.append(" 0.00 AS DEVALUEBAL");
        yearSql.append(" FROM T_FA_FaAccountBalance AS E ");
        yearSql.append(" inner join t_org_company cp on cp.fid = E.Fcompanyorgunitid ");
        yearSql.append(" INNER JOIN T_BD_Period AS PERIOD ON E.FPeriodID = PERIOD.FID and cp.faccountperiodid = period.ftypeid");
        yearSql.append(" INNER JOIN T_BD_SystemStatusCtrol ssc on ssc.FCompanyID = E.FCompanyOrgUnitID ");
        yearSql.append(" INNER JOIN T_BD_PERIOD AS STARTPERIOD ON STARTPERIOD.FID = ssc.FStartPeriodID ");
        yearSql.append(" INNER JOIN T_BD_SystemStatus ss ON ss.FID = ssc.FSystemStatusID AND ss.FName = ").append(14);
        yearSql.append(" WHERE PERIOD.FNumber >= ").append(this.startYear * 100 + this.startNumber);
        yearSql.append(" AND PERIOD.FNumber <= ").append(this.endYear * 100 + this.endNumber);
        yearSql.append(" AND PERIOD.FNumber >= STARTPERIOD.FNumber");
        yearSql.append(" AND E.FCompanyOrgUnitID ");
        if (this.isVirCompany) {
            yearSql.append(" IN (").append(this.strCompanyInclude).append(") ");
        } else {
            yearSql.append(" = '").append(this.currCompanyInfo.getId().toString()).append("' ");
        }
        yearSql.append(" union all ");
        yearSql.append(" SELECT initcard.ffacurcardid,PERIOD.FID,");
        yearSql.append("PERIOD.FPeriodYear AS PERIODYEAR,");
        yearSql.append("PERIOD.FPeriodNumber AS PERIODNUMBER,");
        yearSql.append("PERIOD.FEndDate AS BIZDATE, ");
        yearSql.append("N'" + ResourceBase.getString((String)"com.kingdee.eas.fi.fa.basedata.FaResource", (String)"yearTotalAll", (Locale)this.ctx.getLocale()) + "' AS BRIEF, ");
        yearSql.append("'9' AS SORT_COL,");
        yearSql.append(" 3 AS isBegin,");
        yearSql.append("initdata.FOriginIncQty AS VALUEDEBIT, ");
        yearSql.append("initdata.FOriginDecQty AS VALUECREDIT, ");
        yearSql.append("initdata.FDeprIncQty AS DEPRDEBIT, ");
        yearSql.append("initdata.FDeprDecQty+initcard.FAccuDeprTYear-initcard.FdeprTTerm AS DEPRCREDIT, ");
        yearSql.append("initdata.fdecValueIncQty AS DEVALUEDEBIT, ");
        yearSql.append("initdata.fdecValueDecQty AS DEVALUECREDIT, ");
        yearSql.append(" 0 AS VALUEBAL, ");
        yearSql.append(" 0 AS DEPRBAL,");
        yearSql.append(" 0 AS DEVALUEBAL ");
        yearSql.append(" FROM T_FA_Famoninitdata AS initdata ");
        yearSql.append(" inner join t_fa_famoncard initcard on initcard.fid = initdata.ffamoncardid ");
        yearSql.append(" INNER JOIN T_BD_SystemStatusCtrol ssc on ssc.FCompanyID = initcard.FCompanyID ");
        yearSql.append(" INNER JOIN T_BD_SystemStatus ss ON ss.FID = ssc.FSystemStatusID AND ss.FName = ").append(14);
        yearSql.append(" INNER JOIN T_BD_PERIOD AS STARTPERIOD ON STARTPERIOD.FID = ssc.FStartPeriodID ");
        yearSql.append(" inner join t_org_company cp on cp.fid = initcard.Fcompanyid ");
        yearSql.append(" INNER JOIN T_BD_PERIOD AS PERIOD ON PERIOD.FNumber >= ").append(this.startYear * 100 + this.startNumber).append(" AND PERIOD.FNumber <= ").append(this.endYear * 100 + this.endNumber);
        yearSql.append(" and cp.faccountperiodid = period.ftypeid");
        yearSql.append(" WHERE STARTPERIOD.FPeriodYear >= ").append(this.startYear).append(" AND STARTPERIOD.FPeriodYear <= ").append(this.endYear);
        yearSql.append(" AND initcard.FPeriodID IS NULL AND initcard.fDeletedStatus = ").append(1);
        yearSql.append(" AND initcard.fcompanyid ");
        if (this.isVirCompany) {
            yearSql.append(" IN (").append(this.strCompanyInclude).append(") ");
        } else {
            yearSql.append(" = '").append(this.currCompanyInfo.getId().toString()).append("' ");
        }
        sql.append(yearSql);
        sql.append(") AS T");
        if (isIncludeCurrPeriod) {
            sql.append(" INNER JOIN T_FA_FaCurCard c ON T.ffacurcardid = c.fid");
            if (this.isVirCompany) {
                sql.append(" INNER JOIN ( SELECT sysctrl.FCOMPANYID FCOMPANYID, sysctrl.FCURRENTPERIODID FCURRENTPERIODID FROM T_BD_SYSTEMSTATUSCTROL sysctrl ");
                sql.append(" INNER JOIN T_BD_SYSTEMSTATUS sysstatus ON sysctrl.FSYSTEMSTATUSID = sysstatus.FID ");
                sql.append(" WHERE sysstatus.FNAME = ");
                sql.append(SystemEnum.FIXEDASSETS.getValue());
                sql.append(" ) AS currPeriod ON c.FCompanyID = currPeriod.FCOMPANYID AND T.fperiodid = currPeriod.FCURRENTPERIODID ");
            }
        } else {
            sql.append(" INNER JOIN T_FA_FaMonCard c ON T.ffacurcardid = c.ffacurcardid and T.fperiodid=c.ffaperiodid");
        }
        sql.append(" INNER JOIN T_FA_Cat assetCat ON c.fassetcatid = assetCat.fid");
        sql.append(" INNER JOIN T_BD_currency currency ON currency.fid = c.fcurrencyid");
        if (this.isQuerySingleCard) {
            if (this.isGroupByDep || this.filter != null && this.filter.indexOf("useDepartment.fnumber") != -1) {
                sql.append(" LEFT OUTER JOIN T_FA_FaCurDepartment AS faDepartment ON c.fid = faDepartment.FFaCurCardID ");
                sql.append(" INNER JOIN T_ORG_ADMIN AS useDepartment ON faDepartment.FUseDepartmentID = useDepartment.FID ");
            }
            if (this.filter != null && (this.filter.indexOf("asstActItem.fname_l2") != -1 || this.filter.indexOf("asstActType.fnumber") != -1)) {
                sql.append(" INNER JOIN T_FA_FACURCOSTCENTER costcenter on costcenter.ffacurcardid = c.fid");
                sql.append(" INNER JOIN T_FA_FACURASSTACTCOMPOSIT composit on composit.FfaCurCostCenterId = costcenter.Fid");
                sql.append(" INNER JOIN t_bd_asstacttype asstActType on asstActType.Fid = composit.FasstActType");
                sql.append(" INNER JOIN " + this.acctAsstTableName + " AS asstActItem ON composit.FAsstActItem = asstActItem.FID AND asstActItem.fasstActTypeId = composit.fasstActType");
            }
        }
        if (isIncludeCurrPeriod && !this.isVirCompany) {
            sql.append(" WHERE T.fperiodid='").append(this.currPeriod.getId().toString()).append("' AND c.FcompanyID ");
        } else if (!isIncludeCurrPeriod && !this.isVirCompany) {
            sql.append(" WHERE T.fperiodid!='").append(this.currPeriod.getId().toString()).append("' AND c.FcompanyID ");
        } else {
            sql.append(" WHERE c.FcompanyID ");
        }
        if (this.isVirCompany) {
            sql.append(" IN (").append(this.strCompanyInclude).append(") ");
        } else {
            sql.append(" = '").append(this.currCompanyInfo.getId().toString()).append("' ");
        }
        if (this.filter != null && this.filter.trim().length() > 0) {
            String tmpFilter = this.filter.replaceAll("ASSETNUMBER", "c.fnumber");
            tmpFilter = tmpFilter.replaceAll("assetName", "c.fassetName");
            tmpFilter = tmpFilter.replaceAll("oldNumber", "c.foldnumber");
            tmpFilter = tmpFilter.replaceAll("groupNumber", "c.fgroupNumber");
            sql.append(" AND ").append(tmpFilter);
        }
        if (this.isGroupByAssetType && ((ArrayList)(cat = this.getAssetCatList())[1]).size() > 0) {
            filter = ((ArrayList)cat[1]).get(0).toString();
            sql.append(" and assetCat.flongnumber= '").append(filter).append("'");
        }
        if (this.isGroupByDep && ((ArrayList)(departmentLists = this.getAdminDepartmentList())[1]).size() > 0) {
            filter = ((ArrayList)departmentLists[1]).get(0).toString();
            sql.append(" and useDepartment.flongnumber= '").append(filter).append("'");
        }
        if (this.isGroupByCard && !this.isFromPrintCard && !this.isShowNoIncurredAmtCard && ((ArrayList)(cardLists = this.getCardList())[1]).size() > 0) {
            filter = ((ArrayList)cardLists[1]).get(0).toString();
            sql.append(" and c.fnumber= '").append(filter).append("'");
        }
        return sql.toString();
    }

    private String createYearSumSql() throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(this.getSQLSelect());
        sql.append(" FROM( ");
        sql.append("SELECT DISTINCT ");
        sql.append("c.FCompanyID,");
        sql.append("PERIOD.FPeriodYear AS PERIODYEAR,");
        sql.append("PERIOD.FPeriodNumber AS PERIODNUMBER,");
        sql.append("TO_DATE(CONCAT(TO_CHAR(A.FCHANGEDATE,'yyyy-mm-dd'), ' 00:00:00')) AS BIZDATE, ");
        sql.append("N'" + ResourceBase.getString((String)"com.kingdee.eas.fi.fa.basedata.FaResource", (String)"yearTotalAll", (Locale)this.ctx.getLocale()) + "' AS BRIEF, ");
        sql.append(this.getCatAdminSql(this.isGroupByDep, this.isGroupByAssetType));
        sql.append("TO_CHAR(NULL) AS BILLID, ");
        sql.append("TO_CHAR(NULL) AS FACURCARDID, ");
        sql.append("TO_CHAR(NULL) AS FACURCARDNUM, ");
        sql.append("TO_CHAR(NULL) as voucherNumber,");
        sql.append("TO_CHAR(NULL) as abstract,");
        sql.append("TO_CHAR(NULL) AS bizNumber,");
        sql.append("TO_CHAR(NULL) BILLTYPE, ");
        sql.append("TO_CHAR(NULL) AS ASSETNUMBER, ");
        sql.append("TO_CHAR(NULL) AS OLDERNUMBER, ");
        sql.append("TO_CHAR(NULL) as GROUPNUMBER, ");
        sql.append("TO_CHAR(NULL) AS ASSETNAME, ");
        sql.append("TO_CHAR(NULL) AS UNIT, ");
        sql.append("TO_CHAR(NULL) AS ASSETAMT, ");
        sql.append("TO_CHAR(NULL) AS CURRENCY, ");
        sql.append("TO_CHAR(NULL) AS Fcurrencypre, ");
        sql.append("TO_CHAR(NULL) AS FExRate, ");
        sql.append("TO_CHAR(NULL) AS FOriginAmt, ");
        sql.append("TO_CHAR(NULL) AS FAddons, ");
        sql.append("TO_CHAR(NULL) AS FAssetValue, ");
        if (this.isByEvalue) {
            sql.append("ABS((CASE WHEN c.FINITEVALVALUE-c.FLASTEVALVALUE>0 THEN c.FINITEVALVALUE-c.FLASTEVALVALUE ELSE 0 END)) AS VALUEDEBIT, ");
            sql.append("ABS((CASE WHEN c.FINITEVALVALUE-c.FLASTEVALVALUE<0 THEN c.FINITEVALVALUE-c.FLASTEVALVALUE ELSE 0 END))  AS VALUECREDIT, ");
            sql.append("000000000000.0000 AS VALUEBAL, ");
        } else {
            sql.append("000000000000.0000 AS VALUEDEBIT, ");
            sql.append("000000000000.0000 AS VALUECREDIT, ");
            sql.append("000000000000.0000 AS VALUEBAL, ");
        }
        sql.append("000000000000.0000 AS DEPRDEBIT,");
        sql.append("000000000000.0000 AS DEPRCREDIT,");
        sql.append("000000000000.0000 AS DEPRBAL, ");
        sql.append("000000000000.0000 AS DEVALUEDEBIT, ");
        sql.append("000000000000.0000 AS DEVALUECREDIT, ");
        sql.append("000000000000.0000 AS DEVALUEBAL,");
        sql.append("1 AS FYearOrMonth, ");
        sql.append("'9' AS SORT_COL,");
        sql.append("3 AS isBegin");
        sql.append(" FROM T_FA_FACHANGEBILL AS A ");
        sql.append(" INNER JOIN T_FA_FACHANGEBILLENTRY AS B ON A.FID = B.FCHANGEBILLID");
        sql.append(" INNER JOIN T_FA_ALTERMODE AS alterMode ON alterMode.FID = A.FChangeModeID");
        sql.append(" INNER JOIN T_FA_FABIZCARD AS c ON B.FBIZCARDID = c.FID");
        sql.append(" INNER JOIN T_FA_FaBakCard AS bak ON bak.FID = c.ffabakcardid AND bak.FAssetCatID!=c.FAssetCatID ");
        sql.append(" INNER JOIN T_FA_FaCurCard AS cur ON cur.FID = bak.ffacurcardid ");
        sql.append(" INNER JOIN T_BD_Period AS PERIOD ON A.FPeriodID = PERIOD.FID");
        sql.append(" INNER JOIN t_bd_currency AS currency on c.fcurrencyid = currency.FID");
        sql.append(" INNER JOIN T_FA_Cat AS assetCat ON bak.FAssetCatID = assetCat.FID");
        sql.append(" INNER JOIN T_BD_MeasureUnit MEASUREUNIT ON MEASUREUNIT.fid = c.FMeasureUnitID");
        sql.append(" LEFT OUTER JOIN T_FA_FaBizDepartment AS faDepartment ON c.fid = faDepartment.FFaBizCardID ");
        sql.append(" INNER JOIN T_ORG_ADMIN AS useDepartment ON faDepartment.FUseDepartmentID = useDepartment.FID ");
        if (this.filter != null && (this.filter.indexOf("asstActItem.fname_l2") != -1 || this.filter.indexOf("asstActType.fnumber") != -1)) {
            sql.append(" INNER JOIN T_FA_FABizCOSTCENTER costcenter on costcenter.ffabizcardid = c.fid");
            sql.append(" INNER JOIN T_FA_FABIZASSTACTCOMPOSIT composit on composit.FfaBizCostCenterId = costcenter.Fid");
            sql.append(" INNER JOIN t_bd_asstacttype asstActType on asstActType.Fid = composit.FasstActType");
            sql.append(" INNER JOIN " + this.acctAsstTableName + " AS asstActItem ON composit.FAsstActItem = asstActItem.FID AND asstActItem.fasstActTypeId = composit.fasstActType");
        }
        sql.append(" WHERE ").append(this.isShowNotAudit ? " A.feffectedStatus = 2" : " A.fcheckedStatus = 2");
        sql.append(" AND A.FCOMPANYID ");
        if (this.isVirCompany) {
            sql.append(" IN (").append(this.strCompanyInclude).append(") ");
        } else {
            sql.append(" ='").append(this.currCompanyInfo.getId().toString()).append("' ");
        }
        sql.append(this.getPeriodCondNullParam());
        if (this.filter != null) {
            String tmpFilter = this.filter.replaceAll("ASSETNUMBER", "cur.fnumber");
            tmpFilter = tmpFilter.replaceAll("assetName", "cur.fassetName");
            tmpFilter = tmpFilter.replaceAll("oldNumber", "cur.FOldNumber");
            tmpFilter = tmpFilter.replaceAll("groupNumber", "cur.fgroupNumber");
            sql.append(" AND ").append(tmpFilter);
        }
        sql.append(") AS A");
        if (this.isVirCompany) {
            sql.append(" INNER JOIN " + this.getSumItemJoinSql("orgArchitecture") + " COMPANY on COMPANY.fid = a.FCompanyID");
        }
        return sql.toString();
    }

    private String getMonthSumBalanceSQL() throws BOSException, EASBizException {
        if (!this.isGroupByAssetType) {
            return this.getMonthSumBalanceSQLOld();
        }
        if (this.isVirCompany) {
            return this.getMonthSumBalanceSQLNew(true) + " UNION ALL " + this.getMonthSumBalanceSQLNew(false);
        }
        int curr = this.currPeriod.getNumber();
        int start = this.startYear * 100 + this.startNumber;
        int end = this.endYear * 100 + this.endNumber;
        if (start < curr && curr < end) {
            return this.getMonthSumBalanceSQLNew(true) + " UNION ALL " + this.getMonthSumBalanceSQLNew(false);
        }
        if (start == curr && curr == end) {
            return this.getMonthSumBalanceSQLNew(true);
        }
        return this.getMonthSumBalanceSQLNew(false);
    }

    private String getMonthSumBalanceSQLOld() throws BOSException, EASBizException {
        List[] cardLists;
        List[] departmentLists;
        String filter;
        List[] cat;
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT ");
        if (this.isGroupByCard || this.isFromPrintCard) {
            sql.append(" mc.fassetname,");
        }
        sql.append(" mc.FCompanyID,mc.FAssetValue,mc.FAddons,mc.fnumber,MT.ffacurcardid,MT.PERIODYEAR,MT.PERIODNUMBER,MT.BIZDATE,");
        sql.append("MT.BRIEF,MT.SORT_COL,MT.isBegin,MT.VALUEBAL,MT.DEPRBAL,MT.DEVALUEBAL,MT.VALUEDEBIT,MT.VALUECREDIT,");
        sql.append("MT.DEPRDEBIT,MT.DEPRCREDIT,MT.DEVALUEDEBIT,MT.DEVALUECREDIT");
        sql.append(" FROM (");
        StringBuffer monthSql = new StringBuffer();
        monthSql.append(" SELECT b.ffacurcardid,PD.FID,");
        monthSql.append("b.").append(this.isByEvalue ? "FEvalueDebitFor" : "FrealDebitFor").append(" AS VALUEDEBIT, ");
        monthSql.append("b.").append(this.isByEvalue ? "FEvalueCreditFor" : "FrealCreditFor").append(" AS VALUECREDIT, ");
        monthSql.append("b.FdepreDebitFor AS DEPRDEBIT, ");
        monthSql.append("b.FdepreCreditFor AS DEPRCREDIT, ");
        monthSql.append("b.FdecValueDebitFor AS DEVALUEDEBIT, ");
        monthSql.append("b.FdecValueCreditFor AS DEVALUECREDIT, ");
        monthSql.append("case when STARTPERIOD.FNumber >= ").append(this.startYear * 100 + this.startNumber).append(" then STARTPERIOD.FPeriodYear else PD.FPeriodYear end AS PERIODYEAR,");
        monthSql.append("case when STARTPERIOD.FNumber >= ").append(this.startYear * 100 + this.startNumber).append(" then STARTPERIOD.FPeriodNumber else PD.FPeriodNumber end AS PERIODNUMBER,");
        monthSql.append("case when STARTPERIOD.FNumber >= ").append(this.startYear * 100 + this.startNumber).append(" then STARTPERIOD.FBeginDate else PD.FBeginDate end AS BIZDATE, ");
        monthSql.append("N'" + ResourceBase.getString((String)"com.kingdee.eas.fi.fa.basedata.FaResource", (String)"startPerionBalance", (Locale)this.ctx.getOriginLocale()) + "' AS BRIEF, ");
        monthSql.append("'1' AS SORT_COL,");
        monthSql.append("1 AS isBegin,");
        monthSql.append(" 0 AS VALUEBAL,");
        monthSql.append(" 0 AS DEPRBAL,");
        monthSql.append(" 0 AS DEVALUEBAL");
        monthSql.append(" from t_fa_faaccountbalance as b ");
        monthSql.append(" INNER JOIN T_BD_Period AS PERIOD ON b.FPeriodID = PERIOD.FID ");
        monthSql.append(" INNER JOIN T_BD_SystemStatusCtrol ssc on ssc.FCompanyID = b.FCompanyOrgUnitID ");
        monthSql.append(" INNER JOIN T_BD_SystemStatus ss ON ss.FID = ssc.FSystemStatusID AND ss.FName = ").append(14);
        monthSql.append(" INNER JOIN T_BD_PERIOD AS STARTPERIOD ON STARTPERIOD.FID = ssc.FStartPeriodID ");
        monthSql.append(" inner join t_Org_company cp on cp.fid = b.fcompanyorgunitid ");
        monthSql.append(" INNER JOIN T_BD_PERIOD AS PD ON PD.FNumber = ").append(this.startYear * 100 + this.startNumber);
        monthSql.append(" AND cp.faccountperiodid = pd.ftypeid");
        monthSql.append(" WHERE PERIOD.FNumber < ").append(this.startYear * 100 + this.startNumber);
        monthSql.append(" and PERIOD.FNumber >= ").append(this.startYear * 100 + 1);
        monthSql.append(" and PERIOD.FNumber >= STARTPERIOD.fnumber ");
        monthSql.append(" and b.FCompanyOrgUnitID ");
        if (this.isVirCompany) {
            monthSql.append(" IN (").append(this.strCompanyInclude).append(") ");
        } else {
            monthSql.append(" = '").append(this.currCompanyInfo.getId().toString()).append("' ");
        }
        monthSql.append("");
        monthSql.append(" union all ");
        monthSql.append(" SELECT b.ffacurcardid,b.FPeriodID,");
        monthSql.append("0 AS VALUEDEBIT, ");
        monthSql.append("0 AS VALUECREDIT, ");
        monthSql.append("0 AS DEPRDEBIT, ");
        monthSql.append("0 AS DEPRCREDIT, ");
        monthSql.append("0 AS DEVALUEDEBIT, ");
        monthSql.append("0 AS DEVALUECREDIT, ");
        monthSql.append("case when STARTPERIOD.FNumber >= ").append(this.startYear * 100 + this.startNumber).append(" then STARTPERIOD.FPeriodYear else PD.FPeriodYear end AS PERIODYEAR,");
        monthSql.append("case when STARTPERIOD.FNumber >= ").append(this.startYear * 100 + this.startNumber).append(" then STARTPERIOD.FPeriodNumber else PD.FPeriodNumber end AS PERIODNUMBER,");
        monthSql.append("case when STARTPERIOD.FNumber >= ").append(this.startYear * 100 + this.startNumber).append(" then STARTPERIOD.FBeginDate else PD.FBeginDate end AS BIZDATE, ");
        monthSql.append("N'" + ResourceBase.getString((String)"com.kingdee.eas.fi.fa.basedata.FaResource", (String)"startPerionBalance", (Locale)this.ctx.getOriginLocale()) + "' AS BRIEF, ");
        monthSql.append("'1' AS SORT_COL,");
        monthSql.append("1 AS isBegin,");
        monthSql.append(" b.").append(this.isByEvalue ? "FEvalueBeginBalanceFor" : "FRealBeginBalanceFor").append(" AS VALUEBAL,");
        monthSql.append(" b.FDepreBeginBalanceFor AS DEPRBAL,");
        monthSql.append(" b.FDecValueBeginBalanceFor AS DEVALUEBAL");
        monthSql.append(" FROM T_FA_FaAccountBalance AS b ");
        monthSql.append(" INNER JOIN T_BD_Period AS PERIOD ON b.FPeriodID = PERIOD.FID ");
        monthSql.append(" INNER JOIN T_BD_SystemStatusCtrol ssc on ssc.FCompanyID = b.FCompanyOrgUnitID ");
        monthSql.append(" INNER JOIN T_BD_SystemStatus ss ON ss.FID = ssc.FSystemStatusID AND ss.FName = ").append(14);
        monthSql.append(" INNER JOIN T_BD_PERIOD AS STARTPERIOD ON STARTPERIOD.FID = ssc.FStartPeriodID ");
        monthSql.append(" INNER JOIN t_Org_company cp on cp.fid = b.fcompanyorgunitid ");
        monthSql.append(" INNER JOIN T_BD_PERIOD AS PD ON PD.FNumber = ").append(this.startYear * 100 + this.startNumber);
        monthSql.append(" and cp.faccountperiodid = pd.ftypeid ");
        monthSql.append(" WHERE PERIOD.FNumber = (case when STARTPERIOD.FNumber >= ").append(this.startYear * 100 + this.startNumber).append(" then STARTPERIOD.FNumber else ").append(this.startYear * 100 + this.startNumber).append(" end )");
        monthSql.append(" and b.FCompanyOrgUnitID ");
        if (this.isVirCompany) {
            monthSql.append(" IN (").append(this.strCompanyInclude).append(") ");
        } else {
            monthSql.append(" = '").append(this.currCompanyInfo.getId().toString()).append("' ");
        }
        monthSql.append(" union all ");
        monthSql.append(" SELECT initcard.ffacurcardid,STARTPERIOD.FID,");
        if (this.isByEvalue) {
            monthSql.append("initdata.FOriginIncQty AS VALUEDEBIT, ");
        } else {
            monthSql.append("initdata.FOriginIncQty AS VALUEDEBIT, ");
        }
        if (this.isByEvalue) {
            monthSql.append("0 AS VALUECREDIT, ");
        } else {
            monthSql.append("initdata.FOriginDecQty AS VALUECREDIT, ");
        }
        monthSql.append("initdata.FDeprDecQty AS DEPRDEBIT, ");
        monthSql.append("initdata.FDeprIncQty+initcard.FAccuDeprTYear AS DEPRCREDIT, ");
        monthSql.append("initdata.fdecValueIncQty AS DEVALUEDEBIT, ");
        monthSql.append("initdata.fdecValueDecQty AS DEVALUECREDIT, ");
        monthSql.append("case when STARTPERIOD.FNumber >= ").append(this.startYear * 100 + this.startNumber).append(" then STARTPERIOD.FPeriodYear else PD.FPeriodYear end AS PERIODYEAR,");
        monthSql.append("case when STARTPERIOD.FNumber >= ").append(this.startYear * 100 + this.startNumber).append(" then STARTPERIOD.FPeriodNumber else PD.FPeriodNumber end AS PERIODNUMBER,");
        monthSql.append("case when STARTPERIOD.FNumber >= ").append(this.startYear * 100 + this.startNumber).append(" then STARTPERIOD.FBeginDate else PD.FBeginDate end AS BIZDATE, ");
        monthSql.append("N'" + ResourceBase.getString((String)"com.kingdee.eas.fi.fa.basedata.FaResource", (String)"startPerionBalance", (Locale)this.ctx.getOriginLocale()) + "' AS BRIEF, ");
        monthSql.append("'1' AS SORT_COL,");
        monthSql.append("1 AS isBegin,");
        monthSql.append(" 0 AS VALUEBAL, ");
        monthSql.append(" 0 AS DEPRBAL,");
        monthSql.append(" 0 AS DEVALUEBAL ");
        monthSql.append(" FROM T_FA_Famoninitdata AS initdata ");
        monthSql.append(" inner join t_fa_famoncard initcard on initcard.fid = initdata.ffamoncardid ");
        monthSql.append(" INNER JOIN T_BD_SystemStatusCtrol ssc on ssc.FCompanyID = initcard.FCompanyID ");
        monthSql.append(" INNER JOIN T_BD_SystemStatus ss ON ss.FID = ssc.FSystemStatusID AND ss.FName = ").append(14);
        monthSql.append(" INNER JOIN T_BD_PERIOD AS STARTPERIOD ON STARTPERIOD.FID = ssc.FStartPeriodID ");
        monthSql.append(" inner join t_Org_company cp on cp.fid = initcard.fcompanyid ");
        monthSql.append(" INNER JOIN T_BD_PERIOD AS PD ON PD.FNumber = ").append(this.startYear * 100 + this.startNumber);
        monthSql.append(" and cp.faccountperiodid = pd.ftypeid ");
        monthSql.append(" WHERE STARTPERIOD.FPeriodYear >= ").append(this.startYear).append(" AND STARTPERIOD.FPeriodYear <= ").append(this.endYear);
        monthSql.append(" AND initcard.FPeriodID is null AND initcard.fDeletedStatus = ").append(1);
        monthSql.append(" AND initcard.fcompanyid ");
        if (this.isVirCompany) {
            monthSql.append(" IN (").append(this.strCompanyInclude).append(") ");
        } else {
            monthSql.append(" = '").append(this.currCompanyInfo.getId().toString()).append("' ");
        }
        monthSql.append(" UNION ALL ");
        monthSql.append("SELECT ME.ffacurcardid,ME.FPeriodID,");
        monthSql.append("ME.").append(this.isByEvalue ? "FEvalueDebitFor" : "FRealDebitFor").append(" AS VALUEDEBIT, ");
        monthSql.append("ME.").append(this.isByEvalue ? "FEvalueCreditFor" : "FRealCreditFor").append(" AS VALUECREDIT, ");
        monthSql.append("ME.FDepreDebitFor AS DEPRDEBIT, ");
        monthSql.append("ME.FdepreCreditFor AS DEPRCREDIT, ");
        monthSql.append("ME.FDecValueDebitFor AS DEVALUEDEBIT, ");
        monthSql.append("ME.FDecValueCreditFor AS DEVALUECREDIT, ");
        monthSql.append("PERIOD.FPeriodYear AS PERIODYEAR,");
        monthSql.append("PERIOD.FPeriodNumber AS PERIODNUMBER,");
        monthSql.append("PERIOD.FEndDate AS BIZDATE, ");
        monthSql.append("N'" + ResourceBase.getString((String)"com.kingdee.eas.fi.fa.basedata.FaResource", (String)"yearTotal", (Locale)this.ctx.getOriginLocale()) + "' AS BRIEF, ");
        monthSql.append("'8' AS SORT_COL,");
        monthSql.append("2 AS isBegin,");
        monthSql.append(" ME.").append(this.isByEvalue ? "FEvalueEndBalanceFor" : "FRealEndBalanceFor").append(" AS VALUEBAL,");
        monthSql.append(" ME.FDepreEndBalanceFor AS DEPRBAL,");
        monthSql.append(" ME.FDecValueEndBalanceFor AS DEVALUEBAL");
        monthSql.append(" FROM T_FA_FaAccountBalance AS ME ");
        monthSql.append(" INNER JOIN T_BD_Period AS PERIOD ON ME.FPeriodID = PERIOD.FID ");
        monthSql.append(" INNER JOIN T_BD_SystemStatusCtrol ssc on ssc.FCompanyID = ME.FCompanyOrgUnitID ");
        monthSql.append(" INNER JOIN T_BD_PERIOD AS STARTPERIOD ON STARTPERIOD.FID = ssc.FStartPeriodID ");
        monthSql.append(" INNER JOIN T_BD_SystemStatus ss ON ss.FID = ssc.FSystemStatusID AND ss.FName = ").append(14);
        monthSql.append(" WHERE PERIOD.FNumber >= ").append(this.startYear * 100 + this.startNumber);
        monthSql.append(" AND PERIOD.FNumber <= ").append(this.endYear * 100 + this.endNumber);
        monthSql.append(" AND PERIOD.FNumber >= STARTPERIOD.FNumber");
        monthSql.append(" AND ME.FCompanyOrgUnitID ");
        if (this.isVirCompany) {
            monthSql.append(" IN (").append(this.strCompanyInclude).append(") ");
        } else {
            monthSql.append(" = '").append(this.currCompanyInfo.getId().toString()).append("' ");
        }
        sql.append(monthSql);
        sql.append(") AS MT");
        sql.append(" INNER JOIN T_FA_FaCurCard mc ON MT.ffacurcardid = mc.fid");
        sql.append(" INNER JOIN T_FA_Cat assetCat ON mc.fassetcatid = assetCat.fid");
        sql.append(" INNER JOIN T_BD_currency currency ON currency.fid = mc.fcurrencyid");
        if (this.isQuerySingleCard) {
            if (this.isGroupByDep || this.filter != null && this.filter.indexOf("useDepartment.fnumber") != -1) {
                sql.append(" inner JOIN T_FA_FaCurDepartment AS faDepartment ON mc.fid = faDepartment.FFaCurCardID ");
                sql.append(" INNER JOIN T_ORG_ADMIN AS useDepartment ON faDepartment.FUseDepartmentID = useDepartment.FID ");
            }
            if (this.filter != null && (this.filter.indexOf("asstActItem.fname_l2") != -1 || this.filter.indexOf("asstActType.fnumber") != -1)) {
                sql.append(" INNER JOIN T_FA_FACURCOSTCENTER costcenter on costcenter.ffacurcardid = mc.fid");
                sql.append(" INNER JOIN T_FA_FACURASSTACTCOMPOSIT composit on composit.FfaCurCostCenterId = costcenter.Fid");
                sql.append(" INNER JOIN t_bd_asstacttype asstActType on asstActType.Fid = composit.FasstActType");
                sql.append(" INNER JOIN " + this.acctAsstTableName + " AS asstActItem ON composit.FAsstActItem = asstActItem.FID AND asstActItem.fasstActTypeId = composit.fasstActType");
            }
        }
        sql.append(" WHERE mc.FCompanyID ");
        if (this.isVirCompany) {
            sql.append(" IN (").append(this.strCompanyInclude).append(")");
        } else {
            sql.append(" = '").append(this.currCompanyInfo.getId().toString()).append("'");
        }
        if (this.filter != null && this.filter.trim().length() > 0) {
            String tmpFilter = this.filter.replaceAll("ASSETNUMBER", "mc.fnumber");
            tmpFilter = tmpFilter.replaceAll("assetName", "mc.fassetName");
            tmpFilter = tmpFilter.replaceAll("oldNumber", "mc.foldnumber");
            tmpFilter = tmpFilter.replaceAll("groupNumber", "mc.fgroupNumber");
            sql.append(" AND ").append(tmpFilter);
        }
        if (this.isGroupByAssetType && ((ArrayList)(cat = this.getAssetCatList())[1]).size() > 0) {
            filter = ((ArrayList)cat[1]).get(0).toString();
            sql.append(" AND assetCat.flongnumber= '").append(filter).append("'");
        }
        if (this.isGroupByDep && ((ArrayList)(departmentLists = this.getAdminDepartmentList())[1]).size() > 0) {
            filter = ((ArrayList)departmentLists[1]).get(0).toString();
            sql.append(" AND useDepartment.flongnumber= '").append(filter).append("'");
        }
        if (this.isGroupByCard && !this.isFromPrintCard && !this.isShowNoIncurredAmtCard && ((ArrayList)(cardLists = this.getCardList())[1]).size() > 0) {
            filter = ((ArrayList)cardLists[1]).get(0).toString();
            sql.append(" AND mc.fnumber= '").append(filter).append("'");
        }
        return sql.toString();
    }

    private String getMonthSumBalanceSQLNew(boolean isIncludeCurrPeriod) throws BOSException, EASBizException {
        List[] cardLists;
        List[] departmentLists;
        String filter;
        List[] cat;
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT ");
        if (this.isGroupByCard || this.isFromPrintCard) {
            sql.append(" mc.fassetname,");
        }
        sql.append(" mc.FCompanyID,mc.FAssetValue,mc.FAddons,mc.fnumber,MT.ffacurcardid,MT.PERIODYEAR,MT.PERIODNUMBER,MT.BIZDATE,");
        sql.append("MT.BRIEF,MT.SORT_COL,MT.isBegin,MT.VALUEBAL,MT.DEPRBAL,MT.DEVALUEBAL,MT.VALUEDEBIT,MT.VALUECREDIT,");
        sql.append("MT.DEPRDEBIT,MT.DEPRCREDIT,MT.DEVALUEDEBIT,MT.DEVALUECREDIT");
        sql.append(" FROM (");
        StringBuffer monthSql = new StringBuffer();
        monthSql.append(" SELECT b.ffacurcardid,PD.FID,");
        monthSql.append("b.").append(this.isByEvalue ? "FEvalueDebitFor" : "FrealDebitFor").append(" AS VALUEDEBIT, ");
        monthSql.append("b.").append(this.isByEvalue ? "FEvalueCreditFor" : "FrealCreditFor").append(" AS VALUECREDIT, ");
        monthSql.append("b.FdepreDebitFor AS DEPRDEBIT, ");
        monthSql.append("b.FdepreCreditFor AS DEPRCREDIT, ");
        monthSql.append("b.FdecValueDebitFor AS DEVALUEDEBIT, ");
        monthSql.append("b.FdecValueCreditFor AS DEVALUECREDIT, ");
        monthSql.append("case when STARTPERIOD.FNumber >= ").append(this.startYear * 100 + this.startNumber).append(" then STARTPERIOD.FPeriodYear else PD.FPeriodYear end AS PERIODYEAR,");
        monthSql.append("case when STARTPERIOD.FNumber >= ").append(this.startYear * 100 + this.startNumber).append(" then STARTPERIOD.FPeriodNumber else PD.FPeriodNumber end AS PERIODNUMBER,");
        monthSql.append("case when STARTPERIOD.FNumber >= ").append(this.startYear * 100 + this.startNumber).append(" then STARTPERIOD.FBeginDate else PD.FBeginDate end AS BIZDATE, ");
        monthSql.append("N'" + ResourceBase.getString((String)"com.kingdee.eas.fi.fa.basedata.FaResource", (String)"startPerionBalance", (Locale)this.ctx.getLocale()) + "' AS BRIEF, ");
        monthSql.append("'1' AS SORT_COL,");
        monthSql.append("1 AS isBegin,");
        monthSql.append(" 0 AS VALUEBAL,");
        monthSql.append(" 0 AS DEPRBAL,");
        monthSql.append(" 0 AS DEVALUEBAL");
        monthSql.append(" from t_fa_faaccountbalance as b ");
        monthSql.append(" INNER JOIN T_BD_Period AS PERIOD ON b.FPeriodID = PERIOD.FID ");
        monthSql.append(" INNER JOIN T_BD_SystemStatusCtrol ssc on ssc.FCompanyID = b.FCompanyOrgUnitID ");
        monthSql.append(" INNER JOIN T_BD_SystemStatus ss ON ss.FID = ssc.FSystemStatusID AND ss.FName = ").append(14);
        monthSql.append(" INNER JOIN T_BD_PERIOD AS STARTPERIOD ON STARTPERIOD.FID = ssc.FStartPeriodID ");
        monthSql.append(" inner join t_Org_company cp on cp.fid = b.fcompanyorgunitid ");
        monthSql.append(" INNER JOIN T_BD_PERIOD AS PD ON PD.FNumber = ").append(this.startYear * 100 + this.startNumber);
        monthSql.append(" AND cp.faccountperiodid = pd.ftypeid");
        monthSql.append(" WHERE PERIOD.FNumber < ").append(this.startYear * 100 + this.startNumber);
        monthSql.append(" and PERIOD.FNumber >= ").append(this.startYear * 100 + 1);
        monthSql.append(" and PERIOD.FNumber >= STARTPERIOD.fnumber ");
        monthSql.append(" and b.FCompanyOrgUnitID ");
        if (this.isVirCompany) {
            monthSql.append(" IN (").append(this.strCompanyInclude).append(") ");
        } else {
            monthSql.append(" = '").append(this.currCompanyInfo.getId().toString()).append("' ");
        }
        monthSql.append("");
        monthSql.append(" union all ");
        monthSql.append(" SELECT b.ffacurcardid,b.FPeriodID,");
        monthSql.append("0 AS VALUEDEBIT, ");
        monthSql.append("0 AS VALUECREDIT, ");
        monthSql.append("0 AS DEPRDEBIT, ");
        monthSql.append("0 AS DEPRCREDIT, ");
        monthSql.append("0 AS DEVALUEDEBIT, ");
        monthSql.append("0 AS DEVALUECREDIT, ");
        monthSql.append("case when STARTPERIOD.FNumber >= ").append(this.startYear * 100 + this.startNumber).append(" then STARTPERIOD.FPeriodYear else PD.FPeriodYear end AS PERIODYEAR,");
        monthSql.append("case when STARTPERIOD.FNumber >= ").append(this.startYear * 100 + this.startNumber).append(" then STARTPERIOD.FPeriodNumber else PD.FPeriodNumber end AS PERIODNUMBER,");
        monthSql.append("case when STARTPERIOD.FNumber >= ").append(this.startYear * 100 + this.startNumber).append(" then STARTPERIOD.FBeginDate else PD.FBeginDate end AS BIZDATE, ");
        monthSql.append("N'" + ResourceBase.getString((String)"com.kingdee.eas.fi.fa.basedata.FaResource", (String)"startPerionBalance", (Locale)this.ctx.getLocale()) + "' AS BRIEF, ");
        monthSql.append("'1' AS SORT_COL,");
        monthSql.append("1 AS isBegin,");
        monthSql.append(" b.").append(this.isByEvalue ? "FEvalueBeginBalanceFor" : "FRealBeginBalanceFor").append(" AS VALUEBAL,");
        monthSql.append(" b.FDepreBeginBalanceFor AS DEPRBAL,");
        monthSql.append(" b.FDecValueBeginBalanceFor AS DEVALUEBAL");
        monthSql.append(" FROM T_FA_FaAccountBalance AS b ");
        monthSql.append(" INNER JOIN T_BD_Period AS PERIOD ON b.FPeriodID = PERIOD.FID ");
        monthSql.append(" INNER JOIN T_BD_SystemStatusCtrol ssc on ssc.FCompanyID = b.FCompanyOrgUnitID ");
        monthSql.append(" INNER JOIN T_BD_SystemStatus ss ON ss.FID = ssc.FSystemStatusID AND ss.FName = ").append(14);
        monthSql.append(" INNER JOIN T_BD_PERIOD AS STARTPERIOD ON STARTPERIOD.FID = ssc.FStartPeriodID ");
        monthSql.append(" INNER JOIN t_Org_company cp on cp.fid = b.fcompanyorgunitid ");
        monthSql.append(" INNER JOIN T_BD_PERIOD AS PD ON PD.FNumber = ").append(this.startYear * 100 + this.startNumber);
        monthSql.append(" and cp.faccountperiodid = pd.ftypeid ");
        monthSql.append(" WHERE PERIOD.FNumber = (case when STARTPERIOD.FNumber >= ").append(this.startYear * 100 + this.startNumber).append(" then STARTPERIOD.FNumber else ").append(this.startYear * 100 + this.startNumber).append(" end )");
        monthSql.append(" and b.FCompanyOrgUnitID ");
        if (this.isVirCompany) {
            monthSql.append(" IN (").append(this.strCompanyInclude).append(") ");
        } else {
            monthSql.append(" = '").append(this.currCompanyInfo.getId().toString()).append("' ");
        }
        monthSql.append(" union all ");
        monthSql.append(" SELECT initcard.ffacurcardid,STARTPERIOD.FID,");
        if (this.isByEvalue) {
            monthSql.append("initdata.FOriginIncQty AS VALUEDEBIT, ");
        } else {
            monthSql.append("initdata.FOriginIncQty AS VALUEDEBIT, ");
        }
        if (this.isByEvalue) {
            monthSql.append("0 AS VALUECREDIT, ");
        } else {
            monthSql.append("initdata.FOriginDecQty AS VALUECREDIT, ");
        }
        monthSql.append("initdata.FDeprDecQty AS DEPRDEBIT, ");
        monthSql.append("initdata.FDeprIncQty+initcard.FAccuDeprTYear AS DEPRCREDIT, ");
        monthSql.append("initdata.fdecValueIncQty AS DEVALUEDEBIT, ");
        monthSql.append("initdata.fdecValueDecQty AS DEVALUECREDIT, ");
        monthSql.append("case when STARTPERIOD.FNumber >= ").append(this.startYear * 100 + this.startNumber).append(" then STARTPERIOD.FPeriodYear else PD.FPeriodYear end AS PERIODYEAR,");
        monthSql.append("case when STARTPERIOD.FNumber >= ").append(this.startYear * 100 + this.startNumber).append(" then STARTPERIOD.FPeriodNumber else PD.FPeriodNumber end AS PERIODNUMBER,");
        monthSql.append("case when STARTPERIOD.FNumber >= ").append(this.startYear * 100 + this.startNumber).append(" then STARTPERIOD.FBeginDate else PD.FBeginDate end AS BIZDATE, ");
        monthSql.append("N'" + ResourceBase.getString((String)"com.kingdee.eas.fi.fa.basedata.FaResource", (String)"startPerionBalance", (Locale)this.ctx.getLocale()) + "' AS BRIEF, ");
        monthSql.append("'1' AS SORT_COL,");
        monthSql.append("1 AS isBegin,");
        monthSql.append(" 0 AS VALUEBAL, ");
        monthSql.append(" 0 AS DEPRBAL,");
        monthSql.append(" 0 AS DEVALUEBAL ");
        monthSql.append(" FROM T_FA_Famoninitdata AS initdata ");
        monthSql.append(" inner join t_fa_famoncard initcard on initcard.fid = initdata.ffamoncardid ");
        monthSql.append(" INNER JOIN T_BD_SystemStatusCtrol ssc on ssc.FCompanyID = initcard.FCompanyID ");
        monthSql.append(" INNER JOIN T_BD_SystemStatus ss ON ss.FID = ssc.FSystemStatusID AND ss.FName = ").append(14);
        monthSql.append(" INNER JOIN T_BD_PERIOD AS STARTPERIOD ON STARTPERIOD.FID = ssc.FStartPeriodID ");
        monthSql.append(" inner join t_Org_company cp on cp.fid = initcard.fcompanyid ");
        monthSql.append(" INNER JOIN T_BD_PERIOD AS PD ON PD.FNumber = ").append(this.startYear * 100 + this.startNumber);
        monthSql.append(" and cp.faccountperiodid = pd.ftypeid ");
        monthSql.append(" WHERE STARTPERIOD.FPeriodYear >= ").append(this.startYear).append(" AND STARTPERIOD.FPeriodYear <= ").append(this.endYear);
        monthSql.append(" AND initcard.FPeriodID is null AND initcard.fDeletedStatus = ").append(1);
        monthSql.append(" AND initcard.fcompanyid ");
        if (this.isVirCompany) {
            monthSql.append(" IN (").append(this.strCompanyInclude).append(") ");
        } else {
            monthSql.append(" = '").append(this.currCompanyInfo.getId().toString()).append("' ");
        }
        monthSql.append(" UNION ALL ");
        monthSql.append("SELECT ME.ffacurcardid,ME.FPeriodID,");
        monthSql.append("ME.").append(this.isByEvalue ? "FEvalueDebitFor" : "FRealDebitFor").append(" AS VALUEDEBIT, ");
        monthSql.append("ME.").append(this.isByEvalue ? "FEvalueCreditFor" : "FRealCreditFor").append(" AS VALUECREDIT, ");
        monthSql.append("ME.FDepreDebitFor AS DEPRDEBIT, ");
        monthSql.append("ME.FdepreCreditFor AS DEPRCREDIT, ");
        monthSql.append("ME.FDecValueDebitFor AS DEVALUEDEBIT, ");
        monthSql.append("ME.FDecValueCreditFor AS DEVALUECREDIT, ");
        monthSql.append("PERIOD.FPeriodYear AS PERIODYEAR,");
        monthSql.append("PERIOD.FPeriodNumber AS PERIODNUMBER,");
        monthSql.append("PERIOD.FEndDate AS BIZDATE, ");
        monthSql.append("N'" + ResourceBase.getString((String)"com.kingdee.eas.fi.fa.basedata.FaResource", (String)"yearTotal", (Locale)this.ctx.getLocale()) + "' AS BRIEF, ");
        monthSql.append("'8' AS SORT_COL,");
        monthSql.append("2 AS isBegin,");
        monthSql.append(" ME.").append(this.isByEvalue ? "FEvalueEndBalanceFor" : "FRealEndBalanceFor").append(" AS VALUEBAL,");
        monthSql.append(" ME.FDepreEndBalanceFor AS DEPRBAL,");
        monthSql.append(" ME.FDecValueEndBalanceFor AS DEVALUEBAL");
        monthSql.append(" FROM T_FA_FaAccountBalance AS ME ");
        monthSql.append(" INNER JOIN T_BD_Period AS PERIOD ON ME.FPeriodID = PERIOD.FID ");
        monthSql.append(" INNER JOIN T_BD_SystemStatusCtrol ssc on ssc.FCompanyID = ME.FCompanyOrgUnitID ");
        monthSql.append(" INNER JOIN T_BD_PERIOD AS STARTPERIOD ON STARTPERIOD.FID = ssc.FStartPeriodID ");
        monthSql.append(" INNER JOIN T_BD_SystemStatus ss ON ss.FID = ssc.FSystemStatusID AND ss.FName = ").append(14);
        monthSql.append(" WHERE PERIOD.FNumber >= ").append(this.startYear * 100 + this.startNumber);
        monthSql.append(" AND PERIOD.FNumber <= ").append(this.endYear * 100 + this.endNumber);
        monthSql.append(" AND PERIOD.FNumber >= STARTPERIOD.FNumber");
        monthSql.append(" AND ME.FCompanyOrgUnitID ");
        if (this.isVirCompany) {
            monthSql.append(" IN (").append(this.strCompanyInclude).append(") ");
        } else {
            monthSql.append(" = '").append(this.currCompanyInfo.getId().toString()).append("' ");
        }
        sql.append(monthSql);
        sql.append(") AS MT");
        if (isIncludeCurrPeriod) {
            sql.append(" INNER JOIN T_FA_FaCurCard mc ON MT.ffacurcardid = mc.fid");
            if (this.isVirCompany) {
                sql.append(" INNER JOIN ( SELECT sysctrl.FCOMPANYID FCOMPANYID, sysctrl.FCURRENTPERIODID FCURRENTPERIODID FROM T_BD_SYSTEMSTATUSCTROL sysctrl ");
                sql.append(" INNER JOIN T_BD_SYSTEMSTATUS sysstatus ON sysctrl.FSYSTEMSTATUSID = sysstatus.FID ");
                sql.append(" WHERE sysstatus.FNAME = ");
                sql.append(SystemEnum.FIXEDASSETS.getValue());
                sql.append(" ) AS currPeriod ON mc.FCompanyID = currPeriod.FCOMPANYID AND MT.fid = currPeriod.FCURRENTPERIODID ");
            }
        } else {
            sql.append(" INNER JOIN T_FA_FaMonCard mc ON MT.ffacurcardid = mc.ffacurcardid and MT.fid=mc.ffaperiodid");
        }
        sql.append(" INNER JOIN T_FA_Cat assetCat ON mc.fassetcatid = assetCat.fid");
        sql.append(" INNER JOIN T_BD_currency currency ON currency.fid = mc.fcurrencyid");
        if (this.isQuerySingleCard) {
            if (this.isGroupByDep || this.filter != null && this.filter.indexOf("useDepartment.fnumber") != -1) {
                sql.append(" inner JOIN T_FA_FaCurDepartment AS faDepartment ON mc.fid = faDepartment.FFaCurCardID ");
                sql.append(" INNER JOIN T_ORG_ADMIN AS useDepartment ON faDepartment.FUseDepartmentID = useDepartment.FID ");
            }
            if (this.filter != null && (this.filter.indexOf("asstActItem.fname_l2") != -1 || this.filter.indexOf("asstActType.fnumber") != -1)) {
                sql.append(" INNER JOIN T_FA_FACURCOSTCENTER costcenter on costcenter.ffacurcardid = mc.fid");
                sql.append(" INNER JOIN T_FA_FACURASSTACTCOMPOSIT composit on composit.FfaCurCostCenterId = costcenter.Fid");
                sql.append(" INNER JOIN t_bd_asstacttype asstActType on asstActType.Fid = composit.FasstActType");
                sql.append(" INNER JOIN " + this.acctAsstTableName + " AS asstActItem ON composit.FAsstActItem = asstActItem.FID AND asstActItem.fasstActTypeId = composit.fasstActType");
            }
        }
        if (isIncludeCurrPeriod && !this.isVirCompany) {
            sql.append(" WHERE MT.PERIODYEAR=").append(this.currPeriod.getPeriodYear());
            sql.append(" AND MT.PERIODNUMBER=").append(this.currPeriod.getPeriodNumber());
            sql.append(" AND mc.FCompanyID ");
        } else {
            sql.append(" WHERE mc.FCompanyID ");
        }
        if (this.isVirCompany) {
            sql.append(" IN (").append(this.strCompanyInclude).append(")");
        } else {
            sql.append(" = '").append(this.currCompanyInfo.getId().toString()).append("'");
        }
        if (this.filter != null && this.filter.trim().length() > 0) {
            String tmpFilter = this.filter.replaceAll("ASSETNUMBER", "mc.fnumber");
            tmpFilter = tmpFilter.replaceAll("assetName", "mc.fassetName");
            tmpFilter = tmpFilter.replaceAll("oldNumber", "mc.foldnumber");
            tmpFilter = tmpFilter.replaceAll("groupNumber", "mc.fgroupNumber");
            sql.append(" AND ").append(tmpFilter);
        }
        if (this.isGroupByAssetType && ((ArrayList)(cat = this.getAssetCatList())[1]).size() > 0) {
            filter = ((ArrayList)cat[1]).get(0).toString();
            sql.append(" AND assetCat.flongnumber= '").append(filter).append("'");
        }
        if (this.isGroupByDep && ((ArrayList)(departmentLists = this.getAdminDepartmentList())[1]).size() > 0) {
            filter = ((ArrayList)departmentLists[1]).get(0).toString();
            sql.append(" AND useDepartment.flongnumber= '").append(filter).append("'");
        }
        if (this.isGroupByCard && !this.isFromPrintCard && !this.isShowNoIncurredAmtCard && ((ArrayList)(cardLists = this.getCardList())[1]).size() > 0) {
            filter = ((ArrayList)cardLists[1]).get(0).toString();
            sql.append(" AND mc.fnumber= '").append(filter).append("'");
        }
        return sql.toString();
    }

    private String createMonthSumSql() throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(this.getSQLSelect());
        sql.append(" FROM( ");
        sql.append("SELECT DISTINCT ");
        sql.append("c.FCompanyID,");
        sql.append("PERIOD.FPeriodYear AS PERIODYEAR,");
        sql.append("PERIOD.FPeriodNumber AS PERIODNUMBER,");
        sql.append("TO_DATE(CONCAT(TO_CHAR(A.FCHANGEDATE,'yyyy-mm-dd'), ' 00:00:00')) AS BIZDATE, ");
        sql.append("N'" + ResourceBase.getString((String)"com.kingdee.eas.fi.fa.basedata.FaResource", (String)"yearTotal", (Locale)this.ctx.getLocale()) + "' AS BRIEF, ");
        sql.append(this.getCatAdminSql(this.isGroupByDep, this.isGroupByAssetType));
        sql.append("TO_CHAR(NULL) AS BILLID, ");
        sql.append("TO_CHAR(NULL) AS FACURCARDID, ");
        sql.append("TO_CHAR(NULL) AS FACURCARDNUM, ");
        sql.append("TO_CHAR(NULL) as voucherNumber,");
        sql.append("TO_CHAR(NULL) as abstract,");
        sql.append("TO_CHAR(NULL) AS bizNumber,");
        sql.append("TO_CHAR(NULL) BILLTYPE, ");
        sql.append("TO_CHAR(NULL) AS ASSETNUMBER, ");
        sql.append("TO_CHAR(NULL) AS OLDERNUMBER, ");
        sql.append("TO_CHAR(NULL) as GROUPNUMBER, ");
        sql.append("TO_CHAR(NULL) AS ASSETNAME, ");
        sql.append("TO_CHAR(NULL) AS UNIT, ");
        sql.append("TO_CHAR(NULL) AS ASSETAMT, ");
        sql.append("TO_CHAR(NULL) AS CURRENCY, ");
        sql.append("TO_CHAR(NULL) AS Fcurrencypre, ");
        sql.append("TO_CHAR(NULL) AS FExRate, ");
        sql.append("TO_CHAR(NULL) AS FOriginAmt, ");
        sql.append("TO_CHAR(NULL) AS FAddons, ");
        sql.append("TO_CHAR(NULL) AS FAssetValue, ");
        if (this.isByEvalue) {
            sql.append("ABS((CASE WHEN c.FINITEVALVALUE-c.FLASTEVALVALUE>0 THEN c.FINITEVALVALUE-c.FLASTEVALVALUE ELSE 0 END)) AS VALUEDEBIT, ");
            sql.append("ABS((CASE WHEN c.FINITEVALVALUE-c.FLASTEVALVALUE<0 THEN c.FINITEVALVALUE-c.FLASTEVALVALUE ELSE 0 END))  AS VALUECREDIT, ");
            sql.append("000000000000.0000 AS VALUEBAL, ");
        } else {
            sql.append("000000000000.0000 AS VALUEDEBIT, ");
            sql.append("000000000000.0000 AS VALUECREDIT, ");
            sql.append("000000000000.0000 AS VALUEBAL, ");
        }
        sql.append("000000000000.0000 AS DEPRDEBIT,");
        sql.append("000000000000.0000 AS DEPRCREDIT,");
        sql.append("000000000000.0000 AS DEPRBAL, ");
        sql.append("000000000000.0000 AS DEVALUEDEBIT, ");
        sql.append("000000000000.0000 AS DEVALUECREDIT, ");
        sql.append("000000000000.0000 AS DEVALUEBAL,");
        sql.append("1 AS FYearOrMonth, ");
        sql.append("'8' AS SORT_COL,");
        sql.append("2 AS isBegin");
        sql.append(" FROM T_FA_FACHANGEBILL AS A ");
        sql.append(" INNER JOIN T_FA_FACHANGEBILLENTRY AS B ON A.FID = B.FCHANGEBILLID");
        sql.append(" INNER JOIN T_FA_ALTERMODE AS alterMode ON alterMode.FID = A.FChangeModeID");
        sql.append(" INNER JOIN T_FA_FABIZCARD AS c ON B.FBIZCARDID = c.FID");
        sql.append(" INNER JOIN T_FA_FaBakCard AS bak ON bak.FID = c.ffabakcardid AND bak.FAssetCatID!=c.FAssetCatID ");
        sql.append(" INNER JOIN T_FA_FaCurCard AS cur ON cur.FID = bak.ffacurcardid ");
        sql.append(" INNER JOIN T_BD_Period AS PERIOD ON A.FPeriodID = PERIOD.FID");
        sql.append(" INNER JOIN t_bd_currency AS currency on c.fcurrencyid = currency.FID");
        sql.append(" INNER JOIN T_FA_Cat AS assetCat ON bak.FAssetCatID = assetCat.FID");
        sql.append(" INNER JOIN T_BD_MeasureUnit MEASUREUNIT ON MEASUREUNIT.fid = c.FMeasureUnitID");
        sql.append(" LEFT OUTER JOIN T_FA_FaBizDepartment AS faDepartment ON c.fid = faDepartment.FFaBizCardID ");
        sql.append(" INNER JOIN T_ORG_ADMIN AS useDepartment ON faDepartment.FUseDepartmentID = useDepartment.FID ");
        if (this.filter != null && (this.filter.indexOf("asstActItem.fname_l2") != -1 || this.filter.indexOf("asstActType.fnumber") != -1)) {
            sql.append(" INNER JOIN T_FA_FABizCOSTCENTER costcenter on costcenter.ffabizcardid = c.fid");
            sql.append(" INNER JOIN T_FA_FABIZASSTACTCOMPOSIT composit on composit.FfaBizCostCenterId = costcenter.Fid");
            sql.append(" INNER JOIN t_bd_asstacttype asstActType on asstActType.Fid = composit.FasstActType");
            sql.append(" INNER JOIN " + this.acctAsstTableName + " AS asstActItem ON composit.FAsstActItem = asstActItem.FID AND asstActItem.fasstActTypeId = composit.fasstActType");
        }
        sql.append(" WHERE ").append(this.isShowNotAudit ? " A.feffectedStatus = 2" : " A.fcheckedStatus = 2");
        sql.append(" AND A.FCOMPANYID ");
        if (this.isVirCompany) {
            sql.append(" IN (").append(this.strCompanyInclude).append(") ");
        } else {
            sql.append(" ='").append(this.currCompanyInfo.getId().toString()).append("' ");
        }
        sql.append(this.getPeriodCondNullParam());
        if (this.filter != null) {
            String tmpFilter = this.filter.replaceAll("ASSETNUMBER", "cur.fnumber");
            tmpFilter = tmpFilter.replaceAll("assetName", "cur.fassetName");
            tmpFilter = tmpFilter.replaceAll("oldNumber", "cur.FOldNumber");
            tmpFilter = tmpFilter.replaceAll("groupNumber", "cur.fgroupNumber");
            sql.append(" AND ").append(tmpFilter);
        }
        sql.append(") AS A");
        if (this.isVirCompany) {
            sql.append(" INNER JOIN " + this.getSumItemJoinSql("orgArchitecture") + " COMPANY on COMPANY.fid = a.FCompanyID");
        }
        return sql.toString();
    }

    private String getChangeBillSql() throws BOSException {
        if (!this.isGroupByAssetType) {
            return this.getChangeBillSqlOld();
        }
        StringBuffer sb = new StringBuffer();
        sb.append(this.getChangeBillSqlNewNotAlter());
        sb.append(" UNION ALL ");
        sb.append(this.getChangeBillSqlNewAlter());
        sb.append(" UNION ALL ");
        sb.append(this.createChangeBillSql());
        return sb.toString();
    }

    private void createYearMonthSumSql() throws BOSException {
        String isAlterSql = "SELECT DISTINCT temp.PERIODYEAR, temp.PERIODNUMBER FROM (" + this.createChangeBillSql() + ") temp";
        IRowSet iRowSet = DbUtil.executeQuery((Context)this.ctx, (String)isAlterSql.toString());
        try {
            while (iRowSet.next()) {
                int periodNumber;
                int periodYear = iRowSet.getInt("PERIODYEAR");
                boolean isExsit = this.isExistMonthData(periodYear, periodNumber = iRowSet.getInt("PERIODNUMBER"));
                if (isExsit) continue;
                StringBuffer sqlCreate = new StringBuffer();
                sqlCreate.append(this.createYearSumSql());
                sqlCreate.append(" WHERE A.PERIODYEAR=").append(periodYear);
                sqlCreate.append(" AND A.PERIODNUMBER=").append(periodNumber);
                sqlCreate.append(" UNION ALL ");
                sqlCreate.append(this.createMonthSumSql());
                sqlCreate.append(" WHERE A.PERIODYEAR=").append(periodYear);
                sqlCreate.append(" AND A.PERIODNUMBER=").append(periodNumber);
                DbUtil.execute((Context)this.ctx, (String)FaLocalUtils.transformLocal((Context)this.ctx, (String)("INSERT INTO " + this.tempTable + " select * from (" + sqlCreate.toString() + ") as tempTable ")));
            }
        }
        catch (SQLException ex) {
            throw new BOSException("sql error: " + isAlterSql.toString(), (Throwable)ex);
        }
    }

    private void updateMonthSumSql() throws BOSException {
        String isAlterSql = "SELECT DISTINCT temp.PERIODYEAR, temp.PERIODNUMBER FROM (" + this.createChangeBillSql(true) + ") temp";
        IRowSet iRowSet = DbUtil.executeQuery((Context)this.ctx, (String)isAlterSql.toString());
        try {
            while (iRowSet.next()) {
                int periodYear = iRowSet.getInt("PERIODYEAR");
                int periodNumber = iRowSet.getInt("PERIODNUMBER");
                this.updateMonthSumSql(periodYear, periodNumber);
            }
        }
        catch (SQLException ex) {
            throw new BOSException("sql error: " + isAlterSql.toString(), (Throwable)ex);
        }
        isAlterSql = "SELECT DISTINCT temp.PERIODYEAR, temp.PERIODNUMBER FROM (" + this.getChangeBillSqlNewAlter(true) + ") temp";
        IRowSet iRowSetB = DbUtil.executeQuery((Context)this.ctx, (String)isAlterSql.toString());
        try {
            while (iRowSetB.next()) {
                int periodYear = iRowSetB.getInt("PERIODYEAR");
                int periodNumber = iRowSetB.getInt("PERIODNUMBER");
                this.updateMonthSumSqlB(periodYear, periodNumber);
            }
        }
        catch (SQLException ex) {
            throw new BOSException("sql error: " + isAlterSql.toString(), (Throwable)ex);
        }
    }

    private boolean isExistMonthData(int periodYear, int periodNumber) throws BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT * FROM ").append(this.tempTable);
        sb.append(" WHERE PERIODYEAR=").append(periodYear);
        sb.append(" AND PERIODNUMBER=").append(periodNumber);
        sb.append(" AND FYearOrMonth=1 AND SORT_COL=8 and isbegin=2");
        IRowSet rowSet = DbUtil.executeQuery((Context)this.ctx, (String)sb.toString());
        if (rowSet != null) {
            try {
                if (rowSet.next()) {
                    return true;
                }
            }
            catch (SQLException e) {
                throw new BOSException("sql error: " + sb.toString(), (Throwable)e);
            }
        }
        return false;
    }

    private void updateMonthSumSql(int periodYear, int periodNumber) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT SUM(VALUECREDIT) VALUESUM, SUM(DEPRDEBIT) DEPRSUM, SUM(DEVALUEDEBIT) DEVALUESUM FROM (");
        if (periodYear * 100 + periodNumber < this.startYear * 100 + this.startNumber) {
            sql.append(this.createChangeBillSql(true));
        } else {
            sql.append(this.createChangeBillSql());
        }
        sql.append(" WHERE A.PERIODYEAR=").append(periodYear);
        sql.append(" AND A.PERIODNUMBER=").append(periodNumber);
        sql.append(") B");
        IRowSet rowSet = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
        BigDecimal valueSum = new BigDecimal(0);
        BigDecimal deprSum = new BigDecimal(0);
        BigDecimal devalueSum = new BigDecimal(0);
        if (rowSet != null) {
            try {
                if (rowSet.next()) {
                    valueSum = rowSet.getBigDecimal("VALUESUM");
                    deprSum = rowSet.getBigDecimal("DEPRSUM");
                    devalueSum = rowSet.getBigDecimal("DEVALUESUM");
                }
            }
            catch (SQLException e) {
                throw new BOSException("sql error: " + sql.toString(), (Throwable)e);
            }
        }
        if (valueSum != null && deprSum != null && devalueSum != null) {
            sql = new StringBuffer();
            sql.append("UPDATE ").append(this.tempTable).append(" SET ");
            sql.append(" VALUECREDIT=VALUECREDIT+").append(valueSum);
            sql.append(" ,DEPRDEBIT=DEPRDEBIT+").append(deprSum);
            sql.append(" ,DEVALUEDEBIT=DEVALUEDEBIT+").append(devalueSum);
            if (periodYear * 100 + periodNumber < this.startYear * 100 + this.startNumber) {
                sql.append(" ,VALUEBAL=VALUEBAL-").append(valueSum);
                sql.append(" ,DEPRBAL=DEPRBAL-").append(deprSum);
                sql.append(" ,DEVALUEBAL=DEVALUEBAL-").append(devalueSum);
                sql.append(" WHERE FYearOrMonth=1 AND SORT_COL=1 and isbegin=1");
            } else {
                sql.append(" WHERE FYearOrMonth=1 AND SORT_COL=8 and isbegin=2");
                sql.append(" and periodyear=").append(periodYear);
                sql.append(" and periodnumber=").append(periodNumber);
            }
            DbUtil.execute((Context)this.ctx, (String)FaLocalUtils.transformLocal((Context)this.ctx, (String)sql.toString()));
        }
        if (periodYear * 100 + periodNumber <= this.startYear * 100 + this.startNumber) {
            sql = new StringBuffer();
            sql.append("SELECT ");
            sql.append(" ").append(this.isByEvalue ? "SUM(FEvalueDebitFor)" : "SUM(FrealDebitFor)").append(" AS VALUEDEBIT, ");
            sql.append(" ").append(this.isByEvalue ? "SUM(FEvalueCreditFor)" : "SUM(FrealCreditFor)").append(" AS VALUECREDIT, ");
            sql.append(" SUM(FdepreDebitFor) AS DEPRDEBIT, ");
            sql.append(" SUM(FAddUpYearDepre-FDepreCreditFor) AS DEPRCREDIT, ");
            sql.append(" SUM(FdecValueDebitFor) AS DEVALUEDEBIT, ");
            sql.append(" SUM(FdecValueCreditFor) AS DEVALUECREDIT, ");
            sql.append(" ").append(this.isByEvalue ? "SUM(FEvalueBeginBalanceFor)" : "SUM(FRealBeginBalanceFor)").append(" AS VALUEBAL,");
            sql.append(" SUM(FDepreBeginBalanceFor) AS DEPRBAL,");
            sql.append(" SUM(FDecValueBeginBalanceFor) AS DEVALUEBAL");
            sql.append(" FROM T_FA_FaAccountBalance ");
            sql.append(" WHERE fcompanyorgunitid='").append(this.currCompanyInfo.getId().toString()).append("'");
            sql.append(" AND FPeriodID IN (SELECT FID FROM t_bd_period WHERE FNUMBER=").append(periodYear * 100 + periodNumber).append(") ");
            sql.append(" AND ffacurcardid IN ");
            sql.append(" (SELECT DISTINCT FACURCARDID FROM (");
            sql.append(this.createChangeBillSql(true));
            sql.append(" WHERE A.PERIODYEAR=").append(periodYear);
            sql.append(" AND A.PERIODNUMBER=").append(periodNumber);
            sql.append(" ) B)");
            rowSet = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
            BigDecimal valueDebitSum = new BigDecimal(0);
            BigDecimal deprDebitSum = new BigDecimal(0);
            BigDecimal devalueDebitSum = new BigDecimal(0);
            BigDecimal valueCreditSum = new BigDecimal(0);
            BigDecimal deprCreditSum = new BigDecimal(0);
            BigDecimal devalueCreditSum = new BigDecimal(0);
            BigDecimal valueBalSum = new BigDecimal(0);
            BigDecimal deprBalSum = new BigDecimal(0);
            BigDecimal devalueBalSum = new BigDecimal(0);
            if (rowSet != null) {
                try {
                    if (rowSet.next()) {
                        valueDebitSum = rowSet.getBigDecimal("VALUEDEBIT");
                        valueCreditSum = rowSet.getBigDecimal("VALUECREDIT");
                        deprDebitSum = rowSet.getBigDecimal("DEPRDEBIT");
                        deprCreditSum = rowSet.getBigDecimal("DEPRCREDIT");
                        devalueDebitSum = rowSet.getBigDecimal("DEVALUEDEBIT");
                        devalueCreditSum = rowSet.getBigDecimal("DEVALUECREDIT");
                        valueBalSum = rowSet.getBigDecimal("VALUEBAL");
                        deprBalSum = rowSet.getBigDecimal("DEPRBAL");
                        devalueBalSum = rowSet.getBigDecimal("DEVALUEBAL");
                    }
                }
                catch (SQLException e) {
                    throw new BOSException("sql error: " + sql.toString(), (Throwable)e);
                }
            }
            sql = new StringBuffer();
            sql.append("UPDATE ").append(this.tempTable).append(" SET");
            sql.append(" VALUEDEBIT=VALUEDEBIT+").append(valueDebitSum);
            sql.append(" ,VALUECREDIT=VALUECREDIT+").append(valueCreditSum);
            sql.append(" ,DEPRDEBIT=DEPRDEBIT+").append(deprDebitSum);
            sql.append(" ,DEPRCREDIT=DEPRCREDIT+").append(deprCreditSum);
            sql.append(" ,DEVALUEDEBIT=DEVALUEDEBIT+").append(devalueDebitSum);
            sql.append(" ,DEVALUECREDIT=DEVALUECREDIT+").append(devalueCreditSum);
            sql.append(" ,VALUEBAL=VALUEBAL+").append(valueBalSum);
            sql.append(" ,DEPRBAL=DEPRBAL+").append(deprBalSum);
            sql.append(" ,DEVALUEBAL=DEVALUEBAL+").append(devalueBalSum);
            sql.append(" WHERE FYearOrMonth=1 AND SORT_COL=1 and isbegin=1");
            DbUtil.execute((Context)this.ctx, (String)FaLocalUtils.transformLocal((Context)this.ctx, (String)sql.toString()));
        }
    }

    private void updateMonthSumSqlB(int periodYear, int periodNumber) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT SUM(VALUEDEBIT) VALUESUM, SUM(DEPRCREDIT) DEPRSUM, SUM(DEVALUECREDIT) DEVALUESUM FROM (");
        if (periodYear * 100 + periodNumber < this.startYear * 100 + this.startNumber) {
            sql.append(this.getChangeBillSqlNewAlter(true));
        } else {
            sql.append(this.getChangeBillSqlNewAlter());
        }
        sql.append(" WHERE A.PERIODYEAR=").append(periodYear);
        sql.append(" AND A.PERIODNUMBER=").append(periodNumber);
        sql.append(") B");
        IRowSet rowSet = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
        BigDecimal valueSum = new BigDecimal(0);
        BigDecimal deprSum = new BigDecimal(0);
        BigDecimal devalueSum = new BigDecimal(0);
        if (rowSet != null) {
            try {
                if (rowSet.next()) {
                    valueSum = rowSet.getBigDecimal("VALUESUM");
                    deprSum = rowSet.getBigDecimal("DEPRSUM");
                    devalueSum = rowSet.getBigDecimal("DEVALUESUM");
                }
            }
            catch (SQLException e) {
                throw new BOSException("sql error: " + sql.toString(), (Throwable)e);
            }
        }
        if (valueSum != null && deprSum != null && devalueSum != null) {
            sql = new StringBuffer();
            sql.append("UPDATE ").append(this.tempTable).append(" SET ");
            sql.append(" VALUEDEBIT=VALUEDEBIT+").append(valueSum);
            sql.append(" ,DEPRCREDIT=DEPRCREDIT+").append(deprSum);
            sql.append(" ,DEVALUECREDIT=DEVALUECREDIT+").append(devalueSum);
            if (periodYear * 100 + periodNumber < this.startYear * 100 + this.startNumber) {
                sql.append(" ,VALUEBAL=VALUEBAL+").append(valueSum);
                sql.append(" ,DEPRBAL=DEPRBAL+").append(deprSum);
                sql.append(" ,DEVALUEBAL=DEVALUEBAL+").append(devalueSum);
                sql.append(" WHERE FYearOrMonth=1 AND SORT_COL=1 and isbegin=1");
            } else {
                sql.append(" WHERE FYearOrMonth=1 AND SORT_COL=8 and isbegin=2");
                sql.append(" and periodyear=").append(periodYear);
                sql.append(" and periodnumber=").append(periodNumber);
            }
            DbUtil.execute((Context)this.ctx, (String)FaLocalUtils.transformLocal((Context)this.ctx, (String)sql.toString()));
        }
        if (periodYear * 100 + periodNumber <= this.startYear * 100 + this.startNumber) {
            sql = new StringBuffer();
            sql.append("SELECT ");
            sql.append(" ").append(this.isByEvalue ? "SUM(FEvalueDebitFor)" : "SUM(FrealDebitFor)").append(" AS VALUEDEBIT, ");
            sql.append(" ").append(this.isByEvalue ? "SUM(FEvalueCreditFor)" : "SUM(FrealCreditFor)").append(" AS VALUECREDIT, ");
            sql.append(" SUM(FdepreDebitFor) AS DEPRDEBIT, ");
            sql.append(" SUM(FAddUpYearDepre-FDepreCreditFor) AS DEPRCREDIT, ");
            sql.append(" SUM(FdecValueDebitFor) AS DEVALUEDEBIT, ");
            sql.append(" SUM(FdecValueCreditFor) AS DEVALUECREDIT, ");
            sql.append(" ").append(this.isByEvalue ? "SUM(FEvalueBeginBalanceFor)" : "SUM(FRealBeginBalanceFor)").append(" AS VALUEBAL,");
            sql.append(" SUM(FDepreBeginBalanceFor) AS DEPRBAL,");
            sql.append(" SUM(FDecValueBeginBalanceFor) AS DEVALUEBAL");
            sql.append(" FROM T_FA_FaAccountBalance ");
            sql.append(" WHERE fcompanyorgunitid='").append(this.currCompanyInfo.getId().toString()).append("'");
            sql.append(" AND FPeriodID IN (SELECT FID FROM t_bd_period WHERE FNUMBER=").append(periodYear * 100 + periodNumber).append(") ");
            sql.append(" AND ffacurcardid IN ");
            sql.append(" (SELECT DISTINCT FACURCARDID FROM (");
            sql.append(this.getChangeBillSqlNewAlter(true));
            sql.append(" WHERE A.PERIODYEAR=").append(periodYear);
            sql.append(" AND A.PERIODNUMBER=").append(periodNumber);
            sql.append(" ) B)");
            rowSet = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
            BigDecimal valueDebitSum = new BigDecimal(0);
            BigDecimal deprDebitSum = new BigDecimal(0);
            BigDecimal devalueDebitSum = new BigDecimal(0);
            BigDecimal valueCreditSum = new BigDecimal(0);
            BigDecimal deprCreditSum = new BigDecimal(0);
            BigDecimal devalueCreditSum = new BigDecimal(0);
            BigDecimal valueBalSum = new BigDecimal(0);
            BigDecimal deprBalSum = new BigDecimal(0);
            BigDecimal devalueBalSum = new BigDecimal(0);
            if (rowSet != null) {
                try {
                    if (rowSet.next()) {
                        valueDebitSum = rowSet.getBigDecimal("VALUEDEBIT");
                        valueCreditSum = rowSet.getBigDecimal("VALUECREDIT");
                        deprDebitSum = rowSet.getBigDecimal("DEPRDEBIT");
                        deprCreditSum = rowSet.getBigDecimal("DEPRCREDIT");
                        devalueDebitSum = rowSet.getBigDecimal("DEVALUEDEBIT");
                        devalueCreditSum = rowSet.getBigDecimal("DEVALUECREDIT");
                        valueBalSum = rowSet.getBigDecimal("VALUEBAL");
                        deprBalSum = rowSet.getBigDecimal("DEPRBAL");
                        devalueBalSum = rowSet.getBigDecimal("DEVALUEBAL");
                    }
                }
                catch (SQLException e) {
                    throw new BOSException("sql error: " + sql.toString(), (Throwable)e);
                }
            }
            sql = new StringBuffer();
            sql.append("UPDATE ").append(this.tempTable).append(" SET");
            sql.append(" VALUEDEBIT=VALUEDEBIT-").append(valueDebitSum);
            sql.append(" ,VALUECREDIT=VALUECREDIT-").append(valueCreditSum);
            sql.append(" ,DEPRDEBIT=DEPRDEBIT-").append(deprDebitSum);
            sql.append(" ,DEPRCREDIT=DEPRCREDIT-").append(deprCreditSum);
            sql.append(" ,DEVALUEDEBIT=DEVALUEDEBIT-").append(devalueDebitSum);
            sql.append(" ,DEVALUECREDIT=DEVALUECREDIT-").append(devalueCreditSum);
            sql.append(" ,VALUEBAL=VALUEBAL-").append(valueBalSum);
            sql.append(" ,DEPRBAL=DEPRBAL-").append(deprBalSum);
            sql.append(" ,DEVALUEBAL=DEVALUEBAL-").append(devalueBalSum);
            sql.append(" WHERE FYearOrMonth=1 AND SORT_COL=1 and isbegin=1");
            DbUtil.execute((Context)this.ctx, (String)FaLocalUtils.transformLocal((Context)this.ctx, (String)sql.toString()));
        }
    }

    private String getChangeBillSqlNewNotAlter() throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(this.getSQLSelect());
        sql.append(" FROM( ");
        sql.append("SELECT DISTINCT ");
        sql.append("c.FCompanyID,");
        sql.append("PERIOD.FPeriodYear AS PERIODYEAR,");
        sql.append("PERIOD.FPeriodNumber AS PERIODNUMBER,");
        sql.append("TO_DATE(CONCAT(TO_CHAR(A.FCHANGEDATE,'yyyy-mm-dd'), ' 00:00:00')) AS BIZDATE, ");
        sql.append("alterMode.FName_l2 AS BRIEF, ");
        sql.append(this.getCatAdminSql(this.isGroupByDep, this.isGroupByAssetType));
        sql.append("A.FID AS BILLID, ");
        sql.append("B.FCURCARDID AS FACURCARDID, ");
        sql.append("cur.fnumber AS FACURCARDNUM, ");
        sql.append("A.fvoucherNumber as voucherNumber,");
        sql.append("A.fabstract as abstract,");
        sql.append("A.Fnumber AS bizNumber,");
        sql.append("1 AS BILLTYPE, ");
        sql.append("c.FNumber AS ASSETNUMBER, ");
        sql.append("c.FOldNumber AS OLDERNUMBER, ");
        sql.append("c.fgroupNumber as GROUPNUMBER, ");
        sql.append("c.FAssetName AS ASSETNAME, ");
        sql.append("MEASUREUNIT.FName_l2 AS UNIT, ");
        sql.append("c.FassetAmt AS ASSETAMT, ");
        sql.append("currency.FName_l2 AS CURRENCY, ");
        sql.append("CURRENCY.FPrecision AS Fcurrencypre, ");
        sql.append("c.FExRate, ");
        sql.append("c.FOriginAmt, ");
        sql.append("c.FAddons, ");
        sql.append("c.FAssetValue, ");
        if (this.isByEvalue) {
            sql.append("ABS((CASE WHEN c.FINITEVALVALUE-c.FLASTEVALVALUE>0 THEN c.FINITEVALVALUE-c.FLASTEVALVALUE ELSE 0 END)) AS VALUEDEBIT, ");
            sql.append("ABS((CASE WHEN c.FINITEVALVALUE-c.FLASTEVALVALUE<0 THEN c.FINITEVALVALUE-c.FLASTEVALVALUE ELSE 0 END))  AS VALUECREDIT, ");
            sql.append("000000000000.0000 AS VALUEBAL, ");
        } else {
            sql.append("ABS((CASE WHEN  B.TOriginChg>0 THEN B.TOriginChg ELSE 0 END)) AS VALUEDEBIT, ");
            sql.append("ABS((CASE WHEN  B.TOriginChg<0 THEN B.TOriginChg ELSE 0 END)) AS VALUECREDIT, ");
            sql.append("000000000000.0000 AS VALUEBAL, ");
        }
        sql.append("ABS((CASE WHEN  B.TAccuDeprChg < 0 THEN B.TAccuDeprChg ELSE 0 END)) AS DEPRDEBIT,");
        sql.append("ABS((CASE WHEN  B.TAccuDeprChg > 0 THEN B.TAccuDeprChg ELSE 0 END)) AS DEPRCREDIT,");
        sql.append("000000000000.0000 AS DEPRBAL, ");
        sql.append("ABS((CASE WHEN B.TDecValueChg < 0 THEN B.TDecValueChg ELSE 0 END)) AS DEVALUEDEBIT, ");
        sql.append("ABS((CASE WHEN B.TDecValueChg > 0 THEN B.TDecValueChg ELSE 0 END)) AS DEVALUECREDIT, ");
        sql.append("000000000000.0000 AS DEVALUEBAL,");
        sql.append("0 AS FYearOrMonth, ");
        sql.append("'4' AS SORT_COL,");
        sql.append("2 AS isBegin");
        sql.append(" FROM T_FA_FACHANGEBILL AS A ");
        sql.append(" INNER JOIN T_FA_FACHANGEBILLENTRY AS B ON A.FID = B.FCHANGEBILLID");
        sql.append(" INNER JOIN T_FA_ALTERMODE AS alterMode ON alterMode.FID = A.FChangeModeID");
        sql.append(" INNER JOIN T_FA_FABIZCARD AS c ON B.FBIZCARDID = c.FID");
        sql.append(" INNER JOIN T_FA_FaBakCard AS bak ON bak.FID = c.ffabakcardid ");
        sql.append(" AND bak.FAssetCatID=c.FAssetCatID ");
        sql.append(" INNER JOIN T_FA_FaCurCard AS cur ON cur.FID = bak.ffacurcardid ");
        sql.append(" INNER JOIN T_BD_Period AS PERIOD ON A.FPeriodID = PERIOD.FID");
        sql.append(" INNER JOIN t_bd_currency AS currency on c.fcurrencyid = currency.FID");
        sql.append(" INNER JOIN T_FA_Cat AS assetCat ON c.FAssetCatID = assetCat.FID");
        sql.append(" INNER JOIN T_BD_MeasureUnit MEASUREUNIT ON MEASUREUNIT.fid = c.FMeasureUnitID");
        sql.append(" LEFT OUTER JOIN T_FA_FaBizDepartment AS faDepartment ON c.fid = faDepartment.FFaBizCardID ");
        sql.append(" INNER JOIN T_ORG_ADMIN AS useDepartment ON faDepartment.FUseDepartmentID = useDepartment.FID ");
        if (this.filter != null && (this.filter.indexOf("asstActItem.fname_l2") != -1 || this.filter.indexOf("asstActType.fnumber") != -1)) {
            sql.append(" INNER JOIN T_FA_FABizCOSTCENTER costcenter on costcenter.ffabizcardid = c.fid");
            sql.append(" INNER JOIN T_FA_FABIZASSTACTCOMPOSIT composit on composit.FfaBizCostCenterId = costcenter.Fid");
            sql.append(" INNER JOIN t_bd_asstacttype asstActType on asstActType.Fid = composit.FasstActType");
            sql.append(" INNER JOIN " + this.acctAsstTableName + " AS asstActItem ON composit.FAsstActItem = asstActItem.FID AND asstActItem.fasstActTypeId = composit.fasstActType");
        }
        sql.append(" WHERE ").append(this.isShowNotAudit ? " A.feffectedStatus = 2" : " A.fcheckedStatus = 2");
        sql.append(" AND A.FCOMPANYID ");
        if (this.isVirCompany) {
            sql.append(" IN (").append(this.strCompanyInclude).append(") ");
        } else {
            sql.append(" ='").append(this.currCompanyInfo.getId().toString()).append("' ");
        }
        sql.append(this.getPeriodCondNullParam());
        if (!this.isGroupByAssetType) {
            sql.append(" AND (TOriginChg != 0 OR TAccuDeprChg != 0 OR TDecValueChg != 0)");
        }
        if (this.filter != null) {
            String tmpFilter = this.filter.replaceAll("ASSETNUMBER", "cur.fnumber");
            tmpFilter = tmpFilter.replaceAll("assetName", "cur.fassetName");
            tmpFilter = tmpFilter.replaceAll("oldNumber", "cur.FOldNumber");
            tmpFilter = tmpFilter.replaceAll("groupNumber", "cur.fgroupNumber");
            sql.append(" AND ").append(tmpFilter);
        }
        sql.append(") AS A");
        if (this.isVirCompany) {
            sql.append(" INNER JOIN " + this.getSumItemJoinSql("orgArchitecture") + " COMPANY on COMPANY.fid = a.FCompanyID");
        }
        return sql.toString();
    }

    private String getChangeBillSqlNewAlter() throws BOSException {
        return this.getChangeBillSqlNewAlter(false);
    }

    private String getChangeBillSqlNewAlter(boolean isIngorePeriod) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(this.getSQLSelect());
        sql.append(" FROM( ");
        sql.append("SELECT DISTINCT ");
        sql.append("c.FCompanyID,");
        sql.append("PERIOD.FPeriodYear AS PERIODYEAR,");
        sql.append("PERIOD.FPeriodNumber AS PERIODNUMBER,");
        sql.append("TO_DATE(CONCAT(TO_CHAR(A.FCHANGEDATE,'yyyy-mm-dd'), ' 00:00:00')) AS BIZDATE, ");
        sql.append("alterMode.FName_l2 AS BRIEF, ");
        sql.append(this.getCatAdminSql(this.isGroupByDep, this.isGroupByAssetType));
        sql.append("A.FID AS BILLID, ");
        sql.append("B.FCURCARDID AS FACURCARDID, ");
        sql.append("cur.fnumber AS FACURCARDNUM, ");
        sql.append("A.fvoucherNumber as voucherNumber,");
        sql.append("A.fabstract as abstract,");
        sql.append("A.Fnumber AS bizNumber,");
        sql.append("1 AS BILLTYPE, ");
        sql.append("c.FNumber AS ASSETNUMBER, ");
        sql.append("c.FOldNumber AS OLDERNUMBER, ");
        sql.append("c.fgroupNumber as GROUPNUMBER, ");
        sql.append("c.FAssetName AS ASSETNAME, ");
        sql.append("MEASUREUNIT.FName_l2 AS UNIT, ");
        sql.append("c.FassetAmt AS ASSETAMT, ");
        sql.append("currency.FName_l2 AS CURRENCY, ");
        sql.append("CURRENCY.FPrecision AS Fcurrencypre, ");
        sql.append("c.FExRate, ");
        sql.append("c.FOriginAmt, ");
        sql.append("c.FAddons, ");
        sql.append("c.FAssetValue, ");
        if (this.isByEvalue) {
            sql.append("ABS((CASE WHEN c.FINITEVALVALUE-c.FLASTEVALVALUE>0 THEN c.FINITEVALVALUE-c.FLASTEVALVALUE ELSE 0 END)) AS VALUEDEBIT, ");
            sql.append("ABS((CASE WHEN c.FINITEVALVALUE-c.FLASTEVALVALUE<0 THEN c.FINITEVALVALUE-c.FLASTEVALVALUE ELSE 0 END))  AS VALUECREDIT, ");
            sql.append("000000000000.0000 AS VALUEBAL, ");
        } else {
            sql.append("(bak.FAssetValue+B.TOriginChg) AS VALUEDEBIT, ");
            sql.append("000000000000.0000 AS VALUECREDIT, ");
            sql.append("000000000000.0000 AS VALUEBAL, ");
        }
        sql.append("000000000000.0000 AS DEPRDEBIT,");
        sql.append("(CASE WHEN bak.FDeprTTerm>0 THEN bak.FAccuDepr+B.TAccuDeprChg-bak.FDeprTTerm ELSE bak.FAccuDepr+B.TAccuDeprChg END) AS DEPRCREDIT,");
        sql.append("000000000000.0000 AS DEPRBAL, ");
        sql.append("000000000000.0000 AS DEVALUEDEBIT, ");
        sql.append("(bak.FDecValue+B.TDecValueChg) AS DEVALUECREDIT, ");
        sql.append("000000000000.0000 AS DEVALUEBAL,");
        sql.append("0 AS FYearOrMonth, ");
        sql.append("'4' AS SORT_COL,");
        sql.append("2 AS isBegin");
        sql.append(" FROM T_FA_FACHANGEBILL AS A ");
        sql.append(" INNER JOIN T_FA_FACHANGEBILLENTRY AS B ON A.FID = B.FCHANGEBILLID");
        sql.append(" INNER JOIN T_FA_ALTERMODE AS alterMode ON alterMode.FID = A.FChangeModeID");
        sql.append(" INNER JOIN T_FA_FABIZCARD AS c ON B.FBIZCARDID = c.FID");
        sql.append(" INNER JOIN T_FA_FaBakCard AS bak ON bak.FID = c.ffabakcardid ");
        sql.append(" AND bak.FAssetCatID!=c.FAssetCatID ");
        sql.append(" INNER JOIN T_FA_FaCurCard AS cur ON cur.FID = bak.ffacurcardid ");
        sql.append(" INNER JOIN T_BD_Period AS PERIOD ON A.FPeriodID = PERIOD.FID");
        sql.append(" INNER JOIN t_bd_currency AS currency on c.fcurrencyid = currency.FID");
        sql.append(" INNER JOIN T_FA_Cat AS assetCat ON c.FAssetCatID = assetCat.FID");
        sql.append(" INNER JOIN T_BD_MeasureUnit MEASUREUNIT ON MEASUREUNIT.fid = c.FMeasureUnitID");
        sql.append(" LEFT OUTER JOIN T_FA_FaBizDepartment AS faDepartment ON c.fid = faDepartment.FFaBizCardID ");
        sql.append(" INNER JOIN T_ORG_ADMIN AS useDepartment ON faDepartment.FUseDepartmentID = useDepartment.FID ");
        if (this.filter != null && (this.filter.indexOf("asstActItem.fname_l2") != -1 || this.filter.indexOf("asstActType.fnumber") != -1)) {
            sql.append(" INNER JOIN T_FA_FABizCOSTCENTER costcenter on costcenter.ffabizcardid = c.fid");
            sql.append(" INNER JOIN T_FA_FABIZASSTACTCOMPOSIT composit on composit.FfaBizCostCenterId = costcenter.Fid");
            sql.append(" INNER JOIN t_bd_asstacttype asstActType on asstActType.Fid = composit.FasstActType");
            sql.append(" INNER JOIN " + this.acctAsstTableName + " AS asstActItem ON composit.FAsstActItem = asstActItem.FID AND asstActItem.fasstActTypeId = composit.fasstActType");
        }
        sql.append(" WHERE ").append(this.isShowNotAudit ? " A.feffectedStatus = 2" : " A.fcheckedStatus = 2");
        sql.append(" AND A.FCOMPANYID ");
        if (this.isVirCompany) {
            sql.append(" IN (").append(this.strCompanyInclude).append(") ");
        } else {
            sql.append(" ='").append(this.currCompanyInfo.getId().toString()).append("' ");
        }
        if (isIngorePeriod) {
            sql.append(this.getPeriodCondNullParam2());
        } else {
            sql.append(this.getPeriodCondNullParam());
        }
        if (!this.isGroupByAssetType) {
            sql.append(" AND (TOriginChg != 0 OR TAccuDeprChg != 0 OR TDecValueChg != 0)");
        }
        if (this.filter != null) {
            String tmpFilter = this.filter.replaceAll("ASSETNUMBER", "cur.fnumber");
            tmpFilter = tmpFilter.replaceAll("assetName", "cur.fassetName");
            tmpFilter = tmpFilter.replaceAll("oldNumber", "cur.FOldNumber");
            tmpFilter = tmpFilter.replaceAll("groupNumber", "cur.fgroupNumber");
            sql.append(" AND ").append(tmpFilter);
        }
        sql.append(") AS A");
        if (this.isVirCompany) {
            sql.append(" INNER JOIN " + this.getSumItemJoinSql("orgArchitecture") + " COMPANY on COMPANY.fid = a.FCompanyID");
        }
        return sql.toString();
    }

    private String getChangeBillSqlOld() throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(this.getSQLSelect());
        sql.append(" FROM( ");
        sql.append("SELECT DISTINCT ");
        sql.append("c.FCompanyID,");
        sql.append("PERIOD.FPeriodYear AS PERIODYEAR,");
        sql.append("PERIOD.FPeriodNumber AS PERIODNUMBER,");
        sql.append("TO_DATE(CONCAT(TO_CHAR(A.FCHANGEDATE,'yyyy-mm-dd'), ' 00:00:00')) AS BIZDATE, ");
        sql.append("alterMode.FName_l2 AS BRIEF, ");
        sql.append(this.getCatAdminSql(this.isGroupByDep, this.isGroupByAssetType));
        sql.append("A.FID AS BILLID, ");
        sql.append("B.FCURCARDID AS FACURCARDID, ");
        sql.append("cur.fnumber AS FACURCARDNUM, ");
        sql.append("A.fvoucherNumber as voucherNumber,");
        sql.append("A.fabstract as abstract,");
        sql.append("A.Fnumber AS bizNumber,");
        sql.append("1 AS BILLTYPE, ");
        sql.append("c.FNumber AS ASSETNUMBER, ");
        sql.append("c.FOldNumber AS OLDERNUMBER, ");
        sql.append("c.fgroupNumber as GROUPNUMBER, ");
        sql.append("c.FAssetName AS ASSETNAME, ");
        sql.append("MEASUREUNIT.FName_l2 AS UNIT, ");
        sql.append("c.FassetAmt AS ASSETAMT, ");
        sql.append("currency.FName_l2 AS CURRENCY, ");
        sql.append("CURRENCY.FPrecision AS Fcurrencypre, ");
        sql.append("c.FExRate, ");
        sql.append("c.FOriginAmt, ");
        sql.append("c.FAddons, ");
        sql.append("c.FAssetValue, ");
        if (this.isByEvalue) {
            sql.append("ABS((CASE WHEN c.FINITEVALVALUE-c.FLASTEVALVALUE>0 THEN c.FINITEVALVALUE-c.FLASTEVALVALUE ELSE 0 END)) AS VALUEDEBIT, ");
            sql.append("ABS((CASE WHEN c.FINITEVALVALUE-c.FLASTEVALVALUE<0 THEN c.FINITEVALVALUE-c.FLASTEVALVALUE ELSE 0 END))  AS VALUECREDIT, ");
            sql.append("000000000000.0000 AS VALUEBAL, ");
        } else {
            sql.append("ABS((CASE WHEN  B.TOriginChg>0 THEN B.TOriginChg ELSE 0 END)) AS VALUEDEBIT, ");
            sql.append("ABS((CASE WHEN  B.TOriginChg<0 THEN B.TOriginChg ELSE 0 END)) AS VALUECREDIT, ");
            sql.append("000000000000.0000 AS VALUEBAL, ");
        }
        sql.append("ABS((CASE WHEN  B.TAccuDeprChg < 0 THEN B.TAccuDeprChg ELSE 0 END)) AS DEPRDEBIT,");
        sql.append("ABS((CASE WHEN  B.TAccuDeprChg > 0 THEN B.TAccuDeprChg ELSE 0 END)) AS DEPRCREDIT,");
        sql.append("000000000000.0000 AS DEPRBAL, ");
        sql.append("ABS((CASE WHEN B.TDecValueChg < 0 THEN B.TDecValueChg ELSE 0 END)) AS DEVALUEDEBIT, ");
        sql.append("ABS((CASE WHEN B.TDecValueChg > 0 THEN B.TDecValueChg ELSE 0 END)) AS DEVALUECREDIT, ");
        sql.append("000000000000.0000 AS DEVALUEBAL,");
        sql.append("0 AS FYearOrMonth, ");
        sql.append("'4' AS SORT_COL,");
        sql.append("2 AS isBegin");
        sql.append(" FROM T_FA_FACHANGEBILL AS A ");
        sql.append(" INNER JOIN T_FA_FACHANGEBILLENTRY AS B ON A.FID = B.FCHANGEBILLID");
        sql.append(" INNER JOIN T_FA_ALTERMODE AS alterMode ON alterMode.FID = A.FChangeModeID");
        sql.append(" INNER JOIN T_FA_FABIZCARD AS c ON B.FBIZCARDID = c.FID");
        sql.append(" INNER JOIN T_FA_FaBakCard AS bak ON bak.FID = c.ffabakcardid ");
        sql.append(" INNER JOIN T_FA_FaCurCard AS cur ON cur.FID = bak.ffacurcardid ");
        sql.append(" INNER JOIN T_BD_Period AS PERIOD ON A.FPeriodID = PERIOD.FID");
        sql.append(" INNER JOIN t_bd_currency AS currency on c.fcurrencyid = currency.FID");
        sql.append(" INNER JOIN T_FA_Cat AS assetCat ON c.FAssetCatID = assetCat.FID");
        sql.append(" INNER JOIN T_BD_MeasureUnit MEASUREUNIT ON MEASUREUNIT.fid = c.FMeasureUnitID");
        sql.append(" LEFT OUTER JOIN T_FA_FaBizDepartment AS faDepartment ON c.fid = faDepartment.FFaBizCardID ");
        sql.append(" INNER JOIN T_ORG_ADMIN AS useDepartment ON faDepartment.FUseDepartmentID = useDepartment.FID ");
        if (this.filter != null && (this.filter.indexOf("asstActItem.fname_l2") != -1 || this.filter.indexOf("asstActType.fnumber") != -1)) {
            sql.append(" INNER JOIN T_FA_FABizCOSTCENTER costcenter on costcenter.ffabizcardid = c.fid");
            sql.append(" INNER JOIN T_FA_FABIZASSTACTCOMPOSIT composit on composit.FfaBizCostCenterId = costcenter.Fid");
            sql.append(" INNER JOIN t_bd_asstacttype asstActType on asstActType.Fid = composit.FasstActType");
            sql.append(" INNER JOIN " + this.acctAsstTableName + " AS asstActItem ON composit.FAsstActItem = asstActItem.FID AND asstActItem.fasstActTypeId = composit.fasstActType");
        }
        sql.append(" WHERE ").append(this.isShowNotAudit ? " A.feffectedStatus = 2" : " A.fcheckedStatus = 2");
        sql.append(" AND A.FCOMPANYID ");
        if (this.isVirCompany) {
            sql.append(" IN (").append(this.strCompanyInclude).append(") ");
        } else {
            sql.append(" = ? ");
            this.params.addString(this.currCompanyInfo.getId().toString());
        }
        sql.append(this.getPeriodCond());
        sql.append("AND (TOriginChg != 0 OR TAccuDeprChg != 0 OR TDecValueChg != 0)");
        if (this.filter != null) {
            String tmpFilter = this.filter.replaceAll("ASSETNUMBER", "cur.fnumber");
            tmpFilter = tmpFilter.replaceAll("assetName", "cur.fassetName");
            tmpFilter = tmpFilter.replaceAll("oldNumber", "cur.FOldNumber");
            tmpFilter = tmpFilter.replaceAll("groupNumber", "cur.fgroupNumber");
            sql.append(" AND ").append(tmpFilter);
        }
        sql.append(") AS A");
        if (this.isVirCompany) {
            sql.append(" INNER JOIN " + this.getSumItemJoinSql("orgArchitecture") + " COMPANY on COMPANY.fid = a.FCompanyID");
        }
        return sql.toString();
    }

    private String createChangeBillSql() throws BOSException {
        return this.createChangeBillSql(false);
    }

    private String createChangeBillSql(boolean isIngorePeriod) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(this.getSQLSelect());
        sql.append(" FROM( ");
        sql.append("SELECT DISTINCT ");
        sql.append("c.FCompanyID,");
        sql.append("PERIOD.FPeriodYear AS PERIODYEAR,");
        sql.append("PERIOD.FPeriodNumber AS PERIODNUMBER,");
        sql.append("TO_DATE(CONCAT(TO_CHAR(A.FCHANGEDATE,'yyyy-mm-dd'), ' 00:00:00')) AS BIZDATE, ");
        sql.append("alterMode.FName_l2 AS BRIEF, ");
        sql.append(this.getCatAdminSql(this.isGroupByDep, this.isGroupByAssetType));
        sql.append("A.FID AS BILLID, ");
        sql.append("B.FCURCARDID AS FACURCARDID, ");
        sql.append("cur.fnumber AS FACURCARDNUM, ");
        sql.append("A.fvoucherNumber as voucherNumber,");
        sql.append("A.fabstract as abstract,");
        sql.append("A.Fnumber AS bizNumber,");
        sql.append("1 AS BILLTYPE, ");
        sql.append("c.FNumber AS ASSETNUMBER, ");
        sql.append("c.FOldNumber AS OLDERNUMBER, ");
        sql.append("c.fgroupNumber as GROUPNUMBER, ");
        sql.append("c.FAssetName AS ASSETNAME, ");
        sql.append("MEASUREUNIT.FName_l2 AS UNIT, ");
        sql.append("c.FassetAmt AS ASSETAMT, ");
        sql.append("currency.FName_l2 AS CURRENCY, ");
        sql.append("CURRENCY.FPrecision AS Fcurrencypre, ");
        sql.append("c.FExRate, ");
        sql.append("c.FOriginAmt, ");
        sql.append("c.FAddons, ");
        sql.append("c.FAssetValue, ");
        if (this.isByEvalue) {
            sql.append("ABS((CASE WHEN c.FINITEVALVALUE-c.FLASTEVALVALUE>0 THEN c.FINITEVALVALUE-c.FLASTEVALVALUE ELSE 0 END)) AS VALUEDEBIT, ");
            sql.append("ABS((CASE WHEN c.FINITEVALVALUE-c.FLASTEVALVALUE<0 THEN c.FINITEVALVALUE-c.FLASTEVALVALUE ELSE 0 END))  AS VALUECREDIT, ");
            sql.append("000000000000.0000 AS VALUEBAL, ");
        } else {
            sql.append("000000000000.0000 AS VALUEDEBIT, ");
            sql.append("bak.FAssetValue AS VALUECREDIT, ");
            sql.append("000000000000.0000 AS VALUEBAL, ");
        }
        sql.append("(CASE WHEN bak.FDeprTTerm>0 THEN bak.FAccuDepr-bak.FDeprTTerm ELSE bak.FAccuDepr END) AS DEPRDEBIT,");
        sql.append("000000000000.0000 AS DEPRCREDIT,");
        sql.append("000000000000.0000 AS DEPRBAL, ");
        sql.append("bak.FDecValue AS DEVALUEDEBIT, ");
        sql.append("000000000000.0000 AS DEVALUECREDIT, ");
        sql.append("000000000000.0000 AS DEVALUEBAL,");
        sql.append("0 AS FYearOrMonth, ");
        sql.append("'4' AS SORT_COL,");
        sql.append("2 AS isBegin");
        sql.append(" FROM T_FA_FACHANGEBILL AS A ");
        sql.append(" INNER JOIN T_FA_FACHANGEBILLENTRY AS B ON A.FID = B.FCHANGEBILLID");
        sql.append(" INNER JOIN T_FA_ALTERMODE AS alterMode ON alterMode.FID = A.FChangeModeID");
        sql.append(" INNER JOIN T_FA_FABIZCARD AS c ON B.FBIZCARDID = c.FID");
        sql.append(" INNER JOIN T_FA_FaBakCard AS bak ON bak.FID = c.ffabakcardid AND bak.FAssetCatID!=c.FAssetCatID ");
        sql.append(" INNER JOIN T_FA_FaCurCard AS cur ON cur.FID = bak.ffacurcardid ");
        sql.append(" INNER JOIN T_BD_Period AS PERIOD ON A.FPeriodID = PERIOD.FID");
        sql.append(" INNER JOIN t_bd_currency AS currency on c.fcurrencyid = currency.FID");
        sql.append(" INNER JOIN T_FA_Cat AS assetCat ON bak.FAssetCatID = assetCat.FID");
        sql.append(" INNER JOIN T_BD_MeasureUnit MEASUREUNIT ON MEASUREUNIT.fid = c.FMeasureUnitID");
        sql.append(" LEFT OUTER JOIN T_FA_FaBizDepartment AS faDepartment ON c.fid = faDepartment.FFaBizCardID ");
        sql.append(" INNER JOIN T_ORG_ADMIN AS useDepartment ON faDepartment.FUseDepartmentID = useDepartment.FID ");
        if (this.filter != null && (this.filter.indexOf("asstActItem.fname_l2") != -1 || this.filter.indexOf("asstActType.fnumber") != -1)) {
            sql.append(" INNER JOIN T_FA_FABizCOSTCENTER costcenter on costcenter.ffabizcardid = c.fid");
            sql.append(" INNER JOIN T_FA_FABIZASSTACTCOMPOSIT composit on composit.FfaBizCostCenterId = costcenter.Fid");
            sql.append(" INNER JOIN t_bd_asstacttype asstActType on asstActType.Fid = composit.FasstActType");
            sql.append(" INNER JOIN " + this.acctAsstTableName + " AS asstActItem ON composit.FAsstActItem = asstActItem.FID AND asstActItem.fasstActTypeId = composit.fasstActType");
        }
        sql.append(" WHERE ").append(this.isShowNotAudit ? " A.feffectedStatus = 2" : " A.fcheckedStatus = 2");
        sql.append(" AND A.FCOMPANYID ");
        if (this.isVirCompany) {
            sql.append(" IN (").append(this.strCompanyInclude).append(") ");
        } else {
            sql.append(" ='").append(this.currCompanyInfo.getId().toString()).append("' ");
        }
        if (isIngorePeriod) {
            sql.append(this.getPeriodCondNullParam2());
        } else {
            sql.append(this.getPeriodCondNullParam());
        }
        if (this.filter != null) {
            String tmpFilter = this.filter.replaceAll("ASSETNUMBER", "cur.fnumber");
            tmpFilter = tmpFilter.replaceAll("assetName", "cur.fassetName");
            tmpFilter = tmpFilter.replaceAll("oldNumber", "cur.FOldNumber");
            tmpFilter = tmpFilter.replaceAll("groupNumber", "cur.fgroupNumber");
            sql.append(" AND ").append(tmpFilter);
        }
        sql.append(") AS A");
        if (this.isVirCompany) {
            sql.append(" INNER JOIN " + this.getSumItemJoinSql("orgArchitecture") + " COMPANY on COMPANY.fid = a.FCompanyID");
        }
        return sql.toString();
    }

    private String getCleanBillSql() throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(this.getSQLSelect());
        sql.append(" FROM( ");
        sql.append("SELECT DISTINCT ");
        sql.append("c.FCompanyID,");
        sql.append("PERIOD.FPeriodYear AS PERIODYEAR,");
        sql.append("PERIOD.FPeriodNumber AS PERIODNUMBER,");
        sql.append("TO_DATE(CONCAT(TO_CHAR(A.FClearDate,'yyyy-mm-dd'), ' 00:00:00')) AS BIZDATE, ");
        sql.append("alterMode.FName_l2 AS BRIEF, ");
        sql.append(this.getCatAdminSql(this.isGroupByDep, this.isGroupByAssetType));
        sql.append("A.FID AS BILLID, ");
        sql.append("B.FCURCARDID AS FACURCARDID, ");
        sql.append("cur.fnumber AS FACURCARDNUM, ");
        sql.append("A.Fnumber AS bizNumber,");
        sql.append("A.fvoucherNumber as voucherNumber, ");
        sql.append("A.fabstract as abstract, ");
        sql.append("2 AS BILLTYPE, ");
        sql.append("c.FNumber AS ASSETNUMBER, ");
        sql.append("c.FOldNumber AS OLDERNUMBER, ");
        sql.append("c.fgroupNumber AS GROUPNUMBER, ");
        sql.append("c.FAssetName AS ASSETNAME, ");
        sql.append("MEASUREUNIT.FName_l2 AS UNIT, ");
        sql.append("c.FassetAmt AS ASSETAMT, ");
        sql.append("currency.FName_l2 AS CURRENCY, ");
        sql.append("CURRENCY.FPrecision AS Fcurrencypre, ");
        sql.append("c.FExRate, ");
        sql.append("c.FOriginAmt, ");
        sql.append("c.FAddons, ");
        sql.append("c.FAssetValue, ");
        if (this.isByEvalue) {
            sql.append("0 AS VALUEDEBIT, ");
            if (this.isByEvalue) {
                sql.append("case when c.finitevalvalue = c.fassetvalue then B.FClrOriginal else c.finitevalvalue end AS VALUECREDIT, ");
            } else {
                sql.append("B.FClrOriginal  AS VALUECREDIT, ");
            }
            sql.append("000000000000.0000 AS VALUEBAL, ");
        } else {
            sql.append("0 AS VALUEDEBIT, ");
            sql.append("B.FClrOriginal AS VALUECREDIT, ");
            sql.append("000000000000.0000 AS VALUEBAL, ");
        }
        sql.append("B.FClrAddupDep AS DEPRDEBIT,");
        sql.append("0 AS DEPRCREDIT,");
        sql.append("000000000000.0000 AS DEPRBAL, ");
        sql.append("B.FClrDecPrep AS DEVALUEDEBIT, ");
        sql.append("0 AS DEVALUECREDIT, ");
        sql.append("000000000000.0000 AS DEVALUEBAL,");
        sql.append("0 AS FYearOrMonth, ");
        sql.append("'7' AS SORT_COL,");
        sql.append("2 AS isBegin");
        sql.append(" FROM T_FA_CLEARBILL AS A ");
        sql.append(" INNER JOIN T_FA_CLEARBILLENTRY AS B ON A.FID = B.FENTRYID");
        sql.append(" INNER JOIN T_FA_ALTERMODE AS alterMode ON alterMode.FID = A.FClearModeID");
        sql.append(" INNER JOIN T_FA_FABIZCARD AS c ON B.FBIZCARDID = c.FID");
        sql.append(" INNER JOIN T_FA_FaBakCard AS bak ON bak.FID = c.ffabakcardid ");
        sql.append(" INNER JOIN T_FA_FaCurCard AS cur ON cur.FID = bak.ffacurcardid ");
        sql.append(" INNER JOIN T_BD_Period AS PERIOD ON A.FPeriodID = PERIOD.FID");
        sql.append(" INNER JOIN t_bd_currency AS currency on c.fcurrencyid = currency.FID");
        sql.append(" INNER JOIN T_FA_Cat AS assetCat ON c.FAssetCatID = assetCat.FID");
        sql.append(" INNER JOIN T_BD_MeasureUnit MEASUREUNIT ON MEASUREUNIT.FID = c.FMeasureUnitID");
        sql.append(" LEFT OUTER JOIN T_FA_FaBizDepartment AS faDepartment ON c.fid = faDepartment.FFaBizCardID ");
        sql.append(" INNER JOIN T_ORG_ADMIN AS useDepartment ON faDepartment.FUseDepartmentID = useDepartment.FID ");
        if (this.filter != null && (this.filter.indexOf("asstActItem.fname_l2") != -1 || this.filter.indexOf("asstActType.fnumber") != -1)) {
            sql.append(" INNER JOIN T_FA_FABizCOSTCENTER costcenter on costcenter.ffabizcardid = c.fid");
            sql.append(" INNER JOIN T_FA_FABIZASSTACTCOMPOSIT composit on composit.FfaBizCostCenterId = costcenter.Fid");
            sql.append(" INNER JOIN t_bd_asstacttype asstActType on asstActType.Fid = composit.FasstActType");
            sql.append(" INNER JOIN " + this.acctAsstTableName + " AS asstActItem ON composit.FAsstActItem = asstActItem.FID AND asstActItem.fasstActTypeId = composit.fasstActType");
        }
        sql.append(" WHERE ").append(this.isShowNotAudit ? " A.feffectedStatus = 2" : " A.fcheckedStatus = 2");
        sql.append(" AND A.FCOMPANYID ");
        if (this.isVirCompany) {
            sql.append(" IN (").append(this.strCompanyInclude).append(") ");
        } else {
            sql.append(" = ? ");
            this.params.addString(this.currCompanyInfo.getId().toString());
        }
        sql.append(this.getPeriodCond());
        if (this.filter != null) {
            String tmpFilter = this.filter.replaceAll("ASSETNUMBER", "cur.fnumber");
            tmpFilter = tmpFilter.replaceAll("assetName", "cur.fassetName");
            tmpFilter = tmpFilter.replaceAll("oldNumber", "cur.FOldNumber");
            tmpFilter = tmpFilter.replaceAll("groupNumber", "cur.fgroupNumber");
            sql.append(" AND ").append(tmpFilter);
        }
        sql.append(") AS A");
        if (this.isVirCompany) {
            sql.append(" INNER JOIN " + this.getSumItemJoinSql("orgArchitecture") + " COMPANY on COMPANY.fid = a.FCompanyID");
        }
        return sql.toString();
    }

    private void setYearBalance(Context ctx) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select distinct PERIODYEAR,PERIODNUMBER from ").append(this.tempTable);
        sql.append(" where isbegin = 2 and fyearormonth = 1");
        sql.append(" order by PERIODYEAR,PERIODNUMBER");
        IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (iRowSet.next()) {
                int peirodYear = iRowSet.getInt("PERIODYEAR");
                int periodNumber = iRowSet.getInt("PERIODNUMBER");
                sql = new StringBuffer();
                sql.append("UPDATE ").append(this.tempTable).append(" SET (valuebal,deprbal,devaluebal) = ");
                sql.append(" (select temp.valuebal,temp.deprbal,temp.devaluebal ");
                sql.append(" from( ");
                sql.append(" SELECT t.company_id FCompanyID,t.periodyear fyear,t.valuebal,t.deprbal,t.devaluebal ");
                if (this.isFromPrintCard || this.isGroupByCard) {
                    sql.append(" ,t.assetnumber fnumber ");
                }
                sql.append(" from ").append(this.tempTable).append(" t ");
                sql.append(" WHERE t.isbegin=2 and t.fyearormonth = 1");
                sql.append(" and t.PERIODNUMBER=" + periodNumber + " ");
                sql.append(") temp where temp.FCompanyID = company_id and temp.fyear = periodyear ");
                if (this.isFromPrintCard || this.isGroupByCard) {
                    sql.append(" and temp.fnumber=assetnumber ");
                }
                sql.append(" ) where SORT_COL = '9' and periodyear=" + peirodYear + " and periodnumber=" + periodNumber + " ");
                DbUtil.execute((Context)ctx, (String)FaLocalUtils.transformLocal((Context)ctx, (String)sql.toString()));
            }
        }
        catch (SQLException ex) {
            this.isFromPrintCard = false;
            throw new BOSException("sql error: " + sql.toString(), (Throwable)ex);
        }
    }

    private String getNewCardSql() throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(this.getSQLSelect());
        sql.append(" FROM( ");
        sql.append("SELECT DISTINCT ");
        sql.append("c.FCompanyID,");
        sql.append("PERIOD.FPeriodYear AS PERIODYEAR,");
        sql.append("PERIOD.FPeriodNumber AS PERIODNUMBER,");
        sql.append("c.FFIAccountDate AS BIZDATE, ");
        sql.append("alterMode.FName_l2 AS BRIEF, ");
        sql.append(this.getCatAdminSql(this.isGroupByDep, this.isGroupByAssetType));
        sql.append("c.fvoucherNumber as voucherNumber, ");
        sql.append("c.fabstract as abstract, ");
        sql.append("c.FNumber AS bizNumber, ");
        sql.append("c.FID AS BILLID, ");
        sql.append("c.FFACURCARDID AS FACURCARDID, ");
        sql.append("cur.fnumber AS FACURCARDNUM, ");
        sql.append("6 AS BILLTYPE, ");
        sql.append("c.FNumber AS ASSETNUMBER, ");
        sql.append("c.FOldNumber AS OLDERNUMBER, ");
        sql.append("c.fgroupNumber AS GROUPNUMBER, ");
        sql.append("c.FAssetName AS ASSETNAME, ");
        sql.append("MEASUREUNIT.FName_l2 AS UNIT, ");
        sql.append("c.FassetAmt AS ASSETAMT, ");
        sql.append("currency.FName_l2 AS CURRENCY, ");
        sql.append("CURRENCY.FPrecision AS Fcurrencypre, ");
        sql.append("c.FExRate, ");
        sql.append("c.FOriginAmt, ");
        sql.append("c.FAddons, ");
        sql.append("c.FAssetValue, ");
        sql.append(this.isByEvalue ? "c.FInitevalvalue " : "c.FAssetValue ").append("AS VALUEDEBIT, ");
        sql.append("0 AS VALUECREDIT, ");
        sql.append("000000000000.0000 AS VALUEBAL, ");
        sql.append("0 AS DEPRDEBIT,");
        sql.append("c.FAccuDepr AS DEPRCREDIT,");
        sql.append("000000000000.0000 AS DEPRBAL, ");
        sql.append("0 AS DEVALUEDEBIT, ");
        sql.append("c.FDecValue AS DEVALUECREDIT, ");
        sql.append("000000000000.0000 AS DEVALUEBAL,");
        sql.append("0 AS FYearOrMonth, ");
        sql.append("'3' AS SORT_COL,");
        sql.append("2 AS isBegin");
        sql.append(" FROM T_FA_FABAKCARD AS c ");
        sql.append(" INNER JOIN T_FA_FACURCARD AS cur ON cur.FID = c.ffacurcardid");
        sql.append(" INNER JOIN T_FA_ALTERMODE AS alterMode ON alterMode.FID = c.FOriginMethodID");
        sql.append(" INNER JOIN T_BD_Period AS PERIOD ON c.FPeriodID = PERIOD.FID ");
        sql.append(" INNER JOIN T_FA_Cat assetCat ON c.fassetcatid = assetCat.fid");
        sql.append(" INNER JOIN T_BD_currency currency ON currency.fid = c.fcurrencyid");
        sql.append(" INNER JOIN T_BD_MeasureUnit MEASUREUNIT ON MEASUREUNIT.fid = c.FMeasureUnitID");
        sql.append(" LEFT OUTER JOIN T_FA_FaBakDepartment AS faDepartment ON c.fid = faDepartment.FFaBakCardID ");
        sql.append(" INNER JOIN T_ORG_ADMIN AS useDepartment ON faDepartment.FUseDepartmentID = useDepartment.FID ");
        if (this.filter != null && (this.filter.indexOf("asstActItem.fname_l2") != -1 || this.filter.indexOf("asstActType.fnumber") != -1)) {
            sql.append(" INNER JOIN T_FA_FABAKCOSTCENTER costcenter on costcenter.ffaBakcardid = c.fid");
            sql.append(" INNER JOIN T_FA_FaBakAsstActComposit composit ON costcenter.fid = composit.FFaBakCostCenterID");
            sql.append(" INNER JOIN t_bd_asstacttype asstActType on asstActType.Fid = composit.fasstacttype");
            sql.append(" INNER JOIN " + this.acctAsstTableName + " AS asstActItem ON composit.FAsstActItem = asstActItem.FID AND asstActItem.fasstacttypeid = composit.fasstacttype");
        }
        sql.append(" INNER JOIN T_BD_SystemStatusCtrol ssc on ssc.FCompanyID = c.FCompanyID ");
        sql.append(" INNER JOIN T_BD_PERIOD AS STARTPERIOD ON STARTPERIOD.FID = ssc.FStartPeriodID ");
        sql.append(" INNER JOIN T_BD_SystemStatus ss ON ss.FID = ssc.FSystemStatusID AND ss.FName = ").append(14);
        sql.append(" WHERE c.FcompanyID ");
        if (this.isVirCompany) {
            sql.append(" IN (").append(this.strCompanyInclude).append(") ");
        } else {
            sql.append(" = ? ");
            this.params.addString(this.currCompanyInfo.getId().toString());
        }
        sql.append(" AND c.FBILLTYPE = 1");
        sql.append(this.getPeriodCond());
        sql.append(" AND PERIOD.FNumber >= STARTPERIOD.FNumber");
        if (this.filter != null) {
            String tmpFilter = this.filter.replaceAll("ASSETNUMBER", "cur.fnumber");
            tmpFilter = tmpFilter.replaceAll("assetName", "cur.fassetName");
            tmpFilter = tmpFilter.replaceAll("oldNumber", "cur.foldnumber");
            tmpFilter = tmpFilter.replaceAll("groupNumber", "cur.fgroupnumber");
            sql.append(" AND ").append(tmpFilter);
        }
        sql.append(") AS A");
        if (this.isVirCompany) {
            sql.append(" INNER JOIN " + this.getSumItemJoinSql("orgArchitecture") + " COMPANY on COMPANY.fid = a.FCompanyID");
        }
        return sql.toString();
    }

    private String getDeprSql() throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT ");
        sql.append("NEWBOSID('00000000') AS FId, ");
        if (this.sumOption != null && this.sumOption.isHasSum()) {
            sql.append(this.sumOption.getStrNameFields() + ", ");
        }
        sql.append("A.PERIODYEAR,");
        sql.append("A.PERIODNUMBER,");
        sql.append("A.SORT_COL, ");
        sql.append("A.isBegin,");
        sql.append("A.BIZDATE, ");
        sql.append("A.BRIEF, ");
        sql.append("A.assetType,");
        sql.append("A.catNum,");
        sql.append("A.adminDepartment,");
        sql.append("A.adminNum,");
        sql.append("A.BILLID, ");
        sql.append("A.FACURCARDID AS FACURCARDID, ");
        sql.append("A.FACURCARDNUM AS FACURCARDNUM, ");
        sql.append("A.bizNumber as bizNumber,");
        sql.append("voucher.fnumber as voucherNumber, ");
        sql.append("voucher.fabstract as abstract, ");
        sql.append("A.BILLTYPE, ");
        sql.append("A.ASSETNUMBER, ");
        sql.append("A.OLDERNUMBER, ");
        sql.append("A.GROUPNUMBER, ");
        sql.append("A.ASSETNAME, ");
        sql.append("A.UNIT, ");
        sql.append("A.ASSETAMT, ");
        sql.append("A.CURRENCY, ");
        sql.append("A.Fcurrencypre, ");
        sql.append("A.FexRate, ");
        sql.append("A.FOriginAmt, ");
        sql.append("A.FAddons, ");
        sql.append("A.FAssetValue, ");
        sql.append("A.VALUEDEBIT, ");
        sql.append("A.VALUECREDIT, ");
        sql.append("A.VALUEBAL, ");
        sql.append("A.DEPRDEBIT, ");
        sql.append("A.DEPRCREDIT, ");
        sql.append("A.DEPRBAL, ");
        sql.append("000000000000.0000 AS NETVALUE, ");
        sql.append("A.DEVALUEDEBIT, ");
        sql.append("A.DEVALUECREDIT, ");
        sql.append("A.DEVALUEBAL, ");
        sql.append("000000000000.0000 AS NETAMOUNT, ");
        sql.append("A.FYearOrMonth, ");
        sql.append("0 AS isSum, ");
        sql.append("A.FCompanyID AS COMPANY_ID ");
        if (this.isVirCompany) {
            sql.append(",COMPANY.FLevel AS SumLevel");
        }
        if (this.sumOption != null && this.sumOption.isHasSum()) {
            sql.append(",").append(this.sumOption.getStrLongNumberFields());
        }
        sql.append(" FROM( ");
        sql.append("SELECT ");
        sql.append("d.FCompanyID,");
        sql.append("d.FPERIODYEAR AS PERIODYEAR,");
        sql.append("d.FPERIODNUMBER AS PERIODNUMBER,");
        sql.append("d.FBizDate AS BIZDATE, ");
        sql.append("N'" + ResourceBase.getString((String)"com.kingdee.eas.fi.fa.basedata.FaResource", (String)"dpr", (Locale)this.ctx.getOriginLocale()) + "' AS BRIEF, ");
        sql.append("d.assetType as assetType,");
        sql.append("d.catNum as catNum,");
        sql.append("d.adminDepartment as adminDepartment,");
        sql.append("d.adminNum as adminNum,");
        sql.append("d.fid AS BILLID, ");
        sql.append(this.isQuerySingleCard ? "d.FACURCARDID" : "TO_CHAR(NULL)").append(" AS FACURCARDID, ");
        sql.append(this.isQuerySingleCard ? "d.FACURCARDNUM" : "TO_CHAR(NULL)").append(" AS FACURCARDNUM, ");
        sql.append("N' ' AS bizNumber,");
        sql.append("N' ' AS voucherNumber,");
        sql.append("N' ' AS abstract,");
        sql.append("5 AS BILLTYPE, ");
        sql.append(this.isQuerySingleCard ? "d.FNumber" : "N' '").append(" AS ASSETNUMBER, ");
        sql.append(this.isQuerySingleCard ? "d.oldernumber" : "N''").append(" AS OLDERNUMBER, ");
        sql.append(this.isQuerySingleCard ? "d.fgroupNumber" : "N' '").append(" AS GROUPNUMBER, ");
        sql.append(this.isQuerySingleCard ? "d.FAssetName" : "N' '").append(" AS ASSETNAME, ");
        sql.append(this.isQuerySingleCard ? "d.UNIT" : "N' '").append(" AS UNIT, ");
        sql.append(this.isQuerySingleCard ? "d.FassetAmt" : "TO_DECIMAL(NULL)").append(" AS ASSETAMT, ");
        sql.append(this.isQuerySingleCard ? "d.CURRENCY" : "N' '").append(" AS  CURRENCY, ");
        sql.append(this.isQuerySingleCard ? "d.Fcurrencypre" : "TO_INT(NULL)").append(" AS Fcurrencypre, ");
        sql.append(this.isQuerySingleCard ? "d.FExRate" : "TO_DECIMAL(NULL)").append(" AS FexRate, ");
        sql.append(this.isQuerySingleCard ? "d.FOriginAmt" : "TO_DECIMAL(NULL)").append(" AS FOriginAmt, ");
        sql.append(this.isQuerySingleCard ? "d.FAddons" : "TO_DECIMAL(NULL)").append(" AS FAddons, ");
        sql.append(this.isQuerySingleCard ? "d.FAssetValue" : "TO_DECIMAL(NULL)").append(" AS FAssetValue, ");
        sql.append("000000000000.0000 AS VALUEDEBIT, ");
        sql.append("000000000000.0000 AS VALUECREDIT, ");
        sql.append("000000000000.0000 AS VALUEBAL, ");
        sql.append("000000000000.0000 AS DEPRDEBIT,");
        sql.append(this.isQuerySingleCard ? "d.FDepreciation - d.FWellCost" : "SUM(d.FDepreciation - d.FWellCost)").append(" AS DEPRCREDIT,");
        sql.append("000000000000.0000 AS DEPRBAL,");
        sql.append("000000000000.0000 AS DEVALUEDEBIT, ");
        sql.append("000000000000.0000 AS DEVALUECREDIT, ");
        sql.append("000000000000.0000 AS DEVALUEBAL, ");
        sql.append("0 AS FYearOrMonth, ");
        sql.append("'5' AS SORT_COL,");
        sql.append("2 AS isBegin");
        sql.append(" FROM (");
        sql.append(this.getCurrDeprSql());
        sql.append(" UNION ");
        sql.append(this.getMonDeprSql()).append(") AS d ");
        if (!this.isQuerySingleCard) {
            sql.append(" GROUP BY ");
            sql.append(" d.FCompanyID,d.FPERIODYEAR,d.FPERIODNUMBER,d.FBEGINDATE,d.FBizDate, d.fid,d.adminDepartment,d.assetType,d.adminNum,d.catNum");
        }
        sql.append(") AS A");
        sql.append(" LEFT OUTER JOIN T_BOT_Relation  AS botp ON A.BILLID = botp.FSrcObjectID ");
        sql.append(" LEFT OUTER JOIN T_GL_Voucher voucher on botp.fdestObjectID = voucher.fid and botp.fdestEntityID = '2652E01E' and botp.fsrcEntityID = 'FD47C291' ");
        if (this.isVirCompany) {
            sql.append(" INNER JOIN " + this.getSumItemJoinSql("orgArchitecture") + " COMPANY on COMPANY.fid = a.FCompanyID");
        }
        return sql.toString();
    }

    private String getCurrDeprSql() throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select distinct period.fbeginDate,period.fperiodyear,period.fperiodnumber,da.fid,db.fid as entryId,");
        sql.append("db.FDepreciation,db.FWellCost,dc.fcompanyid,");
        sql.append(this.getCatAdminSql(this.isGroupByDep, this.isGroupByAssetType));
        sql.append("da.fbizdate");
        if (this.isQuerySingleCard) {
            sql.append(",dc.FNumber AS FNumber,dc.foldNumber as oldernumber,dc.FGroupNumber AS FGroupNumber, dc.FAssetName AS FAssetName,MEASUREUNIT.FName_l2 AS UNIT");
            sql.append(",dc.FassetAmt AS FassetAmt,currency.FName_l2 AS CURRENCY,currency.FPrecision AS Fcurrencypre,dc.FExRate AS FExRate");
            sql.append(",dc.FOriginAmt AS FOriginAmt,dc.FAddons AS FAddons,dc.FAssetValue AS FAssetValue");
            sql.append(",db.FFACURCARDID AS FACURCARDID,dc.FNumber AS FACURCARDNUM");
        }
        sql.append(" from t_fa_fadepreciation AS da");
        sql.append(" inner join t_fa_fadepreciationentry AS db on da.fid = db.FLnkFaDepreEntry");
        sql.append(" inner join t_bd_SystemStatusCtrol ssc on da.fcompanyid = ssc.fcompanyid and da.fperiod = ssc.fcurrentperiodid");
        sql.append(" inner join t_bd_period period ON ssc.fcurrentperiodid = period.fid");
        sql.append(" inner join t_bd_SystemStatus ss on ss.fid = ssc.fsystemstatusid");
        sql.append(" inner join t_fa_facurcard AS dc on db.ffacurcardid = dc.fid");
        sql.append(" INNER JOIN T_FA_Cat assetCat ON dc.fassetcatid = assetCat.fid");
        sql.append(" INNER JOIN T_BD_Currency AS CURRENCY ON dc.FCurrencyID = CURRENCY.FID ");
        sql.append(" LEFT OUTER JOIN T_FA_FaCurDepartment AS faDepartment ON dc.fid = faDepartment.FFaCurCardID ");
        sql.append(" INNER JOIN T_ORG_ADMIN AS useDepartment ON faDepartment.FUseDepartmentID = useDepartment.FID ");
        if (this.isQuerySingleCard) {
            sql.append(" INNER JOIN T_BD_MeasureUnit MEASUREUNIT ON MEASUREUNIT.fid = dc.FMeasureUnitID");
        }
        if (this.filter != null && (this.filter.indexOf("asstActItem.fname_l2") != -1 || this.filter.indexOf("asstActType.fnumber") != -1)) {
            sql.append(" INNER JOIN T_FA_FACURCOSTCENTER costcenter on costcenter.ffacurcardid = dc.fid");
            sql.append(" INNER JOIN T_FA_FACURASSTACTCOMPOSIT composit on composit.FfaCurCostCenterId = costcenter.Fid");
            sql.append(" INNER JOIN t_bd_asstacttype asstActType on asstActType.Fid = composit.FasstActType");
            sql.append(" INNER JOIN " + this.acctAsstTableName + " AS asstActItem ON composit.FAsstActItem = asstActItem.FID AND asstActItem.fasstActTypeId = composit.fasstActType");
        }
        sql.append(" WHERE ss.fname= ").append(14);
        sql.append(this.getPeriodCond());
        sql.append(" AND da.fcompanyid ");
        if (this.isVirCompany) {
            sql.append(" IN (").append(this.strCompanyInclude).append(") ");
        } else {
            sql.append(" = ? ");
            this.params.addString(this.currCompanyInfo.getId().toString());
        }
        sql.append(" AND da.FDepType != 2 ");
        if (this.filter != null) {
            String tmpFilter = this.filter.replaceAll("ASSETNUMBER", "dc.fnumber");
            tmpFilter = tmpFilter.replaceAll("assetName", "dc.fassetName");
            tmpFilter = tmpFilter.replaceAll("oldNumber", "dc.FOldNumber");
            tmpFilter = tmpFilter.replaceAll("groupNumber", "dc.fgroupNumber");
            sql.append(" AND ").append(tmpFilter);
        }
        return sql.toString();
    }

    private String getMonDeprSql() throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select distinct period.fbeginDate,period.fperiodyear,period.fperiodnumber,da.fid,db.fid as entryId,");
        sql.append("db.FDepreciation,db.FWellCost,dc.fcompanyid,");
        sql.append(this.getCatAdminSql(this.isGroupByDep, this.isGroupByAssetType));
        sql.append("da.fbizdate");
        if (this.isQuerySingleCard) {
            sql.append(",dc.FNumber AS FNumber,dc.foldNumber as oldernumber,dc.FGroupNumber AS FGroupNumber,dc.FAssetName AS FAssetName,MEASUREUNIT.FName_l2 AS UNIT");
            sql.append(",dc.FassetAmt AS FassetAmt,currency.FName_l2 AS CURRENCY,currency.FPrecision AS Fcurrencypre,dc.FExRate AS FExRate");
            sql.append(",dc.FOriginAmt AS FOriginAmt,dc.FAddons AS FAddons,dc.FAssetValue AS FAssetValue");
            sql.append(",db.FFACURCARDID AS FACURCARDID,dcur.FNumber AS FACURCARDNUM");
        }
        sql.append(" from t_fa_fadepreciation AS da");
        sql.append(" inner join t_fa_fadepreciationentry AS db on da.fid = db.FLnkFaDepreEntry");
        sql.append(" inner join t_bd_period period ON da.fperiod = period.fid");
        sql.append(" inner join t_fa_famoncard dc on dc.ffacurcardid = db.ffacurcardid and dc.ffaperiodid = period.fid");
        sql.append(" INNER JOIN T_FA_FACURCARD dcur ON dc.ffacurcardid = dcur.fid");
        sql.append(" INNER JOIN T_FA_Cat assetCat ON dc.fassetcatid = assetCat.fid");
        sql.append(" INNER JOIN T_BD_Currency AS CURRENCY ON dc.FCurrencyID = CURRENCY.FID ");
        sql.append(" LEFT OUTER JOIN T_FA_FaMonDepartment AS faDepartment ON dc.fid = faDepartment.FFaMonCardID ");
        sql.append(" INNER JOIN T_ORG_ADMIN AS useDepartment ON faDepartment.FUseDepartmentID = useDepartment.FID ");
        if (this.isQuerySingleCard) {
            sql.append(" INNER JOIN T_BD_MeasureUnit MEASUREUNIT ON MEASUREUNIT.fid = dc.FMeasureUnitID");
        }
        if (this.filter != null && (this.filter.indexOf("asstActItem.fname_l2") != -1 || this.filter.indexOf("asstActType.fnumber") != -1)) {
            sql.append(" INNER JOIN T_FA_FAMonCOSTCENTER costcenter on costcenter.ffamoncardid = dc.fid");
            sql.append(" INNER JOIN T_FA_FAMONASSTACTCOMPOSIT composit on composit.FfaMonCostCenterId = costcenter.Fid");
            sql.append(" INNER JOIN t_bd_asstacttype asstActType on asstActType.Fid = composit.FasstActType");
            sql.append(" INNER JOIN " + this.acctAsstTableName + " AS asstActItem ON composit.FAsstActItem = asstActItem.FID AND asstActItem.fasstActTypeId = composit.fasstActType");
        }
        sql.append(" WHERE period.FPeriodYear*100+period.fperiodnumber >=").append(this.startYear * 100 + this.startNumber);
        sql.append(" AND period.FPeriodYear*100+period.fperiodnumber <=").append(this.endYear * 100 + this.endNumber);
        sql.append(" AND da.fcompanyid ");
        if (this.isVirCompany) {
            sql.append(" IN (").append(this.strCompanyInclude).append(") ");
        } else {
            sql.append(" = '" + this.currCompanyInfo.getId().toString() + "'");
        }
        sql.append(" AND da.FDepType != 2 ");
        if (this.filter != null) {
            String tmpFilter = this.filter.replaceAll("ASSETNUMBER", "dcur.fnumber");
            tmpFilter = tmpFilter.replaceAll("assetName", "dcur.fassetName");
            tmpFilter = tmpFilter.replaceAll("oldNumber", "dcur.FOldNumber");
            tmpFilter = tmpFilter.replaceAll("groupNumber", "dcur.fgroupNumber");
            sql.append(" AND ").append(tmpFilter);
        }
        return sql.toString();
    }

    private void getResultSql() {
        StringBuffer sql = new StringBuffer();
        if (this.sumOption != null && this.sumOption.isHasSum()) {
            sql.append(this.sumOption.getStrSelectResult() + ", ");
        }
        sql.append("BIZDATE, ");
        sql.append("BRIEF, ");
        sql.append("assetType,");
        sql.append("catNum,");
        sql.append("adminDepartment,");
        sql.append("adminNum,");
        sql.append("BILLID, ");
        sql.append("FACURCARDID,");
        sql.append("voucherNumber,");
        sql.append("abstract,");
        sql.append("bizNumber,");
        sql.append("BILLTYPE, ");
        sql.append("ASSETNUMBER, ");
        sql.append("OLDERNUMBER, ");
        sql.append("GROUPNUMBER, ");
        sql.append("ASSETNAME, ");
        sql.append("UNIT, ");
        sql.append("ASSETAMT, ");
        sql.append("CURRENCY, ");
        sql.append("Fcurrencypre, ");
        sql.append("FexRate, ");
        sql.append("FOriginAmt, ");
        sql.append("FAddons, ");
        sql.append("FAssetValue, ");
        sql.append("VALUEDEBIT, ");
        sql.append("VALUECREDIT, ");
        sql.append("VALUEBAL, ");
        sql.append("DEPRDEBIT, ");
        sql.append("DEPRCREDIT, ");
        sql.append("DEPRBAL, ");
        sql.append("NETVALUE, ");
        sql.append("DEVALUEDEBIT, ");
        sql.append("DEVALUECREDIT, ");
        sql.append("DEVALUEBAL, ");
        sql.append("NETAMOUNT,");
        sql.append("COMPANY_ID");
        if (this.isVirCompany) {
            sql.append(",isSum");
            sql.append(", SumLevel ");
        }
        this.resultSql.setSelect(sql.toString());
        this.resultSql.setFrom(this.tempTable);
        this.resultSql.setOrder(this.sorter);
    }

    @Override
    protected String buildSorterSql(EntityViewInfo ev) {
        StringBuffer sorter = new StringBuffer();
        if (this.isFromPrintCard) {
            sorter.append("FACURCARDNUM,");
        }
        sorter.append("PERIODYEAR,PERIODNUMBER,isBegin");
        StringBuffer sorterSql = new StringBuffer();
        if (this.sumOption != null) {
            if (this.sumOption.isHasSum()) {
                sorterSql.append(this.sumOption.getOrderFields().toString()).append(",");
            }
            sorterSql.append(" isSum desc ");
        }
        if (ev.getSorter().toString() != null && ev.getSorter().toString().length() > 0) {
            if (sorterSql.length() > 0) {
                sorterSql.append(",");
            }
            sorterSql.append(ev.getSorter());
        }
        if (sorterSql.length() > 0) {
            sorter.append(",").append(sorterSql);
        }
        return sorter.append(",BIZDATE,SORT_COL,ASSETNUMBER").toString();
    }

    @Override
    protected void buildData() throws BOSException {
        this.getResultSql();
        this.result.put("resultSql", this.resultSql);
        StringBuffer sql = new StringBuffer();
        sql.append(this.getNewCardSql());
        sql.append(" union all ").append(this.getChangeBillSql());
        sql.append(" union all ").append(this.getCleanBillSql());
        sql.append(" union all ").append(this.getDeprSql());
        this.addDataTempTable(sql.toString());
        try {
            this.daoSql = this.getYearMonthSumSql();
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
        DbUtil.execute((Context)this.ctx, (String)FaLocalUtils.transformLocal((Context)this.ctx, (String)("INSERT INTO " + this.tempTable + " select * from (" + this.daoSql + ") as tempTable ")));
        if (this.isGroupByCard && !this.isShowNoIncurredAmtCard) {
            DbUtil.execute((Context)this.ctx, (String)("DELETE FROM " + this.tempTable + " WHERE FACURCARDID NOT IN (SELECT FACURCARDID FROM " + this.tempTable + " WHERE BILLID IS NOT NULL)"));
        }
        this.updateStartYearOrStartPeriod();
        if (this.isGroupByAssetType) {
            this.createYearMonthSumSql();
            this.updateMonthSumSql();
        }
        this.setYearBalance(this.ctx);
        this.setYearAccount(this.ctx);
        if (this.sumOption != null) {
            this.sumSql = this.sumOption.getSumSql(this.tempTable, this.select, null, "FYearOrMonth = 1", "PERIODYEAR,PERIODNUMBER,isBegin,SORT_COL,BIZDATE,BRIEF", true, false);
            if (this.sumSql != null && this.sumSql.trim().length() > 0) {
                DbUtil.execute((Context)this.ctx, (String)this.sumSql);
            }
        }
        if (this.isVirCompany) {
            this.deleteUnnecessaryData();
        }
        if (this.isFromPrintCard) {
            StringBuffer updatesql = new StringBuffer();
            updatesql.append("UPDATE ").append(this.tempTable).append(" SET ADMINNUM= ASSETNUMBER ");
            DbUtil.execute((Context)this.ctx, (String)updatesql.toString());
            updatesql = new StringBuffer();
            updatesql.append("UPDATE ").append(this.tempTable).append(" SET ADMINDEPARTMENT=(select top 1 assetName from " + this.tempTable + " as T1 where t1.ASSETNUMBER = " + this.tempTable + ".ASSETNUMBER and T1.billid is not null ) ");
            DbUtil.execute((Context)this.ctx, (String)updatesql.toString());
            updatesql = new StringBuffer();
            updatesql.append("UPDATE ").append(this.tempTable).append(" SET ASSETNUMBER=null where BILLID is null  ");
            DbUtil.execute((Context)this.ctx, (String)updatesql.toString());
        }
        this.result.put("tempTableName", this.tempTable);
        List[] admin = this.getAdminDepartmentList();
        this.result.put("adminDepartmentList", admin[0]);
        this.result.put("adminNumList", admin[1]);
        List[] cat = this.getAssetCatList();
        this.result.put("assetTypeList", cat[0]);
        this.result.put("catNumList", cat[1]);
        List[] card = this.getCardList();
        this.result.put("cardNameList", card[0]);
        this.result.put("cardNumList", card[1]);
        try {
            if (this.hasNoAuditDepr(this.ctx)) {
                this.result.put("hasNoAudit", new Boolean(true));
            } else {
                this.result.put("hasNoAudit", new Boolean(false));
            }
        }
        catch (EASBizException ex) {
            throw new BOSException((Throwable)ex);
        }
    }

    private void setYearAccount(Context ctx) throws BOSException {
        if (!this.isGroupByAssetType) {
            this.setYearAccountOld(ctx);
            return;
        }
        this.setYearAccountNew(ctx);
    }

    private void setYearAccountOld(Context ctx) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select distinct PERIODYEAR,PERIODNUMBER from ").append(this.tempTable);
        sql.append(" where isbegin = 2 and fyearormonth = 1");
        sql.append(" order by PERIODYEAR,PERIODNUMBER");
        IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (iRowSet.next()) {
                List[] cardList;
                String filterString1;
                List[] departmentLists;
                String strFilter;
                String fil1;
                List[] cat;
                int peirodYear = iRowSet.getInt("PERIODYEAR");
                int periodNumber = iRowSet.getInt("PERIODNUMBER");
                sql = new StringBuffer();
                sql.append("UPDATE ").append(this.tempTable).append(" SET (VALUEDEBIT,VALUECREDIT,DEPRDEBIT,DEPRCREDIT,DEVALUEDEBIT,DEVALUECREDIT) = (select distinct temp.VALUEDEBIT,temp.VALUECREDIT,temp.DEPRDEBIT,temp.DEPRCREDIT,temp.DEVALUEDEBIT,temp.DEVALUECREDIT from (select t.fcompanyorgunitid,");
                if (peirodYear == this.startYear) {
                    sql.append(this.isByEvalue ? " fevalueDebitFor+tempTable.VALUEDEBIT VALUEDEBIT,fevalueCreditFor+tempTable.VALUECREDIT VALUECREDIT," : " frealDebitFor+tempTable.VALUEDEBIT VALUEDEBIT,frealCreditFor+tempTable.VALUECREDIT VALUECREDIT,");
                    sql.append(" fdepreDebitFor+tempTable.DEPRDEBIT DEPRDEBIT,fdepreCreditFor+tempTable.DEPRCREDIT DEPRCREDIT,fdecValueDebitFor+tempTable.DEVALUEDEBIT DEVALUEDEBIT,fdecValueCreditFor+tempTable.DEVALUECREDIT DEVALUECREDIT ");
                } else {
                    sql.append(this.isByEvalue ? " fevalueDebitFor VALUEDEBIT,fevalueCreditFor VALUECREDIT," : " frealDebitFor VALUEDEBIT,frealCreditFor VALUECREDIT,");
                    sql.append(" fdepreDebitFor DEPRDEBIT,fdepreCreditFor DEPRCREDIT,fdecValueDebitFor DEVALUEDEBIT,fdecValueCreditFor DEVALUECREDIT ");
                }
                if (this.isFromPrintCard || this.isGroupByCard && this.isShowNoIncurredAmtCard) {
                    sql.append("  ,cardnumber ");
                }
                sql.append("  from ( select ");
                sql.append(" bal.fcompanyorgunitid fcompanyorgunitid,");
                if (this.isGroupByAssetType) {
                    sql.append(" assetCat.flongnumber catnumber, ");
                }
                if (this.isGroupByDep) {
                    sql.append(" useDepartment.flongnumber adminnumber, ");
                }
                if (this.isFromPrintCard || this.isGroupByCard || this.filter != null && (this.filter.indexOf("ASSETNUMBER = ") != -1 || this.filter.indexOf("(ASSETNUMBER") != -1)) {
                    sql.append(" card.fnumber cardNumber, ");
                }
                sql.append(this.isByEvalue ? "sum(fevalueDebitFor) fevalueDebitFor,sum(fevalueCreditFor) fevalueCreditFor," : "sum(frealDebitFor) frealDebitFor,sum(frealCreditFor) frealCreditFor,");
                sql.append(" sum(fdepreDebitFor) fdepreDebitFor,sum(fdepreCreditFor) fdepreCreditFor,");
                sql.append("sum(fdecValueDebitFor) fdecValueDebitFor,sum(fdecValueCreditFor) fdecValueCreditFor");
                sql.append(" from t_fa_faaccountbalance bal inner join t_bd_period period on period.fid = bal.fperiodid");
                if (this.isGroupByCard) {
                    sql.append(" left join t_fa_facurcard card on bal.ffacurcardid = card.fid ");
                    if (this.filter != null && (this.filter.indexOf("asstActItem.fname_l2") != -1 || this.filter.indexOf("asstActType.fnumber") != -1)) {
                        sql.append(" INNER JOIN T_FA_FACURCOSTCENTER costcenter on costcenter.ffacurcardid = card.fid");
                        sql.append(" INNER JOIN T_FA_FACURASSTACTCOMPOSIT composit on composit.FfaCurCostCenterId = costcenter.Fid");
                        sql.append(" INNER JOIN t_bd_asstacttype asstActType on asstActType.Fid = composit.FasstActType");
                        sql.append(" INNER JOIN " + this.acctAsstTableName + " AS asstActItem ON composit.FAsstActItem = asstActItem.FID AND asstActItem.fasstActTypeId = composit.fasstActType");
                    }
                }
                if (this.isGroupByAssetType) {
                    if (sql.indexOf("t_fa_facurcard") == -1) {
                        sql.append(" left join t_fa_facurcard card on bal.ffacurcardid = card.fid ");
                    }
                    sql.append(" left join t_fa_cat assetCat on card.fassetcatid= assetCat.fid ");
                }
                if (this.isGroupByDep) {
                    if (sql.indexOf("t_fa_facurcard") == -1) {
                        sql.append(" left join t_fa_facurcard card on bal.ffacurcardid = card.fid ");
                    }
                    sql.append(" left join t_fa_facurdepartment facurdepartment on card.fid = facurdepartment.FFaCurCardID ");
                    sql.append(" inner join T_ORG_Admin useDepartment on facurdepartment.FUseDepartmentID = useDepartment.fid ");
                }
                if (!this.isGroupByAssetType && this.filter != null && this.filter.indexOf("assetCat.fnumber") != -1) {
                    if (!this.isGroupByCard && !this.isGroupByDep) {
                        sql.append(" left join t_fa_facurcard card on bal.ffacurcardid = card.fid ");
                    }
                    sql.append(" left join t_fa_cat assetCat on card.fassetcatid= assetCat.fid ");
                }
                if (!this.isGroupByDep && this.filter != null && this.filter.indexOf("useDepartment.fnumber") != -1) {
                    if (!this.isGroupByCard && !this.isGroupByAssetType && sql.indexOf("t_fa_facurcard") == -1) {
                        sql.append(" left join t_fa_facurcard card on bal.ffacurcardid = card.fid ");
                    }
                    sql.append(" left join t_fa_facurdepartment facurdepartment on card.fid = facurdepartment.FFaCurCardID ");
                    sql.append(" inner join T_ORG_Admin useDepartment on facurdepartment.FUseDepartmentID = useDepartment.fid ");
                }
                if (!this.isGroupByCard && !this.isGroupByDep && this.filter != null) {
                    if (sql.indexOf("t_fa_facurcard") == -1) {
                        sql.append(" left join t_fa_facurcard card on bal.ffacurcardid = card.fid ");
                    }
                    if (sql.indexOf("t_fa_cat") == -1) {
                        sql.append(" left join t_fa_cat assetCat on card.fassetcatid= assetCat.fid ");
                    }
                }
                if (sql.indexOf("t_bd_asstacttype") == -1 && this.filter != null && (this.filter.indexOf("asstActItem.fname_l2") != -1 || this.filter.indexOf("asstActType.fnumber") != -1)) {
                    sql.append(" INNER JOIN T_FA_FACURCOSTCENTER costcenter on costcenter.ffacurcardid = card.fid");
                    sql.append(" INNER JOIN T_FA_FACURASSTACTCOMPOSIT composit on composit.FfaCurCostCenterId = costcenter.Fid");
                    sql.append(" INNER JOIN t_bd_asstacttype asstActType on asstActType.Fid = composit.FasstActType");
                    sql.append(" INNER JOIN " + this.acctAsstTableName + " AS asstActItem ON composit.FAsstActItem = asstActItem.FID AND asstActItem.fasstActTypeId = composit.fasstActType");
                }
                if (this.filter != null && this.filter.indexOf("currency.fnumber") != -1) {
                    sql.append(" inner join t_bd_currency currency on currency.fid = card.fcurrencyid ");
                }
                sql.append(" where period.FNumber <= ").append(peirodYear * 100 + periodNumber).append(" and period.FNumber >=").append(this.startYear * 100 + this.startNumber);
                sql.append(" and period.Fnumber >=").append(peirodYear * 100 + 1);
                if (this.isGroupByAssetType && this.filter != null) {
                    if (this.filter.indexOf("assetCat.flongnumber") == -1 && ((ArrayList)(cat = this.getAssetCatList())[1]).size() > 0 && ((ArrayList)cat[1]).get(0) != null) {
                        fil1 = ((ArrayList)cat[1]).get(0).toString();
                        sql.append(" and assetCat.flongnumber= '").append(fil1).append("'");
                    }
                    strFilter = this.filter.replaceAll("ASSETNUMBER", "card.fnumber").toString();
                    strFilter = strFilter.replaceAll("oldNumber", "card.fOldNumber");
                    strFilter = strFilter.replaceAll("assetName", "card.fassetName");
                    strFilter = strFilter.replaceAll("groupNumber", "card.FGroupNumber");
                    sql.append(" AND ").append(strFilter);
                }
                if (this.isGroupByAssetType && this.filter == null && ((ArrayList)(cat = this.getAssetCatList())[1]).size() > 0 && ((ArrayList)cat[1]).get(0) != null) {
                    fil1 = ((ArrayList)cat[1]).get(0).toString();
                    sql.append(" and assetCat.flongnumber= '").append(fil1).append("'");
                }
                if (this.isGroupByDep && this.filter != null) {
                    if (this.filter.indexOf("useDepartment.FLongNumber") == -1 && ((ArrayList)(departmentLists = this.getAdminDepartmentList())[1]).size() > 0 && ((ArrayList)departmentLists[1]).get(0) != null) {
                        filterString1 = ((ArrayList)departmentLists[1]).get(0).toString();
                        sql.append(" and useDepartment.flongnumber= '").append(filterString1).append("'");
                    }
                    strFilter = this.filter.replaceAll("ASSETNUMBER", "card.fnumber").toString();
                    strFilter = strFilter.replaceAll("oldNumber", "card.fOldNumber");
                    strFilter = strFilter.replaceAll("assetName", "card.fassetName");
                    strFilter = strFilter.replaceAll("groupNumber", "card.FGroupNumber");
                    sql.append(" AND ").append(strFilter);
                }
                if (this.isGroupByDep && this.filter == null && ((ArrayList)(departmentLists = this.getAdminDepartmentList())[1]).size() > 0 && ((ArrayList)departmentLists[1]).get(0) != null) {
                    filterString1 = ((ArrayList)departmentLists[1]).get(0).toString();
                    sql.append(" and useDepartment.flongnumber= '").append(filterString1).append("'");
                }
                if (this.isGroupByCard && this.filter != null) {
                    if (this.filter.indexOf("ASSETNUMBER = ") == -1 && this.filter.indexOf("(ASSETNUMBER") == -1 && !this.isFromPrintCard && ((ArrayList)(cardList = this.getCardList())[1]).size() > 0 && ((ArrayList)cardList[1]).get(0) != null) {
                        filterString1 = ((ArrayList)cardList[1]).get(0).toString();
                        sql.append(" and card.fnumber= '").append(filterString1).append("'");
                    }
                    strFilter = this.filter.replaceAll("ASSETNUMBER", "card.fnumber").toString();
                    strFilter = strFilter.replaceAll("assetName", "card.fassetName");
                    strFilter = strFilter.replaceAll("oldNumber", "card.fOldNumber");
                    strFilter = strFilter.replaceAll("groupNumber", "card.FGroupNumber");
                    sql.append(" AND ").append(strFilter);
                }
                if (this.isGroupByCard && this.filter == null && ((ArrayList)(cardList = this.getCardList())[1]).size() > 0 && ((ArrayList)cardList[1]).get(0) != null) {
                    String filCard = ((ArrayList)cardList[1]).get(0).toString();
                    sql.append(" and card.fnumber='").append(filCard).append("'");
                }
                if (!this.isGroupByCard && !this.isGroupByDep && this.filter != null) {
                    strFilter = this.filter.replaceAll("ASSETNUMBER", "card.fnumber").toString();
                    strFilter = strFilter.replaceAll("oldNumber", "card.fOldNumber");
                    strFilter = strFilter.replaceAll("assetName", "card.fassetName");
                    strFilter = strFilter.replaceAll("groupNumber", "card.FGroupNumber");
                    sql.append(" AND ").append(strFilter);
                }
                sql.append(" group by fcompanyorgunitid ");
                if (this.isGroupByAssetType) {
                    sql.append(", assetCat.flongnumber");
                }
                if (this.isGroupByDep) {
                    sql.append(", useDepartment.flongnumber ");
                }
                if (this.isFromPrintCard || this.isGroupByCard || this.filter != null && (this.filter.indexOf("ASSETNUMBER = ") != -1 || this.filter.indexOf("(ASSETNUMBER") != -1)) {
                    sql.append(", card.fnumber ");
                }
                sql.append(") t ");
                sql.append(" inner join ").append(this.tempTable).append(" tempTable on tempTable.COMPANY_ID = t.fcompanyorgunitid and tempTable.SORT_COL='1' ");
                if (this.isFromPrintCard || this.isGroupByCard) {
                    sql.append("  and tempTable.assetnumber = cardnumber  ");
                }
                sql.append(" ) temp ");
                sql.append(" where temp.fcompanyorgunitid = company_id ");
                if (this.isFromPrintCard || this.isGroupByCard && this.isShowNoIncurredAmtCard) {
                    sql.append("  and temp.cardnumber = assetnumber   ");
                }
                sql.append(" ) ");
                sql.append(" where PERIODYEAR = ").append(peirodYear).append(" and PERIODNUMBER = ").append(periodNumber);
                sql.append(" and SORT_COL = '9'");
                DbUtil.execute((Context)ctx, (String)sql.toString());
            }
        }
        catch (SQLException ex) {
            this.isFromPrintCard = false;
            throw new BOSException("sql error: " + sql.toString(), (Throwable)ex);
        }
    }

    private void setYearAccountNew(Context ctx) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select distinct PERIODYEAR,PERIODNUMBER from ").append(this.tempTable);
        sql.append(" where isbegin = 2 and fyearormonth = 1");
        sql.append(" order by PERIODYEAR,PERIODNUMBER");
        IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        boolean isFirstPeriod = true;
        int prePeriodYear = 0;
        int prePeriodNumber = 0;
        try {
            while (iRowSet.next()) {
                int periodYear = iRowSet.getInt("PERIODYEAR");
                int periodNumber = iRowSet.getInt("PERIODNUMBER");
                if (isFirstPeriod) {
                    sql = new StringBuffer();
                    sql.append("UPDATE ").append(this.tempTable).append(" t SET (VALUEDEBIT,VALUECREDIT,DEPRDEBIT,DEPRCREDIT,DEVALUEDEBIT,DEVALUECREDIT) =");
                    sql.append(" (select monBegin.VALUEDEBIT+mon.VALUEDEBIT,monBegin.VALUECREDIT+mon.VALUECREDIT,monBegin.DEPRDEBIT+mon.DEPRDEBIT,monBegin.DEPRCREDIT+mon.DEPRCREDIT,monBegin.DEVALUEDEBIT+mon.DEVALUEDEBIT,monBegin.DEVALUECREDIT+mon.DEVALUECREDIT from ");
                    sql.append("(SELECT * FROM ").append(this.tempTable).append(" WHERE SORT_COL = '1' and isbegin = 1 ");
                    sql.append(" ) monBegin");
                    sql.append(" ,(SELECT * FROM ").append(this.tempTable).append(" WHERE SORT_COL = '8' and isbegin = 2 AND ");
                    sql.append(" PERIODYEAR = ").append(periodYear).append(" and PERIODNUMBER = ").append(periodNumber);
                    sql.append(" ) mon)");
                    sql.append(" where t.PERIODYEAR = ").append(periodYear).append(" and t.PERIODNUMBER = ").append(periodNumber);
                    sql.append(" and t.SORT_COL = '9'");
                    DbUtil.execute((Context)ctx, (String)sql.toString());
                    isFirstPeriod = false;
                } else if (periodYear > prePeriodYear) {
                    sql = new StringBuffer();
                    sql.append("UPDATE ").append(this.tempTable).append(" t SET (VALUEDEBIT,VALUECREDIT,DEPRDEBIT,DEPRCREDIT,DEVALUEDEBIT,DEVALUECREDIT) =");
                    sql.append(" (SELECT mon.VALUEDEBIT,mon.VALUECREDIT,mon.DEPRDEBIT,mon.DEPRCREDIT,mon.DEVALUEDEBIT,mon.DEVALUECREDIT from ");
                    sql.append(this.tempTable).append(" mon WHERE mon.SORT_COL = '8' and mon.isbegin = 2 AND ");
                    sql.append(" mon.PERIODYEAR = ").append(periodYear).append(" and mon.PERIODNUMBER = ").append(periodNumber);
                    sql.append(" )");
                    sql.append(" where t.PERIODYEAR = ").append(periodYear).append(" and t.PERIODNUMBER = ").append(periodNumber);
                    sql.append(" and t.SORT_COL = '9'");
                    DbUtil.execute((Context)ctx, (String)sql.toString());
                } else {
                    sql = new StringBuffer();
                    sql.append("UPDATE ").append(this.tempTable).append(" t SET (VALUEDEBIT,VALUECREDIT,DEPRDEBIT,DEPRCREDIT,DEVALUEDEBIT,DEVALUECREDIT) =");
                    sql.append(" (select pre.VALUEDEBIT+mon.VALUEDEBIT,pre.VALUECREDIT+mon.VALUECREDIT,pre.DEPRDEBIT+mon.DEPRDEBIT,pre.DEPRCREDIT+mon.DEPRCREDIT,pre.DEVALUEDEBIT+mon.DEVALUEDEBIT,pre.DEVALUECREDIT+mon.DEVALUECREDIT from ");
                    sql.append("(SELECT * FROM ").append(this.tempTable).append(" WHERE SORT_COL = '9' AND ");
                    sql.append(" PERIODYEAR = ").append(prePeriodYear).append(" and PERIODNUMBER = ").append(prePeriodNumber);
                    sql.append(" ) pre");
                    sql.append(" ,(SELECT * FROM ").append(this.tempTable).append(" WHERE SORT_COL = '8' and isbegin = 2 AND ");
                    sql.append(" PERIODYEAR = ").append(periodYear).append(" and PERIODNUMBER = ").append(periodNumber);
                    sql.append(" ) mon)");
                    sql.append(" where t.PERIODYEAR = ").append(periodYear).append(" and t.PERIODNUMBER = ").append(periodNumber);
                    sql.append(" and t.SORT_COL = '9'");
                    DbUtil.execute((Context)ctx, (String)sql.toString());
                }
                prePeriodYear = periodYear;
                prePeriodNumber = periodNumber;
            }
        }
        catch (SQLException ex) {
            this.isFromPrintCard = false;
            throw new BOSException("sql error: " + sql.toString(), (Throwable)ex);
        }
    }

    private boolean hasNoAuditDepr(Context ctx) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT COUNT (line.fid) AS COUNT \n");
        sql.append("  FROM t_fa_fadepreciationentry line INNER JOIN t_fa_fadepreciation head ON line.flnkfadepreentry = head.fid \n");
        sql.append("  INNER JOIN t_bd_period period ON head.fperiod = period.fid \n");
        sql.append(" WHERE period.FNumber >= ? ");
        sql.append(" AND period.FNumber <= ?");
        sql.append(" AND head.fcompanyid in (");
        sql.append(this.strCompanyInclude).append(") AND (head.fdeptype = 0 OR head.fdeptype = 1) AND line.fstate <> 3 \n");
        Object[] sqlPara = new Object[]{new Integer(this.startYear * 100 + this.startNumber), new Integer(this.endYear * 100 + this.endNumber)};
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])sqlPara);
            if (rowSet.next() && rowSet.getInt("COUNT") > 0) {
                return true;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return false;
    }

    protected void deleteUnnecessaryData() throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("DELETE FROM ");
        sql.append(this.tempTable).append(" WHERE ISSUM=0 AND FYearOrMonth = 1");
        DbUtil.execute((Context)this.ctx, (String)sql.toString());
    }

    private String getPeriodCond() {
        StringBuffer sql = new StringBuffer();
        if (this.startYear == this.endYear) {
            sql.append(" AND period.FPeriodYear = ? ");
            this.params.addInt(this.startYear);
            if (this.startNumber == this.endNumber) {
                sql.append(" AND period.FPeriodNumber = ? ");
                this.params.addInt(this.startNumber);
            } else {
                sql.append(" AND period.FPeriodNumber >= ? and period.FPeriodNumber <= ? ");
                this.params.addInt(this.startNumber);
                this.params.addInt(this.endNumber);
            }
        } else {
            sql.append(" AND (period.FPeriodYear>? or (period.FPeriodYear=? and period.FPeriodNumber >= ?))");
            sql.append(" AND (period.FPeriodYear<? or (period.FPeriodYear=? and period.FPeriodNumber <= ?))");
            this.params.addInt(this.startYear);
            this.params.addInt(this.startYear);
            this.params.addInt(this.startNumber);
            this.params.addInt(this.endYear);
            this.params.addInt(this.endYear);
            this.params.addInt(this.endNumber);
        }
        return sql.toString();
    }

    private String getPeriodCondNullParam() {
        StringBuffer sql = new StringBuffer();
        if (this.startYear == this.endYear) {
            sql.append(" AND period.FPeriodYear = ").append(this.startYear);
            if (this.startNumber == this.endNumber) {
                sql.append(" AND period.FPeriodNumber = ").append(this.startNumber);
                sql.append(" ");
            } else {
                sql.append(" AND period.FPeriodNumber >= ").append(this.startNumber);
                sql.append(" and period.FPeriodNumber <= ").append(this.endNumber);
                sql.append(" ");
            }
        } else {
            sql.append(" AND (period.FPeriodYear> ").append(this.startYear);
            sql.append(" or (period.FPeriodYear= ").append(this.startYear);
            sql.append(" and period.FPeriodNumber >= ").append(this.startNumber);
            sql.append(")) AND (period.FPeriodYear< ").append(this.endYear);
            sql.append(" or (period.FPeriodYear= ").append(this.endYear);
            sql.append(" and period.FPeriodNumber <= ").append(this.endNumber);
            sql.append(")) ");
        }
        return sql.toString();
    }

    private String getPeriodCondNullParam2() {
        StringBuffer sql = new StringBuffer();
        sql.append(" and period.FNumber <= ").append(this.endYear * 100 + this.endNumber);
        sql.append(" ");
        return sql.toString();
    }

    @Override
    protected String buildFilterSql(EntityViewInfo ev) {
        FilterInfo filterInfo = ev.getFilter();
        if (filterInfo == null || filterInfo.getFilterItems() == null || filterInfo.getFilterItems().isEmpty() || filterInfo.toString().equalsIgnoreCase("null")) {
            return null;
        }
        String filter = filterInfo.toString();
        if (filter.startsWith("NULL AND")) {
            filter = filter.substring(8);
        }
        return filter;
    }

    private String getSumBalanceSql() throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(this.getSumBalanceSelectSQL());
        sql.append(" FROM (");
        sql.append(this.getYearSumBalanceSQL());
        sql.append(") AS TMP");
        sql.append(" GROUP BY TMP.SORT_COL,TMP.isBegin,TMP.PERIODYEAR,TMP.PERIODNUMBER,TMP.BIZDATE,TMP.BRIEF,TMP.fcompanyid");
        if (this.isGroupByCard) {
            sql.append(",TMP.ffacurcardid,TMP.FNUMBER,TMP.FASSETNAME");
        } else if (this.isFromPrintCard) {
            sql.append(",TMP.FNUMBER,TMP.FASSETNAME");
        }
        sql.append(" UNION ALL ");
        sql.append(this.getSumBalanceSelectSQL());
        sql.append(" FROM (");
        sql.append(this.getMonthSumBalanceSQL());
        sql.append(") AS MTMP");
        sql.append(" GROUP BY MTMP.SORT_COL,MTMP.isBegin,MTMP.PERIODYEAR,MTMP.PERIODNUMBER,MTMP.BIZDATE,MTMP.BRIEF,MTMP.FCompanyID");
        if (this.isGroupByCard) {
            sql.append(",MTMP.ffacurcardid,MTMP.FNUMBER,MTMP.FASSETNAME");
        } else if (this.isFromPrintCard) {
            sql.append(",MTMP.FNUMBER,MTMP.FASSETNAME");
        }
        return sql.toString();
    }

    private void updateStartYearOrStartPeriod() throws BOSException {
        try {
            StringBuffer sql = new StringBuffer();
            StringBuffer yearNumber = new StringBuffer();
            StringBuffer termNumber = new StringBuffer();
            if (this.isFromPrintCard) {
                String assetNumber = null;
                int m = this.filter.toString().indexOf("(");
                int n = this.filter.toString().lastIndexOf(")");
                assetNumber = this.filter.toString().substring(m + 1, n);
                String[] assetNumbers = assetNumber.split(",");
                for (int i = 0; i < assetNumbers.length; ++i) {
                    sql = new StringBuffer();
                    sql.append(" select fid from ").append(this.tempTable).append(" where SORT_COL = '0'");
                    sql.append(" and FACURCARDNUM=").append(assetNumbers[i]);
                    IRowSet rowSet = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
                    if (!this.isByEvalue && !rowSet.next()) {
                        yearNumber.append("").append(assetNumbers[i]).append(",");
                    }
                    sql = new StringBuffer();
                    sql.append(" select fid from ").append(this.tempTable).append(" where SORT_COL = '1'");
                    sql.append(" and FACURCARDNUM= ").append(assetNumbers[i]);
                    rowSet = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
                    if (rowSet.next()) continue;
                    termNumber.append("").append(assetNumbers[i]).append(",");
                }
            } else {
                sql = new StringBuffer();
                sql.append(" select fid from ").append(this.tempTable).append(" where SORT_COL = '0'");
                IRowSet rowSet = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
                if (!this.isByEvalue && !rowSet.next()) {
                    yearNumber.append("This's just a flag");
                }
                sql = new StringBuffer();
                sql.append(" select fid from ").append(this.tempTable).append(" where SORT_COL = '1'");
                rowSet = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
                if (!rowSet.next()) {
                    termNumber.append("This's just a flag");
                }
            }
            if (yearNumber != null && yearNumber.length() > 0) {
                this.insertStartYearOrStartPeriod(yearNumber, true);
            }
            if (termNumber != null && termNumber.length() > 0) {
                this.insertStartYearOrStartPeriod(termNumber, false);
            }
        }
        catch (SQLException ex) {
            this.isFromPrintCard = false;
            throw new BOSException((Throwable)ex);
        }
    }

    private void insertStartYearOrStartPeriod(StringBuffer assetNumber, boolean isStartYear) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO " + this.tempTable + " select NEWBOSID('00000000') AS FId, ");
        if (this.sumOption != null && this.sumOption.isHasSum()) {
            sql.append(this.sumOption.getStrNameFields() + ", ");
        }
        sql.append("pd.FPERIODYEAR PERIODYEAR,");
        if (isStartYear) {
            sql.append("0 PERIODNUMBER,");
            sql.append("'0' SORT_COL, ");
            sql.append("0 isBegin,");
            sql.append("TO_DATE(TO_CHAR(pd.FPERIODYEAR)||'-1-1 00:00:00') AS BIZDATE, ");
            sql.append("N'" + ResourceBase.getString((String)"com.kingdee.eas.fi.fa.basedata.FaResource", (String)"startYearBalance", (Locale)this.ctx.getOriginLocale()) + "' BRIEF, ");
        } else {
            sql.append("pd.FPERIODNUMBER PERIODNUMBER,");
            sql.append("'1' SORT_COL, ");
            sql.append("1 isBegin,");
            sql.append("pd.FBeginDate, ");
            sql.append("N'" + ResourceBase.getString((String)"com.kingdee.eas.fi.fa.basedata.FaResource", (String)"startPerionBalance", (Locale)this.ctx.getOriginLocale()) + "' BRIEF, ");
        }
        sql.append("TO_CHAR(NULL) assetType,");
        sql.append("TO_CHAR(NULL) catNum,");
        sql.append("TO_CHAR(NULL) adminDepartment,");
        sql.append("TO_CHAR(NULL) adminNum,");
        sql.append("TO_CHAR(NULL) BILLID, ");
        sql.append(this.isGroupByCard && this.isFromPrintCard ? "T.FACURCARDID" : "TO_CHAR(NULL)").append(" AS FACURCARDID, ");
        sql.append(this.isGroupByCard && this.isFromPrintCard ? "T.FACURCARDNUM" : "TO_CHAR(NULL)").append(" AS FACURCARDNUM, ");
        sql.append("TO_CHAR(NULL) bizNumber,");
        sql.append("TO_CHAR(NULL) VoucherNumber,");
        sql.append("TO_CHAR(NULL) abstract,");
        sql.append("TO_INT(NULL) BILLTYPE, ");
        sql.append(this.isFromPrintCard ? "T.ASSETNUMBER" : "TO_CHAR(NULL)").append(" AS ASSETNUMBER, ");
        sql.append("TO_CHAR(NULL) OLDERNUMBER, ");
        sql.append("TO_CHAR(NULL) GROUPNUMBER, ");
        sql.append(this.isFromPrintCard ? "T.ASSETNAME" : "TO_CHAR(NULL)").append(" AS ASSETNAME, ");
        sql.append("TO_CHAR(NULL) UNIT, ");
        sql.append("TO_DECIMAL(NULL) AS ASSETAMT, ");
        sql.append("TO_CHAR(NULL) CURRENCY, ");
        sql.append("TO_INT(NULL) AS Fcurrencypre,");
        sql.append("TO_DECIMAL(NULL) AS FexRate,");
        sql.append("TO_DECIMAL(NULL) AS FOriginAmt,");
        sql.append("TO_DECIMAL(NULL) AS FAddons,");
        sql.append("TO_DECIMAL(NULL) AS FAssetValue,");
        sql.append("0.00 VALUEDEBIT, ");
        sql.append("0.00 VALUECREDIT, ");
        sql.append("0.00 VALUEBAL, ");
        sql.append("0.00 DEPRDEBIT, ");
        sql.append("0.00 DEPRCREDIT, ");
        sql.append("0.00 DEPRBAL, ");
        sql.append("0.00 NETVALUE, ");
        sql.append("0.00 DEVALUEDEBIT, ");
        sql.append("0.00 DEVALUECREDIT, ");
        sql.append("0.00 DEVALUEBAL, ");
        sql.append("0.00 NETAMOUNT, ");
        sql.append("1 FYearOrMonth, ");
        sql.append("0 AS isSum, ");
        sql.append("cp.fid COMPANY_ID ");
        if (this.isVirCompany) {
            sql.append(",cp.FLevel SumLevel");
        }
        if (this.sumOption != null && this.sumOption.isHasSum()) {
            sql.append(",").append(this.sumOption.getStrLongNumberFields());
        }
        sql.append(" from t_org_company cp ");
        sql.append(" inner join t_bd_period pd on cp.faccountperiodid = pd.ftypeid ");
        if (isStartYear) {
            sql.append(" INNER JOIN T_BD_SystemStatusCtrol ssc on ssc.FCompanyID = cp.fid ");
            sql.append(" INNER JOIN T_BD_PERIOD AS STARTPERIOD ON STARTPERIOD.FID = ssc.FStartPeriodID ");
            sql.append(" INNER JOIN T_BD_SystemStatus ss ON ss.FID = ssc.FSystemStatusID AND ss.FName = ").append(14);
        }
        sql.append(" INNER JOIN (").append("SELECT DISTINCT COMPANY_ID ");
        sql.append(this.isFromPrintCard ? ",ASSETNUMBER,ASSETNAME,FACURCARDID,FACURCARDNUM " : "");
        if (this.sumOption != null && this.sumOption.isHasSum()) {
            sql.append(",").append(this.sumOption.getStrNameFields());
            sql.append(",").append(this.sumOption.getStrLongNumberFields());
        }
        sql.append(" from ").append(this.tempTable);
        if (this.isFromPrintCard) {
            sql.append(" where ").append(" ASSETNUMBER in (").append(assetNumber.substring(0, assetNumber.length() - 1)).append(")");
        }
        sql.append(") T ON t.COMPANY_ID = cp.fid ");
        sql.append(" WHERE pd.fnumber = ").append(this.startYear * 100 + this.startNumber);
        if (isStartYear) {
            sql.append(" and ((STARTPERIOD.FNumber >= ").append(this.startYear * 100 + this.startNumber);
            sql.append(" and STARTPERIOD.FNumber <= ").append(this.endYear * 100 + this.endNumber).append(")");
            sql.append(" or ").append(this.startNumber).append(" = 1)");
        }
        DbUtil.execute((Context)this.ctx, (String)sql.toString());
    }
}

