/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.rpt.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.OrgRangeFactory;
import com.kingdee.eas.base.permission.OrgRangeType;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodTypeCollection;
import com.kingdee.eas.basedata.assistant.PeriodTypeFactory;
import com.kingdee.eas.basedata.master.account.AccountTableCollection;
import com.kingdee.eas.basedata.master.account.AccountTableFactory;
import com.kingdee.eas.basedata.master.account.AccountTools;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.app.FaLocalUtils;
import com.kingdee.eas.fi.gl.ReportBizException;
import com.kingdee.eas.fi.gl.ReportException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class FARptUtil {
    public static CompanyOrgUnitCollection getUserOrgRangesWithRange(Context ctx, String permissionItem) throws BOSException, EASBizException {
        HashSet<String> idSet = new HashSet<String>();
        UserInfo userInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        IPermission permission = PermissionFactory.getLocalInstance((Context)ctx);
        FullOrgUnitCollection mainOrgs = permission.getAuthorizedOrg((IObjectPK)new ObjectUuidPK(userInfo.getId()), OrgType.Company, null, permissionItem);
        for (int i = 0; i < mainOrgs.size(); ++i) {
            FullOrgUnitInfo orgUnit = (FullOrgUnitInfo)mainOrgs.getObject(i);
            idSet.add(orgUnit.getId().toString());
        }
        if (idSet.size() == 0) {
            return new CompanyOrgUnitCollection();
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter2 = new FilterInfo();
        view.setFilter(filter2);
        filter2.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("accountTable.id");
        sic.add("accountTable.name");
        sic.add("accountPeriodType.id");
        sic.add("accountPeriodType.name");
        view.setSelector(sic);
        SorterItemCollection sorterColl = new SorterItemCollection();
        sorterColl.add(new SorterItemInfo("number"));
        view.setSorter(sorterColl);
        return CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(view);
    }

    public static String getNewFieldByFieldName(String fieldName) {
        String newFieldName = "";
        newFieldName = fieldName.equals("assetCat.fnumber") ? "assetCat" : (fieldName.equals("useStatus.fnumber") ? "useStatus" : (fieldName.equals("economicPurp.fnumber") ? "economicPurp" : (fieldName.equals("storeCity.fnumber") ? "storeCity" : (fieldName.equals("originMethod.fnumber") ? "originMethod" : (fieldName.equals("assetAccount.fnumber") ? "assetAccount" : (fieldName.equals("accDeprAccount.fnumber") ? "accDeprAccount" : (fieldName.equals("decAccount.fnumber") ? "decAccount" : (fieldName.equals("asstActItem.fname_l2") ? "asstActItem" : (fieldName.equals("dept.fnumber") ? "dept" : (fieldName.equals("useDepartment.fnumber") ? "useDepartment" : fieldName))))))))));
        return newFieldName;
    }

    public static String getColumnKeyByFieldName(String fieldName) {
        String columnKey = "";
        if (fieldName.equals("assetCat")) {
            columnKey = "assetCat.name";
        } else if (fieldName.equals("useStatus")) {
            columnKey = "useStatus.name";
        } else if (fieldName.equals("economicPurp")) {
            columnKey = "economicPurp";
        } else if (fieldName.equals("storeCity")) {
            columnKey = "storeCity.name";
        } else if (fieldName.equals("originMethod")) {
            columnKey = "originMethod.name";
        } else if (fieldName.equals("assetAccount")) {
            columnKey = "assetAccount.name";
        } else if (fieldName.equals("accDeprAccount")) {
            columnKey = "accDeprAccount.name";
        } else if (fieldName.equals("decAccount")) {
            columnKey = "decAccount.name";
        }
        return columnKey;
    }

    public static String getColumnKeyByFieldNameForSelOption(String fieldName) {
        String columnKey = "";
        columnKey = fieldName.equalsIgnoreCase("ACNTASSET_NAME") ? "assetAccount.fnumber" : (fieldName.equalsIgnoreCase("ACNTACCDEPR_NAME") ? "accDeprAccount.fnumber" : (fieldName.equalsIgnoreCase("ACNTDECVAL") ? "decAccount.fnumber" : (fieldName.equalsIgnoreCase("EVALDEPRMODE") ? "EvalDeprMethod.fnumber" : (fieldName.equalsIgnoreCase("EVALMEASUREUNITWL") ? "EvalMeasureUnit.fnumber" : (fieldName.equalsIgnoreCase("COSTCENTER") ? "CostCenter" : (fieldName.equalsIgnoreCase("USEPERSON") ? "usePerson" : (fieldName.equalsIgnoreCase("ASSETNUMBER") ? "FACURCARD.fnumber" : (fieldName.equalsIgnoreCase("OLDERNUMBER") ? "FACURCARD.FoldNumber" : (fieldName.equalsIgnoreCase("ASSETNAME") ? "FACURCARD.fassetName" : (fieldName.equalsIgnoreCase("ASSETAMT") ? "FACURCARD.fassetAmt" : (fieldName.equalsIgnoreCase("ACCOUNTDATE") ? "FACURCARD.faccountDate" : (fieldName.equalsIgnoreCase("FIACCOUNTDATE") ? "FACURCARD.ffiAccountDate" : (fieldName.equalsIgnoreCase("SPECS") ? "FACURCARD.fspecs" : (fieldName.equalsIgnoreCase("PAREA") ? "FACURCARD.fpArea" : (fieldName.equalsIgnoreCase("MFR") ? "FACURCARD.fmfr" : (fieldName.equalsIgnoreCase("LEVFRDATE") ? "FACURCARD.flevFrDate" : (fieldName.equalsIgnoreCase("PAPERNO") ? "FACURCARD.fpaperNo" : (fieldName.equalsIgnoreCase("EXRATE") ? "FACURCARD.fexRate" : (fieldName.equalsIgnoreCase("ORIGINAMT") ? "FACURCARD.foriginAmt" : (fieldName.equalsIgnoreCase("INPUTTAX") ? "inputTax" : (fieldName.equalsIgnoreCase("ASSETVALUE") ? "FACURCARD.fassetValue" : (fieldName.equalsIgnoreCase("BUYVALUE") ? "FACURCARD.fbuyValue" : (fieldName.equalsIgnoreCase("BUYACCUDEPR") ? "FACURCARD.fbuyAccuDepr" : (fieldName.equalsIgnoreCase("DELIVERDATE") ? "FACURCARD.fdeliverDate" : (fieldName.equalsIgnoreCase("STARTUSEDATE") ? "FACURCARD.fstartUseDate" : (fieldName.equalsIgnoreCase("USEYEARS") ? "FACURCARD.fuseYears" : (fieldName.equalsIgnoreCase("USETERMCOUNT") ? "FACURCARD.fuseTermCount" : (fieldName.equalsIgnoreCase("DEPRTERMCOUNT") ? "FACURCARD.fdeprTermCount" : (fieldName.equalsIgnoreCase("ACCUDEPR") ? "FACURCARD.faccuDepr" : (fieldName.equalsIgnoreCase("ACCUDEPRTYEAR") ? "FACURCARD.faccuDeprTYear" : (fieldName.equalsIgnoreCase("NEATREMVALUE") ? "FACURCARD.fneatRemValue" : (fieldName.equalsIgnoreCase("NEATLEFTRATE") ? "FACURCARD.fNeatLeftRate" : (fieldName.equalsIgnoreCase("NEATVALUE") ? "FACURCARD.fneatValue" : (fieldName.equalsIgnoreCase("DECVALUE") ? "FACURCARD.fdecValue" : (fieldName.equalsIgnoreCase("NEATAMT") ? "FACURCARD.fneatAmt" : (fieldName.equalsIgnoreCase("REMARK") ? "FACURCARD.fremark" : (fieldName.equalsIgnoreCase("GROUPNUMBER") ? "FACURCARD.fgroupNumber" : (fieldName.equalsIgnoreCase("BARCODE") ? "barCode" : (fieldName.equalsIgnoreCase("EVALREINACCOUNTDATE") ? "FaCurCard.fevalReInAccountDate" : (fieldName.equalsIgnoreCase("EVALDEPRPERIODNUM") ? "FaCurCard.fevalDeprPeriodNum" : (fieldName.equalsIgnoreCase("EVALMONTHRATE") ? "FaCurCard.fevalMonthRate" : (fieldName.equalsIgnoreCase("EVALADDDEPR") ? "FaCurCard.fevalAddDepr" : (fieldName.equalsIgnoreCase("EVALREMVALUE") ? "FaCurCard.fevalRemValue" : (fieldName.equalsIgnoreCase("EVALYEARDEPR") ? "FaCurCard.fevalYearDepr" : (fieldName.equalsIgnoreCase("EVALDECVALUE") ? "FaCurCard.fevalDecValue" : (fieldName.equalsIgnoreCase("EVALNEATVALUE") ? "FaCurCard.fevalNeatValue" : (fieldName.equalsIgnoreCase("EVALNEATAMT") ? "FaCurCard.fevalNeatAmt" : (fieldName.equalsIgnoreCase("EVALASSETVALUE") ? "FaCurCard.fevalAssetValue" : (fieldName.equalsIgnoreCase("EVALTAXLEFTPERIOD") ? "FaCurCard.fevalTaxLeftPeriod" : (fieldName.equalsIgnoreCase("EVALUSETERMCOUNT") ? "FaCurCard.fevalUseTermCount" : (fieldName.equalsIgnoreCase("EVALDEPRTTERM") ? "FaCurCard.fevalDeprTTerm" : (fieldName.equalsIgnoreCase("EVALNEATLEFTRATE") ? "FaCurCard.fevalNeatLeftRate" : fieldName))))))))))))))))))))))))))))))))))))))))))))))))))));
        return columnKey;
    }

    public static PeriodTypeCollection getPeriodTypes(Context ctx) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        return PeriodTypeFactory.getLocalInstance((Context)ctx).getPeriodTypeCollection(view);
    }

    public static AccountTableCollection getAccountTables(Context ctx, String companyId) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company", (Object)companyId, CompareType.EQUALS));
        return AccountTableFactory.getLocalInstance((Context)ctx).getAccountTableCollection(view);
    }

    public static AccountTableCollection getAccountTableCollection(Context ctx, boolean isSupportUnion) throws ReportBizException, BOSException {
        CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)ctx);
        if (!company.isIsBizUnit() && isSupportUnion) {
            return AccountTools.getAllAccountTableByCompany((Context)ctx, (CompanyOrgUnitInfo)company);
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        return AccountTableFactory.getLocalInstance((Context)ctx).getAccountTableCollection(view);
    }

    public static PeriodCollection getPeriodColl(Context ctx, CompanyOrgUnitInfo companyInfo) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company", (Object)companyInfo.getId().toString(), CompareType.EQUALS));
        return PeriodFactory.getLocalInstance((Context)ctx).getPeriodCollection(view);
    }

    public static CompanyOrgUnitCollection getChildrenBizCompanys(Context ctx, String rootCompanyId) throws BOSException, EASBizException, SQLException {
        return FARptUtil.getChildrenBizCompanys(ctx, rootCompanyId, null, null);
    }

    public static CompanyOrgUnitCollection getChildrenBizCompanys(Context ctx, String rootCompanyId, String accountTableID, String periodTypeID) throws BOSException, EASBizException, SQLException {
        CompanyOrgUnitInfo currCompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(rootCompanyId));
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT company.FID AS COMPANYID ,company.FName_l2 AS COMPANYNAME, company.FNumber AS COMPANYNUMBER, company.FParentID AS ParentID");
        sql.append(" FROM T_BD_SystemStatusCtrol ssc");
        sql.append(" INNER JOIN T_BD_Period currPeriod ON ssc.FCurrentPeriodID = currPeriod.FID");
        sql.append(" INNER JOIN T_BD_Period startPeriod ON ssc.FStartPeriodID = startPeriod.FID");
        sql.append(" INNER JOIN T_ORG_Company company ON ssc.FCompanyID = company.FID");
        sql.append(" INNER JOIN T_BD_SystemStatus ss ON ss.FID = ssc.FSystemStatusID");
        sql.append(" WHERE ss.FName = ").append(14);
        sql.append(" AND (company.FLongNumber != '").append(currCompany.getLongNumber()).append("'");
        sql.append(" AND company.FLongNumber LIKE '").append(currCompany.getLongNumber()).append("!%')");
        if (!StringUtils.isEmpty((String)accountTableID)) {
            sql.append(" AND company.FAccountTableID = '").append(accountTableID).append("'");
        }
        if (!StringUtils.isEmpty((String)periodTypeID)) {
            sql.append(" AND currPeriod.FTypeID = '").append(periodTypeID).append("'");
        }
        sql.append(" AND company.fid in (").append(FARptUtil.getOrgRange(ctx)).append(") ");
        sql.append(" ORDER BY company.FLongNumber");
        CompanyOrgUnitCollection coll = new CompanyOrgUnitCollection();
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)FaLocalUtils.transformLocal((Context)ctx, (String)sql.toString()));
            while (rs.next()) {
                CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
                company.setId(BOSUuid.read((String)rs.getString("COMPANYID")));
                company.setName(rs.getString("COMPANYNAME"));
                company.setNumber(rs.getString("COMPANYNUMBER"));
                String parentID = rs.getString("ParentID");
                if (parentID != null) {
                    CompanyOrgUnitInfo parent = new CompanyOrgUnitInfo();
                    parent.setId(BOSUuid.read((String)parentID));
                    company.setParent(parent);
                }
                coll.add(company);
            }
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        return coll;
    }

    private static String getOrgRange(Context ctx) throws EASBizException, BOSException {
        StringBuffer orgIds = new StringBuffer();
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
        List orgIdList = OrgRangeFactory.getLocalInstance((Context)ctx).getOrgIdByUserAndType((IObjectPK)new ObjectUuidPK(user.getId()), OrgRangeType.BIZ_ORG_TYPE);
        for (String orgId : orgIdList) {
            orgIds.append("'").append(orgId).append("'");
            orgIds.append(",");
        }
        if (orgIds.length() > 1) {
            orgIds.deleteCharAt(orgIds.length() - 1);
        }
        return orgIds.toString();
    }

    public PeriodTypeCollection getPeriodTypeCollection(Context ctx) throws ReportBizException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        return PeriodTypeFactory.getLocalInstance((Context)ctx).getPeriodTypeCollection(view);
    }

    private static String getPeriodRangeSQL(Set companyIdSet, String periodTypeId) {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT TP.FPeriodYear, Min(TP.FPeriodNumber) MinNumber, Max(TP.FPeriodNumber) MaxNumber ");
        sql.append(" FROM T_BD_Period TP,(SELECT Min(TPS.FNumber) FBeginDate,Max(TPC.FNumber) FEndDate ");
        sql.append(" FROM T_BD_SystemStatusCtrol TSSC ");
        sql.append(" INNER JOIN T_BD_SystemStatus tsst ON TSSC.FSystemStatusID=tsst.fid and TSST.fname=").append(14);
        sql.append(" INNER JOIN T_BD_Period TPS\tON TSSC.FStartPeriodID = TPS.FID \t\t\t\t\t\t\t\r\n");
        sql.append(" INNER JOIN T_BD_Period TPC\tON TSSC.FCurrentPeriodID = TPC.FID\t\t\t\t\t\t\t\r\n");
        sql.append(" WHERE TSSC.FCompanyID in (");
        Iterator it = companyIdSet.iterator();
        sql.append("'").append(it.next()).append("'");
        while (it.hasNext()) {
            sql.append(",'").append(it.next()).append("'");
        }
        sql.append(")");
        if (periodTypeId != null) {
            sql.append(" AND TPS.FTypeID = ? AND TPC.FTypeID = ? ");
        }
        sql.append(" ) TPRange ");
        sql.append(" WHERE TP.FNumber >= TPRange.FBeginDate");
        sql.append(" AND TP.FNumber <= TPRange.FEndDate ");
        if (periodTypeId != null) {
            sql.append(" AND TP.FTypeID = ? ");
        }
        sql.append(" GROUP BY TP.FPeriodYear ");
        sql.append(" ORDER BY TP.FPeriodYear ");
        return sql.toString();
    }

    public static Map getPeriodRange(Context ctx, Set companyIdSet, String periodTypeId) throws BOSException, EASBizException {
        HashMap<Integer, int[]> map = new HashMap<Integer, int[]>();
        String sql = FARptUtil.getPeriodRangeSQL(companyIdSet, periodTypeId);
        IRowSet rs = periodTypeId != null ? DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{periodTypeId, periodTypeId, periodTypeId}) : DbUtil.executeQuery((Context)ctx, (String)sql);
        int[] yearRange = new int[]{-1, -1};
        int maxYear = -1;
        int maxPeriod = -1;
        int minYear = -1;
        int minPeriod = -1;
        try {
            while (rs.next()) {
                int year = rs.getInt("FPeriodYear");
                yearRange[0] = yearRange[0] == -1 ? year : yearRange[0];
                yearRange[1] = year;
                int[] periodRange = new int[]{rs.getInt("MinNumber"), rs.getInt("MaxNumber")};
                if (periodRange[0] <= 0 || periodRange[1] <= 0) {
                    throw new ReportException(ReportException.PERIOD_TYPE_ERROR);
                }
                map.put(new Integer(year), periodRange);
                if (year > maxYear) {
                    maxYear = year;
                    maxPeriod = periodRange[1];
                }
                if (year >= minYear && minYear != -1) continue;
                minYear = year;
                minPeriod = periodRange[0];
            }
        }
        catch (SQLException e) {
            throw new BOSException("SQL ERROR!", (Throwable)e);
        }
        if (yearRange[0] <= 0 || yearRange[1] <= 0 || map.size() <= 0) {
            throw new ReportException(ReportException.PERIOD_TYPE_ERROR);
        }
        HashMap<String, Object> allMap = new HashMap<String, Object>();
        allMap.put("usedPeriod", map);
        allMap.put("currentPeriod", new int[]{maxYear, maxPeriod});
        return allMap;
    }
}

