/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.books.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.ormapping.SQLAccessException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.MeasureUnitGroupInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.BalanceDirectionEnum;
import com.kingdee.eas.basedata.master.account.IAccountView;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.GeneralAsstActTypeGroupInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.books.AccountBooksException;
import com.kingdee.eas.fi.books.AcountSchemeInfo;
import com.kingdee.eas.fi.books.BalanceAdjustCollection;
import com.kingdee.eas.fi.books.BalanceAdjustInfo;
import com.kingdee.eas.fi.books.BalanceEnum;
import com.kingdee.eas.fi.books.app.AbstractBalanceAdjustControllerBean;
import com.kingdee.eas.fi.gl.AcctCussentInfo;
import com.kingdee.eas.fi.gl.GLException;
import com.kingdee.eas.fi.gl.GLFlagFactory;
import com.kingdee.eas.fi.gl.GLGeneralFacadeFactory;
import com.kingdee.eas.fi.gl.IGLFlag;
import com.kingdee.eas.fi.gl.IGLGeneralFacade;
import com.kingdee.eas.fi.gl.VoucherAssistRecordInfo;
import com.kingdee.eas.fi.gl.app.InitHelp;
import com.kingdee.eas.fi.gl.common.SQLUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class BalanceAdjustControllerBean
extends AbstractBalanceAdjustControllerBean {
    private static final long serialVersionUID = -1037942274634582746L;
    private static final String RESOURCE_PATH = "com.kingdee.eas.fi.book.AccountBookResource";

    @Override
    protected ArrayList _getInitData(Context ctx, HashMap otherCtx) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)otherCtx.get("COMPANY");
        if (company == null) {
            throw new GLException(GLException.NOCOMPANY);
        }
        ArrayList<Object> result = new ArrayList<Object>();
        ICurrency curCtrl = CurrencyFactory.getLocalInstance((Context)ctx);
        CurrencyCollection curCol = curCtrl.getCurrencyCollection(false);
        if (curCol.size() == 0) {
            throw new GLException(GLException.NOCURRENCY);
        }
        Map hmParamValue = InitHelp.getInitParam(ctx, company);
        result.add(hmParamValue.get("GL_002"));
        result.add(hmParamValue.get("GL_008"));
        result.add(hmParamValue.get("G001"));
        result.add(curCol);
        PeriodInfo[] periods = InitHelp.getPeriods(ctx, company);
        result.add(periods[0]);
        try {
            result.add(this.getAllAssistAccountBySql(ctx, otherCtx));
        }
        catch (SQLException e) {
            new BOSException((Throwable)e);
        }
        result.add(hmParamValue.get("G010"));
        boolean isInitClosed = this.isInitClosed(ctx, company.getId().toString());
        result.add(isInitClosed);
        result.add(this.getAllAstInitClosed(ctx, otherCtx));
        result.add(this.getAllCussentInitClosed(ctx, otherCtx));
        try {
            int allAccount = this.getAllCount(ctx, otherCtx);
            ArrayList allClosed = this.getAllCloseAccount(ctx, otherCtx);
            boolean isAllClosed = allAccount == allClosed.size();
            result.add(isAllClosed);
        }
        catch (SQLException e) {
            new BOSException((Throwable)e);
        }
        boolean isCussentAllClosed = this.isCussentAllClosed(ctx, otherCtx);
        result.add(isCussentAllClosed);
        result.add(Boolean.valueOf(hmParamValue.get("GL_028").toString()));
        return result;
    }

    private int getAllCount(Context ctx, HashMap otherCtx) throws BOSException, SQLException {
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)otherCtx.get("COMPANY");
        String accounttable = otherCtx.get("ACCOUNTTABLEID").toString();
        String sql = "select count(*) as count from t_BD_AccountView account where account.Fcompanyid=? and account.faccounttableid=?   and account.fcaa is not null and account.fisleaf=1 ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{company.getId().toString(), accounttable});
        if (rs != null && rs.next()) {
            return rs.getInt("count");
        }
        return 0;
    }

    private ArrayList getAllCloseAccount(Context ctx, HashMap otherCtx) throws BOSException, SQLException {
        String orgUnitId = ((CompanyOrgUnitInfo)otherCtx.get("COMPANY")).getId().toString();
        String accounttable = otherCtx.get("ACCOUNTTABLEID").toString();
        String sql = "select fkey from t_gl_flag flag,t_BD_AccountView acc where flag.forgunitid=?  and flag.fname='astinit' and flag.fvalue='true' and acc.faccounttableid=? and acc.fid=flag.fkey and acc.fcaa is not null and acc.fisleaf=1 and acc.Fcompanyid=?  ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{orgUnitId, accounttable, orgUnitId});
        ArrayList<String> result = new ArrayList<String>();
        if (rs != null) {
            while (rs.next()) {
                result.add(rs.getString("fkey"));
            }
        }
        return result;
    }

    private boolean isCussentAllClosed(Context ctx, HashMap otherCtx) throws BOSException, EASBizException {
        ResultSet rs;
        PreparedStatement ps;
        Connection con;
        block4: {
            boolean bl;
            String orgUnitId = ((CompanyOrgUnitInfo)otherCtx.get("COMPANY")).getId().toString();
            String accounttableid = (String)otherCtx.get("ACCOUNTTABLEID");
            String sql = "select top 1 account.fid from t_BD_AccountView account  where account.fid not in (select fkey from t_gl_flag flag where flag.forgunitid=? and flag.fname=? and flag.fvalue=?) and account.Fcompanyid=? and faccountTableid=? and account.fac=1 and account.fcaa is not null and account.fisleaf=1";
            con = null;
            ps = null;
            rs = null;
            try {
                con = this.getConnection(ctx);
                ps = con.prepareStatement(sql);
                int index = 1;
                ps.setString(index++, orgUnitId);
                ps.setString(index++, "cussentinit");
                ps.setString(index++, "true");
                ps.setString(index++, orgUnitId);
                ps.setString(index++, accounttableid);
                rs = ps.executeQuery();
                if (!rs.next()) break block4;
                bl = false;
            }
            catch (SQLException e) {
                try {
                    throw new SQLAccessException(e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, ps, (Connection)con);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)con);
            return bl;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)con);
        return true;
    }

    @Override
    protected HashMap _getBeginBalanceByAcct(Context ctx, HashMap otherCtx) throws BOSException, EASBizException {
        int type = Integer.parseInt(otherCtx.get("type").toString());
        String companyId = ((CompanyOrgUnitInfo)otherCtx.get("COMPANY")).getId().toString();
        String currencyId = ((CurrencyInfo)otherCtx.get("curcurrency")).getId().toString();
        String cuid = otherCtx.get("CUID").toString();
        String acctTableId = otherCtx.get("ACCOUNTTABLEID").toString();
        HashMap beginBalanceMap = null;
        switch (type) {
            case 1: {
                beginBalanceMap = this.getAccountBeginBalance(ctx, type, companyId, currencyId);
                break;
            }
            case 2: {
                AsstAccountInfo asstAccount = (AsstAccountInfo)otherCtx.get("asstaccount");
                beginBalanceMap = this.getAsstBeginBalance(ctx, type, companyId, currencyId, asstAccount, cuid, acctTableId);
                break;
            }
            case 3: {
                AsstAccountInfo asstAccount = (AsstAccountInfo)otherCtx.get("asstaccount");
                beginBalanceMap = this.getCussentBeginBalance(ctx, type, companyId, currencyId, asstAccount, cuid, acctTableId);
                break;
            }
        }
        return beginBalanceMap;
    }

    private HashMap getAccountBeginBalance(Context ctx, int type, String companyId, String currencyId) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select bal.faccountid,bal.FBeginBalanceFor*acct.FDC as FBeginBalanceFor,bal.FBeginBalanceLocal*acct.FDC as FBeginBalanceLocal, \r\n").append("   bal.FBeginBalanceRpt*acct.FDC as FBeginBalanceRpt,bal.FBeginQty,bal.FYearDebitFor,bal.FYearCreditFor ,bal.FYearDebitLocal ,bal.FYearCreditLocal ,bal.FYearDebitRpt ,bal.FYearCreditRpt,bal.FYearDebitQty,bal.FYearCreditQty  from t_gl_initaccountbalance bal  \r\n").append("    inner join t_bd_accountview acct on acct.fid=bal.faccountid    \r\n").append("         where  bal.forgunitid=? and bal.fcurrencyid=?                \r\n");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{companyId, currencyId});
        HashMap<String, BalanceAdjustInfo> beginBalanceMap = new HashMap<String, BalanceAdjustInfo>();
        try {
            while (rowSet.next()) {
                BalanceAdjustInfo beginBalance = new BalanceAdjustInfo();
                beginBalance.setBeginFor(rowSet.getBigDecimal("FBeginBalanceFor") == null ? InitHelp.zero : rowSet.getBigDecimal("FBeginBalanceFor"));
                beginBalance.setBeginLocal(rowSet.getBigDecimal("FBeginBalanceLocal") == null ? InitHelp.zero : rowSet.getBigDecimal("FBeginBalanceLocal"));
                beginBalance.setBeginRpt(rowSet.getBigDecimal("FBeginBalanceRpt") == null ? InitHelp.zero : rowSet.getBigDecimal("FBeginBalanceRpt"));
                beginBalance.setBeginQty(rowSet.getBigDecimal("FBeginQty") == null ? InitHelp.zero : rowSet.getBigDecimal("FBeginQty"));
                beginBalance.setYearBeginDebitFor(rowSet.getBigDecimal("FYearDebitFor") == null ? InitHelp.zero : rowSet.getBigDecimal("FYearDebitFor"));
                beginBalance.setYearBeginDebitLocal(rowSet.getBigDecimal("FYearDebitLocal") == null ? InitHelp.zero : rowSet.getBigDecimal("FYearDebitLocal"));
                beginBalance.setYearBeginDebitRpt(rowSet.getBigDecimal("FYearDebitRpt") == null ? InitHelp.zero : rowSet.getBigDecimal("FYearDebitRpt"));
                beginBalance.setYearBeginDebitQty(rowSet.getBigDecimal("FYearDebitQty") == null ? InitHelp.zero : rowSet.getBigDecimal("FYearDebitQty"));
                beginBalance.setYearBeginCreditFor(rowSet.getBigDecimal("FYearCreditFor") == null ? InitHelp.zero : rowSet.getBigDecimal("FYearCreditFor"));
                beginBalance.setYearBeginCreditLocal(rowSet.getBigDecimal("FYearCreditLocal") == null ? InitHelp.zero : rowSet.getBigDecimal("FYearCreditLocal"));
                beginBalance.setYearBeginCreditRpt(rowSet.getBigDecimal("FYearCreditRpt") == null ? InitHelp.zero : rowSet.getBigDecimal("FYearCreditRpt"));
                beginBalance.setYearBeginCreditQty(rowSet.getBigDecimal("FYearCreditQty") == null ? InitHelp.zero : rowSet.getBigDecimal("FYearCreditQty"));
                beginBalanceMap.put(rowSet.getString("faccountid"), beginBalance);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return beginBalanceMap;
    }

    private HashMap getAsstBeginBalance(Context ctx, int type, String companyId, String currencyId, AsstAccountInfo asstAccount, String cuid, String acctTableId) throws BOSException {
        IObjectCollection coll = this.getAccountFromAsstAccount(ctx, asstAccount.getId().toString(), cuid, acctTableId, null);
        HashMap<String, BalanceAdjustInfo> beginBalanceMap = new HashMap<String, BalanceAdjustInfo>();
        for (int i = 0; i < coll.size(); ++i) {
            AccountViewInfo account = (AccountViewInfo)coll.getObject(i);
            StringBuffer sql = new StringBuffer();
            sql.append(" select bal.FBeginBalanceFor*acct.FDC as FBeginBalanceFor,bal.FBeginBalanceLocal*acct.FDC as FBeginBalanceLocal,  \r\n").append("  bal.FBeginBalanceRpt*acct.FDC as FBeginBalanceRpt,bal.FBeginQty,bal.FAssistGrpID,bal.FYearDebitFor,bal.FYearCreditFor ,bal.FYearDebitLocal ,bal.FYearCreditLocal ,bal.FYearDebitRpt ,bal.FYearCreditRpt,bal.FYearDebitQty,bal.FYearCreditQty from T_GL_InitAssistBalance bal  \r\n").append("    inner join t_bd_accountview acct on acct.fid=bal.faccountid    \r\n").append("         where  bal.forgunitid=? and bal.faccountid=? and  bal.fcurrencyid=?               \r\n");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{companyId, account.getId().toString(), currencyId});
            try {
                while (rowSet.next()) {
                    BalanceAdjustInfo beginBalance = new BalanceAdjustInfo();
                    beginBalance.setBeginFor(rowSet.getBigDecimal("FBeginBalanceFor") == null ? InitHelp.zero : rowSet.getBigDecimal("FBeginBalanceFor"));
                    beginBalance.setBeginLocal(rowSet.getBigDecimal("FBeginBalanceLocal") == null ? InitHelp.zero : rowSet.getBigDecimal("FBeginBalanceLocal"));
                    beginBalance.setBeginRpt(rowSet.getBigDecimal("FBeginBalanceRpt") == null ? InitHelp.zero : rowSet.getBigDecimal("FBeginBalanceRpt"));
                    beginBalance.setBeginQty(rowSet.getBigDecimal("FBeginQty") == null ? InitHelp.zero : rowSet.getBigDecimal("FBeginQty"));
                    beginBalance.setYearBeginDebitFor(rowSet.getBigDecimal("FYearDebitFor") == null ? InitHelp.zero : rowSet.getBigDecimal("FYearDebitFor"));
                    beginBalance.setYearBeginDebitLocal(rowSet.getBigDecimal("FYearDebitLocal") == null ? InitHelp.zero : rowSet.getBigDecimal("FYearDebitLocal"));
                    beginBalance.setYearBeginDebitRpt(rowSet.getBigDecimal("FYearDebitRpt") == null ? InitHelp.zero : rowSet.getBigDecimal("FYearDebitRpt"));
                    beginBalance.setYearBeginDebitQty(rowSet.getBigDecimal("FYearDebitQty") == null ? InitHelp.zero : rowSet.getBigDecimal("FYearDebitQty"));
                    beginBalance.setYearBeginCreditFor(rowSet.getBigDecimal("FYearCreditFor") == null ? InitHelp.zero : rowSet.getBigDecimal("FYearCreditFor"));
                    beginBalance.setYearBeginCreditLocal(rowSet.getBigDecimal("FYearCreditLocal") == null ? InitHelp.zero : rowSet.getBigDecimal("FYearCreditLocal"));
                    beginBalance.setYearBeginCreditRpt(rowSet.getBigDecimal("FYearCreditRpt") == null ? InitHelp.zero : rowSet.getBigDecimal("FYearCreditRpt"));
                    beginBalance.setYearBeginCreditQty(rowSet.getBigDecimal("FYearCreditQty") == null ? InitHelp.zero : rowSet.getBigDecimal("FYearCreditQty"));
                    String key = account.getId().toString() + "-" + rowSet.getString("FAssistGrpID");
                    beginBalanceMap.put(key, beginBalance);
                }
                continue;
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        return beginBalanceMap;
    }

    private HashMap getCussentBeginBalance(Context ctx, int type, String companyId, String currencyId, AsstAccountInfo asstAccount, String cuid, String acctTableId) throws BOSException {
        FilterInfo filter = new FilterInfo();
        String mask = "";
        filter.getFilterItems().add(new FilterItemInfo("AC", (Object)new Integer(1)));
        mask = mask + "#0";
        filter.setMaskString(mask);
        IObjectCollection coll = this.getAccountFromAsstAccount(ctx, asstAccount.getId().toString(), cuid, acctTableId, filter);
        HashMap<String, BalanceAdjustInfo> beginBalanceMap = new HashMap<String, BalanceAdjustInfo>();
        for (int i = 0; i < coll.size(); ++i) {
            AccountViewInfo account = (AccountViewInfo)coll.getObject(i);
            StringBuffer sql = new StringBuffer();
            sql.append(" select vch.fid as vchid,vch.foriginalAmount*acct.FDC as foriginalAmount, vch.flocalAmount*acct.FDC as flocalAmount, \r\n").append("  vch.freportingAmount*acct.FDC as freportingAmount,vch.FQuantity ,vch.FAssGrpID,vch.fbizNumber   from T_GL_AcctCussent bal  \r\n").append("      inner join T_GL_VoucherAssistRecord vch on vch.fid = bal.FVchAssistRecordID                   \r\n").append("      inner join t_bd_accountview acct on acct.fid=bal.faccountid    \r\n").append("         where  bal.fcompanyid=? and bal.faccountid=? and  bal.fcurrencyid=? and bal.fisinit=? and vch.FAssGrpID IS NOT NULL             \r\n");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{companyId, account.getId().toString(), currencyId, new Integer(1)});
            try {
                while (rowSet.next()) {
                    BalanceAdjustInfo beginBalance = new BalanceAdjustInfo();
                    beginBalance.setBeginFor(rowSet.getBigDecimal("foriginalAmount") == null ? InitHelp.zero : rowSet.getBigDecimal("foriginalAmount"));
                    beginBalance.setBeginLocal(rowSet.getBigDecimal("flocalAmount") == null ? InitHelp.zero : rowSet.getBigDecimal("flocalAmount"));
                    beginBalance.setBeginRpt(rowSet.getBigDecimal("freportingAmount") == null ? InitHelp.zero : rowSet.getBigDecimal("freportingAmount"));
                    beginBalance.setBeginQty(rowSet.getBigDecimal("FQuantity") == null ? InitHelp.zero : rowSet.getBigDecimal("FQuantity"));
                    beginBalance.put("vchassistrecordid", rowSet.getString("vchid"));
                    String bizNumber = rowSet.getString("fbizNumber");
                    String key = account.getId().toString() + "-" + rowSet.getString("FAssGrpID");
                    if (bizNumber != null) {
                        key = key + "-" + bizNumber;
                    }
                    beginBalanceMap.put(key, beginBalance);
                }
                continue;
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        return beginBalanceMap;
    }

    private IObjectCollection getAccountFromAsstAccount(Context ctx, String asstAccountId, String cuid, String accounttableid, FilterInfo filter) throws BOSException {
        int index;
        String mask;
        IAccountView av = AccountViewFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        if (filter == null) {
            filter = new FilterInfo();
        }
        if ((mask = filter.getMaskString()) == null) {
            mask = "";
        }
        if ((index = filter.getFilterItems().size()) > 0) {
            mask = mask + " and ";
        }
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)cuid));
        mask = mask + "#" + index++;
        if (asstAccountId != null) {
            filter.getFilterItems().add(new FilterItemInfo("CAA.id", (Object)asstAccountId));
            mask = mask + " and #" + index++;
        } else {
            filter.getFilterItems().add(new FilterItemInfo("CAA.id", null, CompareType.NOTEQUALS));
            mask = mask + " and #" + index++;
        }
        filter.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)new Integer(1)));
        mask = mask + " and #" + index++;
        filter.getFilterItems().add(new FilterItemInfo("accountTableID.id", (Object)accounttableid));
        mask = mask + " and #" + index++;
        filter.setMaskString(mask);
        view.setFilter(filter);
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("longName"));
        sic.add(new SelectorItemInfo("DC"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("isQty"));
        sic.add(new SelectorItemInfo("isLeaf"));
        sic.add(new SelectorItemInfo("isBank"));
        sic.add(new SelectorItemInfo("accountTypeID.property"));
        sic.add(new SelectorItemInfo("accountTypeID.id"));
        sic.add(new SelectorItemInfo("measureUnitID.id"));
        sic.add(new SelectorItemInfo("measureUnitID.name"));
        sic.add(new SelectorItemInfo("measureUnitGroupID.id"));
        sic.add(new SelectorItemInfo("measureUnitGroupID.name"));
        sic.add(new SelectorItemInfo("measureUnitGroupID.defaultUnit.id"));
        sic.add(new SelectorItemInfo("measureUnitGroupID.defaultUnit.name"));
        AccountViewCollection col = av.getAccountViewCollection(view);
        return col;
    }

    @Override
    protected void _saveAdjustBalance(Context ctx, BalanceAdjustCollection adjustBalances, HashMap otherCtx) throws BOSException, EASBizException {
        String acctTableId = otherCtx.get("ACCOUNTTABLEID").toString();
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)otherCtx.get("COMPANY");
        String companyID = company.getId().toString();
        boolean isInitClosed = this.isInitClosed(ctx, company.getId().toString());
        boolean isAllClosed = false;
        try {
            int allAccount = this.getAllCount(ctx, otherCtx);
            ArrayList allClosed = this.getAllCloseAccount(ctx, otherCtx);
            isAllClosed = allAccount == allClosed.size();
        }
        catch (SQLException e) {
            new BOSException((Throwable)e);
        }
        boolean isCussentAllClosed = this.isCussentAllClosed(ctx, otherCtx);
        for (int i = 0; i < adjustBalances.size(); ++i) {
            CurrencyInfo generalRptCurrency;
            CurrencyInfo generalLocalCurrency;
            BalanceAdjustInfo balance = adjustBalances.get(i);
            if (balance.getType() == BalanceEnum.ACCOUNTBALANCE && isInitClosed) {
                throw new AccountBooksException(AccountBooksException.ACCOUNTCLOSED);
            }
            if (balance.getType() == BalanceEnum.ASSISTBALANCE && isAllClosed) {
                throw new AccountBooksException(AccountBooksException.ASSTACCTCLOSED);
            }
            if (balance.getType() == BalanceEnum.ACCTCUSSENT && isCussentAllClosed) {
                throw new AccountBooksException(AccountBooksException.CUSSENTCLOSED);
            }
            BalanceAdjustInfo localbalance = (BalanceAdjustInfo)balance.clone();
            BalanceAdjustInfo rptbalance = (BalanceAdjustInfo)balance.clone();
            if (balance.get("persist_status").equals("new")) {
                this.rewriteBeginBalance(ctx, balance, company.getId().toString(), acctTableId);
                super.addnew(ctx, balance);
                if (balance.getType() == BalanceEnum.ACCTCUSSENT) continue;
                generalLocalCurrency = new CurrencyInfo();
                generalLocalCurrency.setId(CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID);
                localbalance.setCurrency(generalLocalCurrency);
                this.rewriteGeneralBeginBalance(ctx, localbalance, company.getId().toString(), acctTableId);
                generalRptCurrency = new CurrencyInfo();
                generalRptCurrency.setId(CurrencyInfo.GENERAL_REPORT_CURRENCY_ID);
                rptbalance.setCurrency(generalRptCurrency);
                this.rewriteGeneralBeginBalance(ctx, rptbalance, company.getId().toString(), acctTableId);
                continue;
            }
            if (balance.get("persist_status").equals("dirty")) {
                super.update(ctx, (IObjectPK)new ObjectUuidPK(balance.getId()), balance);
                continue;
            }
            if (!balance.get("persist_status").equals("deleted")) continue;
            super.delete(ctx, new IObjectPK[]{new ObjectUuidPK(balance.getId())});
            this.rewriteBeginBalance(ctx, balance, companyID, acctTableId);
            if (balance.getType() == BalanceEnum.ACCTCUSSENT) continue;
            generalLocalCurrency = new CurrencyInfo();
            generalLocalCurrency.setId(CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID);
            balance.setCurrency(generalLocalCurrency);
            this.rewriteGeneralBeginBalance(ctx, balance, companyID, acctTableId);
            generalRptCurrency = new CurrencyInfo();
            generalRptCurrency.setId(CurrencyInfo.GENERAL_REPORT_CURRENCY_ID);
            balance.setCurrency(generalRptCurrency);
            this.rewriteGeneralBeginBalance(ctx, balance, companyID, acctTableId);
        }
        this.saveGeneral(ctx, (IObjectCollection)adjustBalances, otherCtx);
    }

    private void rewriteBeginBalance(Context ctx, BalanceAdjustInfo balance, String cuid, String acctTableId) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        Object[] param = null;
        IRowSet rs = null;
        BigDecimal dc = new BigDecimal(balance.getAccount().getDC().getValue() + "");
        BigDecimal amtFor = balance.getAdjustFor().multiply(dc);
        BigDecimal amtLocal = balance.getAdjustLocal().multiply(dc);
        BigDecimal amtRpt = balance.getAdjustRpt().multiply(dc);
        BigDecimal qty = balance.getAdjustQty().multiply(dc);
        BigDecimal amtYearDebitFor = balance.getYearAdjustDebitFor();
        BigDecimal amtYearDebitLocal = balance.getYearAdjustDebitLocal();
        BigDecimal amtYearDebitRpt = balance.getYearAdjustDebitRpt();
        BigDecimal debitYearQty = balance.getYearAdjustDebitQty();
        BigDecimal amtYearCreditFor = balance.getYearAdjustCreditFor();
        BigDecimal amtYearCreditLocal = balance.getYearAdjustCreditLocal();
        BigDecimal amtYearCreditRpt = balance.getYearAdjustCreditRpt();
        BigDecimal creditYearQty = balance.getYearAdjustCreditQty();
        BigDecimal amtFor2 = balance.getAdjustFor().multiply(dc);
        BigDecimal amtLocal2 = balance.getAdjustLocal().multiply(dc);
        BigDecimal amtRpt2 = balance.getAdjustRpt().multiply(dc);
        BigDecimal qty2 = balance.getAdjustQty().multiply(dc);
        if (balance.get("persist_status").equals("deleted")) {
            amtFor = amtFor.negate();
            amtLocal = amtLocal.negate();
            amtRpt = amtRpt.negate();
            qty = qty.negate();
            amtYearDebitFor = amtYearDebitFor.negate();
            amtYearDebitLocal = amtYearDebitLocal.negate();
            amtYearDebitRpt = amtYearDebitRpt.negate();
            debitYearQty = debitYearQty.negate();
            amtYearCreditFor = amtYearCreditFor.negate();
            amtYearCreditLocal = amtYearCreditLocal.negate();
            amtYearCreditRpt = amtYearCreditRpt.negate();
            creditYearQty = creditYearQty.negate();
        }
        StringBuffer existSql = new StringBuffer();
        try {
            if (balance.getType() == BalanceEnum.ACCOUNTBALANCE) {
                this.dealAccountBalance(ctx, balance, cuid, acctTableId);
            } else if (balance.getType() == BalanceEnum.ASSISTBALANCE) {
                this.dealAssistBalance(ctx, balance, cuid, acctTableId);
            } else if (balance.getType() == BalanceEnum.ACCTCUSSENT) {
                String amtForStr = amtFor.toString();
                String amtLocalStr = amtLocal.toString();
                String amtRptStr = amtRpt.toString();
                String qtyStr = qty.toString();
                if (amtFor.compareTo(InitHelp.zero) == 0) {
                    amtForStr = "0";
                }
                if (amtLocal.compareTo(InitHelp.zero) == 0) {
                    amtLocalStr = "0";
                }
                if (amtRpt.compareTo(InitHelp.zero) == 0) {
                    amtRptStr = "0";
                }
                if (qty.compareTo(InitHelp.zero) == 0) {
                    qtyStr = "0";
                }
                existSql.append(" select vch.fid,vch.foriginalAmount,vch.flocalAmount,vch.freportingAmount,vch.FQuantity   from T_GL_AcctCussent bal  \r\n").append("        inner join T_GL_VoucherAssistRecord vch on vch.fid = bal.FVchAssistRecordID                   \r\n").append("         where  bal.fcompanyid=? and  bal.fcurrencyid=? and bal.faccountid=?  and bal.fisinit=? and vch.FAssGrpID =?             \r\n");
                param = new Object[]{balance.getOrgUnit().getId().toString(), balance.getCurrency().getId().toString(), balance.getAccount().getId().toString(), new Integer(1), balance.getAssistGrp().getId().toString()};
                if (balance.getBizNumber() != null) {
                    existSql.append(" and vch.fbiznumber=? ");
                    param = new Object[]{balance.getOrgUnit().getId().toString(), balance.getCurrency().getId().toString(), balance.getAccount().getId().toString(), new Integer(1), balance.getAssistGrp().getId().toString(), balance.getBizNumber()};
                }
                if ((rs = DbUtil.executeQuery((Context)ctx, (String)existSql.toString(), (Object[])param)).next()) {
                    sql = new StringBuffer();
                    String vchId = rs.getString("fid");
                    BigDecimal oldAmtFor = rs.getBigDecimal("foriginalAmount") == null ? InitHelp.zero : rs.getBigDecimal("foriginalAmount");
                    BigDecimal oldAmtLocal = rs.getBigDecimal("flocalAmount") == null ? InitHelp.zero : rs.getBigDecimal("flocalAmount");
                    BigDecimal oldAmtRpt = rs.getBigDecimal("freportingAmount") == null ? InitHelp.zero : rs.getBigDecimal("freportingAmount");
                    BigDecimal oldQty = rs.getBigDecimal("FQuantity") == null ? InitHelp.zero : rs.getBigDecimal("FQuantity");
                    amtFor = oldAmtFor.add(amtFor);
                    amtLocal = oldAmtLocal.add(amtLocal);
                    amtRpt = oldAmtRpt.add(amtRpt);
                    qty = oldQty.add(qty);
                    sql.append(" update T_GL_VoucherAssistRecord set foriginalAmount=?, flocalAmount=?, freportingAmount=?,FQuantity=?  where fid=?   \r\n");
                    param = new Object[]{amtFor, amtLocal, amtRpt, qty, vchId};
                    DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])param);
                    sql = new StringBuffer();
                    sql.append(" update T_GL_AcctCussent set FUnVerifiedAmtFor=FUnVerifiedAmtFor").append(amtFor2.compareTo(new BigDecimal("0")) < 0 ? " " + amtFor2 : "+" + amtForStr);
                    sql.append(",FUnVerifiedAmtLocal=FUnVerifiedAmtLocal").append(amtLocal2.compareTo(new BigDecimal("0")) < 0 ? " " + amtLocal2 : "+" + amtLocalStr);
                    sql.append(",FUnVerifiedAmtRpt=FUnVerifiedAmtRpt").append(amtRpt2.compareTo(new BigDecimal("0")) < 0 ? " " + amtRpt2 : "+" + amtRptStr);
                    sql.append(",FUnVerifiedQty=FUnVerifiedQty").append(qty2.compareTo(new BigDecimal("0")) < 0 ? " " + qty2 : "+" + qtyStr);
                    sql.append(",FUnVerifiedStdQty=FUnVerifiedStdQty").append(qty2.compareTo(new BigDecimal("0")) < 0 ? " " + qty2 : "+" + qtyStr);
                    sql.append(",FUnHoldedAmtFor=FUnHoldedAmtFor").append(amtFor2.compareTo(new BigDecimal("0")) < 0 ? " " + amtFor2 : "+" + amtForStr);
                    sql.append(",FUnHoldedAmtLocal=FUnHoldedAmtLocal").append(amtLocal2.compareTo(new BigDecimal("0")) < 0 ? " " + amtLocal2 : "+" + amtLocalStr);
                    sql.append(",FUnHoldedAmtRpt=FUnHoldedAmtRpt").append(amtRpt2.compareTo(new BigDecimal("0")) < 0 ? " " + amtRpt2 : "+" + amtRptStr);
                    sql.append(",funHoldedQty=funHoldedQty").append(qty2.compareTo(new BigDecimal("0")) < 0 ? " " + qty2 : "+" + qtyStr);
                    sql.append(",FUnHoldedStdQty=FUnHoldedStdQty").append(qty2.compareTo(new BigDecimal("0")) < 0 ? " " + qty2 : "+" + qtyStr);
                    if (balance.getBizNumber() != null) {
                        sql.append("    where  fcompanyid=? and  fcurrencyid=? and faccountid=?  and fisinit=? and FVchAssistRecordID in (select fid from T_GL_VoucherAssistRecord where FAssGrpID=? and fbizNumber=? )             \r\n");
                        param = new Object[]{balance.getOrgUnit().getId().toString(), balance.getCurrency().getId().toString(), balance.getAccount().getId().toString(), new Integer(1), balance.getAssistGrp().getId().toString(), balance.getBizNumber()};
                    } else {
                        sql.append("    where  fcompanyid=? and  fcurrencyid=? and faccountid=?  and fisinit=? and FVchAssistRecordID in (select fid from T_GL_VoucherAssistRecord where FAssGrpID=? and fbizNumber is null )             \r\n");
                        param = new Object[]{balance.getOrgUnit().getId().toString(), balance.getCurrency().getId().toString(), balance.getAccount().getId().toString(), new Integer(1), balance.getAssistGrp().getId().toString()};
                    }
                    DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])param);
                } else {
                    VoucherAssistRecordInfo entry = new VoucherAssistRecordInfo();
                    BOSUuid vchId = BOSUuid.create((BOSObjectType)entry.getBOSType());
                    entry.setId(vchId);
                    entry.setAssGrp(balance.getAssistGrp());
                    entry.setSeq(0);
                    entry.setOriginalAmount(amtFor);
                    entry.setLocalAmount(amtLocal);
                    entry.setReportingAmount(amtRpt);
                    entry.setQuantity(qty);
                    entry.setBizNumber(balance.getBizNumber());
                    entry.setBizDate(new Date());
                    if (balance.getAccount().getMeasureUnitGroupID() != null && balance.getAccount().getMeasureUnitGroupID().getDefaultUnit() != null) {
                        entry.setMeasureUnit(balance.getAccount().getMeasureUnitGroupID().getDefaultUnit());
                    }
                    AcctCussentInfo acctCussent = new AcctCussentInfo();
                    BOSUuid balId = BOSUuid.create((BOSObjectType)acctCussent.getBOSType());
                    acctCussent.setId(balId);
                    acctCussent.setSeq(0);
                    acctCussent.setVchAssistRecord(entry);
                    acctCussent.setCurrency(balance.getCurrency());
                    acctCussent.setAccount(balance.getAccount());
                    acctCussent.setCompany(balance.getOrgUnit());
                    acctCussent.setIsInit(true);
                    acctCussent.setIsInitClosed(false);
                    acctCussent.setUnHoldedAmtFor(amtFor);
                    acctCussent.setUnHoldedAmtLocal(amtLocal);
                    acctCussent.setUnHoldedAmtRpt(amtRpt);
                    acctCussent.setUnVerifiedAmtFor(amtFor);
                    acctCussent.setUnVerifiedAmtLocal(amtLocal);
                    acctCussent.setUnVerifiedAmtRpt(amtRpt);
                    acctCussent.setUnVerifiedQty(qty);
                    acctCussent.setUnVerifiedStdQty(qty);
                    acctCussent.setUnHoldedQty(qty);
                    acctCussent.setUnHoldedStdQty(qty);
                    InitHelp.getAcctCussentCtrl(ctx).addnew((CoreBaseInfo)acctCussent);
                }
                this.dealAssistBalance(ctx, balance, cuid, acctTableId);
            }
        }
        catch (SQLException e) {
            new BOSException((Throwable)e);
        }
    }

    private void dealAssistBalance(Context ctx, BalanceAdjustInfo balance, String cuid, String acctTableId) throws BOSException, SQLException {
        BigDecimal dc = new BigDecimal(balance.getAccount().getDC().getValue() + "");
        BigDecimal amtFor = balance.getAdjustFor().multiply(dc);
        BigDecimal amtLocal = balance.getAdjustLocal().multiply(dc);
        BigDecimal amtRpt = balance.getAdjustRpt().multiply(dc);
        BigDecimal qty = balance.getAdjustQty().multiply(dc);
        BigDecimal amtYearDebitFor = balance.getYearAdjustDebitFor();
        BigDecimal amtYearDebitLocal = balance.getYearAdjustDebitLocal();
        BigDecimal amtYearDebitRpt = balance.getYearAdjustDebitRpt();
        BigDecimal debitYearQty = balance.getYearAdjustDebitQty();
        BigDecimal amtYearCreditFor = balance.getYearAdjustCreditFor();
        BigDecimal amtYearCreditLocal = balance.getYearAdjustCreditLocal();
        BigDecimal amtYearCreditRpt = balance.getYearAdjustCreditRpt();
        BigDecimal creditYearQty = balance.getYearAdjustCreditQty();
        BigDecimal amtFor2 = balance.getAdjustFor().multiply(dc);
        BigDecimal amtLocal2 = balance.getAdjustLocal().multiply(dc);
        BigDecimal amtRpt2 = balance.getAdjustRpt().multiply(dc);
        BigDecimal qty2 = balance.getAdjustQty().multiply(dc);
        if (balance.get("persist_status").equals("deleted")) {
            amtFor = amtFor.negate();
            amtLocal = amtLocal.negate();
            amtRpt = amtRpt.negate();
            qty = qty.negate();
            amtYearDebitFor = amtYearDebitFor.negate();
            amtYearDebitLocal = amtYearDebitLocal.negate();
            amtYearDebitRpt = amtYearDebitRpt.negate();
            debitYearQty = debitYearQty.negate();
            amtYearCreditFor = amtYearCreditFor.negate();
            amtYearCreditLocal = amtYearCreditLocal.negate();
            amtYearCreditRpt = amtYearCreditRpt.negate();
            creditYearQty = creditYearQty.negate();
        }
        StringBuffer existSql = new StringBuffer();
        existSql.append("select FYearDebitFor,FYearCreditFor ,FYearDebitLocal ,FYearCreditLocal ,FYearDebitRpt ,FYearCreditRpt,FYearDebitQty,FYearCreditQty,FBeginBalanceFor,FBeginBalanceLocal,FBeginBalanceRpt,FBeginQty from T_GL_InitAssistBalance where forgunitid=? and fcurrencyid=? and faccountid=? and fAssistGrpID=? ");
        Object[] param = new Object[]{balance.getOrgUnit().getId().toString(), balance.getCurrency().getId().toString(), balance.getAccount().getId().toString(), balance.getAssistGrp().getId().toString()};
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)existSql.toString(), (Object[])param);
        StringBuffer sql = new StringBuffer();
        if (rs.next()) {
            sql = new StringBuffer();
            BigDecimal oldAmtFor = rs.getBigDecimal("FBeginBalanceFor") == null ? InitHelp.zero : rs.getBigDecimal("FBeginBalanceFor");
            BigDecimal oldAmtLocal = rs.getBigDecimal("FBeginBalanceLocal") == null ? InitHelp.zero : rs.getBigDecimal("FBeginBalanceLocal");
            BigDecimal oldAmtRpt = rs.getBigDecimal("FBeginBalanceRpt") == null ? InitHelp.zero : rs.getBigDecimal("FBeginBalanceRpt");
            BigDecimal oldQty = rs.getBigDecimal("FBeginQty") == null ? InitHelp.zero : rs.getBigDecimal("FBeginQty");
            amtFor = oldAmtFor.add(amtFor);
            amtLocal = oldAmtLocal.add(amtLocal);
            amtRpt = oldAmtRpt.add(amtRpt);
            qty = oldQty.add(qty);
            BigDecimal oldAmtYearDebitFor = rs.getBigDecimal("FYearDebitFor") == null ? InitHelp.zero : rs.getBigDecimal("FYearDebitFor");
            BigDecimal oldAmtYearDebitLocal = rs.getBigDecimal("FYearDebitLocal") == null ? InitHelp.zero : rs.getBigDecimal("FYearDebitLocal");
            BigDecimal oldAmtYearDebitRpt = rs.getBigDecimal("FYearDebitRpt") == null ? InitHelp.zero : rs.getBigDecimal("FYearDebitRpt");
            BigDecimal oldDebitYearQty = rs.getBigDecimal("FYearDebitQty") == null ? InitHelp.zero : rs.getBigDecimal("FYearDebitQty");
            BigDecimal oldAmtYearCreditFor = rs.getBigDecimal("FYearCreditFor") == null ? InitHelp.zero : rs.getBigDecimal("FYearCreditFor");
            BigDecimal oldAmtYearCreditLocal = rs.getBigDecimal("FYearCreditLocal") == null ? InitHelp.zero : rs.getBigDecimal("FYearCreditLocal");
            BigDecimal oldAmtYearCreditRpt = rs.getBigDecimal("FYearCreditRpt") == null ? InitHelp.zero : rs.getBigDecimal("FYearCreditRpt");
            BigDecimal oldCreditYearQty = rs.getBigDecimal("FYearCreditQty") == null ? InitHelp.zero : rs.getBigDecimal("FYearCreditQty");
            amtYearDebitFor = oldAmtYearDebitFor.add(amtYearDebitFor);
            amtYearDebitLocal = oldAmtYearDebitLocal.add(amtYearDebitLocal);
            amtYearDebitRpt = oldAmtYearDebitRpt.add(amtYearDebitRpt);
            debitYearQty = oldDebitYearQty.add(debitYearQty);
            amtYearCreditFor = oldAmtYearCreditFor.add(amtYearCreditFor);
            amtYearCreditLocal = oldAmtYearCreditLocal.add(amtYearCreditLocal);
            amtYearCreditRpt = oldAmtYearCreditRpt.add(amtYearCreditRpt);
            creditYearQty = oldCreditYearQty.add(creditYearQty);
            if (balance.getType() == BalanceEnum.ASSISTBALANCE) {
                balance.setBeginFor(oldAmtFor.multiply(dc));
                balance.setBeginLocal(oldAmtLocal.multiply(dc));
                balance.setBeginRpt(oldAmtRpt.multiply(dc));
                balance.setBeginQty(oldQty);
                balance.setYearBeginDebitFor(oldAmtYearDebitFor.multiply(dc));
                balance.setYearBeginDebitLocal(oldAmtYearDebitLocal.multiply(dc));
                balance.setYearBeginDebitRpt(oldAmtYearDebitRpt.multiply(dc));
                balance.setYearBeginDebitQty(oldDebitYearQty);
                balance.setYearBeginCreditFor(oldAmtYearCreditFor.multiply(dc));
                balance.setYearBeginCreditLocal(oldAmtYearCreditLocal.multiply(dc));
                balance.setYearBeginCreditRpt(oldAmtYearCreditRpt.multiply(dc));
                balance.setYearBeginCreditQty(oldCreditYearQty);
                balance.setEndFor(amtFor.multiply(dc));
                balance.setEndLocal(amtLocal.multiply(dc));
                balance.setEndRpt(amtRpt.multiply(dc));
                balance.setEndQty(qty);
                balance.setYearEndDebitFor(amtYearDebitFor.multiply(dc));
                balance.setYearEndDebitLocal(amtYearDebitLocal.multiply(dc));
                balance.setYearEndDebitRpt(amtYearDebitRpt.multiply(dc));
                balance.setYearEndDebitQty(debitYearQty);
                balance.setYearEndCreditFor(amtYearCreditFor.multiply(dc));
                balance.setYearEndCreditLocal(amtYearCreditLocal.multiply(dc));
                balance.setYearEndCreditRpt(amtYearCreditRpt.multiply(dc));
                balance.setYearEndCreditQty(creditYearQty);
            }
            sql.append(" update T_GL_InitAssistBalance set FBeginBalanceFor=?,FBeginBalanceLocal=?,FBeginBalanceRpt=?,FBeginQty=?,FYearDebitFor=?,FYearCreditFor =?,FYearDebitLocal =?,FYearCreditLocal =?,FYearDebitRpt =?,FYearCreditRpt=?,FYearDebitQty=?,FYearCreditQty=?   \r\n");
            sql.append("     where forgunitid=? and fcurrencyid=? and faccountid=? and fAssistGrpID=?   \r\n  ");
            param = new Object[]{amtFor, amtLocal, amtRpt, qty, amtYearDebitFor, amtYearCreditFor, amtYearDebitLocal, amtYearCreditLocal, amtYearDebitRpt, amtYearCreditRpt, debitYearQty, creditYearQty, balance.getOrgUnit().getId().toString(), balance.getCurrency().getId().toString(), balance.getAccount().getId().toString(), balance.getAssistGrp().getId().toString()};
        } else {
            sql.append(" insert into T_GL_InitAssistBalance (fbeginbalancefor,fbeginbalancelocal,fbeginbalancerpt,fbeginqty,FOrgUnitID,FCurrencyID,FAccountID,fAssistGrpID,FYearDebitFor,FYearCreditFor ,FYearDebitLocal ,FYearCreditLocal ,FYearDebitRpt ,FYearCreditRpt,FYearDebitQty,FYearCreditQty ) values \r\n ");
            sql.append("  (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            param = new Object[]{amtFor, amtLocal, amtRpt, qty, balance.getOrgUnit().getId().toString(), balance.getCurrency().getId().toString(), balance.getAccount().getId().toString(), balance.getAssistGrp().getId().toString(), amtYearDebitFor, amtYearCreditFor, amtYearDebitLocal, amtYearCreditLocal, amtYearDebitRpt, amtYearCreditRpt, debitYearQty, creditYearQty};
        }
        if (balance.getType() == BalanceEnum.ACCTCUSSENT) {
            balance.setType(BalanceEnum.ASSISTBALANCE);
            try {
                BalanceAdjustInfo localbalance = (BalanceAdjustInfo)balance.clone();
                BalanceAdjustInfo rptbalance = (BalanceAdjustInfo)balance.clone();
                CurrencyInfo generalLocalCurrency = new CurrencyInfo();
                generalLocalCurrency.setId(CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID);
                localbalance.setCurrency(generalLocalCurrency);
                this.rewriteGeneralBeginBalance(ctx, localbalance, cuid, acctTableId);
                CurrencyInfo generalRptCurrency = new CurrencyInfo();
                generalRptCurrency.setId(CurrencyInfo.GENERAL_REPORT_CURRENCY_ID);
                rptbalance.setCurrency(generalRptCurrency);
                this.rewriteGeneralBeginBalance(ctx, rptbalance, cuid, acctTableId);
            }
            catch (EASBizException e) {
                logger.error((Object)e);
            }
            balance.setType(BalanceEnum.ACCTCUSSENT);
        }
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])param);
        this.dealAccountBalance(ctx, balance, cuid, acctTableId);
    }

    private void dealAccountBalance(Context ctx, BalanceAdjustInfo balance, String cuid, String acctTableId) throws BOSException, SQLException {
        BigDecimal dc = new BigDecimal(balance.getAccount().getDC().getValue() + "");
        BigDecimal amtFor = balance.getAdjustFor();
        BigDecimal amtLocal = balance.getAdjustLocal();
        BigDecimal amtRpt = balance.getAdjustRpt();
        BigDecimal qty = balance.getAdjustQty();
        BigDecimal amtYearDebitFor = balance.getYearAdjustDebitFor();
        BigDecimal amtYearDebitLocal = balance.getYearAdjustDebitLocal();
        BigDecimal amtYearDebitRpt = balance.getYearAdjustDebitRpt();
        BigDecimal debitYearQty = balance.getYearAdjustDebitQty();
        BigDecimal amtYearCreditFor = balance.getYearAdjustCreditFor();
        BigDecimal amtYearCreditLocal = balance.getYearAdjustCreditLocal();
        BigDecimal amtYearCreditRpt = balance.getYearAdjustCreditRpt();
        BigDecimal creditYearQty = balance.getYearAdjustCreditQty();
        if (balance.get("persist_status").equals("deleted")) {
            amtFor = amtFor.negate();
            amtLocal = amtLocal.negate();
            amtRpt = amtRpt.negate();
            qty = qty.negate();
            amtYearDebitFor = amtYearDebitFor.negate();
            amtYearDebitLocal = amtYearDebitLocal.negate();
            amtYearDebitRpt = amtYearDebitRpt.negate();
            debitYearQty = debitYearQty.negate();
            amtYearCreditFor = amtYearCreditFor.negate();
            amtYearCreditLocal = amtYearCreditLocal.negate();
            amtYearCreditRpt = amtYearCreditRpt.negate();
            creditYearQty = creditYearQty.negate();
        }
        StringBuffer acctSql = new StringBuffer();
        acctSql.append("select fid,fdc from t_bd_accountview where  Fcompanyid=? and faccountTableid=? and fnumber in(");
        String[] accountNumbers = balance.getAccount().getLongNumber().split("!");
        for (int i = accountNumbers.length - 1; i >= 0; --i) {
            acctSql.append("'");
            acctSql.append(accountNumbers[i]);
            acctSql.append("'");
            if (i <= 0) continue;
            acctSql.append(",");
        }
        acctSql.append(")  ");
        Object[] param = new Object[]{cuid, acctTableId};
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)acctSql.toString(), (Object[])param);
        while (rs.next()) {
            String accountId = rs.getString("fid");
            BigDecimal accountDc = new BigDecimal(rs.getString("fdc"));
            this.updateInitAcctBalance(ctx, balance, amtFor, amtLocal, amtRpt, qty, accountId, amtYearDebitFor, amtYearDebitLocal, amtYearDebitRpt, debitYearQty, amtYearCreditFor, amtYearCreditLocal, amtYearCreditRpt, creditYearQty, accountDc);
        }
    }

    private void updateInitAcctBalance(Context ctx, BalanceAdjustInfo balance, BigDecimal amtFor, BigDecimal amtLocal, BigDecimal amtRpt, BigDecimal qty, String accountId, BigDecimal amtYearDebitFor, BigDecimal amtYearDebitLocal, BigDecimal amtYearDebitRpt, BigDecimal debitYearQty, BigDecimal amtYearCreditFor, BigDecimal amtYearCreditLocal, BigDecimal amtYearCreditRpt, BigDecimal creditYearQty, BigDecimal accountDc) throws BOSException, SQLException {
        BigDecimal oldAmtFor = new BigDecimal(0);
        BigDecimal oldAmtLocal = new BigDecimal(0);
        BigDecimal oldAmtRpt = new BigDecimal(0);
        BigDecimal oldQty = new BigDecimal(0);
        BigDecimal oldAmtYearDebitFor = new BigDecimal(0);
        BigDecimal oldAmtYearDebitLocal = new BigDecimal(0);
        BigDecimal oldAmtYearDebitRpt = new BigDecimal(0);
        BigDecimal oldDebitYearQty = new BigDecimal(0);
        BigDecimal oldAmtYearCreditFor = new BigDecimal(0);
        BigDecimal oldAmtYearCreditLocal = new BigDecimal(0);
        BigDecimal oldAmtYearCreditRpt = new BigDecimal(0);
        BigDecimal oldCreditYearQty = new BigDecimal(0);
        StringBuffer existSql = new StringBuffer();
        StringBuffer sql = new StringBuffer();
        existSql.append("select FYearDebitFor,FYearCreditFor ,FYearDebitLocal ,FYearCreditLocal ,FYearDebitRpt ,FYearCreditRpt,FYearDebitQty,FYearCreditQty,FBeginBalanceFor,FBeginBalanceLocal,FBeginBalanceRpt,FBeginQty from t_gl_initaccountbalance where forgunitid=? and fcurrencyid=? and faccountid=?  ");
        Object[] param = new Object[]{balance.getOrgUnit().getId().toString(), balance.getCurrency().getId().toString(), accountId};
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)existSql.toString(), (Object[])param);
        if (rs.next()) {
            oldAmtFor = rs.getBigDecimal("FBeginBalanceFor") == null ? InitHelp.zero : rs.getBigDecimal("FBeginBalanceFor");
            oldAmtLocal = rs.getBigDecimal("FBeginBalanceLocal") == null ? InitHelp.zero : rs.getBigDecimal("FBeginBalanceLocal");
            oldAmtRpt = rs.getBigDecimal("FBeginBalanceRpt") == null ? InitHelp.zero : rs.getBigDecimal("FBeginBalanceRpt");
            oldQty = rs.getBigDecimal("FBeginQty") == null ? InitHelp.zero : rs.getBigDecimal("FBeginQty");
            oldAmtYearDebitFor = rs.getBigDecimal("FYearDebitFor") == null ? InitHelp.zero : rs.getBigDecimal("FYearDebitFor");
            oldAmtYearDebitLocal = rs.getBigDecimal("FYearDebitLocal") == null ? InitHelp.zero : rs.getBigDecimal("FYearDebitLocal");
            oldAmtYearDebitRpt = rs.getBigDecimal("FYearDebitRpt") == null ? InitHelp.zero : rs.getBigDecimal("FYearDebitRpt");
            oldDebitYearQty = rs.getBigDecimal("FYearDebitQty") == null ? InitHelp.zero : rs.getBigDecimal("FYearDebitQty");
            oldAmtYearCreditFor = rs.getBigDecimal("FYearCreditFor") == null ? InitHelp.zero : rs.getBigDecimal("FYearCreditFor");
            oldAmtYearCreditLocal = rs.getBigDecimal("FYearCreditLocal") == null ? InitHelp.zero : rs.getBigDecimal("FYearCreditLocal");
            oldAmtYearCreditRpt = rs.getBigDecimal("FYearCreditRpt") == null ? InitHelp.zero : rs.getBigDecimal("FYearCreditRpt");
            BigDecimal bigDecimal = oldCreditYearQty = rs.getBigDecimal("FYearCreditQty") == null ? InitHelp.zero : rs.getBigDecimal("FYearCreditQty");
            if (amtFor.multiply(accountDc).doubleValue() > 0.0) {
                amtFor = oldAmtFor.add(amtFor.abs());
                amtLocal = oldAmtLocal.add(amtLocal.abs());
                amtRpt = oldAmtRpt.add(amtRpt.abs());
                qty = oldQty.add(qty.abs());
            } else {
                amtFor = oldAmtFor.subtract(amtFor.abs());
                amtLocal = oldAmtLocal.subtract(amtLocal.abs());
                amtRpt = oldAmtRpt.subtract(amtRpt.abs());
                qty = oldQty.subtract(qty.abs());
            }
            amtYearDebitFor = oldAmtYearDebitFor.add(amtYearDebitFor);
            amtYearDebitLocal = oldAmtYearDebitLocal.add(amtYearDebitLocal);
            amtYearDebitRpt = oldAmtYearDebitRpt.add(amtYearDebitRpt);
            debitYearQty = oldDebitYearQty.add(debitYearQty);
            amtYearCreditFor = oldAmtYearCreditFor.add(amtYearCreditFor);
            amtYearCreditLocal = oldAmtYearCreditLocal.add(amtYearCreditLocal);
            amtYearCreditRpt = oldAmtYearCreditRpt.add(amtYearCreditRpt);
            creditYearQty = oldCreditYearQty.add(creditYearQty);
            if (balance.getType() == BalanceEnum.ACCOUNTBALANCE && !balance.get("persist_status").equals("new")) {
                balance.setBeginFor(oldAmtFor);
                balance.setBeginLocal(oldAmtLocal);
                balance.setBeginRpt(oldAmtRpt);
                balance.setBeginQty(oldQty);
                balance.setYearBeginDebitFor(oldAmtYearDebitFor);
                balance.setYearBeginDebitLocal(oldAmtYearDebitLocal);
                balance.setYearBeginDebitRpt(oldAmtYearDebitRpt);
                balance.setYearBeginDebitQty(oldDebitYearQty);
                balance.setYearBeginCreditFor(oldAmtYearCreditFor);
                balance.setYearBeginCreditLocal(oldAmtYearCreditLocal);
                balance.setYearBeginCreditRpt(oldAmtYearCreditRpt);
                balance.setYearBeginCreditQty(oldCreditYearQty);
                balance.setEndFor(amtFor);
                balance.setEndLocal(amtLocal);
                balance.setEndRpt(amtRpt);
                balance.setEndQty(qty);
                balance.setYearEndDebitFor(amtYearDebitFor);
                balance.setYearEndDebitLocal(amtYearDebitLocal);
                balance.setYearEndDebitRpt(amtYearDebitRpt);
                balance.setYearEndDebitQty(debitYearQty);
                balance.setYearEndCreditFor(amtYearCreditFor);
                balance.setYearEndCreditLocal(amtYearCreditLocal);
                balance.setYearEndCreditRpt(amtYearCreditRpt);
                balance.setYearEndCreditQty(creditYearQty);
            }
            sql.append(" update t_gl_initaccountbalance set FBeginBalanceFor=?,FBeginBalanceLocal=?,FBeginBalanceRpt=?,FBeginQty=?,FYearDebitFor=?,FYearCreditFor =?,FYearDebitLocal =?,FYearCreditLocal =?,FYearDebitRpt =?,FYearCreditRpt=?,FYearDebitQty=?,FYearCreditQty=?   \r\n");
            sql.append("     where forgunitid=? and fcurrencyid=? and faccountid=?    \r\n  ");
            param = new Object[]{amtFor, amtLocal, amtRpt, qty, amtYearDebitFor, amtYearCreditFor, amtYearDebitLocal, amtYearCreditLocal, amtYearDebitRpt, amtYearCreditRpt, debitYearQty, creditYearQty, balance.getOrgUnit().getId().toString(), balance.getCurrency().getId().toString(), accountId};
        } else {
            if (amtFor.multiply(accountDc).doubleValue() > 0.0) {
                amtFor = oldAmtFor.add(amtFor.abs());
                amtLocal = oldAmtLocal.add(amtLocal.abs());
                amtRpt = oldAmtRpt.add(amtRpt.abs());
                qty = oldQty.add(qty.abs());
            } else {
                amtFor = oldAmtFor.subtract(amtFor.abs());
                amtLocal = oldAmtLocal.subtract(amtLocal.abs());
                amtRpt = oldAmtRpt.subtract(amtRpt.abs());
                qty = oldQty.subtract(qty.abs());
            }
            sql.append(" insert into T_GL_InitAccountBalance (fbeginbalancefor,fbeginbalancelocal,fbeginbalancerpt,fbeginqty,FOrgUnitID,FCurrencyID,FAccountID,FYearDebitFor,FYearCreditFor ,FYearDebitLocal ,FYearCreditLocal ,FYearDebitRpt ,FYearCreditRpt,FYearDebitQty,FYearCreditQty ) values \r\n ");
            sql.append("  (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            param = new Object[]{amtFor, amtLocal, amtRpt, qty, balance.getOrgUnit().getId().toString(), balance.getCurrency().getId().toString(), accountId, amtYearDebitFor, amtYearCreditFor, amtYearDebitLocal, amtYearCreditLocal, amtYearDebitRpt, amtYearCreditRpt, debitYearQty, creditYearQty};
        }
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])param);
        if (balance.getType() == BalanceEnum.ACCOUNTBALANCE && !balance.get("persist_status").equals("new")) {
            BigDecimal balanceDc = new BigDecimal(balance.getAccount().getDC().getValue() + "");
            balance.setBeginFor(oldAmtFor.multiply(accountDc));
            balance.setBeginLocal(oldAmtLocal.multiply(accountDc));
            balance.setBeginRpt(oldAmtRpt.multiply(accountDc));
            balance.setBeginQty(oldQty.multiply(accountDc));
            balance.setYearBeginDebitFor(oldAmtYearDebitFor.multiply(accountDc));
            balance.setYearBeginDebitLocal(oldAmtYearDebitLocal.multiply(accountDc));
            balance.setYearBeginDebitRpt(oldAmtYearDebitRpt.multiply(accountDc));
            balance.setYearBeginDebitQty(oldDebitYearQty.multiply(accountDc));
            balance.setYearBeginCreditFor(oldAmtYearCreditFor.abs().multiply(balanceDc));
            balance.setYearBeginCreditLocal(oldAmtYearCreditLocal.abs().multiply(balanceDc));
            balance.setYearBeginCreditRpt(oldAmtYearCreditRpt.abs().multiply(balanceDc));
            balance.setYearBeginCreditQty(oldCreditYearQty.abs().multiply(balanceDc));
            balance.setEndFor(amtFor.multiply(accountDc));
            balance.setEndLocal(amtLocal.multiply(accountDc));
            balance.setEndRpt(amtRpt.multiply(accountDc));
            balance.setEndQty(qty.multiply(accountDc));
            balance.setYearEndDebitFor(amtYearDebitFor.multiply(accountDc));
            balance.setYearEndDebitLocal(amtYearDebitLocal.multiply(accountDc));
            balance.setYearEndDebitRpt(amtYearDebitRpt.multiply(accountDc));
            balance.setYearEndDebitQty(debitYearQty.multiply(accountDc));
            balance.setYearEndCreditFor(amtYearCreditFor.multiply(accountDc));
            balance.setYearEndCreditLocal(amtYearCreditLocal.multiply(accountDc));
            balance.setYearEndCreditRpt(amtYearCreditRpt.multiply(accountDc));
            balance.setYearEndCreditQty(creditYearQty.multiply(accountDc));
        }
    }

    private void rewriteGeneralBeginBalance(Context ctx, BalanceAdjustInfo balance, String companyId, String acctTableId) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        Object[] param = null;
        IRowSet rs = null;
        BigDecimal dc = new BigDecimal(balance.getAccount().getDC().getValue() + "");
        BigDecimal amtLocal = balance.getAdjustLocal().multiply(dc);
        BigDecimal amtRpt = balance.getAdjustRpt().multiply(dc);
        BigDecimal qty = balance.getAdjustQty();
        BigDecimal amtYearDebitFor = balance.getYearAdjustDebitFor();
        BigDecimal amtYearDebitLocal = balance.getYearAdjustDebitLocal();
        BigDecimal amtYearDebitRpt = balance.getYearAdjustDebitRpt();
        BigDecimal debitYearQty = balance.getYearAdjustDebitQty();
        BigDecimal amtYearCreditFor = balance.getYearAdjustCreditFor();
        BigDecimal amtYearCreditLocal = balance.getYearAdjustCreditLocal();
        BigDecimal amtYearCreditRpt = balance.getYearAdjustCreditRpt();
        BigDecimal creditYearQty = balance.getYearAdjustCreditQty();
        if (balance.get("persist_status").equals("deleted")) {
            amtLocal = amtLocal.negate();
            amtRpt = amtRpt.negate();
            qty = qty.negate();
            amtYearDebitFor = amtYearDebitFor.negate();
            amtYearDebitLocal = amtYearDebitLocal.negate();
            amtYearDebitRpt = amtYearDebitRpt.negate();
            debitYearQty = debitYearQty.negate();
            amtYearCreditFor = amtYearCreditFor.negate();
            amtYearCreditLocal = amtYearCreditLocal.negate();
            amtYearCreditRpt = amtYearCreditRpt.negate();
            creditYearQty = creditYearQty.negate();
        }
        StringBuffer existSql = new StringBuffer();
        try {
            if (balance.getType() == BalanceEnum.ACCOUNTBALANCE) {
                this.dealGeneralBeginBalance(ctx, balance, companyId, acctTableId);
            } else if (balance.getType() == BalanceEnum.ASSISTBALANCE) {
                existSql.append("select FYearDebitFor,FYearCreditFor ,FYearDebitLocal ,FYearCreditLocal ,FYearDebitRpt ,FYearCreditRpt,FYearDebitQty,FYearCreditQty,FBeginBalanceLocal,FBeginBalanceRpt,FBeginQty from T_GL_InitAssistBalance where forgunitid=? and fcurrencyid=? and faccountid=? and fAssistGrpID=? ");
                param = new Object[]{balance.getOrgUnit().getId().toString(), balance.getCurrency().getId().toString(), balance.getAccount().getId().toString(), balance.getAssistGrp().getId().toString()};
                rs = DbUtil.executeQuery((Context)ctx, (String)existSql.toString(), (Object[])param);
                if (rs.next()) {
                    BigDecimal amtFor;
                    BigDecimal oldAmtLocal = rs.getBigDecimal("FBeginBalanceLocal") == null ? InitHelp.zero : rs.getBigDecimal("FBeginBalanceLocal");
                    BigDecimal oldAmtRpt = rs.getBigDecimal("FBeginBalanceRpt") == null ? InitHelp.zero : rs.getBigDecimal("FBeginBalanceRpt");
                    BigDecimal oldQty = rs.getBigDecimal("FBeginQty") == null ? InitHelp.zero : rs.getBigDecimal("FBeginQty");
                    amtLocal = oldAmtLocal.add(amtLocal);
                    amtRpt = oldAmtRpt.add(amtRpt);
                    qty = oldQty.add(qty);
                    BigDecimal oldAmtYearDebitLocal = rs.getBigDecimal("FYearDebitLocal") == null ? InitHelp.zero : rs.getBigDecimal("FYearDebitLocal");
                    BigDecimal oldAmtYearDebitRpt = rs.getBigDecimal("FYearDebitRpt") == null ? InitHelp.zero : rs.getBigDecimal("FYearDebitRpt");
                    BigDecimal oldDebitYearQty = rs.getBigDecimal("FYearDebitQty") == null ? InitHelp.zero : rs.getBigDecimal("FYearDebitQty");
                    BigDecimal oldAmtYearCreditLocal = rs.getBigDecimal("FYearCreditLocal") == null ? InitHelp.zero : rs.getBigDecimal("FYearCreditLocal");
                    BigDecimal oldAmtYearCreditRpt = rs.getBigDecimal("FYearCreditRpt") == null ? InitHelp.zero : rs.getBigDecimal("FYearCreditRpt");
                    BigDecimal oldCreditYearQty = rs.getBigDecimal("FYearCreditQty") == null ? InitHelp.zero : rs.getBigDecimal("FYearCreditQty");
                    amtYearDebitLocal = oldAmtYearDebitLocal.add(amtYearDebitLocal);
                    amtYearDebitRpt = oldAmtYearDebitRpt.add(amtYearDebitRpt);
                    debitYearQty = oldDebitYearQty.add(debitYearQty);
                    amtYearCreditLocal = oldAmtYearCreditLocal.add(amtYearCreditLocal);
                    amtYearCreditRpt = oldAmtYearCreditRpt.add(amtYearCreditRpt);
                    creditYearQty = oldCreditYearQty.add(creditYearQty);
                    if (balance.getCurrency().getId().equals((Object)CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID)) {
                        amtFor = amtLocal;
                        amtYearDebitFor = amtYearDebitLocal;
                        amtYearCreditFor = amtYearCreditLocal;
                    } else {
                        amtFor = amtRpt;
                        amtYearDebitFor = amtYearDebitRpt;
                        amtYearCreditFor = amtYearCreditRpt;
                    }
                    sql.append(" update T_GL_InitAssistBalance set FBeginBalanceFor=?,FBeginBalanceLocal=?,FBeginBalanceRpt=?,FBeginQty=?,FYearDebitFor=?,FYearCreditFor=? ,FYearDebitLocal=? ,FYearCreditLocal=? ,FYearDebitRpt=? ,FYearCreditRpt=?,FYearDebitQty=?,FYearCreditQty=?   \r\n");
                    sql.append("     where forgunitid=? and fcurrencyid=? and faccountid=? and fAssistGrpID=?   \r\n  ");
                    param = new Object[]{amtFor, amtLocal, amtRpt, qty, amtYearDebitFor, amtYearCreditFor, amtYearDebitLocal, amtYearCreditLocal, amtYearDebitRpt, amtYearCreditRpt, debitYearQty, creditYearQty, balance.getOrgUnit().getId().toString(), balance.getCurrency().getId().toString(), balance.getAccount().getId().toString(), balance.getAssistGrp().getId().toString()};
                } else {
                    sql.append(" insert into T_GL_InitAssistBalance (fbeginbalancefor,fbeginbalancelocal,fbeginbalancerpt,fbeginqty,FOrgUnitID,FCurrencyID,FAccountID,fAssistGrpID,FYearDebitFor,FYearCreditFor ,FYearDebitLocal ,FYearCreditLocal ,FYearDebitRpt ,FYearCreditRpt,FYearDebitQty,FYearCreditQty ) values \r\n ");
                    sql.append("  (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                    BigDecimal amtFor = balance.getCurrency().getId().equals((Object)CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID) ? amtLocal : amtRpt;
                    param = new Object[]{amtFor, amtLocal, amtRpt, qty, balance.getOrgUnit().getId().toString(), balance.getCurrency().getId().toString(), balance.getAccount().getId().toString(), balance.getAssistGrp().getId().toString(), amtYearDebitFor, amtYearCreditFor, amtYearDebitLocal, amtYearCreditLocal, amtYearDebitRpt, amtYearCreditRpt, debitYearQty, creditYearQty};
                }
                DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])param);
                this.dealGeneralBeginBalance(ctx, balance, companyId, acctTableId);
            }
        }
        catch (SQLException e) {
            new BOSException((Throwable)e);
        }
    }

    private void dealGeneralBeginBalance(Context ctx, BalanceAdjustInfo balance, String companyId, String acctTableId) throws BOSException, SQLException {
        BigDecimal dc = new BigDecimal(balance.getAccount().getDC().getValue() + "");
        BigDecimal amtFor = balance.getAdjustFor();
        BigDecimal amtLocal = balance.getAdjustLocal();
        BigDecimal amtRpt = balance.getAdjustRpt();
        BigDecimal qty = balance.getAdjustQty();
        BigDecimal amtYearDebitFor = balance.getYearAdjustDebitFor();
        BigDecimal amtYearDebitLocal = balance.getYearAdjustDebitLocal();
        BigDecimal amtYearDebitRpt = balance.getYearAdjustDebitRpt();
        BigDecimal debitYearQty = balance.getYearAdjustDebitQty();
        BigDecimal amtYearCreditFor = balance.getYearAdjustCreditFor();
        BigDecimal amtYearCreditLocal = balance.getYearAdjustCreditLocal();
        BigDecimal amtYearCreditRpt = balance.getYearAdjustCreditRpt();
        BigDecimal creditYearQty = balance.getYearAdjustCreditQty();
        if (balance.get("persist_status").equals("deleted")) {
            amtLocal = amtLocal.negate();
            amtRpt = amtRpt.negate();
            qty = qty.negate();
            amtYearDebitFor = amtYearDebitFor.negate();
            amtYearDebitLocal = amtYearDebitLocal.negate();
            amtYearDebitRpt = amtYearDebitRpt.negate();
            debitYearQty = debitYearQty.negate();
            amtYearCreditFor = amtYearCreditFor.negate();
            amtYearCreditLocal = amtYearCreditLocal.negate();
            amtYearCreditRpt = amtYearCreditRpt.negate();
            creditYearQty = creditYearQty.negate();
        }
        StringBuffer acctSql = new StringBuffer();
        acctSql.append("select fid,fdc from t_bd_accountview where  Fcompanyid=? and faccountTableid=? and fnumber in(");
        String[] accountNumbers = balance.getAccount().getLongNumber().split("!");
        for (int i = accountNumbers.length - 1; i >= 0; --i) {
            acctSql.append("'");
            acctSql.append(accountNumbers[i]);
            acctSql.append("'");
            if (i <= 0) continue;
            acctSql.append(",");
        }
        acctSql.append(")  ");
        Object[] param = new Object[]{companyId, acctTableId};
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)acctSql.toString(), (Object[])param);
        while (rs.next()) {
            String accountId = rs.getString("fid");
            BigDecimal accountDc = new BigDecimal(rs.getString("fdc"));
            this.updateGeneralInitAcctBalance(ctx, balance, amtLocal, amtRpt, qty, accountId, amtYearDebitFor, amtYearDebitLocal, amtYearDebitRpt, debitYearQty, amtYearCreditFor, amtYearCreditLocal, amtYearCreditRpt, creditYearQty, accountDc);
        }
    }

    private void updateGeneralInitAcctBalance(Context ctx, BalanceAdjustInfo balance, BigDecimal amtLocal, BigDecimal amtRpt, BigDecimal qty, String accountId, BigDecimal amtYearDebitFor, BigDecimal amtYearDebitLocal, BigDecimal amtYearDebitRpt, BigDecimal debitYearQty, BigDecimal amtYearCreditFor, BigDecimal amtYearCreditLocal, BigDecimal amtYearCreditRpt, BigDecimal creditYearQty, BigDecimal accountDc) throws BOSException, SQLException {
        BigDecimal amtFor;
        BigDecimal oldAmtFor = new BigDecimal(0);
        BigDecimal oldAmtLocal = new BigDecimal(0);
        BigDecimal oldAmtRpt = new BigDecimal(0);
        BigDecimal oldQty = new BigDecimal(0);
        BigDecimal oldAmtYearDebitFor = new BigDecimal(0);
        BigDecimal oldAmtYearDebitLocal = new BigDecimal(0);
        BigDecimal oldAmtYearDebitRpt = new BigDecimal(0);
        BigDecimal oldDebitYearQty = new BigDecimal(0);
        BigDecimal oldAmtYearCreditFor = new BigDecimal(0);
        BigDecimal oldAmtYearCreditLocal = new BigDecimal(0);
        BigDecimal oldAmtYearCreditRpt = new BigDecimal(0);
        BigDecimal oldCreditYearQty = new BigDecimal(0);
        StringBuffer existSql = new StringBuffer();
        StringBuffer sql = new StringBuffer();
        existSql.append("select FYearDebitFor,FYearCreditFor ,FYearDebitLocal ,FYearCreditLocal ,FYearDebitRpt ,FYearCreditRpt,FYearDebitQty,FYearCreditQty,FBeginBalanceLocal,FBeginBalanceRpt,FBeginQty from t_gl_initaccountbalance where forgunitid=? and fcurrencyid=? and faccountid=?  ");
        Object[] param = new Object[]{balance.getOrgUnit().getId().toString(), balance.getCurrency().getId().toString(), accountId};
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)existSql.toString(), (Object[])param);
        if (rs.next()) {
            oldAmtLocal = rs.getBigDecimal("FBeginBalanceLocal") == null ? InitHelp.zero : rs.getBigDecimal("FBeginBalanceLocal");
            oldAmtRpt = rs.getBigDecimal("FBeginBalanceRpt") == null ? InitHelp.zero : rs.getBigDecimal("FBeginBalanceRpt");
            BigDecimal bigDecimal = oldQty = rs.getBigDecimal("FBeginQty") == null ? InitHelp.zero : rs.getBigDecimal("FBeginQty");
            if (amtLocal.multiply(accountDc).doubleValue() > 0.0) {
                amtLocal = oldAmtLocal.add(amtLocal.abs());
                amtRpt = oldAmtRpt.add(amtRpt.abs());
                qty = oldQty.add(qty.abs());
            } else {
                amtLocal = oldAmtLocal.subtract(amtLocal.abs());
                amtRpt = oldAmtRpt.subtract(amtRpt.abs());
                qty = oldQty.subtract(qty.abs());
            }
            oldAmtYearDebitLocal = rs.getBigDecimal("FYearDebitLocal") == null ? InitHelp.zero : rs.getBigDecimal("FYearDebitLocal");
            oldAmtYearDebitRpt = rs.getBigDecimal("FYearDebitRpt") == null ? InitHelp.zero : rs.getBigDecimal("FYearDebitRpt");
            oldDebitYearQty = rs.getBigDecimal("FYearDebitQty") == null ? InitHelp.zero : rs.getBigDecimal("FYearDebitQty");
            oldAmtYearCreditLocal = rs.getBigDecimal("FYearCreditLocal") == null ? InitHelp.zero : rs.getBigDecimal("FYearCreditLocal");
            oldAmtYearCreditRpt = rs.getBigDecimal("FYearCreditRpt") == null ? InitHelp.zero : rs.getBigDecimal("FYearCreditRpt");
            oldCreditYearQty = rs.getBigDecimal("FYearCreditQty") == null ? InitHelp.zero : rs.getBigDecimal("FYearCreditQty");
            amtYearDebitLocal = oldAmtYearDebitLocal.add(amtYearDebitLocal);
            amtYearDebitRpt = oldAmtYearDebitRpt.add(amtYearDebitRpt);
            debitYearQty = oldDebitYearQty.add(debitYearQty);
            amtYearCreditLocal = oldAmtYearCreditLocal.add(amtYearCreditLocal);
            amtYearCreditRpt = oldAmtYearCreditRpt.add(amtYearCreditRpt);
            creditYearQty = oldCreditYearQty.add(creditYearQty);
            if (balance.getCurrency().getId().equals((Object)CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID)) {
                amtFor = amtLocal;
                amtYearDebitFor = amtYearDebitLocal;
                amtYearCreditFor = amtYearCreditLocal;
            } else {
                amtFor = amtRpt;
                amtYearDebitFor = amtYearDebitRpt;
                amtYearCreditFor = amtYearCreditRpt;
            }
            sql.append(" update t_gl_initaccountbalance set FBeginBalanceFor=?,FBeginBalanceLocal=?,FBeginBalanceRpt=?,FBeginQty=? ,FYearDebitFor=?,FYearCreditFor =?,FYearDebitLocal =?,FYearCreditLocal =?,FYearDebitRpt =?,FYearCreditRpt=?,FYearDebitQty=?,FYearCreditQty=?   \r\n");
            sql.append("     where forgunitid=? and fcurrencyid=? and faccountid=?    \r\n  ");
            param = new Object[]{amtFor, amtLocal, amtRpt, qty, amtYearDebitFor, amtYearCreditFor, amtYearDebitLocal, amtYearCreditLocal, amtYearDebitRpt, amtYearCreditRpt, debitYearQty, creditYearQty, balance.getOrgUnit().getId().toString(), balance.getCurrency().getId().toString(), accountId};
        } else {
            sql.append(" insert into T_GL_InitAccountBalance (fbeginbalancefor,fbeginbalancelocal,fbeginbalancerpt,fbeginqty,FOrgUnitID,FCurrencyID,FAccountID ,FYearDebitFor,FYearCreditFor ,FYearDebitLocal ,FYearCreditLocal ,FYearDebitRpt ,FYearCreditRpt,FYearDebitQty,FYearCreditQty ) values \r\n ");
            sql.append("  (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            if (balance.getCurrency().getId().equals((Object)CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID)) {
                if (amtLocal.multiply(accountDc).doubleValue() > 0.0) {
                    amtLocal = oldAmtLocal.add(amtLocal.abs());
                    amtRpt = oldAmtRpt.add(amtRpt.abs());
                    qty = oldQty.add(qty.abs());
                } else {
                    amtLocal = oldAmtLocal.subtract(amtLocal.abs());
                    amtRpt = oldAmtRpt.subtract(amtRpt.abs());
                    qty = oldQty.subtract(qty.abs());
                }
                amtFor = amtLocal;
            } else {
                if (amtRpt.multiply(accountDc).doubleValue() > 0.0) {
                    amtLocal = oldAmtLocal.add(amtLocal.abs());
                    amtRpt = oldAmtRpt.add(amtRpt.abs());
                    qty = oldQty.add(qty.abs());
                } else {
                    amtLocal = oldAmtLocal.subtract(amtLocal.abs());
                    amtRpt = oldAmtRpt.subtract(amtRpt.abs());
                    qty = oldQty.subtract(qty.abs());
                }
                amtFor = amtRpt;
            }
            param = new Object[]{amtFor, amtLocal, amtRpt, qty, balance.getOrgUnit().getId().toString(), balance.getCurrency().getId().toString(), accountId, amtYearDebitFor, amtYearCreditFor, amtYearDebitLocal, amtYearCreditLocal, amtYearDebitRpt, amtYearCreditRpt, debitYearQty, creditYearQty};
        }
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])param);
        if (balance.getType() == BalanceEnum.ACCOUNTBALANCE) {
            BigDecimal balanceDc = new BigDecimal(balance.getAccount().getDC().getValue() + "");
            balance.setBeginFor(oldAmtFor.multiply(accountDc));
            balance.setBeginLocal(oldAmtLocal.multiply(accountDc));
            balance.setBeginRpt(oldAmtRpt.multiply(accountDc));
            balance.setBeginQty(oldQty.multiply(accountDc));
            balance.setYearBeginDebitFor(oldAmtYearDebitFor.multiply(accountDc));
            balance.setYearBeginDebitLocal(oldAmtYearDebitLocal.multiply(accountDc));
            balance.setYearBeginDebitRpt(oldAmtYearDebitRpt.multiply(accountDc));
            balance.setYearBeginDebitQty(oldDebitYearQty.multiply(accountDc));
            balance.setYearBeginCreditFor(oldAmtYearCreditFor.abs().multiply(balanceDc));
            balance.setYearBeginCreditLocal(oldAmtYearCreditLocal.abs().multiply(balanceDc));
            balance.setYearBeginCreditRpt(oldAmtYearCreditRpt.abs().multiply(balanceDc));
            balance.setYearBeginCreditQty(oldCreditYearQty.abs().multiply(balanceDc));
            balance.setEndFor(amtFor.multiply(accountDc));
            balance.setEndLocal(amtLocal.multiply(accountDc));
            balance.setEndRpt(amtRpt.multiply(accountDc));
            balance.setEndQty(qty.multiply(accountDc));
            balance.setYearEndDebitFor(amtYearDebitFor.multiply(accountDc));
            balance.setYearEndDebitLocal(amtYearDebitLocal.multiply(accountDc));
            balance.setYearEndDebitRpt(amtYearDebitRpt.multiply(accountDc));
            balance.setYearEndDebitQty(debitYearQty.multiply(accountDc));
            balance.setYearEndCreditFor(amtYearCreditFor.multiply(accountDc));
            balance.setYearEndCreditLocal(amtYearCreditLocal.multiply(accountDc));
            balance.setYearEndCreditRpt(amtYearCreditRpt.multiply(accountDc));
            balance.setYearEndCreditQty(creditYearQty.multiply(accountDc));
        }
    }

    private void saveGeneral(Context ctx, IObjectCollection datas, HashMap otherCtx) throws BOSException, EASBizException {
        int type = Integer.parseInt(otherCtx.get("type").toString());
        if (type == 3) {
            return;
        }
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)otherCtx.get("COMPANY");
        String companyId = company.getId().toString();
        String glcid = CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString();
        String grcid = CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString();
        AcountSchemeInfo accountScheme = (AcountSchemeInfo)otherCtx.get("acctscheme");
        boolean isUseReport = (Boolean)otherCtx.get("ISUSEREPORT");
        StringBuffer sumSql = new StringBuffer();
        sumSql.append("select sum(balance.fbeginLocal) fbeginLocal,sum(balance.fAdjustLocal) fAdjustLocal,sum(balance.fEndLocal) fEndLocal").append(",sum(balance.fbeginrpt) fbeginrpt,sum(balance.fAdjustrpt) fAdjustrpt,sum(balance.fEndrpt) fEndrpt").append(",sum(balance.fbeginqty) fbeginqty,sum(balance.fAdjustqty) fAdjustqty,sum(balance.fEndqty) fEndqty").append(" from t_bks_balanceadjust balance where balance.forgunitid=?  and balance.faccountid=? and balance.ftype=? ");
        if (type != 1) {
            sumSql.append(" and balance.fassistgrpid=? ");
        }
        sumSql.append(" and balance.fcurrencyid<>? and balance.fcurrencyid<>?").toString();
        StringBuffer existSql = new StringBuffer();
        existSql.append("select top 1 * from t_bks_balanceadjust balance where balance.forgunitid=? and balance.faccountid=?  and balance.fcurrencyid=? and ftype=? ");
        if (type != 1) {
            existSql.append(" and balance.fassistgrpid=? ");
        }
        StringBuffer deleteSql = new StringBuffer();
        deleteSql.append("delete from t_bks_balanceadjust where forgunitid=? and faccountid=? and (fcurrencyid=? or fcurrencyid=?) and ftype=? ");
        if (type != 1) {
            deleteSql.append(" and fassistgrpid=? ");
        }
        Connection con = null;
        PreparedStatement stmt = null;
        Statement clear_stmt = null;
        ResultSet rs = null;
        try {
            con = this.getConnection(ctx);
            for (int i = 0; i < datas.size(); ++i) {
                CurrencyInfo generalLocalCurrency;
                BalanceAdjustInfo newBalance;
                CurrencyInfo currency;
                BalanceAdjustInfo as = (BalanceAdjustInfo)datas.getObject(i);
                String accountId = as.getAccount().getId().toString();
                String hgId = null;
                if (type != 1) {
                    hgId = as.getAssistGrp().getId().toString();
                }
                stmt = con.prepareStatement(sumSql.toString());
                int index = 1;
                stmt.setString(index++, companyId);
                stmt.setString(index++, accountId);
                if (SQLUtil.isPG(ctx) || SQLUtil.isKingBase(ctx)) {
                    stmt.setInt(index++, type);
                } else {
                    stmt.setString(index++, type + "");
                }
                if (type != 1) {
                    stmt.setString(index++, hgId);
                }
                stmt.setString(index++, glcid);
                stmt.setString(index++, grcid);
                rs = stmt.executeQuery();
                if (!rs.next()) continue;
                BalanceAdjustInfo data = new BalanceAdjustInfo();
                data.put("account", accountId);
                data.put("assistGrp", hgId);
                data.setBeginLocal(rs.getBigDecimal("fbeginlocal"));
                data.setBeginRpt(rs.getBigDecimal("fbeginrpt"));
                data.setBeginQty(rs.getBigDecimal("fbeginqty"));
                data.setAdjustLocal(rs.getBigDecimal("fAdjustlocal"));
                data.setAdjustRpt(rs.getBigDecimal("fAdjustrpt"));
                data.setAdjustQty(rs.getBigDecimal("fAdjustqty"));
                data.setEndLocal(rs.getBigDecimal("fendlocal"));
                data.setEndRpt(rs.getBigDecimal("fendrpt"));
                data.setEndQty(rs.getBigDecimal("fendqty"));
                SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
                if (data.getBeginLocal() == null) {
                    stmt = con.prepareStatement(deleteSql.toString());
                    index = 1;
                    stmt.setString(index++, companyId);
                    stmt.setString(index++, accountId);
                    stmt.setString(index++, glcid);
                    stmt.setString(index++, grcid);
                    if (SQLUtil.isPG(ctx) || SQLUtil.isKingBase(ctx)) {
                        stmt.setInt(index++, type);
                    } else {
                        stmt.setString(index++, type + "");
                    }
                    if (type != 1) {
                        stmt.setString(index++, hgId);
                    }
                    stmt.executeUpdate();
                    SQLUtils.cleanup((Statement)stmt);
                    continue;
                }
                stmt = con.prepareStatement(existSql.toString());
                index = 1;
                stmt.setString(index++, companyId);
                stmt.setString(index++, accountId);
                stmt.setString(index++, glcid);
                if (SQLUtil.isPG(ctx) || SQLUtil.isKingBase(ctx)) {
                    stmt.setInt(index++, type);
                } else {
                    stmt.setString(index++, type + "");
                }
                if (type != 1) {
                    stmt.setString(index++, hgId);
                }
                rs = stmt.executeQuery();
                boolean flag = false;
                BalanceAdjustInfo generalLocalBalance = new BalanceAdjustInfo();
                if (rs.next()) {
                    generalLocalBalance.setId(BOSUuid.read((String)rs.getString("fid")));
                    generalLocalBalance.setOrgUnit(company);
                    currency = new CurrencyInfo();
                    currency.setId(BOSUuid.read((String)rs.getString("fcurrencyid")));
                    generalLocalBalance.setCurrency(currency);
                    generalLocalBalance.setIsInit(rs.getBoolean("fisinit"));
                    generalLocalBalance.setType(BalanceEnum.getEnum((int)rs.getInt("ftype")));
                    generalLocalBalance.setAccountScheme(accountScheme);
                    flag = true;
                }
                SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
                if (flag) {
                    generalLocalBalance.setBeginFor(data.getBeginLocal());
                    generalLocalBalance.setBeginLocal(data.getBeginLocal());
                    generalLocalBalance.setBeginRpt(InitHelp.zero);
                    generalLocalBalance.setAdjustFor(data.getAdjustLocal());
                    generalLocalBalance.setAdjustLocal(data.getAdjustLocal());
                    generalLocalBalance.setAdjustRpt(InitHelp.zero);
                    generalLocalBalance.setEndFor(data.getEndLocal());
                    generalLocalBalance.setEndLocal(data.getEndLocal());
                    generalLocalBalance.setEndRpt(InitHelp.zero);
                    generalLocalBalance.setBeginQty(data.getBeginQty());
                    generalLocalBalance.setAdjustQty(data.getAdjustQty());
                    generalLocalBalance.setEndQty(data.getEndQty());
                    if (type != 1) {
                        generalLocalBalance.setAssistGrp(as.getAssistGrp());
                    }
                    super.update(ctx, (IObjectPK)new ObjectUuidPK(generalLocalBalance.getId()), generalLocalBalance);
                } else {
                    newBalance = new BalanceAdjustInfo();
                    newBalance.setOrgUnit(company);
                    newBalance.setAccount(as.getAccount());
                    newBalance.setAssistGrp(as.getAssistGrp());
                    generalLocalCurrency = new CurrencyInfo();
                    generalLocalCurrency.setId(CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID);
                    newBalance.setCurrency(generalLocalCurrency);
                    newBalance.setAccountScheme(accountScheme);
                    newBalance.setIsInit(true);
                    newBalance.setType(BalanceEnum.getEnum((int)type));
                    newBalance.setBeginFor(data.getBeginLocal());
                    newBalance.setBeginLocal(data.getBeginLocal());
                    newBalance.setBeginRpt(InitHelp.zero);
                    newBalance.setAdjustFor(data.getAdjustLocal());
                    newBalance.setAdjustLocal(data.getAdjustLocal());
                    newBalance.setAdjustRpt(InitHelp.zero);
                    newBalance.setEndFor(data.getEndLocal());
                    newBalance.setEndLocal(data.getEndLocal());
                    newBalance.setEndRpt(InitHelp.zero);
                    newBalance.setBeginQty(data.getBeginQty());
                    newBalance.setAdjustQty(data.getAdjustQty());
                    newBalance.setEndQty(data.getEndQty());
                    super.addnew(ctx, newBalance);
                }
                if (!isUseReport) continue;
                stmt = con.prepareStatement(existSql.toString());
                index = 1;
                stmt.setString(index++, companyId);
                stmt.setString(index++, accountId);
                stmt.setString(index++, grcid);
                if (SQLUtil.isPG(ctx) || SQLUtil.isKingBase(ctx)) {
                    stmt.setInt(index++, type);
                } else {
                    stmt.setString(index++, type + "");
                }
                if (type != 1) {
                    stmt.setString(index++, hgId);
                }
                rs = stmt.executeQuery();
                flag = false;
                generalLocalBalance = new BalanceAdjustInfo();
                if (rs.next()) {
                    generalLocalBalance.setId(BOSUuid.read((String)rs.getString("fid")));
                    generalLocalBalance.setOrgUnit(company);
                    currency = new CurrencyInfo();
                    currency.setId(BOSUuid.read((String)rs.getString("fcurrencyid")));
                    generalLocalBalance.setCurrency(currency);
                    generalLocalBalance.setIsInit(rs.getBoolean("fisinit"));
                    generalLocalBalance.setType(BalanceEnum.getEnum((int)rs.getInt("ftype")));
                    generalLocalBalance.setAccountScheme(accountScheme);
                    flag = true;
                }
                SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
                if (flag) {
                    generalLocalBalance.setBeginFor(data.getBeginRpt());
                    generalLocalBalance.setBeginLocal(InitHelp.zero);
                    generalLocalBalance.setBeginRpt(data.getBeginRpt());
                    generalLocalBalance.setAdjustFor(data.getAdjustRpt());
                    generalLocalBalance.setAdjustLocal(InitHelp.zero);
                    generalLocalBalance.setAdjustRpt(data.getAdjustRpt());
                    generalLocalBalance.setEndFor(data.getEndRpt());
                    generalLocalBalance.setEndLocal(InitHelp.zero);
                    generalLocalBalance.setEndRpt(data.getEndRpt());
                    generalLocalBalance.setBeginQty(data.getBeginQty());
                    generalLocalBalance.setAdjustQty(data.getAdjustQty());
                    generalLocalBalance.setEndQty(data.getEndQty());
                    if (type != 1) {
                        generalLocalBalance.setAssistGrp(as.getAssistGrp());
                    }
                    super.update(ctx, (IObjectPK)new ObjectUuidPK(generalLocalBalance.getId()), generalLocalBalance);
                    continue;
                }
                newBalance = new BalanceAdjustInfo();
                newBalance.setOrgUnit(company);
                newBalance.setAccount(as.getAccount());
                newBalance.setAssistGrp(as.getAssistGrp());
                generalLocalCurrency = new CurrencyInfo();
                generalLocalCurrency.setId(CurrencyInfo.GENERAL_REPORT_CURRENCY_ID);
                newBalance.setCurrency(generalLocalCurrency);
                newBalance.setAccountScheme(accountScheme);
                newBalance.setIsInit(true);
                newBalance.setType(BalanceEnum.getEnum((int)type));
                newBalance.setBeginFor(data.getBeginRpt());
                newBalance.setBeginLocal(InitHelp.zero);
                newBalance.setBeginRpt(data.getBeginRpt());
                newBalance.setAdjustFor(data.getAdjustRpt());
                newBalance.setAdjustLocal(InitHelp.zero);
                newBalance.setAdjustRpt(data.getAdjustRpt());
                newBalance.setEndFor(data.getEndRpt());
                newBalance.setEndLocal(InitHelp.zero);
                newBalance.setEndRpt(data.getEndRpt());
                newBalance.setBeginQty(data.getBeginQty());
                newBalance.setAdjustQty(data.getAdjustQty());
                newBalance.setEndQty(data.getEndQty());
                super.addnew(ctx, newBalance);
            }
        }
        catch (SQLException e) {
            throw new SQLAccessException(e);
        }
        finally {
            SQLUtils.cleanup(clear_stmt);
            SQLUtils.cleanup(rs, stmt, (Connection)con);
        }
    }

    @Override
    protected boolean _tryBalance(Context ctx, HashMap otherCtx) throws BOSException, EASBizException {
        int type = Integer.parseInt(otherCtx.get("type").toString());
        String companyId = ((CompanyOrgUnitInfo)otherCtx.get("COMPANY")).getId().toString();
        StringBuffer sql = new StringBuffer();
        String currencyField = "b.fname_" + ctx.getLocale();
        sql.append("select fcurrencyid,").append(currencyField).append(" as currencyName,sum(fadjustfor) as adjustfor,sum(fadjustlocal) as adjustlocal,sum(fadjustrpt) as adjustrpt,        \r\n").append("sum(fadjustqty) as adjustqty from t_bks_balanceadjust   \r\n").append("inner join t_bd_currency b on b.fid=fcurrencyid        \r\n").append("where forgunitid=? and ftype=?  group by fcurrencyid,").append(currencyField);
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{companyId, type + ""});
        StringBuffer errSb = new StringBuffer("\n");
        try {
            while (rowSet.next()) {
                BigDecimal adjustQty;
                String currency = rowSet.getString("currencyName");
                BigDecimal adjustFor = rowSet.getBigDecimal("adjustfor") == null ? InitHelp.zero : rowSet.getBigDecimal("adjustfor");
                BigDecimal adjustLocal = rowSet.getBigDecimal("adjustlocal") == null ? InitHelp.zero : rowSet.getBigDecimal("adjustlocal");
                BigDecimal adjustRpt = rowSet.getBigDecimal("adjustrpt") == null ? InitHelp.zero : rowSet.getBigDecimal("adjustrpt");
                BigDecimal bigDecimal = adjustQty = rowSet.getBigDecimal("adjustqty") == null ? InitHelp.zero : rowSet.getBigDecimal("adjustqty");
                if (adjustFor.compareTo(InitHelp.zero) != 0) {
                    errSb.append(currency).append(" ").append(ResourceBase.getString((String)RESOURCE_PATH, (String)"CurrencyFor", (Locale)ctx.getOriginLocale())).append(" ").append(adjustFor).append("\n");
                }
                if (adjustLocal.compareTo(InitHelp.zero) != 0) {
                    errSb.append(currency).append(" ").append(ResourceBase.getString((String)RESOURCE_PATH, (String)"CurrencyLocal", (Locale)ctx.getOriginLocale())).append(" ").append(adjustLocal).append("\n");
                }
                if (adjustRpt.compareTo(InitHelp.zero) != 0) {
                    errSb.append(currency).append(" ").append(ResourceBase.getString((String)RESOURCE_PATH, (String)"CurrencyRpt", (Locale)ctx.getOriginLocale())).append(" ").append(adjustRpt).append("\n");
                }
                if (adjustQty.compareTo(InitHelp.zero) == 0) continue;
                errSb.append(currency).append(" ").append(ResourceBase.getString((String)RESOURCE_PATH, (String)"Qty", (Locale)ctx.getOriginLocale())).append(" ").append(adjustLocal).append("\n");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (errSb.length() > 2) {
            Object[] params = new Object[]{errSb.toString()};
            throw new AccountBooksException(AccountBooksException.BALANCE_NOT_EQUAL, params);
        }
        return false;
    }

    @Override
    protected ArrayList _getBalanceList(Context ctx, HashMap otherCtx) throws BOSException, EASBizException {
        String cuid = otherCtx.get("CUID").toString();
        String acctTableId = otherCtx.get("ACCOUNTTABLEID").toString();
        int type = Integer.parseInt(otherCtx.get("type").toString());
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)otherCtx.get("COMPANY");
        String companyId = company.getId().toString();
        CurrencyInfo curCurrency = (CurrencyInfo)otherCtx.get("curcurrency");
        String currencyId = curCurrency.getId().toString();
        String loc = ctx.getLocale().getLanguage();
        StringBuffer sql = new StringBuffer();
        sql.append("select bal.*,acct.fid as acctid,acct.fname_").append(loc).append(" as fname,acct.fnumber,acct.flongnumber,acct.fdc,acct.fisqty,acct.fbw,mu.fname_").append(ctx.getLocale()).append(" as measurename ,mu.fid as measureid ").append(" from t_bks_balanceadjust bal   \r\n").append("   inner join t_bd_accountview acct on acct.fid=bal.faccountid \r\n").append("   left join t_bd_measureunitgroup measureunitgroup on acct.fmeasureunitgroupid=measureunitgroup.fid  \r\n").append("   left join t_bd_measureunit mu on mu.fid=measureunitgroup.fdefaultunitid \r\n").append("   where bal.forgunitid=? and bal.fcurrencyid=? and  bal.ftype=? \r\n");
        if (type == 1) {
            sql.append("  order by acct.fnumber");
            Object[] objs = new Object[]{companyId, currencyId, new Integer(type)};
            return this.fetchBalanceFromDB(ctx, false, company, curCurrency, null, null, sql, objs);
        }
        AsstAccountInfo asstAccount = null;
        AsstActTypeCollection tcol = null;
        ArrayList<String> disList = null;
        IGLGeneralFacade general = null;
        asstAccount = (AsstAccountInfo)otherCtx.get("asstaccount");
        if (asstAccount == null) {
            return new ArrayList();
        }
        tcol = (AsstActTypeCollection)asstAccount.get("asstTypeCol");
        disList = new ArrayList<String>();
        SelectorItemCollection selector = new SelectorItemCollection();
        if (tcol != null) {
            for (int i = 0; i < tcol.size(); ++i) {
                String asstHGAttribute = tcol.get(i).getAsstHGAttribute();
                selector.add(new SelectorItemInfo(asstHGAttribute + ".id"));
                disList.add(asstHGAttribute);
            }
        }
        general = GLGeneralFacadeFactory.getLocalInstance(ctx);
        sql.append("and bal.FAccountID=?  order by acct.fnumber  ");
        IObjectCollection coll = this.getAccountFromAsstAccount(ctx, asstAccount.getId().toString(), cuid, acctTableId, null);
        ArrayList list = new ArrayList();
        for (int i = 0; i < coll.size(); ++i) {
            AccountViewInfo account = (AccountViewInfo)coll.getObject(i);
            Object[] objs = new Object[]{companyId, currencyId, new Integer(type), account.getId().toString()};
            list.addAll(this.fetchBalanceFromDB(ctx, true, company, curCurrency, disList, general, sql, objs));
        }
        return list;
    }

    private ArrayList fetchBalanceFromDB(Context ctx, boolean needAssgrp, CompanyOrgUnitInfo company, CurrencyInfo curCurrency, List disList, IGLGeneralFacade general, StringBuffer sql, Object[] objs) throws BOSException, EASBizException {
        ArrayList<BalanceAdjustInfo> col = new ArrayList<BalanceAdjustInfo>();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])objs);
        if (rs != null) {
            try {
                while (rs.next()) {
                    BalanceAdjustInfo data = new BalanceAdjustInfo();
                    AccountViewInfo account = new AccountViewInfo();
                    data.setId(BOSUuid.read((String)rs.getString("fid")));
                    data.setType(BalanceEnum.getEnum((int)rs.getInt("ftype")));
                    data.setBeginFor(rs.getBigDecimal("fbeginfor"));
                    data.setBeginLocal(rs.getBigDecimal("fbeginlocal"));
                    data.setBeginRpt(rs.getBigDecimal("fbeginrpt"));
                    data.setBeginQty(rs.getBigDecimal("fbeginqty"));
                    data.setAdjustFor(rs.getBigDecimal("fadjustfor"));
                    data.setAdjustLocal(rs.getBigDecimal("fadjustlocal"));
                    data.setAdjustRpt(rs.getBigDecimal("fadjustrpt"));
                    data.setAdjustQty(rs.getBigDecimal("fadjustqty"));
                    data.setEndFor(rs.getBigDecimal("fendfor"));
                    data.setEndLocal(rs.getBigDecimal("fendlocal"));
                    data.setEndRpt(rs.getBigDecimal("fendrpt"));
                    data.setEndQty(rs.getBigDecimal("fendqty"));
                    data.setYearBeginDebitFor(rs.getBigDecimal("fYearBeginDebitfor"));
                    data.setYearBeginDebitLocal(rs.getBigDecimal("fYearBeginDebitlocal"));
                    data.setYearBeginDebitRpt(rs.getBigDecimal("fYearBeginDebitrpt"));
                    data.setYearBeginDebitQty(rs.getBigDecimal("fYearBeginDebitqty"));
                    data.setYearBeginCreditFor(rs.getBigDecimal("fYearBeginCreditfor"));
                    data.setYearBeginCreditLocal(rs.getBigDecimal("fYearBeginCreditlocal"));
                    data.setYearBeginCreditRpt(rs.getBigDecimal("fYearBeginCreditrpt"));
                    data.setYearBeginCreditQty(rs.getBigDecimal("fYearBeginCreditqty"));
                    data.setYearAdjustDebitFor(rs.getBigDecimal("fYearAdjustDebitfor"));
                    data.setYearAdjustDebitLocal(rs.getBigDecimal("fYearAdjustDebitlocal"));
                    data.setYearAdjustDebitRpt(rs.getBigDecimal("fYearAdjustDebitrpt"));
                    data.setYearAdjustDebitQty(rs.getBigDecimal("fYearAdjustDebitqty"));
                    data.setYearAdjustCreditFor(rs.getBigDecimal("fYearAdjustCreditfor"));
                    data.setYearAdjustCreditLocal(rs.getBigDecimal("fYearAdjustCreditlocal"));
                    data.setYearAdjustCreditRpt(rs.getBigDecimal("fYearAdjustCreditrpt"));
                    data.setYearAdjustCreditQty(rs.getBigDecimal("fYearAdjustCreditqty"));
                    data.setYearEndDebitFor(rs.getBigDecimal("fYearEndDebitfor"));
                    data.setYearEndDebitLocal(rs.getBigDecimal("fYearEndDebitlocal"));
                    data.setYearEndDebitRpt(rs.getBigDecimal("fYearEndDebitrpt"));
                    data.setYearEndDebitQty(rs.getBigDecimal("fYearEndDebitqty"));
                    data.setYearEndCreditFor(rs.getBigDecimal("fYearEndCreditfor"));
                    data.setYearEndCreditLocal(rs.getBigDecimal("fYearEndCreditlocal"));
                    data.setYearEndCreditRpt(rs.getBigDecimal("fYearEndCreditrpt"));
                    data.setYearEndCreditQty(rs.getBigDecimal("fYearEndCreditqty"));
                    account.setId(BOSUuid.read((String)rs.getString("acctid")));
                    account.setNumber(rs.getString("fnumber"));
                    account.setLongNumber(rs.getString("flongnumber"));
                    account.setName(rs.getString("fname"));
                    account.setDC(BalanceDirectionEnum.getEnum((int)rs.getInt("fdc")));
                    account.setIsQty(rs.getInt("fisqty") == 1);
                    account.setBw(rs.getInt("fbw") == 1);
                    MeasureUnitInfo measure = new MeasureUnitInfo();
                    if (rs.getString("measureid") != null) {
                        measure.setName(rs.getString("measurename"));
                        measure.setId(BOSUuid.read((String)rs.getString("measureid")));
                    }
                    account.setMeasureUnitID(measure);
                    data.setAccount(account);
                    data.setOrgUnit(company);
                    data.setCurrency(curCurrency);
                    data.setBizNumber(rs.getString("fbizNumber"));
                    if (needAssgrp) {
                        String fassgrpid = rs.getString("fassistgrpid");
                        AssistantHGInfo item = new AssistantHGInfo();
                        item.setId(BOSUuid.read((String)fassgrpid));
                        AssistantHGInfo hgInfo = new AssistantHGInfo();
                        hgInfo.setId(BOSUuid.read((String)fassgrpid));
                        if (disList.size() > 0) {
                            for (int i = 0; i < disList.size(); ++i) {
                                String key = (String)disList.get(i);
                                HashMap<String, String> param = new HashMap<String, String>();
                                param.put("asstribute", key);
                                param.put("id", fassgrpid);
                                Map result = general.dealTask("GetDataBaseInfo", param);
                                if (result == null) continue;
                                ObjectBaseInfo dbInfo = (ObjectBaseInfo)result.get("DataBaseInfo");
                                hgInfo.put(key, (Object)dbInfo);
                            }
                        }
                        data.setAssistGrp(hgInfo);
                    }
                    col.add(data);
                }
            }
            catch (SQLException e) {
                new BOSException((Throwable)e);
            }
        }
        return col;
    }

    protected IObjectCollection getAllAssistAccountBySql(Context ctx, HashMap otherCtx) throws BOSException, SQLException {
        AsstAccountCollection result = new AsstAccountCollection();
        String companyId = ((CompanyOrgUnitInfo)otherCtx.get("COMPANY")).getId().toString();
        String accouttable = (String)otherCtx.get("ACCOUNTTABLEID");
        String loc = ctx.getLocale().getLanguage();
        String sql = "select    asstAccount.fid as asstAccountId,asstAccount.fcount as asstcount,asstAccount.fnumber as asstAccountNumber,asstAccount.fname_" + loc + " as asstAccountName ,asstAccount.fisqty,asstAccount.fmeasureunitid ,asstAccount.fmeasureunitgroupid, asstActType.fid as asstActTypeId,   \n asstActType.fname_" + loc + " as asstActTypeName ,asstActType.fnumber asstActTypeNumber,asstActType.fdefaultf7ui,asstActType.fasstHGAttribute,asstActType.fdefaultQueryName,\n asstActType.fisForCompany,asstActType.fIsMultilevel,asstActType.fglAsstActTypeGrpid,asstActType.frealtionDataObject,asstActType.fmappingFieldName,m.fname_" + loc + " as fmeasureunitname,m.fcoefficient,b.fac \n from t_bd_asstactgroupdetail a   \n inner join t_bd_accountview b on b.fcaa = a.fasstaccountid\n inner join t_bd_asstaccount asstAccount on a.fasstaccountid = asstAccount.fid   \n inner join t_bd_asstacttype asstActType on a.fasstActTypeid = asstActType.fid   \n left join t_bd_measureunit m on asstAccount.fmeasureunitid=m.fid \n where b.Fcompanyid=? and b.faccounttableid=? and b.fisleaf=1    \n";
        IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{companyId, accouttable});
        if (set != null) {
            HashMap<String, AsstAccountInfo> cache = new HashMap<String, AsstAccountInfo>();
            while (set.next()) {
                String asstid = set.getString("asstAccountId");
                AsstAccountInfo temp = null;
                if (cache.containsKey(asstid)) {
                    temp = (AsstAccountInfo)cache.get(asstid);
                    if (set.getBoolean("fac")) {
                        temp.setBoolean("isAc", true);
                    }
                } else {
                    temp = new AsstAccountInfo();
                    temp.setId(BOSUuid.read((String)asstid));
                    temp.setNumber(set.getString("asstAccountNumber"));
                    temp.setCount(set.getInt("asstcount"));
                    temp.setName(set.getString("asstAccountName"));
                    temp.put("asstTypeCol", (Object)new AsstActTypeCollection());
                    temp.setIsQty(set.getBoolean("fisqty"));
                    temp.setBoolean("isAc", set.getBoolean("fac"));
                    if (set.getString("fmeasureunitid") != null) {
                        MeasureUnitInfo unit = new MeasureUnitInfo();
                        unit.setId(BOSUuid.read((String)set.getString("fmeasureunitid")));
                        unit.setName(set.getString("fmeasureunitname"));
                        unit.setCoefficient(set.getBigDecimal("fcoefficient"));
                        temp.setMeasureUnit(unit);
                    }
                    if (set.getString("fmeasureunitgroupid") != null) {
                        MeasureUnitGroupInfo unitGroup = new MeasureUnitGroupInfo();
                        unitGroup.setId(BOSUuid.read((String)set.getString("fmeasureunitgroupid")));
                        temp.setMeasureUnitGroup(unitGroup);
                    }
                    result.add(temp);
                    cache.put(asstid, temp);
                }
                AsstActTypeInfo type = new AsstActTypeInfo();
                type.setId(BOSUuid.read((String)set.getString("asstActTypeId")));
                type.setNumber(set.getString("asstActTypeNumber"));
                type.setName(set.getString("asstActTypeName"));
                type.setAsstHGAttribute(set.getString("fasstHGAttribute"));
                type.setMappingFieldName(set.getString("fmappingFieldName"));
                type.setDefaultQueryName(set.getString("fdefaultQueryName"));
                type.setRealtionDataObject(set.getString("frealtionDataObject"));
                type.setDefaultF7UI(set.getString("fdefaultf7ui"));
                type.setIsForCompany(set.getBoolean("fisForCompany"));
                type.setIsMultilevel(set.getBoolean("fIsMultilevel"));
                String fglAsstActTypeGrpid = set.getString("fglAsstActTypeGrpid");
                if (fglAsstActTypeGrpid != null) {
                    GeneralAsstActTypeGroupInfo info = new GeneralAsstActTypeGroupInfo();
                    info.setId(BOSUuid.read((String)fglAsstActTypeGrpid));
                    type.setGlAsstActTypeGrp(info);
                }
                ((AsstActTypeCollection)temp.get("asstTypeCol")).add(type);
            }
        }
        return result;
    }

    private boolean isInitClosed(Context ctx, String orgUnitId) throws BOSException {
        IGLFlag flag = GLFlagFactory.getLocalInstance(ctx);
        return flag.getGLInitClosed(orgUnitId);
    }

    private String[] getAllAstInitClosed(Context ctx, HashMap otherCtx) throws BOSException {
        String orgUnitId = ((CompanyOrgUnitInfo)otherCtx.get("COMPANY")).getId().toString();
        IGLFlag flag = GLFlagFactory.getLocalInstance(ctx);
        String[] result = flag.getAllAstInitClosed(orgUnitId);
        return result;
    }

    private String[] getAllCussentInitClosed(Context ctx, HashMap otherCtx) throws BOSException {
        String orgUnitId = ((CompanyOrgUnitInfo)otherCtx.get("COMPANY")).getId().toString();
        IGLFlag flag = GLFlagFactory.getLocalInstance(ctx);
        String[] result = flag.getAllCussentInitClosed(orgUnitId);
        return result;
    }
}

