/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.books.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.attachment.BoAttchAssoFactory;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexLockType;
import com.kingdee.eas.base.netctrl.MutexParameter;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.books.AbstractAccountRuleInfo;
import com.kingdee.eas.fi.books.AccountBooksException;
import com.kingdee.eas.fi.books.AccountRuleFactory;
import com.kingdee.eas.fi.books.AccountRuleInfo;
import com.kingdee.eas.fi.books.AcountSchemeInfo;
import com.kingdee.eas.fi.books.VoucherMessageFactory;
import com.kingdee.eas.fi.books.VoucherMessageInfo;
import com.kingdee.eas.fi.books.VoucherTranseException;
import com.kingdee.eas.fi.books.app.AbstractVoucherMessageControllerBean;
import com.kingdee.eas.fi.books.util.BooksRuleInfo;
import com.kingdee.eas.fi.books.util.BooksUtil;
import com.kingdee.eas.fi.gl.AcctCussentHistoryFacadeFactory;
import com.kingdee.eas.fi.gl.GLPeriodEndFacadeFactory;
import com.kingdee.eas.fi.gl.GlParam;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.IGLPeriodEndFacade;
import com.kingdee.eas.fi.gl.VoucherCollection;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.VoucherOperateStatusEnum;
import com.kingdee.eas.fi.gl.VoucherStatusEnum;
import com.kingdee.eas.fi.gl.app.GLActionListener;
import com.kingdee.eas.fi.gl.app.VoucherUtil;
import com.kingdee.eas.fi.gl.app.voucher.BookUtil;
import com.kingdee.eas.fi.gl.cache.VoucherProcessCache;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.Uuid;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class VoucherMessageControllerBean
extends AbstractVoucherMessageControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.books.app.VoucherMessageControllerBean");
    private static final String CANNOT_OPER_AFTER_VERIFIED = "81-373";
    private static final String REVERSED_VCH_NOT_DEL = "81-234";
    private static final String AC_ASST_CHANGED = "81-038";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean _transferVoucher(Context ctx, String vmId, CompanyOrgUnitInfo transferOrg) throws BOSException, EASBizException {
        VoucherMessageInfo voucherMessage = (VoucherMessageInfo)this.getValue(ctx, (IObjectPK)new ObjectUuidPK(vmId));
        String vchId = voucherMessage.getSrcVoucher().getId().toString();
        AcountSchemeInfo acountScheme = BooksUtil.getCurrentBook((Context)ctx, (String)transferOrg.getId().toString());
        CompanyOrgUnitInfo masterCompany = BooksUtil.getCurrentMasterCompany((Context)ctx, (CompanyOrgUnitInfo)transferOrg);
        BooksRuleInfo ruleInfo = AccountRuleFactory.getLocalInstance((Context)ctx).getRuleS(acountScheme.getId().toString(), masterCompany);
        Object accoutRuleInfo = ruleInfo.getProperties().get("B001");
        if (accoutRuleInfo == null) {
            throw new AccountBooksException(AccountBooksException.STARTACCOUNTRULE);
        }
        if (VoucherUtil._checkHasTransfered(ctx, vchId, acountScheme.getId().toString())) {
            throw new VoucherTranseException(VoucherTranseException.HASTRANSFERED);
        }
        String cacheId = BOSUuid.create((String)"ABCD1234").toString();
        try {
            VoucherProcessCache.initCache(ctx, cacheId);
            String filter = null;
            Class<AbstractAccountRuleInfo> clazz = AbstractAccountRuleInfo.class;
            try {
                Method method = clazz.getMethod("getFilter", new Class[0]);
                if (!(accoutRuleInfo instanceof AccountRuleInfo)) {
                    // empty if block
                }
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            if (transferOrg.getBaseCurrency() != null && transferOrg.getBaseCurrency().getId() != null) {
                transferOrg.setBaseCurrency(this.getCurrencyInfo(ctx, transferOrg.getBaseCurrency().getId().toString()));
            }
            if (transferOrg.getReportCurrency() != null && transferOrg.getReportCurrency().getId() != null) {
                transferOrg.setReportCurrency(this.getCurrencyInfo(ctx, transferOrg.getReportCurrency().getId().toString()));
            }
            BookUtil.transferVoucherByVoucherMessage(ctx, vchId, transferOrg, filter);
            return true;
        }
        catch (EASBizException e) {
            if (e instanceof CodingRuleException) {
                throw e;
            }
            logger.error((Object)e);
            return true;
        }
        catch (BOSException e) {
            logger.error((Object)("Books Repeated Importing Error\uff1a" + e.getMessage()));
            return true;
        }
        finally {
            VoucherProcessCache.clearCache(ctx, cacheId);
        }
    }

    @Override
    protected IObjectValue _traceUp(Context ctx, String vmId) throws BOSException, EASBizException {
        VoucherMessageInfo voucherMessage = (VoucherMessageInfo)this.getValue(ctx, (IObjectPK)new ObjectUuidPK(vmId));
        String vchid = voucherMessage.getSrcVoucher().getId().toString();
        VoucherInfo voucherInfo = (VoucherInfo)VoucherFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectUuidPK(vchid));
        return voucherInfo;
    }

    @Override
    protected IObjectValue _traceDown(Context ctx, String vmId) throws BOSException, EASBizException {
        VoucherMessageInfo voucherMessage = (VoucherMessageInfo)this.getValue(ctx, (IObjectPK)new ObjectUuidPK(vmId));
        if (voucherMessage.isIsSuc()) {
            String vchid = voucherMessage.getTagVoucher().getId().toString();
            VoucherInfo voucherInfo = (VoucherInfo)VoucherFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectUuidPK(vchid));
            return voucherInfo;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean _transferVoucher(Context ctx, List idList, CompanyOrgUnitInfo transferOrg) throws BOSException, EASBizException {
        boolean isSuc = true;
        AcountSchemeInfo acountScheme = BooksUtil.getCurrentBook((Context)ctx, (String)transferOrg.getId().toString());
        CompanyOrgUnitInfo masterCompany = BooksUtil.getCurrentMasterCompany((Context)ctx, (CompanyOrgUnitInfo)transferOrg);
        BooksRuleInfo ruleInfo = AccountRuleFactory.getLocalInstance((Context)ctx).getRuleS(acountScheme.getId().toString(), masterCompany);
        Object accoutRuleInfo = ruleInfo.getProperties().get("B001");
        if (accoutRuleInfo == null) {
            throw new AccountBooksException(AccountBooksException.STARTACCOUNTRULE);
        }
        String filter = null;
        Class<AbstractAccountRuleInfo> clazz = AbstractAccountRuleInfo.class;
        try {
            Method method = clazz.getMethod("getFilter", new Class[0]);
            if (!(accoutRuleInfo instanceof AccountRuleInfo)) {
                // empty if block
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        int i = 0;
        int count = idList.size();
        while (i < count) {
            VoucherMessageFactory.getLocalInstance(ctx).tranferVou(idList.get(i).toString(), transferOrg, acountScheme.getId().toString(), filter);
            ++i;
        }
        return isSuc;
    }

    @Override
    protected String _batchCancelImportVoucher(Context ctx, List idList, CompanyOrgUnitInfo transferOrg) throws BOSException, EASBizException {
        StringBuffer str = new StringBuffer();
        String msg = new String();
        String transferOrgId = transferOrg.getId().toString();
        String bookid = BooksUtil.getCurrentBook((Context)ctx, (String)transferOrgId).getId().toString();
        for (int i = 0; i < idList.size(); ++i) {
            VoucherInfo info = (VoucherInfo)idList.get(i);
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)transferOrgId));
            String sql = " select FTagVoucherID from T_BKS_VoucherMessage where FisSuc = 1 and FaccountSchemeID='" + bookid + "' and FSrcVoucherID = '" + info.getId().toString() + "'";
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)sql, CompareType.INNER));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("period.periodNumber"));
            sic.add(new SelectorItemInfo("period.periodYear"));
            sic.add(new SelectorItemInfo("voucherType.*"));
            sic.add(new SelectorItemInfo("creator.name"));
            sic.add(new SelectorItemInfo("bookedDate"));
            sic.add(new SelectorItemInfo("bizStatus"));
            sic.add(new SelectorItemInfo("voucherAbstract"));
            sic.add(new SelectorItemInfo("sourceSys"));
            sic.add(new SelectorItemInfo("sourceType"));
            sic.add(new SelectorItemInfo("localDebitAmount"));
            sic.add(new SelectorItemInfo("localCreditAmount"));
            evi.setSelector(sic);
            evi.setFilter(filter);
            VoucherCollection collection = VoucherFactory.getLocalInstance((Context)ctx).getVoucherCollection(evi);
            info = collection.get(0);
            IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"update", (BOSObjectType)this.getBOSType(), null, (String)info.getNumber(), (String)"books_voucherCancelimp");
            boolean isReverse = this.isReverse(ctx, info.getId().toString());
            if (isReverse) {
                msg = ResourceBase.getString((String)"com.kingdee.eas.fi.books.VoucherCancelImpResource", (String)"REVERSED", (Locale)ctx.getOriginLocale());
                msg = MessageFormat.format(msg, info.getVoucherType().getName() + "-" + info.getNumber());
                str.append(msg);
                str.append("\n");
                continue;
            }
            if (BookUtil._existBotRelation(ctx, info.getId().toString(), info.getBOSType())) {
                msg = ResourceBase.getString((String)"com.kingdee.eas.fi.books.VoucherCancelImpResource", (String)"ISADJUST", (Locale)ctx.getOriginLocale());
                msg = MessageFormat.format(msg, info.getVoucherType().getName() + "-" + info.getNumber());
                str.append(msg);
                str.append("\n");
                continue;
            }
            this.cancelImportVoucher(ctx, info.getId().toString(), transferOrg);
            LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
        }
        return str.toString();
    }

    private boolean cancelImportVoucher(Context ctx, String id, CompanyOrgUnitInfo transferOrg) throws BOSException, EASBizException {
        VoucherMessageControllerBean.deleteVoucher(ctx, id, transferOrg);
        this._deleteVoucherMessageByTagVoucher(ctx, (IObjectPK)new ObjectUuidPK(id));
        return false;
    }

    @Override
    protected void _deleteVoucherMessageByTagVoucher(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        VoucherMessageFactory.getLocalInstance(ctx).delete("where tagVoucher = '" + pk.toString() + "'");
    }

    protected boolean checkACNoticeCorrelation(Context ctx, String vchId) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT TOP 1 V.FNUMBER FNUMBER,VT.FNAME_");
        sql.append(LocaleUtils.getLocaleString((Locale)ctx.getLocale())).append(" FNAME");
        sql.append(" FROM T_CSL_Requisition REQ");
        sql.append(" INNER JOIN T_CSL_RequisitionEntry REQE ON REQ.FID = REQE.FRequisitionID");
        sql.append(" INNER JOIN T_GL_VOUCHER V ON V.FID=REQ.FVOUCHERID ");
        sql.append(" INNER JOIN T_BD_VOUCHERTYPES VT ON VT.FID=V.FVOUCHERTYPEID ");
        sql.append(" WHERE REQ.FVoucherid = ?");
        sql.append(" AND (REQE.FStatus = 2 OR REQ.FFiVouchered = 1)");
        IRowSet rst = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{vchId});
        try {
            if (rst.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return false;
    }

    public boolean isReverse(Context ctx, String id) throws BOSException {
        StringBuffer sqlReverse = new StringBuffer();
        sqlReverse.append("select fid from t_gl_voucher where fsourcebillid=? and FIsReverseVoucher=?");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlReverse.toString(), (Object[])new Object[]{id, new Integer(1)});
        try {
            if (rs.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return false;
    }

    public boolean hasVerified(Context ctx, String id) throws BOSException, EASBizException {
        String sql = "select FAccountSchemeID,Fcompanyid,FSrcVoucherID from T_BKS_VoucherMessage where FIsSuc=1 and FTAGVOUCHERID=? ";
        IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{id});
        String transCompanyId = null;
        VoucherInfo voucher = (VoucherInfo)VoucherFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectUuidPK(id), VoucherInfo.getNumberSelector());
        try {
            while (set != null && set.next()) {
                boolean isInTimeVerify;
                transCompanyId = set.getString(2);
                boolean bl = isInTimeVerify = GlUtils.getVerifyMode(ctx, transCompanyId) == 0;
                if (!isInTimeVerify) {
                    boolean hasVerified = AcctCussentHistoryFacadeFactory.getLocalInstance(ctx).hasVerify(id);
                    if (!hasVerified) continue;
                    return true;
                }
                if (!VoucherOperateStatusEnum.POST.equals((Object)voucher.getBizStatus())) continue;
                StringBuffer checksql = new StringBuffer();
                checksql.append("select ve.FSeq as FEntrySeq,vast.FSeq as FAsstSeq\t\r\n");
                checksql.append("from t_gl_VoucherAssistRecord vast,                 \r\n");
                checksql.append("\tt_gl_VoucherEntry ve,                           \r\n");
                checksql.append("\tt_GL_AcctCussent cust,                          \r\n");
                checksql.append("\tt_gl_VoucherAssistRecord vast2 ,                 \r\n");
                checksql.append("\tt_gl_Voucher v\t                          \r\n");
                checksql.append("where vast.FEntryID = ve.FID                        \r\n");
                checksql.append("\tand vast.FID = cust.FVchAssistRecordID          \r\n");
                checksql.append("\tand vast.FBillID = ?                            \r\n");
                checksql.append("\tand vast2.FVerifiedCussentID = cust.FID         \r\n");
                checksql.append("\tand vast2.FBillID = v.FID    and v.fbizstatus<>2 ;");
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)checksql.toString(), (Object[])new Object[]{id});
                if (!rs.next()) continue;
                return true;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return false;
    }

    private static void deleteVoucher(Context ctx, String id, CompanyOrgUnitInfo transferOrg) throws EASBizException, BOSException {
        IGLPeriodEndFacade iGLPeriodEndFacade = GLPeriodEndFacadeFactory.getLocalInstance(ctx);
        VoucherInfo tagvoucher = (VoucherInfo)VoucherFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectUuidPK(id));
        String sql = "select FAccountSchemeID,Fcompanyid,FSrcVoucherID from T_BKS_VoucherMessage where FIsSuc=1 and FTAGVOUCHERID=? ";
        IRowSet set = null;
        String[] paramList = new String[]{"G001"};
        GlParam glParam = GlParam.getGlParams((Context)ctx, (String[])paramList, (String)transferOrg.getId().toString());
        boolean useReport = glParam.getBoolean("G001");
        String transCompanyId = null;
        String tagVoucherid = tagvoucher.getId().toString();
        String srcVoucherID = null;
        try {
            set = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{tagVoucherid});
            while (set != null && set.next()) {
                List beforeListeners;
                transCompanyId = set.getString(2);
                srcVoucherID = set.getString(3);
                VoucherInfo voucher = (VoucherInfo)VoucherFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectUuidPK(tagVoucherid), VoucherInfo.getNumberSelector());
                iGLPeriodEndFacade.postVoucherOnBook(tagvoucher.getCompany().getCU().getId().toString(), transCompanyId, new String[]{tagVoucherid}, useReport, 1, true);
                if (voucher.getBizStatus() == VoucherStatusEnum.POSTED) {
                    iGLPeriodEndFacade.postVoucherOnBook(tagvoucher.getCompany().getCU().getId().toString(), transCompanyId, new String[]{tagVoucherid}, useReport, 5, true);
                }
                if ((beforeListeners = VoucherMessageControllerBean.getDeleteActionBeforeListeners(ctx)) != null) {
                    for (Object beforeListener : beforeListeners) {
                        ((GLActionListener)beforeListener).actionPerformed(ctx, voucher);
                    }
                }
                voucher.setId(BOSUuid.read((String)tagVoucherid));
                VoucherUtil._deleteAllAcctcussent(ctx, voucher);
                VoucherUtil._deleteAllCashflowRecords(ctx, voucher);
                VoucherUtil._deleteAllCashflowSplitRecords(ctx, voucher);
                VoucherUtil._deleteAllAssistRecords(ctx, voucher);
                VoucherUtil._deleteAllEntries(ctx, voucher);
                VoucherUtil._deleteVoucher(ctx, voucher);
                VoucherUtil._removeBotRelation(ctx, srcVoucherID, tagVoucherid, voucher.getBOSType());
                BoAttchAssoFactory.getLocalInstance((Context)ctx).deleteAllAssociationsByBoID(tagVoucherid);
                List afterListeners = VoucherMessageControllerBean.getDeleteActionAfterListeners(ctx);
                if (afterListeners == null) continue;
                for (Object afterListener : afterListeners) {
                    ((GLActionListener)afterListener).actionPerformed(ctx, voucher);
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
            throw new BOSException((Throwable)e);
        }
    }

    public static MutexParameter buildTransferVoucherParameter(Context ctx, String voucherID, String transferOrgID) {
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        MutexParameter mp = new MutexParameter();
        Uuid requestId = Uuid.create();
        mp.setRequestId(requestId);
        String actionName = EASResource.getString((String)"com.kingdee.eas.fi.gl.GLResource", (String)"VoucherMessageImp", (Locale)ctx.getLocale());
        mp.setMutexName("books_mutexlock_transferVoucher_" + voucherID + "_" + transferOrgID);
        mp.setActionName(actionName);
        mp.setOrgUnitID(BOSUuid.read((String)transferOrgID));
        mp.setUserID(BOSUuid.read((String)userId));
        mp.setMutexLockType(MutexLockType.EXCLUSIVE_LOCK);
        mp.setDcName(ctx.getAIS());
        mp.setDescription(actionName);
        return mp;
    }

    @Override
    protected boolean _tranferVou(Context ctx, String VoucherID, CompanyOrgUnitInfo transferOrg, String acountSchemeID, String filter) throws BOSException, EASBizException {
        boolean isSucceed = false;
        IMutexServiceControl mutex = null;
        MutexParameter mp = null;
        try {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("number"));
            VoucherInfo voucher = (VoucherInfo)VoucherFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectUuidPK(VoucherID), selector);
            mutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
            mp = VoucherMessageControllerBean.buildTransferVoucherParameter(ctx, VoucherID, transferOrg.getId().toString());
            if (mp != null) {
                MutexParameter current = mutex.requestMutex3(mp);
                boolean bl = isSucceed = current == null;
                if (!isSucceed) {
                    throw new EASBizException(new NumericExceptionSubItem("101", MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLResource", (String)"TRANSFER8007", (Locale)ctx.getLocale()), transferOrg.getMainOrg().getName(), voucher.getNumber(), transferOrg.getName())));
                }
            }
            if (VoucherUtil._checkHasTransfered(ctx, VoucherID, acountSchemeID)) {
                boolean current = false;
                return current;
            }
            IObjectPK pk = BookUtil.transferVoucherByVoucherMessage(ctx, VoucherID, transferOrg, filter);
            IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"update", (BOSObjectType)this.getBOSType(), null, (String)voucher.getNumber(), (String)"books_voucherremimp");
            if (pk != null) {
                LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
            }
            isSucceed = true;
        }
        catch (EASBizException e) {
            logger.error((Object)e);
            throw e;
        }
        catch (BOSException e) {
            logger.error((Object)("Books Repeated Importing Error\uff1a" + e.getMessage()));
            throw e;
        }
        finally {
            if (isSucceed && mutex != null && mp != null) {
                mutex.releaseMutex(mp.getRequestId());
            }
        }
        return isSucceed;
    }

    private static List getDeleteActionBeforeListeners(Context ctx) throws BOSException {
        return GLActionListener.getListeners(ctx, "GL_VoucherDelete", "Before");
    }

    private static List getDeleteActionAfterListeners(Context ctx) throws BOSException {
        return GLActionListener.getListeners(ctx, "GL_VoucherDelete", "After");
    }

    private CurrencyInfo getCurrencyInfo(Context ctx, String currencyId) throws EASBizException, BOSException {
        Map<String, Object> datas = VoucherProcessCache.getDatas(ctx, "getCurrencyInfo");
        if (datas.containsKey(currencyId)) {
            return (CurrencyInfo)datas.get(currencyId);
        }
        CurrencyInfo cur = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId));
        datas.put(currencyId, cur);
        return cur;
    }
}

