/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CashFlowDirection;
import com.kingdee.eas.basedata.assistant.CashFlowItemCollection;
import com.kingdee.eas.basedata.assistant.CashFlowItemFactory;
import com.kingdee.eas.basedata.assistant.CashFlowItemInfo;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGFactory;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.GeneralAsstActTypeGroupInfo;
import com.kingdee.eas.basedata.master.auxacct.IAssistantHG;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gl.AsstInitParam;
import com.kingdee.eas.fi.gl.CashFlowDirectFactory;
import com.kingdee.eas.fi.gl.ICashFlowDirect;
import com.kingdee.eas.fi.gl.TAccountCashflowInfo;
import com.kingdee.eas.fi.gl.TAccountInfo;
import com.kingdee.eas.fi.gl.VoucherFacadeFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.client.VoucherSetCashflowUI;
import com.kingdee.eas.fi.gl.client.asstf7.GLF7Parameter;
import com.kingdee.eas.fi.gl.client.asstf7.GLF7handler;
import com.kingdee.eas.fi.gl.common.GLf7Utils;
import java.awt.Color;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class CashFlowDirectUtil {
    private static final Logger logger = Logger.getLogger(CashFlowDirectUtil.class);

    public static boolean isSameAsstAccount(Object owner, Map saveParam) throws EASBizException, BOSException {
        TAccountInfo accountInfo = (TAccountInfo)saveParam.get("accountInfo");
        CashFlowItemInfo item = (CashFlowItemInfo)saveParam.get("CashFlowItemInfo");
        if (item.getAsstAccount() == null || !item.isIsEnable()) {
            return true;
        }
        String accountid = accountInfo.getId();
        if (accountid == null) {
            return false;
        }
        if (accountInfo.getStatus() != 5 || accountInfo.getStatus() != 8 || !new AccountViewInfo().getBOSType().equals((Object)BOSUuid.read((String)accountid).getType())) {
            return false;
        }
        AccountViewInfo view = null;
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("caa.id");
        if (accountInfo.isAssist()) {
            String companyId = SysContext.getSysContext().getCurrentFIUnit().getId().toString();
            String accouttable = SysContext.getSysContext().getCurrentFIUnit().getAccountTable().getId().toString();
            String number = accountInfo.getParent();
            EntityViewInfo v = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("companyId.id", (Object)companyId));
            filter.getFilterItems().add(new FilterItemInfo("accountTableID.id", (Object)accouttable));
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
            v.setFilter(filter);
            AccountViewCollection col = AccountViewFactory.getRemoteInstance().getAccountViewCollection(v);
            view = col.get(0);
        } else {
            ObjectUuidPK pk = new ObjectUuidPK(accountid);
            view = (AccountViewInfo)AccountViewFactory.getRemoteInstance().getValue((IObjectPK)pk, selector);
        }
        if (view == null || view.getCAA() == null) {
            return false;
        }
        HashMap hmDynamicColumnInfo = new HashMap();
        Object[] info = CashFlowDirectUtil.getCachedColumnInfo(hmDynamicColumnInfo, item.getAsstAccount());
        VoucherInfo.DynamicColumnInfo[] assItemCols = (VoucherInfo.DynamicColumnInfo[])info[0];
        Object[] infoAccount = CashFlowDirectUtil.getCachedColumnInfo(hmDynamicColumnInfo, view.getCAA());
        VoucherInfo.DynamicColumnInfo[] assItemColsAccount = null;
        if (infoAccount != null) {
            assItemColsAccount = (VoucherInfo.DynamicColumnInfo[])infoAccount[0];
        }
        return CashFlowDirectUtil.compareItemCols(assItemCols, assItemColsAccount);
    }

    public static void saveCashflow(Map saveParam) throws BOSException, EASBizException {
        CashFlowDirectUtil.getBizInterface().saveCashflowItem(saveParam);
    }

    protected static ICashFlowDirect getBizInterface() throws BOSException {
        return CashFlowDirectFactory.getRemoteInstance();
    }

    public static Object[] getCachedColumnInfo(HashMap hmDynamicColumnInfo, AsstAccountInfo typeGroup) {
        String typeGroupId = null;
        if (typeGroup == null) {
            return null;
        }
        typeGroupId = typeGroup.getId().toString();
        Object[] colInfo = (Object[])hmDynamicColumnInfo.get(typeGroupId);
        try {
            if (colInfo == null) {
                colInfo = VoucherFacadeFactory.getRemoteInstance().fetchAssColumnInfo(null, typeGroupId, null);
                hmDynamicColumnInfo.put(typeGroupId, colInfo);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return colInfo;
    }

    public static Object[] getCachedColumnInfo(HashMap hmDynamicColumnInfo, String typeGroupId) {
        if (typeGroupId == null) {
            return null;
        }
        Object[] colInfo = (Object[])hmDynamicColumnInfo.get(typeGroupId);
        try {
            if (colInfo == null) {
                colInfo = VoucherFacadeFactory.getRemoteInstance().fetchAssColumnInfo(null, typeGroupId, null);
                hmDynamicColumnInfo.put(typeGroupId, colInfo);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return colInfo;
    }

    public static boolean compareItemCols(VoucherInfo.DynamicColumnInfo[] assItemCols, VoucherInfo.DynamicColumnInfo[] assItemColsAccount) {
        for (VoucherInfo.DynamicColumnInfo dynamicColumnInfo : assItemCols) {
            if (assItemColsAccount == null) {
                return false;
            }
            boolean isSame = false;
            int countj = assItemColsAccount.length;
            for (int j = 0; j < countj; ++j) {
                VoucherInfo.DynamicColumnInfo jdynamicColumnInfo = assItemColsAccount[j];
                if (!dynamicColumnInfo.getMappingPropName().equalsIgnoreCase(jdynamicColumnInfo.getMappingPropName())) continue;
                isSame = true;
                return isSame;
            }
        }
        return false;
    }

    public static void setDynamicColumnInfo(KDTable tblOppEntries, IRow row, String key, Object[] info, HashMap hmDynamicPromptBox, CoreUIObject ui) {
        int beginIndexOfAssItem = tblOppEntries.getColumnIndex(key);
        VoucherInfo.DynamicColumnInfo[] assItemCols = (VoucherInfo.DynamicColumnInfo[])info[0];
        for (int i = 0; i < assItemCols.length; ++i) {
            VoucherInfo.DynamicColumnInfo colInfo = assItemCols[i];
            ICell cell = row.getCell(beginIndexOfAssItem);
            FilterInfo filter = null;
            if (colInfo.getMappingPropName().equals("customer") || colInfo.getMappingPropName().equals("provider")) {
                filter = new FilterInfo();
                FilterItemCollection fic = filter.getFilterItems();
                fic.add(new FilterItemInfo("internalCompany.id", null, CompareType.NOTEQUALS));
            }
            cell.setEditor(CashFlowDirectUtil.getCellEditor(hmDynamicPromptBox, colInfo, filter, ui));
            ++beginIndexOfAssItem;
            cell.getStyleAttributes().setLocked(false);
            cell.getStyleAttributes().setBackground(Color.WHITE);
        }
    }

    public static ICellEditor getCellEditor(HashMap hmDynamicPromptBox, VoucherInfo.DynamicColumnInfo colInfo, FilterInfo filter, CoreUIObject ui) {
        KDBizPromptBox bizPromptBox = (KDBizPromptBox)hmDynamicPromptBox.get(colInfo.getId().toString());
        if (bizPromptBox == null) {
            bizPromptBox = new KDBizPromptBox();
            bizPromptBox.setEditable(true);
            bizPromptBox.setEditFormat("$number$");
            bizPromptBox.setDisplayFormat("$number$;$name$");
            bizPromptBox.setCommitFormat("$number$;$name$");
            bizPromptBox.setQueryInfo(colInfo.getDefaultQueryName());
            bizPromptBox.setDefaultF7UIName(colInfo.getDefaultF7UI());
            GLf7Utils.assignInnerCustomer((KDBizPromptBox)bizPromptBox, (GeneralAsstActTypeGroupInfo)colInfo.getGrp(), (String)colInfo.getMappingPropName(), (String)SysContext.getSysContext().getCurrentCtrlUnit().getId().toString(), (FilterInfo)filter, (CoreUIObject)ui, (boolean)colInfo.isUseLongNumber());
            hmDynamicPromptBox.put(colInfo.getId().toString(), bizPromptBox);
        }
        AsstActTypeInfo atInfo = new AsstActTypeInfo();
        atInfo.setId(colInfo.getId());
        atInfo.setAsstHGAttribute(colInfo.getMappingPropName());
        atInfo.setMappingFieldName(colInfo.getMappingFieldName());
        atInfo.setIsMultilevel(colInfo.isMultilevel());
        atInfo.setRealtionDataObject(colInfo.getRealtionDataObject());
        atInfo.setIsForCompany(colInfo.getIsForCompany());
        atInfo.setUseLongNumber(colInfo.isUseLongNumber());
        atInfo.setGlAsstActTypeGrp(colInfo.getGrp());
        atInfo.setDefaultQueryName(colInfo.getDefaultQueryName());
        atInfo.setDefaultF7UI(colInfo.getDefaultF7UI());
        GLF7Parameter f7Param = new GLF7Parameter();
        f7Param.setOnlyLeaf(true);
        f7Param.setGeneralShowLongNumber(colInfo.isUseLongNumber());
        GLF7handler.assignSelector((CoreUIObject)ui, (KDBizPromptBox)bizPromptBox, (AsstActTypeInfo)atInfo, (CompanyOrgUnitInfo)SysContext.getSysContext().getCurrentFIUnit(), (GLF7Parameter)f7Param);
        if ("FCustomerID".equalsIgnoreCase(colInfo.getMappingFieldName()) || "FProviderID".equalsIgnoreCase(colInfo.getMappingFieldName())) {
            EntityViewInfo entityViewInfo = bizPromptBox.getEntityViewInfo();
            FilterInfo filterInfo = entityViewInfo.getFilter();
            FilterInfo tempInfo = new FilterInfo();
            FilterItemCollection fic = tempInfo.getFilterItems();
            if ("FCustomerID".equalsIgnoreCase(colInfo.getMappingFieldName())) {
                fic.add(new FilterItemInfo("CustomerCompanyInfo.usingStatus", (Object)new Integer(0)));
            } else {
                fic.add(new FilterItemInfo("SUPPLIERCOMPANY.usingStatus", (Object)new Integer(0)));
            }
            try {
                filterInfo.mergeFilter(tempInfo, "and");
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        return new KDTDefaultCellEditor((IKDEditor)bizPromptBox);
    }

    public static AssistantHGInfo confirmAssGrp(AsstAccountInfo typeGroup, IRow row, HashMap hmDynamicColumnInfo, String colKey) throws Exception {
        Object[] info = CashFlowDirectUtil.getCachedColumnInfo(hmDynamicColumnInfo, typeGroup);
        if (info == null) {
            return null;
        }
        AssistantHGInfo group = new AssistantHGInfo();
        group.setAsstAccount(typeGroup);
        VoucherInfo.DynamicColumnInfo[] itemCols = (VoucherInfo.DynamicColumnInfo[])info[0];
        VoucherInfo.DynamicColumnInfo colInfo = itemCols[0];
        String key = colInfo.getMappingPropName();
        Object val = row.getCell(colKey).getValue();
        if (val != null) {
            group.put(key, val);
        }
        group = VoucherFacadeFactory.getRemoteInstance().confirmAssGrp(group, typeGroup.getId().toString(), itemCols);
        IAssistantHG igCtrl = AssistantHGFactory.getRemoteInstance();
        group = igCtrl.getAssistantHGInfo((IObjectPK)new ObjectUuidPK(group.getId().toString()));
        return group;
    }

    public static AssistantHGInfo confirmAssGrp(AsstAccountInfo typeGroup, IRow row, HashMap hmDynamicColumnInfo) throws Exception {
        Object[] info = CashFlowDirectUtil.getCachedColumnInfo(hmDynamicColumnInfo, typeGroup);
        if (info == null) {
            return null;
        }
        AssistantHGInfo group = new AssistantHGInfo();
        group.setAsstAccount(typeGroup);
        VoucherInfo.DynamicColumnInfo[] itemCols = (VoucherInfo.DynamicColumnInfo[])info[0];
        boolean isAllNull = true;
        for (int i = 0; i < itemCols.length; ++i) {
            VoucherInfo.DynamicColumnInfo colInfo = itemCols[i];
            String key = colInfo.getMappingPropName();
            Object val = row.getCell(key).getValue();
            if (val == null) continue;
            isAllNull = false;
            group.put(key, val);
        }
        if (isAllNull) {
            return null;
        }
        AssistantHGInfo hg = VoucherFacadeFactory.getRemoteInstance().confirmAssGrp(group, typeGroup.getId().toString(), itemCols);
        if (hg == null) {
            return null;
        }
        group.setId(hg.getId());
        group.setDisplayNameGroup(hg.getDisplayNameGroup());
        return group;
    }

    public static Map showVoucherSetCashflowUI(Object owner, Map saveParam) throws EASBizException, BOSException {
        UIContext uiContext = new UIContext(owner);
        uiContext.put((Object)"saveParam", (Object)saveParam);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.fi.gl.client.VoucherSetCashflowUI", (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
        VoucherSetCashflowUI selectui = (VoucherSetCashflowUI)uiWindow.getUIObject();
        return selectui.getSaveResult();
    }

    public static AsstInitParam loadParam() throws Exception {
        return AsstInitParam.getInstance();
    }

    public static void handleBeforeSave(Map cashflowRecords) throws BOSException {
        Collection cfiColl = cashflowRecords.values();
        Map cfItems = CashFlowDirectUtil.getCashFlowItemMap(cfiColl);
        Iterator itSave = cfiColl.iterator();
        TAccountCashflowInfo info = null;
        CashFlowItemInfo cfItem = null;
        while (itSave.hasNext()) {
            info = (TAccountCashflowInfo)itSave.next();
            cfItem = (CashFlowItemInfo)cfItems.get(info.getCashflowItemId());
            int coef = 1;
            if (info.isEntryDebit() && cfItem.getDirection() == CashFlowDirection.OUT || !info.isEntryDebit() && cfItem.getDirection() == CashFlowDirection.IN) {
                coef = -1;
            }
            info.setPrimaryCoefficient(coef);
        }
    }

    private static Map getCashFlowItemMap(Collection cfItemMap) throws BOSException {
        Iterator it = cfItemMap.iterator();
        HashSet<String> cfItemIdSet = new HashSet<String>();
        TAccountCashflowInfo info = null;
        while (it.hasNext()) {
            info = (TAccountCashflowInfo)it.next();
            cfItemIdSet.add(info.getCashflowItemId());
        }
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add("id");
        view.getSelector().add("direction");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", cfItemIdSet, CompareType.INCLUDE));
        view.setFilter(filter);
        CashFlowItemCollection cfiColl = CashFlowItemFactory.getRemoteInstance().getCashFlowItemCollection(view);
        Iterator cfiIt = cfiColl.iterator();
        HashMap<String, CashFlowItemInfo> cfiMap = new HashMap<String, CashFlowItemInfo>();
        while (cfiIt.hasNext()) {
            CashFlowItemInfo cfi = (CashFlowItemInfo)cfiIt.next();
            cfiMap.put(cfi.getId().toString(), cfi);
        }
        return cfiMap;
    }
}

