/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.eas.basedata.master.account.AccountCategoryEnum;
import com.kingdee.eas.basedata.master.account.AccountDiffType;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.AbstractDiffItemRecordInfo;
import com.kingdee.eas.fi.gl.DiffItemDC;
import com.kingdee.eas.fi.gl.DiffItemInfo;
import com.kingdee.eas.fi.gl.DiffItemMappingFactory;
import com.kingdee.eas.fi.gl.DiffItemMappingInfo;
import com.kingdee.eas.fi.gl.DiffItemRecordCollection;
import com.kingdee.eas.fi.gl.DiffItemRecordFactory;
import com.kingdee.eas.fi.gl.DiffItemRecordInfo;
import com.kingdee.eas.fi.gl.DiffType;
import com.kingdee.eas.fi.gl.EntryDC;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.IDiffItemMapping;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.util.ResourceBase;
import edu.emory.mathcs.backport.java.util.Collections;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class DiffItemUtils {
    public static final Map<String, String> DiffItems = new HashMap<String, String>();
    public static final String RESOURCE = "com.kingdee.eas.fi.gl.GLAutoGenerateResource";

    public static String getResource(Context ctx, String resName) {
        if (ctx == null) {
            return ResourceBase.getString((String)RESOURCE, (String)resName, (Locale)SysContext.getSysContext().getLocale());
        }
        return ResourceBase.getString((String)RESOURCE, (String)resName, (Locale)ctx.getLocale());
    }

    public static SelectorItemCollection getVoucherSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("bizStatus");
        sic.add("sourceType");
        sic.add("diffItemFlag");
        sic.add("lastUpdateTime");
        sic.add("company.id");
        sic.add("entries.id");
        sic.add("entries.seq");
        sic.add("entries.entryDC");
        sic.add("entries.originalAmount");
        sic.add("entries.localAmount");
        sic.add("entries.reportingAmount");
        sic.add("entries.account.id");
        sic.add("entries.account.number");
        sic.add("entries.account.name");
        sic.add("entries.account.longName");
        sic.add("entries.account.isBank");
        sic.add("entries.account.isCash");
        sic.add("entries.account.isCashEquivalent");
        sic.add("entries.account.category");
        sic.add("entries.account.diffType");
        sic.add("entries.currency.id");
        sic.add("entries.currency.number");
        sic.add("entries.currency.name");
        sic.add("entries.currency.precision");
        return sic;
    }

    public static DiffItemRecordCollection getDiffItemRecords(Context ctx, String voucherId) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("diffEntry.id");
        selector.add("diffSeq");
        selector.add("checkEntry.id");
        selector.add("checkSeq");
        selector.add("diffItem.id");
        selector.add("diffItem.number");
        selector.add("diffItem.name");
        selector.add("diffItem.dc");
        selector.add("assignedLocalAmount");
        view.setSelector(selector);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("voucher.id", (Object)voucherId));
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("diffSeq"));
        sorter.add(new SorterItemInfo("checkSeq"));
        view.setSorter(sorter);
        if (ctx != null) {
            return DiffItemRecordFactory.getLocalInstance(ctx).getDiffItemRecordCollection(view);
        }
        return DiffItemRecordFactory.getRemoteInstance().getDiffItemRecordCollection(view);
    }

    public static Map<String, Object> analysis(VoucherInfo voucher) {
        HashMap<String, VoucherEntryInfo> entries = new HashMap<String, VoucherEntryInfo>();
        ArrayList<VoucherEntryInfo> diffEntries = new ArrayList<VoucherEntryInfo>();
        ArrayList<VoucherEntryInfo> fnInEntries = new ArrayList<VoucherEntryInfo>();
        ArrayList<VoucherEntryInfo> fnExEntries = new ArrayList<VoucherEntryInfo>();
        ArrayList<VoucherEntryInfo> bgInEntries = new ArrayList<VoucherEntryInfo>();
        ArrayList<VoucherEntryInfo> bgExEntries = new ArrayList<VoucherEntryInfo>();
        ArrayList<VoucherEntryInfo> checkEntries = new ArrayList<VoucherEntryInfo>();
        BigDecimal fnInAmt = GlUtils.zero;
        BigDecimal bgInAmt = GlUtils.zero;
        BigDecimal fnExAmt = GlUtils.zero;
        BigDecimal bgExAmt = GlUtils.zero;
        for (VoucherEntryInfo entry : voucher.getEntries()) {
            AccountViewInfo account = entry.getAccount();
            if (account == null || entry.getLocalAmount().compareTo(GlUtils.zero) == 0) continue;
            if (AccountCategoryEnum.BUDGET.equals((Object)account.getCategory())) {
                if (AccountDiffType.INCOME.equals((Object)account.getDiffType())) {
                    bgInAmt = EntryDC.CREDIT.equals((Object)entry.getEntryDC()) ? bgInAmt.add(entry.getLocalAmount()) : bgInAmt.subtract(entry.getLocalAmount());
                    diffEntries.add(entry);
                    bgInEntries.add(entry);
                    if (entry.getId() == null) continue;
                    entries.put(entry.getId().toString(), entry);
                    continue;
                }
                if (!AccountDiffType.EXPENSE.equals((Object)account.getDiffType())) continue;
                bgExAmt = EntryDC.CREDIT.equals((Object)entry.getEntryDC()) ? bgExAmt.subtract(entry.getLocalAmount()) : bgExAmt.add(entry.getLocalAmount());
                diffEntries.add(entry);
                bgExEntries.add(entry);
                if (entry.getId() == null) continue;
                entries.put(entry.getId().toString(), entry);
                continue;
            }
            if (AccountDiffType.INCOME.equals((Object)account.getDiffType())) {
                fnInAmt = EntryDC.CREDIT.equals((Object)entry.getEntryDC()) ? fnInAmt.add(entry.getLocalAmount()) : fnInAmt.subtract(entry.getLocalAmount());
                diffEntries.add(entry);
                fnInEntries.add(entry);
                if (entry.getId() == null) continue;
                entries.put(entry.getId().toString(), entry);
                continue;
            }
            if (AccountDiffType.EXPENSE.equals((Object)account.getDiffType())) {
                fnExAmt = EntryDC.CREDIT.equals((Object)entry.getEntryDC()) ? fnExAmt.subtract(entry.getLocalAmount()) : fnExAmt.add(entry.getLocalAmount());
                diffEntries.add(entry);
                fnExEntries.add(entry);
                if (entry.getId() == null) continue;
                entries.put(entry.getId().toString(), entry);
                continue;
            }
            if (account.isIsBank() || account.isIsCash() || account.isIsCashEquivalent()) continue;
            checkEntries.add(entry);
            if (entry.getId() == null) continue;
            entries.put(entry.getId().toString(), entry);
        }
        BigDecimal inDiffAmt = fnInAmt.subtract(bgInAmt);
        BigDecimal exDiffAmt = bgExAmt.subtract(fnExAmt);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("entries", entries);
        result.put("diffEntries", diffEntries);
        result.put("fnInEntries", fnInEntries);
        result.put("fnExEntries", fnExEntries);
        result.put("bgInEntries", bgInEntries);
        result.put("bgExEntries", bgExEntries);
        result.put("checkEntries", checkEntries);
        result.put("fnInAmt", fnInAmt);
        result.put("bgInAmt", bgInAmt);
        result.put("fnExAmt", fnExAmt);
        result.put("bgExAmt", bgExAmt);
        result.put("inDiffAmt", inDiffAmt);
        result.put("exDiffAmt", exDiffAmt);
        return result;
    }

    public static DiffItemRecordCollection transfer(DiffItemRecordCollection diRecords, Map<String, Object> analysis) {
        DiffItemRecordCollection records = new DiffItemRecordCollection();
        Map entries = (Map)analysis.get("entries");
        List diffEntries = (List)analysis.get("diffEntries");
        List checkEntries = (List)analysis.get("checkEntries");
        BigDecimal inDiffAmt = (BigDecimal)analysis.get("inDiffAmt");
        BigDecimal exDiffAmt = (BigDecimal)analysis.get("exDiffAmt");
        Iterator it = diRecords.iterator();
        while (it.hasNext()) {
            DiffItemRecordInfo record = (DiffItemRecordInfo)it.next();
            VoucherEntryInfo diffEntry = record.getDiffEntry();
            VoucherEntryInfo checkEntry = record.getCheckEntry();
            if (diffEntry == null || checkEntry == null || record.getDiffItem() == null) continue;
            if (diffEntry.getId() != null) {
                diffEntry = (VoucherEntryInfo)entries.get(diffEntry.getId().toString());
            }
            if (diffEntry == null || !diffEntries.contains(diffEntry)) continue;
            record.setDiffEntry(diffEntry);
            if (checkEntry.getId() != null) {
                checkEntry = (VoucherEntryInfo)entries.get(checkEntry.getId().toString());
            }
            if (checkEntry == null || !checkEntries.contains(checkEntry)) continue;
            record.setCheckEntry(checkEntry);
            if ((!diffEntry.getAccount().getDiffType().equals((Object)AccountDiffType.INCOME) || inDiffAmt.compareTo(GlUtils.zero) == 0) && (!diffEntry.getAccount().getDiffType().equals((Object)AccountDiffType.EXPENSE) || exDiffAmt.compareTo(GlUtils.zero) == 0)) continue;
            records.add(record);
        }
        return records;
    }

    /*
     * WARNING - void declaration
     */
    public static DiffItemRecordCollection assign(Context ctx, String voucherId, VoucherInfo voucher, Map<String, Object> analysis, Map<String, Object> cache, Map<String, Object> errors, boolean editing) throws BOSException {
        DiffItemRecordInfo record;
        Object record2;
        BigDecimal checkAssigned;
        BigDecimal checkAmtRemain;
        BigDecimal localAmount;
        AbstractDiffItemRecordInfo lastRecord;
        BigDecimal assignedRemain;
        Object assigned;
        void var28_53;
        BigDecimal amt;
        BigDecimal bigDecimal;
        BigDecimal fnExDiffAmtRemain;
        BigDecimal bgInDiffAmtRemain;
        ArrayList<Object> ves;
        HashSet<Object> offsets;
        Object fnInEntries = (List)analysis.get("fnInEntries");
        ArrayList<Object> fnExEntries = (ArrayList<Object>)analysis.get("fnExEntries");
        ArrayList<Object> bgInEntries = (ArrayList<Object>)analysis.get("bgInEntries");
        ArrayList<Object> bgExEntries = (ArrayList<Object>)analysis.get("bgExEntries");
        List checkEntries = (List)analysis.get("checkEntries");
        BigDecimal fnInAmt = (BigDecimal)analysis.get("fnInAmt");
        BigDecimal bgInAmt = (BigDecimal)analysis.get("bgInAmt");
        BigDecimal fnExAmt = (BigDecimal)analysis.get("fnExAmt");
        BigDecimal bgExAmt = (BigDecimal)analysis.get("bgExAmt");
        BigDecimal inDiffAmt = (BigDecimal)analysis.get("inDiffAmt");
        BigDecimal exDiffAmt = (BigDecimal)analysis.get("exDiffAmt");
        if (inDiffAmt.compareTo(GlUtils.zero) != 0) {
            offsets = new HashSet<Object>();
            if (fnInEntries.size() > 1) {
                Object ve1;
                Iterator iterator = fnInEntries.iterator();
                while (iterator.hasNext()) {
                    ve1 = (VoucherEntryInfo)iterator.next();
                    if (offsets.contains(ve1)) continue;
                    Iterator iterator2 = fnInEntries.iterator();
                    while (iterator2.hasNext()) {
                        VoucherEntryInfo voucherEntryInfo = (VoucherEntryInfo)iterator2.next();
                        if (voucherEntryInfo == ve1 || offsets.contains(voucherEntryInfo)) continue;
                        if (voucherEntryInfo.getEntryDC().equals((Object)ve1.getEntryDC())) {
                            if (voucherEntryInfo.getLocalAmount().compareTo(GlUtils.zero.subtract(ve1.getLocalAmount())) != 0) continue;
                            offsets.add(ve1);
                            offsets.add(voucherEntryInfo);
                            continue;
                        }
                        if (voucherEntryInfo.getLocalAmount().compareTo(ve1.getLocalAmount()) != 0) continue;
                        offsets.add(ve1);
                        offsets.add(voucherEntryInfo);
                    }
                }
                if (offsets.size() > 0) {
                    ves = new ArrayList();
                    ve1 = fnInEntries.iterator();
                    while (ve1.hasNext()) {
                        Object ve = (VoucherEntryInfo)ve1.next();
                        if (offsets.contains(ve)) continue;
                        ves.add(ve);
                    }
                    fnInEntries = ves;
                }
            }
            if (bgInEntries.size() > 1) {
                offsets.clear();
                for (Object ve1 : bgInEntries) {
                    if (offsets.contains(ve1)) continue;
                    for (VoucherEntryInfo voucherEntryInfo : bgInEntries) {
                        if (voucherEntryInfo == ve1 || offsets.contains(voucherEntryInfo)) continue;
                        if (voucherEntryInfo.getEntryDC().equals((Object)ve1.getEntryDC())) {
                            if (voucherEntryInfo.getLocalAmount().compareTo(GlUtils.zero.subtract(ve1.getLocalAmount())) != 0) continue;
                            offsets.add(ve1);
                            offsets.add(voucherEntryInfo);
                            continue;
                        }
                        if (voucherEntryInfo.getLocalAmount().compareTo(ve1.getLocalAmount()) != 0) continue;
                        offsets.add(ve1);
                        offsets.add(voucherEntryInfo);
                    }
                }
                if (offsets.size() > 0) {
                    ves = new ArrayList();
                    for (Object ve : bgInEntries) {
                        if (offsets.contains(ve)) continue;
                        ves.add(ve);
                    }
                    bgInEntries = ves;
                }
            }
        }
        if (exDiffAmt.compareTo(GlUtils.zero) != 0) {
            offsets = new HashSet();
            if (fnExEntries.size() > 1) {
                for (Object ve1 : fnExEntries) {
                    if (offsets.contains(ve1)) continue;
                    for (VoucherEntryInfo voucherEntryInfo : fnExEntries) {
                        if (voucherEntryInfo == ve1 || offsets.contains(voucherEntryInfo)) continue;
                        if (voucherEntryInfo.getEntryDC().equals((Object)ve1.getEntryDC())) {
                            if (voucherEntryInfo.getLocalAmount().compareTo(GlUtils.zero.subtract(ve1.getLocalAmount())) != 0) continue;
                            offsets.add(ve1);
                            offsets.add(voucherEntryInfo);
                            continue;
                        }
                        if (voucherEntryInfo.getLocalAmount().compareTo(ve1.getLocalAmount()) != 0) continue;
                        offsets.add(ve1);
                        offsets.add(voucherEntryInfo);
                    }
                }
                if (offsets.size() > 0) {
                    ves = new ArrayList();
                    for (Object ve : fnExEntries) {
                        if (offsets.contains(ve)) continue;
                        ves.add(ve);
                    }
                    fnExEntries = ves;
                }
            }
            if (bgExEntries.size() > 1) {
                offsets.clear();
                for (Object ve1 : bgExEntries) {
                    if (offsets.contains(ve1)) continue;
                    for (VoucherEntryInfo voucherEntryInfo : bgExEntries) {
                        if (voucherEntryInfo == ve1 || offsets.contains(voucherEntryInfo)) continue;
                        if (voucherEntryInfo.getEntryDC().equals((Object)ve1.getEntryDC())) {
                            if (voucherEntryInfo.getLocalAmount().compareTo(GlUtils.zero.subtract(ve1.getLocalAmount())) != 0) continue;
                            offsets.add(ve1);
                            offsets.add(voucherEntryInfo);
                            continue;
                        }
                        if (voucherEntryInfo.getLocalAmount().compareTo(ve1.getLocalAmount()) != 0) continue;
                        offsets.add(ve1);
                        offsets.add(voucherEntryInfo);
                    }
                }
                if (offsets.size() > 0) {
                    ves = new ArrayList<Object>();
                    for (Object ve : bgExEntries) {
                        if (offsets.contains(ve)) continue;
                        ves.add(ve);
                    }
                    bgExEntries = ves;
                }
            }
        }
        if (inDiffAmt.compareTo(GlUtils.zero) != 0 && fnInEntries.size() > 0 && bgInEntries.size() > 0) {
            Object fn;
            offsets = new HashSet();
            ves = fnInEntries.iterator();
            while (ves.hasNext()) {
                fn = (VoucherEntryInfo)ves.next();
                for (VoucherEntryInfo voucherEntryInfo : bgInEntries) {
                    if (offsets.contains(voucherEntryInfo) || !fn.getEntryDC().equals((Object)voucherEntryInfo.getEntryDC()) || fn.getLocalAmount().compareTo(voucherEntryInfo.getLocalAmount()) != 0) continue;
                    offsets.add(fn);
                    offsets.add(voucherEntryInfo);
                }
            }
            ves = fnInEntries.iterator();
            while (ves.hasNext()) {
                fn = (VoucherEntryInfo)ves.next();
                if (offsets.contains(fn)) continue;
                for (VoucherEntryInfo voucherEntryInfo : bgInEntries) {
                    if (offsets.contains(voucherEntryInfo) || fn.getEntryDC().equals((Object)voucherEntryInfo.getEntryDC()) || fn.getLocalAmount().compareTo(GlUtils.zero.subtract(voucherEntryInfo.getLocalAmount())) != 0) continue;
                    offsets.add(fn);
                    offsets.add(voucherEntryInfo);
                }
            }
            if (offsets.size() > 0) {
                ArrayList fnInEntriesTmp = new ArrayList();
                fn = fnInEntries.iterator();
                while (fn.hasNext()) {
                    VoucherEntryInfo fn2 = (VoucherEntryInfo)fn.next();
                    if (offsets.contains(fn2)) continue;
                    fnInEntriesTmp.add(fn2);
                }
                fnInEntries = fnInEntriesTmp;
                ArrayList<VoucherEntryInfo> bgInEntriesTmp = new ArrayList<VoucherEntryInfo>();
                for (VoucherEntryInfo voucherEntryInfo : bgInEntries) {
                    if (offsets.contains(voucherEntryInfo)) continue;
                    bgInEntriesTmp.add(voucherEntryInfo);
                }
                bgInEntries = bgInEntriesTmp;
            }
        }
        if (exDiffAmt.compareTo(GlUtils.zero) != 0 && fnExEntries.size() > 0 && bgExEntries.size() > 0) {
            offsets = new HashSet();
            for (Object fn : fnExEntries) {
                for (VoucherEntryInfo voucherEntryInfo : bgExEntries) {
                    if (offsets.contains(voucherEntryInfo) || !fn.getEntryDC().equals((Object)voucherEntryInfo.getEntryDC()) || fn.getLocalAmount().compareTo(voucherEntryInfo.getLocalAmount()) != 0) continue;
                    offsets.add(fn);
                    offsets.add(voucherEntryInfo);
                }
            }
            for (Object fn : fnExEntries) {
                if (offsets.contains(fn)) continue;
                for (VoucherEntryInfo voucherEntryInfo : bgExEntries) {
                    if (offsets.contains(voucherEntryInfo) || fn.getEntryDC().equals((Object)voucherEntryInfo.getEntryDC()) || fn.getLocalAmount().compareTo(GlUtils.zero.subtract(voucherEntryInfo.getLocalAmount())) != 0) continue;
                    offsets.add(fn);
                    offsets.add(voucherEntryInfo);
                }
            }
            if (offsets.size() > 0) {
                ArrayList<Object> fnExEntriesTmp = new ArrayList<Object>();
                for (Object fn : fnExEntries) {
                    if (offsets.contains(fn)) continue;
                    fnExEntriesTmp.add(fn);
                }
                fnExEntries = fnExEntriesTmp;
                ArrayList<VoucherEntryInfo> bgExEntriesTmp = new ArrayList<VoucherEntryInfo>();
                for (VoucherEntryInfo voucherEntryInfo : bgExEntries) {
                    if (offsets.contains(voucherEntryInfo)) continue;
                    bgExEntriesTmp.add(voucherEntryInfo);
                }
                bgExEntries = bgExEntriesTmp;
            }
        }
        BigDecimal fnInDiffAmt = GlUtils.zero;
        BigDecimal bgInDiffAmt = GlUtils.zero;
        if (inDiffAmt.compareTo(GlUtils.zero) != 0) {
            if (fnInAmt.compareTo(GlUtils.zero) == 0) {
                bgInDiffAmt = inDiffAmt;
            } else if (bgInAmt.compareTo(GlUtils.zero) == 0) {
                fnInDiffAmt = inDiffAmt;
            } else if (fnInAmt.compareTo(GlUtils.zero) > 0 && bgInAmt.compareTo(GlUtils.zero) > 0) {
                if (fnInAmt.compareTo(bgInAmt) > 0) {
                    fnInDiffAmt = inDiffAmt;
                } else {
                    bgInDiffAmt = inDiffAmt;
                }
            } else if (fnInAmt.compareTo(GlUtils.zero) < 0 && bgInAmt.compareTo(GlUtils.zero) < 0) {
                if (fnInAmt.compareTo(bgInAmt) > 0) {
                    bgInDiffAmt = inDiffAmt;
                } else {
                    fnInDiffAmt = inDiffAmt;
                }
            } else {
                fnInDiffAmt = fnInAmt;
                bgInDiffAmt = GlUtils.zero.subtract(bgInAmt);
            }
        }
        BigDecimal fnExDiffAmt = GlUtils.zero;
        BigDecimal bgExDiffAmt = GlUtils.zero;
        if (exDiffAmt.compareTo(GlUtils.zero) != 0) {
            if (fnExAmt.compareTo(GlUtils.zero) == 0) {
                bgExDiffAmt = exDiffAmt;
            } else if (bgExAmt.compareTo(GlUtils.zero) == 0) {
                fnExDiffAmt = exDiffAmt;
            } else if (fnExAmt.compareTo(GlUtils.zero) > 0 && bgExAmt.compareTo(GlUtils.zero) > 0) {
                if (fnExAmt.compareTo(bgExAmt) > 0) {
                    fnExDiffAmt = exDiffAmt;
                } else {
                    bgExDiffAmt = exDiffAmt;
                }
            } else if (fnExAmt.compareTo(GlUtils.zero) < 0 && bgExAmt.compareTo(GlUtils.zero) < 0) {
                if (fnExAmt.compareTo(bgExAmt) > 0) {
                    bgExDiffAmt = exDiffAmt;
                } else {
                    fnExDiffAmt = exDiffAmt;
                }
            } else {
                bgExDiffAmt = bgExAmt;
                fnExDiffAmt = GlUtils.zero.subtract(fnExAmt);
            }
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        HashSet<Object> equalEntries = new HashSet<Object>();
        HashMap<Object, BigDecimal> checkAmtRemains = new HashMap<Object, BigDecimal>();
        for (Object entry : checkEntries) {
            checkAmtRemains.put(entry, entry.getLocalAmount());
        }
        BigDecimal fnInDiffAmtRemain = fnInDiffAmt;
        if (fnInDiffAmtRemain.compareTo(GlUtils.zero) != 0 && fnInEntries.size() > 0) {
            Object entry;
            entry = fnInEntries.iterator();
            while (entry.hasNext()) {
                void var30_58;
                void var30_61;
                BigDecimal assigned2;
                VoucherEntryInfo diffEntry = (VoucherEntryInfo)entry.next();
                BigDecimal bigDecimal2 = EntryDC.CREDIT.equals((Object)diffEntry.getEntryDC()) ? diffEntry.getLocalAmount() : GlUtils.zero.subtract(diffEntry.getLocalAmount());
                if (!DiffItemUtils.isSignEquals(fnInDiffAmt, bigDecimal2)) continue;
                if (bigDecimal2.abs().compareTo(fnInDiffAmtRemain.abs()) <= 0) {
                    BigDecimal assigned22 = bigDecimal2;
                } else {
                    assigned2 = fnInDiffAmtRemain;
                }
                Object var30_59 = null;
                for (VoucherEntryInfo entry2 : checkEntries) {
                    BigDecimal localAmount2;
                    if (((BigDecimal)checkAmtRemains.get(entry2)).compareTo(GlUtils.zero) == 0 || diffEntry.getEntryDC().equals((Object)entry2.getEntryDC()) || (localAmount2 = entry2.getEntryDC().equals((Object)EntryDC.DEBIT) ? entry2.getLocalAmount() : GlUtils.zero.subtract(entry2.getLocalAmount())).compareTo(assigned2) != 0) continue;
                    VoucherEntryInfo voucherEntryInfo = entry2;
                    break;
                }
                if (var30_61 == null) {
                    for (VoucherEntryInfo entry2 : checkEntries) {
                        BigDecimal localAmount2;
                        if (((BigDecimal)checkAmtRemains.get(entry2)).compareTo(GlUtils.zero) == 0 || !diffEntry.getEntryDC().equals((Object)entry2.getEntryDC()) || (localAmount2 = entry2.getEntryDC().equals((Object)EntryDC.DEBIT) ? entry2.getLocalAmount() : GlUtils.zero.subtract(entry2.getLocalAmount())).compareTo(assigned2) != 0) continue;
                        VoucherEntryInfo voucherEntryInfo = entry2;
                        break;
                    }
                }
                if (var30_58 == null) continue;
                DiffItemRecordInfo record3 = DiffItemUtils.buildRecord(ctx, voucherId, voucher, diffEntry, (VoucherEntryInfo)var30_58, assigned2, cache, errors, editing);
                arrayList.add(record3);
                if (!editing && errors.containsKey(voucherId)) {
                    return null;
                }
                equalEntries.add(diffEntry);
                checkAmtRemains.put(var30_58, GlUtils.zero);
                if ((fnInDiffAmtRemain = fnInDiffAmtRemain.subtract(assigned2)).compareTo(GlUtils.zero) != 0 && DiffItemUtils.isSignEquals(fnInDiffAmtRemain, fnInDiffAmt)) continue;
                break;
            }
        }
        if ((bgInDiffAmtRemain = bgInDiffAmt).compareTo(GlUtils.zero) != 0 && bgInEntries.size() > 0) {
            for (VoucherEntryInfo voucherEntryInfo : bgInEntries) {
                void var30_66;
                BigDecimal amt3 = EntryDC.CREDIT.equals((Object)voucherEntryInfo.getEntryDC()) ? GlUtils.zero.subtract(voucherEntryInfo.getLocalAmount()) : voucherEntryInfo.getLocalAmount();
                if (!DiffItemUtils.isSignEquals(bgInDiffAmt, amt3)) continue;
                if (amt3.abs().compareTo(bgInDiffAmtRemain.abs()) <= 0) {
                    BigDecimal bigDecimal3 = amt3;
                } else {
                    BigDecimal bigDecimal4 = bgInDiffAmtRemain;
                }
                Object checkEntry = null;
                for (Object entry : checkEntries) {
                    BigDecimal bigDecimal5;
                    if (((BigDecimal)checkAmtRemains.get(entry)).compareTo(GlUtils.zero) == 0 || !voucherEntryInfo.getEntryDC().equals((Object)entry.getEntryDC()) || GlUtils.zero.compareTo((bigDecimal5 = entry.getEntryDC().equals((Object)EntryDC.CREDIT) ? entry.getLocalAmount() : GlUtils.zero.subtract(entry.getLocalAmount())).add((BigDecimal)var30_66)) != 0) continue;
                    checkEntry = entry;
                    break;
                }
                if (checkEntry == null) {
                    for (Object entry : checkEntries) {
                        BigDecimal bigDecimal6;
                        if (((BigDecimal)checkAmtRemains.get(entry)).compareTo(GlUtils.zero) == 0 || voucherEntryInfo.getEntryDC().equals((Object)entry.getEntryDC()) || GlUtils.zero.compareTo((bigDecimal6 = entry.getEntryDC().equals((Object)EntryDC.CREDIT) ? entry.getLocalAmount() : GlUtils.zero.subtract(entry.getLocalAmount())).add((BigDecimal)var30_66)) != 0) continue;
                        checkEntry = entry;
                        break;
                    }
                }
                if (checkEntry == null) continue;
                DiffItemRecordInfo record4 = DiffItemUtils.buildRecord(ctx, voucherId, voucher, voucherEntryInfo, checkEntry, (BigDecimal)var30_66, cache, errors, editing);
                arrayList.add(record4);
                if (!editing && errors.containsKey(voucherId)) {
                    return null;
                }
                equalEntries.add(voucherEntryInfo);
                checkAmtRemains.put(checkEntry, GlUtils.zero);
                if ((bgInDiffAmtRemain = bgInDiffAmtRemain.subtract((BigDecimal)var30_66)).compareTo(GlUtils.zero) != 0 && DiffItemUtils.isSignEquals(bgInDiffAmtRemain, bgInDiffAmt)) continue;
                break;
            }
        }
        if ((fnExDiffAmtRemain = fnExDiffAmt).compareTo(GlUtils.zero) != 0 && fnExEntries.size() > 0) {
            for (Object diffEntry : fnExEntries) {
                BigDecimal assigned3;
                BigDecimal bigDecimal7 = EntryDC.CREDIT.equals((Object)diffEntry.getEntryDC()) ? diffEntry.getLocalAmount() : GlUtils.zero.subtract(diffEntry.getLocalAmount());
                if (!DiffItemUtils.isSignEquals(fnExDiffAmt, bigDecimal7)) continue;
                if (bigDecimal7.abs().compareTo(fnExDiffAmtRemain.abs()) <= 0) {
                    BigDecimal assigned4 = bigDecimal7;
                } else {
                    assigned3 = fnExDiffAmtRemain;
                }
                VoucherEntryInfo checkEntry = null;
                for (VoucherEntryInfo voucherEntryInfo : checkEntries) {
                    BigDecimal localAmount4;
                    if (((BigDecimal)checkAmtRemains.get(voucherEntryInfo)).compareTo(GlUtils.zero) == 0 || diffEntry.getEntryDC().equals((Object)voucherEntryInfo.getEntryDC()) || GlUtils.zero.compareTo((localAmount4 = voucherEntryInfo.getEntryDC().equals((Object)EntryDC.CREDIT) ? voucherEntryInfo.getLocalAmount() : GlUtils.zero.subtract(voucherEntryInfo.getLocalAmount())).add(assigned3)) != 0) continue;
                    checkEntry = voucherEntryInfo;
                    break;
                }
                if (checkEntry == null) {
                    for (VoucherEntryInfo voucherEntryInfo : checkEntries) {
                        BigDecimal localAmount3;
                        if (((BigDecimal)checkAmtRemains.get(voucherEntryInfo)).compareTo(GlUtils.zero) == 0 || !diffEntry.getEntryDC().equals((Object)voucherEntryInfo.getEntryDC()) || GlUtils.zero.compareTo((localAmount3 = voucherEntryInfo.getEntryDC().equals((Object)EntryDC.CREDIT) ? voucherEntryInfo.getLocalAmount() : GlUtils.zero.subtract(voucherEntryInfo.getLocalAmount())).add(assigned3)) != 0) continue;
                        checkEntry = voucherEntryInfo;
                        break;
                    }
                }
                if (checkEntry == null) continue;
                DiffItemRecordInfo record5 = DiffItemUtils.buildRecord(ctx, voucherId, voucher, (VoucherEntryInfo)diffEntry, checkEntry, assigned3, cache, errors, editing);
                arrayList.add(record5);
                if (!editing && errors.containsKey(voucherId)) {
                    return null;
                }
                equalEntries.add(diffEntry);
                checkAmtRemains.put(checkEntry, GlUtils.zero);
                if ((fnExDiffAmtRemain = fnExDiffAmtRemain.subtract(assigned3)).compareTo(GlUtils.zero) != 0 && DiffItemUtils.isSignEquals(fnExDiffAmtRemain, fnExDiffAmt)) continue;
                break;
            }
        }
        if ((bigDecimal = bgExDiffAmt).compareTo(GlUtils.zero) != 0 && bgExEntries.size() > 0) {
            for (VoucherEntryInfo voucherEntryInfo : bgExEntries) {
                amt = EntryDC.CREDIT.equals((Object)voucherEntryInfo.getEntryDC()) ? GlUtils.zero.subtract(voucherEntryInfo.getLocalAmount()) : voucherEntryInfo.getLocalAmount();
                if (!DiffItemUtils.isSignEquals(bgExDiffAmt, amt)) continue;
                assigned = amt.abs().compareTo(var28_53.abs()) <= 0 ? amt : var28_53;
                VoucherEntryInfo checkEntry = null;
                for (VoucherEntryInfo entry : checkEntries) {
                    BigDecimal localAmount4;
                    if (((BigDecimal)checkAmtRemains.get(entry)).compareTo(GlUtils.zero) == 0 || !voucherEntryInfo.getEntryDC().equals((Object)entry.getEntryDC()) || (localAmount4 = entry.getEntryDC().equals((Object)EntryDC.DEBIT) ? entry.getLocalAmount() : GlUtils.zero.subtract(entry.getLocalAmount())).compareTo((BigDecimal)assigned) != 0) continue;
                    checkEntry = entry;
                    break;
                }
                if (checkEntry == null) {
                    for (VoucherEntryInfo entry : checkEntries) {
                        Object localAmount5;
                        if (((BigDecimal)checkAmtRemains.get(entry)).compareTo(GlUtils.zero) == 0 || voucherEntryInfo.getEntryDC().equals((Object)entry.getEntryDC()) || ((BigDecimal)(localAmount5 = entry.getEntryDC().equals((Object)EntryDC.DEBIT) ? entry.getLocalAmount() : GlUtils.zero.subtract(entry.getLocalAmount()))).compareTo((BigDecimal)assigned) != 0) continue;
                        checkEntry = entry;
                        break;
                    }
                }
                if (checkEntry == null) continue;
                DiffItemRecordInfo diffItemRecordInfo = DiffItemUtils.buildRecord(ctx, voucherId, voucher, voucherEntryInfo, checkEntry, assigned, cache, errors, editing);
                arrayList.add(diffItemRecordInfo);
                if (!editing && errors.containsKey(voucherId)) {
                    return null;
                }
                equalEntries.add(voucherEntryInfo);
                checkAmtRemains.put(checkEntry, GlUtils.zero);
                BigDecimal bigDecimal8 = var28_53.subtract((BigDecimal)assigned);
                if (bigDecimal8.compareTo(GlUtils.zero) != 0 && DiffItemUtils.isSignEquals(bigDecimal8, bgExDiffAmt)) continue;
                break;
            }
        }
        if (DiffItemUtils.isSignEquals(fnInDiffAmtRemain, fnInDiffAmt) && fnInEntries.size() > 0) {
            Object diffEntry;
            diffEntry = fnInEntries.iterator();
            while (diffEntry.hasNext()) {
                VoucherEntryInfo voucherEntryInfo = (VoucherEntryInfo)diffEntry.next();
                if (equalEntries.contains(voucherEntryInfo) || !DiffItemUtils.isSignEquals(fnInDiffAmt, amt = EntryDC.CREDIT.equals((Object)voucherEntryInfo.getEntryDC()) ? voucherEntryInfo.getLocalAmount() : GlUtils.zero.subtract(voucherEntryInfo.getLocalAmount()))) continue;
                assigned = amt.abs().compareTo(fnInDiffAmtRemain.abs()) <= 0 ? amt : fnInDiffAmtRemain;
                assignedRemain = assigned;
                Object var34_98 = null;
                lastRecord = null;
                for (VoucherEntryInfo entry : checkEntries) {
                    BigDecimal bigDecimal9 = localAmount = entry.getEntryDC().equals((Object)EntryDC.DEBIT) ? entry.getLocalAmount() : GlUtils.zero.subtract(entry.getLocalAmount());
                    if (DiffItemUtils.isSignEquals(localAmount, assigned)) {
                        VoucherEntryInfo voucherEntryInfo2 = entry;
                        checkAmtRemain = (BigDecimal)checkAmtRemains.get(entry);
                        if (checkAmtRemain.compareTo(GlUtils.zero) == 0 || !DiffItemUtils.isSignEquals(checkAmtRemain, entry.getLocalAmount())) continue;
                        localAmount = entry.getEntryDC().equals((Object)EntryDC.DEBIT) ? checkAmtRemain : GlUtils.zero.subtract(checkAmtRemain);
                        checkAssigned = localAmount;
                        if (checkAssigned.abs().compareTo(assignedRemain.abs()) > 0) {
                            checkAssigned = assignedRemain;
                            if (checkAmtRemain.compareTo(GlUtils.zero) > 0) {
                                checkAmtRemains.put(entry, checkAmtRemain.subtract(assignedRemain.abs()));
                            } else {
                                checkAmtRemains.put(entry, checkAmtRemain.add(assignedRemain.abs()));
                            }
                        } else {
                            checkAmtRemains.put(entry, GlUtils.zero);
                        }
                        DiffItemRecordInfo record22 = DiffItemUtils.buildRecord(ctx, voucherId, voucher, voucherEntryInfo, entry, checkAssigned, cache, errors, editing);
                        arrayList.add(record22);
                        if (!editing && errors.containsKey(voucherId)) {
                            return null;
                        }
                        assignedRemain = assignedRemain.subtract(checkAssigned);
                        lastRecord = record22;
                    }
                    if (assignedRemain.compareTo(GlUtils.zero) != 0 && DiffItemUtils.isSignEquals(assignedRemain, assigned)) continue;
                    break;
                }
                if (DiffItemUtils.isSignEquals(assignedRemain, assigned)) {
                    void var34_99;
                    if (lastRecord != null) {
                        if (lastRecord.getDiffItem() == null || lastRecord.getDiffItem().getDc().equals((Object)DiffItemDC.POSITIVE)) {
                            lastRecord.setAssignedLocalAmount(lastRecord.getAssignedLocalAmount().add(assignedRemain));
                        } else {
                            lastRecord.setAssignedLocalAmount(lastRecord.getAssignedLocalAmount().subtract(assignedRemain));
                        }
                    } else if (var34_99 != null) {
                        record2 = DiffItemUtils.buildRecord(ctx, voucherId, voucher, voucherEntryInfo, (VoucherEntryInfo)var34_99, assignedRemain, cache, errors, editing);
                        arrayList.add(record2);
                        if (!editing && errors.containsKey(voucherId)) {
                            return null;
                        }
                    } else {
                        errors.put(voucherId, MessageFormat.format(DiffItemUtils.getResource(ctx, "diffitemUtils1"), voucherEntryInfo.getSeq(), voucherEntryInfo.getAccount().getNumber()));
                        if (!editing) {
                            return null;
                        }
                    }
                }
                if ((fnInDiffAmtRemain = fnInDiffAmtRemain.subtract((BigDecimal)assigned)).compareTo(GlUtils.zero) != 0 && DiffItemUtils.isSignEquals(fnInDiffAmtRemain, fnInDiffAmt)) continue;
                break;
            }
        }
        if (DiffItemUtils.isSignEquals(bgInDiffAmtRemain, bgInDiffAmt) && bgInEntries.size() > 0) {
            for (VoucherEntryInfo voucherEntryInfo : bgInEntries) {
                if (equalEntries.contains(voucherEntryInfo) || !DiffItemUtils.isSignEquals(bgInDiffAmt, amt = EntryDC.CREDIT.equals((Object)voucherEntryInfo.getEntryDC()) ? GlUtils.zero.subtract(voucherEntryInfo.getLocalAmount()) : voucherEntryInfo.getLocalAmount())) continue;
                assigned = amt.abs().compareTo(bgInDiffAmtRemain.abs()) <= 0 ? amt : bgInDiffAmtRemain;
                assignedRemain = assigned;
                Object var34_102 = null;
                lastRecord = null;
                for (VoucherEntryInfo entry : checkEntries) {
                    BigDecimal bigDecimal10 = localAmount = entry.getEntryDC().equals((Object)EntryDC.CREDIT) ? entry.getLocalAmount() : GlUtils.zero.subtract(entry.getLocalAmount());
                    if (!DiffItemUtils.isSignEquals(localAmount, assigned)) {
                        VoucherEntryInfo voucherEntryInfo3 = entry;
                        checkAmtRemain = (BigDecimal)checkAmtRemains.get(entry);
                        if (checkAmtRemain.compareTo(GlUtils.zero) == 0 || !DiffItemUtils.isSignEquals(checkAmtRemain, entry.getLocalAmount())) continue;
                        localAmount = entry.getEntryDC().equals((Object)EntryDC.CREDIT) ? checkAmtRemain : GlUtils.zero.subtract(checkAmtRemain);
                        checkAssigned = GlUtils.zero.subtract(localAmount);
                        if (checkAssigned.abs().compareTo(assignedRemain.abs()) > 0) {
                            checkAssigned = assignedRemain;
                            if (checkAmtRemain.compareTo(GlUtils.zero) > 0) {
                                checkAmtRemains.put(entry, checkAmtRemain.subtract(assignedRemain.abs()));
                            } else {
                                checkAmtRemains.put(entry, checkAmtRemain.add(assignedRemain.abs()));
                            }
                        } else {
                            checkAmtRemains.put(entry, GlUtils.zero);
                        }
                        record = DiffItemUtils.buildRecord(ctx, voucherId, voucher, voucherEntryInfo, entry, checkAssigned, cache, errors, editing);
                        arrayList.add(record);
                        if (!editing && errors.containsKey(voucherId)) {
                            return null;
                        }
                        assignedRemain = assignedRemain.subtract(checkAssigned);
                        lastRecord = record;
                    }
                    if (assignedRemain.compareTo(GlUtils.zero) != 0 && DiffItemUtils.isSignEquals(assignedRemain, assigned)) continue;
                    break;
                }
                if (DiffItemUtils.isSignEquals(assignedRemain, assigned)) {
                    void var34_103;
                    if (lastRecord != null) {
                        if (lastRecord.getDiffItem() == null || lastRecord.getDiffItem().getDc().equals((Object)DiffItemDC.POSITIVE)) {
                            lastRecord.setAssignedLocalAmount(lastRecord.getAssignedLocalAmount().add(assignedRemain));
                        } else {
                            lastRecord.setAssignedLocalAmount(lastRecord.getAssignedLocalAmount().subtract(assignedRemain));
                        }
                    } else if (var34_103 != null) {
                        record2 = DiffItemUtils.buildRecord(ctx, voucherId, voucher, voucherEntryInfo, (VoucherEntryInfo)var34_103, assignedRemain, cache, errors, editing);
                        arrayList.add(record2);
                        if (!editing && errors.containsKey(voucherId)) {
                            return null;
                        }
                    } else {
                        errors.put(voucherId, MessageFormat.format(DiffItemUtils.getResource(ctx, "diffitemUtils1"), voucherEntryInfo.getSeq(), voucherEntryInfo.getAccount().getNumber()));
                        if (!editing) {
                            return null;
                        }
                    }
                }
                if ((bgInDiffAmtRemain = bgInDiffAmtRemain.subtract((BigDecimal)assigned)).compareTo(GlUtils.zero) != 0 && DiffItemUtils.isSignEquals(bgInDiffAmtRemain, bgInDiffAmt)) continue;
                break;
            }
        }
        if (DiffItemUtils.isSignEquals(fnExDiffAmtRemain, fnExDiffAmt) && fnExEntries.size() > 0) {
            for (VoucherEntryInfo voucherEntryInfo : fnExEntries) {
                if (equalEntries.contains(voucherEntryInfo) || !DiffItemUtils.isSignEquals(fnExDiffAmt, amt = EntryDC.CREDIT.equals((Object)voucherEntryInfo.getEntryDC()) ? voucherEntryInfo.getLocalAmount() : GlUtils.zero.subtract(voucherEntryInfo.getLocalAmount()))) continue;
                assigned = amt.abs().compareTo(fnExDiffAmtRemain.abs()) <= 0 ? amt : fnExDiffAmtRemain;
                assignedRemain = assigned;
                Object var34_106 = null;
                lastRecord = null;
                for (VoucherEntryInfo entry : checkEntries) {
                    BigDecimal bigDecimal11 = localAmount = entry.getEntryDC().equals((Object)EntryDC.CREDIT) ? entry.getLocalAmount() : GlUtils.zero.subtract(entry.getLocalAmount());
                    if (!DiffItemUtils.isSignEquals(localAmount, assigned)) {
                        VoucherEntryInfo voucherEntryInfo4 = entry;
                        checkAmtRemain = (BigDecimal)checkAmtRemains.get(entry);
                        if (checkAmtRemain.compareTo(GlUtils.zero) == 0 || !DiffItemUtils.isSignEquals(checkAmtRemain, entry.getLocalAmount())) continue;
                        localAmount = entry.getEntryDC().equals((Object)EntryDC.CREDIT) ? checkAmtRemain : GlUtils.zero.subtract(checkAmtRemain);
                        checkAssigned = GlUtils.zero.subtract(localAmount);
                        if (checkAssigned.abs().compareTo(assignedRemain.abs()) > 0) {
                            checkAssigned = assignedRemain;
                            if (checkAmtRemain.compareTo(GlUtils.zero) > 0) {
                                checkAmtRemains.put(entry, checkAmtRemain.subtract(assignedRemain.abs()));
                            } else {
                                checkAmtRemains.put(entry, checkAmtRemain.add(assignedRemain.abs()));
                            }
                        } else {
                            checkAmtRemains.put(entry, GlUtils.zero);
                        }
                        record = DiffItemUtils.buildRecord(ctx, voucherId, voucher, voucherEntryInfo, entry, checkAssigned, cache, errors, editing);
                        arrayList.add(record);
                        if (!editing && errors.containsKey(voucherId)) {
                            return null;
                        }
                        assignedRemain = assignedRemain.subtract(checkAssigned);
                        lastRecord = record;
                    }
                    if (assignedRemain.compareTo(GlUtils.zero) != 0 && DiffItemUtils.isSignEquals(assignedRemain, assigned)) continue;
                    break;
                }
                if (DiffItemUtils.isSignEquals(assignedRemain, assigned)) {
                    void var34_107;
                    if (lastRecord != null) {
                        if (lastRecord.getDiffItem() == null || lastRecord.getDiffItem().getDc().equals((Object)DiffItemDC.POSITIVE)) {
                            lastRecord.setAssignedLocalAmount(lastRecord.getAssignedLocalAmount().add(assignedRemain));
                        } else {
                            lastRecord.setAssignedLocalAmount(lastRecord.getAssignedLocalAmount().subtract(assignedRemain));
                        }
                    } else if (var34_107 != null) {
                        record2 = DiffItemUtils.buildRecord(ctx, voucherId, voucher, voucherEntryInfo, (VoucherEntryInfo)var34_107, assignedRemain, cache, errors, editing);
                        arrayList.add(record2);
                        if (!editing && errors.containsKey(voucherId)) {
                            return null;
                        }
                    } else {
                        errors.put(voucherId, MessageFormat.format(DiffItemUtils.getResource(ctx, "diffitemUtils1"), voucherEntryInfo.getSeq(), voucherEntryInfo.getAccount().getNumber()));
                        if (!editing) {
                            return null;
                        }
                    }
                }
                if ((fnExDiffAmtRemain = fnExDiffAmtRemain.subtract((BigDecimal)assigned)).compareTo(GlUtils.zero) != 0 && DiffItemUtils.isSignEquals(fnExDiffAmtRemain, fnExDiffAmt)) continue;
                break;
            }
        }
        if (DiffItemUtils.isSignEquals((BigDecimal)var28_53, bgExDiffAmt) && bgExEntries.size() > 0) {
            for (VoucherEntryInfo voucherEntryInfo : bgExEntries) {
                BigDecimal bigDecimal12;
                void var28_55;
                if (equalEntries.contains(voucherEntryInfo) || !DiffItemUtils.isSignEquals(bgExDiffAmt, amt = EntryDC.CREDIT.equals((Object)voucherEntryInfo.getEntryDC()) ? GlUtils.zero.subtract(voucherEntryInfo.getLocalAmount()) : voucherEntryInfo.getLocalAmount())) continue;
                assigned = amt.abs().compareTo(var28_55.abs()) <= 0 ? amt : var28_55;
                assignedRemain = assigned;
                Object var34_110 = null;
                lastRecord = null;
                for (VoucherEntryInfo entry : checkEntries) {
                    BigDecimal bigDecimal13 = localAmount = entry.getEntryDC().equals((Object)EntryDC.DEBIT) ? entry.getLocalAmount() : GlUtils.zero.subtract(entry.getLocalAmount());
                    if (DiffItemUtils.isSignEquals(localAmount, assigned)) {
                        VoucherEntryInfo voucherEntryInfo5 = entry;
                        checkAmtRemain = (BigDecimal)checkAmtRemains.get(entry);
                        if (checkAmtRemain.compareTo(GlUtils.zero) == 0 || !DiffItemUtils.isSignEquals(checkAmtRemain, entry.getLocalAmount())) continue;
                        localAmount = entry.getEntryDC().equals((Object)EntryDC.DEBIT) ? checkAmtRemain : GlUtils.zero.subtract(checkAmtRemain);
                        checkAssigned = localAmount;
                        if (checkAssigned.abs().compareTo(assignedRemain.abs()) > 0) {
                            checkAssigned = assignedRemain;
                            if (checkAmtRemain.compareTo(GlUtils.zero) > 0) {
                                checkAmtRemains.put(entry, checkAmtRemain.subtract(assignedRemain.abs()));
                            } else {
                                checkAmtRemains.put(entry, checkAmtRemain.add(assignedRemain.abs()));
                            }
                        } else {
                            checkAmtRemains.put(entry, GlUtils.zero);
                        }
                        record = DiffItemUtils.buildRecord(ctx, voucherId, voucher, voucherEntryInfo, entry, checkAssigned, cache, errors, editing);
                        arrayList.add(record);
                        if (!editing && errors.containsKey(voucherId)) {
                            return null;
                        }
                        assignedRemain = assignedRemain.subtract(checkAssigned);
                        lastRecord = record;
                    }
                    if (assignedRemain.compareTo(GlUtils.zero) != 0 && DiffItemUtils.isSignEquals(assignedRemain, assigned)) continue;
                    break;
                }
                if (DiffItemUtils.isSignEquals(assignedRemain, assigned)) {
                    void var34_111;
                    if (lastRecord != null) {
                        if (lastRecord.getDiffItem() == null || lastRecord.getDiffItem().getDc().equals((Object)DiffItemDC.POSITIVE)) {
                            lastRecord.setAssignedLocalAmount(lastRecord.getAssignedLocalAmount().add(assignedRemain));
                        } else {
                            lastRecord.setAssignedLocalAmount(lastRecord.getAssignedLocalAmount().subtract(assignedRemain));
                        }
                    } else if (var34_111 != null) {
                        record2 = DiffItemUtils.buildRecord(ctx, voucherId, voucher, voucherEntryInfo, (VoucherEntryInfo)var34_111, assignedRemain, cache, errors, editing);
                        arrayList.add(record2);
                        if (!editing && errors.containsKey(voucherId)) {
                            return null;
                        }
                    } else {
                        errors.put(voucherId, MessageFormat.format(DiffItemUtils.getResource(ctx, "diffitemUtils1"), voucherEntryInfo.getSeq(), voucherEntryInfo.getAccount().getNumber()));
                        if (!editing) {
                            return null;
                        }
                    }
                }
                if ((bigDecimal12 = var28_55.subtract((BigDecimal)assigned)).compareTo(GlUtils.zero) != 0 && DiffItemUtils.isSignEquals(bigDecimal12, bgExDiffAmt)) continue;
                break;
            }
        }
        Collections.sort(arrayList, (Comparator)new Comparator<DiffItemRecordInfo>(){

            @Override
            public int compare(DiffItemRecordInfo o1, DiffItemRecordInfo o2) {
                if (o1.getDiffEntry().getSeq() > o2.getDiffEntry().getSeq()) {
                    return 1;
                }
                if (o1.getDiffEntry().getSeq() < o2.getDiffEntry().getSeq()) {
                    return -1;
                }
                if (o1.getCheckEntry().getSeq() > o2.getCheckEntry().getSeq()) {
                    return 1;
                }
                if (o1.getCheckEntry().getSeq() < o2.getCheckEntry().getSeq()) {
                    return -1;
                }
                return 0;
            }
        });
        DiffItemRecordCollection diRecords = new DiffItemRecordCollection();
        boolean bl = false;
        int checkSeq = 0;
        VoucherEntryInfo preEntry = null;
        for (DiffItemRecordInfo diffItemRecordInfo : arrayList) {
            void var30_80;
            if (preEntry == null) {
                preEntry = diffItemRecordInfo.getDiffEntry();
                diffItemRecordInfo.setDiffSeq((int)(++var30_80));
            } else if (diffItemRecordInfo.getDiffEntry() != preEntry) {
                diffItemRecordInfo.setDiffSeq((int)(++var30_80));
                checkSeq = 0;
                preEntry = diffItemRecordInfo.getDiffEntry();
            } else {
                diffItemRecordInfo.setDiffSeq((int)var30_80);
            }
            diffItemRecordInfo.setCheckSeq(++checkSeq);
            diRecords.add(diffItemRecordInfo);
        }
        return diRecords;
    }

    private static DiffItemRecordInfo buildRecord(Context ctx, String voucherId, VoucherInfo voucher, VoucherEntryInfo diffEntry, VoucherEntryInfo checkEntry, BigDecimal diffAmt, Map<String, Object> cache, Map<String, Object> errors, boolean editing) throws BOSException {
        DiffItemRecordInfo record = new DiffItemRecordInfo();
        record.setVoucher(voucher);
        record.setDiffEntry(diffEntry);
        record.setCheckEntry(checkEntry);
        DiffItemInfo diffItem = DiffItemUtils.getDiffItem(ctx, record, cache);
        if (diffItem == null) {
            if (!editing) {
                errors.put(voucherId, MessageFormat.format(DiffItemUtils.getResource(ctx, "diffitemUtils2"), diffEntry.getAccount().getNumber(), checkEntry.getAccount().getNumber()));
            }
            record.setAssignedLocalAmount(diffAmt);
            return record;
        }
        record.setDiffItem(diffItem);
        if (DiffItemDC.POSITIVE.equals((Object)diffItem.getDc())) {
            record.setAssignedLocalAmount(diffAmt);
        } else {
            record.setAssignedLocalAmount(GlUtils.zero.subtract(diffAmt));
        }
        return record;
    }

    private static DiffItemInfo getDiffItem(Context ctx, DiffItemRecordInfo record, Map<String, Object> cache) throws BOSException {
        IDiffItemMapping iDiffItemMapping = ctx != null ? DiffItemMappingFactory.getLocalInstance(ctx) : DiffItemMappingFactory.getRemoteInstance();
        DiffItemInfo diffItem = null;
        String diffAccountId = record.getDiffEntry().getAccount().getId().toString();
        String checkAccountId = record.getCheckEntry().getAccount().getId().toString();
        String key = diffAccountId + "_" + checkAccountId;
        if (cache.containsKey(key)) {
            diffItem = (DiffItemInfo)cache.get(key);
        } else {
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("id");
            selector.add("diffItem.id");
            selector.add("diffItem.number");
            selector.add("diffItem.name");
            selector.add("diffItem.dc");
            view.setSelector(selector);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("diffAccount.id", (Object)diffAccountId));
            filter.getFilterItems().add(new FilterItemInfo("checkAccount.id", (Object)checkAccountId));
            view.setFilter(filter);
            CoreBaseCollection mappings = iDiffItemMapping.getCollection(view);
            if (mappings.size() > 0) {
                diffItem = ((DiffItemMappingInfo)mappings.get(0)).getDiffItem();
            }
            cache.put(key, diffItem);
        }
        if (diffItem == null) {
            DiffType diffType = DiffItemUtils.getDiffType(record.getDiffEntry().getAccount());
            key = diffType.getValue() + "_" + checkAccountId;
            if (cache.containsKey(key)) {
                diffItem = (DiffItemInfo)cache.get(key);
            } else {
                EntityViewInfo view = new EntityViewInfo();
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add("id");
                selector.add("diffItem.id");
                selector.add("diffItem.number");
                selector.add("diffItem.name");
                selector.add("diffItem.name");
                selector.add("diffItem.dc");
                view.setSelector(selector);
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("diffType", (Object)diffType.getValue()));
                filter.getFilterItems().add(new FilterItemInfo("diffAccount.id", null));
                filter.getFilterItems().add(new FilterItemInfo("checkAccount.id", (Object)checkAccountId));
                view.setFilter(filter);
                CoreBaseCollection mappings = iDiffItemMapping.getCollection(view);
                if (mappings.size() > 0) {
                    diffItem = ((DiffItemMappingInfo)mappings.get(0)).getDiffItem();
                }
                cache.put(key, diffItem);
            }
        }
        return diffItem;
    }

    private static DiffType getDiffType(AccountViewInfo diffAccount) {
        if (diffAccount.isBudget()) {
            if (AccountDiffType.INCOME.equals((Object)diffAccount.getDiffType())) {
                return DiffType.BUDGET_INCOME;
            }
            return DiffType.BUDGET_EXPENSE;
        }
        if (AccountDiffType.INCOME.equals((Object)diffAccount.getDiffType())) {
            return DiffType.FINANCE_INCOME;
        }
        return DiffType.FINANCE_EXPENSE;
    }

    private static boolean isSignEquals(BigDecimal b1, BigDecimal b2) {
        return b1.compareTo(GlUtils.zero) > 0 && b2.compareTo(GlUtils.zero) > 0 || b1.compareTo(GlUtils.zero) < 0 && b2.compareTo(GlUtils.zero) < 0;
    }

    static {
        DiffItems.put("1", "qr/IMHhfoU2vhxbe6/Lz1P9STUg=");
        DiffItems.put("101", "CP79YmOZhU6elr9TfkCbzf9STUg=");
        DiffItems.put("10101", "uOAAYHCoCEuWuBndIPZt9v9STUg=");
        DiffItems.put("10102", "RDxbvo+WhEei3Fl0NwiLYf9STUg=");
        DiffItems.put("102", "i6jyjHoHgkO33bI0D/tuMv9STUg=");
        DiffItems.put("10201", "ouK/066Y9US8r4JiQhsrSv9STUg=");
        DiffItems.put("10202", "eQSL666d/UuvIEH4CGZe3f9STUg=");
        DiffItems.put("10203", "4iQQdVq1U0yq4twjff4vdv9STUg=");
        DiffItems.put("10204", "/5rE7FUT5k+M49Rp+9fcnP9STUg=");
        DiffItems.put("103", "2AbZiT29X0OKqZMRzcsL/f9STUg=");
        DiffItems.put("10301", "9pzbe3Ev5kWnK36v+tudiP9STUg=");
        DiffItems.put("10302", "XMzWKy1q3EC1vDt0JG60J/9STUg=");
        DiffItems.put("104", "rDk6kRjZckSqXvsMP4ziBP9STUg=");
        DiffItems.put("10401", "OMkYrN5LOEyEvLAScMfjuv9STUg=");
        DiffItems.put("10402", "4ZecdAw7RUigZ4M+yMP7IP9STUg=");
        DiffItems.put("10403", "BftRWZs+JkSGmebnq+zkBv9STUg=");
        DiffItems.put("10404", "lLV4zESitUCIGF/9jxfmvP9STUg=");
        DiffItems.put("2", "Kqop4SMUaEuuR05gwUvZlP9STUg=");
    }
}

