/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.eas.basedata.master.account.AccountFacadeFactory;
import com.kingdee.eas.basedata.master.account.IAccountFacade;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GLAsstAccountChangeFacadeFactory;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.common.SQLUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class GLAsstAccountUtils {
    public static AsstActTypeCollection getAsstActTypes(Context ctx, String caaId) throws BOSException {
        return GLAsstAccountUtils.getAsstActTypes(ctx, caaId, null);
    }

    public static AsstActTypeCollection getAsstActTypes(Context ctx, String caaId, SelectorItemCollection selector) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        if (selector == null || selector.size() == 0) {
            selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("asstActType.id"));
            selector.add(new SelectorItemInfo("asstActType.name"));
            selector.add(new SelectorItemInfo("asstActType.number"));
            selector.add(new SelectorItemInfo("asstActType.isMultilevel"));
            selector.add(new SelectorItemInfo("asstActType.useLongNumber"));
            selector.add(new SelectorItemInfo("asstActType.isQty"));
            selector.add(new SelectorItemInfo("asstActType.realtionDataObject"));
            selector.add(new SelectorItemInfo("asstActType.mappingFieldName"));
            selector.add(new SelectorItemInfo("asstActType.asstHGAttribute"));
            selector.add(new SelectorItemInfo("asstActType.groupTableName"));
            selector.add(new SelectorItemInfo("asstActType.groupMappingFieldName"));
            selector.add(new SelectorItemInfo("asstActType.glAsstActTypeGrp.id"));
        }
        view.setSelector(selector);
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("asstAccount.id", (Object)caaId));
        view.setFilter(filter);
        view.getSorter().add(new SorterItemInfo("seq"));
        AsstActGroupDetailCollection asstcol = ctx == null ? AsstActGroupDetailFactory.getRemoteInstance().getAsstActGroupDetailCollection(view) : AsstActGroupDetailFactory.getLocalInstance((Context)ctx).getAsstActGroupDetailCollection(view);
        AsstActTypeCollection asstActTypes = new AsstActTypeCollection();
        for (int i = 0; i < asstcol.size(); ++i) {
            asstActTypes.add(asstcol.get(i).getAsstActType());
        }
        return asstActTypes;
    }

    protected static Map getDefaultVals(Context ctx, Map params) throws BOSException, EASBizException {
        if (ctx == null) {
            return GLAsstAccountChangeFacadeFactory.getRemoteInstance().getDefaultVals(params);
        }
        return GLAsstAccountChangeFacadeFactory.getLocalInstance(ctx).getDefaultVals(params);
    }

    public static AsstAccountInfo getCAA(Context ctx, String accountId, String periodId, Map<String, AsstAccountInfo> cache) throws EASBizException, BOSException {
        HashSet<String> accountIds = new HashSet<String>();
        accountIds.add(accountId);
        Map<String, AsstAccountInfo> caas = GLAsstAccountUtils.getCAAs(ctx, accountIds, periodId, cache);
        return caas.get(accountId);
    }

    public static Map<String, AsstAccountInfo> getCAAs(Context ctx, Set<String> accountIds, String periodId, Map<String, AsstAccountInfo> cache) throws EASBizException, BOSException {
        HashMap<String, AsstAccountInfo> caas = new HashMap<String, AsstAccountInfo>();
        HashSet<String> newAccountIds = new HashSet<String>();
        if (cache != null && cache.size() > 0) {
            for (String accountId : accountIds) {
                if (cache.containsKey(accountId)) {
                    caas.put(accountId, cache.get(accountId));
                    continue;
                }
                newAccountIds.add(accountId);
            }
        } else {
            newAccountIds.addAll(accountIds);
        }
        if (newAccountIds.size() <= 0) {
            return caas;
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("isQty"));
        selector.add(new SelectorItemInfo("count"));
        selector.add(new SelectorItemInfo("measureUnit.id"));
        selector.add(new SelectorItemInfo("measureUnit.number"));
        selector.add(new SelectorItemInfo("measureUnit.name"));
        selector.add(new SelectorItemInfo("measureUnit.coefficient"));
        selector.add(new SelectorItemInfo("measureUnitGroup.id"));
        selector.add(new SelectorItemInfo("measureUnitGroup.defaultUnit.id"));
        selector.add(new SelectorItemInfo("measureUnitGroup.defaultUnit.number"));
        selector.add(new SelectorItemInfo("measureUnitGroup.defaultUnit.name"));
        selector.add(new SelectorItemInfo("measureUnitGroup.defaultUnit.coefficient"));
        IAccountFacade iAccountFacade = ctx != null ? AccountFacadeFactory.getLocalInstance((Context)ctx) : AccountFacadeFactory.getRemoteInstance();
        Map newCaas = iAccountFacade.getCAAsByPeriod(newAccountIds, periodId, selector);
        caas.putAll(newCaas);
        if (cache != null) {
            cache.putAll(newCaas);
        }
        return caas;
    }

    public static String createAccountAsstTable(Context ctx) throws BOSException, EASBizException {
        return GLAsstAccountUtils.createAsstAccountTable(ctx, false);
    }

    public static String createAsstAccountTable(Context ctx, boolean includePeriod) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        try {
            sql.append("create table T_TMP_AsstAccount ( \n");
            sql.append("    FAccountID VARCHAR(44), \n");
            if (includePeriod) {
                sql.append("    FPeriodID VARCHAR(44), \n");
            }
            sql.append("    FCAA VARCHAR(44) default null, \n");
            sql.append("    FMeasureUnitGroupID VARCHAR(44) default null, \n");
            sql.append("    FIsQty int default 0 \n");
            sql.append(") \n");
            String T_TMP_AsstAccount = TempTablePool.getInstance((Context)ctx).createTempTable(sql.toString());
            String indexCols = "FAccountID";
            if (includePeriod) {
                indexCols = indexCols + ", FPeriodID";
            }
            TempTablePool.getInstance((Context)ctx).createIndex(T_TMP_AsstAccount, indexCols, true, false);
            return T_TMP_AsstAccount;
        }
        catch (Exception e) {
            throw new BOSException("create tempTable error!", (Throwable)e);
        }
    }

    public static String buildAsstAccountTable(Context ctx, String companyId, String periodId, String accountTable, String T_TMP_AsstAccount, boolean includePeriod, Map<String, AsstAccountInfo> cache, String where) throws BOSException, EASBizException {
        String string;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            StringBuffer sql = new StringBuffer();
            sql.append("select \n");
            sql.append("    av.FID \n");
            sql.append("from T_BD_AccountView av \n");
            sql.append("join T_BD_AccountType at on at.FID = av.FAccountTypeID \n");
            sql.append("where av.FCompanyID = '" + companyId + "' \n");
            sql.append(" and av.FISPROFITCENTER = 0 \n");
            if (accountTable != null) {
                sql.append("    and av.FAccountTableID = '" + accountTable + "' \n");
            }
            if (where != null) {
                sql.append("    and " + where);
            }
            if (T_TMP_AsstAccount != null) {
                sql.append("    and not exists ( \n");
                sql.append("        select 1 from " + T_TMP_AsstAccount + " t where t.FAccountID = av.FID \n");
                if (includePeriod) {
                    sql.append("        and t.FPeriodID = '" + periodId + "' \n");
                }
                sql.append("    ) \n");
            }
            pstmt = conn.prepareStatement(sql.toString());
            rs = pstmt.executeQuery();
            HashSet<String> accountIds = new HashSet<String>();
            while (rs.next()) {
                accountIds.add(rs.getString("FID"));
            }
            rs.close();
            pstmt.close();
            string = GLAsstAccountUtils.buildAsstAccountTable(ctx, periodId, T_TMP_AsstAccount, includePeriod, cache, accountIds);
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
        return string;
    }

    public static String buildAsstAccountTable(Context ctx, String periodId, String T_TMP_AsstAccount, boolean includePeriod, Map<String, AsstAccountInfo> cache, Set<String> accountIds) throws BOSException, EASBizException {
        if (T_TMP_AsstAccount == null) {
            T_TMP_AsstAccount = GLAsstAccountUtils.createAsstAccountTable(ctx, includePeriod);
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            HashMap<String, AsstAccountInfo> caas = new HashMap<String, AsstAccountInfo>();
            HashSet<String> ids = new HashSet<String>();
            for (String id : accountIds) {
                ids.add(id);
                if (ids.size() < 50) continue;
                Map<String, AsstAccountInfo> iCaas = GLAsstAccountUtils.getCAAs(ctx, ids, periodId, cache);
                caas.putAll(iCaas);
                ids.clear();
            }
            if (ids.size() > 0) {
                Map<String, AsstAccountInfo> iCaas = GLAsstAccountUtils.getCAAs(ctx, ids, periodId, cache);
                caas.putAll(iCaas);
            }
            conn = EJBFactory.getConnection((Context)ctx);
            StringBuffer sql = new StringBuffer();
            sql.append("insert into " + T_TMP_AsstAccount + " ( \n");
            if (includePeriod) {
                sql.append("    FPeriodID, \n");
            }
            sql.append("     FAccountID, FCAA, FMeasureUnitGroupID, FIsQty \n");
            sql.append(") values ( \n");
            if (includePeriod) {
                sql.append("    ?, \n");
            }
            sql.append("    ?, ?, ?, ? \n");
            sql.append(") \n");
            pstmt = conn.prepareStatement(sql.toString());
            for (String id : accountIds) {
                AsstAccountInfo caa = (AsstAccountInfo)caas.get(id);
                int index = 0;
                if (includePeriod) {
                    pstmt.setString(++index, periodId);
                }
                pstmt.setString(++index, id);
                String caaId = null;
                String measureUnitGroupId = null;
                int isQty = 0;
                if (caa != null) {
                    caaId = caa.getId().toString();
                    if (caa.getMeasureUnitGroup() != null) {
                        measureUnitGroupId = caa.getMeasureUnitGroup().getId().toString();
                    }
                    isQty = caa.isIsQty() ? 1 : 0;
                }
                pstmt.setString(++index, caaId);
                pstmt.setString(++index, measureUnitGroupId);
                pstmt.setInt(++index, isQty);
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        return T_TMP_AsstAccount;
    }

    public static Set<String> filterAsstAccountTable(Context ctx, String periodId, String T_TMP_AsstAccount, boolean includePeriod, Set<String> accountIds) throws BOSException, EASBizException {
        HashSet<String> result = new HashSet<String>();
        if (accountIds.size() <= 0) {
            return result;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            ArrayList<String> inSqls = new ArrayList<String>();
            StringBuffer inSql = new StringBuffer();
            int count = 0;
            for (String id : accountIds) {
                inSql.append("'").append(id).append("'");
                if (++count % 100 == 0) {
                    inSqls.add("(" + inSql.toString() + ")");
                    inSql.setLength(0);
                    continue;
                }
                if (count == accountIds.size()) continue;
                inSql.append(",");
            }
            if (inSql.length() > 0) {
                inSqls.add("(" + inSql.toString() + ")");
            }
            conn = EJBFactory.getConnection((Context)ctx);
            String sql = "select FAccountID from " + T_TMP_AsstAccount;
            sql = includePeriod ? sql + " where FPeriodID = '" + periodId + "' and FAccountID in " : sql + " where FAccountID in ";
            HashSet<String> existIds = new HashSet<String>();
            for (String str : inSqls) {
                pstmt = conn.prepareStatement(sql + str);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    existIds.add(rs.getString("FAccountID"));
                }
                rs.close();
                pstmt.close();
            }
            for (String id : accountIds) {
                if (existIds.contains(id)) continue;
                result.add(id);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rs, pstmt, (Connection)conn);
        return result;
    }

    public static Map<String, Object> getAssistantHgs(Context ctx, String asstAccountId, List<AsstActTypeInfo> aats, Set<String> ids) throws BOSException, SQLException {
        if (ids == null || ids.size() == 0) {
            return new HashMap<String, Object>();
        }
        if (aats != null && aats.size() > 0) {
            for (int i = 0; i < aats.size(); ++i) {
                assert (aats.get(i).getNumber() != null);
                assert (aats.get(i).containsKey("realtionDataObject"));
                assert (aats.get(i).containsKey("mappingFieldName"));
                assert (aats.get(i).containsKey("isMultilevel"));
                assert (aats.get(i).containsKey("groupTableName"));
                assert (aats.get(i).containsKey("groupMappingFieldName"));
            }
        } else {
            if (asstAccountId == null || asstAccountId.length() == 0) {
                return new HashMap<String, Object>();
            }
            AsstActTypeCollection coll = GLAsstAccountUtils.getAsstActTypes(ctx, asstAccountId);
            if (coll.size() == 0) {
                return new HashMap<String, Object>();
            }
            aats = new ArrayList<AsstActTypeInfo>();
            for (int i = 0; i < coll.size(); ++i) {
                AsstActTypeInfo aat = coll.get(i);
                if (aat.isUseLongNumber()) {
                    aat.put("showLongNumber", (Object)true);
                }
                aats.add(aat);
            }
        }
        Map<String, Object> result = null;
        List<Set<String>> batchs = GlUtils.split(ids, 100);
        for (Set<String> batch : batchs) {
            if (result == null) {
                result = GLAsstAccountUtils.doGetAssistantHgs(ctx, asstAccountId, aats, batch);
                continue;
            }
            result.putAll(GLAsstAccountUtils.doGetAssistantHgs(ctx, asstAccountId, aats, batch));
        }
        return result;
    }

    private static Map<String, Object> doGetAssistantHgs(Context ctx, String asstAccountId, List<AsstActTypeInfo> aats, Set<String> ids) throws BOSException, SQLException {
        AsstActTypeInfo aat;
        int i;
        HashMap<String, Object> result = new HashMap<String, Object>();
        StringBuffer sql = new StringBuffer();
        ArrayList<String> params = new ArrayList<String>();
        String loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        sql.append("select \n");
        for (i = 0; i < aats.size(); ++i) {
            aat = aats.get(i);
            if (aat.getBoolean("showId")) {
                sql.append("    aat" + (i + 1) + ".FID FID" + (i + 1) + ", \n");
            }
            if (!aat.containsKey("showNumber") || aat.getBoolean("showNumber")) {
                sql.append("    aat" + (i + 1) + ".FNumber FNumber" + (i + 1) + ", \n");
            }
            if (!aat.containsKey("showName") || aat.getBoolean("showName")) {
                sql.append("    aat" + (i + 1) + ".FName_" + loc + " FName" + (i + 1) + ", \n");
            }
            if (aat.isIsMultilevel()) {
                if (aat.getGroupTableName() != null) {
                    if (aat.getBoolean("showLongNumber")) {
                        sql.append("    case when aat" + (i + 1) + ".FID is not null then g" + (i + 1) + ".FLongNumber || '!' || aat" + (i + 1) + ".FNumber else null end FLongNumber" + (i + 1) + ", \n");
                    }
                    if (!aat.getBoolean("showLongName")) continue;
                    sql.append("    case when aat" + (i + 1) + ".FID is not null then g" + (i + 1) + ".FDisplayName_" + loc + " || '_' || aat" + (i + 1) + ".FName_" + loc + " else null end FLongName" + (i + 1) + ", \n");
                    continue;
                }
                if (aat.getBoolean("showLongNumber")) {
                    sql.append("    aat" + (i + 1) + ".FLongNumber FLongNumber" + (i + 1) + ", \n");
                }
                if (!aat.getBoolean("showLongName")) continue;
                sql.append("    aat" + (i + 1) + ".FDisplayName_" + loc + " FLongName" + (i + 1) + ", \n");
                continue;
            }
            if (aat.getBoolean("showLongNumber")) {
                sql.append("    aat" + (i + 1) + ".FNumber FLongNumber" + (i + 1) + ", \n");
            }
            if (!aat.getBoolean("showLongName")) continue;
            sql.append("    aat" + (i + 1) + ".FName_" + loc + " FLongName" + (i + 1) + ", \n");
        }
        sql.append("    hg.FID \n");
        sql.append("from T_BD_AssistantHG hg \n");
        for (i = 0; i < aats.size(); ++i) {
            aat = aats.get(i);
            sql.append("left join " + aat.getRealtionDataObject() + " aat" + (i + 1) + " on aat" + (i + 1) + ".FID = hg." + aat.getMappingFieldName() + " \n");
            if (!aat.isIsMultilevel() || aat.getGroupTableName() == null || !aat.getBoolean("showLongNumber") && !aat.getBoolean("showLongName")) continue;
            sql.append("left join " + aat.getGroupTableName() + " g" + (i + 1) + " on g" + (i + 1) + ".FID = aat" + (i + 1) + "." + aat.getGroupMappingFieldName() + " \n");
        }
        if (asstAccountId != null) {
            sql.append("where hg.FAsstAccountID = ? \n");
            params.add(asstAccountId);
            sql.append("and hg.FID in ");
        } else {
            sql.append("where hg.FID in ");
        }
        sql.append(SQLUtil.buildMarkSQL(ids.size()));
        params.addAll(ids);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
        while (rs.next()) {
            HashMap<String, String> hg = new HashMap<String, String>();
            for (int i2 = 0; i2 < aats.size(); ++i2) {
                AsstActTypeInfo aat2 = aats.get(i2);
                if (aat2.getBoolean("showId")) {
                    hg.put(aat2.getNumber() + ".id", rs.getString("FID" + (i2 + 1)));
                }
                if (!aat2.containsKey("showNumber") || aat2.getBoolean("showNumber")) {
                    hg.put(aat2.getNumber() + ".number", rs.getString("FNumber" + (i2 + 1)));
                }
                if (!aat2.containsKey("showName") || aat2.getBoolean("showName")) {
                    hg.put(aat2.getNumber() + ".name", rs.getString("FName" + (i2 + 1)));
                }
                if (aat2.getBoolean("showLongNumber")) {
                    hg.put(aat2.getNumber() + ".longNumber", rs.getString("FLongNumber" + (i2 + 1)));
                }
                if (!aat2.getBoolean("showLongName")) continue;
                hg.put(aat2.getNumber() + ".longName", rs.getString("FLongName" + (i2 + 1)));
            }
            result.put(rs.getString("FID"), hg);
        }
        return result;
    }
}

