/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.basedata.master.account.BalanceDirectionEnum;
import com.kingdee.eas.fi.gl.GLAsstBalanceKey;
import com.kingdee.eas.fi.gl.GlUtils;
import java.io.Serializable;
import java.math.BigDecimal;

public class GLAsstBalanceInfo
implements Serializable {
    private static final long serialVersionUID = 8951978928808982755L;
    private GLAsstBalanceKey key = null;
    private BigDecimal debitFor = GlUtils.zero;
    private BigDecimal debitLocal = GlUtils.zero;
    private BigDecimal creditFor = GlUtils.zero;
    private BigDecimal creditLocal = GlUtils.zero;
    private BigDecimal origAmount = GlUtils.zero;
    private BigDecimal localAmount = GlUtils.zero;

    public GLAsstBalanceInfo(GLAsstBalanceKey key) {
        this.key = key;
    }

    public GLAsstBalanceKey getKey() {
        return this.key;
    }

    public BigDecimal getOrigAmount() {
        return this.origAmount;
    }

    public void setOrigAmount(BigDecimal origAmount) {
        if (origAmount != null) {
            this.origAmount = origAmount;
        }
    }

    public BigDecimal getLocalAmount() {
        return this.localAmount;
    }

    public void setLocalAmount(BigDecimal localAmount) {
        if (localAmount != null) {
            this.localAmount = localAmount;
        }
    }

    public BigDecimal getDebitFor() {
        return this.debitFor;
    }

    public void setDebitFor(BigDecimal debitFor) {
        this.debitFor = debitFor;
    }

    public BigDecimal getDebitLocal() {
        return this.debitLocal;
    }

    public void setDebitLocal(BigDecimal debitLocal) {
        this.debitLocal = debitLocal;
    }

    public BigDecimal getCreditFor() {
        return this.creditFor;
    }

    public void setCreditFor(BigDecimal creditFor) {
        this.creditFor = creditFor;
    }

    public BigDecimal getCreditLocal() {
        return this.creditLocal;
    }

    public void setCreditLocal(BigDecimal creditLocal) {
        this.creditLocal = creditLocal;
    }

    public void add(GLAsstBalanceInfo augend) throws BOSException {
        if (augend == null) {
            return;
        }
        if (!this.key.equals(augend.key)) {
            throw new BOSException("The hgId not equal!");
        }
        this.debitFor = this.debitFor.add(augend.getDebitFor());
        this.debitLocal = this.debitLocal.add(augend.getDebitLocal());
        this.creditFor = this.creditFor.add(augend.getCreditFor());
        this.creditLocal = this.creditLocal.add(augend.getCreditLocal());
        this.origAmount = this.origAmount.add(augend.origAmount);
        this.localAmount = this.localAmount.add(augend.localAmount);
    }

    public void subtract(GLAsstBalanceInfo subtrahend) throws BOSException {
        if (subtrahend == null) {
            return;
        }
        if (!this.key.equals(subtrahend.key)) {
            throw new BOSException("The hgId not equal!");
        }
        this.debitFor = this.debitFor.subtract(subtrahend.getDebitFor());
        this.debitLocal = this.debitLocal.subtract(subtrahend.getDebitLocal());
        this.creditFor = this.creditFor.subtract(subtrahend.getCreditFor());
        this.creditLocal = this.creditLocal.subtract(subtrahend.getCreditLocal());
        this.origAmount = this.origAmount.subtract(subtrahend.origAmount);
        this.localAmount = this.localAmount.subtract(subtrahend.localAmount);
    }

    public void negate() {
        this.debitFor = this.debitFor.negate();
        this.debitLocal = this.debitLocal.negate();
        this.creditFor = this.creditFor.negate();
        this.creditLocal = this.creditLocal.negate();
        this.origAmount = this.origAmount.negate();
        this.localAmount = this.localAmount.negate();
    }

    public boolean equalZero() {
        return this.origAmount.doubleValue() == 0.0 && this.localAmount.doubleValue() == 0.0;
    }

    public int compareToZero() throws BOSException {
        int dc = 1;
        if (this.key.getAccount().getDC() == BalanceDirectionEnum.CREDIT) {
            dc = -1;
        }
        if (this.origAmount.doubleValue() * (double)dc < 0.0) {
            return -1;
        }
        if (this.equalZero()) {
            return 0;
        }
        return 1;
    }
}

