/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.fi.gl.rpt.GLRptBaseCondition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class GLBalanceUtils {
    public static final String T_ACCOUNT_BALANCE = "T_GL_AccountBalance";
    public static final String T_ASSIST_BALANCE = "T_GL_AssistBalance";
    public static final String T_MEASURE_BALANCE = "T_GL_AssistMeasureBalance";
    public static final int ACCOUNT_BALANCE = 1;
    public static final int ASSIST_BALANCE = 2;
    public static final int MEASURE_BALANCE = 3;

    public static String getBalanceTable(int balanceType, int balType, String currencyId) {
        String table = null;
        if (balanceType == 1) {
            table = T_ACCOUNT_BALANCE;
        } else if (balanceType == 2) {
            table = T_ASSIST_BALANCE;
        } else if (balanceType == 3) {
            table = T_MEASURE_BALANCE;
        } else {
            throw new IllegalArgumentException("tableType must be 1, 2 or 3.");
        }
        if (balType == 1) {
            table = "11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId) ? table + "_1L" : ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId) ? table + "_1R" : table + "_1F");
        } else if (balType == 5) {
            table = "11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId) ? table + "_5L" : ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId) ? table + "_5R" : table + "_5F");
        } else {
            throw new IllegalArgumentException("balType must be 1 or 5.");
        }
        return table;
    }

    public static String getAccountBalanceTable(int baltype, String currencyId) {
        return GLBalanceUtils.getBalanceTable(1, baltype, currencyId);
    }

    public static String getAssistBalanceTable(int baltype, String currencyId) {
        return GLBalanceUtils.getBalanceTable(2, baltype, currencyId);
    }

    public static String getAssistMeasureBalanceTable(int baltype, String currencyId) {
        return GLBalanceUtils.getBalanceTable(3, baltype, currencyId);
    }

    public static String getAccountBalanceTable(int balType) {
        return GLBalanceUtils.getAccountBalanceTable(balType, null);
    }

    public static String getAssistBalanceTable(int balType) {
        return GLBalanceUtils.getAssistBalanceTable(balType, null);
    }

    public static String getAssistMeasureBalanceTable(int balType) {
        return GLBalanceUtils.getAssistMeasureBalanceTable(balType, null);
    }

    public static String getAccountBalanceTable(GLRptBaseCondition cond) {
        return GLBalanceUtils.getAccountBalanceTable(cond.getOptionPosting() ? 1 : 5, cond.getCurrencyID());
    }

    public static String getAssistBalanceTable(GLRptBaseCondition cond) {
        return GLBalanceUtils.getAssistBalanceTable(cond.getOptionPosting() ? 1 : 5, cond.getCurrencyID());
    }

    public static String getAssistMeasureBalanceTable(GLRptBaseCondition cond) {
        return GLBalanceUtils.getAssistMeasureBalanceTable(cond.getOptionPosting() ? 1 : 5, cond.getCurrencyID());
    }

    public static Map<String, Object> translateEntityViewInfo(Context ctx, EntityViewInfo view) throws BOSException {
        SorterItemCollection sorter;
        SelectorItemCollection selector;
        HashMap<String, Object> result = new HashMap<String, Object>();
        int baltype = 5;
        String currencyId = null;
        boolean isQueryCurrency = false;
        boolean isQueryPeriod = false;
        result.put("baltype", baltype);
        result.put("currencyId", currencyId);
        result.put("isQueryCurrency", isQueryCurrency);
        result.put("isQueryPeriod", isQueryPeriod);
        result.put("view", view);
        if (view == null) {
            return result;
        }
        FilterInfo filter = view.getFilter();
        if (filter != null && filter.getFilterItems() != null) {
            Object compareValue;
            Object item;
            int i;
            FilterItemCollection fic = filter.getFilterItems();
            ArrayList<Object> currencyFilters = new ArrayList<Object>();
            ArrayList<Object> periodFilters = new ArrayList<Object>();
            ArrayList<Object> replaceFilters = new ArrayList<Object>();
            for (i = 0; i < fic.size(); ++i) {
                Set set;
                item = fic.get(i);
                String string = ((String)item.get("propertyName")).toLowerCase();
                CompareType compareType = (CompareType)item.get("compareType");
                compareValue = item.get("compareValue");
                if (string.startsWith("baltype")) {
                    Object v;
                    Integer tBaltype = null;
                    if (CompareType.EQUALS.equals((Object)compareType) && compareValue instanceof Integer) {
                        tBaltype = (Integer)compareValue;
                    } else if (CompareType.INCLUDE.equals((Object)compareType) && compareValue instanceof Set && (set = (Set)compareValue).size() == 1 && (v = set.iterator().next()) instanceof Integer) {
                        tBaltype = (Integer)v;
                    }
                    if (tBaltype != null && (tBaltype == 1 || tBaltype == 5)) {
                        baltype = tBaltype;
                    }
                    replaceFilters.add(item);
                    continue;
                }
                if (string.startsWith("currency")) {
                    if (string.equals("currency") || string.equals("currency.id")) {
                        String tCurrencyId = null;
                        if (CompareType.EQUALS.equals((Object)compareType)) {
                            tCurrencyId = compareValue.toString();
                        } else if (CompareType.INCLUDE.equals((Object)compareType) && compareValue instanceof Set && (set = (Set)compareValue).size() == 1) {
                            tCurrencyId = set.iterator().next().toString();
                        }
                        if (tCurrencyId != null) {
                            currencyId = "11111111-1111-1111-1111-111111111111DEB58FDC".equals(tCurrencyId) ? "11111111-1111-1111-1111-111111111111DEB58FDC" : ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(tCurrencyId) ? "22222222-2222-2222-2222-222222222222DEB58FDC" : null);
                        }
                    }
                    currencyFilters.add(item);
                    continue;
                }
                if (!string.startsWith("period")) continue;
                if ((string.equals("period") || string.equals("period.id")) && (CompareType.EQUALS.equals((Object)compareType) || CompareType.NOTEQUALS.equals((Object)compareType) || CompareType.INCLUDE.equals((Object)compareType) || CompareType.NOTINCLUDE.equals((Object)compareType))) {
                    item.put("propertyName", (Object)"period");
                    periodFilters.add(item);
                    continue;
                }
                if (string.equals("period.number")) {
                    item.put("propertyName", (Object)"period");
                    continue;
                }
                replaceFilters.add(item);
            }
            if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId) || "22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId)) {
                replaceFilters.addAll(currencyFilters);
            }
            if (periodFilters.size() > 0) {
                HashSet<String> periodIds = new HashSet<String>();
                for (FilterItemInfo filterItemInfo : periodFilters) {
                    CompareType compareType = (CompareType)filterItemInfo.get("compareType");
                    compareValue = filterItemInfo.get("compareValue");
                    if (CompareType.EQUALS.equals((Object)compareType) || CompareType.NOTEQUALS.equals((Object)compareType)) {
                        periodIds.add(compareValue.toString());
                        continue;
                    }
                    if (!(compareValue instanceof Set)) continue;
                    periodIds.addAll((Set)compareValue);
                }
                HashMap<String, PeriodInfo> pMap = new HashMap<String, PeriodInfo>();
                if (periodIds.size() > 0) {
                    EntityViewInfo entityViewInfo = new EntityViewInfo();
                    FilterInfo filterInfo = new FilterInfo();
                    filterInfo.getFilterItems().add(new FilterItemInfo("id", periodIds, CompareType.INCLUDE));
                    entityViewInfo.setFilter(filterInfo);
                    SelectorItemCollection s = new SelectorItemCollection();
                    s.add("id");
                    s.add("number");
                    PeriodCollection pcoll = PeriodFactory.getLocalInstance((Context)ctx).getPeriodCollection(entityViewInfo);
                    for (int i2 = 0; i2 < pcoll.size(); ++i2) {
                        pMap.put(pcoll.get(i2).getId().toString(), pcoll.get(i2));
                    }
                }
                for (FilterItemInfo filterItemInfo : periodFilters) {
                    CompareType compareType2 = (CompareType)filterItemInfo.get("compareType");
                    Object compareValue2 = filterItemInfo.get("compareValue");
                    if (CompareType.EQUALS.equals((Object)compareType2) || CompareType.NOTEQUALS.equals((Object)compareType2)) {
                        PeriodInfo p = (PeriodInfo)pMap.get(compareValue2.toString());
                        if (p != null) {
                            filterItemInfo.put("compareValue", (Object)p.getNumber());
                            continue;
                        }
                        replaceFilters.add(filterItemInfo);
                        continue;
                    }
                    if (compareValue2 instanceof Set) {
                        HashSet<Integer> numbers = new HashSet<Integer>();
                        Iterator it = ((Set)compareValue2).iterator();
                        while (it.hasNext()) {
                            PeriodInfo p = (PeriodInfo)pMap.get(it.next().toString());
                            if (p != null) {
                                numbers.add(p.getNumber());
                            }
                            if (numbers.size() > 0) {
                                filterItemInfo.put("compareValue", numbers);
                                continue;
                            }
                            replaceFilters.add(filterItemInfo);
                        }
                        continue;
                    }
                    replaceFilters.add(filterItemInfo);
                }
            }
            for (i = fic.size() - 1; i >= 0; --i) {
                item = fic.get(i);
                for (FilterItemInfo filterItemInfo : replaceFilters) {
                    if (item != filterItemInfo) continue;
                    item.put("propertyName", (Object)"period");
                    item.put("compareValue", null);
                    item.put("compareType", (Object)CompareType.NOTEQUALS);
                    item.setCompareValueIsProperty(false);
                }
            }
        }
        if ((selector = view.getSelector()) != null) {
            for (int i = selector.size() - 1; i >= 0; --i) {
                SelectorItemInfo item = selector.get(i);
                String propertyName = ((String)item.get("propertyName")).toLowerCase();
                if (propertyName.startsWith("baltype")) {
                    selector.remove(item);
                    continue;
                }
                if (propertyName.startsWith("currency")) {
                    isQueryCurrency = true;
                    if (!"11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId) && !"22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId)) continue;
                    selector.remove(item);
                    continue;
                }
                if (propertyName.startsWith("period")) {
                    isQueryPeriod = true;
                    if (propertyName.equals("period.number") || propertyName.equals("period.*")) {
                        item.put("propertyName", (Object)"period");
                        continue;
                    }
                    selector.remove(item);
                    continue;
                }
                if (!propertyName.equals("*")) continue;
                isQueryCurrency = true;
                isQueryPeriod = true;
            }
        }
        if ((sorter = view.getSorter()) != null) {
            for (int i = sorter.size() - 1; i >= 0; --i) {
                SorterItemInfo item = sorter.get(i);
                String propertyName = ((String)item.get("propertyName")).toLowerCase();
                if (propertyName.startsWith("baltype")) {
                    sorter.remove(item);
                    continue;
                }
                if (propertyName.startsWith("currency")) {
                    if (!"11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId) && !"22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId)) continue;
                    sorter.remove(item);
                    continue;
                }
                if (!propertyName.startsWith("period")) continue;
                if (propertyName.equals("period.number")) {
                    item.put("propertyName", (Object)"period");
                    continue;
                }
                sorter.remove(item);
            }
        }
        result.put("baltype", baltype);
        result.put("currencyId", currencyId);
        result.put("isQueryCurrency", isQueryCurrency);
        result.put("isQueryPeriod", isQueryPeriod);
        result.put("view", view);
        return result;
    }
}

