/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CashFlowItemCollection;
import com.kingdee.eas.basedata.assistant.CashFlowItemFactory;
import com.kingdee.eas.basedata.assistant.CashFlowItemInfo;
import com.kingdee.eas.basedata.assistant.CostItemInfo;
import com.kingdee.eas.basedata.assistant.CostObjectCollection;
import com.kingdee.eas.basedata.assistant.CostObjectInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICashFlowItem;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.IMeasureUnit;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.ISettlementType;
import com.kingdee.eas.basedata.assistant.IVoucherType;
import com.kingdee.eas.basedata.assistant.IVoucherTypeCtrlItem;
import com.kingdee.eas.basedata.assistant.MeasureUnitCollection;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SettlementTypeCollection;
import com.kingdee.eas.basedata.assistant.SettlementTypeFactory;
import com.kingdee.eas.basedata.assistant.SettlementTypeInfo;
import com.kingdee.eas.basedata.assistant.VoucherTypeCollection;
import com.kingdee.eas.basedata.assistant.VoucherTypeCtrlItemCollection;
import com.kingdee.eas.basedata.assistant.VoucherTypeCtrlItemFactory;
import com.kingdee.eas.basedata.assistant.VoucherTypeFactory;
import com.kingdee.eas.basedata.assistant.VoucherTypeInfo;
import com.kingdee.eas.basedata.framework.DataBaseDUtil;
import com.kingdee.eas.basedata.framework.IDataBaseD;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.IAccountView;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.AuxAccountUtils;
import com.kingdee.eas.basedata.master.auxacct.IAssistantHG;
import com.kingdee.eas.basedata.master.auxacct.IAsstActType;
import com.kingdee.eas.basedata.master.auxacct.ShareTacticEnum;
import com.kingdee.eas.basedata.master.cssp.CustomerCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.ICustomer;
import com.kingdee.eas.basedata.master.cssp.ISupplier;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.IProfitCenterOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitRelationCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitCollection;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.RunningBusinessMethod;
import com.kingdee.eas.fi.gl.VoucherFacadeFactory;
import com.kingdee.eas.fi.gl.WSVoucherInfo;
import com.kingdee.eas.fi.gl.cache.VoucherProcessCache;
import com.kingdee.eas.fi.gl.validator.AssistCuSuStatusValidator;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.DataBaseCollection;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class GlWebServiceUtil {
    private static final Logger logger = Logger.getLogger(GlWebServiceUtil.class);
    private static Map<String, Object> synObjs = new HashMap<String, Object>();
    private static Map wsObject = null;
    public static String TABLENAME_SUPPLIER = "t_bd_supplier";
    public static String TABLENAME_CUSTOMER = "t_bd_customer";
    public static String FI_INFO_TABLENAME_SUPPLIER = "T_BD_SupplierCompanyInfo";
    public static String FI_INFO_TABLENAME_CUSTOMER = "T_BD_CustomerCompanyInfo";
    public static String FIELDNAME_SUPPLIER = "FsupplierId";
    public static String FIELDNAME_CUSTOMER = "FcustomerId";

    public static Map getWsObject(Context ctx, String orgunitid, String key) {
        HashMap keyMap;
        String orgKey;
        HashMap orgunitMap;
        if (wsObject == null) {
            wsObject = new HashMap();
        }
        if ((orgunitMap = (HashMap)wsObject.get(orgKey = ctx.getAIS() + orgunitid)) == null) {
            orgunitMap = new HashMap();
            wsObject.put(orgKey, orgunitMap);
        }
        if ((keyMap = (HashMap)orgunitMap.get(key)) == null) {
            keyMap = new HashMap();
            orgunitMap.put(key, keyMap);
        }
        return keyMap;
    }

    public static void setWsObject(Context ctx, String orgunitid, String key) {
        String orgKey;
        HashMap orgunitMap;
        if (wsObject == null) {
            wsObject = new HashMap();
        }
        if ((orgunitMap = (HashMap)wsObject.get(orgKey = ctx.getAIS() + orgunitid)) == null) {
            orgunitMap = new HashMap();
            wsObject.put(orgKey, orgunitMap);
        }
        if (orgunitMap.containsKey(key)) {
            orgunitMap.remove(key);
        }
    }

    public static void setWsObjectKeyMap(Context ctx, String orgunitid, String key, String objectKey) {
        HashMap keyMap;
        String orgKey;
        HashMap orgunitMap;
        if (wsObject == null) {
            wsObject = new HashMap();
        }
        if ((orgunitMap = (HashMap)wsObject.get(orgKey = ctx.getAIS() + orgunitid)) == null) {
            orgunitMap = new HashMap();
            wsObject.put(orgKey, orgunitMap);
        }
        if ((keyMap = (HashMap)orgunitMap.get(key)) == null) {
            keyMap = new HashMap();
            orgunitMap.put(key, keyMap);
        }
        if (keyMap.containsKey(objectKey)) {
            keyMap.remove(objectKey);
        }
    }

    public static CompanyOrgUnitInfo getCompany(Context ctx, String companyNumber) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.addObjectCollection((IObjectCollection)GlUtils.getCompanySic());
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("number", (Object)companyNumber));
        fic.add(new FilterItemInfo("isBizUnit", (Object)new Integer(1)));
        view.setFilter(filter);
        ICompanyOrgUnit comCtrl = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitCollection companyCollection = comCtrl.getCompanyOrgUnitCollection(view);
        CompanyOrgUnitInfo orgUnitInfo = null;
        if (companyCollection != null && companyCollection.size() != 0) {
            orgUnitInfo = companyCollection.get(0);
        }
        return orgUnitInfo;
    }

    public static PeriodCollection fetchPeriod(Context ctx, String periodTypeId, Date time) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("periodYear"));
        sic.add(new SelectorItemInfo("periodNumber"));
        sic.add(new SelectorItemInfo("beginDate"));
        sic.add(new SelectorItemInfo("endDate"));
        sic.add(new SelectorItemInfo("isAdjustPeriod"));
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("periodType.id", (Object)periodTypeId));
        fic.add(new FilterItemInfo("beginDate", (Object)time, CompareType.LESS_EQUALS));
        fic.add(new FilterItemInfo("endDate", (Object)time, CompareType.GREATER_EQUALS));
        IPeriod prdCtrl = PeriodFactory.getLocalInstance((Context)ctx);
        PeriodCollection objs = prdCtrl.getPeriodCollection(view);
        return objs;
    }

    public static PeriodCollection fetchPeriodByContext(Context ctx, String periodTypeId, Date time) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("periodYear"));
        sic.add(new SelectorItemInfo("periodNumber"));
        sic.add(new SelectorItemInfo("beginDate"));
        sic.add(new SelectorItemInfo("endDate"));
        sic.add(new SelectorItemInfo("isAdjustPeriod"));
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("periodType.id", (Object)periodTypeId));
        fic.add(new FilterItemInfo("beginDate", (Object)time, CompareType.LESS_EQUALS));
        fic.add(new FilterItemInfo("endDate", (Object)time, CompareType.GREATER_EQUALS));
        IPeriod prdCtrl = PeriodFactory.getLocalInstance((Context)ctx);
        PeriodCollection objs = prdCtrl.getPeriodCollection(view);
        return objs;
    }

    public static PeriodCollection fetchPeriod(String periodTypeId, Date time) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("periodYear"));
        sic.add(new SelectorItemInfo("periodNumber"));
        sic.add(new SelectorItemInfo("beginDate"));
        sic.add(new SelectorItemInfo("endDate"));
        sic.add(new SelectorItemInfo("isAdjustPeriod"));
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("periodType.id", (Object)periodTypeId));
        fic.add(new FilterItemInfo("beginDate", (Object)time, CompareType.LESS_EQUALS));
        fic.add(new FilterItemInfo("endDate", (Object)time, CompareType.GREATER_EQUALS));
        IPeriod prdCtrl = PeriodFactory.getRemoteInstance();
        PeriodCollection objs = prdCtrl.getPeriodCollection(view);
        return objs;
    }

    public static PeriodInfo fetchPeriod(Context ctx, String periodTypeId, int year, int number) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("periodYear"));
        sic.add(new SelectorItemInfo("periodNumber"));
        sic.add(new SelectorItemInfo("beginDate"));
        sic.add(new SelectorItemInfo("endDate"));
        sic.add(new SelectorItemInfo("periodType"));
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("periodType.id", (Object)periodTypeId));
        fic.add(new FilterItemInfo("periodYear", (Object)new Integer(year)));
        fic.add(new FilterItemInfo("periodNumber", (Object)new Integer(number)));
        IPeriod prdCtrl = PeriodFactory.getLocalInstance((Context)ctx);
        CoreBaseCollection objs = prdCtrl.getCollection(view);
        if (objs.size() > 0) {
            return (PeriodInfo)objs.getObject(0);
        }
        return null;
    }

    public static VoucherTypeInfo findVouherTypeByName(Context ctx, String strName, BOSUuid cu) throws BOSException {
        if (strName == null || strName.trim().equals("")) {
            return null;
        }
        IVoucherType voucherType = VoucherTypeFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("name", (Object)strName.trim()));
        BOSUuid pk = cu;
        FilterInfo filterVT = new FilterInfo();
        try {
            filterVT = VoucherTypeFactory.getLocalInstance((Context)ctx).getDatabaseDFilter((IObjectPK)new ObjectUuidPK(pk.toString()), "id", "adminCU");
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
        filter.mergeFilter(filterVT, "and");
        view.setFilter(filter);
        VoucherTypeInfo voucherTypeInfo = null;
        VoucherTypeCollection voucherTypeCollection = voucherType.getVoucherTypeCollection(view);
        if (voucherTypeCollection != null && voucherTypeCollection.size() != 0) {
            voucherTypeInfo = voucherTypeCollection.get(0);
        }
        if (voucherTypeInfo == null) {
            return null;
        }
        VoucherTypeCtrlItemCollection voucherTypeCtrlItemCollection = voucherTypeInfo.getItems();
        view = new EntityViewInfo();
        filter = new FilterInfo();
        view.setFilter(filter);
        fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("voucherType.id", (Object)voucherTypeInfo.getId().toString()));
        fic.add(new FilterItemInfo("company.id", (Object)cu));
        SelectorItemCollection sicItem = view.getSelector();
        sicItem.add(new SelectorItemInfo("id"));
        sicItem.add(new SelectorItemInfo("level"));
        sicItem.add(new SelectorItemInfo("account.number"));
        sicItem.add(new SelectorItemInfo("account.longNumber"));
        IVoucherTypeCtrlItem ciCtrl = VoucherTypeCtrlItemFactory.getLocalInstance((Context)ctx);
        VoucherTypeCtrlItemCollection ciCol = ciCtrl.getVoucherTypeCtrlItemCollection(view);
        voucherTypeCtrlItemCollection.addCollection(ciCol);
        return voucherTypeInfo;
    }

    public static VoucherTypeInfo findVouherTypeByNumber(Context ctx, String strNumber, BOSUuid cu) throws BOSException {
        if (strNumber == null || strNumber.trim().equals("")) {
            return null;
        }
        IVoucherType voucherType = VoucherTypeFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("number", (Object)strNumber.trim()));
        BOSUuid pk = cu;
        FilterInfo filterVT = new FilterInfo();
        try {
            filterVT = VoucherTypeFactory.getLocalInstance((Context)ctx).getDatabaseDFilter((IObjectPK)new ObjectUuidPK(pk.toString()), "id", "adminCU");
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
        filter.mergeFilter(filterVT, "and");
        view.setFilter(filter);
        VoucherTypeInfo voucherTypeInfo = null;
        VoucherTypeCollection voucherTypeCollection = voucherType.getVoucherTypeCollection(view);
        if (voucherTypeCollection != null && voucherTypeCollection.size() != 0) {
            voucherTypeInfo = voucherTypeCollection.get(0);
        }
        if (voucherTypeInfo == null) {
            return null;
        }
        VoucherTypeCtrlItemCollection voucherTypeCtrlItemCollection = voucherTypeInfo.getItems();
        view = new EntityViewInfo();
        filter = new FilterInfo();
        view.setFilter(filter);
        fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("voucherType.id", (Object)voucherTypeInfo.getId().toString()));
        fic.add(new FilterItemInfo("company.id", (Object)cu));
        SelectorItemCollection sicItem = view.getSelector();
        sicItem.add(new SelectorItemInfo("id"));
        sicItem.add(new SelectorItemInfo("level"));
        sicItem.add(new SelectorItemInfo("account.number"));
        sicItem.add(new SelectorItemInfo("account.longNumber"));
        IVoucherTypeCtrlItem ciCtrl = VoucherTypeCtrlItemFactory.getLocalInstance((Context)ctx);
        VoucherTypeCtrlItemCollection ciCol = ciCtrl.getVoucherTypeCtrlItemCollection(view);
        voucherTypeCtrlItemCollection.addCollection(ciCol);
        return voucherTypeInfo;
    }

    public static AccountViewInfo findAccountViewInfoByNumber(Context ctx, String strNumber, CompanyOrgUnitInfo company) throws BOSException {
        if (StringUtil.isEmptyString((String)strNumber)) {
            return null;
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("longNumber"));
        sic.add(new SelectorItemInfo("longName"));
        sic.add(new SelectorItemInfo("level"));
        sic.add(new SelectorItemInfo("DC"));
        sic.add(new SelectorItemInfo("AC"));
        sic.add(new SelectorItemInfo("isQty"));
        sic.add(new SelectorItemInfo("control"));
        sic.add(new SelectorItemInfo("isCash"));
        sic.add(new SelectorItemInfo("isBank"));
        sic.add(new SelectorItemInfo("isCashEquivalent"));
        sic.add(new SelectorItemInfo("hasUserProperty"));
        sic.add(new SelectorItemInfo("isGFreeze"));
        sic.add(new SelectorItemInfo("isCFreeze"));
        sic.add(new SelectorItemInfo("isLeaf"));
        sic.add(new SelectorItemInfo("PLType"));
        sic.add(new SelectorItemInfo("measureUnitGroupID.id"));
        sic.add(new SelectorItemInfo("accountTypeID.property"));
        sic.add(new SelectorItemInfo("CAA.id"));
        sic.add(new SelectorItemInfo("CAA.name"));
        sic.add(new SelectorItemInfo("CAA.count"));
        sic.add(new SelectorItemInfo("CAA.isQty"));
        sic.add(new SelectorItemInfo("CAA.measureUnitGroup"));
        sic.add(new SelectorItemInfo("CAA.measureUnitGroup.id"));
        sic.add(new SelectorItemInfo("category"));
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("number", (Object)strNumber.trim()));
        fic.add(new FilterItemInfo("companyId.id", (Object)company.getId().toString()));
        fic.add(new FilterItemInfo("accountTableID.id", (Object)company.getAccountTable().getId().toString()));
        filter.setMaskString("#0 and #1 and #2");
        AccountViewInfo accountViewInfo = null;
        IAccountView accountView = AccountViewFactory.getLocalInstance((Context)ctx);
        AccountViewCollection accountViewCollection = accountView.getAccountViewCollection(view);
        if (accountViewCollection != null && accountViewCollection.size() != 0) {
            accountViewInfo = accountViewCollection.get(0);
        }
        return accountViewInfo;
    }

    public static CustomerInfo findCustomerNumber(Context ctx, String strNumber, CompanyOrgUnitInfo company) throws BOSException {
        if (StringUtil.isEmptyString((String)strNumber)) {
            return null;
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("number", (Object)strNumber.trim()));
        CustomerInfo customerInfo = null;
        ICustomer customer = CustomerFactory.getLocalInstance((Context)ctx);
        CustomerCollection customerCollection = customer.getCustomerCollection(view);
        if (customerCollection != null && customerCollection.size() != 0) {
            customerInfo = customerCollection.get(0);
        }
        return customerInfo;
    }

    public static CurrencyInfo findCurrencyByNumber(Context ctx, String fnumber) throws BOSException {
        if (StringUtil.isEmptyString((String)fnumber)) {
            return null;
        }
        ICurrency currency = CurrencyFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("precision"));
        sic.add(new SelectorItemInfo("isoCode"));
        sic.add(new SelectorItemInfo("deletedStatus"));
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("number", (Object)fnumber.trim()));
        view.setFilter(filter);
        CurrencyInfo currencyInfo = null;
        CurrencyCollection currencyCollection = currency.getCurrencyCollection(view);
        if (currencyCollection != null && currencyCollection.size() != 0) {
            currencyInfo = currencyCollection.get(0);
        }
        return currencyInfo;
    }

    public static MeasureUnitInfo findMeasureUnitByName(Context ctx, String measureUnitGroupID, String strName) throws BOSException {
        if (strName == null || StringUtils.isEmpty((String)strName)) {
            return null;
        }
        IMeasureUnit measure = MeasureUnitFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("coefficient"));
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        if (measureUnitGroupID != null && !StringUtils.isEmpty((String)measureUnitGroupID)) {
            fic.add(new FilterItemInfo("measureUnitGroup.id", (Object)measureUnitGroupID.trim()));
        }
        fic.add(new FilterItemInfo("number", (Object)strName.trim()));
        view.setFilter(filter);
        MeasureUnitInfo measureUnitInfo = null;
        MeasureUnitCollection measureUnitCollection = measure.getMeasureUnitCollection(view);
        if (measureUnitCollection != null && measureUnitCollection.size() != 0) {
            measureUnitInfo = measureUnitCollection.get(0);
        }
        if (measureUnitInfo == null) {
            filter = new FilterInfo();
            fic = filter.getFilterItems();
            if (measureUnitGroupID != null && !StringUtils.isEmpty((String)measureUnitGroupID)) {
                fic.add(new FilterItemInfo("measureUnitGroup.id", (Object)measureUnitGroupID.trim()));
            }
            fic.add(new FilterItemInfo("name", (Object)strName.trim()));
            view.setFilter(filter);
            measureUnitCollection = measure.getMeasureUnitCollection(view);
            if (measureUnitCollection != null && measureUnitCollection.size() != 0) {
                measureUnitInfo = measureUnitCollection.get(0);
            }
        }
        return measureUnitInfo;
    }

    public static UserInfo findUserUByName(Context ctx, String strName) throws BOSException {
        if (strName == null || strName.trim().equals("")) {
            return null;
        }
        IUser user = UserFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("number", (Object)strName.trim()));
        view.setFilter(filter);
        UserCollection userCollection = user.getUserCollection(view);
        if (userCollection != null && userCollection.size() != 0) {
            return userCollection.get(0);
        }
        filter = new FilterInfo();
        fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("name", (Object)strName.trim()));
        view.setFilter(filter);
        userCollection = user.getUserCollection(view);
        if (userCollection != null && userCollection.size() != 0) {
            return userCollection.get(0);
        }
        return null;
    }

    public static SettlementTypeInfo findSettelmentType(Context ctx, String number) throws BOSException {
        if (number == null || number.trim().length() == 0) {
            return null;
        }
        ISettlementType settlementType = SettlementTypeFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("number", (Object)number.trim()));
        SettlementTypeInfo settlementTypeInfo = null;
        SettlementTypeCollection settlementTypeCollection = settlementType.getSettlementTypeCollection(view);
        if (settlementTypeCollection != null && settlementTypeCollection.size() != 0) {
            settlementTypeInfo = settlementTypeCollection.get(0);
        }
        return settlementTypeInfo;
    }

    public static SettlementTypeInfo findSettelmentTypeByName(Context ctx, String strName) throws BOSException {
        if (strName == null || strName.trim().equals("")) {
            return null;
        }
        ISettlementType settlementType = SettlementTypeFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("name", (Object)strName.trim()));
        SettlementTypeInfo settlementTypeInfo = null;
        SettlementTypeCollection settlementTypeCollection = settlementType.getSettlementTypeCollection(view);
        if (settlementTypeCollection != null && settlementTypeCollection.size() != 0) {
            settlementTypeInfo = settlementTypeCollection.get(0);
        }
        return settlementTypeInfo;
    }

    public static AsstActTypeInfo findAsstActtypeNumberByName(Context ctx, String strAsstActTypeName) throws BOSException {
        if (strAsstActTypeName == null || strAsstActTypeName.trim().equals("")) {
            return null;
        }
        IAsstActType asstActType = AsstActTypeFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("asstHGAttribute"));
        sic.add(new SelectorItemInfo("mappingFieldName"));
        sic.add(new SelectorItemInfo("isMultilevel"));
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("name", (Object)strAsstActTypeName.trim()));
        AsstActTypeInfo asstActTypeInfo = null;
        AsstActTypeCollection asstActTypeCollection = asstActType.getAsstActTypeCollection(view);
        if (asstActTypeCollection != null && asstActTypeCollection.size() != 0) {
            asstActTypeInfo = asstActTypeCollection.get(0);
        }
        return asstActTypeInfo;
    }

    public static AsstActTypeInfo findAsstActTypeByNumber(Context ctx, String strAsstActTypeNumber) throws BOSException {
        if (strAsstActTypeNumber == null || strAsstActTypeNumber.trim().equals("")) {
            return null;
        }
        IAsstActType asstActType = AsstActTypeFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("asstHGAttribute"));
        sic.add(new SelectorItemInfo("mappingFieldName"));
        sic.add(new SelectorItemInfo("isMultilevel"));
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("number", (Object)strAsstActTypeNumber.trim()));
        AsstActTypeInfo asstActTypeInfo = null;
        AsstActTypeCollection asstActTypeCollection = asstActType.getAsstActTypeCollection(view);
        if (asstActTypeCollection != null && asstActTypeCollection.size() != 0) {
            asstActTypeInfo = asstActTypeCollection.get(0);
        }
        return asstActTypeInfo;
    }

    public static AsstActTypeInfo findAsstActtypeNumberByAttribute(Context ctx, String asstHGAttribute) throws BOSException {
        if (asstHGAttribute == null || asstHGAttribute.trim().equals("")) {
            return null;
        }
        IAsstActType asstActType = null;
        asstActType = ctx != null ? AsstActTypeFactory.getLocalInstance((Context)ctx) : AsstActTypeFactory.getRemoteInstance();
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("asstHGAttribute"));
        sic.add(new SelectorItemInfo("useLongNumber"));
        sic.add(new SelectorItemInfo("mappingFieldName"));
        sic.add(new SelectorItemInfo("isMultilevel"));
        sic.add(new SelectorItemInfo("groupTableName"));
        sic.add(new SelectorItemInfo("useLongNumber"));
        sic.add(new SelectorItemInfo("glAsstActTypeGrp.id"));
        sic.add(new SelectorItemInfo("glAsstActTypeGrp.shareTactic"));
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("asstHGAttribute", (Object)asstHGAttribute.trim()));
        AsstActTypeInfo asstActTypeInfo = null;
        AsstActTypeCollection asstActTypeCollection = asstActType.getAsstActTypeCollection(view);
        if (asstActTypeCollection != null && asstActTypeCollection.size() != 0) {
            asstActTypeInfo = asstActTypeCollection.get(0);
        }
        return asstActTypeInfo;
    }

    public static DataBaseInfo findAsstActObject(Context ctx, String asstHGAttribute, String number, String name, String cuid) throws BOSException {
        DataBaseInfo data;
        block27: {
            IAssistantHG iAssistantHG = AssistantHGFactory.getLocalInstance((Context)ctx);
            BOSObjectType type = iAssistantHG.getType();
            IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
            EntityObjectInfo eo = loader.getEntity(type);
            PropertyCollection props = eo.getInheritedNoDuplicatedProperties();
            Iterator itr = props.iterator();
            LinkPropertyInfo pi = null;
            data = null;
            try {
                DataBaseCollection collection;
                FilterInfo Dfilter;
                while (itr.hasNext()) {
                    PropertyInfo p = (PropertyInfo)itr.next();
                    if (!asstHGAttribute.equalsIgnoreCase(p.getName()) || !(p instanceof LinkPropertyInfo)) continue;
                    pi = (LinkPropertyInfo)p;
                    break;
                }
                if (pi == null) break block27;
                EntityObjectInfo eobj = pi.getRelationship().getSupplierObject();
                String strFacotry = eobj.getBusinessImplFactory();
                String strLocal = eobj.getBusinessImplName();
                EntityViewInfo view = new EntityViewInfo();
                SelectorItemCollection sic = view.getSelector();
                sic.add(new SelectorItemInfo("number"));
                sic.add(new SelectorItemInfo("name"));
                FilterInfo filter = new FilterInfo();
                view.setFilter(filter);
                FilterItemCollection fic = filter.getFilterItems();
                AsstActTypeInfo typeInfo = GlWebServiceUtil.findAsstActtypeNumberByAttribute(ctx, asstHGAttribute);
                if (typeInfo.isUseLongNumber() && number != null) {
                    fic.add(new FilterItemInfo("longNumber", (Object)number.replace('.', '!')));
                } else {
                    fic.add(new FilterItemInfo("number", (Object)number));
                }
                if ("customer".equalsIgnoreCase(asstHGAttribute)) {
                    fic.add(new FilterItemInfo("usedStatus", (Object)new Integer(1)));
                    Dfilter = GlWebServiceUtil.getDFilterInfo((IDataBaseD)CustomerFactory.getLocalInstance((Context)ctx), cuid);
                    if (Dfilter != null) {
                        filter.mergeFilter(Dfilter, "and");
                    }
                } else if ("provider".equalsIgnoreCase(asstHGAttribute)) {
                    fic.add(new FilterItemInfo("usedStatus", (Object)new Integer(1)));
                    Dfilter = GlWebServiceUtil.getDFilterInfo((IDataBaseD)SupplierFactory.getLocalInstance((Context)ctx), cuid);
                    if (Dfilter != null) {
                        filter.mergeFilter(Dfilter, "and");
                    }
                } else if ("material".equalsIgnoreCase(asstHGAttribute)) {
                    fic.add(new FilterItemInfo("status", (Object)new Integer(1)));
                } else if ("bankAccount".equalsIgnoreCase(asstHGAttribute)) {
                    sic.add(new SelectorItemInfo("bankAccountNumber"));
                    sic.add(new SelectorItemInfo("isByCurrency"));
                    sic.add(new SelectorItemInfo("bank.id"));
                    sic.add(new SelectorItemInfo("currency.id"));
                    sic.add(new SelectorItemInfo("account.id"));
                } else if (typeInfo.isIsMultilevel()) {
                    FilterInfo filter1 = new FilterInfo();
                    if (asstHGAttribute.equals("saleOrg") || asstHGAttribute.equals("profitOrg") || asstHGAttribute.equals("purchaseOrg") || asstHGAttribute.equals("storeageOrg") || asstHGAttribute.equals("companyOrg") || asstHGAttribute.equals("costOrg")) {
                        sic.add(new SelectorItemInfo("isBizUnit"));
                        fic.add(new FilterItemInfo("isBizUnit", (Object)new Integer(1)));
                    } else if (typeInfo.getGroupTableName() == null && (typeInfo.getGlAsstActTypeGrp() == null || !typeInfo.getGlAsstActTypeGrp().getShareTactic().equals((Object)ShareTacticEnum.S2) && !typeInfo.getGlAsstActTypeGrp().getShareTactic().equals((Object)ShareTacticEnum.B1))) {
                        sic.add(new SelectorItemInfo("isLeaf"));
                        fic.add(new FilterItemInfo("isLeaf", (Object)new Integer(1)));
                    } else if (typeInfo.getGlAsstActTypeGrp() != null) {
                        sic.add(new SelectorItemInfo("isLeaf"));
                        filter1.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)new Integer(1)));
                        String groupID = typeInfo.getGlAsstActTypeGrp().getId().toString();
                        String idCol = GlUtils.getGeneralCollection(ctx, groupID);
                        if (idCol.length() != 0) {
                            filter1.getFilterItems().add(new FilterItemInfo("id", (Object)idCol, CompareType.NOTINCLUDE));
                            filter1.setMaskString("#0 or #1");
                        }
                    }
                    if (typeInfo.getGlAsstActTypeGrp() != null) {
                        sic.add(new SelectorItemInfo("group.id"));
                        fic.add(new FilterItemInfo("group.id", (Object)typeInfo.getGlAsstActTypeGrp().getId().toString()));
                    }
                    if (filter1.getFilterItems().size() > 0) {
                        filter.mergeFilter(filter1, "and");
                    }
                }
                String strMethod = "getDataBaseCollection";
                Class[] argTypes = new Class[]{view.getClass()};
                Object[] args = new Object[]{view};
                Object result = null;
                try {
                    result = RunningBusinessMethod.runLocalMethod(ctx, strFacotry, strLocal, strMethod, argTypes, args);
                }
                catch (Exception e) {
                    strMethod = "getDataBaseCollection";
                    result = RunningBusinessMethod.runLocalMethod(ctx, strFacotry, strLocal, strMethod, argTypes, args, eobj.getType());
                }
                if (result != null && (collection = (DataBaseCollection)result).size() != 0) {
                    data = collection.get(0);
                }
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        return data;
    }

    public static DataBaseInfo findAsstActObject(Context ctx, String asstHGAttribute, String number, String name, String cuid, CompanyOrgUnitInfo company) throws BOSException {
        DataBaseInfo data;
        block73: {
            IAssistantHG iAssistantHG = AssistantHGFactory.getLocalInstance((Context)ctx);
            BOSObjectType type = iAssistantHG.getType();
            IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
            EntityObjectInfo eo = loader.getEntity(type);
            PropertyCollection props = eo.getInheritedNoDuplicatedProperties();
            Iterator itr = props.iterator();
            LinkPropertyInfo pi = null;
            data = null;
            try {
                FilterInfo Dfilter;
                while (itr.hasNext()) {
                    PropertyInfo p = (PropertyInfo)itr.next();
                    if (!asstHGAttribute.equalsIgnoreCase(p.getName()) || !(p instanceof LinkPropertyInfo)) continue;
                    pi = (LinkPropertyInfo)p;
                    break;
                }
                if (pi == null) break block73;
                EntityObjectInfo eobj = pi.getRelationship().getSupplierObject();
                String strFacotry = eobj.getBusinessImplFactory();
                String strLocal = eobj.getBusinessImplName();
                EntityViewInfo view = new EntityViewInfo();
                SelectorItemCollection sic = view.getSelector();
                sic.add(new SelectorItemInfo("number"));
                sic.add(new SelectorItemInfo("name"));
                FilterInfo filter = new FilterInfo();
                view.setFilter(filter);
                FilterItemCollection fic = filter.getFilterItems();
                AsstActTypeInfo typeInfo = ctx != null ? VoucherProcessCache.findAsstActTypeByAttribute(ctx, asstHGAttribute) : GlWebServiceUtil.findAsstActtypeNumberByAttribute(ctx, asstHGAttribute);
                if (typeInfo.isUseLongNumber() && number != null) {
                    fic.add(new FilterItemInfo("longNumber", (Object)number.replace('.', '!')));
                } else {
                    fic.add(new FilterItemInfo("number", (Object)number));
                }
                if ("customer".equalsIgnoreCase(asstHGAttribute)) {
                    sic.add(new SelectorItemInfo("isInternalCompany"));
                    fic.add(new FilterItemInfo("usedStatus", (Object)new Integer(1)));
                    Dfilter = GlWebServiceUtil.getDFilterInfo(company.getId().toString(), number, asstHGAttribute);
                    if (Dfilter != null) {
                        filter.mergeFilter(Dfilter, "and");
                    }
                } else if ("project".equalsIgnoreCase(asstHGAttribute)) {
                    String projectIsolate = GlWebServiceUtil.getProjectIsolateParam(ctx);
                    if ("1".equals(projectIsolate)) {
                        fic.add(new FilterItemInfo("company.id", (Object)company.getId().toString()));
                    } else if ("2".equals(projectIsolate)) {
                        String longNumber = company.getLongNumber();
                        String[] numberArr = longNumber.split("!");
                        HashSet<String> numberSet = new HashSet<String>();
                        numberSet.addAll(Arrays.asList(numberArr));
                        if (numberSet != null && numberSet.size() > 0) {
                            fic.add(new FilterItemInfo("company.number", numberSet, CompareType.INCLUDE));
                        }
                    }
                    fic.add(new FilterItemInfo("status", (Object)new Integer(2), CompareType.NOTEQUALS));
                } else if ("provider".equalsIgnoreCase(asstHGAttribute)) {
                    sic.add(new SelectorItemInfo("isInternalCompany"));
                    fic.add(new FilterItemInfo("usedStatus", (Object)new Integer(1)));
                    Dfilter = GlWebServiceUtil.getDFilterInfo(company.getId().toString(), number, asstHGAttribute);
                    if (Dfilter != null) {
                        filter.mergeFilter(Dfilter, "and");
                    }
                } else if ("material".equalsIgnoreCase(asstHGAttribute)) {
                    fic.add(new FilterItemInfo("status", (Object)new Integer(1)));
                } else if ("bankAccount".equalsIgnoreCase(asstHGAttribute)) {
                    fic.add(new FilterItemInfo("company.id", (Object)company.getId().toString()));
                    sic.add(new SelectorItemInfo("bankAccountNumber"));
                    sic.add(new SelectorItemInfo("isByCurrency"));
                    sic.add(new SelectorItemInfo("bank.id"));
                    sic.add(new SelectorItemInfo("currency.id"));
                    sic.add(new SelectorItemInfo("account.id"));
                    sic.add(new SelectorItemInfo("isClosed"));
                } else if ("costobject".equalsIgnoreCase(asstHGAttribute)) {
                    if (company == null) {
                        company = ContextUtil.getCurrentFIUnit((Context)ctx);
                    }
                    fic.add(new FilterItemInfo("company.id", (Object)company.getId().toString()));
                } else if ("costItem".equalsIgnoreCase(asstHGAttribute)) {
                    FilterInfo filterInfo;
                    if (company == null) {
                        company = ContextUtil.getCurrentFIUnit((Context)ctx);
                    }
                    if ((filterInfo = DataBaseDUtil.getDatabaseDFilter((Context)ctx, (BOSObjectType)new CostItemInfo().getBOSType(), (IObjectPK[])new IObjectPK[]{new ObjectUuidPK(company.getCU().getId().toString())}, (String)"id", (String)"cu.id")) != null) {
                        filter.mergeFilter(filterInfo, "and");
                    }
                } else if (typeInfo.isIsMultilevel()) {
                    FilterInfo filter1 = new FilterInfo();
                    if (asstHGAttribute.equals("saleOrg") || asstHGAttribute.equals("profitOrg") || asstHGAttribute.equals("purchaseOrg") || asstHGAttribute.equals("storeageOrg") || asstHGAttribute.equals("companyOrg") || asstHGAttribute.equals("costOrg")) {
                        String permItemName;
                        OrgType fromOrg;
                        sic.add(new SelectorItemInfo("isBizUnit"));
                        fic.add(new FilterItemInfo("isBizUnit", (Object)new Integer(1)));
                        CompanyOrgUnitInfo fiOrg = company;
                        if (fiOrg == null) {
                            fiOrg = ContextUtil.getCurrentFIUnit((Context)ctx);
                        }
                        HashMap param = new HashMap();
                        param.put("GL_043", fiOrg.getId().toString());
                        param.put("GL_069", fiOrg.getId().toString());
                        IParamControl pc = ParamControlFactory.getLocalInstance((Context)ctx);
                        param = pc.getParamHashMap(param);
                        if (asstHGAttribute.equals("costOrg")) {
                            fromOrg = OrgType.CostCenter;
                            permItemName = "CostCenter_View";
                        } else if (asstHGAttribute.equals("saleOrg")) {
                            fromOrg = OrgType.Sale;
                            permItemName = "Sale_View";
                        } else if (asstHGAttribute.equals("profitOrg")) {
                            fromOrg = OrgType.ProfitCenter;
                            permItemName = "ProfitCenter_View";
                        } else if (asstHGAttribute.equals("purchaseOrg")) {
                            fromOrg = OrgType.Purchase;
                            permItemName = "Purchase_View";
                        } else if (asstHGAttribute.equals("storeageOrg")) {
                            fromOrg = OrgType.Storage;
                            permItemName = "Storage_View";
                        } else if (asstHGAttribute.equals("companyOrg")) {
                            fromOrg = OrgType.Company;
                            permItemName = "Company_View";
                        } else {
                            fromOrg = OrgType.NONE;
                            permItemName = "Company_View";
                        }
                        if ("true".equals(param.get("GL_069")) && !asstHGAttribute.equals("companyOrg") && !asstHGAttribute.equals("profitOrg")) {
                            FilterInfo orFilter = new FilterInfo();
                            orFilter.getFilterItems().add(new FilterItemInfo("toUnit.id", (Object)fiOrg.getId().toString()));
                            orFilter.getFilterItems().add(new FilterItemInfo("typeRelation.toType", (Object)new Integer(1)));
                            orFilter.getFilterItems().add(new FilterItemInfo("typeRelation.fromType", (Object)new Integer(fromOrg.getValue())));
                            OrgUnitRelationCollection orColl = OrgUnitRelationFactory.getLocalInstance((Context)ctx).getOrgUnitRelationCollection(EntityViewInfo.getInstance((FilterInfo)orFilter, null, null));
                            HashSet<String> idSet = new HashSet<String>();
                            idSet.add(fiOrg.getId().toString());
                            int j = orColl.size();
                            for (int i = 0; i < j; ++i) {
                                idSet.add(orColl.get(i).getFromUnit().getId().toString());
                            }
                            fic.add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
                        } else if ("true".equals(param.get("GL_043"))) {
                            String userID = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
                            Map map = PermissionFactory.getLocalInstance((Context)ctx).getAuthorizedOrgs((IObjectPK)new ObjectUuidPK(userID), fromOrg, null, null, null);
                            if (map != null) {
                                fic.add(new FilterItemInfo("id", new HashSet(map.keySet()), CompareType.INCLUDE));
                            }
                            String rule = PermissionFactory.getLocalInstance((Context)ctx).getQueryPermissionSQL((IObjectPK)new ObjectUuidPK(userID), (IObjectPK)new ObjectUuidPK("11111111-1111-1111-1111-111111111111CCE7AED4"), permItemName);
                            String sql = "select id where id in (" + rule + ") and id in (select forgid from t_pm_orgrange where fuserid = '" + userID + "' and ftype = " + 10 + ")";
                            IObjectPK[] pks = FullOrgUnitFactory.getLocalInstance((Context)ctx).getPKList(sql);
                            if (pks != null) {
                                HashSet<IObjectPK> pkSet = new HashSet<IObjectPK>(Arrays.asList(pks));
                                fic.add(new FilterItemInfo("id", pkSet, CompareType.INCLUDE));
                            }
                        }
                    } else {
                        String groupID;
                        Object obj;
                        boolean runNew = false;
                        if (typeInfo.getGlAsstActTypeGrp() != null && (obj = VoucherProcessCache.getParam(ctx, null, "GL_ASSTACT_FindByNew")) != null) {
                            runNew = Boolean.valueOf(obj.toString());
                        }
                        if (runNew) {
                            sic.add(new SelectorItemInfo("isLeaf"));
                            sic.add(new SelectorItemInfo("group.id"));
                            groupID = typeInfo.getGlAsstActTypeGrp().getId().toString();
                            filter.getFilterItems().add(new FilterItemInfo("group.id", (Object)groupID));
                            filter.getFilterItems().add(new FilterItemInfo("isEnabled", (Object)new Integer(1)));
                            if (typeInfo.getGlAsstActTypeGrp().getShareTactic().equals((Object)ShareTacticEnum.S2) || typeInfo.getGlAsstActTypeGrp().getShareTactic().equals((Object)ShareTacticEnum.B1)) {
                                StringBuffer sql = new StringBuffer();
                                sql.append("select A.fparentid \n");
                                sql.append("from T_BD_Generalasstacttype A \n");
                                sql.append("inner join T_ORG_CtrlUnit D on D.FID='" + cuid + "' \n");
                                sql.append("inner join T_ORG_CtrlUnit E on E.FID=A.FControlUnitID ");
                                sql.append("and (CHARINDEX(E.FLongNumber||'!',D.FLongNumber)=1 or d.fid=e.fid) \n");
                                sql.append("where A.fparentid is not null and FgroupID='" + groupID + "' ");
                                filter.getFilterItems().add(new FilterItemInfo("id", (Object)sql.toString(), CompareType.NOTINNER));
                            }
                            FilterInfo gFilter = AuxAccountUtils.getFilterForGeneral((Context)ctx, (String)typeInfo.getGlAsstActTypeGrp().getId().toString(), (CompanyOrgUnitInfo[])new CompanyOrgUnitInfo[]{company});
                            String defaultSql = GlWebServiceUtil.oqlToSql(gFilter);
                            StringBuffer sql = new StringBuffer();
                            sql.append(" select cg.fparentid from T_BD_GeneralAsstActType cg ");
                            sql.append(" inner JOIN T_ORG_CtrlUnit AS CU ON cg.FControlUnitID = CU.FID ");
                            sql.append(" inner join T_ORG_Company AS creatorCompany ON cg.FCreatorCompanyID = creatorCompany.FID ");
                            sql.append(" where ");
                            sql.append(" cg.fparentid is not null  ");
                            if (groupID != null) {
                                sql.append(" and cg.fgroupid='").append(groupID).append("'");
                            }
                            if (defaultSql != null) {
                                sql.append(" and ( ").append(defaultSql);
                                sql.append(" ) ");
                            }
                            filter.getFilterItems().add(new FilterItemInfo("id", (Object)sql.toString(), CompareType.NOTINNER));
                            if (gFilter != null && gFilter.getFilterItems().size() > 0) {
                                filter.mergeFilter(gFilter, "and");
                            }
                        } else if (typeInfo.getGroupTableName() == null && (typeInfo.getGlAsstActTypeGrp() == null || !typeInfo.getGlAsstActTypeGrp().getShareTactic().equals((Object)ShareTacticEnum.S2) && !typeInfo.getGlAsstActTypeGrp().getShareTactic().equals((Object)ShareTacticEnum.B1))) {
                            sic.add(new SelectorItemInfo("isLeaf"));
                            if (typeInfo.getGlAsstActTypeGrp() == null) {
                                fic.add(new FilterItemInfo("isLeaf", (Object)new Integer(1)));
                            } else {
                                CompanyOrgUnitInfo[] coms = new CompanyOrgUnitInfo[]{company};
                                FilterInfo gengeralFilter = AuxAccountUtils.getFilterForGeneralAsstActType((Context)ctx, (String)typeInfo.getGlAsstActTypeGrp().getId().toString(), (CompanyOrgUnitInfo[])coms, (boolean)true);
                                filter.mergeFilter(gengeralFilter, "and");
                            }
                        } else {
                            if (typeInfo.getGlAsstActTypeGrp() != null) {
                                sic.add(new SelectorItemInfo("isLeaf"));
                                filter1.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)new Integer(1)));
                                groupID = typeInfo.getGlAsstActTypeGrp().getId().toString();
                                String idCol = GlUtils.getGeneralCollection(ctx, groupID, company.getId().toString(), cuid);
                                if (idCol.length() != 0) {
                                    filter1.getFilterItems().add(new FilterItemInfo("id", (Object)idCol, CompareType.NOTINCLUDE));
                                    filter1.setMaskString("#0 or #1");
                                }
                            }
                            sic.add(new SelectorItemInfo("group.id"));
                            filter.getFilterItems().add(new FilterItemInfo("group.id", (Object)typeInfo.getGlAsstActTypeGrp().getId().toString()));
                        }
                    }
                    if (filter1.getFilterItems().size() > 0) {
                        filter.mergeFilter(filter1, "and");
                    }
                }
                String strMethod = "getDataBaseCollection";
                Class[] argTypes = new Class[]{view.getClass()};
                Object[] args = new Object[]{view};
                Object result = null;
                try {
                    result = RunningBusinessMethod.runLocalMethod(ctx, strFacotry, strLocal, strMethod, argTypes, args);
                }
                catch (Exception e) {
                    strMethod = "getDataBaseCollection";
                    result = RunningBusinessMethod.runLocalMethod(ctx, strFacotry, strLocal, strMethod, argTypes, args, eobj.getType());
                }
                if (result != null) {
                    DataBaseCollection collection = (DataBaseCollection)result;
                    if (collection.size() != 0) {
                        data = collection.get(0);
                    }
                    if (data != null) {
                        int rtnResult;
                        AssistCuSuStatusValidator cusuStatusValidator = new AssistCuSuStatusValidator(ctx);
                        if ("customer".equalsIgnoreCase(asstHGAttribute)) {
                            int rtnResult2 = cusuStatusValidator.customerValidator(data.get("id").toString(), company.getId().toString());
                            if (rtnResult2 == 1) {
                                data = null;
                            }
                        } else if ("provider".equalsIgnoreCase(asstHGAttribute) && (rtnResult = cusuStatusValidator.supplierValidator(data.get("id").toString(), company.getId().toString())) == 1) {
                            data = null;
                        }
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
        }
        return data;
    }

    private static String oqlToSql(FilterInfo defaultFilter) {
        String sql = null;
        if (defaultFilter != null && defaultFilter.getFilterItems().size() > 0) {
            sql = defaultFilter.toSql();
            sql = sql.replaceAll("\\.id", ".fid");
            sql = sql.replaceAll("\\.longNumber", ".flongNumber");
        }
        return sql;
    }

    public static ObjectBaseInfo findAsstActObject(Context ctx, String asstHGAttribute, String id) throws BOSException {
        CostObjectInfo data;
        block12: {
            IAssistantHG iAssistantHG = AssistantHGFactory.getLocalInstance((Context)ctx);
            BOSObjectType type = iAssistantHG.getType();
            IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
            EntityObjectInfo eo = loader.getEntity(type);
            PropertyCollection props = eo.getInheritedNoDuplicatedProperties();
            Iterator itr = props.iterator();
            LinkPropertyInfo pi = null;
            data = null;
            try {
                while (itr.hasNext()) {
                    PropertyInfo p = (PropertyInfo)itr.next();
                    if (!asstHGAttribute.equalsIgnoreCase(p.getName()) || !(p instanceof LinkPropertyInfo)) continue;
                    pi = (LinkPropertyInfo)p;
                    break;
                }
                if (pi == null) break block12;
                EntityObjectInfo eobj = pi.getRelationship().getSupplierObject();
                String strFacotry = eobj.getBusinessImplFactory();
                String strLocal = eobj.getBusinessImplName();
                EntityViewInfo view = new EntityViewInfo();
                SelectorItemCollection sic = view.getSelector();
                sic.add(new SelectorItemInfo("number"));
                sic.add(new SelectorItemInfo("name"));
                FilterInfo filter = new FilterInfo();
                view.setFilter(filter);
                if (id != null && id.length() > 1) {
                    FilterItemCollection fic = filter.getFilterItems();
                    fic.add(new FilterItemInfo("id", (Object)id));
                }
                String strMethod = "getDataBaseCollection";
                if ("costObject".equals(asstHGAttribute)) {
                    strMethod = "getCostObjectCollection";
                }
                Class[] argTypes = new Class[]{view.getClass()};
                Object[] args = new Object[]{view};
                Object result = null;
                try {
                    result = RunningBusinessMethod.runLocalMethod(ctx, strFacotry, strLocal, strMethod, argTypes, args);
                }
                catch (Exception e) {
                    strMethod = "getDataBaseCollection";
                    result = RunningBusinessMethod.runLocalMethod(ctx, strFacotry, strLocal, strMethod, argTypes, args, eobj.getType());
                }
                if (result != null) {
                    if ("costObject".equals(asstHGAttribute)) {
                        CostObjectCollection collection = (CostObjectCollection)result;
                        if (collection.size() != 0) {
                            data = collection.get(0);
                        }
                    } else {
                        DataBaseCollection collection = (DataBaseCollection)result;
                        if (collection.size() != 0) {
                            data = collection.get(0);
                        }
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        return data;
    }

    public static FilterInfo getDFilterInfo(IDataBaseD iDaba, String cuid) throws Exception {
        ObjectUuidPK pk = new ObjectUuidPK(cuid);
        return iDaba.getDatabaseDFilter((IObjectPK)pk, "id", "adminCU.id");
    }

    public static FilterInfo getDFilterInfoForStandImp(IDataBaseD iDaba, String cuid) throws Exception {
        ObjectUuidPK pk = new ObjectUuidPK(cuid);
        if (iDaba instanceof ISupplier) {
            return iDaba.getDatabaseDFilter((IObjectPK)pk, "supplier.id", "supplier.adminCU.id");
        }
        return iDaba.getDatabaseDFilter((IObjectPK)pk, "customer.id", "customer.adminCU.id");
    }

    public static Object[] getExchangeRate(Context ctx, CompanyOrgUnitInfo companyOrgUnitInfo, CurrencyInfo currencyInfo, PeriodInfo period) throws EASBizException, BOSException {
        if (companyOrgUnitInfo.getBaseExchangeTable() == null || companyOrgUnitInfo.getReportExchangeTable() == null || companyOrgUnitInfo.getBaseCurrency() == null || companyOrgUnitInfo.getReportCurrency() == null) {
            return null;
        }
        Object[] info = new Object[8];
        info[0] = companyOrgUnitInfo.getBaseExchangeTable().getId().toString();
        info[1] = companyOrgUnitInfo.getReportExchangeTable().getId().toString();
        info[2] = currencyInfo.getId().toString();
        info[3] = companyOrgUnitInfo.getBaseCurrency().getId().toString();
        info[4] = companyOrgUnitInfo.getReportCurrency().getId().toString();
        info[5] = new Date();
        info[6] = period.getBeginDate();
        return VoucherFacadeFactory.getLocalInstance((Context)ctx).fetchExchangeRate(info);
    }

    public static Object[] getExchangeRateByBookDate(Context ctx, CompanyOrgUnitInfo companyOrgUnitInfo, CurrencyInfo currencyInfo, PeriodInfo period, Date bookDate) throws EASBizException, BOSException {
        if (companyOrgUnitInfo.getBaseExchangeTable() == null || companyOrgUnitInfo.getReportExchangeTable() == null || companyOrgUnitInfo.getBaseCurrency() == null || companyOrgUnitInfo.getReportCurrency() == null) {
            return null;
        }
        Object[] info = new Object[8];
        info[0] = companyOrgUnitInfo.getBaseExchangeTable().getId().toString();
        info[1] = companyOrgUnitInfo.getReportExchangeTable().getId().toString();
        info[2] = currencyInfo.getId().toString();
        info[3] = companyOrgUnitInfo.getBaseCurrency().getId().toString();
        info[4] = companyOrgUnitInfo.getReportCurrency().getId().toString();
        info[5] = bookDate;
        info[6] = period.getBeginDate();
        return VoucherFacadeFactory.getLocalInstance((Context)ctx).fetchExchangeRate(info);
    }

    public static PeriodInfo getPrePeriodInfo(Context ctx, PeriodInfo periodInfo) throws BOSException, EASBizException {
        return PeriodUtils.getPrePeriodInfo((Context)ctx, (PeriodInfo)periodInfo);
    }

    public static CashFlowItemInfo findCashflowItemByName(Context ctx, String strName, WSVoucherInfo wsVoucher, VoucherProcessCache cache) throws BOSException {
        return GlWebServiceUtil.findCashflowItemByName(ctx, strName, wsVoucher.getCompanyNumber(), cache);
    }

    public static CashFlowItemInfo findCashflowItemByName(Context ctx, String strName, String companyNumber, VoucherProcessCache cache) throws BOSException {
        if (strName == null || strName.trim().equals("")) {
            return null;
        }
        ICashFlowItem cashFlowItem = CashFlowItemFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("type"));
        sic.add(new SelectorItemInfo("direction"));
        sic.add(new SelectorItemInfo("isDealActivity"));
        sic.add(new SelectorItemInfo("items.account.id"));
        sic.add(new SelectorItemInfo("asstAccount.id"));
        sic.add(new SelectorItemInfo("asstAccount.count"));
        sic.add(new SelectorItemInfo("isLeaf"));
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("number", (Object)strName.trim()));
        fic.add(new FilterItemInfo("isFreeze", (Object)new Integer(0)));
        try {
            String cuid;
            FilterInfo viewfilter;
            CompanyOrgUnitInfo company = cache.getCompanyByNumber(ctx, companyNumber);
            if (company != null && company.getCU() != null && (viewfilter = cache.getCashFlowItemViewFromCache(ctx, cuid = company.getCU().getId().toString())) != null) {
                filter.mergeFilter(viewfilter, "and");
            }
        }
        catch (EASBizException e1) {
            throw new BOSException((Throwable)e1);
        }
        view.setFilter(filter);
        CashFlowItemInfo cashFlowItemInfo = null;
        CashFlowItemCollection cashFlowItemCollection = cashFlowItem.getCashFlowItemCollection(view);
        if (cashFlowItemCollection != null && cashFlowItemCollection.size() != 0) {
            cashFlowItemInfo = cashFlowItemCollection.get(0);
        }
        return cashFlowItemInfo;
    }

    public static boolean getImportParam(Context ctx, String companyID) throws BOSException, EASBizException {
        ObjectUuidPK comPK = new ObjectUuidPK(companyID);
        HashMap<String, ObjectUuidPK> hmParamIn = new HashMap<String, ObjectUuidPK>();
        hmParamIn.put("GL_016", comPK);
        IParamControl pc = null;
        pc = ctx != null ? ParamControlFactory.getLocalInstance((Context)ctx) : ParamControlFactory.getRemoteInstance();
        HashMap hmAllParam = pc.getParamHashMap(hmParamIn);
        boolean importParam = false;
        try {
            importParam = Boolean.valueOf(hmAllParam.get("GL_016").toString());
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        return importParam;
    }

    public static boolean getHandnumberParam(Context ctx, String companyID) throws BOSException, EASBizException {
        ObjectUuidPK comPK = new ObjectUuidPK(companyID);
        HashMap<String, ObjectUuidPK> hmParamIn = new HashMap<String, ObjectUuidPK>();
        hmParamIn.put("GL_031", comPK);
        IParamControl pc = null;
        pc = ctx != null ? ParamControlFactory.getLocalInstance((Context)ctx) : ParamControlFactory.getRemoteInstance();
        HashMap hmAllParam = pc.getParamHashMap(hmParamIn);
        boolean importParam = false;
        try {
            importParam = Boolean.valueOf(hmAllParam.get("GL_031").toString());
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        return importParam;
    }

    public static FilterInfo getFilterInfo(String desdription, String comid, String vouchertypeid, String periodid) {
        FilterInfo filter = new FilterInfo();
        StringBuffer strMask = new StringBuffer();
        int index = 0;
        filter.getFilterItems().add(new FilterItemInfo("description", (Object)desdription));
        strMask.append("#" + index++ + " ");
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)comid));
        strMask.append(" AND #" + index++ + " ");
        filter.getFilterItems().add(new FilterItemInfo("period.id", (Object)periodid));
        strMask.append(" AND #" + index++ + " ");
        filter.getFilterItems().add(new FilterItemInfo("voucherType.id", (Object)vouchertypeid));
        strMask.append(" AND #" + index++ + " ");
        filter.setMaskString(strMask.toString());
        return filter;
    }

    public static void cleanWsObject(Context ctx, String orgNumber) {
        String orgKey;
        Map orgMap;
        if (wsObject == null || (orgMap = (Map)wsObject.get(orgKey = ctx.getAIS() + orgNumber)) != null) {
            // empty if block
        }
    }

    public static void cleanAllWsObject() {
        if (wsObject != null) {
            wsObject.clear();
        }
    }

    public static FilterInfo getDFilterInfo(String comOrgId, String number, String asstHGAttribute) throws Exception {
        String tableName = null;
        String FIinfoTableName = null;
        String fieldName = null;
        if ("provider".equalsIgnoreCase(asstHGAttribute)) {
            tableName = TABLENAME_SUPPLIER;
            FIinfoTableName = FI_INFO_TABLENAME_SUPPLIER;
            fieldName = FIELDNAME_SUPPLIER;
        } else if ("customer".equalsIgnoreCase(asstHGAttribute)) {
            tableName = TABLENAME_CUSTOMER;
            FIinfoTableName = FI_INFO_TABLENAME_CUSTOMER;
            fieldName = FIELDNAME_CUSTOMER;
        }
        FilterInfo filterInfo = new FilterInfo();
        StringBuffer sql = new StringBuffer();
        sql.append("select FID from ");
        sql.append(tableName);
        sql.append(" where Fnumber = '");
        sql.append(number);
        sql.append("' and Fusedstatus = ");
        sql.append(1);
        sql.append(" and Fid in ");
        sql.append(" ( select ");
        sql.append(fieldName);
        sql.append(" from ");
        sql.append(FIinfoTableName);
        sql.append(" where fusingStatus = ");
        sql.append(0);
        sql.append(" and fcomorgid = '");
        sql.append(comOrgId);
        sql.append("')");
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)sql.toString(), CompareType.INNER));
        return filterInfo;
    }

    public static FilterInfo getDFilterInfoForStandImp(String comOrgId, String number, String asstHGAttribute) throws Exception {
        String tableName = null;
        String FIinfoTableName = null;
        String fieldName = null;
        String maindataId = null;
        if ("provider".equalsIgnoreCase(asstHGAttribute)) {
            tableName = TABLENAME_SUPPLIER;
            FIinfoTableName = FI_INFO_TABLENAME_SUPPLIER;
            fieldName = FIELDNAME_SUPPLIER;
            maindataId = "supplier.id";
        } else if ("customer".equalsIgnoreCase(asstHGAttribute)) {
            tableName = TABLENAME_CUSTOMER;
            FIinfoTableName = FI_INFO_TABLENAME_CUSTOMER;
            fieldName = FIELDNAME_CUSTOMER;
            maindataId = "customer.id";
        }
        FilterInfo filterInfo = new FilterInfo();
        StringBuffer sql = new StringBuffer();
        sql.append("select FID from ");
        sql.append(tableName);
        sql.append(" where Fnumber = '");
        sql.append(number);
        sql.append("' and Fusedstatus = ");
        sql.append(1);
        sql.append("  and Fid in ");
        sql.append(" ( select ");
        sql.append(fieldName);
        sql.append(" from ");
        sql.append(FIinfoTableName);
        sql.append(" where feffectedstatus = ");
        sql.append(2);
        sql.append(" and fusingStatus = ");
        sql.append(0);
        sql.append(" and fcomorgid = '");
        sql.append(comOrgId);
        sql.append("')");
        filterInfo.getFilterItems().add(new FilterItemInfo(maindataId, (Object)sql.toString(), CompareType.INNER));
        return filterInfo;
    }

    public static ProfitCenterOrgUnitInfo findProfitCenterOrgByNumber(Context ctx, String fnumber) throws BOSException {
        if (StringUtil.isEmptyString((String)fnumber)) {
            return null;
        }
        ProfitCenterOrgUnitCollection profitCenterOrgUnitCollection = new ProfitCenterOrgUnitCollection();
        IProfitCenterOrgUnit ProfitCenterOrgUnit = ProfitCenterOrgUnitFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("isbizunit"));
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("number", (Object)fnumber, CompareType.INCLUDE));
        fic.add(new FilterItemInfo("name", (Object)fnumber, CompareType.INCLUDE));
        filter.setMaskString("#0 OR #1");
        profitCenterOrgUnitCollection = ProfitCenterOrgUnit.getProfitCenterOrgUnitCollection(view);
        ProfitCenterOrgUnitInfo profitCenterinfo = null;
        if (profitCenterOrgUnitCollection != null && profitCenterOrgUnitCollection.size() != 0) {
            profitCenterinfo = profitCenterOrgUnitCollection.get(0);
        }
        return profitCenterinfo;
    }

    public static synchronized Object getSynObj(String companyId) {
        Object synObj = synObjs.get(companyId);
        if (synObj == null) {
            synObj = new Object();
            synObjs.put(companyId, synObj);
        }
        return synObj;
    }

    public static Set<String> getRelatedCompanyIds(Set<String> profitCenterIds) throws BOSException {
        HashSet<String> companyIds = new HashSet<String>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("fromUnit.id", profitCenterIds, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("typeRelation.fromType", (Object)6));
        filter.getFilterItems().add(new FilterItemInfo("typeRelation.toType", (Object)1));
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("toUnit.id");
        view.setSelector(selector);
        IOrgUnitRelation iOUR = OrgUnitRelationFactory.getRemoteInstance();
        OrgUnitRelationCollection coll = iOUR.getOrgUnitRelationCollection(view);
        for (int i = 0; i < coll.size(); ++i) {
            companyIds.add(coll.get(i).getToUnit().getId().toString());
        }
        return companyIds;
    }

    public static Set<String> getRelatedCompanyIds(Context ctx, Set<String> profitCenterIds) throws BOSException {
        HashSet<String> companyIds = new HashSet<String>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("fromUnit.id", profitCenterIds, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("typeRelation.fromType", (Object)6));
        filter.getFilterItems().add(new FilterItemInfo("typeRelation.toType", (Object)1));
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("toUnit.id");
        view.setSelector(selector);
        IOrgUnitRelation iOUR = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        OrgUnitRelationCollection coll = iOUR.getOrgUnitRelationCollection(view);
        for (int i = 0; i < coll.size(); ++i) {
            companyIds.add(coll.get(i).getToUnit().getId().toString());
        }
        return companyIds;
    }

    public static boolean isMainRelatedCompany(Context ctx, String profitCenterId, String relatedCompanyId) throws BOSException {
        boolean result = false;
        HashSet<String> companyIds = new HashSet<String>();
        HashSet<String> profitCenterIds = new HashSet<String>();
        profitCenterIds.add(profitCenterId);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("fromUnit.id", profitCenterIds, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("typeRelation.fromType", (Object)6));
        filter.getFilterItems().add(new FilterItemInfo("typeRelation.toType", (Object)1));
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("toUnit.id");
        view.setSelector(selector);
        IOrgUnitRelation iOUR = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        OrgUnitRelationCollection coll = iOUR.getOrgUnitRelationCollection(view);
        for (int i = 0; i < coll.size(); ++i) {
            companyIds.add(coll.get(i).getToUnit().getId().toString());
        }
        if (companyIds.size() != 0 && companyIds.contains(relatedCompanyId)) {
            result = true;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isViceRelatedCompany(Context ctx, String profitCenterId, String relatedCompanyId) {
        boolean result = false;
        HashSet<String> companyIds = new HashSet<String>();
        String sql = "select ffiorgunitid from t_org_fiaccountrange where fprofitorgunitid = ?";
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            ps = conn.prepareStatement(sql);
            ps.setString(1, profitCenterId);
            rs = ps.executeQuery();
            while (rs.next()) {
                String ffiorgunitid = rs.getString("ffiorgunitid");
                companyIds.add(ffiorgunitid);
            }
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)conn);
                throw throwable;
            }
            SQLUtils.cleanup(rs, (Statement)ps, (Connection)conn);
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
        if (companyIds.size() != 0 && companyIds.contains(relatedCompanyId)) {
            result = true;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> getRelatedCompanyIdsAndAccountRange(Context ctx, String profitCenterId) throws BOSException {
        HashSet<String> companyIds = new HashSet<String>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("fromUnit.id", (Object)profitCenterId));
        filter.getFilterItems().add(new FilterItemInfo("typeRelation.fromType", (Object)6));
        filter.getFilterItems().add(new FilterItemInfo("typeRelation.toType", (Object)1));
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("toUnit.id");
        view.setSelector(selector);
        IOrgUnitRelation iOUR = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        OrgUnitRelationCollection coll = iOUR.getOrgUnitRelationCollection(view);
        for (int i = 0; i < coll.size(); ++i) {
            companyIds.add(coll.get(i).getToUnit().getId().toString());
        }
        String sql = "select ffiorgunitid from t_org_fiaccountrange where fprofitorgunitid = ?";
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            ps = conn.prepareStatement(sql);
            ps.setString(1, profitCenterId);
            rs = ps.executeQuery();
            while (rs.next()) {
                String ffiorgunitid = rs.getString("ffiorgunitid");
                companyIds.add(ffiorgunitid);
            }
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)conn);
                throw throwable;
            }
            SQLUtils.cleanup(rs, (Statement)ps, (Connection)conn);
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
        return companyIds;
    }

    public static String getRelatedCompanyIds(Context ctx, String profitCenterId) throws BOSException {
        HashSet<String> idSet = new HashSet<String>();
        idSet.add(profitCenterId);
        Set<String> companyIds = GlWebServiceUtil.getRelatedCompanyIds(ctx, idSet);
        Object companyId = null;
        Iterator<String> it = companyIds.iterator();
        if (it.hasNext()) {
            return it.next();
        }
        return "";
    }

    public static String getProjectIsolateParam(Context ctx) {
        String value = null;
        IParamControl iParam = null;
        try {
            iParam = ctx != null ? ParamControlFactory.getLocalInstance((Context)ctx) : ParamControlFactory.getRemoteInstance();
            value = iParam.getParamValue(null, "ProjectIsolate");
            if (value == null) {
                value = "false";
            }
        }
        catch (BOSException e1) {
            e1.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        return value;
    }

    public static String getRelatedCompanyIds(String profitCenterId) throws BOSException {
        HashSet<String> idSet = new HashSet<String>();
        idSet.add(profitCenterId);
        Set<String> companyIds = GlWebServiceUtil.getRelatedCompanyIds(idSet);
        Object companyId = null;
        Iterator<String> it = companyIds.iterator();
        if (it.hasNext()) {
            return it.next();
        }
        return "";
    }
}

