/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.AccountingCurrencyEnum;
import com.kingdee.eas.basedata.master.account.BalanceDirectionEnum;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGFactory;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.IAssistantHG;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.AssistInitFacadeFactory;
import com.kingdee.eas.fi.gl.GLException;
import com.kingdee.eas.fi.gl.GLFlagFactory;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.GlWebServiceUtil;
import com.kingdee.eas.fi.gl.IGLFlag;
import com.kingdee.eas.fi.gl.InitException;
import com.kingdee.eas.fi.gl.VoucherFacadeFactory;
import com.kingdee.eas.fi.gl.app.InitHelp;
import com.kingdee.eas.fi.gl.cache.VoucherProcessCache;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.LowTimer;
import com.kingdee.util.UuidException;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;

public abstract class InitImportBase
extends AbstractDataTransmission {
    private Map<String, AsstActTypeInfo> asstActTypes = new HashMap<String, AsstActTypeInfo>();
    private Map<String, DataBaseInfo> asstActObjects = new HashMap<String, DataBaseInfo>();
    private Map<String, CurrencyInfo> currencys = new HashMap<String, CurrencyInfo>();

    protected abstract String getType();

    protected BigDecimal getValue(Object data) throws InitException {
        BigDecimal decimal = null;
        try {
            decimal = new BigDecimal(((DataToken)data).data.toString().trim());
        }
        catch (Exception e) {
            throw new InitException(InitException.NUMBER_ERROR);
        }
        return decimal;
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        super.submit(coreBaseInfo, ctx);
    }

    protected boolean constructAssistInfo(Context ctx, AssistantHGInfo assistantHGInfo, String strAsstActTypeName, String strAsstActID, String strAsstName, AsstActTypeCollection arrayAsstActTypeInfo) throws Exception {
        AsstActTypeInfo asstActTypeInfo;
        boolean isAssit = false;
        if (strAsstActTypeName != null && strAsstActTypeName.trim().length() > 0) {
            isAssit = true;
            strAsstActTypeName = strAsstActTypeName.trim();
        }
        if (!StringUtil.isEmptyString((String)strAsstActID)) {
            isAssit = true;
            strAsstActID = strAsstActID.trim();
        }
        if (!StringUtil.isEmptyString((String)strAsstName)) {
            isAssit = true;
            strAsstName = strAsstName.trim();
        }
        if (isAssit && (asstActTypeInfo = this.findAsstActTypeByName(ctx, strAsstActTypeName)) != null) {
            arrayAsstActTypeInfo.add(asstActTypeInfo);
            String asstHGAttribute = asstActTypeInfo.getAsstHGAttribute();
            HashSet<String> set = new HashSet<String>();
            set.add(strAsstActID);
            Map<String, Object> aAsstActNumbers = VoucherProcessCache.findAsstActByNumbers(ctx, asstActTypeInfo, set, ContextUtil.getCurrentFIUnit((Context)ctx), ContextUtil.getCurrentFIUnit((Context)ctx).getCU().getId().toString(), null);
            DataBaseInfo dataInfo = null;
            Object dt = aAsstActNumbers.get(strAsstActID);
            dataInfo = dt instanceof String ? null : (DataBaseInfo)dt;
            if (dataInfo != null) {
                CostCenterOrgUnitInfo info;
                assistantHGInfo.put(asstHGAttribute, (Object)dataInfo);
                if (asstHGAttribute.equals("costOrg") ? (info = (CostCenterOrgUnitInfo)dataInfo) != null && !info.isIsBizUnit() : (asstHGAttribute.equals("adminOrg") ? (info = (AdminOrgUnitInfo)dataInfo) != null && !info.isIsLeaf() : (asstHGAttribute.equals("companyOrg") ? (info = (CompanyOrgUnitInfo)dataInfo) != null && !info.isIsBizUnit() : (asstHGAttribute.equals("saleOrg") ? (info = (SaleOrgUnitInfo)dataInfo) != null && !info.isIsBizUnit() : (asstHGAttribute.equals("purchaseOrg") ? (info = (PurchaseOrgUnitInfo)dataInfo) != null && !info.isIsBizUnit() : (asstHGAttribute.equals("storeageOrg") ? (info = (StorageOrgUnitInfo)dataInfo) != null && !info.isIsBizUnit() : asstHGAttribute.equals("profitOrg") && (info = (ProfitCenterOrgUnitInfo)dataInfo) != null && !info.isIsBizUnit())))))) {
                    throw new Exception(strAsstActTypeName + ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1008_InitImportBase", (Locale)ctx.getLocale()));
                }
            } else {
                throw new Exception(strAsstActTypeName + ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1009_InitImportBase", (Locale)ctx.getLocale()));
            }
        }
        return isAssit;
    }

    public AsstActTypeInfo findAsstActTypeByName(Context ctx, String asstActTypeName) throws BOSException {
        if (asstActTypeName == null || asstActTypeName.trim().length() == 0) {
            return null;
        }
        if (this.asstActTypes.containsKey(asstActTypeName = asstActTypeName.trim())) {
            return this.asstActTypes.get(asstActTypeName);
        }
        AsstActTypeInfo asstActTypeInfo = GlWebServiceUtil.findAsstActtypeNumberByName(ctx, asstActTypeName);
        this.asstActTypes.put(asstActTypeName, asstActTypeInfo);
        return asstActTypeInfo;
    }

    protected boolean CheckString(Object values) {
        boolean check = true;
        if (values != null) {
            String value = String.valueOf(values);
            if (value.length() <= 0) {
                check = false;
            }
        } else {
            check = false;
        }
        return check;
    }

    protected CurrencyInfo getCurrency(Context ctx, Hashtable hsData) throws UuidException, SQLException, Exception {
        String currencyID = ((DataToken)hsData.get((Object)"Fcurrency")).data.toString();
        CurrencyInfo currency = this.doGetCurrency(ctx, currencyID);
        if (currency == null) {
            throw new Exception(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1010_InitImportBase", (Locale)ctx.getLocale()));
        }
        return currency;
    }

    private CurrencyInfo doGetCurrency(Context ctx, String number) throws UuidException, SQLException, Exception {
        if (this.currencys.containsKey(number)) {
            return this.currencys.get(number);
        }
        String sqlToGetCurrency = "select top 1  fid,fprecision  from T_BD_Currency where fnumber=?";
        IRowSet rsToGetCurrency = DbUtil.executeQuery((Context)ctx, (String)sqlToGetCurrency, (Object[])new Object[]{number});
        CurrencyInfo currency = null;
        if (rsToGetCurrency != null && rsToGetCurrency.next()) {
            currency = new CurrencyInfo();
            currency.setId(BOSUuid.read((String)rsToGetCurrency.getString("fid")));
            currency.setPrecision(rsToGetCurrency.getInt("fprecision"));
            currency.setNumber(number);
        }
        this.currencys.put(number, currency);
        return currency;
    }

    protected Object[] getExchangeRate(Context ctx, String orgCurId) throws EASBizException, BOSException {
        CompanyOrgUnitInfo curCompany = InitHelp.getCurrentCompany(ctx, ctx.get((Object)"CurCompanyId").toString());
        CurrencyInfo reportCur = curCompany.getReportCurrency();
        CurrencyInfo localCur = curCompany.getBaseCurrency();
        HashMap<String, Object> otherCtx = new HashMap<String, Object>();
        AccountTableInfo accouttable = curCompany.getAccountTable();
        String cuid = curCompany.getCU().getId().toString();
        otherCtx.put("COMPANY", curCompany);
        otherCtx.put("CUID", cuid);
        otherCtx.put("ACCOUNTTABLEID", accouttable.getId().toString());
        LowTimer low = new LowTimer();
        low.reset();
        ArrayList al = AssistInitFacadeFactory.getLocalInstance(ctx).findInitData(otherCtx);
        int index = 0;
        ++index;
        int n = ++index;
        ++index;
        Boolean b = (Boolean)al.get(n);
        boolean isUsingReport = b;
        int n2 = ++index;
        ++index;
        PeriodInfo startPeriod = (PeriodInfo)al.get(n2);
        Object[] info = new Object[8];
        if (curCompany.getBaseExchangeTable() == null) {
            throw new GLException(GLException.NOLOCALEXTABLE);
        }
        info[0] = curCompany.getBaseExchangeTable().getId().toString();
        info[2] = orgCurId;
        info[3] = localCur.getId().toString();
        if (isUsingReport) {
            info[4] = reportCur.getId().toString();
            info[1] = curCompany.getReportExchangeTable().getId().toString();
        }
        info[6] = startPeriod.getBeginDate();
        info[5] = startPeriod.getBeginDate();
        Object[] exes = VoucherFacadeFactory.getLocalInstance((Context)ctx).fetchExchangeRate(info);
        return exes;
    }

    protected CompanyOrgUnitInfo getCompany(Context ctx, Hashtable hsData) throws UuidException, SQLException, Exception {
        String orgUnitID = ((DataToken)hsData.get((Object)"FOrgUnitID")).data.toString();
        CompanyOrgUnitInfo unitInfo = ContextUtil.getCurrentFIUnit((Context)ctx);
        ICompanyOrgUnit companyOrgUnit = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        ObjectUuidPK pk = new ObjectUuidPK(unitInfo.getId().toString());
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.addObjectCollection((IObjectCollection)GlUtils.getCompanySic());
        unitInfo = companyOrgUnit.getCompanyOrgUnitInfo((IObjectPK)pk, sic);
        if (!unitInfo.getNumber().equals(orgUnitID)) {
            throw new Exception(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1011_InitImportBase", (Locale)ctx.getLocale()));
        }
        return unitInfo;
    }

    protected void isCloseInit(Context ctx, AccountViewInfo account, boolean isCussent) throws Exception, BOSException {
        String cuid = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        HashMap<String, Object> otherCtx = new HashMap<String, Object>();
        CompanyOrgUnitInfo curCompany = ContextUtil.getCurrentFIUnit((Context)ctx);
        String accouttable = curCompany.getAccountTable().getId().toString();
        otherCtx.put("COMPANY", curCompany);
        otherCtx.put("CUID", cuid);
        otherCtx.put("accouttable", accouttable);
        String orgUnitId = ((CompanyOrgUnitInfo)otherCtx.get("COMPANY")).getId().toString();
        IGLFlag flag = GLFlagFactory.getLocalInstance(ctx);
        String[] closedAccount = null;
        closedAccount = isCussent ? flag.getAllCussentInitClosed(orgUnitId) : flag.getAllAstInitClosed(orgUnitId);
        if (closedAccount != null && Arrays.asList(closedAccount).contains(account.getId().toString())) {
            throw new Exception(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1012_InitImportBase", (Locale)ctx.getLocale()));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected AccountViewInfo getAccount(Context ctx, CurrencyInfo currency, Hashtable hsData, boolean isCussent) throws Exception, SQLException {
        AccountViewInfo account = new AccountViewInfo();
        String accountID = ((DataToken)hsData.get((Object)"FAccountID")).data.toString();
        String type = this.getType();
        if ("InitAccountBalance".equals(this.getType())) {
            String sqlToGetAccount = "select top 1 fid,fcaa,fac,facctcurrency,fisQty,flongnumber from T_BD_ACCOUNTVIEW where fisleaf=1 and fcaa is null and fnumber=? and Fcompanyid=? and faccounttableid=?";
            IRowSet rsToGetAccount = DbUtil.executeQuery((Context)ctx, (String)sqlToGetAccount, (Object[])new Object[]{accountID, ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString(), ContextUtil.getCurrentFIUnit((Context)ctx).getAccountTable().getId().toString()});
            if (rsToGetAccount == null || !rsToGetAccount.next()) throw new Exception(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1014_InitImportBase", (Locale)ctx.getLocale()));
            if (rsToGetAccount.getInt("facctcurrency") == 0 && !currency.getId().equals((Object)ContextUtil.getCurrentFIUnit((Context)ctx).getBaseCurrency().getId())) {
                throw new Exception(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1013_InitImportBase", (Locale)ctx.getLocale()));
            }
            account.setId(BOSUuid.read((String)rsToGetAccount.getString("fid")));
            account.setAC(rsToGetAccount.getBoolean("fac"));
            account.setIsQty(rsToGetAccount.getBoolean("fisQty"));
            account.setLongNumber(rsToGetAccount.getString("flongnumber"));
            account.setNumber(accountID);
            account.setAccountingcurrency(AccountingCurrencyEnum.getEnum((int)rsToGetAccount.getInt("facctcurrency")));
            this.isCloseInit(ctx, account, isCussent);
            return account;
        } else {
            String sqlToGetAccount = "select top 1 fid,fcaa,fac,facctcurrency,fisQty,fiscfreeze ,fdc from T_BD_ACCOUNTVIEW where fisleaf=1 and fcaa is not null and fnumber=? and Fcompanyid=? and faccounttableid=?";
            IRowSet rsToGetAccount = DbUtil.executeQuery((Context)ctx, (String)sqlToGetAccount, (Object[])new Object[]{accountID, ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString(), ContextUtil.getCurrentFIUnit((Context)ctx).getAccountTable().getId().toString()});
            if (rsToGetAccount == null || !rsToGetAccount.next()) throw new Exception(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1015_InitImportBase", (Locale)ctx.getLocale()));
            if (rsToGetAccount.getInt("facctcurrency") == 0 && !currency.getId().equals((Object)ContextUtil.getCurrentFIUnit((Context)ctx).getBaseCurrency().getId())) {
                throw new Exception(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1013_InitImportBase", (Locale)ctx.getLocale()));
            }
            account.setId(BOSUuid.read((String)rsToGetAccount.getString("fid")));
            AsstAccountInfo caa = new AsstAccountInfo();
            caa.setId(BOSUuid.read((String)rsToGetAccount.getString("fcaa")));
            account.setCAA(caa);
            account.setAC(rsToGetAccount.getBoolean("fac"));
            account.setIsQty(rsToGetAccount.getBoolean("fisQty"));
            account.setNumber(accountID);
            account.setIsCFreeze(rsToGetAccount.getBoolean("fiscFreeze"));
            account.setAccountingcurrency(AccountingCurrencyEnum.getEnum((int)rsToGetAccount.getInt("facctcurrency")));
            int dc = rsToGetAccount.getInt("fdc");
            account.setDC(dc == 1 ? BalanceDirectionEnum.DEBIT : BalanceDirectionEnum.CREDIT);
            this.isCloseInit(ctx, account, isCussent);
        }
        return account;
    }

    protected AssistantHGInfo getAssistantHGInfo(Context ctx, Hashtable hsData, String fAsstid) throws Exception {
        String name = "FName_" + LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        String sqltoacctaccount = "select c." + name + " Fname from T_BD_AsstAccount a  inner join T_BD_AsstActGroupDetail b on a.fid=b.fasstaccountid  inner join  t_bd_asstacttype c on b.fasstacttypeid=c.fid where a.FID=? order by b.fseq";
        IRowSet rsToGetAcctname = DbUtil.executeQuery((Context)ctx, (String)sqltoacctaccount, (Object[])new Object[]{fAsstid});
        int siz = rsToGetAcctname.size();
        String[] asstactTypeName = new String[siz];
        String[] asstactTypeNumber = new String[siz];
        String[] asstactType = new String[siz];
        for (int iop = 0; iop < siz; ++iop) {
            rsToGetAcctname.next();
            asstactType[iop] = rsToGetAcctname.getString("Fname");
        }
        for (int i = 0; i < siz; ++i) {
            for (int ii = 0; ii < 7; ++ii) {
                String Fitem = ((DataToken)hsData.get((Object)new StringBuilder().append((String)"Fitem_").append((String)String.valueOf((int)(ii + 1))).toString())).data.toString();
                if (!Fitem.equals(asstactType[i]) || ((DataToken)hsData.get((Object)new StringBuilder().append((String)"Fnumber_").append((String)String.valueOf((int)(ii + 1))).toString())).data == null || ((DataToken)hsData.get((Object)new StringBuilder().append((String)"Fname_").append((String)String.valueOf((int)(ii + 1))).toString())).data == null) continue;
                asstactTypeNumber[i] = ((DataToken)hsData.get((Object)new StringBuilder().append((String)"Fnumber_").append((String)String.valueOf((int)(ii + 1))).toString())).data.toString();
                asstactTypeName[i] = ((DataToken)hsData.get((Object)new StringBuilder().append((String)"Fname_").append((String)String.valueOf((int)(ii + 1))).toString())).data.toString();
                break;
            }
            if (asstactTypeNumber[i] != null) continue;
            throw new Exception(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1016_InitImportBase", (Locale)ctx.getLocale()) + (i + 1) + ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1017_InitImportBase", (Locale)ctx.getLocale()));
        }
        AssistantHGInfo assistantHGInfo = new AssistantHGInfo();
        AsstActTypeCollection arrayAsstActTypeInfo = new AsstActTypeCollection();
        int count = asstactTypeName.length;
        for (int i = 0; i < count; ++i) {
            this.constructAssistInfo(ctx, assistantHGInfo, asstactType[i], asstactTypeNumber[i], asstactTypeName[i], arrayAsstActTypeInfo);
        }
        IAssistantHG igCtrl = AssistantHGFactory.getLocalInstance((Context)ctx);
        AssistantHGInfo actualAssistantHGInfo = igCtrl.getAssistantHG(assistantHGInfo, fAsstid, arrayAsstActTypeInfo);
        return actualAssistantHGInfo;
    }

    protected MeasureUnitInfo getMeasureUnit(Context ctx, String fmeasureunitgroupid, Hashtable hsData) throws UuidException, SQLException, Exception {
        MeasureUnitInfo minfo = null;
        if (this.CheckString(((DataToken)hsData.get((Object)"MeasureUnit")).data)) {
            IRowSet rsMeasureUnit;
            String MeasureUnit = ((DataToken)hsData.get((Object)"MeasureUnit")).data.toString();
            String sqlMeasureUnit = "select top 1  fid,fCoefficient  from T_BD_MeasureUnit  where fnumber=? ";
            if (fmeasureunitgroupid != null) {
                sqlMeasureUnit = sqlMeasureUnit + " and fgroupid=?";
                rsMeasureUnit = DbUtil.executeQuery((Context)ctx, (String)sqlMeasureUnit, (Object[])new Object[]{MeasureUnit, fmeasureunitgroupid});
            } else {
                rsMeasureUnit = DbUtil.executeQuery((Context)ctx, (String)sqlMeasureUnit, (Object[])new Object[]{MeasureUnit});
            }
            if (rsMeasureUnit != null && rsMeasureUnit.next()) {
                minfo = new MeasureUnitInfo();
                minfo.setId(BOSUuid.read((String)rsMeasureUnit.getString("fid")));
                minfo.setCoefficient(rsMeasureUnit.getBigDecimal("fCoefficient"));
            } else {
                throw new Exception(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1018_InitImportBase", (Locale)ctx.getLocale()));
            }
        }
        return minfo;
    }

    protected DataBaseInfo findAsstActObject(Context ctx, String asstHGAttribute, AssistantHGInfo assistantHGInfo, String strAsstActTypeName, String strAsstActID, String strAsstName, AsstActTypeCollection arrayAsstActTypeInfo) throws BOSException {
        return this.findAsstActObject(ctx, asstHGAttribute, strAsstActID, strAsstName, ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString(), ContextUtil.getCurrentFIUnit((Context)ctx));
    }

    protected DataBaseInfo findAsstActObject(Context ctx, String asstHGAttribute, AssistantHGInfo assistantHGInfo, String strAsstActTypeName, String strAsstActID, String strAsstName, AsstActTypeCollection arrayAsstActTypeInfo, String cuId, CompanyOrgUnitInfo company) throws BOSException {
        return this.findAsstActObject(ctx, asstHGAttribute, strAsstActID, strAsstName, cuId, company);
    }

    private DataBaseInfo findAsstActObject(Context ctx, String asstHGAttribute, String number, String name, String cuid, CompanyOrgUnitInfo company) throws BOSException {
        String key = asstHGAttribute + "_" + cuid + "_";
        key = key + (company == null ? "nocompany" : company.getId().toString()) + "_";
        if (this.asstActObjects.containsKey(key = key + number)) {
            return this.asstActObjects.get(key);
        }
        DataBaseInfo info = GlWebServiceUtil.findAsstActObject(ctx, asstHGAttribute, number, name, cuid, company);
        this.asstActObjects.put(key, info);
        return info;
    }
}

