/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.fi.gl.common.SimpleCompanyUserObject;
import com.kingdee.eas.framework.report.util.RptConditionManager;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class ReportConditionBase
implements Serializable,
Cloneable {
    public static final String KEY = "GLFixCondition";
    public static final String ALL_CURRENCY = "AllCurrency";
    public static final String ALL_CURRENCY_COLUMNAR = "AllCurrencyColumnar";
    private String accountCodeStart = null;
    private String accountCodeEnd = null;
    private Object accountViewStart = null;
    private Object accountViewEnd = null;
    private int accountLevelStart = -1;
    private int accountLevelEnd = -1;
    protected Set<String> accountIdSet;
    private int periodYearStart = -1;
    private int periodYearEnd = -1;
    private int periodNumberStart = -1;
    private int periodNumberEnd = -1;
    private String currencyID = null;
    private String currencyName = null;
    private DefaultKingdeeTreeNode selectAccountNode = null;
    private String accountId = null;
    private String companyId = null;
    private String profitCenterId = null;
    private boolean optionPosting = false;
    private boolean newQuery;
    private int expandCompanyLevel = -1;
    private boolean isExplandAllChildCom = false;
    private Object treeModelOfCompany = null;
    private Object treeModelOfProfitCenter = null;
    private SimpleCompanyUserObject virtureCompany = null;
    private Map expandInfo = null;
    private boolean canJoinQueryOther = true;
    private static final String EXPAND_INFO_KEY = "com.kingdee.eas.fi.gl.ReportConditionBase#EXPAND_INFO_KEY";

    public boolean isExplandAllChildCom() {
        return this.isExplandAllChildCom;
    }

    public void setExplandAllChildCom(boolean isExplandAllChildCom) {
        this.isExplandAllChildCom = isExplandAllChildCom;
    }

    public Map getExpandInfo() {
        if (this.expandInfo == null) {
            this.expandInfo = new HashMap();
        }
        return this.expandInfo;
    }

    public void setExpandInfo(Map expandInfo) {
        this.expandInfo = expandInfo;
    }

    public String getAccountCodeStart() {
        return this.accountCodeStart;
    }

    public void setAccountCodeStart(String accountCode) {
        this.accountCodeStart = accountCode;
    }

    public boolean isInputCodeStart() {
        return this.accountCodeStart != null && this.accountCodeStart.length() > 0;
    }

    public boolean isInputMultiCodeStart() {
        if (this.accountCodeStart == null) {
            return false;
        }
        return this.accountCodeStart.indexOf(44) > 0;
    }

    public String getAccountCodeEnd() {
        return this.accountCodeEnd;
    }

    public void setAccountCodeEnd(String accountCode) {
        this.accountCodeEnd = accountCode;
    }

    public boolean isInputCodeEnd() {
        return this.accountCodeEnd != null && this.accountCodeEnd.length() > 0;
    }

    public boolean isInputMultiCodeEnd() {
        if (this.accountCodeEnd == null) {
            return false;
        }
        return this.accountCodeEnd.indexOf(44) > 0;
    }

    public int getAccountLevelStart() {
        return this.accountLevelStart;
    }

    public void setAccountLevelStart(int level) {
        this.accountLevelStart = level;
    }

    public int getAccountLevelEnd() {
        return this.accountLevelEnd;
    }

    public void setAccountLevelEnd(int level) {
        this.accountLevelEnd = level;
    }

    public Set<String> getAccountIdSet() {
        if (this.accountIdSet == null) {
            this.accountIdSet = new HashSet<String>();
        }
        return this.accountIdSet;
    }

    public void setAccountIdSet(Set<String> accountIdSet) {
        this.accountIdSet = accountIdSet;
    }

    public int getPeriodYearStart() {
        return this.periodYearStart;
    }

    public void setPeriodYearStart(int periodYear) {
        this.periodYearStart = periodYear;
    }

    public int getPeriodYearEnd() {
        return this.periodYearEnd;
    }

    public void setPeriodYearEnd(int periodYear) {
        this.periodYearEnd = periodYear;
    }

    public int getPeriodNumberStart() {
        return this.periodNumberStart;
    }

    public void setPeriodNumberStart(int periodNumber) {
        this.periodNumberStart = periodNumber;
    }

    public int getPeriodNumberEnd() {
        return this.periodNumberEnd;
    }

    public void setPeriodNumberEnd(int periodNumber) {
        this.periodNumberEnd = periodNumber;
    }

    public String getCurrencyID() {
        return this.currencyID;
    }

    public void setCurrencyID(String id) {
        this.currencyID = id;
    }

    public boolean getOptionPosting() {
        return this.optionPosting;
    }

    public void setOptionPosting(boolean option) {
        this.optionPosting = option;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean isAllCurrency() {
        return ALL_CURRENCY.equals(this.currencyID);
    }

    public boolean isGeneralLocalCurrency() {
        return CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString().equals(this.currencyID);
    }

    public boolean isGeneralReportCurrency() {
        return CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString().equals(this.currencyID);
    }

    public boolean isAllCurrencyColumnar() {
        return ALL_CURRENCY_COLUMNAR.equals(this.currencyID);
    }

    public Map toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(this.getClass().getName(), this.getClass().getName());
        map.put("PeriodYearStart", new Integer(this.getPeriodYearStart()));
        map.put("PeriodYearEnd", new Integer(this.getPeriodYearEnd()));
        map.put("PeriodNumberStart", new Integer(this.getPeriodNumberStart()));
        map.put("PeriodNumberEnd", new Integer(this.getPeriodNumberEnd()));
        map.put("AccountCodeStart", this.getAccountCodeStart());
        map.put("AccountCodeEnd", this.getAccountCodeEnd());
        map.put("AccountViewStart", this.getAccountViewStart());
        map.put("AccountViewEnd", this.getAccountViewEnd());
        map.put("AccountLevelStart", new Integer(this.getAccountLevelStart()));
        map.put("AccountLevelEnd", new Integer(this.getAccountLevelEnd()));
        map.put("AccountID", this.getAccountId());
        map.put("CurrencyID", this.getCurrencyID());
        map.put("CurrencyName", this.getCurrencyName());
        map.put("OptionPosting", this.getOptionPosting());
        map.put("canJoinQueryOther", this.canJoinQueryOther);
        map.put("ExpandCompanyLevel", new Integer(this.getExpandCompanyLevel()));
        if (this.treeModelOfCompany != null) {
            map.put("treeModelOfCompany", this.treeModelOfCompany);
        }
        if (this.treeModelOfProfitCenter != null) {
            map.put("treeModelOfProfitCenter", this.treeModelOfProfitCenter);
        }
        map.put(EXPAND_INFO_KEY, this.expandInfo);
        return map;
    }

    protected boolean isOldQuerySolution(Map cond) {
        return cond.get("jspYearFrom") != null && cond.get("jspYearFrom") instanceof RptConditionManager.ComponentStatus;
    }

    protected Map getNewToOldKeyMap() {
        return new HashMap();
    }

    public ReportConditionBase(Map map) throws CloneNotSupportedException {
        if (map == null) {
            return;
        }
        if (this.isOldQuerySolution(map)) {
            AccountViewInfo ac;
            Object obj = null;
            if (map.get("jspYearFrom") != null) {
                obj = ((RptConditionManager.ComponentStatus)map.get("jspYearFrom")).getValue();
                this.setPeriodYearStart(Integer.parseInt(obj.toString()));
            }
            if (map.get("jspYearTo") != null) {
                obj = ((RptConditionManager.ComponentStatus)map.get("jspYearTo")).getValue();
                this.setPeriodYearEnd(Integer.parseInt(obj.toString()));
            }
            if (map.get("jspPeriodFrom") != null) {
                obj = ((RptConditionManager.ComponentStatus)map.get("jspPeriodFrom")).getValue();
                this.setPeriodNumberStart(Integer.parseInt(obj.toString()));
            }
            if (map.get("jspPeriodTo") != null) {
                obj = ((RptConditionManager.ComponentStatus)map.get("jspPeriodTo")).getValue();
                this.setPeriodNumberEnd(Integer.parseInt(obj.toString()));
            }
            if (map.get("jebAccountFrom") != null) {
                obj = ((RptConditionManager.ComponentStatus)map.get("jebAccountFrom")).getValue();
                this.setAccountViewStart(obj);
                if (obj instanceof Object[]) {
                    ac = (AccountViewInfo)((Object[])obj)[0];
                    if (ac != null) {
                        this.setAccountCodeStart(ac.getNumber());
                    }
                } else {
                    ac = (AccountViewInfo)obj;
                    if (ac != null) {
                        this.setAccountCodeStart(ac.getNumber());
                    }
                }
            }
            if (map.get("jebAccountTo") != null) {
                obj = ((RptConditionManager.ComponentStatus)map.get("jebAccountTo")).getValue();
                this.setAccountViewEnd(obj);
                if (obj instanceof Object[]) {
                    ac = (AccountViewInfo)((Object[])obj)[0];
                    if (ac != null) {
                        this.setAccountCodeEnd(ac.getNumber());
                    }
                } else {
                    ac = (AccountViewInfo)obj;
                    if (ac != null) {
                        this.setAccountCodeEnd(ac.getNumber());
                    }
                }
            }
            if (map.get("jbxCurrency") != null) {
                obj = ((RptConditionManager.ComponentStatus)map.get("jbxCurrency")).getValue();
                CurrencyInfo currency = null;
                if (obj instanceof CurrencyInfo) {
                    currency = (CurrencyInfo)obj;
                } else if (obj instanceof String && obj.toString().length() > 0) {
                    try {
                        EntityViewInfo view = new EntityViewInfo();
                        FilterInfo filter = new FilterInfo();
                        FilterItemCollection fi = filter.getFilterItems();
                        if (obj.toString().length() > 12) {
                            fi.add(new FilterItemInfo("id", (Object)obj.toString(), CompareType.EQUALS));
                        } else {
                            fi.add(new FilterItemInfo("name", (Object)obj.toString(), CompareType.LIKE));
                        }
                        view.setFilter(filter);
                        CurrencyCollection currencys = CurrencyFactory.getRemoteInstance().getCurrencyCollection(view);
                        if (currencys != null && currencys.size() > 0) {
                            currency = currencys.get(0);
                        }
                    }
                    catch (BOSException e) {
                        e.printStackTrace();
                    }
                }
                if (currency != null) {
                    this.setCurrencyID(currency.getId().toString());
                    this.setCurrencyName(currency.getName());
                }
            }
            if (map.get("jspLevelFrom") != null) {
                obj = ((RptConditionManager.ComponentStatus)map.get("jspLevelFrom")).getValue();
                this.setAccountLevelStart(Integer.parseInt(obj.toString()));
            }
            if (map.get("jspLevelTo") != null) {
                obj = ((RptConditionManager.ComponentStatus)map.get("jspLevelTo")).getValue();
                this.setAccountLevelEnd(Integer.parseInt(obj.toString()));
            }
            if (map.get("jcbIncludeUnPost") != null) {
                obj = ((RptConditionManager.ComponentStatus)map.get("jcbIncludeUnPost")).getValue();
                this.setOptionPosting(Boolean.parseBoolean(obj.toString()));
            }
            this.treeModelOfCompany = map.get("companyTreeNode");
            if (map.get("spCompanyLevel") != null) {
                Integer ExpandCompanyLevel = (Integer)((RptConditionManager.ComponentStatus)map.get("spCompanyLevel")).getValue();
                this.setExpandCompanyLevel(this.getInt(ExpandCompanyLevel));
            }
        } else {
            this.setPeriodYearStart(this.getInt((Integer)map.get("PeriodYearStart")));
            this.setPeriodYearEnd(this.getInt((Integer)map.get("PeriodYearEnd")));
            this.setPeriodNumberStart(this.getInt((Integer)map.get("PeriodNumberStart")));
            this.setPeriodNumberEnd(this.getInt((Integer)map.get("PeriodNumberEnd")));
            this.setAccountCodeStart((String)map.get("AccountCodeStart"));
            String accountCode = (String)map.get("AccountCodeEnd");
            this.setAccountCodeEnd(accountCode);
            this.setAccountViewStart(map.get("AccountViewStart"));
            this.setAccountViewEnd(map.get("AccountViewEnd"));
            this.setAccountLevelStart(this.getInt((Integer)map.get("AccountLevelStart")));
            this.setAccountLevelEnd(this.getInt((Integer)map.get("AccountLevelEnd")));
            this.setCurrencyID((String)map.get("CurrencyID"));
            this.setCurrencyName((String)map.get("CurrencyName"));
            this.setAccountId((String)map.get("AccountID"));
            this.expandInfo = (Map)map.get(EXPAND_INFO_KEY);
            this.setOptionPosting(this.getBoolean((Boolean)map.get("OptionPosting")));
            this.treeModelOfCompany = map.get("treeModelOfCompany");
            if (map.get("treeModelOfProfitCenter") != null) {
                this.treeModelOfProfitCenter = map.get("treeModelOfProfitCenter");
            }
            this.setExpandCompanyLevel(this.getInt((Integer)map.get("ExpandCompanyLevel")));
            if (map.containsKey("canJoinQueryOther")) {
                this.setCanJoinQueryOther(this.getBoolean((Boolean)map.get("canJoinQueryOther")));
            }
        }
    }

    public ReportConditionBase(ReportConditionBase base) {
        this.setExpandCompanyLevel(base.getExpandCompanyLevel());
        this.setPeriodYearStart(base.getPeriodYearStart());
        this.setPeriodYearEnd(base.getPeriodYearEnd());
        this.setPeriodNumberStart(base.getPeriodNumberStart());
        this.setPeriodNumberEnd(base.getPeriodNumberEnd());
        this.setAccountCodeStart(base.getAccountCodeStart());
        this.setAccountCodeEnd(base.getAccountCodeEnd());
        this.setAccountIdSet(base.getAccountIdSet());
        this.setAccountLevelStart(base.getAccountLevelStart());
        this.setAccountLevelEnd(base.getAccountLevelEnd());
        this.setCurrencyID(base.getCurrencyID());
        this.setOptionPosting(base.getOptionPosting());
        this.setAccountId(base.getAccountId());
        this.setCurrencyName(base.getCurrencyName());
        this.setExpandInfo(base.getExpandInfo());
        this.setCanJoinQueryOther(base.isCanJoinQueryOther());
    }

    public ReportConditionBase() {
    }

    protected boolean getBoolean(Boolean value) {
        return value == null ? false : value;
    }

    protected int getInt(Integer value) {
        return value == null ? 0 : value;
    }

    public String getCurrencyName() {
        return this.currencyName;
    }

    public void setCurrencyName(String string) {
        this.currencyName = string;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String string) {
        this.accountId = string;
    }

    public Object getTreeModelOfCompany() {
        return this.treeModelOfCompany;
    }

    public void setTreeModelOfCompany(Object object) {
        this.treeModelOfCompany = object;
    }

    public Object getTreeModelOfProfitCenter() {
        return this.treeModelOfProfitCenter;
    }

    public void setTreeModelOfProfitCenter(Object treeModelOfProfitCenter) {
        this.treeModelOfProfitCenter = treeModelOfProfitCenter;
    }

    public SimpleCompanyUserObject getVirtureCompany() {
        return this.virtureCompany;
    }

    public void setVirtureCompany(SimpleCompanyUserObject info) {
        this.virtureCompany = info;
    }

    public boolean isNewQuery() {
        return this.newQuery;
    }

    public void setNewQuery(boolean b) {
        this.newQuery = b;
    }

    public String getCompanyId() {
        return this.companyId;
    }

    public void setCompanyId(String string) {
        this.companyId = string;
    }

    public String getProfitCenterId() {
        return this.profitCenterId;
    }

    public void setProfitCenterId(String profitCenterId) {
        this.profitCenterId = profitCenterId;
    }

    public DefaultKingdeeTreeNode getSelectAccountNode() {
        return this.selectAccountNode;
    }

    public void setSelectAccountNode(DefaultKingdeeTreeNode selectAccountNode) {
        this.selectAccountNode = selectAccountNode;
    }

    public boolean isCanJoinQueryOther() {
        return this.canJoinQueryOther;
    }

    public void setCanJoinQueryOther(boolean canJoinQueryOther) {
        this.canJoinQueryOther = canJoinQueryOther;
    }

    public Object getAccountViewStart() {
        return this.accountViewStart;
    }

    public void setAccountViewStart(Object accountViewStart) {
        this.accountViewStart = accountViewStart;
    }

    public Object getAccountViewEnd() {
        return this.accountViewEnd;
    }

    public void setAccountViewEnd(Object accountViewEnd) {
        this.accountViewEnd = accountViewEnd;
    }

    public int getExpandCompanyLevel() {
        return this.expandCompanyLevel;
    }

    public void setExpandCompanyLevel(int expandCompanyLevel) {
        this.expandCompanyLevel = expandCompanyLevel;
    }
}

